function [Ishift]=shiftcalc(delta,cv)

%********************************************************************
%
% shiftcalc, by J.M. Daz-Cruz, May 2006, Last revised October 2007
%
% For a single spectra shifts the signal of one or more components 
% according to delta (in normalized number of columns units)
%
% cv is the column-wise matrix obtained as [isshift;c(1 spectra);es],
% where isshift is a vector in the form [1,0.1,...] denoting with '1' 
% the components to be moved, c is the concentration of all components 
% for the given spectra and es is the initial estimate of unit 
% voltammograms
%
% Syntax:   [Ishift]=shiftcalc(delta,cv);
%
%*********************************************************************


[nexp,ncomp]=size(delta);
[nr,nc]=size(cv);
npot=nr-2;
isshift=cv(1,:);c=cv(2,:);v=cv(3:nr,:);

Iold=c*v';

%variable x: normalized number of column

x(1,:)=0;
for i=1:(npot-1); x=[x;i/(npot-1)]; end


	for j=1:ncomp,
		xshift=x-delta(1,j);
		if delta(1,j)~=0 & isshift(1,j)==1, vshift(:,j)=spline(x,v(:,j),xshift);
		else vshift(:,j)=v(:,j);
		end
	end

Ishift=c*vshift';


      