%%% Example 1: Simple backtracking run (Hynne model and Yeast 7)
clear all, close all, clc
initCobraToolbox
changeCobraSolver('glpk');
% add all backtracking functions to the searchpath
addpath([cd '/bktr_functions']);

%% Load  models
% GSM
load('GSModels/Yeast/Y7_filled.mat','Y7');
GSM=Y7;

% DynM
load('DynModels/Hynne_model.mat','DM');

% Map
load('DynModels/maps.mat','mapHynne');


%% Map models
% map = bktr_mapping(GSM,DM); % to ry out the mapping
map = mapHynne; % to use supplied map directly

%% Define Target
scale = 1000; %scaling parameter (to avoid )
IdxTargetMet = 339; %can either be met or rxn (idx in GSM)
IdxTargetRxn = 0;
[GSM, BioRxnIdx]= bktr_Target(GSM,IdxTargetMet,IdxTargetRxn,scale);

%% Prepare model and run backtracking
[GSM_prep,irrevGSM,matchRev, map_prep] = bktr_prep_Lump(GSM,DM,map,BioRxnIdx);% prepare model

[Leaks, AddUptakes,waste] = bktr_Run(irrevGSM,GSM_prep,matchRev,map_prep,scale);% Run FBA and calculate leaks
    
     
%% Plot results
bktr_barPlot(Leaks,map.DMets,'Leaks Hynne Model')
disp(table(map.DMets,Leaks,'VariableNames', {'DynMets','Leaks'}))

%% Add leak reaction to DDM and export to SBML
DM = bktr_AddLeakRxn(DM,Leaks,'Biomass',waste);
bktr_Export(DM,'/DynModels/Hynne2001/Hynne_newLeaks')
