%%% Example 2: Dissection of production of different biomass components

%% Initialize
clear all
close all
initCobraToolbox
changeCobraSolver('glpk');

% add all backtracking functions to the searchpath
addpath([cd '/bktr_functions']);

%% Load translated models
% GSM
load('GSModels/Yeast/Y7_filled.mat','Y7');
GSM = bktr_addY7LumpedBiomassComponents(Y7);%% Add lumped biomass components

% DM
load('DynModels/Hynne_model.mat','DM');

% Map
load('DynModels/maps.mat','mapHynne');
map = bktr_mapping(GSM,DM, mapHynne); % display map

%% Set medium (glucose only)
idxMedium = (findExcRxns(GSM))& GSM.lb<0;[a,~]=find(GSM.S(:,idxMedium));
disp(table(GSM.rxns(idxMedium),printRxnFormula(GSM, GSM.rxns(idxMedium),0,1,1), GSM.lb(idxMedium), GSM.ub(idxMedium),(bktr_nAtoms(GSM,a,'C'))',...
    'VariableNames',{'Rxn','ReactionFormula', 'lb','ub','nC'}))


GSM_unmodified=changeRxnBounds(GSM,'r_1714',-10,'l');



%% Define Targets
targets=[2222 2223 2224 2221 883 1180 588 2 339];%339 biomass
scale = 1000;
IdxTargetRxn = 0;

%% Run Backtracking for all biomass components
for k= 1: length(targets)

    IdxTargetMet = targets(k);

    [GSM, BioRxnIdx]= bktr_Target(GSM_unmodified,IdxTargetMet,IdxTargetRxn,scale);

    [GSM,irrevGSM,matchRev, map_lump] = bktr_prep_Lump(GSM,DM,map,BioRxnIdx);% prepare model
  
    [Leaks(:,k), AddUptakes{k}] = bktr_Run(irrevGSM,GSM,matchRev,map_lump,scale);   % Run FBA and Calculate Leaks

end


%% Plot results
% biomass only
bktr_barPlot(Leaks(:,end),DM.mets, 'Biomass')
set(gcf,'Position', [1456          84         464        1089])

% close all
% Bar Plot
bktr_barPlot(Leaks(:,1:end-1),DM.mets, GSM.metNames(targets(1:end-1)))
set(gcf,'Position',[896          86         560        1087])


%Distribution Figure
Leaks_plot= Leaks(:,1:end-1); %no biomass total in plots
figure
selected=[1 2 4  6:9 11 13:15]; % order according to steps in glycolysis 
selected=[4  6:9 11 13:16 18 21]; % order according to steps in glycolysis
Leaks_plot=Leaks_plot(selected,:);
Leaks_plot(Leaks_plot>0)=0; % only depleting fluxes in distribution figure

nC=bktr_nAtoms(GSM,[map.GSMMets{(selected)}],'C'); % number of carbon atoms in each precursor
percBiomass   =[0.012   0.219   0.0536  3.685   0.81    0.02    0.52    1.14]; %mmol/gDW

Leaks_plot= Leaks_plot.*repmat(nC(:),1,length(targets(1:end-1)));% weigh with carbon atoms
Leaks_plot= Leaks_plot.*repmat(percBiomass,length(DM.mets(selected)),1);% weigh with biomass molar contribution

bktr_DistributionFigure(-Leaks_plot, DM.mets(selected), GSM.metNames(targets(1:end-1)))
set(gcf,'Position',[2   635   892   538])


%% additional uptakes
figure
AddPlot=zeros(length(targets),4);
for k= 1: length(targets)
    [a,b]=ismember({'carbon dioxide exchange','oxygen exchange','ammonium exchange','D-glucose exchange'}, table2cell(AddUptakes{k}(:,1)));
    AddPlot(k,a) =AddUptakes{k}{b(a),2}; 
end
AddPlot= AddPlot.*repmat([percBiomass 1]',1,4);% weigh with biomass %

barh(1:4,[(AddPlot(1:end-1,:)); ]','stacked', 'EdgeColor','none')
set(gca, 'ytick', 1:4,'yticklabel',{'carbon dioxide exchange','oxygen exchange','ammonium exchange','D-glucose exchange'})
legend(GSM.metNames(targets(1:end-1)) )
set(gcf,'Position',[436   145   456   411])
colormap(gca,[0.200000002980232,0.200000002980232,0.200000002980232;0.236519604921341,0.246568635106087,0.250000000000000;0.273039221763611,0.293137252330780,0.300000011920929;0.309558838605881,0.339705884456635,0.349999994039536;0.346078425645828,0.386274516582489,0.400000005960465;0.382598042488098,0.432843148708344,0.449999988079071;0.419117659330368,0.479411780834198,0.500000000000000;0.455637276172638,0.525980412960053,0.550000011920929;0.492156863212585,0.572549045085907,0.600000023841858;0.528676450252533,0.619117677211762,0.649999976158142;0.565196096897125,0.665686249732971,0.699999988079071;0.601715683937073,0.712254881858826,0.750000000000000;0.638235330581665,0.758823513984680,0.800000011920929;0.674754917621613,0.805392146110535,0.850000023841858;0.711274504661560,0.851960778236389,0.899999976158142;0.747794151306152,0.898529410362244,0.949999988079071;0.784313738346100,0.945098042488098,1;0.749542474746704,0.916862726211548,0.974117636680603;0.714771270751953,0.888627469539642,0.948235273361206;0.680000007152557,0.860392153263092,0.922352969646454;0.645228743553162,0.832156896591187,0.896470606327057;0.610457539558411,0.803921580314636,0.870588243007660;0.575686275959015,0.775686264038086,0.844705879688263;0.540915071964264,0.747451007366180,0.818823516368866;0.506143808364868,0.719215691089630,0.792941212654114;0.471372574567795,0.690980434417725,0.767058849334717;0.436601310968399,0.662745118141174,0.741176486015320;0.401830077171326,0.634509801864624,0.715294122695923;0.367058843374252,0.606274545192719,0.689411759376526;0.332287609577179,0.578039228916168,0.663529455661774;0.297516345977783,0.549803972244263,0.637647092342377;0.262745112180710,0.521568655967712,0.611764729022980;0.257777780294418,0.507450997829437,0.605751633644104;0.252810478210449,0.493333369493485,0.599738597869873;0.247843146324158,0.479215711355209,0.593725502490997;0.242875829339027,0.465098053216934,0.587712466716766;0.237908512353897,0.450980424880981,0.581699371337891;0.232941180467606,0.436862766742706,0.575686275959015;0.227973863482475,0.422745108604431,0.569673240184784;0.223006546497345,0.408627480268478,0.563660144805908;0.218039229512215,0.394509822130203,0.557647109031677;0.213071897625923,0.380392163991928,0.551634013652802;0.208104580640793,0.366274535655975,0.545620918273926;0.203137263655663,0.352156877517700,0.539607882499695;0.198169946670532,0.338039219379425,0.533594787120819;0.193202614784241,0.323921591043472,0.527581751346588;0.188235297799110,0.309803932905197,0.521568655967712;0.184313729405403,0.298731267452240,0.516724348068237;0.180392161011696,0.287658601999283,0.511880099773407;0.176470592617989,0.276585936546326,0.507035791873932;0.172549024224281,0.265513271093369,0.502191483974457;0.168627455830574,0.254440605640411,0.497347205877304;0.164705887436867,0.243367940187454,0.492502897977829;0.160784319043159,0.232295274734497,0.487658619880676;0.156862750649452,0.221222609281540,0.482814311981201;0.152941182255745,0.210149943828583,0.477970033884048;0.149019613862038,0.199077278375626,0.473125725984573;0.145098045468330,0.188004612922668,0.468281447887421;0.141176477074623,0.176931947469711,0.463437139987946;0.137254908680916,0.165859282016754,0.458592861890793;0.133333340287209,0.154786616563797,0.453748553991318;0.129411771893501,0.143713951110840,0.448904275894165;0.125490203499794,0.132641285657883,0.444059967994690;0.121568627655506,0.121568627655506,0.439215689897537]);


%% Calculate ATP blances: glycolysis, mitochondrial, total required
% Add ATP cyto2mito transporter to account for respiratory ATP production
map_ATP = mapHynne;
map_ATP.DRxns{end+1} = 'ATP/ADP transport cytosol to mitochondrium';
map_ATP.GSMRxns{end+1} = 870;

map_trp_only = map_ATP;
map_trp_only.DRxns(1:end-1)=[];
map_trp_only.GSMRxns(1:end-1) = [];


targets=[2222 2223 2224 2221 883 1180 588 2 339] ;%339 biomass

% Run Backtracking for all biomass components
for k= 1: length(targets)
    IdxTargetMet = targets(k); %can either be met or rxn (idx in GSM)
    [GSM, BioRxnIdx]= bktr_Target(GSM_unmodified,IdxTargetMet,IdxTargetRxn,scale);

    [GSM,irrevGSM,matchRev, map_lump] = bktr_prep_Lump(GSM,DM,map_ATP,BioRxnIdx);% prepare model
    [LeaksATP(:,k), AddUptakesATP{k}] = bktr_Run(irrevGSM,GSM,matchRev,map_lump,scale);   % Run FBA and Calculate Leaks

    [GSM,irrevGSM,matchRev, map_lump] = bktr_prep_Lump(GSM,DM,map_trp_only,BioRxnIdx);% prepare model
    [LeaksTrp(:,k), AddUptakesTrp{k}] = bktr_Run(irrevGSM,GSM,matchRev,map_lump,scale);   % Run FBA and Calculate Leaks

    
end

%% Plot Results
Leaks_plot=Leaks(3,1:end-1);% Requirement from glycolysis
Leaks_plot2=LeaksATP(3,1:end-1); % requirement for component production
Leaks_plot3=LeaksTrp(3,1:end-1); % requirement from mito ATP synthesis

percBiomass   =[0.012	0.219	0.0536	3.685	0.81	0.02	0.52	1.14]; %mmol/gDW
Leaks_plot= Leaks_plot.*percBiomass;% weigh with biomass molar contributions
Leaks_plot2= Leaks_plot2.*percBiomass;% weigh with biomass molar contributions
Leaks_plot3= Leaks_plot3.*percBiomass;% weigh with biomass molar contributions

Leaks_plot=[-Leaks_plot;-Leaks_plot2; -Leaks_plot3];

leg={'Reqirement of synthesis reaction','mitochondrial production','glycolytic production'};
bktr_barPlot(Leaks_plot([2 3 1],:)',GSM.metNames(targets(1:end-1)),leg)
colormap(gca,[0.400000002980232,0.400000002980232,0.400000002980232; ([182 226 241])/255;0.121568627655506,0.121568627655506,0.439215689897537]);

xlabel('mol ATP')
set(gcf,'Position',[ 2   145   432   411])

%% single result for complete biomass
table(DM.metNames, LeaksATP(:,end))
