function M = bktr_AddLeakRxn(M,Leaks,target,waste)
% function to add leak reaction to the DDM and (if supplied) adjust the stoichiometry of lumped reactions as specified in 'waste'
% in: 
% M:      Dynamic Model in Cobra Format
% Leaks:  Vector of Leak fluxes for all n dyn metabolites
% target: Name of the target compound
% 
% out:
% M:      Model with added Leak reaction

% add reaction
M = addReaction(M,['Leak_to_' target], [M.mets(:); target], [Leaks(:) ; 1],false);

% adjust stoichiometries 
if ~isempty(waste)
	for k=1:length(M.rxns)-1
        
		if~isempty(waste{k}) && any(waste{k}{:,2}) % for lumped reactions that have nonzero flux
			disp(' ')
            disp (['Changing stoichiometry of lumped reaction ' M.rxns{k} ' from '])
			printRxnFormula(M, M.rxns{k}, 1,1,1);
			% waste{k}= table(GSM.metNames(reactants),stoich*scale, isinDM);
			M.S(find(M.S(:,k)),k) = waste{k}{waste{k}{:,3},2}./max(waste{k}{waste{k}{:,3},2});
			disp('to ')
			printRxnFormula(M, M.rxns{k}, 1,1,1);
		end
	end
end
