% plotting function for the biomass backtracking results
function bktr_DistributionFigure(data, SNames, ENames, varargin)

%define colors
colormapE=[0.200000002980232,0.200000002980232,0.200000002980232;0.236519604921341,0.246568635106087,0.250000000000000;0.273039221763611,0.293137252330780,0.300000011920929;0.309558838605881,0.339705884456635,0.349999994039536;0.346078425645828,0.386274516582489,0.400000005960465;0.382598042488098,0.432843148708344,0.449999988079071;0.419117659330368,0.479411780834198,0.500000000000000;0.455637276172638,0.525980412960053,0.550000011920929;0.492156863212585,0.572549045085907,0.600000023841858;0.528676450252533,0.619117677211762,0.649999976158142;0.565196096897125,0.665686249732971,0.699999988079071;0.601715683937073,0.712254881858826,0.750000000000000;0.638235330581665,0.758823513984680,0.800000011920929;0.674754917621613,0.805392146110535,0.850000023841858;0.711274504661560,0.851960778236389,0.899999976158142;0.747794151306152,0.898529410362244,0.949999988079071;0.784313738346100,0.945098042488098,1;0.749542474746704,0.916862726211548,0.974117636680603;0.714771270751953,0.888627469539642,0.948235273361206;0.680000007152557,0.860392153263092,0.922352969646454;0.645228743553162,0.832156896591187,0.896470606327057;0.610457539558411,0.803921580314636,0.870588243007660;0.575686275959015,0.775686264038086,0.844705879688263;0.540915071964264,0.747451007366180,0.818823516368866;0.506143808364868,0.719215691089630,0.792941212654114;0.471372574567795,0.690980434417725,0.767058849334717;0.436601310968399,0.662745118141174,0.741176486015320;0.401830077171326,0.634509801864624,0.715294122695923;0.367058843374252,0.606274545192719,0.689411759376526;0.332287609577179,0.578039228916168,0.663529455661774;0.297516345977783,0.549803972244263,0.637647092342377;0.262745112180710,0.521568655967712,0.611764729022980;0.257777780294418,0.507450997829437,0.605751633644104;0.252810478210449,0.493333369493485,0.599738597869873;0.247843146324158,0.479215711355209,0.593725502490997;0.242875829339027,0.465098053216934,0.587712466716766;0.237908512353897,0.450980424880981,0.581699371337891;0.232941180467606,0.436862766742706,0.575686275959015;0.227973863482475,0.422745108604431,0.569673240184784;0.223006546497345,0.408627480268478,0.563660144805908;0.218039229512215,0.394509822130203,0.557647109031677;0.213071897625923,0.380392163991928,0.551634013652802;0.208104580640793,0.366274535655975,0.545620918273926;0.203137263655663,0.352156877517700,0.539607882499695;0.198169946670532,0.338039219379425,0.533594787120819;0.193202614784241,0.323921591043472,0.527581751346588;0.188235297799110,0.309803932905197,0.521568655967712;0.184313729405403,0.298731267452240,0.516724348068237;0.180392161011696,0.287658601999283,0.511880099773407;0.176470592617989,0.276585936546326,0.507035791873932;0.172549024224281,0.265513271093369,0.502191483974457;0.168627455830574,0.254440605640411,0.497347205877304;0.164705887436867,0.243367940187454,0.492502897977829;0.160784319043159,0.232295274734497,0.487658619880676;0.156862750649452,0.221222609281540,0.482814311981201;0.152941182255745,0.210149943828583,0.477970033884048;0.149019613862038,0.199077278375626,0.473125725984573;0.145098045468330,0.188004612922668,0.468281447887421;0.141176477074623,0.176931947469711,0.463437139987946;0.137254908680916,0.165859282016754,0.458592861890793;0.133333340287209,0.154786616563797,0.453748553991318;0.129411771893501,0.143713951110840,0.448904275894165;0.125490203499794,0.132641285657883,0.444059967994690;0.121568627655506,0.121568627655506,0.439215689897537];
colormapS=[0.313725501298904,0.0862745121121407,0.0862745121121407;0.331617653369904,0.0808823555707932,0.0808823555707932;0.349509805440903,0.0754901990294457,0.0754901990294457;0.367401987314224,0.0700980424880981,0.0700980424880981;0.385294139385223,0.0647058859467506,0.0647058859467506;0.403186291456223,0.0593137256801128,0.0593137256801128;0.421078443527222,0.0539215691387653,0.0539215691387653;0.438970595598221,0.0485294125974178,0.0485294125974178;0.456862747669220,0.0431372560560703,0.0431372560560703;0.474754929542542,0.0377450995147228,0.0377450995147228;0.492647081613541,0.0323529429733753,0.0323529429733753;0.510539233684540,0.0269607845693827,0.0269607845693827;0.528431415557861,0.0215686280280352,0.0215686280280352;0.546323537826538,0.0161764714866877,0.0161764714866877;0.564215719699860,0.0107843140140176,0.0107843140140176;0.582107841968536,0.00539215700700879,0.00539215700700879;0.600000023841858,0,0;0.615163445472717,0.0104575166478753,0.0104575166478753;0.630326807498932,0.0209150332957506,0.0209150332957506;0.645490229129791,0.0313725508749485,0.0313725508749485;0.660653591156006,0.0418300665915012,0.0418300665915012;0.675817012786865,0.0522875823080540,0.0522875823080540;0.690980434417725,0.0627451017498970,0.0627451017498970;0.706143796443939,0.0732026174664497,0.0732026174664497;0.721307218074799,0.0836601331830025,0.0836601331830025;0.736470580101013,0.0941176488995552,0.0941176488995552;0.751634001731873,0.104575164616108,0.104575164616108;0.766797423362732,0.115032680332661,0.115032680332661;0.781960785388947,0.125490203499794,0.125490203499794;0.797124207019806,0.135947719216347,0.135947719216347;0.812287569046021,0.146405234932899,0.146405234932899;0.827450990676880,0.156862750649452,0.156862750649452;0.835032701492310,0.207058832049370,0.197647064924240;0.842614412307739,0.257254898548126,0.238431379199028;0.850196063518524,0.307450979948044,0.279215693473816;0.857777774333954,0.357647061347961,0.319999992847443;0.865359485149384,0.407843142747879,0.360784322023392;0.872941195964813,0.458039224147797,0.401568651199341;0.880522906780243,0.508235275745392,0.442352950572968;0.888104557991028,0.558431386947632,0.483137249946594;0.895686268806458,0.608627438545227,0.523921608924866;0.903267979621887,0.658823549747467,0.564705908298492;0.910849690437317,0.709019601345062,0.605490207672119;0.918431401252747,0.759215712547302,0.646274507045746;0.926013052463532,0.809411764144898,0.687058806419373;0.933594763278961,0.859607875347138,0.727843165397644;0.941176474094391,0.909803926944733,0.768627464771271;0.930657446384430,0.900023102760315,0.762168407440186;0.920138418674469,0.890242218971252,0.755709350109100;0.909619390964508,0.880461394786835,0.749250292778015;0.899100363254547,0.870680510997772,0.742791235446930;0.888581335544586,0.860899686813355,0.736332178115845;0.855709373950958,0.830334544181824,0.716147661209106;0.822837412357330,0.799769341945648,0.695963084697723;0.789965391159058,0.769204199314117,0.675778567790985;0.757093429565430,0.738638997077942,0.655593991279602;0.724221467971802,0.708073854446411,0.635409474372864;0.691349506378174,0.677508652210236,0.615224897861481;0.658477544784546,0.646943509578705,0.595040380954742;0.625605523586273,0.616378307342529,0.574855804443359;0.592733561992645,0.585813164710999,0.554671287536621;0.559861600399017,0.555247962474823,0.534486711025238;0.526989638805389,0.524682819843292,0.514302194118500;0.494117647409439,0.494117647409439,0.494117647409439];

SColor=interp1(1:64, colormapS, linspace(1, 64, length(SNames)));
EColor=interp1(1:64, colormapE, linspace(1, 64, length(ENames)));


%Marginal Distributions
MargS=sum(data,2);
MargE=sum(data,1);

%Normalize
data=data./sum(MargS).*100;
MargS=sum(data,2);
MargE=sum(data,1);

% offset % widths
offset=3;
TW=200;
MW=25;
if nargin > 3 && ~isempty(varargin(1))
    offset = varargin{1};
end
if nargin > 4 && ~isempty(varargin(2))
    TW = varargin{2};
end
if nargin > 5 && ~isempty(varargin(3))
    MW = varargin{3};
end

if TW<2*MW
    TW=2*MW;
end

% clear to small data values
data(data<1e-10)=0;

% clear empty rows
data(:,MargE<1e-10)=[];
try
    ENames(MargE<1e-10)=[];
catch
end
MargE(MargE<1e-10)=[];

% clear empty cols
data(MargS<1e-10,:)=[];
SNames(MargS<1e-10)=[];
MargS(MargS<1e-10)=[];

% Bottom vertices
SFracBottom =[0 cumsum(MargS)'];
EFracBottom =[0 cumsum(MargE)];


% Calculation
for j=1:length(MargS)
    SFracBott(j)=SFracBottom(j)+offset*j;
    SFracBott_ini(j)=SFracBottom(j)+offset*j;
end

for k=1:length(MargE)
    EFracBott(k)=EFracBottom(k)+offset*k;
    EFracBott_ini(k)=EFracBottom(k)+offset*k;
end


for k=1:length(MargS)
    if MargS(k)>1e-10
        clear x y cdata
        %left edge
        y=SFracBott_ini(k) ;
        x=0;
        cdata=SColor(k,:);
        for j=1:length(MargE)
            if MargE(j)>0
                if data(k,j) >0
                    x=[x MW TW-MW TW TW TW-MW];
                    width=data(k,j);
                    y=[y SFracBott(k) EFracBott(j) EFracBott(j) EFracBott(j)+width EFracBott(j)+width  ];
                    cdata=[cdata; SColor(k,:); EColor(j,:); EColor(j,:); EColor(j,:); EColor(j,:)];
                    SFracBott(k)=SFracBott(k)+width;
                    EFracBott(j)=EFracBott(j)+width;
                end
            end
        end
        
        y=[y SFracBott(k) SFracBott(k)  y(1)];
        x=[x MW 0 0];
        cdata=[cdata; SColor(k,:); SColor(k,:); SColor(k,:)];
        
        
        
        hold on
        verts=[x;y]';
        faces= 1:length(x);
        patch('Faces',faces,'Vertices',verts,'FaceColor','interp','FaceVertexCData',cdata,'EdgeColor','none');
        
        
    end
end
SFracBott_ini=[SFracBott_ini max(y)];
EFracBott_ini=[EFracBott_ini max(y)];

for k=1:length(MargS)
    if MargS(k)>0
        text(-5 ,SFracBott_ini(k)+(SFracBott_ini(k+1)-SFracBott_ini(k))/2,[SNames{k} ' (' num2str(MargS(k),'%3.2f') '%)'],'HorizontalAlignment','right')
    end
end
for j=1:length(MargE)
    if MargE(j)>0
        text(TW+5 ,EFracBott_ini(j)+(EFracBott_ini(j+1)-EFracBott_ini(j))/2,[ENames{j} ' (' num2str(MargE(j),'%3.2f') '%)'] )
    end
end
xlim([-60, TW+60])
ylim([-10, max(y)+10+offset])
set(gca,'xtick',[],'ytick',[]); box on
