function bktr_Export(M,filename)

%% add compartment labels to species IDs (requrement for cobra export function)
compSymbolList={};
for k= 1:length(M.metNames)
    idx=strfind(M.metNames{k},'[');
    if isempty(idx)
        M.mets{k}=[M.mets{k} '[UnknComp]'];
        compSymbolList=unique([compSymbolList, 'UnknComp']);
    else
        M.mets{k}=[M.mets{k} M.metNames{k}(idx:end)];
        compSymbolList=unique([compSymbolList, M.metNames{k}(idx+1:end-1)]);
    end
end

%% Create SBML toolbox model
sbmlModel =convertCobraToSBML(M,3,1,compSymbolList,compSymbolList);

%% Write to xml file
disp(['Exporting model with new drain reaction to: ' cd filename '.xml'])
OutputSBML(sbmlModel, filename)
