function CM=bktr_RefillChebiAndKeggIds(CM, SM)
h= waitbar(0,'Annotating ... ');
% CM ... Incomplete converted cobra model
% SM ... SBML Model converted by SBML-Toolbox

%%% get SBML species IDs
for k=1:size(SM.species,2)
    spec_ids{k} = getfield(SM.species,{k}, 'id');
end

%%% Initialize formula storer
if isfield(CM, 'metFormulas')
    CM.metFormula=CM.metFormulas;
    CM = rmfield(CM, 'metFormulas');
elseif ~isfield(CM, 'metFormula')
    CM.metFormula=cell(size(CM.metNames));
%     CM.metFormula(1:end)={char(0,0)};
end

for k=1:size(CM.mets,1)
    %%% Find Database IDs for each compound
    [~,idx]=ismember(CM.mets{k},spec_ids);
    if 0==idx
        currMet=strsplit(CM.mets{k},{'[',']'});
        [~,idx]=ismember(['M_',currMet{1},'_' currMet{2}],spec_ids);%Different form: 'M_10fthf_c'
    end
    %     fprintf([' \n Species ' CM.metNames{k} ':\n'])
    waitbar(k/(size(CM.mets,1)+(size(CM.rxns,1))),h,['Annotating ... ' CM.metNames{k} '...'])
    if 0~=idx
        anno=  [strsplit(SM.species(idx).annotation,{'"',':','<p>',' ' ,'</p>','/'}) strsplit(SM.species(idx).notes,{'"',':','<p>',' ' ,'</p>','/'})];
        % KEGG
        [~,idx_Kegg]=ismember('kegg.compound',anno);
        if 0~=idx_Kegg
            CM.metKEGGID(k)=anno(idx_Kegg+1);
            %             fprintf('found KEGG ID (%s)...', CM.metKEGGID{k})
            %%% KEGG query
            if isempty(CM.metFormula{k}) || ~any(regexp(reshape(CM.metFormula{k},1, length(CM.metFormula{k})),'\w'))
                [text,status]=urlread(['http://rest.kegg.jp/get/cpd:' CM.metKEGGID{k} ]);
                if status==1
                    tlines = strsplit(text,'\n');
                    line_idx = find(cellfun(@any,strfind(tlines,'FORMULA')));
                    if ~isempty(line_idx)
                        formula=strsplit(tlines{line_idx});
                        CM.metFormula(k)=formula(2);
                        %                     fprintf('found Formula (%s)...',CM.metFormula{k} )
                        
                    end
                end
            end
        else
            CM.metKEGGID{k}=char.empty(0,0);
            
        end
        
        % Chebi
        [~,idx_chebi]=ismember('CHEBI',anno);
        if 0~=idx_chebi
            CM.metChEBIID(k)=anno(idx_chebi+1);
            %             fprintf('found CHEBI ID (%s).', CM.metChEBIID{k})
            
            if isempty(CM.metFormula{k}) || ~any(regexp(reshape(CM.metFormula{k},1, length(CM.metFormula{k})),'\w')) %if formula was not found via KEGG
                text=urlread(['http://www.ebi.ac.uk/chebi/searchId.do?chebiId=',CM.metChEBIID{k}]) ;
                splittext=strsplit(text,'Formula');
                lastentry=strsplit(splittext{end},'<td class="chebiDataContent" >');
                formula=strsplit(lastentry{2});
                CM.metFormula(k)=formula(2);
                %                 fprintf('..found Formula (%s).\n',CM.metFormula{k} )
                
            end
        else
            CM.metChEBIID{k}=char.empty(0,0);
        end
    else
        CM.metFormula{k}=char.empty(0,0);
        %         fprintf('No match!!!\n')
    end
    
end

%%% Reactions
for k=1:size(SM.reaction,2)
    rxn_ids{k} = getfield(SM.reaction,{k}, 'id');
end

CM.rxnECNumbers = cell(size(CM.rxns));
CM.rxnKEGGID = cell(size(CM.rxns));


for k = 1: length(CM.rxns)
    waitbar((k+size(CM.mets,1))/(size(CM.mets,1)+(size(CM.rxns,1))),h,['Annotating ... ' CM.rxnNames{k} '...'])
    
    [~,idx]=ismember(CM.rxns{k},rxn_ids);
    if 0==idx
        [~,idx]=ismember(['R_' CM.rxns{k}],rxn_ids); % Different notation
    end
    if 0~=idx
        anno=  [strsplit(SM.reaction(idx).annotation,{'"',':','<p>' ,'</p>','/'}) strsplit(SM.reaction(idx).notes,{'"',':','<p>' ,'</p>','/'})];
        
        % KEGG
        a=ismember(anno,'kegg.reaction');
        idx_Kegg=find(a);
        if 0~=idx_Kegg
            CM.rxnKEGGID(k)={anno(idx_Kegg+1)};
        else
            CM.rxnKEGGID{k}=char.empty(0,0);
        end
        
        % EC
        a=ismember(anno,'ec-code');
        idx_EC=find(a);
        
        if 0~=idx_EC
            CM.rxnECNumbers(k)={anno(idx_EC+1)};
        else
            CM.rxnECNumbers{k}=char.empty(0,0);
        end
        
    end
    
end


close(h)



