function [GSM, BioRxnIdx]= bktr_Target(GSM,IdxTargetMet,IdxTargetRxn, scale)

% function to fix the flux through the reaction producing the target metabolite to 1

if IdxTargetMet~= 0
    % add sink Rxn for the target metabolite (Steady state!)
    [GSM,BioRxnIdx] = addSinkReactions(GSM,GSM.mets(IdxTargetMet),1,1);
    if BioRxnIdx==-1 %if rxn was not present before
        BioRxnIdx=length(GSM.rxns);
    end
else
    BioRxnIdx=IdxTargetRxn;
    IdxTargetMet=find(GSM.S(:,BioRxnIdx));
end

% set flux through consuming Rxn to 1 scaled by the input scale parameter
GSM=changeRxnBounds(GSM,GSM.rxns(BioRxnIdx),1/scale,'b');

disp(['Added sink reaction and fixed flux for target metabolite ' GSM.metNames{IdxTargetMet} ' (reaction ' GSM.rxnNames{BioRxnIdx} ')'])