function Y7 = bktr_addY7LumpedBiomassComponents(Y7)
%%% add 'Proteinogenic AA Pool' entity
AAs= {'L-alanine [cytoplasm]',...
'L-arginine [cytoplasm]',...
'L-asparagine [cytoplasm]',...
'L-aspartate [cytoplasm]',...
'L-cysteine [cytoplasm]',...
'L-glutamate [cytoplasm]',...
'L-glutamine [cytoplasm]',...
'L-glycine [cytoplasm]',...
'L-histidine [cytoplasm]',...
'L-isoleucine [cytoplasm]',...
'L-leucine [cytoplasm]',...
'L-lysine [cytoplasm]',...
'L-methionine [cytoplasm]',...
'L-phenylalanine [cytoplasm]',...
'L-proline [cytoplasm]',...
'L-serine [cytoplasm]',...
'L-threonine [cytoplasm]',...
'L-tryptophan [cytoplasm]',...
'L-tyrosine [cytoplasm]',...
'L-valine [cytoplasm]'};

[~, AAidx]=ismember(AAs, Y7.metNames);
[~, biorxnidx]=ismember('yeast 5 biomass pseudoreaction', Y7.rxnNames);
AAstoich= full(Y7.S(AAidx,biorxnidx));

Y7 = addReaction(Y7,'r_p4040',[Y7.mets(AAidx);'s_p3714'],[-AAstoich/sum(AAstoich); 1],0,0,1000);
Y7.rxnNames{end}='Protein pseudoreaction (WCM)';
Y7.metNames{end}='Proteinogenic AA Pool';

%%% add 'DNA Deoxyribonucleotide Pool' entity 
dNTPs={'dAMP [cytoplasm]'...
'dCMP [cytoplasm]'...
'dGMP [cytoplasm]'...
'dTMP [cytoplasm]'};

[~, dNTPidx]=ismember(dNTPs, Y7.metNames);
dNTPstoich= full(Y7.S(dNTPidx,biorxnidx));

Y7 = addReaction(Y7,'r_p4041',[Y7.mets(dNTPidx);'s_p3715'],[-dNTPstoich/sum(dNTPstoich); 1],0,0,1000);
Y7.rxnNames{end}='DNA pseudoreaction (WCM)';
Y7.metNames{end}='DNA Deoxyribonucleotide Pool';


%%% add 'RNA Ribonucleotide Pool' entity 
NTPs={'AMP [cytoplasm]'...
'CMP [cytoplasm]'...
'GMP [cytoplasm]'...
'UMP [cytoplasm]'};

[~, NTPidx]=ismember(NTPs, Y7.metNames);
NTPstoich= full(Y7.S(NTPidx,biorxnidx));

Y7 = addReaction(Y7,'r_p4042',[Y7.mets(NTPidx);'s_p3716'],[-NTPstoich/sum(NTPstoich); 1],0,0,1000);
Y7.rxnNames{end}='RNA pseudoreaction (WCM)';
Y7.metNames{end}='RNA Ribonucleotide Pool';

%%% Rescale Lipid entity (to 1 mol and not mol fraction used in the biomass)
[~, lipid_idx]=ismember('lipid [cytoplasm]', Y7.metNames);
lipidProdRxnIdx=find(Y7.S(lipid_idx,:)>0);

[LipPrecIdx , ~ , LipPrecStoich]=find(Y7.S(:,lipidProdRxnIdx));

Y7 = addReaction(Y7,'r_p4043',[Y7.mets(LipPrecIdx(LipPrecStoich<0));'s_p3717'],[-LipPrecStoich(LipPrecStoich<0)/sum(LipPrecStoich(LipPrecStoich<0)); 1],0,0,1000);
Y7.rxnNames{end}='Lipid pseudoreaction (WCM)';
Y7.metNames{end}='Lipid Pool';
end