function bktr_barPlot(values,names,conditions)

% Bar Plot
figure,hold on

xlims=[min(min(values))-1 max(max(values))+1];
for k=1:length(names)
    if sum(abs(values(k,:)))<1e-10
        rectangle('Position',[xlims(1),0.5+k-1,xlims(2)-xlims(1),1],'FaceColor',[0.8 0.8 0.8],'EdgeColor','none') ;
    end
end


barh(1:length(values),values,1,'EdgeColor','none')
set(gca, 'ytick', 1:length(names),'yticklabel',names)

plot(xlims,repmat((0.5:length(names)+0.5),2,1),'Color',[0.5 0.5 0.5])
colormap(gca,[0.313725501298904,0.0862745121121407,0.0862745121121407;0.331617653369904,0.0808823555707932,0.0808823555707932;0.349509805440903,0.0754901990294457,0.0754901990294457;0.367401987314224,0.0700980424880981,0.0700980424880981;0.385294139385223,0.0647058859467506,0.0647058859467506;0.403186291456223,0.0593137256801128,0.0593137256801128;0.421078443527222,0.0539215691387653,0.0539215691387653;0.438970595598221,0.0485294125974178,0.0485294125974178;0.456862747669220,0.0431372560560703,0.0431372560560703;0.474754929542542,0.0377450995147228,0.0377450995147228;0.492647081613541,0.0323529429733753,0.0323529429733753;0.510539233684540,0.0269607845693827,0.0269607845693827;0.528431415557861,0.0215686280280352,0.0215686280280352;0.546323537826538,0.0161764714866877,0.0161764714866877;0.564215719699860,0.0107843140140176,0.0107843140140176;0.582107841968536,0.00539215700700879,0.00539215700700879;0.600000023841858,0,0;0.615163445472717,0.0104575166478753,0.0104575166478753;0.630326807498932,0.0209150332957506,0.0209150332957506;0.645490229129791,0.0313725508749485,0.0313725508749485;0.660653591156006,0.0418300665915012,0.0418300665915012;0.675817012786865,0.0522875823080540,0.0522875823080540;0.690980434417725,0.0627451017498970,0.0627451017498970;0.706143796443939,0.0732026174664497,0.0732026174664497;0.721307218074799,0.0836601331830025,0.0836601331830025;0.736470580101013,0.0941176488995552,0.0941176488995552;0.751634001731873,0.104575164616108,0.104575164616108;0.766797423362732,0.115032680332661,0.115032680332661;0.781960785388947,0.125490203499794,0.125490203499794;0.797124207019806,0.135947719216347,0.135947719216347;0.812287569046021,0.146405234932899,0.146405234932899;0.827450990676880,0.156862750649452,0.156862750649452;0.835032701492310,0.207058832049370,0.197647064924240;0.842614412307739,0.257254898548126,0.238431379199028;0.850196063518524,0.307450979948044,0.279215693473816;0.857777774333954,0.357647061347961,0.319999992847443;0.865359485149384,0.407843142747879,0.360784322023392;0.872941195964813,0.458039224147797,0.401568651199341;0.880522906780243,0.508235275745392,0.442352950572968;0.888104557991028,0.558431386947632,0.483137249946594;0.895686268806458,0.608627438545227,0.523921608924866;0.903267979621887,0.658823549747467,0.564705908298492;0.910849690437317,0.709019601345062,0.605490207672119;0.918431401252747,0.759215712547302,0.646274507045746;0.926013052463532,0.809411764144898,0.687058806419373;0.933594763278961,0.859607875347138,0.727843165397644;0.941176474094391,0.909803926944733,0.768627464771271;0.930657446384430,0.900023102760315,0.762168407440186;0.920138418674469,0.890242218971252,0.755709350109100;0.909619390964508,0.880461394786835,0.749250292778015;0.899100363254547,0.870680510997772,0.742791235446930;0.888581335544586,0.860899686813355,0.736332178115845;0.855709373950958,0.830334544181824,0.716147661209106;0.822837412357330,0.799769341945648,0.695963084697723;0.789965391159058,0.769204199314117,0.675778567790985;0.757093429565430,0.738638997077942,0.655593991279602;0.724221467971802,0.708073854446411,0.635409474372864;0.691349506378174,0.677508652210236,0.615224897861481;0.658477544784546,0.646943509578705,0.595040380954742;0.625605523586273,0.616378307342529,0.574855804443359;0.592733561992645,0.585813164710999,0.554671287536621;0.559861600399017,0.555247962474823,0.534486711025238;0.526989638805389,0.524682819843292,0.514302194118500;0.494117647409439,0.494117647409439,0.494117647409439]);
legend(conditions,2), box on
xlabel('mol of metabolite released during production of 1 mol target')
xlim(xlims)