function [vRev_min, vRev_max] = bktr_convertIrrevFluxDistributionFVABounds(vIrrev_min,vIrrev_max,matchRev)
% Convert bound of irreversible model to reversible form
% (modified from covertIrrevFluxDistribution function of the cobra toolbox, Markus Herrgard 1/30/07)
%
% INPUTS
% vIrrev        Irreversible flux distribution
% matchRev      Vector mapping irreversible fluxes to reversible fluxes 
%               (Generated by convertToIrreversible)
%
% OUTPUT
% vRev          Reversible flux distribution


processedFlux = false*ones(length(vIrrev_min),1);

vRev_min = [];
vRev_max = [];

for i = 1:length(vIrrev_min)
    if (~processedFlux(i))
        if (matchRev(i) > 0)
            vRev_min(end+1) = vIrrev_min(i)-vIrrev_max(matchRev(i));
            vRev_max(end+1) = vIrrev_max(i)-vIrrev_min(matchRev(i));
            processedFlux(matchRev(i)) = true;
        else
            vRev_min(end+1) = vIrrev_min(i);
            vRev_max(end+1) = vIrrev_max(i);
        end
        processedFlux(i) = true;
    end
end

vRev_min = columnVector(vRev_min);
vRev_max = columnVector(vRev_max);