%% generate annotated COBRA toolbox versions of the GSM models
clear all
initCobraToolbox

%% Yeast %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y7_file='GSModels/Yeast/yeast_7.00_cobra.xml';

Y7_SBML = TranslateSBML(Y7_file);
Y7 = convertSBMLToCobra(Y7_SBML);
Y7 = bktr_RefillChebiAndKeggIds(Y7,Y7_SBML);

idxMedium = (findExcRxns(Y7));[a,~]=find(Y7.S(:,idxMedium));
disp(table(Y7.rxns(idxMedium),printRxnFormula(Y7, Y7.rxns(idxMedium),0,1,1), Y7.lb(idxMedium), Y7.ub(idxMedium),(bktr_nAtoms(Y7,a,'C'))',...
    'VariableNames',{'Rxn','ReactionFormula', 'lb','ub','nC'}))

Y7=changeRxnBounds(Y7,{'r_1549','r_2033','r_1634'},0,'u');


save('GSModels/Yeast/Y7_filled.mat','Y7')

%% Ecoli %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
iJO1366_file= 'GSModels/EColi/msb201165-sup-0003.xml';

iJO1366_SBML = TranslateSBML(iJO1366_file);
iJO1366 = convertSBMLToCobra(iJO1366_SBML);
iJO1366 = bktr_RefillChebiAndKeggIds(iJO1366,iJO1366_SBML);

save('GSModels/EColi/iJO_filled.mat','iJO1366')

%% Mtb   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
iNJ661_file=('GSModels/Mtb/SBML_export_iNJ661.xml');

iNJ661_SBML = TranslateSBML(iNJ661_file);
iNJ661 = convertSBMLToCobra(iNJ661_SBML);
iNJ661 = bktr_RefillChebiAndKeggIds(iNJ661,iNJ661_SBML);

save('GSModels/Mtb/iNJ_filled.mat','iNJ661')

%% B.subtilis  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

iBsu1103_file='GSModels/Bsub/gb-2009-10-6-r69-s4.xml';

iBsu1103_SBML = TranslateSBML(iBsu1103_file);
iBsu1103 = convertSBMLToCobra(iBsu1103_SBML);
iBsu1103 = bktr_RefillChebiAndKeggIds(iBsu1103,iBsu1103_SBML);

save('GSModels/Bsub/iBsu_filled.mat','iBsu1103')

