%%function to generate representations of dynamic models for which the
%%biomass leaks will be computed
clear all
clc

% initialize
initCobraToolbox


%% Yeast glycolysis model of Hynne 2002
DMfile='DynModels/Hynne2001/BIOMD0000000061_Hynne_without_cyanide.xml';


DM_SBML = TranslateSBML(DMfile);
DM = convertSBMLToCobra(DM_SBML);
DM = bktr_RefillChebiAndKeggIds(DM,DM_SBML);

save('DynModels/Hynne_model.mat','DM')


%% Dummy glycolysis model
clear DM
map.DRxns = {'fructose-bisphosphatase';'fructose-bisphosphate aldolase';'hexokinase (D-glucose:ATP)';'glucose-6-phosphate isomerase';'glyceraldehyde-3-phosphate dehydrogenase';'phosphofructokinase';'phosphoglycerate kinase';'phosphoglycerate mutase';'enolase';'pyruvate kinase';'triose-phosphate isomerase'};
map.DMets = {'1,3-bisphospho-D-glycerate';'2-phospho-D-glyceric acid';'3-phosphoglycerate';'D-fructose 1,6-bisphosphate';'D-fructose 6-phosphate';'D-glucose';'D-glucose 6-phosphate';'glyceraldehyde 3-phosphate';'dihydroxyacetone phosphate';'phosphoenolpyruvate';'pyruvate';'ADP';'ATP';'NAD';'NADH'};
DM.mets = {'13dpg[c]','2pg[c]','3pg[c]','fdp[c]','f6p[c]','glc-D[c]','g6p[c]','g3p[c]','dhap[c]','pep[c]','pyr[c]','adp[c]','atp[c]','nad[c]','nadh[c]'};
DM.rxns = {'FBP','FBA','HEX1','PGI','GAPD','PFK','PGK','PGM','ENO','PYK','TPI'};
DM.metNames = map.DMets;
DM.rxnNames = map.DRxns;
DM.S=sparse([0,0,0,0,1,0,-1,0,0,0,0;0,0,0,0,0,0,0,1,-1,0,0;0,0,0,0,0,0,1,-1,0,0,0;-1,-1,0,0,0,1,0,0,0,0,0;1,0,0,1,0,-1,0,0,0,0,0;0,0,-1,0,0,0,0,0,0,0,0;0,0,1,-1,0,0,0,0,0,0,0;0,1,0,0,-1,0,0,0,0,0,1;0,1,0,0,0,0,0,0,0,0,-1;0,0,0,0,0,0,0,0,1,-1,0;0,0,0,0,0,0,0,0,0,1,0;0,0,1,0,0,1,-1,0,0,-1,0;0,0,-1,0,0,-1,1,0,0,1,0;0,0,0,0,-1,0,0,0,0,0,0;0,0,0,0,1,0,0,0,0,0,0]);
DM.rev = [1;1;1;1;1;1;1;1;1;1;1];
DM.metKEGGID= {'C00236';'C05853';'C01005';'C00095';'C00354';'C00794';'C00031';'C00127';'C00579';'C00350';'C00314';'C00054';'C02984';'C02700';'C00003'};
DM.metChEBIID=cell(size(DM.mets));
DM.rxnKEGGID= {[];'R00519';'R00332';'R02003';'R00115';'R01377';'R00756';'R01843';'R01009';[];'R02016'};
DM.metFormula={'C3H8O10P2';'C3H7O7P';'C3H7O7P';'C6H14O12P2';'C6H13O9P';'C6H12O6';'C6H13O9P';'C3H7O6P';'C3H7O6P';'C3H5O6P';'C3H4O3';'C10H15N5O10P2';'C10H16N5O13P3';'C21H28N7O14P2';'C21H29N7O14P2'};


save('DynModels/Glycolysis_model.mat','DM')

%% Extended dummy glycolysis model
clear DM
mapY7.DRxns = {'fructose-bisphosphatase';'fructose-bisphosphate aldolase';'hexokinase (D-glucose:ATP)';'glucose-6-phosphate isomerase';'glyceraldehyde-3-phosphate dehydrogenase';'phosphofructokinase';'phosphoglycerate kinase';'phosphoglycerate mutase';'enolase';'pyruvate kinase';'triose-phosphate isomerase';    'pyruvate carboxylase';'pyruvate decarboxylase'};
mapY7.DMets = {'1,3-bisphospho-D-glycerate';'2-phospho-D-glyceric acid';'3-phosphoglycerate';'D-fructose 1,6-bisphosphate';'D-fructose 6-phosphate';'D-glucose';'D-glucose 6-phosphate';'glyceraldehyde 3-phosphate';'dihydroxyacetone phosphate';'phosphoenolpyruvate';'pyruvate';'ADP';'ATP';'NAD';'NADH'; 'acetaldehyde';'oxaloacetate'};
DM.mets = {'13dpg[c]','2pg[c]','3pg[c]','fdp[c]','f6p[c]','glc-D[c]','g6p[c]','g3p[c]','dhap[c]','pep[c]','pyr[c]','adp[c]','atp[c]','nad[c]','nadh[c]','acald[c]','oxa[c]'};
DM.rxns = {'FBP','FBA','HEX1','PGI','GAPD','PFK','PGK','PGM','ENO','PYK','TPI','PYC','PYDC'};
DM.metNames = mapY7.DMets;
DM.rxnNames = mapY7.DRxns;
DM.S=sparse([0,0,0,0,1,0,-1,0,0,0,0,0,0;0,0,0,0,0,0,0,1,-1,0,0,0,0;0,0,0,0,0,0,1,-1,0,0,0,0,0;-1,-1,0,0,0,1,0,0,0,0,0,0,0;1,0,0,1,0,-1,0,0,0,0,0,0,0;0,0,-1,0,0,0,0,0,0,0,0,0,0;0,0,1,-1,0,0,0,0,0,0,0,0,0;0,1,0,0,-1,0,0,0,0,0,1,0,0;0,1,0,0,0,0,0,0,0,0,-1,0,0;0,0,0,0,0,0,0,0,1,-1,0,0,0;0,0,0,0,0,0,0,0,0,1,0,-1,-1;0,0,1,0,0,1,-1,0,0,-1,0,1,0;0,0,-1,0,0,-1,1,0,0,1,0,-1,0;0,0,0,0,-1,0,0,0,0,0,0,0,0;0,0,0,0,1,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,0,1;0,0,0,0,0,0,0,0,0,0,0,1,0]);
DM.rev = [1;1;1;1;1;1;1;1;1;0;0;1;1;1;1];
DM.metKEGGID= {'C00236';'C05853';'C01005';'C00095';'C00354';'C00794';'C00031';'C00127';'C00579';'C00350';'C00314';'C00054';'C02984';'C02700';'C00003'};
DM.metChEBIID=cell(size(DM.mets));
DM.rxnKEGGID= {[];'R00519';'R00332';'R02003';'R00115';'R01377';'R00756';'R01843';'R01009';[];'R02016'};
DM.metFormula={'C3H8O10P2';'C3H7O7P';'C3H7O7P';'C6H14O12P2';'C6H13O9P';'C6H12O6';'C6H13O9P';'C3H7O6P';'C3H7O6P';'C3H5O6P';'C3H4O3';'C10H15N5O10P2';'C10H16N5O13P3';'C21H28N7O14P2';'C21H29N7O14P2'};

save('DynModels/Glycolysis_model_ext.mat','DM') % DM

