clear all
clc
%% Hynne <--> Y7
load('GSModels/Yeast/Y7_filled.mat','Y7') % GSM
load('DynModels/Hynne_model.mat','DM') % DM

% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;

map.GSMRxns = {'rm','rm',424,366,686,350,820,384,[692,693,327],743,740,[143,1595],'rm','rm',[387,389],'rm','rm','rm','rm','rm','rm',128};
map.GSMMets = {'rm',435,326,439,290,429,427,581,485,954,56,959,1057,1090,264,525,'rm',582,'rm','rm',315};
              

mapHynne= bktr_mapping(Y7,DM, map);



%% Glycolysis <--> Y7

load('GSModels/Yeast/Y7_filled.mat','Y7') % GSM
load('DynModels/Glycolysis_model.mat','DM') % DM

% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;
YRxns={'r_0449','r_0450','r_0534','r_0467','r_0486','r_0886','r_0892','r_0893','r_0366','r_0962','r_1054'};
map.GSMRxns=num2cell(findRxnIDs(Y7,YRxns));
YMets={'s_0075','s_0188','s_0260','s_0555','s_0557','s_0563','s_0568','s_0764','s_0629','s_1360','s_1399','s_0394','s_0434','s_1198','s_1203'};
map.GSMMets=num2cell(findMetIDs(Y7,YMets));

mapY7= bktr_mapping(Y7,DM,map);


%% Extended Glycolysis <--> Y7

load('GSModels/Yeast/Y7_filled.mat','Y7') % GSM
load('DynModels/Glycolysis_model_ext.mat','DM') % DM

% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;
YRxns={'r_0449','r_0450','r_0534','r_0467','r_0486','r_0886','r_0892','r_0893','r_0366','r_0962','r_1054', 'r_0958',  'r_0959'};
map.GSMRxns=num2cell(findRxnIDs(Y7,YRxns));
YMets={'s_0075','s_0188','s_0260','s_0555','s_0557','s_0563','s_0568','s_0764','s_0629','s_1360','s_1399','s_0394','s_0434','s_1198','s_1203','s_0359','s_1271'};
map.GSMMets=num2cell(findMetIDs(Y7,YMets));

mapY7_e= bktr_mapping(Y7,DM,map);



%% Glycolysis <--> iJO1366

load('GSModels/EColi/iJO_filled.mat','iJO1366') % GSM
load('DynModels/Glycolysis_model.mat','DM') % DM as above


% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;
CRxns={'FBP','FBA','HEX1','PGI','GAPD','PFK','PGK','PGM','ENO','PYK','TPI'};
map.GSMRxns=num2cell(findRxnIDs(iJO1366,CRxns));
CMets={'13dpg[c]','2pg[c]','3pg[c]','fdp[c]','f6p[c]','glc-D[c]','g6p[c]','g3p[c]','dhap[c]','pep[c]','pyr[c]','adp[c]','atp[c]','nad[c]','nadh[c]'};
map.GSMMets=num2cell(findMetIDs(iJO1366,CMets));

mapiJO= bktr_mapping(iJO1366,DM,map);


%% Glycolysis <--> iNJ661

load('GSModels/Mtb/iNJ_filled.mat','iNJ661'); % GSM
load('DynModels/Glycolysis_model.mat','DM') % DM as above

% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;
MRxns = {'FBP','FBA','PPGKr','PGI','GAPD','PFK','PGK','PGM','ENO','PYK','TPI'};
map.GSMRxns=num2cell(findRxnIDs(iNJ661,MRxns));
MMets={'13dpg[c]','2pg[c]','3pg[c]','fdp[c]','f6p[c]','glc-D[c]','g6p[c]','g3p[c]','dhap[c]','pep[c]','pyr[c]','adp[c]','atp[c]','nad[c]','nadh[c]'};
map.GSMMets=num2cell(findMetIDs(iNJ661,MMets));

mapiNJ= bktr_mapping(iNJ661,DM,map);


%% Glycolysis <--> iBsu1103

load('GSModels/Bsub/iBsu_filled.mat','iBsu1103'); % GSM
load('DynModels/Glycolysis_model.mat','DM') % DM as above

% constrauct map by hand (also function bktr_mapping possible)
map.DMets = DM.metNames;
map.DRxns = DM.rxnNames;
map.GSMMets={397,1024,775,325,1125,648,1241,1260,515,1123,950,1141,489,656,1045};
map.GSMRxns={706,421,1178,278,54,521,1226,834, 181 ,  947,1281};

mapiBsu= bktr_mapping(iBsu1103,DM,map);


%% save all maps
save('DynModels/maps.mat','mapY7','mapY7_e','mapiJO','mapiNJ','mapiBsu','mapHynne')