function nC=bktr_nAtoms(GSM,idx,WeighAtom)
nC=zeros(1,length(idx));
for k=1:length(idx)
    str=[];
    try
        str=GSM.metFormula{idx(k)};
    catch
        try
            str=GSM.metFormulas{idx(k)};
        catch
        end
    end
    
    if ~isempty(str)
        idx_noChar = regexp(str(:)','\W');
        str(idx_noChar) = [];
    end
    
    if ~isempty(str)
        Fparts=strsplit(str,'(');
        for j=1:length(Fparts)
            if ~isempty(Fparts{j})
                Fparts{j}=strsplit(Fparts{j},')');
                str=Fparts{j}{1};
                [atStart, atEnd] = regexp(str,'([A-Z][a-z]*)');% find all element names
                atStart(end+1)=length(str)+1;
                for i=1:length(atEnd)
                    atoms(i)={str(atStart(i):atEnd(i))};
                    stoich(i)={str2double(str(atEnd(i)+1:atStart(i+1)-1))};
                    if isnan(stoich{i})
                        stoich(i)={1}; %CN
                    end
                end
                if length(Fparts{j})>1
                    if ~isnan(str2double(Fparts{1,2}{1,2}))
                        stoich=stoich*str2double(Fparts{1,2}{1,2});%multiply with number behind the bracket
                    end
                end
                [a,b]=ismember(WeighAtom,atoms);
                if a
                    nC(k)=nC(k)+stoich{b}; % sum over all brackets
                end
            end
            
        end
    end
    
    
end
