function [GSM,modelIrrev,matchRev, map ,rev2irrev] = bktr_prep_Lump(GSM,DynM,map,BioRxnIdx)

% Function to irreversibilize model and sets the objective to 'total flux'
% in:
% GSM:       Genome scale model
% DynM:      Dynamic model
% map:       mappingstructure of the two models
% BioRxnIdx: Idx of the target Rxn
%
% out:
% GSM:        Original GSM Model
% modelIrrev: Irreversible model with objective
% matchRev:   Mapping of the two

%% add flux measure
GSM=addReaction(GSM,'Fluxmeasure',{'X'},[-1],0,0,1000);

%% change reversibiliy according to bounds
isRev = (sign(GSM.lb).*sign(GSM.ub))<0;
GSM.rev(:)=0;
GSM.rev(isRev)=1;

%% Make irreversible model
[modelIrrev,matchRev,rev2irrev,~] = convertToIrreversible(GSM);

% Correct bound of newly created uptake rxn for the target metabolite (COBRA bug)
modelIrrev.ub(rev2irrev{BioRxnIdx}(1))=GSM.ub(BioRxnIdx); % correct ub for target metabolite uptake
modelIrrev.lb(rev2irrev{BioRxnIdx}(1))=GSM.lb(BioRxnIdx); % correct lb for target metabolite uptake
if length(rev2irrev{BioRxnIdx})==2 % inactivate reverse reaction if one was created
    modelIrrev.ub(rev2irrev{BioRxnIdx}(2))=0; % correct ub for target metabolite uptake
    modelIrrev.lb(rev2irrev{BioRxnIdx}(2))=0; % correct lb for target metabolite uptake
end

%% Add Flux Measure to each reaction
modelIrrev.S(end,1:end-1)=1;% each Rxn produces the flux measure

%% Set objective
modelIrrev.c(:)=0;
modelIrrev.c(end)=1; %flux objective
