% Code for plotting of the calculated spearman correlation coefficient values between the model parameters and the inflammation indices of the model output variables
function graphindices = CC_figure(Z)

A = {'S1','S10','S20','S30','S40','S50','S60','S70'};
B = {'P1','P10','P20','P30','P40','P50','P60','P70','P80','P90','P100',...
    'P110','P120','P130','P140','P150','P160','P170','P180','P190'};

F = (abs(Z)'); 
% imagesc(abs(F));
imagesc(abs(F)>=0.5); %Uncomment this line  to plot only strong correlations
%colormap(flipud(gray));
hold on
for i=0.5:1:78.5    % draw horizontals
hGRID = plot([0 193.5],[i i],'k-');
set(get(get(hGRID,'Annotation'),'LegendInformation'),...
'IconDisplayStyle','off'); % Exclude line from legend
hold on
end
for i=0.5:1:193.5    % draw verticals
hGRID = plot([i i],[0 78.5],'k-');
set(get(get(hGRID,'Annotation'),'LegendInformation'),...
'IconDisplayStyle','off'); % Exclude line from legend
end
set(gca,'XTick',1:10:200, 'Ytick',1:10:80);
format_ticks(gca,B,A);
hold off
