function P = Latinhypercube(Param,rangefactor,iter)

%Assigning parameter range
% Minimum values
k_min = Param./rangefactor;
% Maximum values
k_max = Param.*rangefactor;

%Creating Latin hypercube sampling matrix using Matlab function lhsdesign
X1 = lhsdesign(iter,size(Param,1));
P = zeros(size(X1,1),size(X1,2));

%Creating randomized parameter sets using LHS
for i = 1:size(Param,1)
    P(:,i) = (X1(:,i).*(k_max(i)-k_min(i)))+k_min(i);
end
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------























