%% It calculates PRCCs and their significances
%% (uncorrected p-value, Bonferroni correction and 
%% Benjamini and Hochberg False Discovery Rate correction)
%% LHSmatrix: LHS matrix (N x k) %%
%% Y: output matrix (time x N) %%
%% s: time points to test (row vector) %%
%% PRCC_var: vector of strings {'p1','p2',...,'pk'}
%%            to label all the parameters varied in the LHS
%% by Simeone Marino, May 29 2007 %%
%% N.B.: this version uses ONE output at a time

function [prcc sign]=PRCC(Param1,Y,s);

%LHSmatrix=LHS; % Define LHS matrix
% Y=Y(s,:)';% Define the output. Comment out if the Y is already 
%           % a subset of all the time points and it already comprises
%           % ONLY the s rows of interest
[a k]=size(Param1); % Define the size of LHS matrix
[b out]=size(Y);
for i=1:k  % Loop for the whole submatrices
%     i;
    c=['Paramtemp=Param1;Paramtemp(:,',num2str(i),')=[];Z',num2str(i),'=Paramtemp;Paramtemp=[];'];
    eval(c);
    % Loop to calculate PRCCs and significances
    c1=['[Param1(:,',num2str(i),'),Y];'];
    c2=['Z',num2str(i)];
    [rho,p]=partialcorr(eval(c1),eval(c2),'type','Spearman');
    for j=1:out
        c3=['prcc_',num2str(i),'(',num2str(j),')=rho(1,',num2str(j+1),');'];
        c4=['prcc_sign_',num2str(i),'(',num2str(j),')=p(1,',num2str(j+1),');'];
        eval(c3);
        eval(c4);
    end
    c5=['clear Z',num2str(i),';'];
    eval(c5);
end
prcc=[];
prcc_sign=[];
for i=1:k
    d1=['prcc=[prcc ; prcc_',num2str(i),'];'];
    eval(d1);
    d2=['prcc_sign=[prcc_sign ; prcc_sign_',num2str(i),'];'];
    eval(d2);
end
[length(s) k out];
PRCCs=prcc';
uncorrected_sign=prcc_sign';
prcc=PRCCs;
sign=uncorrected_sign;