% Function for calculating the model outputs for a given parameter set
function Ymain_default = Param_var_local(tmin_ss,tminday,Yinit,Param,options)

% Calling ODE solver with default parameters
p = Param;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,Yinit,options);
y0new = sol.y(:,end);
% LPS chronic
p(116) = 1100; % rl_b_tt
p(191) = Param(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
Ymain_default = deval(solw,tminday)';

clear sol
clear solw
clear tnf_il10_model

