
function [] = figure_2(pars,names,y0)

thours = 24*2;
tsecs_ss = 0:1:100*3600; % 3000 hrs sec
tsecsday = 0:1:thours*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);

tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

% Yuk et al. Nat Imm 2011 Fig. 2a
tt = [0 180 360 1080 2880]/60;
target = [0,0;0.0000582,0.000025;0.000235,0.00004;0.0002941,0.00007;0.000176,0.0001];

% Xia et al. Immunity 2011 Fig. 6b
tp38 = [0 15 30 45 60]/60;
p38 = [0; 0.05; 0.04666; 0.0333; 0.01666];

% Rowlett et al Am J Ph GLPhy Fig 3a
tmtnf = [0 60 120 180 240]/60;
mtnf = [0; 0.03; 0.0137; 0.00514; 0.00257]*2;

% Tiruppathi et al. Nat Imm Fig. S4a
ttak1 = [0 15 30 60]/60;
tak1 = [0.463113006396589;0.941577825159915;0.570575692963753;0.442643923240939];

% Qin et ak. Blood Fig. 4d
tifn = [0 2 4 8 12];
ifn = [0;0.996323784956865;3.32925294058587;3.89649189198930;1.89778165651074]*0.00004444;

figure;
set(gcf, 'Color', 'w');

subplot(2,3,1);
plot(thrsday,y1(:,31),'k',tt,target(:,1),'--*k','LineWidth',3);
xlim([0 thours]);
ylim([0 1.1*max(y1(:,31))]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
title('TNF-\alpha','FontName','Arial','FontSize',20);
% legend('Sim', 'Exp','Location','southeast');
% legend('boxoff');
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 1e-4 2e-4 3e-4]);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,3,2);
plot(thrsday,y1(:,41),'k',tt,target(:,2),'--*k','LineWidth',3);
xlim([0 thours]);
ylim([0 1.1*max(y1(:,41))]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
title('IL-10','FontName','Arial','FontSize',20);
% legend('Sim', 'Exp','Location','southeast');
% legend('boxoff');
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 5e-5 10e-5]);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,3,3);
fh = 12;
plot(thrsday(1:fh*3600),y1(1:fh*3600,36),'k',tifn,ifn,'--*k','LineWidth',3);
xlim([0 fh]);
ylim([0 2e-4]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
title('IFN-\beta','FontName','Arial','FontSize',20);
% legend('Sim','Exp','Location','southeast');
% legend('boxoff');
set(gca, 'XTick',[0 4 8 12]);
set(gca, 'YTick',[0 1e-4 2e-4]);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,3,4);
fh = 4;
plot(thrsday(1:fh*3600),rescaleTo(y1(1:fh*3600,29),0,1),'k',tmtnf,rescaleTo(mtnf,0,1),'--*k','LineWidth',3);
xlim([0 fh]);
ylim([0 1.1]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration (A.U.)','FontName','Arial','FontSize',20);
title('mRNA-TNF\alpha','FontName','Arial','FontSize',20);
% legend('Sim','Exp','Location','northeast');
% legend('boxoff');
set(gca, 'XTick',[0 2 4]);
set(gca, 'YTick',[0 0.5 1]);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,3,5);
fh = 1;
plot(thrsday(1:fh*3600),rescaleTo(y1(1:fh*3600,18),0,1),'k',...
     ttak1,rescaleTo(tak1,0,1),'--*k','LineWidth',3);
xlim([0 fh]);
ylim([0 1.1]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration (A.U.)','FontName','Arial','FontSize',20);
title('TAK1','FontName','Arial','FontSize',20);
% legend('Sim','Exp','Location','northeast');
% legend('boxoff');
set(gca, 'XTick',[0 0.5 1]);
set(gca, 'YTick',[0 0.5 1]);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,3,6);
fh = 1;
plot(thrsday(1:fh*3600),rescaleTo(y1(1:fh*3600,63),0,1),'k',tp38,rescaleTo(p38,0,1),'--*k','LineWidth',3);
xlim([0 fh]);
ylim([0 1.1]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('Concentration (A.U.)','FontName','Arial','FontSize',20);
title('P38','FontName','Arial','FontSize',20);
% legend('Sim','Exp','Location','northeast');
% legend('boxoff');
set(gca, 'XTick',[0 0.5 1]);
set(gca, 'YTick',[0 0.5 1]);
set(gca,'FontName','Arial','FontSize',18);


