
function [] = figure_3(pars,names,y0)

thours = 24*2;
tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:thours*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;
ifnb = 1e-2;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

% IFNAR -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(121) = 0; % ifnrtot
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y2 = deval(solw,tminday)';

% ifnb wt
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
y0new(36) = y0new(36) + ifnb; % IFNb
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y3wt = deval(solw,tminday)';

% GSK3 knockin
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(163) = 0.1*p(163); % a_c_pg
tic
p(116) = 1100; % rl_b_tt
y0new(36) = y0new(36) + ifnb; % IFNb
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y3 = deval(solw,tminday)';

% TRIF -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(130) = 0; % triftot
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y4 = deval(solw,tminday)';

% IRF3 -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(168) = 0; % irf3tot
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y5 = deval(solw,tminday)';

% MSK1 -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(151) = 0; % a_c_pm
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y6 = deval(solw,tminday)';

figure;
set(gcf, 'Color', 'w');

vars = 41;

% data from Fig 2C Chang et al J Imm 2007
ydata = [1697.80620351702,58.3632649246258,240.382946336774,555.039856862458];
ydata = ydata./max(ydata);
subplot(2,2,1);
ys = [y1(end,vars),y4(end,vars),y5(end,vars),y2(end,vars)];
ys = ys./max(ys);
ytoplot = [ydata;ys]';
bar(ytoplot,1,'LineWidth',2);
colormap gray
ylim([0 1.1]);
title(names(vars),'FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',16);
% legend('Exp','Sim','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',16);
set(gca,'XTickLabel',{'WT','TRIF','IRF3','IFNAR'});
set(gca, 'YTick',[0 0.5 1]);

% data from Fig 4H Wang et al J Imm 2011
ydata = [8.9943074003795141e+02,1.7647058823529440e+02];
ydata = ydata./max(ydata);
subplot(2,2,2);
ys = [y3wt(end,vars),y3(end,vars)];
ys = ys./max(ys);
ytoplot = [ydata;ys]';
bar(ytoplot,1,'LineWidth',2);
colormap gray
ylim([0 1.1]);
title(names(vars),'FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',16);
% legend('Exp','Sim','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',16);
set(gca,'XTickLabel',{'WT', 'GSK3 knockin'});
set(gca, 'YTick',[0 0.5 1]);

% data from Fig 3C Pattison et al J Imm 2012
xdata = [0 1 4 8 16 24];
ydata = [10.4529922018762,497.301323052660,106.181547358277,13.4364321387903,15.1537720143706,16.8754928590217];
ydata = ydata./max(ydata);
subplot(2,2,3);
vars = 39;
xhours = xdata*3600;
xhours(1) = 1;
ys = y2(xhours,vars)';
ys = ys./max(ys);
ytoplot = [ydata;ys]';
bar(ytoplot,1,'LineWidth',2);
colormap gray
ylim([0 1.1]);
title(names(vars),'FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',16);
ylabel('Normalized units','FontName','Arial','FontSize',16);
% legend('IFNAR -/- Exp','IFNAR -/- Sim','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',16);
set(gca,'XTickLabel',{'0','1','4','8','16','24'});
set(gca, 'YTick',[0 0.5 1]);

vars = 41;
% data from Fig 4B Ananieva et al Nat Imm 2008
ydata = [11.5090103942436,44.1178731779323,79.1061873423951,296.101389999385,354.741989052217,392.094378498063];
ydatawt = [11.8203309692676;281.323877068558;189.125295508275;664.302600472814;702.127659574468;643.026004728133];
ydata = ydata./max(ydatawt);
subplot(2,2,4);
xhours = [1 1*3600 2*3600 4*3600 6*3600 8*3600];
y1s = y1(xhours,vars)';
ys = y6(xhours,vars)';
ys = ys./max(y1s);
ytoplot = [ydata' ys'];
bar(ytoplot,1,'LineWidth',2);
colormap gray
ylim([0 0.6]);
title(names(vars),'FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',16);
ylabel('Ratio to WT','FontName','Arial','FontSize',16);
% legend('MSK -/- Exp','MSK -/- Sim','Location','northwest');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',16);
set(gca,'XTickLabel',{'0','1','2','4','6','8'});
set(gca,'YTick',[0 0.3 0.6]);

