
function [] = figure_4(pars,names,y0)

thours = 24*4;
tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:thours*3600; % 4 days in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);

tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

% IFNb -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(69) = 0; % prs_ifn
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y3 = deval(solw,tminday)';

% DUSp1 -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(87) = 0;  % prs_du
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y4 = deval(solw,tminday)';

% MSK -/-
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(151) = 0; % a_c_pm
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y6 = deval(solw,tminday)';

hour1 = 0;
hour2 = 12;
vars = 74;

figure;
set(gcf, 'Color', 'w');
plot(thrsday,y1(:,vars),'k',...
    thrsday,y6(:,vars),'r',...
    thrsday,y4(:,vars),'b',...
    thrsday,y3(:,vars),'g','LineWidth',3);
xlim([hour1 hour2]);
ylim([0 1.1*max(y4(1:hour2*3600,vars))]);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('[pCREB] (\muM)','FontName','Arial','FontSize',20);
legend('WT','MSK1 -/-','DUSP1 -/-','IFN-\beta -/-','Location','northeast');
legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 4 8 12]);
set(gca,'YTick',[0 3e-2 6e-2]);

