
function [] = figure_5(pars,names,y0)

tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:24*4*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);

tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat = zeros(size(y1,1),10);
tmat(:,1) = y1(:,14);
tmat(:,2) = y1(:,74);

% 50% IkBa
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(36) = 0.5*p(36); % prs_an
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,3) = y1(:,14);

% 200% IkBa
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(36) = 2*p(36); % prs_an
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,4) = y1(:,14);

% 50% DUSP 
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(87) = 0.5*p(87);  % prs_du
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,5) = y1(:,74);

% 200% DUSP 
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(87) = 2*p(87);  % prs_du
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,6) = y1(:,74);

% 50% A20
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(52) = 0.5*p(52); % prs_a20n
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,7) = y1(:,14);
ikkb(:,2) = y1(:,15);

% 200% A20
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(52) = 2*p(52); % prs_a20n
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,8) = y1(:,14);

% 50% GSK3 -- this means more GSK3 inhibition
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(162) = 0.5*p(162); % gsk3tot
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,9) = y1(:,74);

% 200% GSK3 -- this means less GSK3 inhibition
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(162) = 2*p(162); % gsk3tot
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
tmat(:,10) = y1(:,74);

figure;
set(gcf, 'Color', 'w');
subplot(2,2,1);
hour1 = 0;
hour2 = 4;
plot(thrsday,tmat(:,1),'k',thrsday,tmat(:,3),'--k',thrsday,tmat(:,4),':k','LineWidth',3);
xlim([hour1 hour2]);
ylim([0 1.1*max(tmat(1:hour2*3600,3))]);
title('NF-\kappaB','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',18);
ylabel('Concentration (\muM)','FontName','Arial','FontSize',18);
legend('WT', '50% I\kappaB\alpha','200% I\kappaB\alpha','Location','northeast');
legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 1 2 3]);
% set(gca,'YTick',[0 2e-2 4e-2]);

subplot(2,2,2);
hour1 = 0;
hour2 = 12;
plot(thrsday,tmat(:,2),'k',thrsday,tmat(:,5),'--k',thrsday,tmat(:,6),':k','LineWidth',3);
xlim([hour1 hour2]);
ylim([0 1.3*max(tmat(1:hour2*3600,5))]);
title('pCREB','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',18);
ylabel('Concentration (\muM)','FontName','Arial','FontSize',18);
legend('WT', '50% DUSP1','200% DUSP1','Location','northeast');
legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 6 12]);
set(gca,'YTick',[0 3e-2 6e-2]);

subplot(2,2,3);
hour1 = 0;
hour2 = 3;
plot(thrsday,tmat(:,1),'k',thrsday,tmat(:,7),'--k',thrsday,tmat(:,8),':k','LineWidth',3);
xlim([hour1 hour2]);
% ylim([0 4e-2]);
title('NF-\kappaB','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',18);
ylabel('Concentration (\muM)','FontName','Arial','FontSize',18);
legend('WT', '50% A20','200% A20','Location','northeast');
legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 1 2 3]);
% set(gca,'YTick',[0 2e-2 4e-2]);

subplot(2,2,4);
hour1 = 0;
hour2 = 12;
plot(thrsday,tmat(:,2),'k',thrsday,tmat(:,9),':k',thrsday,tmat(:,10),'--k','LineWidth',3);
xlim([hour1 hour2]);
ylim([0 1.3*max(tmat(1:hour2*3600,9))]);
title('pCREB','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',18);
ylabel('Concentration (\muM)','FontName','Arial','FontSize',18);
legend('WT', '200% GSK3','50% GSK3','Location','northeast');
legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 6 12]);
set(gca,'YTick',[0 3e-2 6e-2]);
        
