
function [tmat,datapm,datapt,datass,allik,all10] = figure_6(pars,names,y0)

tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:24*7*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;

levels10 = 0:0.05:1;
levelsik = 0:0.05:1;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

tmat = zeros(size(y1,1),length(levels10)*length(levelsik));

k = 1;
datapm = zeros(length(levelsik),length(levels10));
datapt = zeros(length(levelsik),length(levels10));
datass = zeros(length(levelsik),length(levels10));

for i=1:length(levelsik),
    for j=1:length(levels10),
       
        p = pars;
        p(36) = levelsik(i)*p(36); % prs_an
        p(78) = levels10(j)*p(78); % prs_il

        p(116) = 0; % rl_b_tt
        p(191) = 0; % LPS
        tic
        sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
        y0new = sol.y(:,end);
        tic
        p(116) = 1100; % rl_b_tt
        p(191) = pars(191); % LPS
        y0new(27:31) = 0; % TNF vars
        y0new(54:55) = 0; % TNF vars
        solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
        y1 = deval(solw,tminday)';
        
        [pm,peakt] = max(y1(:,31));
        pt = thrsday(peakt);
        datapm(i,j) = pm;
        datapt(i,j) = pt;
        datass(i,j) = y1(end,31);
        
        tmat(:,k) = y1(:,31);
        k = k+1;
    end
end

levels10 = [5e-3,7.5e-3,1e-2,2.5e-2,5e-2,1e-1,0.25,0.5,1,1.5,2];
levelsik = 0.5:0.15:2;

allik = zeros(size(y1,1),length(levelsik));

for i=1:length(levelsik),
    
    p = pars;
    p(36) = levelsik(i)*p(36); % prs_an

    p(116) = 0; % rl_b_tt
    p(191) = 0; % LPS
    tic
    sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
    y0new = sol.y(:,end);
    tic
    p(116) = 1100; % rl_b_tt
    p(191) = pars(191); % LPS
    y0new(27:31) = 0; % TNF vars
    y0new(54:55) = 0; % TNF vars
    solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
    y1 = deval(solw,tminday)';

    allik(:,i) = y1(:,31);
end

all10 = zeros(size(y1,1),length(levels10));

for i=1:length(levels10),
    
    p = pars;
    p(78) = levels10(i)*p(78); % prs_il

    p(116) = 0; % rl_b_tt
    p(191) = 0; % LPS
    tic
    sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
    y0new = sol.y(:,end);
    tic
    p(116) = 1100; % rl_b_tt
    p(191) = pars(191); % LPS
    y0new(27:31) = 0; % TNF vars
    y0new(54:55) = 0; % TNF vars
    solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
    y1 = deval(solw,tminday)';

    all10(:,i) = y1(:,31);
end
