
function [] = figure_7(pars,names,y0)

tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:24*4*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

% IFNb --
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(69) = 0; % prs_ifn
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y2a = deval(solw,tminday)';

% MSK --
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(151) = 0; % a_c_pm
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y3a = deval(solw,tminday)';

% IkBa --
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
p(36) = 0*p(36); % prs_an
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y4a = deval(solw,tminday)';

figure;
set(gcf, 'Color', 'w');
h0 = 1;
h3 = 24*4*3600;
h1 = 4*3600;
h2 = 8*3600;
plot(thrsday(h0:h3),y1(h0:h3,31)./y1(h0:h3,31),'k',...
     thrsday(h0:h3),y4a(h0:h3,31)./y1(h0:h3,31),'--k',...
     thrsday(h1:h3),y3a(h1:h3,31)./y1(h1:h3,31),'--r',...
     thrsday(h2:h3),y2a(h2:h3,31)./y1(h2:h3,31),'--b','LineWidth',3);
axis([0 96 0.9 3.5]);
legend('WT','I\kappaB\alpha -/-','MSK1 -/-','IFN\beta -/-','Location','northeast');
legend('boxoff');
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
ylabel('[TNF-\alpha] relative to WT','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 24 48 72 96]);
set(gca,'YTick',[1 2 3]);
