
function [] = figure_s1(pars,names,y0)

thours = 24*2;
tsecs_ss = 0:1:100*3600;
tsecsday = 0:1:thours*3600;
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';

% Fig S2 form Hao et al PNAS 2013
pikba = [0,62.3040623040621;4.86486486486486,126.070026070026;6.81081081081080,581.995181995182;7.35135135135134,788.921888921889;9.40540540540540,753.997953997954;11.2432432432432,792.347292347292;14.1621621621622,795.832095832096;14.8108108108108,684.070884070884;16.6486486486487,748.061248061248;19.3513513513513,700.277200277200;29.7297297297297,399.277299277299;39.8918918918919,286.935286935287;60.0000000000000,130.030030030030];
mikba = [0,69.6036696036694;4.32432432432432,102.293502293502;7.02702702702702,131.432531432531;8.64864864864865,156.974556974557;10.0540540540540,206.339306339306;11.5675675675676,281.338481338481;13.9459459459459,350.790350790351;17.0810810810811,590.525690525690;20.0000000000000,855.915255915256;30.0540540540541,935.887535887536;39.5675675675676,781.460581460581;60.0000000000000,256.403656403656];

pikbe = [0,19.1837524891216;4.90983848366399,22.3583044472306;9.73984069621654,62.0349030164467;14.9406298399587,144.605059370160;20.0193598347961,138.987480640165;29.8421712515672,110.968729257320;39.8814440592964,89.3433328416550;59.8355335939229,31.1730216092632];
mikbe = [0,32.7734346190722;9.70112102662438,34.0599417361163;15.0151191090788,48.4235563094624;16.7610074489269,34.8278818496939;20.0051626226123,53.7299948373774;29.9371266317575,104.573991444797;40.0457260859945,133.037097131057;60.2782284829265,126.020078914374];

ptnf = [0,0;5.73825503355705,6.58490465537452;8.45637583892618,47.1689570682859;9.96644295302014,140.086023223607;14.6979865771812,293.448386065836;19.5302013422819,346.814743794610;30.0000000000000,71.0397358048365;39.5637583892617,38.0859166932993;59.8993288590604,7.14685202940230];
mtnf = [0,0;5.63758389261745,-0.561947374027949;9.96644295302014,7.54634068392469;14.8993288590604,56.1547885373389;16.7114093959732,151.464791733248;19.7315436241611,196.029082774049;29.8993288590604,325.003994886545;39.8657718120805,280.161393416427;59.8993288590604,78.5754234579739];

figure;
set(gcf, 'Color', 'w');
fh = 60;
subplot(2,3,1);
plot(pikba(:,1),rescaleTo(pikba(:,2),0,1),'r',mikba(:,1),rescaleTo(mikba(:,2),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]);
title('I\kappaB\alpha','FontName','Arial','FontSize',20);
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 30 60]);
set(gca, 'YTick',[0 0.5 1]);
subplot(2,3,2);
plot(pikbe(:,1),rescaleTo(pikbe(:,2),0,1),'r',mikbe(:,1),rescaleTo(mikbe(:,2),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]);
title('I\kappaB\epsilon','FontName','Arial','FontSize',20);
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 30 60]);
set(gca, 'YTick',[0 0.5 1]);
subplot(2,3,3);
plot(ptnf(:,1),rescaleTo(ptnf(:,2),0,1),'r',mtnf(:,1),rescaleTo(mtnf(:,2),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]);
title('TNF','FontName','Arial','FontSize',20);
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 30 60]);
set(gca, 'YTick',[0 0.5 1]);

fh = 120;
subplot(2,3,4);
plot(tminday(1:fh*60),rescaleTo(y1(1:fh*60,21),0,1),'r',...
     tminday(1:fh*60),rescaleTo(y1(1:fh*60,5),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]); 
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northwest');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 60 120]);
set(gca, 'YTick',[0 0.5 1]);
subplot(2,3,5);
plot(tminday(1:fh*60),rescaleTo(y1(1:fh*60,23),0,1),'r',...
     tminday(1:fh*60),rescaleTo(y1(1:fh*60,10),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]);
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 60 120]);
set(gca, 'YTick',[0 0.5 1]);
subplot(2,3,6);
plot(tminday(1:fh*60),rescaleTo(y1(1:fh*60,27),0,1),'r',...
     tminday(1:fh*60),rescaleTo(y1(1:fh*60,29),0,1),'b','LineWidth',3);
axis([0 fh 0 1.1]); 
xlabel('Time (min)','FontName','Arial','FontSize',20);
ylabel('Normalized units','FontName','Arial','FontSize',20);
% legend('pre-mRNA','mRNA','Location','northeast');
% legend('boxoff');
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 60 120]);
set(gca, 'YTick',[0 0.5 1]);

figure;
set(gcf, 'Color', 'w');
sel = [1 6 11 13 14 15];
fh = 8;
for i=1:length(sel),
    subplot(2,3,i);
    plot(thrsday(1:fh*3600),y1(1:fh*3600,sel(i)),'k','LineWidth',3);
    xlim([0 fh]);
    ylim([0 1.1*max(y1(1:fh*3600,sel(i)))]);
    title(names(sel(i)),'FontName','Arial','FontSize',20);
    xlabel('Time (hrs)','FontName','Arial','FontSize',20);
    ylabel('Concentration (\muM)','FontName','Arial','FontSize',20);
    set(gca,'FontName','Arial','FontSize',18);
    set(gca,'XTick',[0 4 8]);
end

figure;
set(gcf, 'Color', 'w');
sel = [14 15 18 63 65];
fh = 8;
for i=1:length(sel),
    subplot(2,3,i);
    plot(thrsday(1:fh*3600),y1(1:fh*3600,sel(i)),'k','LineWidth',3);
    xlim([0 fh]);
%     ylim([0 1.1*max(y1(1:fh*3600,sel(i)))]);
    title(names(sel(i)),'FontName','Arial','FontSize',20);
    xlabel('Time (hrs)','FontName','Arial','FontSize',20);
    ylabel('Concentration (\muM)','FontName','Arial','FontSize',20);
    set(gca,'FontName','Arial','FontSize',18);
    set(gca,'XTick',[0 4 8]);
end
