
function [] = figure_s2(smax,stmax,sarea,ssteady)


figure;
set(gcf, 'Color', 'w');

xax = -2:(4/30):2;

subplot(2,2,1);
buf = reshape(smax,size(sarea,1)*size(sarea,2),1);
h = hist(buf,xax);
semilogy(xax,h+1,'k','LineWidth',3);
xlim([xax(1) xax(end)]);
title('Peak Magnitude','FontName','Arial','FontSize',20);
xlabel('Sensitivity','FontName','Arial','FontSize',20);
ylabel('Count','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[-2 -1 0 1 2]);
set(gca, 'YTick',[1 10 100 1000 10000 100000]);

xax = -15:(30/30):15;
subplot(2,2,2);
buf = reshape(stmax,size(sarea,1)*size(sarea,2),1);
h = hist(buf,xax);
semilogy(xax,h+1,'k','LineWidth',3);
xlim([xax(1) xax(end)]);
title('Peak Time','FontName','Arial','FontSize',20);
xlabel('Sensitivity','FontName','Arial','FontSize',20);
ylabel('Count','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[-15 -10 -5 0 5 10 15]);
set(gca, 'YTick',[1 10 100 1000 10000 100000]);

xax = -2:(4/30):2;
subplot(2,2,3);
buf = reshape(sarea,size(sarea,1)*size(sarea,2),1);
h = hist(buf,xax);
semilogy(xax,h+1,'k','LineWidth',3);
xlim([xax(1) xax(end)]);
title('AUC','FontName','Arial','FontSize',20);
xlabel('Sensitivity','FontName','Arial','FontSize',20);
ylabel('Count','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[-2 -1 0 1 2]);
set(gca, 'YTick',[1 10 100 1000 10000 100000]);

xax = -10:(12/30):10;
subplot(2,2,4);
buf = reshape(ssteady,size(sarea,1)*size(sarea,2),1);
h = hist(buf,xax);
semilogy(xax,h+1,'k','LineWidth',3);
xlim([xax(1) xax(end)]);
title('Steady State','FontName','Arial','FontSize',20);
xlabel('Sensitivity','FontName','Arial','FontSize',20);
ylabel('Count','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[-10 -5 0 5 10]);
set(gca, 'YTick',[1 10 100 1000 10000 100000]);