
function [] = figure_s4(atnf,anfk,aifn,ail10)

rthours = 24*2;
rtsecsday = 0:100:rthours*3600; % 24hrs in sec
rtminday = rtsecsday/60;
rthrsday = rtminday/60;

steps = 1:10:length(rthrsday);
rtime = rthrsday(steps);

by2 = 1:2:length(rthrsday);
rt2 = rthrsday(by2);

figure(2);
subplot(2,2,1);
hold on
plot(rtime,atnf(steps,2:end),'k');
plot(rtime,atnf(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 8e-4]);
hold off
title('TNF extracelluar','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 4e-4 8e-4]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,2);
hold on
plot(rt2,anfk(by2,2:end),'k');
plot(rt2,anfk(by2,1),'r','LineWidth',3);
xlim([0 6]);
ylim([0 0.06]);
hold off
title('NF-\kappaB nuclear','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 3 6]);
set(gca, 'YTick',[0 0.03 0.06]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,3);
hold on
plot(rtime,aifn(steps,2:end),'k');
plot(rtime,aifn(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 4e-4]);
hold off
title('IFN-\beta extracellular','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 2e-4 4e-4]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,4);
hold on
plot(rtime,ail10(steps,2:end),'k');
plot(rtime,ail10(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 3e-4]);
hold off
title('IL-10 extracellular','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 1.5e-4 3e-4]);
set(gca,'FontName','Arial','FontSize',18);
