
function[] = figure_s5_s8(pars,y0)

% Main program for global sensitivity analysis
% to reproduce figures S4-7 of the Electronic Supplementary Material
% of the paper titled:
% Computational identification and analysis of signaling subnetworks 
% with distinct functional roles in the regulation of TNF production
% by Tomaiuolo at al.

%*** CHANGE HERE TO SPECIFY NUMBER OF GENERATED PARAMETER SETS *** 
iter = 50000; % NUMBER OF RANDOM PARAMETER SETS TO BE GENERATED 

% Parameters;
%Initializes parameters and initial conditions

rangefactor = 2; % Limit for uniform distribution variation for creation of random parameter sets
Param1 = Latinhypercube(pars,rangefactor,iter); % function to create 'iter' number of random parameters sets using Latin Hypercube Sampling technique

disp('parameters generation step is complete');

thours = 24*2;
tsecs_ss = 0:100:100*3600; % 3000 hrs sec
tsecsday = 0:100:thours*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;

options = odeset('AbsTol',1e-8,'RelTol',1e-6);

%Default value in case of error
Y_main_def = zeros(1729,78);
E = zeros(iter,1);

% Initializing parallel pool of matlab cores
% use only if your copy of Matlab support parallel computing.
parfor_progress(iter)
parpool('local',12)

for k = 1:size(Param1,1)
    if(mod(k,100)==0)
        k
    end
    
    try
        local_par_set = Param1(k,:);
        Y_main = Param_var_local(tmin_ss,tminday,y0,local_par_set,options);
        Y_main = real(Y_main);
        Y_main_global{k} = Y_main;
%         parfor_progress
    catch % in case of an error
        E(k) = k;
        Y_main_global{k} = Y_main_def;
%         parfor_progress
    end
end

disp('simulations step is complete');

% Save outputs
save('outputvars','tminday','iter','Param1');
save('Y_main_global','-v7.3');

disp('variables saving step is complete');

%Calculates prcc, significance and sorts the prcc values
[G M] = prcccalculation(Y_main_global,E,Param1);
save('outputvars2','M','G');

disp('prcc calculation step is complete');

%%
% Plot Figures S4-S7
%Change the value in M to plot a different time point

figure(1);
CC_figure(M1(2).prcc); % PRCC at 1 hr
figure(2);
CC_figure(M1(3).prcc); % PRCC at 12 hr
figure(3);
CC_figure(M1(4).prcc); % PRCC at 24 hr
figure(4);
CC_figure(M1(5).prcc); % PRCC at 48 hr
