
function [out] = getPeakTimeAreaSteady(t,y)

% out(1) max
% out(2) tmax
% out(3) area under curve
% out(4) steady state

out = zeros(size(y,2),3);

% detect max, tmax and area
for i=1:size(y,2),
    sy = y(:,i); % single variable vector
    [peak,idx] = max(sy);
    tpeak = t(idx);
    
    if(tpeak < 5) % less than 5 min
        tpeak = 1;
    end
    
    out(i,1) = peak;
    out(i,2) = tpeak;
    out(i,3) = trapz(t,sy);
    out(i,4) = sy(end);
end
