
function [] = plot_fig_6(allik,all10,datapm,datass,datapt)

tsecs_ss = 0:1:3000*3600;
tsecsday = 0:1:24*7*3600;
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;

figure;
set(gcf, 'Color', 'w');

hour1 = 0;
hour2 = 4;
subplot(2,2,1);
plot(tday,allik,'k','LineWidth',2);
xlim([hour1 hour2]);
ylim([0 1.1*max(max(allik))]);
xlabel('Time (days)','FontName','Arial','FontSize',20);
ylabel('[TNF] (\muM)','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 1 2 3 4]);
set(gca,'YTick',[0 1e-4 2e-4 3e-4 4e-4]);

subplot(2,2,2);
plot(tday,all10,'k','LineWidth',2);
xlim([hour1 hour2]);
ylim([0 1.1*max(max(all10))]);
xlabel('Time (days)','FontName','Arial','FontSize',20);
ylabel('[TNF] (\muM)','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
set(gca,'XTick',[0 1 2 3 4]);
set(gca,'YTick',[0 1e-4 2e-4 3e-4]);

levels10 = 0:0.05:1;
levelsik = 0:0.05:1;

subplot(2,2,3);
contourf(levels10,levelsik,datapm);
hcb = colorbar;
set(hcb,'YTick',[4e-4,6e-4,8e-4]);
colormap('jet');
title('TNF peak height (\muM)','FontName','Arial','FontSize',20);
xlabel('IL-10 fold expression','FontName','Arial','FontSize',20);
ylabel('I\kappaB\alpha fold expression','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);

subplot(2,2,4);
vticks = [0:2e-5:14e-5];
contourf(levels10,levelsik,datass,vticks);
hcb = colorbar;
set(hcb,'YTick',[2e-5,8e-5,14e-5]);
colormap('jet');
title('TNF tail height (\muM)','FontName','Arial','FontSize',20);
xlabel('IL-10 fold expression','FontName','Arial','FontSize',20);
ylabel('I\kappaB\alpha fold expression','FontName','Arial','FontSize',20);
set(gca,'FontName','Arial','FontSize',18);
