
function [smax,stmax,sarea,ssteady] = runSA(pars,names,y0)

tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:24*2*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;
lps = 0.5;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

smax = zeros(length(y0),length(pars));
stmax = smax;
sarea = smax;
ssteady = smax;

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
perD = getPeakTimeAreaSteady(tminday,y1);

for i=1:length(pars),
    
    if(i~= 32) % changing Hill coeff to non integers leads to complex numbers
    
        if(mod(i,10)==0)
            disp(num2str(i));
        end

        if(p(i) > 0)
            p = pars;
            % adding 1% of parameter value
            p(i) = 1.01*p(i);
            % LPS chronic
            p(116) = 0; % rl_b_tt
            p(191) = 0; % LPS
            tic
            sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
            y0new = sol.y(:,end);
            tic
            p(116) = 1100; % rl_b_tt
            p(191) = pars(191); % LPS
            y0new(27:31) = 0; % TNF vars
            y0new(54:55) = 0; % TNF vars
            solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
            y1 = deval(solw,tminday)';
            per1 = getPeakTimeAreaSteady(tminday,y1);

            % removing 1% of parameter value
            p = pars;
            p(i) = 0.99*p(i);
            % LPS chronic
            p(116) = 0; % rl_b_tt
            p(191) = 0; % LPS
            tic
            sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
            y0new = sol.y(:,end);
            tic
            p(116) = 1100; % rl_b_tt
            p(191) = pars(191); % LPS
            y0new(27:31) = 0; % TNF vars
            y0new(54:55) = 0; % TNF vars
            solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
            y2 = deval(solw,tminday)'; 
            per2 = getPeakTimeAreaSteady(tminday,y2);

            perA = 50*((per1 - per2)./perD);

            smax(:,i) = perA(:,1);
            stmax(:,i) = perA(:,2);
            sarea(:,i) = perA(:,3);
            ssteady(:,i) = perA(:,4);
        end
    end
end
