
function [smax2X,stmax2X,sarea2X,ssteady2X,atnf,anfk,aifn,ail10] = runSA2X(pars,names,y0)

tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
tsecsday = 0:1:24*2*3600; % 24hrs in sec
tmin_ss = tsecs_ss/60;
tminday = tsecsday/60;
thrsday = tminday/60;
tday = thrsday/24;
lps = 0.5;

options = odeset('AbsTol',1e-8,'RelTol',1e-6,'Events',@my_ode_timeout_event);

smax = zeros(length(y0),length(pars));
stmax = smax;
sarea = smax;
ssteady = smax;

% LPS chronic
p = pars;
p(116) = 0; % rl_b_tt
p(191) = 0; % LPS
tic
sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
y0new = sol.y(:,end);
tic
p(116) = 1100; % rl_b_tt
p(191) = pars(191); % LPS
y0new(27:31) = 0; % TNF vars
y0new(54:55) = 0; % TNF vars
solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
y1 = deval(solw,tminday)';
perD = getPeakTimeAreaSteady(tminday,y1);

steps = 1:100:length(tminday);

atnf = zeros(length(steps),length(pars)*2+1);
anfk = zeros(length(steps),length(pars)*2+1);
aifn = zeros(length(steps),length(pars)*2+1);
ail10 = zeros(length(steps),length(pars)*2+1);

% TNF extracell
atnf(:,1) = y1(steps,31);

% NF-kB nuclear
anfk(:,1) = y1(steps,14);

% IFNb extracell
aifn(:,1) = y1(steps,36);

% IFNb extracell
ail10(:,1) = y1(steps,41);

for i=1:length(pars),
    
    if(mod(i,10)==0)
        disp(num2str(i));
    end
    
    if(i~= 32) % changing Hill coeff to non integers leads to complex numbers
    
        if(mod(i,10)==0)
            disp(num2str(i));
        end

        if(p(i) > 0)
            p = pars;
            % adding 50% of parameter value
            p(i) = 1.5*p(i);
            % LPS chronic
            p(116) = 0; % rl_b_tt
            p(191) = 0; % LPS
            tic
            sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
            y0new = sol.y(:,end);
            tic
            p(116) = 1100; % rl_b_tt
            p(191) = pars(191); % LPS
            y0new(27:31) = 0; % TNF vars
            y0new(54:55) = 0; % TNF vars
            solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
            y1 = deval(solw,tminday)';
            per1 = getPeakTimeAreaSteady(tminday,y1);

            % removing 50% of parameter value
            p = pars;
            p(i) = 0.5*p(i);
            % LPS chronic
            p(116) = 0; % rl_b_tt
            p(191) = 0; % LPS
            tic
            sol = ode15s(@(t,y) tnf_il10_model(t,y,p),tmin_ss,y0,options);
            y0new = sol.y(:,end);
            tic
            p(116) = 1100; % rl_b_tt
            p(191) = pars(191); % LPS
            y0new(27:31) = 0; % TNF vars
            y0new(54:55) = 0; % TNF vars
            solw = ode15s(@(t,y) tnf_il10_model(t,y,p),tminday,y0new,options);
            y2 = deval(solw,tminday)'; 
            per2 = getPeakTimeAreaSteady(tminday,y2);

            perA = 50*((per1 - per2)./perD);

            smax2X(:,i) = perA(:,1);
            stmax2X(:,i) = perA(:,2);
            sarea2X(:,i) = perA(:,3);
            ssteady2X(:,i) = perA(:,4);
            
            % TNF extracell
            atnf(:,2*i - 1) = y1(steps,31);
            atnf(:,2*i) = y2(steps,31); 
            
            % NF-kB nuclear
            anfk(:,2*i) = y1(steps,14);
            anfk(:,2*i + 1) = y2(steps,14);
            
            % IFNb extracell
            aifn(:,2*i) = y1(steps,36);
            aifn(:,2*i + 1) = y2(steps,36);
            
            % IFNb extracell
            ail10(:,2*i) = y1(steps,41);
            ail10(:,2*i + 1) = y2(steps,41);
           
        end
    end
end
