

%%
% variable names and initical conditions

pars = dlmread('params.txt');

names  = {'I\kappaB\alpha','I\kappaB\alphan','I\kappaB\alphaNF\kappaB','I\kappaB\alphaNF\kappaBn','mRNA-I\kappaB\alpha',                ... % 1-5
          'I\kappaB\epsilon','I\kappaB\epsilonn','I\kappaB\epsilonNF\kappaB','I\kappaB\epsilonNF\kappaBn','mRNA-I\kappaB\epsilon',      ... % 6-10
          'A20','mRNA-A20','NF\kappaBc','NF\kappaB',                                                                                    ... % 11-14
          'IKKa','IKKne','IKKi','TAK1a','TAK1ne','TAK1i',                                                                                 ... % 15-20
          'prna-a','srna-a','prna-e','srna-e',                                                                                          ... % 21-24
          'prna-a20','srna-a20','preRNA-TNF\alpha','srna-TNF\alpha','mRNA-TNF\alpha','TNFi',                                            ... % 25-30                                         
          'TNF-\alpha','prna-IFN\beta','srna-i','mRNA-IFN\beta','IFN\betai','IFN-\beta',                                                ... % 31-36
          'preRNA-IL10','srna-il','mRNA-IL10','IL10i','IL-10',                                                                           ... % 37-41       
          'preRNA-Dusp','srna-du','mRNA-Dusp','Dusp',                                                                                   ... % 42-45
          'prna-re','srna-re','mRNA-Rep','Rep',                                                                                         ... % 46-49
          'TLR4','LPS/TLR4','LPS/TLR4i','LPS/TLR4d','TNFR','TnfTnfr',                                                                   ... % 50-55
          'Ifnr','Il10r','MyD88','Trif','Adapter','Tbk1',                                                                               ... % 56-61
          'Mkk','P38','Erka','MSK1','MSK2','Jak1','Pi3k','Gsk3','Jak1il',                                                           ... % 62-71
          'pIRF3','pIRF3n','pCreb','pCrebn','pStat3','pStat3n','pATF','pATFn'};                                                               % 72-79
      
y0 = zeros(78,1); % all species start at zero by default

% Set initial values for non-zero species
y0(14)   = 0.125;  % nfkbn
y0(16)   = 0.1;    % IKK_off
y0(19)   = 0.1;    % TAK1n
y0(50)   = 0.1;    % TLR4

%% 
% run the simulations to obatain the figures in the manuscript
% uncomment (by removing the % at the beginning) each line to reproduce
% each figure

% figure_2(pars,names,y0);
% figure_3(pars,names,y0);
% figure_4(pars,names,y0);
% figure_5(pars,names,y0);
% [tmat,datapm,datapt,datass,allik,all10] = figure_6(pars,names,y0);
% plot_fig_6(allik,all10,datapm,datass,datapt);
% figure_7(pars,names,y0);
% figure_s1(pars,names,y0);
% [smax,stmax,sarea,ssteady] = runSA(pars,names,y0);
% figure_s2(smax,stmax,sarea,ssteady);
% [smax2X,stmax2X,sarea2X,ssteady2X] = runSA2X(pars,names,y0);
% figure_s3(smax2X,stmax2X,sarea2X,ssteady2X);
% figure_s4(atnf,anfk,aifn,ail10);
% figure_s5_s8(pars,y0); % may take up to 2-4 days to run
% plot_fig_s8(datapt);


%%

% [smax2X,stmax2X,sarea2X,ssteady2X,atnf,anfk,aifn,ail10] = runSA2X(pars,names,y0);

% tsecs_ss = 0:1:3000*3600; % 3000 hrs sec
% tsecsday = 0:1:24*2*3600; % 24hrs in sec
% tmin_ss = tsecs_ss/60;
% tminday = tsecsday/60;
% thrsday = tminday/60;

rthours = 24*2;
rtsecsday = 0:100:rthours*3600; % 24hrs in sec
rtminday = rtsecsday/60;
rthrsday = rtminday/60;

steps = 1:10:length(rthrsday);
rtime = rthrsday(steps);

by2 = 1:2:length(rthrsday);
rt2 = rthrsday(by2);

% ylim([0 1.1]);
% title(names(vars),'FontName','Arial','FontSize',20);
% ylabel('Normalized units','FontName','Arial','FontSize',16);
% % legend('Exp','Sim','Location','northeast');
% % legend('boxoff');
% set(gca,'FontName','Arial','FontSize',16);
% set(gca,'XTickLabel',{'WT','TRIF','IRF3','IFNAR'});
% set(gca, 'YTick',[0 0.5 1]);

figure(2);
subplot(2,2,1);
hold on
% plot(rthrsday,atnf(:,2:end),'k');
% plot(rthrsday,atnf(:,1),'r','LineWidth',3);
plot(rtime,atnf(steps,2:end),'k');
plot(rtime,atnf(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 8e-4]);
hold off
title('TNF extracelluar','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 4e-4 8e-4]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,2);
hold on
plot(rt2,anfk(by2,2:end),'k');
plot(rt2,anfk(by2,1),'r','LineWidth',3);
xlim([0 6]);
ylim([0 0.06]);
hold off
title('NF-\kappaB nuclear','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 3 6]);
set(gca, 'YTick',[0 0.03 0.06]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,3);
hold on
plot(rtime,aifn(steps,2:end),'k');
plot(rtime,aifn(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 4e-4]);
hold off
title('IFN-\beta extracellular','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 2e-4 4e-4]);
set(gca,'FontName','Arial','FontSize',18);
subplot(2,2,4);
hold on
plot(rtime,ail10(steps,2:end),'k');
plot(rtime,ail10(steps,1),'r','LineWidth',3);
xlim([0 48]);
ylim([0 3e-4]);
hold off
title('IL-10 extracellular','FontName','Arial','FontSize',20);
ylabel('Concentration \muM','FontName','Arial','FontSize',20);
xlabel('Time (hrs)','FontName','Arial','FontSize',20);
set(gca, 'XTick',[0 24 48]);
set(gca, 'YTick',[0 1.5e-4 3e-4]);
set(gca,'FontName','Arial','FontSize',18);

