

function dy = tnf_il10_model(t,y,pars)

dy = zeros(78,1);

IkBa            = y(1);  % concentration of IkBa
IkBan           = y(2);  % concentration of nuclear IkBa
IkBaNFkB        = y(3);  % concentration of IkBa-NFkB complex
IkBaNFkBn       = y(4);  % concentration of nuclear IkBa-NFkB complex
IkBat           = y(5);  % concentration of IkBa transcript
IkBe            = y(6);  % concentration of IkBe
IkBen           = y(7);  % concentration of nuclear IkBe
IkBeNFkB        = y(8);  % concentration of IkBe-NFkB complex
IkBeNFkBn       = y(9);  % concentration of nuclear IkBe-NFkB complex
IkBet           = y(10); % concentration of IkBe transcript
a20             = y(11); % concentration of A20
a20t            = y(12); % concentration of A20 transcript
NFkB            = y(13); % concentration of NFkB
NFkBn           = y(14); % concentration of nuclear NFkB
IKKa            = y(15); % concentration of active IKK
IKKne           = y(16); % concentration of neutral IKK
IKKi            = y(17); % concentration of inactive IKK
TAK1a           = y(18); % concentration of active TAK1
TAK1ne          = y(19); % concentration of neutral TAK1
TAK1i           = y(20); % concentration of inactive TAK1

% IkBa
prna_a          = y(21); % concentration of unspliced IkBa transcript 
srna_a          = y(22); % concentration of unspliced IkBa transcript bound to the spliceosome
% IkBe
prna_e          = y(23); % concentration of unspliced IkBe transcript 
srna_e          = y(24); % concentration of unspliced IkBe transcript bound to the spliceosome
% A20
prna_a20        = y(25); % concentration of unspliced A20 transcript bound
srna_a20        = y(26); % concentration of unspliced A20 transcript bound to the spliceosome
% TNF
prna_t          = y(27); % concentration of unspliced TNF transcript
srna_t          = y(28); % concentration of unspliced TNF transcript bound to the spliceosome
TNFt            = y(29); % concentration of spliced TNF transcript 
TNFi            = y(30); % concentration of intracellular TNF
TNFe            = y(31); % concentration of extracellular TNF
% IFNb
prna_i          = y(32); % concentration of unspliced IFNb transcript
srna_i          = y(33); % concentration of unspliced IFNb transcript bound to the spliceosome
IFNbt           = y(34); % concentration of spliced IFNb transcript 
IFNbi           = y(35); % concentration of intracellular IFNb
IFNbe           = y(36); % concentration of extracellular IFNb
% IL-10
prna_il         = y(37); % concentration of unspliced IL10 transcript
srna_il         = y(38); % concentration of unspliced IL10 transcript bound to the spliceosome
IL10t           = y(39); % concentration of spliced IL10 transcript
IL10i           = y(40); % concentration of intracellular IL10
IL10e           = y(41); % concentration of extracellular IL10
% DUSP1
prna_du         = y(42); % concentration of unspliced DUSP1 transcript
srna_du         = y(43); % concentration of unspliced DUSP1 transcript bound to the spliceosome
Duspt           = y(44); % concentration of spliced DUSP1 transcript
Dusp            = y(45); % concentration of intracellular DUSP1
% Rep
prna_re         = y(46); % concentration of unspliced REP transcript
srna_re         = y(47); % concentration of unspliced REP transcript bound to the spliceosome
Rept            = y(48); % concentration of spliced REP transcript
Rep             = y(49); % concentration of intracellular REP

Tlr4            = y(50); % concentration of TLR4 receptor
LpsTlr4         = y(51); % concentration of TLR4 receptor bound to LPS
LpsTlr4i        = y(52); % concentration of internalized TLR4 receptor bound to LPS 
LpsTlr4d        = y(53); % concentration of degraded TLR4 receptor bound to LPS
Tnfr            = y(54); % concentration of TNF receptor
TnfTnfr         = y(55); % concentration of TNF receptor bound to TNF
Ifnr            = y(56); % concentration of IFNb receptor
Il10r           = y(57); % concentration of IL-10 receptor
MyD88           = y(58); % concentration of MyD88 
Trif            = y(59); % concentration of TRIF 
Traf6           = y(60); % concentration of TRAF6
Tbk1            = y(61); % concentration of TBK1
Mkk             = y(62); % concentration of MKK3 and MKK6
P38a            = y(63); % concentration of active P38
Erka            = y(64); % concentration of active ERK1 and ERK2
Msk1            = y(65); % concentration of MSK1
Msk2            = y(66); % concentration of MSK2
Jak1            = y(67); % concentration of JAK1
Pi3k            = y(68); % concentration of PI3K
Gsk3            = y(69); % concentration of GSK3
jak1il          = y(70); % concentration of JAK1 activated by IL10 receptor
pIrf3           = y(71); % concentration of phosphorylated IRF3
pIrf3n          = y(72); % concentration of nuclear phosphorylated IRF3
pCreb           = y(73); % concentration of phosphorylated CREB
pCrebn          = y(74); % concentration of nuclear phosphorylated CREB
pStat3          = y(75); % concentration of phosphorylated STAT3
pStat3n         = y(76); % concentration of nuclear phosphorylated STAT3
pAtf            = y(77); % concentration of phosphorylated ATF
pAtfn           = y(78); % concentration of nuclear phosphorylated ATF

% pars
in_a            = pars(1); % rate of nuclear import of IkBa 
in_e            = pars(2); % rate of nuclear import of IkBe 
ex_a            = pars(3); % rate of nuclear export of IkBa
ex_e            = pars(4); % rate of nuclear export of IkBe
in_2an          = pars(5); % rate of nuclear import of IkBa:NFkB complex
in_2en          = pars(6); % rate of nuclear import of IkBe:NFkB complex
ex_2an          = pars(7); % rate of nuclear export of IkBa:NFkB complex
ex_2en          = pars(8); % rate of nuclear export of IkBe:NFkB complex
in_n            = pars(9); % rate of nuclear import of NFkB
ex_n            = pars(10); % rate of nuclear export of NFkB
pd_n_a          = pars(11); % rate of degradation of nuclear IkBa
pd_n_e          = pars(12); % rate of degradation of nuclear IkBe
pd_c_2an        = pars(13); % rate of degradation of NFkB:IkBa complex
pd_c_2en        = pars(14); % rate of degradation of NFkB:IkBe complex
pd_n_2an        = pars(15); % rate of degradation of nuclear NFkB:IkBa complex
pd_n_2en        = pars(16); % rate of degradation of nuclear NFkB:IkBe complex
a_c_an          = pars(17); % rate of NFkB:IkBa complex association
a_c_en          = pars(18); % rate of NFkB:IkBe complex association
a_n_an          = pars(19); % rate of nuclear NFkB:IkBa complex association
a_n_en          = pars(20); % rate of nuclear NFkB:IkBe complex association
d_c_an          = pars(21); % rate of NFkB:IkBa complex degradation 
d_c_en          = pars(22); % rate of NFkB:IkBe complex degradation
d_n_an          = pars(23); % rate of nuclear NFkB:IkBa complex degradation
d_n_en          = pars(24); % rate of nuclear NFkB:IkBe complex degradation
pd_c_2ai        = pars(25); % rate of IKK mediated IkBa degradation
pd_c_2ei        = pars(26); % rate of IKK mediated IkBe degradation
pd_c_3ain       = pars(27); % rate of IKK mediated NFkB:IkBa degradation
pd_c_3ein       = pars(28); % rate of IKK mediated NFkB:IkBe degradation
cnvr            = pars(29); % cell to nucleus volume ratio
mmVmax          = pars(30); % maximum rate of Michaelis-Menten function
mmKm            = pars(31); % half saturation of Michaelis-Menten function
mmHc            = pars(32); % Hill coefficient
arep            = pars(33); % value of REPressor function when REP=0 
brep            = pars(34); % threshold of REPressor function 
krep            = pars(35); % inhibition strenght of REPressor function 
prs_an          = pars(36); % rate of NFkB mediated IkBa gene transcription 
prd_a           = pars(37); % rate of unspliced IkBa transcript degradation 
a_n_spa         = pars(38); % rate of association of unspliced IkBa transcript with spliceosome complex
prs_a           = pars(39); % basal rate of IkBa transcription
rs_a            = pars(40); % rate of dissociation of spliced IkBa transcript from spliceosome complex
rd_a            = pars(41); % rate of degradation of spliced IkBa transcript
ps_c_a          = pars(42); % rate of IkBa protein synthesis
pd_c_a          = pars(43); % rate of IkBa protein degradation
% IkBe
prs_en          = pars(44); % rate of NFkB mediated IkBe gene transcription
prd_e           = pars(45); % rate of unspliced IkBe transcript degradation
a_n_spe         = pars(46); % rate of association of unspliced IkBe transcript with spliceosome complex
prs_e           = pars(47); % basal rate of IkBae transcription
rs_e            = pars(48); % rate of dissociation of spliced IkBe transcript from spliceosome complex
rd_e            = pars(49); % rate of degradation of spliced IkBe transcript
ps_c_e          = pars(50); % rate of IkBe protein synthesis
pd_c_e          = pars(51); % rate of IkBe protein degradation
% A20
prs_a20n        = pars(52); % rate of NFkB mediated A20 gene transcription
prd_a20         = pars(53); % rate of unspliced A20 transcript degradation
a_n_spa20       = pars(54); % rate of association of unspliced A20 transcript with spliceosome complex
prs_a20         = pars(55); % basal rate of A20 transcription 
rs_a20          = pars(56); % rate of dissociation of spliced A20 transcript from spliceosome complex
rd_a20          = pars(57); % rate of degradation of spliced A20 transcript
ps_c_a20        = pars(58); % rate of A20 protein synthesis
pd_c_a20        = pars(59); % rate of A20 protein degradation
% TNF
prs_t           = pars(60); % rate of NFkB mediated TNF gene transcription
prd_t           = pars(61); % rate of unspliced TNF transcript degradation
a_n_spt         = pars(62); % rate of association of unspliced TNF transcript with spliceosome complex
rs_t            = pars(63); % rate of dissociation of spliced TNF transcript from spliceosome complex
rd_t            = pars(64); % rate of degradation of spliced TNF transcript
ps_c_t          = pars(65); % rate of TNF protein synthesis
pd_c_t          = pars(66); % rate of TNF protein degradation
ex_tnf          = pars(67); % rate of TNF export to extracellular compartment 
pd_e_t          = pars(68); % rate of extracellular TNF protein degradation 
%IFNb
prs_ifn         = pars(69); % rate of IRF3 mediated IFNb gene transcription
prd_ifn         = pars(70); % rate of unspliced IFNb transcript degradation
a_n_spifn       = pars(71); % rate of association of unspliced IFNb transcript with spliceosome complex
rs_ifn          = pars(72); % rate of dissociation of spliced IFNb transcript from spliceosome complex
rd_ifn          = pars(73); % rate of degradation of spliced IFNb transcript
ps_c_ifn        = pars(74); % rate of IFNb protein synthesis
pd_c_ifn        = pars(75); % rate of IFNb protein degradation
ex_ifn          = pars(76); % rate of IFNb export to extracellular compartment
pd_e_ifn        = pars(77); % rate of extracellular IFNb protein degradation
% IL10
prs_il          = pars(78); % rate of CREB mediated IL10 gene transcription
prd_il          = pars(79); % rate of unspliced IL10 transcript degradation
a_n_spil        = pars(80); % rate of association of unspliced IL10 transcript with spliceosome complex
rs_il           = pars(81); % rate of dissociation of spliced IL10 transcript from spliceosome complex
rd_il           = pars(82); % rate of degradation of spliced IL10 transcript
ps_c_il         = pars(83); % rate of IL10 protein synthesis
pd_c_il         = pars(84); % rate of IL10 protein degradation
ex_il           = pars(85); % rate of IL10 export to extracellular compartment
pd_e_il         = pars(86); % rate of extracellular IL10 protein degradation
% DUSP1
prs_du          = pars(87); % rate of ATF mediated DUSP1 gene transcription
prd_du          = pars(88); % rate of unspliced DUSP1 transcript degradation
a_n_spdu        = pars(89); % rate of association of unspliced DUSP1 transcript with spliceosome complex
rs_du           = pars(90); % rate of dissociation of spliced DUSP1 transcript from spliceosome complex
rd_du           = pars(91); % rate of degradation of spliced DUSP1 transcript
ps_c_du         = pars(92); % rate of DUSP1 protein synthesis
pd_c_du         = pars(93); % rate of DUSP1 protein degradation
% REP(ressor)
prs_re          = pars(94); % rate of STAT3 mediated REP gene transcription
prd_re          = pars(95); % rate of unspliced REP transcript degradation
a_n_spre        = pars(96); % rate of association of unspliced REP transcript with spliceosome complex
rs_re           = pars(97); % rate of dissociation of spliced REP transcript from spliceosome complex
rd_re           = pars(98); % rate of degradation of spliced REP transcript
ps_c_re         = pars(99); % rate of REP protein synthesis
pd_c_re         = pars(100); % rate of REP protein degradation

ka              = pars(101); % rate TAK1 mediated IKK activation 
a20ina          = pars(102); % strenght of A20 mediated IKK inactivation
ki              = pars(103); % baseline rate of IKK inactivation
kp              = pars(104); % baseline rate of transition from IKKi to IKKne
tak1_nat        = pars(105); % rate of TNF mediated TAK1 activation  
tak1_nat6       = pars(106); % rate of TRAF6 mediated TAK1 activation 
tak1_ai         = pars(107); % baseline rate of TAK1 inactivation 
tak1_in         = pars(108); % baseline rate of transition from TAK1i to TAK1ne

%LPS/TLR4
rl_b_tl         = pars(109); % rate of asssociation of LPS to TLR4
rl_u_tl         = pars(110); % rate of dissociation of LPS to TLR4
rl_i_tl         = pars(111); % rate of internalization of the LPS:TLR4 complex
rl_r_tl         = pars(112); % recycling rate of internalized TLR4 receptor
rl_d_tl         = pars(113); % rate of degradation of internalized LPS:TLR4 complex
% TNF-TNFR
tnfrtot         = pars(114); % total TNFR
rl_u_tt         = pars(115); % rate of dissociation of TNF:TNFR complex
rl_b_tt         = pars(116); % rate of association of TNF to TNFR
rl_d_tt         = pars(117); % rate of degradation of TNF:TNFR complex
rl_r_tt         = pars(118); % rate of reciclying of TNF:TNFR complex
rl_i_tt         = pars(119); % rate of internalization of TNF:TNFR complex
rl_i_lt         = pars(120); % rate of LPS induced TNFR internalization 
% IFN-IFNAR
ifnrtot         = pars(121); % total IFNAR
rl_b_ifif       = pars(122); % rate of asssociation of IFNb to IFNAR
rl_u_ifif       = pars(123); % rate of dissociation of IFNb:IFNAR complex
% IL10-IL10R
il10rtot        = pars(124); % total IL10R
rl_b_ilil       = pars(125); % rate of asssociation of IL10 to IL10R
rl_u_ilil       = pars(126); % rate of dissociation of IL10:IL10R complex
% MyD88
myd88tot        = pars(127); % total MyD88
pa_c_my         = pars(128); % rate of LPS:TLR4 induced MyD88 acticvation
pd_c_my         = pars(129); % baseline rate of MyD88 inactivation
%TRIF
triftot         = pars(130); % total TRIF
pa_c_tr         = pars(131); % rate of internalized LPS:TLR4 induced TRIF acticvation
pd_c_tr         = pars(132); % baseline rate of TRIF inactivation
% Traf6
traf6Tot        = pars(133); % total TRAF6
a_c_am          = pars(134); % rate of MyD88 induced TRAF6 activation
a_c_at          = pars(135); % rate of TRIF induced TRAF6 activation
d_c_a           = pars(136); % baseline rate of TRAF6 inactivation
% TBK
tbktot          = pars(137); % total TBK 
a_c_tt          = pars(138); % rate of TRIF induced TBK activation 
d_c_tt          = pars(139); % baseline rate of TBK inactivation
% MKK
mkktot          = pars(140); % total MKK
a_c_tm          = pars(141); % rate of TAK1 induced MKK activation
d_c_tm          = pars(142); % baseline rate of MKK inactivation
% P38
p38tot          = pars(143); % total P38
a_c_mp          = pars(144); % rate of MKK induced P38 activation
d_c_mp          = pars(145); % baseline rate of P38 inactivation
d_c_dp          = pars(146); % rate of DUSP1 induced P38 inactivation
% ERK
erktot          = pars(147); % total ERK
a_c_me          = pars(148); % rate of MKK induced ERK activation 
d_c_me          = pars(149); % baseline rate of ERK inactivation
% MSK1
msk1tot         = pars(150); % total MSK1
a_c_pm          = pars(151); % rate of P38 induced MSK1 activation
d_c_pm          = pars(152); % baseline rate of MSK1 inactivation
% MSK2
msk2tot         = pars(153); % total MSK2
a_c_em          = pars(154); % rate of ERK induced MSK2 activation
d_c_em          = pars(155); % baseline rate of MSK2 inactivation
% JAK1
jak1tot         = pars(156); % total JAK1
a_c_ij          = pars(157); % rate of IFNAR induced JAK1 activation
d_c_ij          = pars(158); % baseline rate of JAK1 inactivation
% PI3K
pi3ktot         = pars(159); % total PI3K
a_c_jp          = pars(160); % rate of JAK1 induced PI3K activation
d_c_jp          = pars(161); % baseline rate of PI3K inactivation
% GSK3
gsk3tot         = pars(162); % total GSK3
a_c_pg          = pars(163); % rate of PI3K induced GSK3 activation 
d_c_pg          = pars(164); % baseline rate of GSK3 inactivation
% JAK3
jak1iltot       = pars(165); % total JAK1il
a_c_ilj         = pars(166); % rate of IL10R induced JAK1il activation
d_c_ilj         = pars(167); % baseline rate of JAK1il inactivation
% IRF3
irf3tot         = pars(168); % total IRF3
a_c_ti          = pars(169); % rate of association (phosphorylation) of IRF3 to TBK
dr_c_i          = pars(170); % baseline rate of dissociation (dephosphorylation) of IRF3
in_i            = pars(171); % rate of nuclear import ot pIRF3
ex_i            = pars(172); % rate of nuclear export ot pIRF3n
% CREB
crebtot         = pars(173); % total CREB
a_c_m1c         = pars(174); % rate of association (phosphorylation) of CREB to MSK1
a_c_m2c         = pars(175); % rate of association (phosphorylation) of CREB to MSK2
d_c_gc          = pars(176); % rate of GSK3 induced CREB inactivation
in_c            = pars(177); % rate of nuclear import ot pCREB
ex_c            = pars(178); % rate of nuclear export ot pCREBn
d_c_c           = pars(179); % baseline rate of dephosphorylation of CREB
% STAT3
stat3tot        = pars(180); % total STAT3
a_c_js          = pars(181); % rate of association (phosphorylation) of STAT3 to JAK1il
d_c_js          = pars(182); % baseline ra of dephosphorylation of STAT3 
in_s            = pars(183); % rate of nuclear import ot pSTAT3
ex_s            = pars(184); % rate of nuclear export ot pSTAT3n
% ATF
atftot          = pars(185); % total ATF
a_c_m1a         = pars(186); % rate of association (phosphorylation) of ATF to MSK1
a_c_m2a         = pars(187); % rate of association (phosphorylation) of ATF to MSK2
d_c_ab          = pars(188); % baseline rate of dephosphorylation of ATF
in_at           = pars(189); % rate of nuclear import ot pATF
ex_at           = pars(190); % rate of nuclear export ot pATFn

LPS             = pars(191); % LPS concentration
kmuM            = pars(192); % converts internal uM conc of 100k cells to external uM conc in 1 mL

% functions
fCREB = mmfn(pCrebn,mmVmax,mmKm,mmHc);
fATF = mmfn(pAtfn,mmVmax,mmKm,mmHc);
fRep = mmrfn(Rep,arep,brep,krep);
fNFkB = mmfn(NFkBn,mmVmax,mmKm,mmHc);
fStat3 = mmfn(pStat3n,mmVmax,mmKm,mmHc);
fIRF3 = mmfn(pIrf3n,mmVmax,mmKm,mmHc);
fMd88 = mmfn(MyD88,mmVmax,mmKm,mmHc);
fTrif = mmfn(Trif,mmVmax,mmKm,mmHc);
tnf_fNFkB = fNFkB*fRep;
fLPS = mmfn(LpsTlr4d,mmVmax,mmKm,mmHc);

%=======================================================
% ODEs
%=======================================================

% IkB/NF-kB module from Hoffman 2008
% IkBa ode
dy(1) = ps_c_a*IkBat - in_a*IkBa + ex_a*(1/cnvr)*IkBan - a_c_an*IkBa*NFkB + d_c_an*IkBaNFkB - pd_c_a*IkBa - pd_c_2ai*IkBa*IKKa;
% IkBan ode
dy(2) = in_a*IkBa - ex_a*(1/cnvr)*IkBan - a_n_an*IkBan*NFkBn + d_n_an*IkBaNFkBn - pd_n_a*IkBan;
% IkBaNFkB ode
dy(3) = - in_2an*IkBaNFkB + ex_2an*(1/cnvr)*IkBaNFkBn + a_c_an*IkBa*NFkB - d_c_an*IkBaNFkB - pd_c_2an*IkBaNFkB - pd_c_3ain*IkBaNFkB*IKKa;
% IkBaNFkBn ode
dy(4) = in_2an*IkBaNFkB - ex_2an*(1/cnvr)*IkBaNFkBn + a_n_an*IkBan*NFkBn - d_n_an*IkBaNFkBn - pd_n_2an*IkBaNFkBn;
% IkBat ode
dy(5) = rs_a*srna_a - rd_a*IkBat;
% IkBe ode 
dy(6) = ps_c_e*IkBet - in_e*IkBe + ex_e*(1/cnvr)*IkBen - a_c_en*IkBe*NFkB + d_c_en*IkBeNFkB - pd_c_e*IkBe - pd_c_2ei*IkBe*IKKa;
% IkBen ode 
dy(7) = in_e*IkBe - ex_e*(1/cnvr)*IkBen - a_n_en*IkBen*NFkBn + d_n_en*IkBeNFkBn - pd_n_e*IkBen;
% IkBeNFkB
dy(8) = - in_2en*IkBeNFkB + ex_2en*(1/cnvr)*IkBeNFkBn + a_c_en*IkBe*NFkB - d_c_en*IkBeNFkB - pd_c_2en*IkBeNFkB - pd_c_3ein*IkBeNFkB*IKKa;
% IkBeNFkBn ode
dy(9) = in_2en*IkBeNFkB - ex_2en*(1/cnvr)*IkBeNFkBn + a_n_en*IkBen*NFkBn - d_n_en*IkBeNFkBn - pd_n_2en*IkBeNFkBn;
% IkBet ode
dy(10) = rs_e*srna_e - rd_e*IkBet;
% a20 ode
dy(11) = ps_c_a20*a20t - pd_c_a20*a20;
% a20t ode
dy(12) = rs_a20*srna_a20 - rd_a20*a20t;
% NFkB ode
dy(13) = - in_n*NFkB + ex_n*(1/cnvr)*NFkBn - a_c_an*IkBa*NFkB - a_c_en*IkBe*NFkB + d_c_an*IkBaNFkB + d_c_en*IkBeNFkB + pd_c_2an*IkBaNFkB + pd_c_2en*IkBeNFkB + pd_c_3ain*IkBaNFkB*IKKa + pd_c_3ein*IkBeNFkB*IKKa;
% NFkBn ode
dy(14) = in_n*NFkB - ex_n*(1/cnvr)*NFkBn - a_n_an*IkBan*NFkBn - a_n_en*IkBen*NFkBn + d_n_an*IkBaNFkBn + d_n_en*IkBeNFkBn + pd_n_2an*IkBaNFkBn + pd_n_2en*IkBeNFkBn; 

% IKK module from White 2009
% IKKa ode
dy(15) = ka*IKKne*TAK1a - ki*IKKa - a20ina*IKKa*a20;
% IKKne ode
dy(16) = - ka*IKKne*TAK1a + kp*IKKi;
% IKKi ode
dy(17) = ki*IKKa + a20ina*IKKa*a20 - kp*IKKi;

% TAK1 module equation modified from Lipniacki BMC Bioinfo 2007 and Fallahi Front in Physiol 2012
% TAK1 ode
% TAK1a
dy(18) = (tak1_nat*TnfTnfr + tak1_nat6*Traf6)*TAK1ne - tak1_ai*TAK1a;
% TAK1ne
dy(19) = tak1_in*TAK1i - (tak1_nat*TnfTnfr + tak1_nat6*Traf6)*TAK1ne;
% TAK1i
dy(20) = tak1_ai*TAK1a - tak1_in*TAK1i;


% prna_a ode
dy(21) = prs_an*fNFkB - prd_a*prna_a - a_n_spa*prna_a + prs_a;
% srna_a ode
dy(22) = a_n_spa*prna_a - rs_a*srna_a;

% prna_e ode
dy(23) = prs_en*fNFkB - prd_e*prna_e - a_n_spe*prna_e + prs_e;
% srna_e ode
dy(24) = a_n_spe*prna_e - rs_e*srna_e;

% prna_a20 ode
dy(25) = prs_a20n*fNFkB - prd_a20*prna_a20 - a_n_spa20*prna_a20 + prs_a20;
% srna_a20 ode
dy(26) = a_n_spa20*prna_a20 - rs_a20*srna_a20;

% prna_t ode
dy(27) = prs_t*tnf_fNFkB - prd_t*prna_t - a_n_spt*prna_t;
% srna_t ode
dy(28) = a_n_spt*prna_t - rs_t*srna_t;
% TNFt ode
dy(29) = rs_t*srna_t - rd_t*TNFt;
% TNFi ode
dy(30) = ps_c_t*TNFt - pd_c_t*TNFi - ex_tnf*TNFi; 
% TNFe ode in nM
dy(31) = ex_tnf*kmuM*TNFi - pd_e_t*TNFe;
% prna_i ode
dy(32) = prs_ifn*fIRF3 - prd_ifn*prna_i - a_n_spifn*prna_i;
% srna_i ode
dy(33) = a_n_spifn*prna_i - rs_ifn*srna_i;
% IFNbt ode
dy(34) = rs_ifn*srna_i - rd_ifn*IFNbt;
% IFNb ode
dy(35) = ps_c_ifn*IFNbt - pd_c_ifn*IFNbi - ex_ifn*IFNbi; 
% IFNbe ode
dy(36) = ex_ifn*kmuM*IFNbi - pd_e_ifn*IFNbe;
% prna_il ode
dy(37) = prs_il*fCREB - prd_il*prna_il - a_n_spil*prna_il;
% srna_il ode
dy(38) = a_n_spil*prna_il - rs_il*srna_il;
% IL10t ode
dy(39) = rs_il*srna_il - rd_il*IL10t;
% IL10i ode
dy(40) = ps_c_il*IL10t - pd_c_il*IL10i - ex_il*IL10i;
% IL10e ode
dy(41) = ex_il*kmuM*IL10i - pd_e_il*IL10e;
% prna_du ode
dy(42) = prs_du*fATF - prd_du*prna_du - a_n_spdu*prna_du;
% srna_du ode
dy(43) = a_n_spdu*prna_du - rs_du*srna_du;
% DUSP1t ode
dy(44) = rs_du*srna_du - rd_du*Duspt;
% DUSP1 ode
dy(45) = ps_c_du*Duspt - pd_c_du*Dusp;
% prna_re ode
dy(46) = prs_re*fStat3 - prd_re*prna_re - a_n_spre*prna_re;
% srna_re ode
dy(47) = a_n_spre*prna_re - rs_re*srna_re;
% Rept ode
dy(48) = rs_re*srna_re - rd_re*Rept;
% Rep ode
dy(49) = ps_c_re*Rept - pd_c_re*Rep;
% TL4 ode
dy(50) = rl_r_tl*LpsTlr4d - rl_b_tl*LPS*Tlr4 + rl_u_tl*LpsTlr4;
% LPS/TLR4 ode
dy(51) = rl_b_tl*LPS*Tlr4 - rl_u_tl*LpsTlr4 - rl_i_tl*LpsTlr4;
% LPS/TLR4 internalized ode
dy(52) = rl_i_tl*LpsTlr4 - rl_d_tl*LpsTlr4i;
% LPS/TLR4 inactive
dy(53) = rl_d_tl*LpsTlr4i - rl_r_tl*LpsTlr4d;
% TNF dynamics from Covert Nature 2010
Tnfri = tnfrtot - Tnfr - TnfTnfr;
% TNFR ode
dy(54) =  rl_u_tt*TnfTnfr - rl_b_tt*TNFe*Tnfr + rl_r_tt*Tnfri - rl_i_lt*fLPS*Tnfr;
% TNFR-TNF ode
dy(55) = - rl_u_tt*TnfTnfr + rl_b_tt*TNFe*Tnfr - rl_i_tt*TnfTnfr - rl_d_tt*TnfTnfr;
% IFN/IFNAR ode
dy(56) = rl_b_ifif*IFNbe*(ifnrtot - Ifnr) - rl_u_ifif*Ifnr;
% IL10/IL10R ode
dy(57) = rl_b_ilil*IL10e*(il10rtot - Il10r) - rl_u_ilil*Il10r;
% active MyD88 ode
dy(58) = pa_c_my*LpsTlr4*(myd88tot - MyD88) - pd_c_my*MyD88;
% active TRIF ode
dy(59) = pa_c_tr*LpsTlr4i*(triftot - Trif) - pd_c_tr*Trif;
% Traf6 ode
dy(60) = (a_c_am*fMd88 + a_c_at*fTrif)*(traf6Tot - Traf6) - d_c_a*Traf6;
% TBK1a ode
dy(61) = a_c_tt*(tbktot - Tbk1)*Trif - d_c_tt*Tbk1;
% MKK ode
dy(62) = a_c_tm*TAK1a*(mkktot - Mkk) - d_c_tm*Mkk;
% P38 ode
dy(63) = a_c_mp*Mkk*(p38tot - P38a) - d_c_mp*P38a - d_c_dp*P38a*Dusp;
% Erk ode
dy(64) = a_c_me*Mkk*(erktot - Erka) - d_c_me*Erka;
% MSK1 ode
dy(65) = a_c_pm*P38a*(msk1tot - Msk1) - d_c_pm*Msk1;
% MSK2 ode
dy(66) = a_c_em*Erka*(msk2tot - Msk2) - d_c_em*Msk2;
% JAK1 ode
dy(67) = a_c_ij*Ifnr*(jak1tot - Jak1) - d_c_ij*Jak1;
% PI3K ode
dy(68) = a_c_jp*Jak1*(pi3ktot - Pi3k) - d_c_jp*Pi3k;
% GSK3 ode
dy(69) = a_c_pg*Pi3k*(gsk3tot - Gsk3) - d_c_pg*Gsk3;
% JAK1il ode
dy(70) = a_c_ilj*Il10r*(jak1iltot - jak1il) - d_c_ilj*jak1il;
% IRF3 ode
Irf3i = irf3tot - (pIrf3 + pIrf3n);
% pIRF3 ode
dy(71) = a_c_ti*Tbk1*Irf3i - dr_c_i*pIrf3 - in_i*pIrf3 + ex_i*(1/cnvr)*pIrf3n;
% pIRF3n ode
dy(72) = in_i*pIrf3 - ex_i*(1/cnvr)*pIrf3n - dr_c_i*pIrf3n;
% CREB ode
Crebf = crebtot - (pCreb + pCrebn);
% pCREB ode
dy(73) = (a_c_m1c*Msk1 + a_c_m2c*Msk2)*Crebf + d_c_gc*Crebf*Gsk3 - in_c*pCreb + ex_c*(1/cnvr)*pCrebn - d_c_c*pCreb;
% pCREBn ode
dy(74) = in_c*pCreb - ex_c*(1/cnvr)*pCrebn - d_c_c*pCrebn;
% STAT3 ode
Stat3f = stat3tot - (pStat3 + pStat3n);
% pSTAT3 ode
dy(75) = a_c_js*jak1il*Stat3f - d_c_js*pStat3 - in_s*pStat3 + ex_s*(1/cnvr)*pStat3n;
% pSTAT3n ode
dy(76) = in_s*pStat3 - ex_s*(1/cnvr)*pStat3n - d_c_js*pStat3n;
% ATF ode
Atff = atftot - (pAtf + pAtfn);
% pATF ode
dy(77) = (a_c_m1a*Msk1 + a_c_m2a*Msk2)*Atff - d_c_ab*pAtf - in_at*pAtf + ex_at*(1/cnvr)*pAtfn;
% pATFn ode
dy(78) = in_at*pAtf - ex_at*(1/cnvr)*pAtfn - d_c_ab*pAtfn;
