# =============================================================================
# begin of file *gui2.py*
# =============================================================================
# richard@mevis (c) 2016
"""Create a simple tkinter gui for micro plastic analysis.
"""

# gui1
# - first version

# gui2
# - make entries read only, manipulation only through buttons
# - added tooltips from the idlelib
# - check input before running

# module imports
# =============================================================================
import tkinter
from tkinter import filedialog

import os

from idlelib.ToolTip import ToolTip


from Main_Script import analyse

# class defs
# =============================================================================

class MyApp(tkinter.Frame):
    
    def __init__(self, master):
        tkinter.Frame.__init__(self, master)
        self.grid()

        self.__file_name = 'Select Data File!'
        self.got_file_name = False
        self.file_name = tkinter.StringVar()
        self.file_name.set(self.__file_name)
        self.__dir_name = 'Select Results Dir!'
        self.got_dir_name = False
        self.dir_name = tkinter.StringVar()
        self.dir_name.set(self.__dir_name)
        
        self.createWidgets()
        
        return
        
    def createWidgets(self):
        self.file_btn = tkinter.Button(self, text="file name", width=10)
        self.file_btn["command"] = self.get_file_name
        self.result_btn = tkinter.Button(self, text="result dir", width=10)
        self.result_btn["command"] = self.get_dir_name
        self.start_btn = tkinter.Button(self, text="start", width=10)
        self.start_btn["command"] = self.run
        self.exit_btn = tkinter.Button(self, text="exit", width=10)
        self.exit_btn["command"] = self.quit
        
        file_ttp = ToolTip(self.file_btn, "Select data file")
        result_ttp = ToolTip(self.result_btn, "Select results directory")
        start_ttp = ToolTip(self.start_btn, "Run analysis")
        exit_ttp = ToolTip(self.exit_btn, "Exit application")
        
        self.file_ent = tkinter.Entry(self, fg='red',
                                      textvariable=self.file_name, 
                                      state="readonly", width=20)
        self.dir_ent = tkinter.Entry(self, fg='red',
                                     textvariable=self.dir_name, 
                                     state="readonly", width=20)
        
        self.file_btn.grid(row=0, column=0)
        self.result_btn.grid(row=1, column=0)
        self.start_btn.grid(row=2, column=0)
        self.exit_btn.grid(row=3, column=0)
        
        self.file_ent.grid(row=0, column=1)
        self.dir_ent.grid(row=1, column=1)        
        return
        
    def get_file_name(self):
        self.__file_name = file_name = filedialog.askopenfilename()
        head, tail = os.path.split(file_name)
        self.file_ent['fg'] = 'black'
        self.file_name.set(tail)
        self.got_file_name = True
        return
        
    def get_dir_name(self):
        self.__dir_name = dir_name = filedialog.askdirectory()
        head, tail = os.path.split(dir_name)
        self.dir_ent['fg'] = 'black'
        self.dir_name.set(tail)
        self.got_dir_name = True
        return
        
    def run(self):
        if self.got_dir_name and self.got_file_name:
            print("running...") 
            analyse(self.__file_name, self.__dir_name)
            
        return
        
        
# script entry
# =============================================================================
        
root = tkinter.Tk()
root.title("micro plastic")
app = MyApp(root)
root.mainloop()
        
# =============================================================================
# end of file *gui2.py*
# =============================================================================
