# ======================================================================
# begin of file *tools.py*
# ======================================================================
# richard@mevis (c) 2016

"""Some tools for a AWI project.  
"""

import pandas as pd                # for data anlysis
import SimpleITK as sitk


# showing itk-inges with matplotlib
# taken from http://insightsoftwareconsortium.github.io/
#                   SimpleITK-Notebooks/10_matplotlib's_imshow.html


# Closing with the information of two images
# Base matrix for labeling
# x_30 x_31 x_32 x_33
# x_20 x_21 x_22 x_23
# x_10 x_11 x_12 x_13
# x_00 x_01 x_02 x_03
# Three kind of pixel gaps were analysed diagonal, horizontal/vertical and staggered
def closing4x4pixel(data,d=20): 
    # Generation of Imagefile from data
    image = data2image(data)
    image2 = polymerdata2image(data)
    width = image.GetWidth()
    height = image.GetHeight()
    # Application of 4 x 4 matrix
    def analysedistance(x, y):
        nonlocal image
        nonlocal image2
        nonlocal width
        nonlocal height
        # Readout of datapoints
        x_00=int(image.GetPixel(x,y,0))
        p_00=int(image2.GetPixel(x,y,0))
        p_01=int(image2.GetPixel(x+0,y+1,0))
        p_02=int(image2.GetPixel(x+0,y+2,0))
        p_03=int(image2.GetPixel(x+0,y+3,0))       
        p_10=int(image2.GetPixel(x+1,y,0))
        p_11=int(image2.GetPixel(x+1,y+1,0))
        p_12=int(image2.GetPixel(x+1,y+2,0))
        p_13=int(image2.GetPixel(x+1,y+3,0))
        p_20=int(image2.GetPixel(x+2,y,0))
        p_21=int(image2.GetPixel(x+2,y+1,0))
        p_22=int(image2.GetPixel(x+2,y+2,0))
        p_23=int(image2.GetPixel(x+2,y+3,0))
        p_30=int(image2.GetPixel(x+3,y,0))
        p_31=int(image2.GetPixel(x+3,y+1,0))
        p_32=int(image2.GetPixel(x+3,y+2,0))
        p_33=int(image2.GetPixel(x+3,y+3,0))                            
        x_10=int(image.GetPixel(x+1,y,0))
        x_20=int(image.GetPixel(x+2,y,0))
        x_30=int(image.GetPixel(x+3,y,0))
        x_01=int(image.GetPixel(x,y+1,0))
        x_11=int(image.GetPixel(x+1,y+1,0))
        x_21=int(image.GetPixel(x+2,y+1,0))
        x_31=int(image.GetPixel(x+3,y+1,0))
        x_02=int(image.GetPixel(x,y+2,0))
        x_12=int(image.GetPixel(x+1,y+2,0))
        x_22=int(image.GetPixel(x+2,y+2,0))
        x_32=int(image.GetPixel(x+3,y+2,0))
        x_03=int(image.GetPixel(x,y+3,0))
        x_13=int(image.GetPixel(x+1,y+3,0))
        x_23=int(image.GetPixel(x+2,y+3,0))
        x_33=int(image.GetPixel(x+3,y+3,0))
        #Analysis starting at lower left corner
        if x_00>0 and x_02>0 and x_01==0 and p_00==p_02:
            xmedian=(x_02+x_00)/2
            image.SetPixel(x,y+1,0,int(xmedian))
            image2.SetPixel(x,y+1,0,int(p_00))
        if x_00>0 and x_20>0 and x_10==0 and p_00==p_20:
            xmedian=(x_20+x_00)/2
            image.SetPixel(x+1,y,0,int(xmedian))
            image2.SetPixel(x+1,y,0,int(p_00))
        if x_00>0 and x_22>0 and x_11==0 and p_00==p_22:
            xmedian=(x_22+x_00)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,int(p_00))
        if x_00>0 and x_03>0 and x_02==0 and x_01==0 and p_00==p_03:
            xmedian=(x_03+x_00*2)/3
            image.SetPixel(x,y+1,0,int(xmedian))
            image2.SetPixel(x,y+1,0,int(p_00))
            xmedian=(x_03*2+x_00)/3
            image.SetPixel(x,y+2,0,int(xmedian))
            image2.SetPixel(x,y+2,0,int(p_00))
        if x_00>0 and x_30>0 and x_20==0 and x_10==0 and p_00==p_30:
            xmedian=(x_30+x_00*2)/3
            image.SetPixel(x+1,y,0,int(xmedian))
            image2.SetPixel(x+1,y,0,int(p_00))
            xmedian=(x_30*2+x_00)/3
            image.SetPixel(x+2,y,0,int(xmedian))
            image2.SetPixel(x+2,y,0,int(p_00))
            
        #Analysis starting at upper left corner
        
        if x_30>0 and x_32>0 and x_31==0 and p_30==p_32:
            xmedian=(x_32+x_30)/2
            image.SetPixel(x+3,y+1,0,int(xmedian))
            image2.SetPixel(x+3,y+1,0,int(p_30))
        if x_30>0 and x_10>0 and x_20==0 and p_30==p_10:
            xmedian=(x_10+x_30)/2
            image.SetPixel(x+2,y,0,int(xmedian))
            image2.SetPixel(x+2,y,0,int(p_30))
        if x_30>0 and x_12>0 and x_21==0 and p_30==p_12:
            xmedian=(x_12+x_30)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,int(p_30))
        if x_30>0 and x_33>0 and x_32==0 and x_31==0 and p_30==p_33:
            xmedian=(x_33+x_30*2)/3
            image.SetPixel(x+3,y+1,0,int(xmedian))
            image2.SetPixel(x+3,y+1,0,int(p_30))
            xmedian=(x_33*2+x_30)/3
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,int(p_30))
            
        #Analysis starting at upper right corner
        
        if x_33>0 and x_31>0 and x_32==0 and p_33==p_31:
            xmedian=(x_33+x_31)/2
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,int(p_33))
        if x_33>0 and x_13>0 and x_23==0 and p_33==p_13:
            xmedian=(x_33+x_13)/2
            image.SetPixel(x+2,y+3,0,int(xmedian))
            image2.SetPixel(x+2,y+3,0,int(p_33))
        if x_33>0 and x_11>0 and x_22==0 and p_33==p_11:
            xmedian=(x_11+x_33)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,int(p_33))
        if x_33>0 and x_03>0 and x_23==0 and x_13==0 and p_33==p_03:
            xmedian=(x_33+x_03*2)/3
            image.SetPixel(x+1,y+3,0,int(xmedian))
            image2.SetPixel(x+1,y+3,0,int(p_33))
            xmedian=(x_33*2+x_03)/3
            image.SetPixel(x+2,y+3,0,int(xmedian))
            image2.SetPixel(x+2,y+3,0,int(p_33))

        #Analysis starting at lower right corner
        if x_03>0 and x_01>0 and x_02==0 and p_03==p_01:
            xmedian=(x_03+x_01)/2
            image.SetPixel(x,y+2,0,int(xmedian))
            image2.SetPixel(x,y+2,0,int(p_03))
        if x_03>0 and x_23>0 and x_13==0 and p_03==p_23:
            xmedian=(x_03+x_23)/2
            image.SetPixel(x+1,y+3,0,int(xmedian))
            image2.SetPixel(x+1,y+3,0,int(p_03))
        if x_03>0 and x_21>0 and x_12==0 and p_03==p_21:
            xmedian=(x_21+x_03)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,int(p_03))
            
        # Analysis starting at lower row
        if x_01 > 0 and x_21>0 and x_11==0  and p_21==p_01:
            xmedian=(x_21+x_01)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
        if x_01 > 0 and x_23>0 and x_12==0  and p_23==p_01:
            xmedian=(x_23+x_01)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_01)
        if x_01 > 0 and x_31>0 and x_21==0 and x_11==0  and p_31==p_01:
            xmedian=(x_31+x_01*2)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
            xmedian=(x_31*2+x_01)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_01)
            
        if x_02 > 0 and x_22>0 and x_12==0  and p_22==p_02:
            xmedian=(x_22+x_02)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_02)
        if x_02 > 0 and x_20>0 and x_11==0  and p_20==p_02:
            xmedian=(x_20+x_02)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_02)
        if x_02 > 0 and x_32>0 and x_22==0 and x_12==0  and p_02==p_32:
            xmedian=(x_32+x_02*2)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,int(p_02))
            xmedian=(x_32*2+x_02)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,int(p_02))
            
        # Analysis starting at upper row

        if x_31 > 0 and x_11>0 and x_21==0 and p_31==p_11:
            xmedian=(x_11+x_31)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_31)
        if x_31 > 0 and x_13>0 and x_22==0 and p_13==p_31:
            xmedian=(x_13+x_31)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_31)
            
        if x_32 > 0 and x_12>0 and x_22==0 and p_32==p_12:
            xmedian=(x_32+x_12)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_32)
        if x_32 > 0 and x_10>0 and x_21==0 and p_32==p_10:
            xmedian=(x_32+x_10)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_32)
            
        ## Analysis starting at right row
        
        if x_10 > 0 and x_12>0 and x_11==0 and p_10==p_12:
            xmedian=(x_10+x_12)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_10)
        if x_10 > 0 and x_13>0 and x_11==0 and x_12==0  and p_10==p_13:
            xmedian=(x_13+x_10*2)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_10)
            xmedian=(x_13*2+x_10)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_10)
            
        if x_20 > 0 and x_22>0 and x_21==0 and p_20==p_22:
            xmedian=(x_20+x_22)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_20)
        if x_20 > 0 and x_23>0 and x_22==0 and x_21==0  and p_20==p_23:
            xmedian=(x_23+x_20*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,int(p_20))
            xmedian=(x_23*2+x_20)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,int(p_20))
        
        # # Analysis starting at left row
        
        if x_13 > 0 and x_11>0 and x_12==0 and p_13==p_11:
            xmedian=(x_13+x_11)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_13)
        
        if x_23 > 0 and x_21>0 and x_22==0 and p_23==p_21:
            xmedian=(x_23+x_21)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_23)
            
        #Diagonal
        if x_00>0 and x_33>0 and x_22==0 and x_11==0 and p_00==p_33:
            xmedian=(x_33+x_00*2)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,int(p_00))
            xmedian=(x_33*2+x_00)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,int(p_00))
        if x_30>0 and x_03>0 and x_12==0 and x_21==0 and p_30==p_03:
            xmedian=(x_03+x_30*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,int(p_30))
            xmedian=(x_03*2+x_30)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,int(p_30))
        
        #Staggered
        
        ## Analysis starting at lower row
        
        if x_00 >0 and x_21 >0 and x_01==0 and x_10==0 and x_11==0 and x_20==0 and p_00==p_21:
            xmedian=(x_00+x_21)/2
            image.SetPixel(x+1,y+0,0,int(xmedian))
            image2.SetPixel(x+1,y+0,0,p_00)
            xmedian=(x_00+x_21)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_00)
        if x_00 >0 and x_12 >0 and x_01==0 and x_02==0 and x_10==0 and x_11==0 and p_00==p_12:
            xmedian=(x_00+x_12)/2
            image.SetPixel(x+0,y+1,0,int(xmedian))
            image2.SetPixel(x+0,y+1,0,p_00)
            xmedian=(x_00+x_12)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_00)
        
        if x_01 >0 and x_22 >0 and x_02==0 and x_11==0 and x_12==0 and x_21==0 and p_01==p_22:
            xmedian=(x_01+x_22)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_01)
            xmedian=(x_01+x_22)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
        if x_01 >0 and x_13 >0 and x_02==0 and x_03==0 and x_11==0 and x_12==0 and p_01==p_13:
            xmedian=(x_01+x_13)/2
            image.SetPixel(x+0,y+2,0,int(xmedian))
            image2.SetPixel(x+0,y+2,0,p_01)
            xmedian=(x_01+x_13)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_01)
        if x_01 >0 and x_20 >0 and x_00==0 and x_10==0 and x_11==0 and x_12==0 and p_01==p_20:
            xmedian=(x_01+x_20)/2
            image.SetPixel(x+1,y+0,0,int(xmedian))
            image2.SetPixel(x+1,y+0,0,p_01)
            xmedian=(x_01+x_20)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
        
        if x_02 >0 and x_21 >0 and x_01==0 and x_11==0 and x_12==0 and x_22==0 and p_02==p_21:
            xmedian=(x_02+x_21)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_02)
            xmedian=(x_02+x_21)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_02)
        if x_02 >0 and x_23 >0 and x_03==0 and x_12==0 and x_13==0 and x_22==0 and p_02==p_23:
            xmedian=(x_02+x_23)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_02)
            xmedian=(x_02+x_23)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_02)
        if x_02 >0 and x_10 >0 and x_00==0 and x_01==0 and x_11==0 and x_12==0 and p_02==p_10:
            xmedian=(x_02+x_10)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_02)
            xmedian=(x_02+x_10)/2
            image.SetPixel(x+0,y+1,0,int(xmedian))
            image2.SetPixel(x+0,y+1,0,p_02)
        
        if x_03 >0 and x_11 >0 and x_01==0 and x_02==0 and x_12==0 and x_13==0 and p_03==p_11:
            xmedian=(x_03+x_11)/2
            image.SetPixel(x+0,y+2,0,int(xmedian))
            image2.SetPixel(x+0,y+2,0,p_03)
            xmedian=(x_03+x_11)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_03)
        if x_03 >0 and x_22 >0 and x_02==0 and x_12==0 and x_13==0 and x_23==0 and p_03==p_22:
            xmedian=(x_03+x_22)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_03)
            xmedian=(x_03+x_22)/2
            image.SetPixel(x+1,y+3,0,int(xmedian))
            image2.SetPixel(x+1,y+3,0,p_03)
        
        
        
        ## Analysis starting at upper row
        if x_30 >0 and x_11 >0 and x_20==0 and x_10==0 and x_31==0 and x_21==0 and p_30==p_11:
            xmedian=(x_30+x_11)/2
            image.SetPixel(x+2,y+0,0,int(xmedian))
            image2.SetPixel(x+2,y+0,0,p_30)
            xmedian=(x_30+x_11)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_30)
        if x_30 >0 and x_22 >0 and x_31==0 and x_32==0 and x_20==0 and x_21==0 and p_30==p_22:
            xmedian=(x_30+x_22)/2
            image.SetPixel(x+3,y+1,0,int(xmedian))
            image2.SetPixel(x+3,y+1,0,p_30)
            xmedian=(x_30+x_22)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_30)
            
        if x_31 >0 and x_10 >0 and x_30==0 and x_20==0 and x_21==0 and x_11==0 and p_31==p_10:
            xmedian=(x_31+x_10)/2
            image.SetPixel(x+2,y+0,0,int(xmedian))
            image2.SetPixel(x+2,y+0,0,p_31)
            xmedian=(x_31+x_10)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_31)
        if x_31 >0 and x_12 >0 and x_32==0 and x_21==0 and x_22==0 and x_11==0 and p_31==p_12:
            xmedian=(x_31+x_12)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_31)
            xmedian=(x_31+x_12)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_31)
        if x_31 >0 and x_23 >0 and x_21==0 and x_32==0 and x_22==0 and x_23==0 and p_31==p_23:
            xmedian=(x_31+x_23)/2
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,p_31)
            xmedian=(x_31+x_23)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_31)
        
        if x_32 >0 and x_11 >0 and x_31==0 and x_21==0 and x_22==0 and x_12==0 and p_32==p_11:
            xmedian=(x_32+x_11)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_32)
            xmedian=(x_32+x_11)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_32)
        if x_32 >0 and x_13 >0 and x_33==0 and x_22==0 and x_23==0 and x_12==0 and p_32==p_32:
            xmedian=(x_32+x_13)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_32)
            xmedian=(x_32+x_13)/2
            image.SetPixel(x+2,y+3,0,int(xmedian))
            image2.SetPixel(x+2,y+3,0,p_32)
        if x_32 >0 and x_20 >0 and x_30==0 and x_31==0 and x_21==0 and x_22==0 and p_32==p_02:
            xmedian=(x_32+x_20)/2
            image.SetPixel(x+3,y+1,0,int(xmedian))
            image2.SetPixel(x+3,y+1,0,p_32)
            xmedian=(x_32+x_20)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_32)
        
        if x_33 >0 and x_21 >0 and x_31==0 and x_32==0 and x_22==0 and x_23==0 and p_33==p_21:
            xmedian=(x_33+x_21)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_33)
            xmedian=(x_33+x_21)/2
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,p_33)
        if x_33 >0 and x_12 >0 and x_32==0 and x_22==0 and x_23==0 and x_13==0 and p_33==p_12:
            xmedian=(x_33+x_12)/2
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,p_33)
            xmedian=(x_33+x_12)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_33)
        # # Analysis starting at sides
        if x_10 >0 and x_22 >0 and x_11==0 and x_12==0 and x_20==0 and x_21==0 and p_10==p_22:
            xmedian=(x_10+x_22)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_22)
            xmedian=(x_10+x_22)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_22)
        if x_20 >0 and x_12 >0 and x_10==0 and x_11==0 and x_21==0 and x_22==0 and p_20==p_12:
            xmedian=(x_20+x_12)/2
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_20)
            xmedian=(x_20+x_12)/2
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_20)
        if x_13 >0 and x_21 >0 and x_11==0 and x_12==0 and x_22==0 and x_23==0 and p_13==p_21:
            xmedian=(x_13+x_21)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_13)
            xmedian=(x_13+x_21)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_13)
        if x_23 >0 and x_11 >0 and x_12==0 and x_13==0 and x_21==0 and x_22==0 and p_23==p_11:
            xmedian=(x_23+x_11)/2
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_23)
            xmedian=(x_23+x_11)/2
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_23)
        
        # Staggered with 2 pixel gap
        
        # Lower row = upper row
        if x_00 >0 and x_31 >0 and x_01==0 and x_10==0 and x_11==0 and x_20==0 and x_21==0 and x_30==0 and p_00==p_31:
            xmedian=(x_00*2+x_31)/3
            image.SetPixel(x+1,y+0,0,int(xmedian))
            image2.SetPixel(x+1,y+0,0,p_00)
            xmedian=(x_00+x_31*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_00)
        if x_00 >0 and x_32 >0 and x_01==0 and x_10==0 and x_11==0 and x_21==0 and x_22==0 and x_31==0 and p_00==p_32:
            xmedian=(x_00*2+x_32)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_00)
            xmedian=(x_00+x_32*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_00)
            
        if x_01 >0 and x_30 >0 and x_00==0 and x_10==0 and x_11==0 and x_20==0 and x_21==0 and x_31==0 and p_01==p_30:
            xmedian=(x_01*2+x_30)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
            xmedian=(x_01+x_30*2)/3
            image.SetPixel(x+2,y+0,0,int(xmedian))
            image2.SetPixel(x+2,y+0,0,p_01)
        if x_01 >0 and x_32 >0 and x_02==0 and x_11==0 and x_12==0 and x_21==0 and x_22==0 and x_31==0 and p_01==p_32:
            xmedian=(x_01*2+x_32)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_01)
            xmedian=(x_01+x_32*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_01)
        if x_01 >0 and x_33 >0 and x_02==0 and x_11==0 and x_12==0 and x_22==0 and x_23==0 and x_32==0 and p_01==p_33:
            xmedian=(x_01*2+x_33)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_01)
            xmedian=(x_01+x_33*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_01)
            
        if x_02 >0 and x_30 >0 and x_01==0 and x_11==0 and x_12==0 and x_20==0 and x_21==0 and x_31==0 and p_02==p_30:
            xmedian=(x_02*2+x_30)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_02)
            xmedian=(x_02+x_30*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_02)
        if x_02 >0 and x_31 >0 and x_01==0 and x_11==0 and x_12==0 and x_21==0 and x_22==0 and x_32==0 and p_02==p_31:
            xmedian=(x_02*2+x_31)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_02)
            xmedian=(x_02+x_31*2)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_02)
        if x_02 >0 and x_33 >0 and x_03==0 and x_12==0 and x_13==0 and x_22==0 and x_23==0 and x_32==0 and p_02==p_33:
            xmedian=(x_02*2+x_33)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_02)
            xmedian=(x_02+x_33*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_02)
            
        if x_03 >0 and x_31 >0 and x_02==0 and x_12==0 and x_13==0 and x_21==0 and x_22==0 and x_32==0 and p_03==p_31:
            xmedian=(x_03*2+x_31)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_03)
            xmedian=(x_03+x_31*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_03)
        if x_03 >0 and x_32 >0 and x_02==0 and x_12==0 and x_13==0 and x_22==0 and x_23==0 and x_33==0 and p_03==p_32:
            xmedian=(x_03*2+x_32)/3
            image.SetPixel(x+1,y+3,0,int(xmedian))
            image2.SetPixel(x+1,y+3,0,p_03)
            xmedian=(x_03+x_32*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_03)
    
    # Left row = right row
        if x_00 >0 and x_13 >0 and x_01==0 and x_10==0 and x_11==0 and x_12==0 and x_22==0 and x_23==0 and p_00==p_13:
            xmedian=(x_00*2+x_13)/3
            image.SetPixel(x+0,y+0,0,int(xmedian))
            image2.SetPixel(x+0,y+0,0,p_00)
            xmedian=(x_00+x_13*2)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_00)
        if x_00 >0 and x_23 >0 and x_01==0 and x_10==0 and x_11==0 and x_12==0 and x_13==0 and x_22==0 and p_00==p_23:
            xmedian=(x_00*2+x_23)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_00)
            xmedian=(x_00+x_23*2)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_00)
            
        if x_10 >0 and x_03 >0 and x_00==0 and x_01==0 and x_11==0 and x_12==0 and x_13==0 and x_02==0 and p_10==p_03:
            xmedian=(x_10*2+x_03)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_10)
            xmedian=(x_10+x_03*2)/3
            image.SetPixel(x+0,y+2,0,int(xmedian))
            image2.SetPixel(x+0,y+2,0,p_10)
        if x_10 >0 and x_23 >0 and x_11==0 and x_12==0 and x_13==0 and x_20==0 and x_21==0 and x_22==0 and p_10==p_23:
            xmedian=(x_10*2+x_23)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_10)
            xmedian=(x_10+x_23*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_10)
        if x_10 >0 and x_33 >0 and x_11==0 and x_20==0 and x_21==0 and x_22==0 and x_23==0 and x_32==0 and p_10==p_33:
            xmedian=(x_10*2+x_33)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_10)
            xmedian=(x_10+x_33*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_10)
            
        if x_20 >0 and x_03 >0 and x_02==0 and x_10==0 and x_11==0 and x_12==0 and x_13==0 and x_21==0 and p_20==p_03:
            xmedian=(x_20*2+x_03)/3
            image.SetPixel(x+1,y+1,0,int(xmedian))
            image2.SetPixel(x+1,y+1,0,p_20)
            xmedian=(x_20+x_03*2)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_20)
        if x_20 >0 and x_13 >0 and x_10==0 and x_11==0 and x_12==0 and x_21==0 and x_22==0 and x_23==0 and p_20==p_13:
            xmedian=(x_20*2+x_13)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_20)
            xmedian=(x_20+x_13*2)/3
            image.SetPixel(x+1,y+2,0,int(xmedian))
            image2.SetPixel(x+1,y+2,0,p_20)
        if x_20 >0 and x_33 >0 and x_21==0 and x_22==0 and x_23==0 and x_30==0 and x_31==0 and x_32==0 and p_20==p_33:
            xmedian=(x_20*2+x_33)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_20)
            xmedian=(x_20+x_33*2)/3
            image.SetPixel(x+3,y+2,0,int(xmedian))
            image2.SetPixel(x+3,y+2,0,p_20)
            
        if x_30 >0 and x_13 >0 and x_12==0 and x_20==0 and x_21==0 and x_22==0 and x_23==0 and x_31==0 and p_30==p_13:
            xmedian=(x_30*2+x_13)/3
            image.SetPixel(x+2,y+1,0,int(xmedian))
            image2.SetPixel(x+2,y+1,0,p_30)
            xmedian=(x_30+x_13*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_30)
        if x_30 >0 and x_23 >0 and x_20==0 and x_21==0 and x_22==0 and x_31==0 and x_32==0 and x_33==0 and p_30==p_23:
            xmedian=(x_30*2+x_23)/3
            image.SetPixel(x+3,y+1,0,int(xmedian))
            image2.SetPixel(x+3,y+1,0,p_30)
            xmedian=(x_30+x_23*2)/3
            image.SetPixel(x+2,y+2,0,int(xmedian))
            image2.SetPixel(x+2,y+2,0,p_30)
        
    # The analysis is performed with starting pixels in the overall matrix in three directions: horizonatal, vertical and diagonal. If not other stated the wohle procedure has 20 iterations
    k=0
    if d == 0:
        d=20
    for k in range(0,d+1,1):
        for i in range(0, width-3, 4):
            for j in range(0, height-3, 4):
                analysedistance(i, j)
        for i in range(1, width-3, 4):
            for j in range(1, height-3, 4):
                analysedistance(i, j)
        for i in range(2, width-3, 4):
            for j in range(2, height-3, 4):
                analysedistance(i, j)
        for i in range(3, width-3, 4):
            for j in range(3, height-3, 4):
                analysedistance(i, j)
        for i in range(1, width-3, 4):
            for j in range(0, height-3, 4):
                analysedistance(i, j)
        for i in range(2, width-3, 4):
            for j in range(0, height-3, 4):
                analysedistance(i, j)
        for i in range(3, width-3, 4):
            for j in range(0, height-3, 4):
                analysedistance(i, j)
        for i in range(0, width-3, 4):
            for j in range(1, height-3, 4):
                analysedistance(i, j)
        for i in range(0, width-3, 4):
            for j in range(2, height-3, 4):
                analysedistance(i, j)
        for i in range(0, width-3, 4):
            for j in range(3, height-3, 4):
                analysedistance(i, j)
        for i in range(2, width-3, 4):
            for j in range(1, height-3, 4):
                analysedistance(i, j)
        for i in range(3, width-3, 4):
            for j in range(1, height-3, 4):
                analysedistance(i, j)
        for i in range(3, width-3, 4):
            for j in range(2, height-3, 4):
                analysedistance(i, j)
        for i in range(1, width-3, 4):
            for j in range(2, height-3, 4):
                analysedistance(i, j)
        for i in range(1, width-3, 4):
            for j in range(3, height-3, 4):
                analysedistance(i, j)
        for i in range(2, width-3, 4):
            for j in range(3, height-3, 4):
                analysedistance(i, j)                
    
    # The images are transformed into a pandas dataframe as output
    data2 = image2combidata(image,image2)
    return data2

def image2combidata(image, image2):
    """Create image from data frame.
    
    data: data frame with columns x, y, g
    size: tuple of width and height
    
    image: size width x height image
    """
    x_max=image.GetWidth()
    y_max=image.GetHeight()
    i=0
    z=0
    dfimage=pd.DataFrame(columns=['x','y','g','p'])
    while i < x_max:
        j=0
        while j < y_max:
            if int(image.GetPixel(i,j,0))>0:
                dfimage.loc[z]=[int(i),int(j),int(image.GetPixel(i,j,0)),int(image2.GetPixel(i,j,0))]
                z=z+1
            j=j+1
        i=i+1
    return dfimage

def data2image(data, size=None):
    """Create image from data frame.
    
    data: data frame with columns x, y, g
    size: tuple of width and height
    
    image: size width x height image
    """
    if size is None:
        width, height = max(data.x)+1, max(data.y)+1
    else:
        width, height = size
        
    # create empty image of given size and data type (enough for 11-bit)    
    image = sitk.Image(int(width), int(height), sitk.sitkUInt16)
    c = 0  # success counter
    for idx in data.index:
        try:
            image[int(data.x[idx]), int(data.y[idx])] = int(data.g[idx])
            c += 1
        except:
            #print('An error occured. Not all Pixels set!')
            pass

    return image

def polymerdata2image(data, size=None):
    """Create image from data frame.
    
    data: data frame with columns x, y, g
    size: tuple of width and height
    
    image: size width x height image
    """
    if size is None:
        width, height = max(data.x)+1, max(data.y)+1
    else:
        width, height = size
        
    # create empty image of given size and data type (enough for 11-bit)    
    image = sitk.Image(int(width), int(height), sitk.sitkUInt8)
    c = 0  # success counter
    for idx in data.index:
        try:
            image[int(data.x[idx]), int(data.y[idx])] = int(data.p[idx])
            c += 1
        except:
            #print('An error occured. Not all Pixels set!')
            pass

    return image

def image2data(image):
    """Create image from data frame.
    
    data: data frame with columns x, y, g
    size: tuple of width and height
    
    image: size width x height image
    """
    x_max=image.GetWidth()
    y_max=image.GetHeight()
    i=0
    data={'x':0,'y':0,'g':0}
    dfimage=pd.DataFrame(columns=data)
    z=0
    while i < x_max:
        j=1
        while j < y_max:
            if int(image.GetPixel(i,j,0))>0:
                dfimage.loc[z]=[i,j,int(image.GetPixel(i,j,0))]
                z=z+1
            j=j+1
        i=i+1
    return dfimage

#=======================================================================
# end of file *tools_for_MP_analysis.py*
#=======================================================================
