%% mergeImages.m - Supplementary File 1
% Stitch acquired images into a montage, then merge green and red channel
% images (green represenets lymphocytes/monocytes; red, granulocytes).
%
% Example case below provided for buffy coat in capillary tube
%
% Note: directories must be changed to correspond to your specific image
% file paths. Test images included in archive.
%
% Version: 1.0, 1 August 2016
% Author:  Max L. Balter
% Email:   balterm53=gmail*com, max.balter=rutgers*edu

clear all; close all; clc; warning off

%% Main Loop
s = 1;                                                                              % Capillary tube trial number
for v = 1 : 1;                                                                      % Iterate through image sets 
    %% File Naming for Saving Figures and Images
    folderPath = ['Test_Images', int2str(s),'_v', int2str(v)];                      % Folder path if using mutliple image sets

    green_fig_name = ['greenImage_trial', int2str(s),'_v',int2str(v), '.fig'];      % Green figure file name 
    green_Im_name = ['greenImage_trial', int2str(s),'_v',int2str(v), '.png'];       % Green image file name 

    red_fig_name = ['redImage_trial', int2str(s),'_v',int2str(v), '.fig'];          % Red figure file name 
    red_Im_name = ['redImage_trial', int2str(s),'_v',int2str(v), '.png'];           % Red image file name 

    merge_Im_name = ['mergedImage_trial', int2str(s),'_v',int2str(v), '.png'];      % Merged image file name 

    %% Import and Process Green Images
    codeDir = pwd;                                                                  % Set code directory
    cd ('./1-Test Images/Green');
    greenImageDir = cd;                                                             % Set green image directory
    dirOutput = dir('*.png');                                                       % Find all images in folder

    cd(codeDir);                                                                    % Retun to code directory
    fileNames = sort_nat({dirOutput.name});                                         % Extract file names and sort based on number
    cd(greenImageDir);                                                              % Return to green image directory
    y = size(fileNames);                                                            % Set variable for 'Size' montage parameter
    startIm = 1;                                                                    % Set start image number
    monLength = y(2) - startIm + 1;                                                 % Set montage length for 'Size' parameter

    figure;
    green_qbc = montage(fileNames, 'Indices',startIm:y(2), 'Size',[monLength 1]);   % Create image montage along length of tube
    set(gca,'LooseInset',get(gca,'TightInset'));                                    % Delete borders around image

    cd('../../2-Processed Images/Green');                                           % Go to green processed images directory
    saveas(green_qbc, green_fig_name);                                              % Save .fig file
    green_montage = get(green_qbc, 'CData');                                        % Get cdata from object
    imwrite(green_montage, green_Im_name);                                          % Save image as .png file

    %% Import and Process Red Images                                                                
    redImageDir = cd('../../1-Test Images/Red');
    dirOutput = dir('*.png');                                                       % Find all images in folder

    figure;
    red_qbc = montage(fileNames, 'Indices',startIm:y(2), 'Size',[monLength 1]);     % Create image montage along length of tube
    set(gca,'LooseInset',get(gca,'TightInset'));                                    % Delete borders around image

    cd('../../2-Processed Images/Red');                                             % Go to red processed images directory
    saveas(red_qbc, red_fig_name);                                                  % Save .fig file
    red_montage = get(red_qbc, 'CData');                                            % Get the cdata from the object
    imwrite(red_montage, red_Im_name);                                              % Save image as .png file

    %% Normalize Green Image
    cd('../Green')
    I1 = imread(green_Im_name);                                                     % Open green montage image
    I1normalized = double(I1)./double(max(I1(:)));                                  % Normalize green montage image
    figure; imshow(I1normalized)                                                    % Display green image post-normalization

    %% Normalize Red Image
    cd('../Red')
    I2 = imread(red_Im_name);                                                       % Open red montage image
    I2normalized = double(I2)./double(max(I2(:)));                                  % Normalize red montage image
    figure; imshow(I2normalized)                                                    % Display red image post-normalization
                    
    %% Merge Normalzied Green and Red Channel Images
    I3 = imfuse(I2normalized,I1normalized,'falsecolor','Scaling','joint','ColorChannels',[1 2 0]);  
    figure; imshow(I3);                                                             % Use proper colors (i.e. green: green channel image; red: red channel image)
    cd ../                                                                          % Go to processed images directory
    imwrite(I3, merge_Im_name);                                                     % Save merged image 
    cd(codeDir);                                                                    % Return to code directory
end
