launch <- function(path, names, tauGuess, miniRMSD, maxiRMSD, miniEne, maxiEne, YFlag, title, colors){
  
  source("MDA.R")
  library("graphics")
      
  print("#######################################################")
  print("")
  print("MoDyGliAni: Molecular Dynamics Global Analysis")
  print("")
  print("If you are using Modygliani for your own research please Cite: ")
  print("Belmonte L, Rossetto D, Forlin M, Scintilla S, Bonfio C and Mansy SS ")
  print("'Cysteine containing dipeptides show metal specificity that matches the composition of seawater'")
  print("Physical Chemistry Chemical Physics, 2016")
  print("#######################################################")
  print("")  
    
  i <- 1
  
  lunghezzaCiclo <- length(names)
  
  Energy_AVG<-NULL
  Energy_SD<-NULL
  
  RMSD_AVG<-NULL
  RMSD_SD<-NULL
  
  for (i in 1:lunghezzaCiclo) {
    
    stats <- MDA(path, names[i], tauGuess, YFlag)
    
    RMSD_AVG<-cbind(RMSD_AVG,stats[,1])
    RMSD_SD<-cbind(RMSD_SD,stats[,2])
        
    Energy_AVG<-cbind(Energy_AVG,stats[,5])
    Energy_SD<-cbind(Energy_SD,stats[,6])    
    
  }
  colnames(Energy_AVG)<-names
  
  old.par <- par(mfrow=c(2, 1))
    
  barRMSD<- barplot(RMSD_AVG, ylim=c(miniRMSD, maxiRMSD), col=colors, beside=TRUE, ylab="Average RMSD (Å)", main=title, las=1)
  #legend("top",legend=c("Fe","Co","Ni","Cu","Zn"), fill=colors, bty = "n", ncol=5)
    
  arrows(barRMSD,RMSD_AVG+RMSD_SD,barRMSD,RMSD_AVG, angle=90, code=1)
  arrows(barRMSD,RMSD_AVG-RMSD_SD,barRMSD,RMSD_AVG, angle=90, code=1)
  
  barEne<- barplot(Energy_AVG, ylim=c(miniEne, maxiEne), col=colors, beside=TRUE, xlab="Chains", ylab="Average Energy (kcal/mol)", las=3)
      
  arrows(barEne,Energy_AVG+Energy_SD,barEne,Energy_AVG, angle=90, code=1)
  arrows(barEne,Energy_AVG-Energy_SD,barEne,Energy_AVG, angle=90, code=1)
  
  par(old.par)
  
  dev.copy(svg,paste(path,"aggregates.svg"))
  dev.off()
  

  print("#######################################################")
  print("")
  print("Molecular Dynamics Analysis - FINISHED")
  print( paste ("Check your output in ", path, "*.dat & *.png"))
  print("")
  print("MoDyGliAni: Molecular Dynamics Global Analysis")
  print("")
  print("If you are using Modygliani for your own research please Cite: ")
  print("Belmonte L, Rossetto D, Forlin M, Scintilla S, Bonfio C and Mansy SS ")
  print("'Cysteine containing dipeptides show metal specificity that matches the composition of seawater'")
  print("Physical Chemistry Chemical Physics, 2016")
  print("#######################################################")
  
  summary<-rbind(Energy_AVG, Energy_SD, RMSD_AVG, RMSD_SD, deparse.level = 1)
  orderedSummary<- summary[, order(summary[1,], decreasing=FALSE)]
  rownames(orderedSummary) <- c("Energy_avg", "Energy_rmsd", "RMSD_avg", "RMSD_rmsd")
  
  tmp <- paste(path,"summary.csv", sep="")
  write.csv(orderedSummary, file = tmp)
    
}