(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    243615,       6397]
NotebookOptionsPosition[    236108,       6183]
NotebookOutlinePosition[    236482,       6199]
CellTagsIndexPosition[    236439,       6196]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Reducing density-driven error without exact exchange \nBenjamin G. Janesko\n\
Supporting Information Document 2 of 2\n\nThis document is the December 2016 \
version of the Janesko group\[CloseCurlyQuote]s ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " electronic structure code.  \nIt contains self-consistent \
spin-unrestricted implementations of Hartree-Fock, LSDA, and PiLDA exchange. \
\nExample 1 gives the energy as a function of noninteger minority-spin \
electron population, for adding a spin-down electron to  H atom. \nExample 2 \
compares Hartree-Fock, LDA, and Rung 3.5 PiLDA  density-driven errors in the \
H2+H transition state, evaluated in a minimal basis set. \nAll examples run \
without error in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 9 version 9.0.1.0\n\nThis code is provided with limited documentation, the \
numerical integrations are quite slow, and the results are not guaranteed to \
be correct.  "
}], "Subsubtitle",
 CellChangeTimes->{{3.589558887214523*^9, 3.5895589256275225`*^9}, {
  3.5978690461573906`*^9, 3.597869058185913*^9}, {3.5987929445403676`*^9, 
  3.598792946895952*^9}, {3.602362898624982*^9, 3.6023629369853816`*^9}, {
  3.6096950097340918`*^9, 3.6096950332340918`*^9}, {3.6106616521723976`*^9, 
  3.610661669182398*^9}, {3.6106639213363976`*^9, 3.6106639351763973`*^9}, {
  3.611314250992574*^9, 3.611314262677049*^9}, {3.6908123313969193`*^9, 
  3.6908123488899193`*^9}, {3.6908125091659193`*^9, 3.69081256755892*^9}, {
  3.69081260323592*^9, 3.6908126327539196`*^9}, {3.6908385865149193`*^9, 
  3.6908386426889195`*^9}, {3.6908390551089196`*^9, 3.6908390612509193`*^9}, {
  3.691234161495104*^9, 3.6912343424821043`*^9}}],

Cell[CellGroupData[{

Cell["Functions for generating operators ", "Section",
 CellChangeTimes->{{3.589559126647523*^9, 3.5895591328565226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Erfroverr", "[", "R_", "]"}], ":=", " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"R", ">", 
       RowBox[{"10", "^", 
        RowBox[{"(", 
         RowBox[{"-", "5"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Erf", "[", "R", "]"}], "/", "R"}], ",", " ", 
      RowBox[{
       FractionBox["2", 
        SqrtBox["\[Pi]"]], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["R", "2"]}], 
        RowBox[{"3", " ", 
         SqrtBox["\[Pi]"]}]], "+", 
       FractionBox[
        SuperscriptBox["R", "4"], 
        RowBox[{"5", " ", 
         SqrtBox["\[Pi]"]}]], "-", 
       FractionBox[
        SuperscriptBox["R", "6"], 
        RowBox[{"21", " ", 
         SqrtBox["\[Pi]"]}]], "+", 
       FractionBox[
        SuperscriptBox["R", "8"], 
        RowBox[{"108", " ", 
         SqrtBox["\[Pi]"]}]], "-", 
       FractionBox[
        SuperscriptBox["R", "10"], 
        RowBox[{"660", " ", 
         SqrtBox["\[Pi]"]}]]}]}], " ", "]"}]}], " ", ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Taylor", " ", "expansion", " ", "approximation", " ", "for", " ", "small",
     " ", "R"}], "  ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.5643173391269736`*^9, 3.5643173396261735`*^9}, {
  3.564317413835374*^9, 3.5643174149117737`*^9}, {3.5643336405384197`*^9, 
  3.5643336488067904`*^9}, {3.589559146957523*^9, 3.589559155772523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"F02", "[", "t_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], " ", "*", " ", 
    RowBox[{"Pi", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}], " ", "*", " ", 
    RowBox[{"Erfroverr", "[", 
     RowBox[{"Sqrt", "[", "t", "]"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{3.462903958879153*^9, 3.462904146557441*^9, 
  3.589560884791523*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"F01", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], " ", "*", " ", 
    RowBox[{"Pi", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}], " ", "*", " ", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{"Sqrt", "[", "t", "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "t", "]"}], "+", "0.0000000001"}], ")"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.589564721083523*^9, 3.5895647739295225`*^9}, {
  3.589565083666523*^9, 3.589565088313523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DoDeriv", "[", 
    RowBox[{"sterm_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "type_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"X_", ",", "Y_", ",", "Z_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "ret", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Given", " ", "s", " ", "integral", " ", "for", " ", "a", " ", 
        "Gaussian", " ", "at", " ", 
        RowBox[{"{", 
         RowBox[{"X", ",", "Y", ",", "Z"}], "}"}]}], " ", ",", " ", 
       RowBox[{
       "evaluate", " ", "the", " ", "full", " ", "integral", " ", "via", " ", 
        RowBox[{"recursion", ".", " ", "And"}], " ", "add", " ", "the", " ", 
        "normalization", " ", 
        RowBox[{"prefactor", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ret", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"a", "/", "Pi"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"3", "/", "4"}], ")"}]}], "*", "sterm"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{"ret", ",", "X"}], "]"}], "/", 
           RowBox[{"Sqrt", "[", "a", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "2"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{"ret", ",", "Y"}], "]"}], "/", 
           RowBox[{"Sqrt", "[", "a", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "3"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{"ret", ",", "Z"}], "]"}], "/", 
           RowBox[{"Sqrt", "[", "a", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "4"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"D", "[", 
               RowBox[{"ret", ",", 
                RowBox[{"{", 
                 RowBox[{"X", ",", "2"}], "}"}]}], "]"}], "/", "a"}], "+", 
             RowBox[{"2", "*", "ret"}]}], ")"}], "/", 
           RowBox[{"Sqrt", "[", "3", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "5"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"D", "[", 
               RowBox[{"ret", ",", 
                RowBox[{"{", 
                 RowBox[{"Y", ",", "2"}], "}"}]}], "]"}], "/", "a"}], "+", 
             RowBox[{"2", "*", "ret"}]}], ")"}], "/", 
           RowBox[{"Sqrt", "[", "3", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "6"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"D", "[", 
               RowBox[{"ret", ",", 
                RowBox[{"{", 
                 RowBox[{"Z", ",", "2"}], "}"}]}], "]"}], "/", "a"}], "+", 
             RowBox[{"2", "*", "ret"}]}], ")"}], "/", 
           RowBox[{"Sqrt", "[", "3", "]"}]}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "7"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"ret", ",", "X"}], "]"}], ",", "Y"}], "]"}], "/", 
           "a"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "8"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"ret", ",", "X"}], "]"}], ",", "Z"}], "]"}], "/", 
           "a"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"type", "\[Equal]", "9"}], ",", 
        RowBox[{"{", 
         RowBox[{"ret", "=", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"ret", ",", "Y"}], "]"}], ",", "Z"}], "]"}], "/", 
           "a"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462277381688933*^9, 3.462277415017058*^9}, {
  3.462285121241204*^9, 3.462285156897454*^9}, {3.462285204569329*^9, 
  3.462285210288079*^9}, {3.462285258428704*^9, 3.462285304491204*^9}, {
  3.462910230899617*^9, 3.4629102502578773`*^9}, {3.4629107302927256`*^9, 
  3.462910733151936*^9}, {3.4787083017265086`*^9, 3.4787083088512807`*^9}, {
  3.478708357365353*^9, 3.4787083730679755`*^9}, {3.478708484705028*^9, 
  3.478708498438964*^9}, {3.478708541562584*^9, 3.4787086891203613`*^9}, {
  3.4787089470496073`*^9, 3.4787089816734996`*^9}, {3.478709148246294*^9, 
  3.4787091741517153`*^9}, {3.478709234337289*^9, 3.4787092747422457`*^9}, {
  3.478709487219822*^9, 3.4787094918134246`*^9}, {3.5895592870545225`*^9, 
  3.589559288581523*^9}, {3.6791564784714327`*^9, 3.679156480452633*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DoDeriv2", "[", 
    RowBox[{"ssterm_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "typea_", ",", "X1_", ",", "Y1_", ",", "Z1_"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "typeb_", ",", "X2_", ",", "Y2_", ",", "Z2_"}], 
      "}"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Given", " ", "s"}], "-", 
       RowBox[{
       "s", " ", "integral", " ", "for", " ", "two", " ", "Gaussians", " ", 
        "at", " ", 
        RowBox[{"{", 
         RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}], " ", "and", " ", 
        RowBox[{"{", 
         RowBox[{"Xb", ",", "Yb", ",", "Zb"}], "}"}]}]}], ",", " ", 
      RowBox[{
      "and", " ", "the", " ", "corresponding", " ", "exponents", " ", "and", 
       " ", "types"}], ",", " ", 
      RowBox[{
      "evaluate", " ", "the", " ", "full", " ", "integral", " ", "via", " ", 
       "recursion"}]}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Return", "[", 
     RowBox[{"DoDeriv", "[", 
      RowBox[{
       RowBox[{"DoDeriv", "[", 
        RowBox[{"ssterm", ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "typea"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"X1", ",", "Y1", ",", "Z1"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "typeb"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"X2", ",", "Y2", ",", "Z2"}], "}"}]}], "]"}], "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462277381688933*^9, 3.462277415017058*^9}, {
  3.462285121241204*^9, 3.462285156897454*^9}, {3.462285204569329*^9, 
  3.462285210288079*^9}, {3.462285258428704*^9, 3.462285304491204*^9}, {
  3.4787086912452936`*^9, 3.478708795023223*^9}, {3.4787089901107297`*^9, 
  3.4787090680301113`*^9}, {3.478709383629387*^9, 3.4787094354402285`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DoDeriv4", "[", 
    RowBox[{"sterm_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "typea_", ",", "X1_", ",", "Y1_", ",", "Z1_"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "typeb_", ",", "X2_", ",", "Y2_", ",", "Z2_"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"c_", ",", "typec_", ",", "X3_", ",", "Y3_", ",", "Z3_"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d_", ",", "typed_", ",", "X4_", ",", "Y4_", ",", "Z4_"}], 
      "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Ret1", ",", "Ret2", ",", "Ret3", ",", "Ret"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Faster", " ", "version", " ", "of", " ", "DoDeriv4"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Ret1", " ", "=", " ", 
       RowBox[{"DoDeriv", "[", 
        RowBox[{"sterm", ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "typea"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"X1", ",", "Y1", ",", "Z1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ret2", " ", "=", " ", 
       RowBox[{"DoDeriv", "[", 
        RowBox[{"Ret1", ",", 
         RowBox[{"{", 
          RowBox[{"b", ",", "typeb"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"X2", ",", "Y2", ",", "Z2"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ret3", " ", "=", " ", 
       RowBox[{"DoDeriv", "[", 
        RowBox[{"Ret2", ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "typec"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"X3", ",", "Y3", ",", "Z3"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ret", " ", "=", 
       RowBox[{"DoDeriv", "[", 
        RowBox[{"Ret3", ",", 
         RowBox[{"{", 
          RowBox[{"d", ",", "typed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"X4", ",", "Y4", ",", "Z4"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462277381688933*^9, 3.462277415017058*^9}, {
  3.462285121241204*^9, 3.462285156897454*^9}, {3.462285204569329*^9, 
  3.462285210288079*^9}, {3.462285258428704*^9, 3.462285304491204*^9}, {
  3.4787086912452936`*^9, 3.478708795023223*^9}, {3.4787089901107297`*^9, 
  3.4787090680301113`*^9}, {3.478709383629387*^9, 3.4787094354402285`*^9}, {
  3.478709564357978*^9, 3.4787096309339724`*^9}, {3.4787132947386017`*^9, 
  3.4787134417182736`*^9}, {3.478713491122943*^9, 3.478713514356574*^9}, {
  3.4787135646674643`*^9, 3.478713601228794*^9}, {3.4787136559614177`*^9, 
  3.478713672726506*^9}, {3.4787139813572545`*^9, 3.4787139970598774`*^9}, {
  3.4787140457301946`*^9, 3.478714057167329*^9}, {3.5933658715667124`*^9, 
  3.5933659027043123`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SAB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa_", ",", "ta_", ",", 
       RowBox[{"{", 
        RowBox[{"Xaa_", ",", "Yaa_", ",", "Zaa_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ab_", ",", "tb_", ",", 
       RowBox[{"{", 
        RowBox[{"Xbb_", ",", "Ybb_", ",", "Zbb_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Xa", ",", "Ya", ",", "Za", ",", "Xb", ",", "Yb", ",", "Zb", ",", "DR", 
       ",", "ssterm", ",", "fullterm"}], " ", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Overlap", " ", "integral", " ", "between", " ", "AOs", " ", "a", " ", 
        "and", " ", "b", " ", "with", " ", "exponents", " ", "aa", " ", "and",
         " ", "ab", " ", "and", " ", "types", " ", "ta"}], ",", "tb"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DR", " ", "=", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}], " ", "-", " ", 
        RowBox[{"{", 
         RowBox[{"Xb", ",", "Yb", ",", "Zb"}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ssterm", " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Pi", "/", 
           RowBox[{"(", 
            RowBox[{"aa", "+", "ab"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"3", "/", "2"}], ")"}]}], " ", "*", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"aa", "*", 
             RowBox[{"ab", "/", 
              RowBox[{"(", 
               RowBox[{"aa", "+", "ab"}], ")"}]}]}], ")"}]}], "*", 
          RowBox[{"DR", ".", "DR"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fullterm", " ", "=", " ", 
       RowBox[{"DoDeriv2", "[", 
        RowBox[{"ssterm", ",", 
         RowBox[{"{", 
          RowBox[{"aa", ",", "ta", ",", "Xa", ",", "Ya", ",", "Za"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"ab", ",", "tb", ",", "Xb", ",", "Yb", ",", "Zb"}], "}"}]}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"fullterm", " ", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Xa", "\[Rule]", "Xaa"}], ",", 
          RowBox[{"Ya", "\[Rule]", "Yaa"}], ",", 
          RowBox[{"Za", "\[Rule]", "Zaa"}], ",", 
          RowBox[{"Xb", "\[Rule]", "Xbb"}], ",", 
          RowBox[{"Yb", "\[Rule]", "Ybb"}], ",", 
          RowBox[{"Zb", "\[Rule]", "Zbb"}]}], "}"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462275663126433*^9, 3.462275704438933*^9}, {
  3.462276311985808*^9, 3.462276440079558*^9}, {3.462276535767058*^9, 
  3.462276548142058*^9}, {3.462276952626433*^9, 3.462276958110808*^9}, {
  3.462277059579558*^9, 3.462277064532683*^9}, {3.462277110735808*^9, 
  3.462277144438933*^9}, {3.462277302142058*^9, 3.462277361392058*^9}, {
  3.462285309053704*^9, 3.462285332834954*^9}, {3.4787088080853043`*^9, 
  3.4787088198505535`*^9}, {3.4787094425806255`*^9, 3.4787094806106577`*^9}, {
  3.4787097705232553`*^9, 3.4787097743825073`*^9}, {3.5895592974265227`*^9, 
  3.589559337791523*^9}, {3.69083872783492*^9, 3.6908387283969193`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ATB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa_", ",", "ta_", ",", 
       RowBox[{"{", 
        RowBox[{"Xaa_", ",", "Yaa_", ",", "Zaa_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ab_", ",", "tb_", ",", 
       RowBox[{"{", 
        RowBox[{"Xbb_", ",", "Ybb_", ",", "Zbb_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Xa", ",", "Ya", ",", "Za", ",", "Xb", ",", "Yb", ",", "Zb", " ", ",", 
       "DR", ",", "ssterm", ",", "fullterm"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Kinetic", " ", "energy", " ", "integral", " ", "between", " ", "AOs", 
        " ", "a", " ", "and", " ", "b", " ", "with", " ", "exponents", " ", 
        "aa", " ", "and", " ", "ab", " ", "and", " ", "types", " ", "ta"}], 
       ",", "tb"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DR", " ", "=", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}], " ", "-", " ", 
        RowBox[{"{", 
         RowBox[{"Xb", ",", "Yb", ",", "Zb"}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ssterm", " ", "=", "  ", 
       RowBox[{
        RowBox[{"(", " ", 
         RowBox[{"aa", "*", 
          RowBox[{"ab", "/", 
           RowBox[{"(", 
            RowBox[{"aa", "+", "ab"}], ")"}]}]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"2", "*", "aa", "*", 
           RowBox[{"ab", "/", 
            RowBox[{"(", 
             RowBox[{"aa", "+", "ab"}], ")"}]}], "*", 
           RowBox[{"DR", ".", "DR"}]}]}], " ", ")"}], " ", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Pi", "/", 
           RowBox[{"(", 
            RowBox[{"aa", "+", "ab"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"3", "/", "2"}], ")"}]}], " ", "*", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"aa", "*", 
             RowBox[{"ab", "/", 
              RowBox[{"(", 
               RowBox[{"aa", "+", "ab"}], ")"}]}]}], ")"}]}], "*", 
          RowBox[{"DR", ".", "DR"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fullterm", " ", "=", " ", 
       RowBox[{"DoDeriv2", "[", 
        RowBox[{"ssterm", ",", 
         RowBox[{"{", 
          RowBox[{"aa", ",", "ta", ",", "Xa", ",", "Ya", ",", "Za"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"ab", ",", "tb", ",", "Xb", ",", "Yb", ",", "Zb"}], "}"}]}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"fullterm", " ", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Xa", "\[Rule]", "Xaa"}], ",", 
          RowBox[{"Ya", "\[Rule]", "Yaa"}], ",", 
          RowBox[{"Za", "\[Rule]", "Zaa"}], ",", 
          RowBox[{"Xb", "\[Rule]", "Xbb"}], ",", 
          RowBox[{"Yb", "\[Rule]", "Ybb"}], ",", 
          RowBox[{"Zb", "\[Rule]", "Zbb"}]}], "}"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462276553923308*^9, 3.462276618032683*^9}, {
  3.462276669642058*^9, 3.462276691673308*^9}, {3.4622958881452036`*^9, 
  3.4622958956608286`*^9}, {3.4622985268952036`*^9, 3.4622985290827036`*^9}, {
  3.478708851568288*^9, 3.478708858880554*^9}, {3.4787095171407394`*^9, 
  3.4787095299215803`*^9}, {3.4787097613672986`*^9, 3.478709765757783*^9}, {
  3.589559380550523*^9, 3.589559387780523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AVBC", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa_", ",", "ta_", ",", 
       RowBox[{"{", 
        RowBox[{"Xaa_", ",", "Yaa_", ",", "Zaa_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ab_", ",", "tb_", ",", 
       RowBox[{"{", 
        RowBox[{"Xbb_", ",", "Ybb_", ",", "Zbb_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ZZ_", ",", 
       RowBox[{"{", 
        RowBox[{"Xcc_", ",", "Ycc_", ",", "Zcc_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Xa", ",", "Ya", ",", "Za", ",", "Xb", ",", "Yb", ",", "Zb", " ", ",", 
       "Xc", ",", "Yc", ",", "Zc", ",", "Ra", ",", "Rb", ",", "Rc", ",", "Rp",
        ",", "RAB", ",", "RPC", ",", "ssterm", ",", "fullterm"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "nuclear", " ", "attraction", " ", "integral", " ", "between", " ", 
        "AOs", " ", "a", " ", "and", " ", "b", " ", "with", " ", "exponents", 
        " ", "aa", " ", "and", " ", "ab", " ", "and", " ", "types", " ", 
        "ta"}], ",", "tb", ",", " ", 
       RowBox[{
       "plus", " ", "nucleus", " ", "c", " ", "with", " ", "charge", " ", 
        "ZZ"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Ra", "=", 
       RowBox[{"{", 
        RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}], ";", " ", 
      RowBox[{"Rb", "=", 
       RowBox[{"{", 
        RowBox[{"Xb", ",", "Yb", ",", "Zb"}], "}"}]}], ";", 
      RowBox[{"Rc", "=", 
       RowBox[{"{", 
        RowBox[{"Xc", ",", "Yc", ",", "Zc"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Rp", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"aa", "*", "Ra"}], "+", 
          RowBox[{"ab", "*", "Rb"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"aa", "+", "ab"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RAB", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Ra", "-", "Rb"}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{"Ra", "-", "Rb"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RPC", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Rp", "-", "Rc"}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{"Rp", "-", "Rc"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ssterm", " ", "=", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", " ", 
          RowBox[{"2", "*", 
           RowBox[{"Pi", "/", 
            RowBox[{"(", 
             RowBox[{"aa", "+", "ab"}], ")"}]}]}], ")"}]}], "*", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"aa", "*", 
             RowBox[{"ab", "/", 
              RowBox[{"(", 
               RowBox[{"aa", "+", "ab"}], ")"}]}]}], ")"}]}], "*", "RAB"}], 
         "]"}], " ", "*", " ", 
        RowBox[{"F02", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"aa", "+", "ab"}], ")"}], "*", "RPC"}], "]"}], "*", 
        "ZZ"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fullterm", " ", "=", " ", 
       RowBox[{"DoDeriv2", "[", 
        RowBox[{"ssterm", ",", 
         RowBox[{"{", 
          RowBox[{"aa", ",", "ta", ",", "Xa", ",", "Ya", ",", "Za"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"ab", ",", "tb", ",", "Xb", ",", "Yb", ",", "Zb"}], "}"}]}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"fullterm", " ", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Xa", "\[Rule]", "Xaa"}], ",", 
          RowBox[{"Ya", "\[Rule]", "Yaa"}], ",", 
          RowBox[{"Za", "\[Rule]", "Zaa"}], ",", 
          RowBox[{"Xb", "\[Rule]", "Xbb"}], ",", 
          RowBox[{"Yb", "\[Rule]", "Ybb"}], ",", 
          RowBox[{"Zb", "\[Rule]", "Zbb"}], ",", 
          RowBox[{"Xc", "\[Rule]", "Xcc"}], ",", 
          RowBox[{"Yc", "\[Rule]", "Ycc"}], ",", 
          RowBox[{"Zc", "\[Rule]", "Zcc"}]}], "}"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462276731688933*^9, 3.462276742220183*^9}, {
   3.462276859688933*^9, 3.462276894876433*^9}, 3.4622863117557683`*^9, {
   3.4622986721764536`*^9, 3.4622986744889536`*^9}, {3.4622987147233286`*^9, 
   3.4622988499420786`*^9}, {3.47870886775527*^9, 3.4787088756456423`*^9}, {
   3.4787095395775213`*^9, 3.478709556686349*^9}, {3.478709748570833*^9, 
   3.478709757383051*^9}, {3.564330320264374*^9, 3.5643303448031735`*^9}, {
   3.5643304392143736`*^9, 3.5643304703987737`*^9}, {3.5643312454067736`*^9, 
   3.5643312454535737`*^9}, {3.5643312774959736`*^9, 
   3.5643312815363736`*^9}, {3.589559394964523*^9, 3.589559402548523*^9}, {
   3.589560447009523*^9, 3.5895604883685226`*^9}, {3.589560695794523*^9, 
   3.5895607096255226`*^9}, {3.589561128215523*^9, 3.589561171843523*^9}, {
   3.589564766989523*^9, 3.589564770345523*^9}, {3.5895649234035225`*^9, 
   3.5895649234665227`*^9}, {3.589565102919523*^9, 3.5895651029745226`*^9}, {
   3.5895656998015227`*^9, 3.589565713711523*^9}, {3.589565796147523*^9, 
   3.5895657961915226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ABCD", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa_", ",", "ta_", ",", 
       RowBox[{"{", 
        RowBox[{"Xaa_", ",", "Yaa_", ",", "Zaa_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ab_", ",", "tb_", ",", 
       RowBox[{"{", 
        RowBox[{"Xbb_", ",", "Ybb_", ",", "Zbb_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ac_", ",", "tc_", ",", 
       RowBox[{"{", 
        RowBox[{"Xcc_", ",", "Ycc_", ",", "Zcc_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ad_", ",", "td_", ",", 
       RowBox[{"{", 
        RowBox[{"Xdd_", ",", "Ydd_", ",", "Zdd_"}], "}"}]}], "}"}]}], "]"}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "Xa", ",", "Ya", ",", "Za", ",", "\[IndentingNewLine]", "Xb", ",", "Yb",
        ",", "Zb", ",", "\[IndentingNewLine]", "Xc", ",", "Yc", ",", "Zc", 
       ",", "\[IndentingNewLine]", "Xd", ",", "Yd", ",", "Zd", ",", 
       "\[IndentingNewLine]", "Ra", ",", "Rb", ",", "Rc", ",", "Rd", ",", 
       "RAB", ",", "RCD", ",", "RP", ",", "RQ", ",", "fullterm", ",", 
       "ssss"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Two", "-", 
       RowBox[{"electron", " ", "integral"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Ra", "=", 
       RowBox[{"{", 
        RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Rb", "=", 
       RowBox[{"{", 
        RowBox[{"Xb", ",", "Yb", ",", "Zb"}], "}"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Rc", "=", 
       RowBox[{"{", 
        RowBox[{"Xc", ",", "Yc", ",", "Zc"}], "}"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Rd", "=", 
       RowBox[{"{", 
        RowBox[{"Xd", ",", "Yd", ",", "Zd"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RAB", " ", "=", 
       RowBox[{"Rb", "-", "Ra"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RCD", " ", "=", 
       RowBox[{"Rc", "-", "Rd"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RP", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"aa", "*", "Ra"}], "  ", "+", 
          RowBox[{"ab", "*", "Rb"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"aa", "+", "ab"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RQ", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ac", "*", "Rc"}], "  ", "+", 
          RowBox[{"ad", "*", "Rd"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"ac", "+", "ad"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ssss", " ", "=", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "aa"}], "*", 
           RowBox[{"ab", "/", 
            RowBox[{"(", 
             RowBox[{"aa", "+", "ab"}], ")"}]}], "*", 
           RowBox[{"RAB", ".", "RAB"}]}], "  ", "-", " ", 
          RowBox[{"ac", "*", 
           RowBox[{"ad", "/", 
            RowBox[{"(", 
             RowBox[{"ac", "+", "ad"}], ")"}]}], "*", 
           RowBox[{"RCD", ".", "RCD"}]}]}], "]"}], " ", "*", " ", 
        RowBox[{"F02", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"aa", "+", "ab"}], ")"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ac", "+", "ad"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"aa", "+", "ab", "+", "ac", "+", "ad"}], ")"}]}], " ", 
          "*", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"RP", "-", "RQ"}], ")"}], ".", 
           RowBox[{"(", 
            RowBox[{"RP", "-", "RQ"}], ")"}]}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fullterm", " ", "=", "  ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "*", 
          RowBox[{
           RowBox[{"Pi", "^", 
            RowBox[{"(", 
             RowBox[{"5", "/", "2"}], ")"}]}], "/", 
           RowBox[{"(", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"aa", "+", "ab"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"ac", "+", "ad"}], ")"}], "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"aa", "+", "ab", "+", "ac", "+", "ad"}], "]"}]}], " ", 
            ")"}]}]}], ")"}], " ", "*", " ", 
        RowBox[{"DoDeriv4", "[", 
         RowBox[{"ssss", ",", 
          RowBox[{"{", 
           RowBox[{"aa", ",", "ta", ",", "Xa", ",", "Ya", ",", "Za"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ab", ",", "tb", ",", "Xb", ",", "Yb", ",", "Zb"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ac", ",", "tc", ",", "Xc", ",", "Yc", ",", "Zc"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ad", ",", "td", ",", "Xd", ",", "Yd", ",", "Zd"}], 
           "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"fullterm", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Xa", "\[Rule]", "Xaa"}], ",", 
          RowBox[{"Ya", "\[Rule]", "Yaa"}], ",", 
          RowBox[{"Za", "\[Rule]", "Zaa"}], ",", 
          RowBox[{"Xb", "\[Rule]", "Xbb"}], ",", 
          RowBox[{"Yb", "\[Rule]", "Ybb"}], ",", 
          RowBox[{"Zb", "\[Rule]", "Zbb"}], ",", 
          RowBox[{"Xc", "\[Rule]", "Xcc"}], ",", 
          RowBox[{"Yc", "\[Rule]", "Ycc"}], ",", 
          RowBox[{"Zc", "\[Rule]", "Zcc"}], ",", 
          RowBox[{"Xd", "\[Rule]", "Xdd"}], ",", 
          RowBox[{"Yd", "\[Rule]", "Ydd"}], ",", 
          RowBox[{"Zd", "\[Rule]", "Zdd"}]}], "}"}]}], "]"}], ";"}]}], " ", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462285937185818*^9, 3.4622860491354094`*^9}, {
   3.46228608713468*^9, 3.462286190320199*^9}, {3.462286334411873*^9, 
   3.46228648962963*^9}, {3.462286761597799*^9, 3.462286761675924*^9}, {
   3.4626303240010023`*^9, 3.4626303753899827`*^9}, {3.4626304460752206`*^9, 
   3.462630449809476*^9}, {3.462810842060948*^9, 3.4628108852911725`*^9}, 
   3.4628109342864685`*^9, {3.462811168060899*^9, 3.462811176497589*^9}, {
   3.462811209588162*^9, 3.462811212244157*^9}, {3.462811332013908*^9, 
   3.462811339731917*^9}, {3.462811467047818*^9, 3.462811474000276*^9}, {
   3.4787096524020357`*^9, 3.4787097422741594`*^9}, {3.47871327698917*^9, 
   3.4787132848170443`*^9}, {3.478713522793804*^9, 3.4787135543084207`*^9}, {
   3.4787137140845575`*^9, 3.4787138299714737`*^9}, {3.4787138992348824`*^9, 
   3.4787139287651873`*^9}, {3.4787141204778023`*^9, 
   3.4787141227121058`*^9}, {3.4787209593839507`*^9, 3.478720959649567*^9}, {
   3.4787214703363495`*^9, 3.478721478367343*^9}, {3.4787216007071776`*^9, 
   3.4787216084256806`*^9}, {3.478721954711474*^9, 3.478721957117647*^9}, {
   3.4787225284587383`*^9, 3.4787225303024297`*^9}, {3.478723306449467*^9, 
   3.478723333448603*^9}, {3.489879496584954*^9, 3.489879496881827*^9}, 
   3.489880200736697*^9, {3.4898802469239016`*^9, 3.489880246986401*^9}, {
   3.4898806550619144`*^9, 3.489880655140039*^9}, {3.5643160197561736`*^9, 
   3.5643160200057735`*^9}, {3.5643170449109735`*^9, 3.564317086484974*^9}, {
   3.5643172698473735`*^9, 3.5643173012501736`*^9}, {3.5643173497817736`*^9, 
   3.5643173767541733`*^9}, {3.5643174636929736`*^9, 
   3.5643174688877735`*^9}, {3.5643299485475736`*^9, 
   3.5643299658167734`*^9}, {3.5643301972895737`*^9, 
   3.5643302019383736`*^9}, {3.5643302345735736`*^9, 
   3.5643302346671734`*^9}, {3.5643302691275735`*^9, 
   3.5643302691743736`*^9}, {3.5643315399347734`*^9, 
   3.5643315399503736`*^9}, {3.564331788856374*^9, 3.5643317932711735`*^9}, {
   3.564331982327574*^9, 3.5643320049475737`*^9}, {3.5643320945851736`*^9, 
   3.564332103258774*^9}, {3.564332223612774*^9, 3.5643323174467735`*^9}, {
   3.564333036690852*^9, 3.5643330491909375`*^9}, 3.564333260672743*^9, {
   3.589559452027523*^9, 3.5895594575785227`*^9}, {3.589559488136523*^9, 
   3.5895595407035227`*^9}, {3.5895607232685227`*^9, 3.589560725563523*^9}, {
   3.5933658464663124`*^9, 3.5933658467471123`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Operators and DFT terms ", "Section",
 CellChangeTimes->{{3.589559792978523*^9, 3.5895597979725227`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OneElectronOperator", "[", 
    RowBox[{"func_", ",", "basis_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "Ret"}], "}"}], ",", "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Generate", " ", "a", " ", "one"}], "-", 
        RowBox[{"electron", " ", "operator", " ", "V", 
         RowBox[{"(", 
          RowBox[{"a", ",", "b"}], ")"}], " ", "given", " ", "an", " ", 
         "array", " ", "basis_", " ", "of", " ", "exponents", " ", "of", " ", 
         "s"}], "-", 
        RowBox[{
        "type", " ", "primitive", " ", "Gaussians", " ", "at", " ", "the", 
         " ", "origin", " ", "and", " ", "a", " ", "function", " ", 
         RowBox[{"func", "[", 
          RowBox[{"alpha_a", ",", " ", "alpha_b"}], "]"}], " ", "for", " ", 
         "generating", " ", "matrix", " ", "element", " ", "ab"}]}], "  ", 
       "*)"}],
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
           RowBox[{"func", "[", 
            RowBox[{
             RowBox[{"basis", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"basis", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589559887626523*^9, 3.589559895201523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NuclearAttractionIntegrals", "[", 
    RowBox[{"basis_", ",", "nucs_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "NN", ",", "MM", ",", "Ret", ",", "Z", ",", "R", ",", "i", ",", "j", 
       ",", "k"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MM", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "nucs", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"Ret", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"Ret", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}], "+", 
                RowBox[{"AVBC", "[", 
                 RowBox[{
                  RowBox[{"basis", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{"basis", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], ",", 
                  RowBox[{"nucs", "[", 
                   RowBox[{"[", "k", "]"}], "]"}]}], "]"}]}]}], ";"}], 
             "\[IndentingNewLine]", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "MM"}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895605693415227`*^9, 3.5895606894395227`*^9}, {
  3.589560748843523*^9, 3.589560774713523*^9}, {3.602363972571582*^9, 
  3.602363985082782*^9}, {3.6032077943880463`*^9, 3.6032077954635906`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NuclearAttractionCross", "[", 
    RowBox[{"basis1_", ",", "basis2_", ",", "nucs_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "NN1", ",", "NN2", ",", "MM", ",", "Ret", ",", "Z", ",", "R", ",", "i", 
       ",", "j", ",", "k", ",", "UndoNormalization"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Cross", "-", 
          RowBox[{"term", " ", "nuclear", " ", "attraction"}]}], " ", "<", 
         "basis1"}], "|", "nucleii", "|", 
        RowBox[{"basis2", ">"}]}], ",", " ", 
       RowBox[{
        RowBox[{"used", " ", "for", " ", "Rung", " ", "3.5", " ", 
         RowBox[{"terms", ".", " ", "Make"}], " ", "second", " ", "basis", 
         " ", "un"}], "-", "normalized"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN1", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis1", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NN2", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis2", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MM", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "nucs", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN1", ",", "NN2"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"UndoNormalization", " ", "=", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"basis2", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", "Pi"}]}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "/", "4"}], ")"}]}]}], ";", " ", 
              RowBox[{"(*", " ", 
               RowBox[{
               "undo", " ", "normalization", " ", "of", " ", "all", " ", 
                "aux", " ", "bfns"}], " ", "*)"}], "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"0", "<", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"basis2", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ")"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"UndoNormalization", "=", 
                 RowBox[{"UndoNormalization", "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"basis2", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", ")"}]}]}]}],
                "]"}], ";", " ", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{"undo", " ", "normalization", " ", "of", " ", "px"}], 
                ",", " ", "py", ",", " ", 
                RowBox[{"pz", " ", "aux", " ", "bfns"}]}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Ret", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"Ret", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"AVBC", "[", 
                  RowBox[{
                   RowBox[{"basis1", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                   RowBox[{"basis2", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ",", 
                   RowBox[{"nucs", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "*", 
                 "UndoNormalization"}]}]}], ";"}], "\[IndentingNewLine]", 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "MM"}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "NN2"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895605693415227`*^9, 3.5895606894395227`*^9}, {
  3.589560748843523*^9, 3.589560774713523*^9}, {3.5895641027245226`*^9, 
  3.5895642171105227`*^9}, {3.589566855581523*^9, 3.589566882220523*^9}, {
  3.589566940817523*^9, 3.5895669408805227`*^9}, {3.5901747681942577`*^9, 
  3.5901748229807363`*^9}, {3.590174927641201*^9, 3.590174984386875*^9}, {
  3.5901750354619823`*^9, 3.590175040219458*^9}, {3.5901754622206535`*^9, 
  3.5901754835187836`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NuclearRepulsionEnergy", "[", "nucs_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Ret", ",", "MM", ",", "i", ",", "j", ",", "Zi", ",", "Ri", ",", "Zj", 
       ",", "Rj"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MM", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "nucs", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", "0.0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Zi", ",", "Ri"}], "}"}], " ", "=", " ", 
           RowBox[{"nucs", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Zj", ",", "Rj"}], "}"}], " ", "=", " ", 
               RowBox[{"nucs", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"Ret", "=", 
               RowBox[{"Ret", "+", 
                RowBox[{"Zi", "*", 
                 RowBox[{"Zj", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Ri", "-", "Rj"}], ")"}], ".", 
                    RowBox[{"(", 
                    RowBox[{"Ri", "-", "Rj"}], ")"}]}], "]"}]}]}]}]}], ";"}], 
             "\[IndentingNewLine]", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "MM"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895605693415227`*^9, 3.5895606894395227`*^9}, {
  3.589560748843523*^9, 3.589560774713523*^9}, {3.5895614793235226`*^9, 
  3.5895616175875225`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NuclearRepulsionEnergy", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.0", ",", 
      RowBox[{"{", 
       RowBox[{"0.", ",", "0.", ",", "0."}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.0", ",", 
      RowBox[{"{", 
       RowBox[{"1.1", ",", "0.", ",", "0."}], "}"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5895616206505227`*^9, 3.5895616482385225`*^9}}],

Cell[BoxData["0.9090909090909091`"], "Output",
 CellChangeTimes->{{3.5895616446115227`*^9, 3.5895616487095227`*^9}, 
   3.589562892098523*^9, 3.5895648163165226`*^9, 3.5895658084595227`*^9, 
   3.589567029346523*^9, 3.589570226298523*^9, 3.590163280484602*^9, 
   3.5901634232208743`*^9, 3.590168046695175*^9, 3.590168854649963*^9, 
   3.590172014718938*^9, 3.5901721792483892`*^9, 3.5901750710955453`*^9, 
   3.5901754926506968`*^9, 3.5917178287238984`*^9, 3.592669558733986*^9, 
   3.593349444643712*^9, 3.5933659224227123`*^9, 3.5933776174067125`*^9, 
   3.5933885956440516`*^9, 3.593435126724647*^9, 3.594132586146966*^9, 
   3.59786907439421*^9, 3.5979396585861454`*^9, 3.5979401953319044`*^9, 
   3.598792952574316*^9, 3.6023630534237814`*^9, 3.6023633753283815`*^9, 
   3.60320699535271*^9, 3.60320751342371*^9, 3.6032075956529098`*^9, 
   3.6032078030235767`*^9, 3.6033928678647923`*^9, 3.6083021679331894`*^9, 
   3.608315753788015*^9, 3.6096970185364923`*^9, 3.6106303628226004`*^9, 
   3.6106584402853975`*^9, 3.6113122977902484`*^9, 3.61131476203625*^9, 
   3.6120336844828525`*^9, 3.6120952711361628`*^9, 3.612278515878825*^9, 
   3.6127861531648254`*^9, 3.6132344976948605`*^9, 3.613305380659627*^9, 
   3.613406311774194*^9, 3.615047950351591*^9, 3.6151415985728273`*^9, 
   3.6151424772221584`*^9, 3.6156539900404*^9, {3.6158272423023443`*^9, 
   3.6158272685563445`*^9}, 3.6391482612956853`*^9, 3.639939195898839*^9, 
   3.661509166121266*^9, 3.661621447006461*^9, 3.661793523402405*^9, 
   3.6627451615911937`*^9, 3.6633309903521605`*^9, 3.6638760138100414`*^9, 
   3.6684362835823193`*^9, 3.6721511779084635`*^9, 3.672159173755463*^9, 
   3.6725751666589727`*^9, 3.6737127866604695`*^9, 3.6761316409698286`*^9, 
   3.676135200711997*^9, 3.6762132858013287`*^9, 3.676292972860961*^9, 
   3.676301575132961*^9, 3.6784540534957685`*^9, 3.6785426116290927`*^9, 
   3.679150110056182*^9, 3.679151642675956*^9, 3.6792430522443485`*^9, 
   3.6797501662164507`*^9, 3.679758450717451*^9, 3.679758682970251*^9, 
   3.679758869362651*^9, 3.679760839182851*^9, 3.679835212198291*^9, 
   3.6799212098096*^9, 3.679939482229596*^9, 3.6864149264361334`*^9, 
   3.69081264661092*^9, 3.6941955382839746`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TwoElectronIntegrals", "[", "basis_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "Ret"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN", ",", "NN", ",", "NN"}], "}"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"aa", ",", "bb", ",", "cc", ",", "dd"}], "]"}], "]"}], 
           "=", 
           RowBox[{"ABCD", "[", 
            RowBox[{
             RowBox[{"basis", "[", 
              RowBox[{"[", "aa", "]"}], "]"}], ",", 
             RowBox[{"basis", "[", 
              RowBox[{"[", "bb", "]"}], "]"}], ",", 
             RowBox[{"basis", "[", 
              RowBox[{"[", "cc", "]"}], "]"}], ",", 
             RowBox[{"basis", "[", 
              RowBox[{"[", "dd", "]"}], "]"}]}], "]"}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"aa", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"bb", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"cc", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"dd", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589559897009523*^9, 3.589559907232523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DensityMatrix", "[", 
     RowBox[{"Psi_", ",", "NFilled_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Ret", ",", "Nbottom", ",", "Nfrac"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Ret", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", "0.0", ")"}], " ", "*", " ", 
         RowBox[{"IdentityMatrix", "[", 
          RowBox[{
           RowBox[{"Dimensions", "[", "Psi", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Nbottom", " ", "=", " ", 
        RowBox[{"Floor", "[", "NFilled", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Nfrac", " ", "=", " ", 
        RowBox[{"NFilled", "-", "Nbottom"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Nbottom", ">", "0"}], ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Ret", "=", 
            RowBox[{"Array", "[", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Outer", "[", 
                 RowBox[{"Times", ",", 
                  RowBox[{"Psi", "[", 
                   RowBox[{"[", "##", "]"}], "]"}], ",", 
                  RowBox[{"Psi", "[", 
                   RowBox[{"[", "##", "]"}], "]"}]}], "]"}], ")"}], "&"}], 
              " ", ",", " ", 
              RowBox[{"{", "Nbottom", "}"}], ",", "1", ",", "Plus"}], "]"}]}],
            ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Nfrac", ">", "0"}], ",", 
         RowBox[{"Ret", " ", "=", " ", 
          RowBox[{"Ret", " ", "+", " ", 
           RowBox[{"Nfrac", "*", 
            RowBox[{"Outer", "[", 
             RowBox[{"Times", ",", 
              RowBox[{"Psi", "[", 
               RowBox[{"[", 
                RowBox[{"Nbottom", "+", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Psi", "[", 
               RowBox[{"[", 
                RowBox[{"Nbottom", "+", "1"}], "]"}], "]"}]}], "]"}]}]}]}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "Ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.462302932728318*^9, 3.462302938462657*^9}, {
  3.4923587453803587`*^9, 3.4923587686305075`*^9}, {3.589560150149523*^9, 
  3.5895601516845226`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Utility", " ", "functions", " ", "for", " ", "J", " ", "and", " ", "K", 
   " ", "matrices"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6908388957419195`*^9, 3.6908389113869195`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MabcdNcd", "[", 
    RowBox[{"a_", ",", "b_", ",", "MM_", ",", "NN_"}], "]"}], ":=", " ", 
   RowBox[{"Tr", "[", " ", 
    RowBox[{
     RowBox[{"MM", "[", 
      RowBox[{"[", 
       RowBox[{"a", ",", "b", ",", "All", ",", "All"}], "]"}], "]"}], ".", 
     RowBox[{"Transpose", "[", "NN", "]"}]}], " ", "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MacbdNcd", "[", 
    RowBox[{"a_", ",", "b_", ",", "MM_", ",", "NN_"}], "]"}], ":=", " ", 
   RowBox[{"Tr", "[", " ", 
    RowBox[{
     RowBox[{"MM", "[", 
      RowBox[{"[", 
       RowBox[{"a", ",", "All", ",", "b", ",", "All"}], "]"}], "]"}], ".", 
     RowBox[{"Transpose", "[", "NN", "]"}]}], " ", "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeJ", "[", 
    RowBox[{"P_", ",", "ABCD_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "Ret"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "P", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Ret", "[", 
          RowBox[{"[", 
           RowBox[{"a", ",", "b"}], "]"}], "]"}], "=", 
         RowBox[{"MabcdNcd", "[", 
          RowBox[{"a", ",", "b", ",", "ABCD", ",", "P"}], "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"a", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "NN"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589559914991523*^9, 3.5895599181835227`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeK", "[", 
    RowBox[{"P_", ",", "ABCD_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "Ret"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "P", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Ret", "[", 
          RowBox[{"[", 
           RowBox[{"a", ",", "b"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"-", "1"}], "*", 
          RowBox[{"MacbdNcd", "[", 
           RowBox[{"a", ",", "b", ",", "ABCD", ",", "P"}], "]"}]}]}], ",", 
        " ", 
        RowBox[{"{", 
         RowBox[{"a", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "NN"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895599189985228`*^9, 3.5895599216865225`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrbitalsAtR", "[", 
    RowBox[{"basis_", ",", "rval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "NN", ",", "Rval", ",", "Ret", ",", "ai", ",", "ti", ",", "sterm", ",", 
       "fullterm", ",", "Xa", ",", "Ya", ",", "Za", ",", "rmR"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{"(*", " ", 
       RowBox[{"Vector", " ", "Chi_u", 
        RowBox[{"(", "rval", ")"}], " ", "of", " ", "the", " ", "orbitals", 
        " ", "in", " ", 
        RowBox[{"basis", "."}]}], "  ", "*)"}],
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ai", "=", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", " ", 
          RowBox[{"ti", " ", "=", " ", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";", " ", 
          RowBox[{"Rval", " ", "=", " ", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"rmR", " ", "=", " ", 
           RowBox[{"rval", " ", "-", 
            RowBox[{"{", 
             RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"sterm", "  ", "=", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "ai"}], "*", 
             RowBox[{"rmR", ".", "rmR"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"fullterm", " ", "=", " ", 
           RowBox[{"DoDeriv", "[", 
            RowBox[{"sterm", ",", 
             RowBox[{"{", 
              RowBox[{"ai", ",", "ti"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"fullterm", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Xa", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"Ya", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"Za", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.4622903800769434`*^9, 3.4622904250769434`*^9}, {
  3.462290481498819*^9, 3.4622905495144434`*^9}, {3.462306687538281*^9, 
  3.462306687866406*^9}, {3.462306752928906*^9, 3.462306777772656*^9}, {
  3.462306859116406*^9, 3.462306870819531*^9}, {3.4787098823321776`*^9, 
  3.478709918877883*^9}, {3.478709976626035*^9, 3.478710028155636*^9}, {
  3.4787100849194446`*^9, 3.4787101069343653`*^9}, {3.4787101824163246`*^9, 
  3.4787102730384245`*^9}, {3.478710361832458*^9, 3.478710457485647*^9}, {
  3.478710835692294*^9, 3.478710842942062*^9}, {3.4787108739098215`*^9, 
  3.478710919720855*^9}, {3.47871096300072*^9, 3.4787109754378223`*^9}, {
  3.4787111056055317`*^9, 3.4787111062617607`*^9}, {3.589562832886523*^9, 
  3.589562849949523*^9}, {3.589570081829523*^9, 3.589570184494523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DensityAtR", "[", 
    RowBox[{"basis_", ",", "rval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Temp", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Temp", "=", 
       RowBox[{"OrbitalsAtR", "[", 
        RowBox[{"basis", ",", "rval"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"Outer", "[", 
        RowBox[{"Times", ",", "Temp", ",", "Temp"}], "]"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4622906323581934`*^9, 3.462290669967569*^9}, 
   3.4622907397644434`*^9, {3.5599937101957235`*^9, 3.559993716997367*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrbGradAtR", "[", 
    RowBox[{"basis_", ",", "rval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "NN", ",", "Ret", ",", "ai", ",", "ti", ",", "Rval", ",", "sterm", ",", 
       "fullterm", ",", "xv", ",", "yv", ",", "zv", ",", "Xa", ",", "Ya", ",",
        "Za", ",", "rmR"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Vector", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dChi_u", 
          RowBox[{
           RowBox[{"(", "rval", ")"}], "/", "dx"}]}], ",", " ", 
         RowBox[{"dChi_u", 
          RowBox[{
           RowBox[{"(", "rval", ")"}], "/", "dy"}]}], ",", " ", 
         RowBox[{"dChi_u", 
          RowBox[{
           RowBox[{"(", "rval", ")"}], "/", "dz"}]}]}], " ", "}"}], " ", "of",
        " ", "the", " ", "first", " ", "derivatives", " ", "of", " ", "each", 
       " ", "orbital"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ret", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "3"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ai", "=", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", " ", 
          RowBox[{"ti", " ", "=", " ", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";", " ", 
          RowBox[{"Rval", " ", "=", " ", 
           RowBox[{"basis", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"rmR", " ", "=", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xv", ",", "yv", ",", "zv"}], "}"}], " ", "-", 
            RowBox[{"{", 
             RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"sterm", "  ", "=", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "ai"}], "*", 
             RowBox[{"rmR", ".", "rmR"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"fullterm", " ", "=", " ", 
           RowBox[{"DoDeriv", "[", 
            RowBox[{"sterm", ",", 
             RowBox[{"{", 
              RowBox[{"ai", ",", "ti"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Xa", ",", "Ya", ",", "Za"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"D", "[", 
              RowBox[{"fullterm", ",", "xv"}], "]"}], ")"}], "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Xa", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"Ya", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"Za", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{"xv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"yv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"zv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"D", "[", 
              RowBox[{"fullterm", ",", "yv"}], "]"}], ")"}], "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Xa", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"Ya", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"Za", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{"xv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"yv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"zv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Ret", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"D", "[", 
              RowBox[{"fullterm", ",", "zv"}], "]"}], ")"}], "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Xa", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"Ya", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"Za", "\[Rule]", 
               RowBox[{"Rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{"xv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"yv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"zv", "\[Rule]", 
               RowBox[{"rval", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.477663221578043*^9, 3.477663235077957*^9}, {
  3.4776638082617884`*^9, 3.4776638289179063`*^9}, {3.477663964463914*^9, 
  3.477663964901411*^9}, {3.4776701619711246`*^9, 3.4776703171107564`*^9}, {
  3.477673807322794*^9, 3.4776738249008064`*^9}, {3.4776738922597504`*^9, 
  3.4776741043208933`*^9}, {3.478710326864827*^9, 3.478710329114755*^9}, {
  3.478710761882156*^9, 3.4787108179272375`*^9}, {3.478710924283209*^9, 
  3.478710948048074*^9}, {3.4787109973589954`*^9, 3.478711049122964*^9}, {
  3.4787111421668615`*^9, 3.4787112464760237`*^9}, {3.478711331926414*^9, 
  3.4787113326295166`*^9}, {3.5901685388993907`*^9, 3.5901685945759583`*^9}, {
  3.5901686305745573`*^9, 3.5901686777232723`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetGradRho", "[", 
    RowBox[{"basis_", ",", "rval_", ",", "P_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Vec1", ",", "Vec2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Returns", " ", "the", " ", "vector", " ", "grad", " ", "rho"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Vec1", " ", "=", " ", 
       RowBox[{"P", ".", 
        RowBox[{"OrbitalsAtR", "[", 
         RowBox[{"basis", ",", "rval"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Vec2", " ", "=", " ", 
       RowBox[{"Vec1", ".", 
        RowBox[{"OrbGradAtR", "[", 
         RowBox[{"basis", ",", "rval"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"2", "*", "Vec2"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4776748958627024`*^9, 3.4776749903464727`*^9}, {
  3.4776750417055187`*^9, 3.477675105267612*^9}, {3.477676454352728*^9, 
  3.4776764654151573`*^9}, {3.478632863999968*^9, 3.4786328644687033`*^9}, {
  3.4787113525195055`*^9, 3.4787113529726157`*^9}, {3.502831642753658*^9, 
  3.5028316613319016`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetGradRhoSquared", "[", 
    RowBox[{"basis_", ",", "rval_", ",", "P_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Vec1", ",", "Vec2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Returns", " ", "|", 
       RowBox[{"grad", " ", "rho"}], "|", 
       RowBox[{"^", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Vec1", " ", "=", " ", 
       RowBox[{"P", ".", 
        RowBox[{"OrbitalsAtR", "[", 
         RowBox[{"basis", ",", "rval"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Vec2", " ", "=", " ", 
       RowBox[{"Vec1", ".", 
        RowBox[{"OrbGradAtR", "[", 
         RowBox[{"basis", ",", "rval"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"4", "*", 
        RowBox[{"Vec2", ".", "Vec2"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4776748958627024`*^9, 3.4776749903464727`*^9}, {
  3.4776750417055187`*^9, 3.477675105267612*^9}, {3.477676454352728*^9, 
  3.4776764654151573`*^9}, {3.478632863999968*^9, 3.4786328644687033`*^9}, {
  3.4787113525195055`*^9, 3.4787113529726157`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Digest", "[", 
    RowBox[{"f0_", ",", "basis_", ",", "maxpt_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "RetRename", ",", "Dens", ",", "Val"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{" ", 
        RowBox[{
         RowBox[{"Calculate", " ", "F_", 
          RowBox[{"{", 
           RowBox[{"mu", ",", "nu"}], "}"}]}], " ", "=", " ", 
         RowBox[{
          RowBox[{"[", 
           RowBox[{"int", " ", 
            RowBox[{"d", "^", "3"}], " ", "r"}], "]"}], " ", "f0", 
          RowBox[{"(", "r", ")"}], " ", "mu", 
          RowBox[{"(", "r", ")"}], "nu", 
          RowBox[{"(", "r", ")"}]}]}], "  ", ")"}], "  ", "for", " ", "input",
        " ", "function", " ", "f", 
       RowBox[{"(", 
        RowBox[{"x", ",", "y", ",", "z"}], ")"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RetRename", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Dens", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Val", " ", "=", " ", 
           RowBox[{"NIntegrate", "[", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"f0", "*", 
               RowBox[{"Dens", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "j"}], "]"}], "]"}]}], " ", ")"}], ",", 
             "  ", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"y", ",", 
               RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"z", ",", 
               RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
             RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
             RowBox[{"AccuracyGoal", "\[Rule]", "5"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"RetRename", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "Val"}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "NN"}], "}"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "RetRename", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4631637504576025`*^9, 3.4631637917385883`*^9}, {
   3.4631649278563175`*^9, 3.463164945715578*^9}, {3.4631649849675355`*^9, 
   3.463165007501237*^9}, {3.463165980775236*^9, 3.463165988728361*^9}, {
   3.463167477360593*^9, 3.4631674850949183`*^9}, {3.463167654281335*^9, 
   3.4631676728280916`*^9}, {3.492358771349275*^9, 3.492358807880759*^9}, 
   3.492364588730256*^9, {3.492364701527853*^9, 3.492364702246608*^9}, {
   3.5599937361854897`*^9, 3.559993736825094*^9}, {3.5599990658327866`*^9, 
   3.5599990666595917`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Rung 3.5 terms ", "Section",
 CellChangeTimes->{{3.5895680498735228`*^9, 3.589568053537523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PiLDAE0", "[", 
    RowBox[{"P_", ",", "basis_", ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "rhoval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "aux", ",", "auxvals", ",", "orbvals", ",", "ret"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"PiLDA", " ", "energy", " ", "density", " ", "at", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", " ", 
       RowBox[{"no", " ", "aux", " ", "basis"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "=", "1.48386923"}], ";", "\[IndentingNewLine]", 
      RowBox[{"aux", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"b", "*", 
           RowBox[{"rhoval", "^", 
            RowBox[{"(", 
             RowBox[{"2", "/", "3"}], ")"}]}]}], ",", "0", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"auxvals", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"NuclearAttractionCross", "[", 
          RowBox[{"basis", ",", "aux", ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.0"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], 
          "]"}], ")"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"orbvals", "=", 
       RowBox[{"OrbitalsAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ret", "=", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], "*", "rhoval", "*", 
        RowBox[{"Tr", "[", 
         RowBox[{"P", ".", 
          RowBox[{"Outer", "[", 
           RowBox[{"Times", ",", "orbvals", ",", "auxvals"}], "]"}]}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589563861938523*^9, 3.5895639929855227`*^9}, {
   3.589564053398523*^9, 3.589564057773523*^9}, {3.5895642325385227`*^9, 
   3.5895643069525228`*^9}, {3.589564338461523*^9, 3.5895643395805225`*^9}, 
   3.5895644824675226`*^9, {3.589565155537523*^9, 3.589565157464523*^9}, {
   3.589565190695523*^9, 3.5895651934535227`*^9}, {3.5895656248745227`*^9, 
   3.589565637897523*^9}, {3.5895662133735228`*^9, 3.5895662590585227`*^9}, {
   3.589566293280523*^9, 3.589566297013523*^9}, {3.589566412273523*^9, 
   3.589566466009523*^9}, {3.589566968228523*^9, 3.589566993727523*^9}, {
   3.5895670884605227`*^9, 3.589567094444523*^9}, {3.589567554119523*^9, 
   3.589567581572523*^9}, {3.5895688952485228`*^9, 3.5895689020645227`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PiLDAV0", "[", 
    RowBox[{"P_", ",", "basis_", ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "rhoval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "b", ",", "aux", ",", "auxvals", ",", "orbvals", ",", "drho", ",", 
       "dgam", ",", "dgam2", ",", "ret"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "PiLDA", " ", "exchange", " ", "potential", " ", "integrand", " ", 
        "at", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", " ", 
       RowBox[{"no", " ", "aux", " ", "basis"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "=", "1.48386923"}], ";", "\[IndentingNewLine]", 
      RowBox[{"aux", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"b", "*", 
           RowBox[{"rhoval", "^", 
            RowBox[{"(", 
             RowBox[{"2", "/", "3"}], ")"}]}]}], ",", "0", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"auxvals", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"NuclearAttractionCross", "[", 
          RowBox[{"basis", ",", "aux", ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.0"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], 
          "]"}], ")"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"orbvals", "=", 
       RowBox[{"OrbitalsAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"drho", "=", 
       RowBox[{"Outer", "[", 
        RowBox[{"Times", ",", "orbvals", ",", "orbvals"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dgam", "=", 
       RowBox[{"Outer", "[", 
        RowBox[{"Times", ",", "orbvals", ",", "auxvals"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dgam2", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"dgam", "+", 
          RowBox[{"Transpose", "[", "dgam", "]"}]}], ")"}], "/", "2"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"ret", "=", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], "*", 
        RowBox[{"(", " ", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"rhoval", "*", "dgam2"}], "+"}], "*)"}], "  ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"+", "drho"}], "*", 
           RowBox[{"Tr", "[", 
            RowBox[{"P", ".", "dgam2"}], "]"}]}], "\[IndentingNewLine]", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "/", "3"}], ")"}], "*", "b", "*", 
           RowBox[{"rhoval", "^", 
            RowBox[{"(", 
             RowBox[{"2", "/", "3"}], ")"}]}], "*", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", " ", "drho", "*", 
           RowBox[{"Tr", "[", 
            RowBox[{"P", ".", "dgam2"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "/", "3"}], ")"}], "*", "b", "*", 
              RowBox[{"rhoval", "^", 
               RowBox[{"(", 
                RowBox[{"2", "/", "3"}], ")"}]}]}]}], " ", ")"}]}]}], 
         ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589563861938523*^9, 3.5895639929855227`*^9}, {
   3.589564053398523*^9, 3.589564057773523*^9}, {3.5895642325385227`*^9, 
   3.5895643069525228`*^9}, {3.589564338461523*^9, 3.5895643395805225`*^9}, 
   3.5895644824675226`*^9, {3.589565155537523*^9, 3.589565157464523*^9}, {
   3.589565190695523*^9, 3.5895651934535227`*^9}, {3.5895656248745227`*^9, 
   3.589565637897523*^9}, {3.5895662133735228`*^9, 3.5895662590585227`*^9}, {
   3.589566293280523*^9, 3.589566297013523*^9}, {3.589566412273523*^9, 
   3.589566466009523*^9}, {3.589566968228523*^9, 3.589566993727523*^9}, {
   3.5895670884605227`*^9, 3.589567094444523*^9}, {3.589567554119523*^9, 
   3.589567581572523*^9}, {3.5895688952485228`*^9, 3.5895689020645227`*^9}, {
   3.5979397167581725`*^9, 3.597939933861981*^9}, {3.5979415895371256`*^9, 
   3.5979416312945776`*^9}, {3.597941986919855*^9, 3.5979419919740925`*^9}, {
   3.5979432156618204`*^9, 3.597943250293598*^9}, {3.5979433590571012`*^9, 
   3.597943369992631*^9}, {3.5979435176868644`*^9, 3.597943533177565*^9}, {
   3.597943701672085*^9, 3.597943704948064*^9}, 3.5979438303624563`*^9, {
   3.597944086449006*^9, 3.5979440937341595`*^9}, {3.5979445559649887`*^9, 
   3.5979446356960783`*^9}, {3.597944761232068*^9, 3.597944761356868*^9}, {
   3.597944804833789*^9, 3.5979448307920227`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SAuxMetricS", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Return", "[", 
     FractionBox[
      RowBox[{"2", "Pi"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], " ", ")"}]], "]"}], ";"}], ")"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Overlap", " ", "of", " ", "two", " ", "unnormalized", " ", "s"}],
     "-", 
    RowBox[{
    "type", " ", "Gaussian", " ", "functions", " ", "in", " ", "Coulomb", " ",
      "metric"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.5895681094995227`*^9, 3.589568156034523*^9}, {
  3.589568189886523*^9, 3.5895682413445225`*^9}, {3.5901695106825595`*^9, 
  3.5901695142029114`*^9}, {3.5941324775699663`*^9, 3.594132483685166*^9}, {
  3.679755085594451*^9, 3.679755095665451*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SAuxMetricP", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Return", "[", 
     FractionBox[
      RowBox[{" ", 
       RowBox[{"2", "Pi"}]}], 
      RowBox[{"3", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], " ", ")"}], "2"]}]], "]"}], ";"}], ")"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Overlap", " ", "of", " ", "two", " ", "unnormalized", " ", "p"}],
     "-", 
    RowBox[{
    "type", " ", "Gaussian", " ", "functions", " ", "in", " ", "Coulomb", " ",
      "metric"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.59016952478697*^9, 3.5901695659780884`*^9}, {
  3.5941325065713663`*^9, 3.5941325137005663`*^9}, {3.679755098698451*^9, 
  3.6797551067444506`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SAuxDerivS", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Return", " ", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", "Pi"}], 
       RowBox[{" ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], "2"]}]]}], "]"}], ";"}], ")"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Overlap", " ", "derivative", " ", "of", " ", "two", " ", "unnormalized", 
     " ", "s"}], "-", 
    RowBox[{
    "type", " ", "Gaussian", " ", "functions", " ", "in", " ", "Coulomb", " ",
      "metric"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.590162962656822*^9, 3.5901629716027164`*^9}, {
  3.590163007047261*^9, 3.5901630203625927`*^9}, {3.5901695168031716`*^9, 
  3.590169540627554*^9}, {3.594132530938566*^9, 3.594132542139366*^9}, {
  3.5979477499306145`*^9, 3.597947751459405*^9}, {3.679755099457451*^9, 
  3.679755108896451*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SAuxDerivP", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Return", " ", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", "Pi"}], 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], "3"]}]]}], "]"}], ";"}], ")"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Overlap", " ", "derivative", " ", "of", " ", "two", " ", "unnormalized", 
     " ", "p"}], "-", 
    RowBox[{
    "type", " ", "Gaussian", " ", "functions", " ", "in", " ", "Coulomb", " ",
      "metric"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.590162962656822*^9, 3.5901629716027164`*^9}, {
  3.590163007047261*^9, 3.5901630203625927`*^9}, {3.5901695168031716`*^9, 
  3.590169540627554*^9}, {3.5901696450949993`*^9, 3.590169645351025*^9}, {
  3.590169685415031*^9, 3.5901696936888585`*^9}, {3.594132549221766*^9, 
  3.594132558628566*^9}, {3.679755100529451*^9, 3.6797551105844507`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SAuxDeriv2S", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Return", " ", "[", 
     FractionBox[
      RowBox[{"4", "Pi"}], 
      RowBox[{" ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "3"]}]], "]"}], ";"}], ")"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Overlap", " ", "2", "nd", " ", "derivative", " ", "of", " ", "two", " ", 
     "unnormalized", " ", "s"}], "-", 
    RowBox[{
    "type", " ", "Gaussian", " ", "functions", " ", "in", " ", "Coulomb", " ",
      "metric"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.5979477045973053`*^9, 3.5979477142068434`*^9}, {
  3.597947753253393*^9, 3.5979477672153034`*^9}, {3.6797551013214507`*^9, 
  3.6797551120724506`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SAuxInv", "[", 
    RowBox[{"aux_", ",", 
     RowBox[{"L_:", "0"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NN", ",", "SS", ",", "aa", ",", "bb"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Build", " ", "aux", " ", "basis", " ", "inverse", " ", "overlap", " ", 
       "matrix", " ", "in", " ", "chosen", " ", "metric"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "aux", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"SS", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", "NN"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"aa", "=", 
           RowBox[{"aux", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"bb", "=", 
           RowBox[{"aux", "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"L", "\[Equal]", "0"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"SS", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
              RowBox[{"SAuxMetricS", "[", 
               RowBox[{"aa", ",", "bb"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"SS", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
              RowBox[{"SAuxMetricP", "[", 
               RowBox[{"aa", ",", "bb"}], "]"}]}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "NN"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"Inverse", "[", "SS", "]"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589568066682523*^9, 3.5895681028235226`*^9}, {
  3.589568245534523*^9, 3.589568378904523*^9}, {3.589568411359523*^9, 
  3.589568411654523*^9}, {3.5901693632788205`*^9, 3.5901693725807505`*^9}, {
  3.5901696556640563`*^9, 3.590169680016491*^9}, {3.5901697176422534`*^9, 
  3.590169733999889*^9}, {3.590169788445333*^9, 3.5901698027257605`*^9}, {
  3.590172097597225*^9, 3.5901721139998655`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PiLDAE", "[", 
    RowBox[{"P_", ",", "basis_", ",", "aux_", ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "rhoval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "b", ",", "NN2", ",", "orbvals", ",", "aux2", ",", "SauxI", ",", "Amu", 
       ",", "rhotildes", ",", "Cs", ",", "Ret"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"PiLDA", "  ", "energy", " ", "density", " ", "at", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", " ", 
       RowBox[{"aux", " ", 
        RowBox[{"basis", ".", " ", "Array"}], " ", "aux", " ", "just", " ", 
        "contains", " ", "auxiliary", " ", "basis", " ", 
        RowBox[{"exponents", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "=", "1.48386923"}], ";", "\[IndentingNewLine]", 
      RowBox[{"NN2", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "aux", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"orbvals", "=", 
       RowBox[{"OrbitalsAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SauxI", " ", "=", " ", 
       RowBox[{"SAuxInv", "[", 
        RowBox[{"aux", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"aux2", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"aux2", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"aux", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "0", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Amu", " ", "=", " ", 
       RowBox[{"NuclearAttractionCross", "[", 
        RowBox[{"basis", ",", "aux2", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.0"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rhotildes", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"rhotildes", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Tr", "[", 
            RowBox[{"P", ".", 
             RowBox[{"Outer", "[", 
              RowBox[{"Times", ",", "orbvals", ",", 
               RowBox[{"Amu", "[", 
                RowBox[{"[", 
                 RowBox[{"All", ",", "i"}], "]"}], "]"}]}], "]"}]}], "]"}]}], 
          ";"}], "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Cs", " ", "=", " ", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Cs", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"SAuxMetricS", "[", 
            RowBox[{
             RowBox[{"b", "*", 
              RowBox[{"rhoval", "^", 
               RowBox[{"(", 
                RowBox[{"2", "/", "3"}], ")"}]}]}], ",", 
             RowBox[{"aux", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ret", " ", "=", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], "*", "rhoval", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Cs", ".", "SauxI"}], ")"}], ".", "rhotildes"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895675617905226`*^9, 3.5895675885525227`*^9}, {
   3.5895677562855225`*^9, 3.589567913343523*^9}, {3.5895679544365225`*^9, 
   3.589568030159523*^9}, {3.5895684434535227`*^9, 3.589568499359523*^9}, {
   3.589568586220523*^9, 3.5895686263235226`*^9}, {3.5895686631935225`*^9, 
   3.5895687650055227`*^9}, {3.590162185306095*^9, 3.590162187322297*^9}, {
   3.590169227087203*^9, 3.590169249332427*^9}, {3.5901699770971966`*^9, 
   3.5901699773202186`*^9}, {3.590172083523818*^9, 3.5901720843238983`*^9}, {
   3.590172217825247*^9, 3.5901723203244953`*^9}, 3.5917178541058984`*^9, {
   3.69083898827592*^9, 3.6908389888999195`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PiLDAV", "[", 
    RowBox[{"P_", ",", "basis_", ",", "aux_", ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "rhoval_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "b", ",", "NN", ",", "NN2", ",", "orbvals", ",", "Vrho", ",", "aux2", 
       ",", "SauxI", ",", "Amu", ",", "rhotildes", ",", "Vtildes", ",", 
       "Temp", ",", "Cs", ",", "Csrho", ",", "Ret"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "PiLDA", "  ", "potential", " ", "contributions", " ", "at", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", " ", 
       RowBox[{"aux", " ", 
        RowBox[{"basis", "."}]}]}], "   ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "=", "1.48386923"}], ";", "\[IndentingNewLine]", 
      RowBox[{"NN", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "basis", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NN2", " ", "=", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "aux", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"orbvals", "=", 
       RowBox[{"OrbitalsAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Vrho", " ", "=", " ", 
       RowBox[{"Outer", "[", 
        RowBox[{"Times", ",", "orbvals", ",", "orbvals"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SauxI", " ", "=", " ", 
       RowBox[{"SAuxInv", "[", 
        RowBox[{"aux", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"aux2", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"aux2", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"aux", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "0", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Amu", " ", "=", " ", 
       RowBox[{"NuclearAttractionCross", "[", 
        RowBox[{"basis", ",", "aux2", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.0"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rhotildes", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Vtildes", "=", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Temp", "  ", "=", " ", 
           RowBox[{"Outer", "[", 
            RowBox[{"Times", ",", "orbvals", ",", 
             RowBox[{"Amu", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "i"}], "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Vtildes", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Temp", "+", 
              RowBox[{"Transpose", "[", "Temp", "]"}]}], ")"}], "/", "2"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rhotildes", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Tr", "[", 
            RowBox[{"P", ".", "Temp"}], "]"}]}], ";"}], "\[IndentingNewLine]",
          "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Cs", " ", "=", " ", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Csrho", " ", "=", " ", 
       RowBox[{"Array", "[", 
        RowBox[{",", 
         RowBox[{"{", "NN2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "Include", " ", "prefactor", " ", "of", " ", "rho", " ", "in", " ", 
         "these", " ", "coefficients"}], ",", " ", 
        RowBox[{"simplify", " ", "rho", "*", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"rho", "^", 
             RowBox[{"(", 
              RowBox[{"2", "/", "3"}], ")"}]}]}], ",", "rho"}], "]"}], " ", 
         "term"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Cs", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{"rhoval", "*", 
            RowBox[{"SAuxMetricS", "[", 
             RowBox[{
              RowBox[{"aux", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"b", "*", 
               RowBox[{"rhoval", "^", 
                RowBox[{"(", 
                 RowBox[{"2", "/", "3"}], ")"}]}]}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Csrho", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"SAuxMetricS", "[", 
             RowBox[{
              RowBox[{"aux", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"b", "*", 
               RowBox[{"rhoval", "^", 
                RowBox[{"(", 
                 RowBox[{"2", "/", "3"}], ")"}]}]}]}], "]"}], " ", "+", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "/", "3"}], ")"}], "*", "b", "*", 
             RowBox[{"rhoval", "^", 
              RowBox[{"(", 
               RowBox[{"2", "/", "3"}], ")"}]}], "*", 
             RowBox[{"SAuxDerivS", "[", 
              RowBox[{
               RowBox[{"aux", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", 
               RowBox[{"b", "*", 
                RowBox[{"rhoval", "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "/", "3"}], ")"}]}]}]}], "]"}]}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NN2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ret", " ", "=", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], "*", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Vrho", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Csrho", ".", "SauxI"}], ")"}], ".", "rhotildes"}], 
            ")"}]}], "\[IndentingNewLine]", "+", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Cs", ".", "SauxI"}], ")"}], ".", "Vtildes"}]}], " ", 
         "\[IndentingNewLine]", ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Ret", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5895675617905226`*^9, 3.5895675885525227`*^9}, {
   3.5895677562855225`*^9, 3.589567913343523*^9}, {3.5895679544365225`*^9, 
   3.589568030159523*^9}, {3.5895684434535227`*^9, 3.589568499359523*^9}, {
   3.589568586220523*^9, 3.5895686263235226`*^9}, {3.5895686631935225`*^9, 
   3.5895687650055227`*^9}, {3.590162160513616*^9, 3.590162176914256*^9}, {
   3.5901625751280737`*^9, 3.590162624458006*^9}, {3.5901627026528244`*^9, 
   3.590162788049363*^9}, {3.590163033897946*^9, 3.5901630563881946`*^9}, {
   3.590163112735829*^9, 3.590163262004754*^9}, {3.5901652369162254`*^9, 
   3.5901652967502084`*^9}, {3.5901653353670692`*^9, 
   3.5901653356630993`*^9}, {3.590165629016432*^9, 3.590165631007631*^9}, {
   3.590165797846313*^9, 3.590165804708999*^9}, {3.590165890178545*^9, 
   3.5901659262641535`*^9}, {3.590166384508973*^9, 3.59016638487601*^9}, {
   3.5901665127117925`*^9, 3.59016651968749*^9}, {3.590166682934813*^9, 
   3.5901666983753567`*^9}, {3.59016684802232*^9, 3.5901669289134083`*^9}, {
   3.5901672445639706`*^9, 3.590167245314045*^9}, {3.5901692790453978`*^9, 
   3.590169285044998*^9}, {3.5901699825097375`*^9, 3.5901699827167583`*^9}, {
   3.590172327330196*^9, 3.5901723438458476`*^9}, {3.591717858372898*^9, 
   3.591717867068898*^9}, 3.5933691882531123`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Exchange - correlation functionals ", "Section",
 CellChangeTimes->{{3.5895612758025227`*^9, 3.5895612850925226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeFXHF", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Return", "[", 
      RowBox[{"makeK", "[", 
       RowBox[{"P", ",", "I2"}], "]"}], "]"}], ";"}], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.456249401610475*^9, {3.589569569489523*^9, 3.5895695701985226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeEXHF", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "F", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"F", "=", 
       RowBox[{"makeFXHF", "[", 
        RowBox[{"P", ",", "basis", ",", "I2", ",", "maxpt", ",", "aux"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", " ", "[", 
       RowBox[{
        RowBox[{"Tr", "[", 
         RowBox[{"P", ".", "F"}], "]"}], "/", "2"}], " ", "]"}], ";"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.456249401610865*^9, {3.589561305221523*^9, 3.589561312956523*^9}, {
   3.589569572794523*^9, 3.5895695738945227`*^9}, {3.5901640696385098`*^9, 
   3.590164069964542*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeFXLSDA", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoOp", ",", "rhotemp", ",", "FX"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"FX", " ", "=", " ", 
       RowBox[{"Digest", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"6", "/", "Pi"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "3"}], ")"}]}]}], " ", "*", " ", 
          RowBox[{"rhotemp", "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}]}], ",", "  ", "basis", ",", " ", 
         "maxpt"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "FX", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.45624940160913*^9, {3.4631650335040655`*^9, 3.46316503395724*^9}, {
   3.4631673290802917`*^9, 3.4631673307365313`*^9}, {3.589562305534523*^9, 
   3.589562332740523*^9}, {3.589562955524523*^9, 3.5895629643285227`*^9}, 
   3.5895631754465227`*^9, {3.5895695765715227`*^9, 3.589569577207523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeEXLSDA", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RhoOp", ",", "rhotemp", ",", "x", ",", "y", ",", "z", ",", "EX"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"EX", " ", "=", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"3", "/", "4"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"6", "/", "Pi"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "/", "3"}], ")"}]}], "*", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"rhotemp", "^", 
           RowBox[{"(", 
            RowBox[{"4", "/", "3"}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"z", ",", 
            RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
          RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
          RowBox[{"Method", "->", 
           RowBox[{"{", 
            RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
             RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
         "]"}]}]}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "EX", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.456249401609928*^9, {3.4631650909009347`*^9, 3.4631651174350715`*^9}, {
   3.463167384923684*^9, 3.463167385033058*^9}, {3.46316781835841*^9, 
   3.4631678241552477`*^9}, {3.463168175965496*^9, 3.4631681779342337`*^9}, {
   3.4634962659165173`*^9, 3.463496268541484*^9}, {3.463950511849077*^9, 
   3.463950516692827*^9}, {3.5895623346775227`*^9, 3.5895623481105227`*^9}, {
   3.589569579636523*^9, 3.589569580560523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeFXPi0", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RhoOp", ",", "rhotemp", ",", "integrand", ",", "FX", ",", "x", ",", 
       "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"integrand", "=", 
       RowBox[{"PiLDAV0", "[", 
        RowBox[{"P", ",", "basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "rhotemp"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"FX", "=", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{"integrand", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
            RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
        "]"}]}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "FX", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.45624940160913*^9, {3.4631650335040655`*^9, 3.46316503395724*^9}, {
   3.4631673290802917`*^9, 3.4631673307365313`*^9}, {3.589562305534523*^9, 
   3.589562332740523*^9}, {3.589562955524523*^9, 3.5895629643285227`*^9}, 
   3.5895631754465227`*^9, {3.5895695765715227`*^9, 3.589569577207523*^9}, {
   3.5979400647451415`*^9, 3.5979401635549088`*^9}, 3.597940649196395*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeEXPi0", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RhoOp", ",", "rhotemp", ",", "Pitemp", ",", "x", ",", "y", ",", "z", 
       ",", "EX"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pitemp", " ", "=", 
       RowBox[{"PiLDAE0", "[", 
        RowBox[{"P", ",", "basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "rhotemp"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"EX", " ", "=", " ", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{"Pitemp", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
            RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
        "]"}]}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "EX", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589569636649523*^9, 3.5895697083635225`*^9}, {
  3.59794017890521*^9, 3.5979401847707725`*^9}, {3.5979404873942327`*^9, 
  3.59794048778423*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeFXPiLDA", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RhoOp", ",", "rhotemp", ",", "Pitemp", ",", "x", ",", "y", ",", "z", 
       ",", "VX"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pitemp", " ", "=", 
       RowBox[{"PiLDAV", "[", 
        RowBox[{"P", ",", "basis", ",", "aux", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "rhotemp"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"VX", " ", "=", " ", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{"Pitemp", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
            RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
        "]"}]}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "VX", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589569636649523*^9, 3.5895697083635225`*^9}, {
  3.5979464981202517`*^9, 3.597946516730932*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeEXPiLDA", "[", 
    RowBox[{"P_", ",", "basis_", ",", "I2_", ",", "maxpt_", ",", "aux_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RhoOp", ",", "rhotemp", ",", "Pitemp", ",", "x", ",", "y", ",", "z", 
       ",", "EX"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RhoOp", "=", 
       RowBox[{"DensityAtR", "[", 
        RowBox[{"basis", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"rhotemp", "=", 
       RowBox[{"Tr", "[", 
        RowBox[{"P", ".", "RhoOp"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pitemp", " ", "=", 
       RowBox[{"PiLDAE", "[", 
        RowBox[{"P", ",", "basis", ",", "aux", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "rhotemp"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"EX", " ", "=", " ", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{"Pitemp", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", 
           RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
         RowBox[{"MaxPoints", "\[Rule]", "maxpt"}], ",", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
            RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
        "]"}]}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "EX", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589569636649523*^9, 3.5895697083635225`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Self - consistent calculations ", "Section",
 CellChangeTimes->{{3.5895600183615227`*^9, 3.589560024990523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricOrthogonalize", "[", "S_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "sdiag", ",", "U", ",", "splushalf", ",", "sminushalf", ",", "Xm", ",", 
       "Xp"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sdiag", ",", "U"}], "}"}], "=", 
       RowBox[{"Eigensystem", "[", "S", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"splushalf", "=", 
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"N", "[", 
         RowBox[{"sdiag", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sminushalf", "=", 
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"N", "[", 
         RowBox[{"sdiag", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ")"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Xm", "=", 
       RowBox[{
        RowBox[{"Transpose", "[", "U", "]"}], ".", "sminushalf", ".", "U"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"Xp", "=", 
       RowBox[{
        RowBox[{"Transpose", "[", "U", "]"}], ".", "splushalf", ".", "U"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"Xm", ",", "Xp"}], "}"}], "]"}], ";"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.589560072477523*^9, 3.589560090516523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvertS", "[", "S_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sdiag", ",", "U", ",", "sminus", ",", "Xm"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sdiag", ",", "U"}], "}"}], "=", 
       RowBox[{"Eigensystem", "[", "S", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sminus", "=", 
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"N", "[", 
         RowBox[{"sdiag", "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Xm", "=", 
       RowBox[{
        RowBox[{"Transpose", "[", "U", "]"}], ".", "sminus", ".", "U"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "Xm", "]"}], ";"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.676217609593929*^9, 3.6762176594671288`*^9}, 
   3.676218837940729*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalizeFock", "[", 
    RowBox[{"F_", ",", "X_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Ftemp", ",", "vals", ",", "vecs", ",", "sortvals", ",", "sortvecsao"}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Diagonalize", " ", "AO"}], "-", 
        RowBox[{
        "basis", " ", "Fock", " ", "matrix", " ", "and", " ", "return", " ", 
         "corresponding", " ", "AO"}], "-", 
        RowBox[{"basis", " ", "orbitals", " ", "and", " ", 
         RowBox[{"energies", ".", " ", "X"}]}]}], " ", "=", " ", 
       RowBox[{
        RowBox[{"S", "^", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], "}"}]}], " ", "from", " ", "the", 
        " ", "symmetric", " ", "orthogonalized", " ", "overlap", " ", 
        RowBox[{"matrix", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Ftemp", "=", 
       RowBox[{
        RowBox[{"Transpose", "[", "X", "]"}], ".", "F", ".", "X"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
       RowBox[{"Eigensystem", "[", "Ftemp", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sortvals", "=", 
       RowBox[{"Part", "[", 
        RowBox[{"vals", ",", 
         RowBox[{"Ordering", "[", "vals", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sortvecsao", "=", 
       RowBox[{
        RowBox[{"Part", "[", 
         RowBox[{"vecs", ",", 
          RowBox[{"Ordering", "[", "vals", "]"}]}], "]"}], ".", 
        RowBox[{"Transpose", "[", "X", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"sortvals", ",", "sortvecsao"}], "}"}], "]"}], ";"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.454181727256876*^9, 3.454181741834058*^9}, {
  3.589560091892523*^9, 3.5895601147715225`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "AOs_", ",", "aux_", ",", "I2s_", ",", "Na_", ",", "Nb_", ",", "nucleii_",
      ",", "makeFxc_", ",", "makeExc_", ",", "scftol_", ",", "maxit_", ",", 
     "maxpt_", ",", "updatefrac_", ",", 
     RowBox[{"debug_:", "False"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "diff", ",", "Etot", ",", "Enuc", ",", "valsa", ",", "valsb", ",", 
       "vecsa", ",", "vecsb", ",", "J", ",", "S", ",", "X", ",", "Xdum", ",", 
       "T", ",", "Vext", ",", "h1", ",", "vals", ",", "vecs", ",", "Pa", ",", 
       "Pb", ",", "Fxca", ",", "Fxcb", ",", "iteration", ",", "Fa", ",", "Fb",
        ",", "Paold", ",", "Pbold", ",", "Panew", ",", "Pbnew", ",", "Excb"}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"diff", "=", "10000."}], ";", "\[IndentingNewLine]", 
      RowBox[{"Etot", "=", 
       RowBox[{"-", "10000000."}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Enuc", "=", 
       RowBox[{"NuclearRepulsionEnergy", "[", "nucleii", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"valsa", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"valsb", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"J", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"S", "=", 
       RowBox[{"OneElectronOperator", "[", 
        RowBox[{"SAB", ",", "AOs"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Xdum"}], "}"}], "=", 
       RowBox[{"SymmetricOrthogonalize", "[", "S", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"T", "=", 
       RowBox[{"OneElectronOperator", "[", 
        RowBox[{"ATB", ",", "AOs"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Vext", "=", 
       RowBox[{"NuclearAttractionIntegrals", "[", 
        RowBox[{"AOs", ",", "nucleii"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"h1", "=", 
       RowBox[{"T", "+", "Vext"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Initial", " ", "guess"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"debug", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"MatrixForm", "[", "h1", "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
       RowBox[{"DiagonalizeFock", "[", 
        RowBox[{
         RowBox[{"T", "+", "Vext"}], ",", "X"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Pa", " ", "=", " ", 
       RowBox[{"DensityMatrix", "[", 
        RowBox[{"vecs", ",", "Na"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"Pb", " ", "=", " ", 
       RowBox[{"DensityMatrix", "[", 
        RowBox[{"vecs", ",", "Nb"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"Fxca", "=", 
       RowBox[{"0.0", "*", 
        RowBox[{"IdentityMatrix", "[", " ", 
         RowBox[{
          RowBox[{"Dimensions", "[", "AOs", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Fxcb", "=", 
       RowBox[{"0.0", "*", 
        RowBox[{"IdentityMatrix", "[", 
         RowBox[{
          RowBox[{"Dimensions", "[", "AOs", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"SCF", " ", "iterations"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"iteration", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"diff", ">", "scftol"}], ",", 
          RowBox[{"iteration", "<", "maxit"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"iteration", "=", 
           RowBox[{"iteration", "+", "1"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"J", "=", 
           RowBox[{"makeJ", "[", 
            RowBox[{
             RowBox[{"Pa", "+", "Pb"}], ",", "I2s"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Fxca", "=", 
           RowBox[{"makeFxc", "[", 
            RowBox[{"Pa", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{"debug", ",", 
              RowBox[{"Print", "[", 
               RowBox[{"MatrixForm", "[", "Fxca", "]"}], "]"}]}], "]"}], 
            ";"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Nb", ">", "0"}], ",", 
            RowBox[{"Fxcb", "=", 
             RowBox[{"makeFxc", "[", 
              RowBox[{
              "Pb", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
              "]"}]}], ",", 
            RowBox[{"Fxcb", "=", 
             RowBox[{"0.0", "*", 
              RowBox[{"IdentityMatrix", "[", 
               RowBox[{
                RowBox[{"Dimensions", "[", "AOs", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Fa", "=", 
           RowBox[{"h1", "+", "J", "+", "Fxca"}]}], ";", "  ", 
          RowBox[{"Fb", "=", 
           RowBox[{"h1", "+", "J", "+", "Fxcb"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{"debug", ",", 
              RowBox[{"Print", "[", 
               RowBox[{"MatrixForm", "[", "Fa", "]"}], "]"}]}], "]"}], ";"}], 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"valsa", ",", "vecsa"}], "}"}], "=", 
           RowBox[{"DiagonalizeFock", "[", 
            RowBox[{"Fa", ",", "X"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"valsb", ",", "vecsb"}], "}"}], "=", 
           RowBox[{"DiagonalizeFock", "[", 
            RowBox[{"Fb", ",", "X"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Paold", "=", "Pa"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Pbold", "=", "Pb"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Panew", "=", 
           RowBox[{"DensityMatrix", "[", 
            RowBox[{"vecsa", ",", "Na"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Pbnew", "=", 
           RowBox[{"DensityMatrix", "[", 
            RowBox[{"vecsb", ",", "Nb"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Pa", "=", 
           RowBox[{
            RowBox[{"updatefrac", "*", "Panew"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "updatefrac"}], ")"}], "*", "Paold"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"Pb", "=", 
           RowBox[{
            RowBox[{"updatefrac", "*", "Pbnew"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "updatefrac"}], ")"}], "*", "Pbold"}]}]}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"diff", "=", 
           RowBox[{
            RowBox[{"Tr", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Panew", "-", "Paold"}], ")"}], "^", "2"}], "]"}], " ",
             "+", " ", 
            RowBox[{"Tr", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Pbnew", "-", "Pbold"}], ")"}], "^", "2"}], "]"}]}]}], 
          " ", ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"debug", ",", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"Print", "[", "aux", "]"}], ";"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Nb", ">", "0"}], ",", 
                RowBox[{"Excb", "=", 
                 RowBox[{"makeExc", "[", 
                  RowBox[{
                  "Pb", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
                  "]"}]}], ",", 
                RowBox[{"Excb", "=", "0"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Etot", "=", 
               RowBox[{
                RowBox[{"Tr", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Pa", "+", "Pb"}], ")"}], ".", "h1"}], "]"}], " ", 
                "+", " ", 
                RowBox[{
                 RowBox[{"Tr", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"Pa", "+", "Pb"}], ")"}], ".", "J"}], "]"}], "/", 
                 "2"}], "  ", "+", " ", 
                RowBox[{"makeExc", "[", 
                 RowBox[{
                 "Pa", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
                 "]"}], " ", "+", " ", "Excb"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"{", 
                RowBox[{"iteration", ",", "Etot", ",", "diff"}], "}"}], "]"}],
               " ", ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Nb", ">", "0"}], ",", 
        RowBox[{"Excb", "=", 
         RowBox[{"makeExc", "[", 
          RowBox[{"Pb", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
          "]"}]}], ",", 
        RowBox[{"Excb", "=", "0"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Etot", "=", 
       RowBox[{
        RowBox[{"Tr", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Pa", "+", "Pb"}], ")"}], ".", "h1"}], "]"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"Tr", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Pa", "+", "Pb"}], ")"}], ".", "J"}], "]"}], "/", "2"}], 
        "  ", "+", " ", 
        RowBox[{"makeExc", "[", 
         RowBox[{"Pa", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
         "]"}], " ", "+", " ", "Excb"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"Pa", ",", "Pb", ",", 
         RowBox[{"Etot", "+", "Enuc"}], ",", 
         RowBox[{
          RowBox[{"makeExc", "[", 
           RowBox[{"Pa", ",", "AOs", ",", "I2s", ",", "maxpt", ",", "aux"}], 
           "]"}], " ", "+", " ", "Excb"}], ",", "valsa", ",", "valsb", ",", 
         "vecsa", ",", "vecsb"}], "}"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4622929924564967`*^9, 3.462293020737928*^9}, {
   3.4623014393003764`*^9, 3.462301488050064*^9}, {3.4628105303564997`*^9, 
   3.4628105326062837`*^9}, {3.4628116688096976`*^9, 
   3.4628116715281863`*^9}, {3.4631669647388735`*^9, 3.46316696603574*^9}, {
   3.4631678596550207`*^9, 3.4631678596706457`*^9}, {3.4633477507461405`*^9, 
   3.4633477537147193`*^9}, {3.4643715499913054`*^9, 3.4643715514131804`*^9}, 
   3.4643716988194304`*^9, {3.467911296560639*^9, 3.4679112986854486`*^9}, {
   3.492184303284786*^9, 3.492184360097286*^9}, {3.492184391534786*^9, 
   3.492184402144161*^9}, {3.492184584191036*^9, 3.492184612441036*^9}, {
   3.512841895221881*^9, 3.5128419011398807`*^9}, {3.5140575724507694`*^9, 
   3.514057593107835*^9}, {3.5142400048705225`*^9, 3.5142400094629817`*^9}, {
   3.559994454373308*^9, 3.5599944602545457`*^9}, {3.5599945003468027`*^9, 
   3.559994562981204*^9}, {3.5895603004335227`*^9, 3.589560302793523*^9}, {
   3.5895603881245227`*^9, 3.5895604217695227`*^9}, {3.589561253067523*^9, 
   3.589561261425523*^9}, {3.589561449777523*^9, 3.589561465909523*^9}, {
   3.589561664371523*^9, 3.5895616651065226`*^9}, {3.5895695284795227`*^9, 
   3.589569558161523*^9}, {3.589569602678523*^9, 3.589569619706523*^9}, {
   3.590163376003153*^9, 3.590163376323185*^9}, {3.5901635124247932`*^9, 
   3.5901635149760485`*^9}, {3.5933653697165127`*^9, 
   3.5933653813697124`*^9}, {3.60320764299891*^9, 3.60320765343531*^9}, {
   3.6122786826078253`*^9, 3.6122786847198253`*^9}, {3.6150482909255915`*^9, 
   3.615048306246591*^9}, {3.6908175954529195`*^9, 3.6908176146939197`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Example 1: Adding a fraction of a minority-spin electron to 3-21G H atom\
\>", "Section",
 CellChangeTimes->{{3.661621342641461*^9, 3.661621350394661*^9}, {
   3.6627451188471937`*^9, 3.662745142730794*^9}, {3.6908126575879197`*^9, 
   3.6908126739049196`*^9}, {3.6908176384709196`*^9, 3.6908176392259197`*^9}, 
   3.6908295937849197`*^9, {3.6908297336259193`*^9, 3.69082977436092*^9}, {
   3.6908304712289195`*^9, 3.69083047323592*^9}, 3.6908305522739196`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"basis", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.447178", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.824547", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.183192", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.0", ",", 
      RowBox[{"{", 
       RowBox[{"0.", ",", "0.", ",", "0"}], "}"}]}], "}"}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.6761351092839966`*^9, 3.676135109689597*^9}, {
   3.6761351513899965`*^9, 3.6761351846989965`*^9}, {3.676135358063997*^9, 
   3.676135358638997*^9}, {3.6908129781489196`*^9, 3.6908130242089195`*^9}, {
   3.6908130745749197`*^9, 3.6908130856799192`*^9}, {3.6908297671489196`*^9, 
   3.69082976972392*^9}, {3.6908299217919197`*^9, 3.69082998090292*^9}, 
   3.6908305522749195`*^9, 3.694194899968175*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.447178`", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.824547`", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.183192`", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.69082998804692*^9, 3.69083055227592*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", " ", "=", " ", 
   RowBox[{"TwoElectronIntegrals", "[", "basis", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.676135190576997*^9, 3.6761351945289965`*^9}, 
   3.6791522448093553`*^9, {3.6908299831019197`*^9, 3.6908299861809196`*^9}, 
   3.6908305522769194`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF00", ",", "a", ",", "va00", ",", "vb00", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.0", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF01", ",", "a", ",", "va01", ",", "vb01", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.1", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF02", ",", "a", ",", "va02", ",", "vb02", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.2", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF03", ",", "a", ",", "va03", ",", "vb03", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.3", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF04", ",", "a", ",", "va04", ",", "vb04", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.4", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF05", ",", "a", ",", "va05", ",", "vb05", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.5", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF06", ",", "a", ",", "va06", ",", "vb06", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.6", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF07", ",", "a", ",", "va07", ",", "vb07", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.7", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF08", ",", "a", ",", "va08", ",", "vb08", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.8", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF09", ",", "a", ",", "va09", ",", "vb09", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.9", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EHF10", ",", "a", ",", "va10", ",", "vb10", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "1.0", ",", "n", ",", 
     "makeFXHF", ",", "makeEXHF", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
     "False"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6908303981219196`*^9, 3.6908303982409196`*^9}, {
  3.6908304763269196`*^9, 3.6908305017659197`*^9}, {3.69083055227792*^9, 
  3.69083060068592*^9}, {3.6908306946689196`*^9, 3.6908307813359194`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EHFs", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0", ",", ".1", ",", ".2", ",", ".3", ",", ".4", ",", ".5", ",", ".6", 
        ",", ".7", ",", ".8", ",", ".9", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "EHF00", ",", "EHF01", ",", "EHF02", ",", "EHF03", ",", "EHF04", ",", 
        "EHF05", ",", "EHF06", ",", "EHF07", ",", "EHF08", ",", "EHF09", ",", 
        "EHF10"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908310381359196`*^9, 3.69083105009192*^9}, {
  3.6908311261799192`*^9, 3.69083114983492*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA00", ",", "a", ",", "va00", ",", "vb00", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.0", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA01", ",", "a", ",", "va01", ",", "vb01", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.1", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA02", ",", "a", ",", "va02", ",", "vb02", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.2", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA03", ",", "a", ",", "va03", ",", "vb03", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.3", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA04", ",", "a", ",", "va04", ",", "vb04", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.4", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA05", ",", "a", ",", "va05", ",", "vb05", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.5", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA06", ",", "a", ",", "va06", ",", "vb06", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.6", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA07", ",", "a", ",", "va07", ",", "vb07", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.7", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA08", ",", "a", ",", "va08", ",", "vb08", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.8", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA09", ",", "a", ",", "va09", ",", "vb09", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "0.9", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "ELDA10", ",", "a", ",", "va10", ",", "vb10", ",", 
     "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"{", "}"}], ",", "int", ",", "1", ",", "1.0", ",", "n", ",", 
     "makeFXLSDA", ",", "makeEXLSDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6908303981219196`*^9, 3.6908303982409196`*^9}, {
  3.6908304763269196`*^9, 3.6908305017659197`*^9}, {3.69083055227792*^9, 
  3.69083060068592*^9}, {3.6908306946689196`*^9, 3.6908307813359194`*^9}, {
  3.6908308673909197`*^9, 3.6908309596449194`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ELDAs", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0", ",", ".1", ",", ".2", ",", ".3", ",", ".4", ",", ".5", ",", ".6", 
        ",", ".7", ",", ".8", ",", ".9", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "ELDA00", ",", "ELDA01", ",", "ELDA02", ",", "ELDA03", ",", "ELDA04", 
        ",", "ELDA05", ",", "ELDA06", ",", "ELDA07", ",", "ELDA08", ",", 
        "ELDA09", ",", "ELDA10"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908306044779196`*^9, 3.69083064194092*^9}, {
  3.6908309306279197`*^9, 3.6908309370669193`*^9}, {3.6908310730929193`*^9, 
  3.69083108426892*^9}, {3.69083115821192*^9, 3.69083116133492*^9}}],

Cell[BoxData[
 RowBox[{"auxbasis", "=", 
  RowBox[{"{", 
   RowBox[{"10.", ",", 
    RowBox[{"10.", "/", "8."}], ",", 
    RowBox[{"10.", "/", 
     RowBox[{"8.", "^", "2"}]}], ",", 
    RowBox[{"10.", "/", 
     RowBox[{"8.", "^", "3"}]}]}], "}"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Very", " ", "small", " ", "auxiliary", " ", "basis", " ", "set"}],
    " ", "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA00", ",", "a", ",", "vaPiLDA00", ",", "vb00",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.0", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908312586169195`*^9, 3.6908312755109196`*^9}, 
   3.6911626103299923`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA01", ",", "a", ",", "vaPiLDA00", ",", "vb00",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.1", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908383473809195`*^9, 3.6908383499319196`*^9}, 
   3.6911626109060497`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA02", ",", "a", ",", "vaPiLDA00", ",", "vb00",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.2", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908312897749195`*^9, 3.6908312926539197`*^9}, 
   3.691162611656125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA03", ",", "a", ",", "vaPiLDA03", ",", "vb03",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.3", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908383570109196`*^9, 3.6908383705489197`*^9}, 
   3.6911626122031794`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA04", ",", "a", ",", "vaPiLDA04", ",", "vb04",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.4", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908337627329197`*^9, 3.69083377223592*^9}, 
   3.691162612748234*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA05", ",", "a", ",", "vaPiLDA05", ",", "vb05",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.5", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.69083837815792*^9, 3.6908383846569195`*^9}, 
   3.691162613298289*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA06", ",", "a", ",", "vaPiLDA06", ",", "vb06",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.6", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.69083839192892*^9, 3.69083839753292*^9}, 
   3.691162613858345*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA07", ",", "a", ",", "vaPiLDA07", ",", "vb07",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.7", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908384229459195`*^9, 3.6908384272479196`*^9}, 
   3.691162614418401*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA08", ",", "a", ",", "vaPiLDA08", ",", "vb08",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.8", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908337911239195`*^9, 3.6908338007789197`*^9}, 
   3.691162614986458*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA09", ",", "a", ",", "vaPiLDA09", ",", "vb09",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.9", ",", "n", ",",
      "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908384062699194`*^9, 3.6908384152199197`*^9}, 
   3.6911626155915184`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA10", ",", "a", ",", "vaPiLDA10", ",", "vb10",
      ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "1", ",", "n", ",", 
     "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.690852293381835*^9, 3.6908523043428345`*^9}, 
   3.691162617138673*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EPiLDAs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "EPiLDA00"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", "EPiLDA01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", "EPiLDA02"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", "EPiLDA03"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", "EPiLDA04"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", "EPiLDA05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", "EPiLDA06"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", "EPiLDA07"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", "EPiLDA08"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".9", ",", "EPiLDA09"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "EPiLDA10"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6908313098759193`*^9, 3.6908313234449196`*^9}, {
  3.6908338087299194`*^9, 3.6908338226409197`*^9}, {3.6908522026588345`*^9, 
  3.690852258815835*^9}, {3.6908949156230607`*^9, 3.6908949199184904`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Calculations", " ", "without", " ", "an", " ", "auxiliary", " ", "basis", 
   " ", "set"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.691166071594084*^9, 3.691166080786003*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA000", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.0", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232236952324`*^9, 3.6909232240072327`*^9}, {3.690923277152232*^9, 
  3.6909232774632325`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA010", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.1", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232272262325`*^9, 3.6909232273002324`*^9}, {3.6909232750362325`*^9, 
  3.6909232751232324`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA020", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.2", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232295622325`*^9, 3.6909232296182327`*^9}, {3.6909232726312323`*^9, 
  3.6909232726902323`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA030", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.3", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232321542325`*^9, 3.690923232225232*^9}, {3.6909232700882325`*^9, 
  3.690923270159232*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA040", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.4", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232359772325`*^9, 3.6909232360562325`*^9}, {3.6909232671762323`*^9, 
  3.6909232672522326`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA050", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.5", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA060", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.6", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232424032326`*^9, 3.6909232646282325`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA070", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.7", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.690923244817232*^9, 3.6909232622202325`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA080", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.8", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232473842325`*^9, 3.690923259718232*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA090", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "0.9", ",", "n", ",",
      "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232498982325`*^9, 3.6909232570662327`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Pa", ",", "Pb", ",", "EPiLDA100", ",", "a", ",", "va05", ",", "vb05", 
     ",", "d", ",", "e"}], "}"}], " ", "=", 
   RowBox[{"DoUSCF", "[", 
    RowBox[{
    "basis", ",", "auxbasis", ",", "int", ",", "1", ",", "1", ",", "n", ",", 
     "makeFXPi0", ",", "makeEXPi0", ",", 
     RowBox[{"10", "^", 
      RowBox[{"(", 
       RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "10000", ",", "0.8", ",",
      "False"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909215451642323`*^9, 3.6909215689702325`*^9}, {
  3.6909232524252324`*^9, 3.6909232553842325`*^9}, {3.6909232899102325`*^9, 
  3.690923291086232*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EPiLDA0s", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "EPiLDA000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", "EPiLDA010"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", "EPiLDA020"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".3", ",", "EPiLDA030"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".4", ",", "EPiLDA040"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".5", ",", "EPiLDA050"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", "EPiLDA060"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", "EPiLDA070"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", "EPiLDA080"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".9", ",", "EPiLDA090"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "EPiLDA100"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6911526329873576`*^9, 3.6911526663706956`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Interpolate", " ", "LDA", " ", "correlation", " ", "energies", " ", "from",
    " ", "Gaussian", " ", "calculations", " ", "on", " ", "H", "  ", "H", 
   RowBox[{"(", "-", ")"}], " ", "dissociated", " ", "H2", 
   RowBox[{"(", "-", ")"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6909160204622326`*^9, 3.6909160535582323`*^9}, {
  3.6909188795632324`*^9, 3.6909189091612325`*^9}, {3.69116611315724*^9, 
  3.691166121118036*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EcLDA0", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "0.022254790967"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", " ", 
      RowBox[{
       RowBox[{"-", "0.154155559232"}], "/", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"-", "0.123091313931"}], "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "0.087300401090"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.690916057296232*^9, 3.690916068133232*^9}, {
   3.6909167396422324`*^9, 3.690916743522232*^9}, {3.6909178096442327`*^9, 
   3.6909178842152324`*^9}, 3.6909185033382325`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "0.022254790967`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     RowBox[{"-", "0.05138518641066667`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", "0.0615456569655`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "0.08730040109`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6909178850902324`*^9, 3.690918504133232*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EcLDA1", "=", " ", 
  RowBox[{
   RowBox[{"-", "0.02225479096"}], " ", "+", " ", 
   RowBox[{"c1", "*", "nn"}], "+", 
   RowBox[{"c2", "*", 
    RowBox[{"nn", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6909185312522326`*^9, 3.6909185886222324`*^9}, {
   3.690918713456232*^9, 3.6909187213112326`*^9}, 3.690918758461232*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.02225479096`"}], "+", 
  RowBox[{"c1", " ", "nn"}], "+", 
  RowBox[{"c2", " ", 
   SuperscriptBox["nn", "2"]}]}]], "Output",
 CellChangeTimes->{{3.6909187137812324`*^9, 3.6909187218422327`*^9}, 
   3.6909187594732323`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToMinimize", "=", 
  RowBox[{"Tr", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"EcLDA0", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", 
        RowBox[{"(", 
         RowBox[{"EcLDA1", "/.", 
          RowBox[{"nn", "\[Rule]", 
           RowBox[{"EcLDA0", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], ")"}]}], ")"}], "^", 
      "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6909185894662323`*^9, 3.6909187623182325`*^9}}],

Cell[BoxData[
 RowBox[{"4.9000017823009444`*^-23", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.06504561012999999`"}], "-", "c1", "-", "c2"}], ")"}], 
   "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.0392908660055`"}], "-", 
     FractionBox["c1", "2"], "-", 
     FractionBox["c2", "4"]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.029130395450666667`"}], "-", 
     FractionBox["c1", "3"], "-", 
     FractionBox["c2", "9"]}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{{3.6909186915582323`*^9, 3.6909187631982327`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"err", ",", "vals"}], "}"}], " ", "=", " ", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{"ToMinimize", ",", 
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6909187366632323`*^9, 3.6909187712572327`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1384238470101294`*^-6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", 
      RowBox[{"-", "0.0950318536021777`"}]}], ",", 
     RowBox[{"c2", "\[Rule]", "0.03007454649369834`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6909187497452326`*^9, 3.690918771638232*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EcLDA", " ", "=", " ", 
   RowBox[{"EcLDA1", "/.", "vals"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6909187727232323`*^9, 3.6909187788602324`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ELDAs2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ELDAs", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"ELDAs", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", 
        RowBox[{"(", 
         RowBox[{"EcLDA", "/.", 
          RowBox[{"nn", "->", 
           RowBox[{"ELDAs", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "11"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.690918919942232*^9, 3.6909189617972326`*^9}, {
  3.6909189942482324`*^9, 3.690919043237232*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EPiLDAs2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EPiLDAs", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"EPiLDAs", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", 
        RowBox[{"(", 
         RowBox[{"EcLDA", "/.", 
          RowBox[{"nn", "->", 
           RowBox[{"EPiLDAs", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "11"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EPiLDA0s2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EPiLDA0s", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"EPiLDA0s", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", 
        RowBox[{"(", 
         RowBox[{"EcLDA", "/.", 
          RowBox[{"nn", "->", 
           RowBox[{"EPiLDA0s", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "11"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6909190493422327`*^9, 3.6909190584692326`*^9}, {
  3.6911526937164297`*^9, 3.691152705526611*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Total", " ", "energies", " ", "per", " ", "atom", " ", "from", " ", 
     "Gaussian", " ", "calculations", " ", "on", " ", "H"}], ",", " ", 
    RowBox[{"H", 
     RowBox[{"(", "-", ")"}]}], ",", " ", 
    RowBox[{"and", " ", "stretched", " ", "H2", 
     RowBox[{"(", "-", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"GauHF", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.496203888709"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{
          RowBox[{"-", "0.890988511028"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "0.404595243641"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GauLDA", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.472952041725"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{
          RowBox[{"-", "0.976538259261"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "0.412739617304"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GauPiLDA", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.457251640960"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{
          RowBox[{"-", "0.890224586130"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "0.382924111366"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GauPiPBE", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.491411323560"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{
          RowBox[{"-", "0.946799256793"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "0.426177342455"}]}], "}"}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.691157078204835*^9, 3.6911571412171354`*^9}, {
  3.6911573492749395`*^9, 3.6911574076317744`*^9}, {3.6911575558865986`*^9, 
  3.69115759170218*^9}, {3.691166136942618*^9, 3.6911661417981033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "EHFs", ",", "ELDAs2", ",", "EPiLDAs2", ",", "GauHF", ",", "GauLDA", ",", 
     "GauPiLDA"}], "}"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", "]"}], ",", 
      RowBox[{"Graphics", "[", "]"}], ",", 
      RowBox[{"Graphics", "[", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", ".05"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Green", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", ".05"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", ".05"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", ".05"}], "}"}]}], 
     "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Green"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Black"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Green"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "Red"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", 
        RowBox[{"-", "0.38"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Number minority-spin electrons\>\"", ",", 
      "\"\<Total energy (au)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<HF\>\"", ",", "\"\<LDA\>\"", ",", "\"\<\[CapitalPi]LDA\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", "0.7"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.8"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "15"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.690902109247351*^9, 3.6909021662670527`*^9}, {
  3.690902330712496*^9, 3.690902391843608*^9}, {3.6909024255499783`*^9, 
  3.690902478830306*^9}, {3.690902515021925*^9, 3.6909025202134438`*^9}, {
  3.690902595338956*^9, 3.6909026410435257`*^9}, {3.6909026863850594`*^9, 
  3.690902774207841*^9}, {3.6909190640972323`*^9, 3.6909190953722324`*^9}, {
  3.6909196909672327`*^9, 3.6909196981322327`*^9}, {3.6911527110881667`*^9, 
  3.691152763395397*^9}, {3.6911527965517125`*^9, 3.691152801078165*^9}, {
  3.6911571477407875`*^9, 3.6911572171327267`*^9}, {3.691157266054618*^9, 
  3.6911572825202646`*^9}, {3.691157319411953*^9, 3.6911573374667587`*^9}, {
  3.691157376646676*^9, 3.691157377812793*^9}, {3.691157438130824*^9, 
  3.691157439537965*^9}, {3.6911575955105605`*^9, 3.6911576513381424`*^9}, {
  3.6911586362096195`*^9, 3.6911586399839973`*^9}, {3.691158708149813*^9, 
  3.691158772746272*^9}}],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQDQPuZzq/nD14f/+smSCw034ut5PYWn4Y/6S94f4N
inHJ9/Ybg8Fle1OR2G6OvXeh8jft123vvHhD5u5+iGkP7EVWsJV+b7oDVf/Y
fuLSqqje97f3p4HBM/u5+VskdiTdhup/af+Jra5zxp1b+8+eAYE39p0bTa54
xN6CmvfB/or+ddl7T27uh7lXzv1hxm6ne3D3rtbZ5Wm77R7cvaZGYgc1Ne/D
3Zt6Rqalo/A+3L2Ge5df3dl0H+7eC94SFW9D78Pd+2vvho53z+7B3bvmPavv
W6N7cPd+KXnK9cn8Lty9Ajxv5k/8chvuXjueKRkH0m/B3Xs+3mvKbdO7cPf+
09tg8dbwLty9DU+OZBjp3IW7V/bel+xkUUT4Jh1iCpR+cgfu3g3HZSYsn4gI
3y+PxPjeS9yBu/fNWcs/8yoQ4Vuy68JTnRWI8G2oULmfvfwm3L2/q/Mm8JXc
gLt33VlIeoDZ1+NcH/ar6Q5cvXbn46LHSPGR6vRp8Q2Xe3D1gca3NM/a34er
l0tpzQ3OQoSH/+m/SXOcEekl5UCB644ahPkJa08pXmm8sR8AF9U3tw==
      "], {{{}, {}, 
        {GrayLevel[0], Thickness[Large], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}]}, 
        {RGBColor[0, 1, 0], Thickness[Large], 
         LineBox[{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22}]}, 
        {RGBColor[0, 0, 1], Thickness[Large], 
         LineBox[{23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33}]}, 
        {GrayLevel[0], Dashing[{0, Small}], LineBox[{34, 35, 36}]}, 
        {RGBColor[0, 1, 0], Dashing[{0, Small}], LineBox[{37, 38, 39}]}, 
        {RGBColor[0, 0, 1], Dashing[{0, Small}], LineBox[{40, 41, 42}]}}, {
        {GrayLevel[0], Thickness[Large], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 1], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 2], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 3], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 4], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 5], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 6], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 7], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 8], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 9], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 10], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Thickness[Large]}], 11]}, 
        {RGBColor[0, 1, 0], Thickness[Large], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 12], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 13], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 14], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 15], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 16], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 17], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 18], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 19], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 20], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 21], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Thickness[Large]}], 22]}, 
        {RGBColor[0, 0, 1], Thickness[Large], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 23], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 24], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 25], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 26], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 27], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 28], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 29], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 30], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 31], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 32], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Thickness[Large]}], 33]}, 
        {GrayLevel[0], Dashing[{0, Small}], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 34, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 35, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {GrayLevel[0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 36, 
          Automatic, Scaled[{0.05, 0.05}]]}, 
        {RGBColor[0, 1, 0], Dashing[{0, Small}], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 37, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 38, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {RGBColor[0, 1, 0], Dashing[{0, Small}], DiskBox[{0, 0}]}], 39, 
          Automatic, Scaled[{0.05, 0.05}]]}, 
        {RGBColor[0, 0, 1], Dashing[{0, Small}], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Dashing[{0, Small}], DiskBox[{0, 0}]}], 40, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Dashing[{0, Small}], DiskBox[{0, 0}]}], 41, 
          Automatic, Scaled[{0.05, 0.05}]], InsetBox[
          GraphicsBox[
           {RGBColor[0, 0, 1], Dashing[{0, Small}], DiskBox[{0, 0}]}], 42, 
          Automatic, Scaled[{0.05, 0.05}]]}, {}}}], {}}, InsetBox[
     TemplateBox[{"\"HF\"","\"LDA\"","\"\[CapitalPi]LDA\""},
      "LineLegend",
      DisplayFunction->(StyleBox[
        StyleBox[
         PaneBox[
          TagBox[
           GridBox[{{
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    GrayLevel[0]], {
                    InsetBox[
                    GraphicsBox[{}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    GrayLevel[0]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, ImageSize -> {20, 10},
                    PlotRangePadding -> None, ImagePadding -> 1, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 1, 0]], {
                    InsetBox[
                    GraphicsBox[{}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 1, 0]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, ImageSize -> {20, 10},
                    PlotRangePadding -> None, ImagePadding -> 1, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 0, 1]], {
                    InsetBox[
                    GraphicsBox[{}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[{
                    Opacity[0.3], 
                    GrayLevel[0]}], 
                    Thickness[Large], 
                    RGBColor[0, 0, 1]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, ImageSize -> {20, 10},
                    PlotRangePadding -> None, ImagePadding -> 1, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.8}}}],
                "Grid"]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
           "Grid"], Alignment -> Left, AppearanceElements -> None, 
          ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"],
          LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Times"}, 
        Background -> Automatic, StripOnInput -> False]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"GrayLevel", "[", "0", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"GrayLevel", "[", "0", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Column\"", ",", 
                 RowBox[{"{", 
                   RowBox[{"Automatic", ",", "5"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 GraphicsBox[{}], ",", 
                 GraphicsBox[{}], ",", 
                 GraphicsBox[{}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    GrayLevel[0], 
                    DiskBox[{0, 0}]}], ",", "0.05`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    RGBColor[0, 1, 0], 
                    DiskBox[{0, 0}]}], ",", "0.05`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    RGBColor[0, 0, 1], 
                    DiskBox[{0, 0}]}], ",", "0.05`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    RGBColor[1, 0, 0], 
                    DiskBox[{0, 0}]}], ",", "0.05`"}], "}"}]}], "}"}]}]}], 
         "]"}]& )], Scaled[{0.3, 0.7}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->0.8,
   Axes->True,
   AxesOrigin->{0, -0.5},
   BaseStyle->{FontSize -> 15},
   Frame->True,
   FrameLabel->{{
      FormBox["\"Total energy (au)\"", TraditionalForm], None}, {
      FormBox["\"Number minority-spin electrons\"", TraditionalForm], None}},
   ImageSize->300,
   Method->{},
   PlotRange->{{0, 1}, {-0.5, -0.38}},
   PlotRangeClipping->True,
   PlotRangePadding->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, 
      GraphicsComplex[CompressedData["
1:eJxTTMoPSmViYGDQAmIQDQPuZzq/nD14f/+smSCw034ut5PYWn4Y/6S94f4N
inHJ9/Ybg8Fle1OR2G6OvXeh8jft123vvHhD5u5+iGkP7EVWsJV+b7oDVf/Y
fuLSqqje97f3p4HBM/u5+VskdiTdhup/af+Jra5zxp1b+8+eAYE39p0bTa54
xN6CmvfB/or+ddl7T27uh7lXzv1hxm6ne3D3rtbZ5Wm77R7cvaZGYgc1Ne/D
3Zt6Rqalo/A+3L2Ge5df3dl0H+7eC94SFW9D78Pd+2vvho53z+7B3bvmPavv
W6N7cPd+KXnK9cn8Lty9Ajxv5k/8chvuXjueKRkH0m/B3Xs+3mvKbdO7cPf+
09tg8dbwLty9DU+OZBjp3IW7V/bel+xkUUT4Jh1iCpR+cgfu3g3HZSYsn4gI
3y+PxPjeS9yBu/fNWcs/8yoQ4Vuy68JTnRWI8G2oULmfvfwm3L2/q/Mm8JXc
gLt33VlIeoDZ1+NcH/ar6Q5cvXbn46LHSPGR6vRp8Q2Xe3D1gca3NM/a34er
l0tpzQ3OQoSH/+m/SXOcEekl5UCB644ahPkJa08pXmm8sR8AF9U3tw==
       "], {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           GrayLevel[0]], 
          Line[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}]}, {
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           RGBColor[0, 1, 0]], 
          Line[{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22}]}, {
          Hue[0.1421359549995791, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           RGBColor[0, 0, 1]], 
          Line[{23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33}]}, {
          Hue[0.37820393249936934`, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           GrayLevel[0]], 
          Line[{34, 35, 36}]}, {
          Hue[0.6142719099991583, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           RGBColor[0, 1, 0]], 
          Line[{37, 38, 39}]}, {
          Hue[0.8503398874989481, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           RGBColor[0, 0, 1]], 
          Line[{40, 41, 42}]}}, {{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           GrayLevel[0]], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 1], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 2], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 3], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 4], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 5], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 6], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 7], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 8], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 9], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 10], 
          Inset[
           Graphics[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              GrayLevel[0]]}], 11]}, {
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           RGBColor[0, 1, 0]], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 12], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 13], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 14], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 15], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 16], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 17], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 18], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 19], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 20], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 21], 
          Inset[
           Graphics[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 1, 0]]}], 22]}, {
          Hue[0.1421359549995791, 0.6, 0.6], 
          Directive[
           Thickness[Large], 
           RGBColor[0, 0, 1]], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 23], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 24], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 25], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 26], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 27], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 28], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 29], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 30], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 31], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 32], 
          Inset[
           Graphics[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              Thickness[Large], 
              RGBColor[0, 0, 1]]}], 33]}, {
          Hue[0.37820393249936934`, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           GrayLevel[0]], 
          Inset[
           Graphics[{
             Hue[0.37820393249936934`, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              GrayLevel[0]], 
             GrayLevel[0], 
             Disk[{0, 0}]}], 34, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.37820393249936934`, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              GrayLevel[0]], 
             GrayLevel[0], 
             Disk[{0, 0}]}], 35, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.37820393249936934`, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              GrayLevel[0]], 
             GrayLevel[0], 
             Disk[{0, 0}]}], 36, Automatic, 
           Scaled[{0.05, 0.05}]]}, {
          Hue[0.6142719099991583, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           RGBColor[0, 1, 0]], 
          Inset[
           Graphics[{
             Hue[0.6142719099991583, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 1, 0]], 
             RGBColor[0, 1, 0], 
             Disk[{0, 0}]}], 37, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.6142719099991583, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 1, 0]], 
             RGBColor[0, 1, 0], 
             Disk[{0, 0}]}], 38, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.6142719099991583, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 1, 0]], 
             RGBColor[0, 1, 0], 
             Disk[{0, 0}]}], 39, Automatic, 
           Scaled[{0.05, 0.05}]]}, {
          Hue[0.8503398874989481, 0.6, 0.6], 
          Directive[
           Dashing[{0, Small}], 
           RGBColor[0, 0, 1]], 
          Inset[
           Graphics[{
             Hue[0.8503398874989481, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 0, 1]], 
             RGBColor[0, 0, 1], 
             Disk[{0, 0}]}], 40, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.8503398874989481, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 0, 1]], 
             RGBColor[0, 0, 1], 
             Disk[{0, 0}]}], 41, Automatic, 
           Scaled[{0.05, 0.05}]], 
          Inset[
           Graphics[{
             Hue[0.8503398874989481, 0.6, 0.6], 
             Directive[
              Dashing[{0, Small}], 
              RGBColor[0, 0, 1]], 
             RGBColor[0, 0, 1], 
             Disk[{0, 0}]}], 42, Automatic, 
           Scaled[{0.05, 0.05}]]}, {}}}], {}}, {
     FrameLabel -> {{"Total energy (au)", None}, {
        "Number minority-spin electrons", None}}, AspectRatio -> 0.8, Axes -> 
      True, AxesOrigin -> {0, -0.5}, BaseStyle -> {FontSize -> 15}, Frame -> 
      True, FrameLabel -> {
       "Number minority-spin electrons", "Total energy (au)"}, ImageSize -> 
      300, Method -> {}, PlotRange -> {{0, 1}, {-0.5, -0.38}}, 
      PlotRangeClipping -> True, 
      PlotRangePadding -> {Automatic, Automatic}}], {
     Placed[
      Unevaluated[
       LineLegend[{
         Directive[
          Thickness[Large], 
          GrayLevel[0]], 
         Directive[
          Thickness[Large], 
          RGBColor[0, 1, 0]], 
         Directive[
          Thickness[Large], 
          RGBColor[0, 0, 1]], 
         Directive[
          Dashing[{0, Small}], 
          GrayLevel[0]], 
         Directive[
          Dashing[{0, Small}], 
          RGBColor[0, 1, 0]], 
         Directive[
          Dashing[{0, Small}], 
          RGBColor[0, 0, 1]]}, {"HF", "LDA", "\[CapitalPi]LDA"}, 
        LegendLayout -> {"Column", {Automatic, 5}}, LegendMarkers -> {
          Graphics[{}], 
          Graphics[{}], 
          Graphics[{}], {
           Graphics[{
             GrayLevel[0], 
             Disk[{0, 0}]}], 0.05}, {
           Graphics[{
             RGBColor[0, 1, 0], 
             Disk[{0, 0}]}], 0.05}, {
           Graphics[{
             RGBColor[0, 0, 1], 
             Disk[{0, 0}]}], 0.05}, {
           Graphics[{
             RGBColor[1, 0, 0], 
             Disk[{0, 0}]}], 0.05}}]], {0.3, 0.7}, Identity]}]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.691158745439542*^9, 3.691158778901888*^9}, 
   3.6911595892609158`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Example 2 : Spin polarization of central atom in H2 + H transition state \
\>", "Section",
 CellChangeTimes->{{3.694195453266175*^9, 3.694195463771175*^9}, {
  3.69419822962436*^9, 3.69419823118436*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hbasis", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "1.75"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", 
         RowBox[{"-", "1.75"}]}], "}"}]}], "}"}]}], "}"}]}], ";", 
  RowBox[{"nH", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "1.75"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.", ",", 
         RowBox[{"-", "1.75"}]}], "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6761351092839966`*^9, 3.676135109689597*^9}, {
  3.6761351513899965`*^9, 3.6761351846989965`*^9}, {3.676135358063997*^9, 
  3.676135358638997*^9}, {3.6908129781489196`*^9, 3.6908130242089195`*^9}, {
  3.6908130745749197`*^9, 3.6908130856799192`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"intH", " ", "=", " ", 
   RowBox[{"TwoElectronIntegrals", "[", "Hbasis", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.676135190576997*^9, 3.6761351945289965`*^9}, 
   3.6791522448093553`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "PaHF", ",", "PbHF", ",", "EtotHF", ",", "ExHF", ",", "valsaHF", ",", 
      "valsbHF", ",", "vecsaHF", ",", "vecsbHF"}], "}"}], " ", "=", 
    RowBox[{"DoUSCF", "[", 
     RowBox[{"Hbasis", ",", 
      RowBox[{"{", "}"}], ",", "intH", ",", "2", ",", "1", ",", "nH", ",", 
      "makeFXHF", ",", "makeEXHF", ",", 
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "100", ",", "0.8", ",", 
      "False"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Unrestricted", " ", "Hartree"}], "-", 
    RowBox[{"Fock", " ", "calculation"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6761352126729965`*^9, 3.6761352221919966`*^9}, {
  3.676219441707529*^9, 3.6762194507399287`*^9}, {3.676220792821529*^9, 
  3.6762207976419287`*^9}, {3.679243069497349*^9, 3.679243076578349*^9}, {
  3.6908130321849194`*^9, 3.6908130337529197`*^9}, {3.69081314053292*^9, 
  3.69081315153292*^9}, {3.69081557953292*^9, 3.6908155882989197`*^9}, {
  3.69081756547392*^9, 3.6908175659899197`*^9}, {3.6908260253719196`*^9, 
  3.69082602834892*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EtotHF", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Gaussian", " ", "gives"}], " ", "-", "1.33183706289"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.676135340546997*^9, 3.6761353732129965`*^9}, 
   3.6762192305605288`*^9, 3.679243079168349*^9, 3.6908130543239193`*^9, 
   3.69081315494792*^9}],

Cell[BoxData[
 RowBox[{"-", "1.3318370013351761`"}]], "Output",
 CellChangeTimes->{{3.6761353416119967`*^9, 3.6761353736589966`*^9}, 
   3.676213293492129*^9, {3.676220786300729*^9, 3.6762208022127285`*^9}, 
   3.679151675230962*^9, {3.67915221289196*^9, 3.67915224718054*^9}, 
   3.679152414568433*^9, 3.679154705328833*^9, 3.679155673870233*^9, 
   3.679156861702033*^9, 3.679158468039033*^9, 3.6791585310318327`*^9, 
   3.679163021500433*^9, 3.679164606240633*^9, 3.679243079517349*^9, 
   3.6797501765204506`*^9, 3.6797584581118507`*^9, 3.6797586917374506`*^9, 
   3.679758875212651*^9, 3.6797608455788507`*^9, 3.6798352285702906`*^9, 
   3.6799212211664*^9, 3.6799394918745966`*^9, 3.6908130377399197`*^9, 
   3.6908130910309196`*^9, 3.69081315545492*^9, 3.694195550982375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"PaHF", "-", "PbHF"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "UHF", " ", "spin", " ", "density", " ", "matrix", " ", "shows", " ", 
     "substantial", " ", "negative"}], "-", 
    RowBox[{
    "spin", " ", "population", " ", "on", " ", "central", " ", "H", " ", 
     "atom"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.69081305971692*^9, 3.69081311786092*^9}, {
  3.6908131580289197`*^9, 3.6908131626919193`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.656891076905461`", 
      RowBox[{"-", "0.002840853787613784`"}], 
      RowBox[{"-", "0.39217436681903595`"}]},
     {
      RowBox[{"-", "0.002840853787613784`"}], 
      RowBox[{"-", "0.27181319656294356`"}], 
      RowBox[{"-", "0.002840853787614034`"}]},
     {
      RowBox[{"-", "0.39217436681903595`"}], 
      RowBox[{"-", "0.002840853787614034`"}], "0.6568910769054628`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.6908130655249195`*^9, 3.6908131184329195`*^9, 
  3.6908131633779197`*^9, 3.694195551996375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "PaLDA", ",", "PbLDA", ",", "EtotLDA", ",", "ExLDA", ",", "valsaLDA", 
      ",", "valsbLDA", ",", "vecsaLDA", ",", "vecsbLDA"}], "}"}], " ", "=", 
    RowBox[{"DoUSCF", "[", 
     RowBox[{"Hbasis", ",", 
      RowBox[{"{", "}"}], ",", "intH", ",", "2", ",", "1", ",", "nH", ",", 
      "makeFXLSDA", ",", "makeEXLSDA", ",", 
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", "50000", ",", "0.8", 
      ",", "True"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Unrestricted", " ", "DFT", " ", 
    RowBox[{"calculation", ".", " ", "LDA"}], " ", "exchange", " ", "and", 
    " ", "no", " ", "correlation"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6908131680059195`*^9, 3.6908132260269194`*^9}, {
  3.6908155916069193`*^9, 3.6908156079869194`*^9}, {3.6908157204699197`*^9, 
  3.6908157207279196`*^9}, {3.6908176470699196`*^9, 3.6908176474709196`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1.227905624049796`"}], 
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "0.1420542568408093`"}]},
     {
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "1.5060039342031493`"}], 
      RowBox[{"-", "0.8398020596282825`"}]},
     {
      RowBox[{"-", "0.1420542568408093`"}], 
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "1.227905624049796`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.6941955536811748`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50028\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.4290799859322043`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.000013732073433539765`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.6908132001139193`*^9, 3.6908132274959197`*^9}, 
   3.69081560893392*^9, 3.6908176487849197`*^9, 3.6941955544455748`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50028\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.4615414647993476`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.000018130877946710565`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.6908132001139193`*^9, 3.6908132274959197`*^9}, 
   3.69081560893392*^9, 3.6908176487849197`*^9, 3.6941955553035746`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50028\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.42907998593220426`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.000013732073433507522`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.6908132001139193`*^9, 3.6908132274959197`*^9}, 
   3.69081560893392*^9, 3.6908176487849197`*^9, 3.694195556192775*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: maxp\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.6908132001139193`*^9, 3.6908132274959197`*^9}, 
   3.69081560893392*^9, 3.6908176487849197`*^9, 3.694195556270775*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "2.5680682758919158`"}], ",", "0.216048510996658`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195558595175*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "2.6290807886700307`"}], ",", "0.0014882781185662527`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195562978775*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2.6259683949806893`"}], ",", "0.0000930669624327031`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195567565175*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"-", "2.626564878723704`"}], ",", "0.000011310186092347595`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195571777175*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"-", "2.6265923113969003`"}], ",", "1.7319050821673503`*^-6"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.6941955758175745`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"-", "2.626602756244851`"}], ",", "2.7004130399717146`*^-7"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.6941955798735747`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "2.626603827777072`"}], ",", "4.234644087744753`*^-8"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195583913975*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{"-", "2.626603849203298`"}], ",", "6.651963678857497`*^-9"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195587954375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", 
   RowBox[{"-", "2.626603761662421`"}], ",", "1.0453655365610343`*^-9"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195592010375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   RowBox[{"-", "2.626603708783742`"}], ",", "1.643051433921055`*^-10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.694195596081975*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", 
   RowBox[{"-", "2.626603684102088`"}], ",", "2.5825840010702113`*^-11"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6908176485099196`*^9, 3.6941956001223745`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"PaLDA", "-", "PbLDA"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "ULDA", " ", "spin", " ", "density", " ", "matrix", " ", "shows", " ", 
     "small", " ", "negative"}], "-", 
    RowBox[{
    "spin", " ", "population", " ", "on", " ", "central", " ", "H", " ", 
     RowBox[{"atom", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.69081434838892*^9, 3.6908143545119195`*^9}, {
  3.6908155325579195`*^9, 3.6908155744039197`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.5823802912838715`", 
      RowBox[{"-", "0.00143566985681845`"}], 
      RowBox[{"-", "0.4666851524406243`"}]},
     {
      RowBox[{"-", "0.00143566985681845`"}], 
      RowBox[{"-", "0.11843567854445744`"}], 
      RowBox[{"-", "0.0014356698568162019`"}]},
     {
      RowBox[{"-", "0.4666851524406243`"}], 
      RowBox[{"-", "0.0014356698568162019`"}], "0.582380291283875`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.6908143550509195`*^9, 3.6908177047719193`*^9, 
  3.694195620885975*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"auxbasis", "=", 
  RowBox[{"{", 
   RowBox[{"10.", ",", 
    RowBox[{"10.", "/", "8."}], ",", 
    RowBox[{"10.", "/", 
     RowBox[{"8.", "^", "2"}]}], ",", 
    RowBox[{"10.", "/", 
     RowBox[{"8.", "^", "3"}]}]}], "}"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Small", " ", "auxiliary", " ", "basis", " ", "set"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.6908178146359196`*^9, 3.69081782154692*^9}, {
  3.6908178631409197`*^9, 3.69081787541492*^9}, {3.6908182107089195`*^9, 
  3.6908182331889195`*^9}, {3.6912340960301037`*^9, 3.6912340991471043`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.`", ",", "1.25`", ",", "0.15625`", ",", "0.01953125`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6908182335829196`*^9, 3.6941956225083747`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "PaPiLDA", ",", "PbPiLDA", ",", "EtotPiLDA", ",", "ExPiLDA", ",", 
      "valsaPiLDA", ",", "valsbPiLDA", ",", "vecsaPiLDA", ",", "vecsbPiLDA"}],
      "}"}], " ", "=", 
    RowBox[{"DoUSCF", "[", 
     RowBox[{
     "Hbasis", ",", "auxbasis", ",", "intH", ",", "2", ",", "1", ",", "nH", 
      ",", "makeFXPiLDA", ",", "makeEXPiLDA", ",", 
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{"-", "8"}], ")"}]}], ",", "50", ",", "50000", ",", "0.8", ",",
       "True"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Unrestricted", " ", "DFT", " ", 
    RowBox[{"calculation", ".", " ", "PiLDA"}], " ", "exchange", " ", "and", 
    " ", "no", " ", 
    RowBox[{"correlation", ".", " ", "Implementation"}], " ", "with", " ", 
    "an", " ", "auxiliary", " ", "basis", " ", "set"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.6908182737159195`*^9, 3.6908182978829193`*^9}, 
   3.6908184504629197`*^9, {3.6908266472399197`*^9, 3.6908266490239196`*^9}, {
   3.6908271059729195`*^9, 3.6908271209319196`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1.227905624049796`"}], 
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "0.1420542568408093`"}]},
     {
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "1.5060039342031493`"}], 
      RowBox[{"-", "0.8398020596282825`"}]},
     {
      RowBox[{"-", "0.1420542568408093`"}], 
      RowBox[{"-", "0.8398020596282825`"}], 
      RowBox[{"-", "1.227905624049796`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.694195624161975*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50050\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.48224682512284345`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.0003997581178514116`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6941956317747746`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50050\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.3019746303742936`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.00015285617465207737`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.694195639652775*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(50050\\)\[NoBreak] integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(-0.06313208262085186`\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.00007328049973278253`\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", \
ButtonNote -> \\\"NIntegrate::maxp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6941956475775747`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: maxp\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.694195647593175*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "2.4801974678911134`"}], ",", "0.1576663884530613`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941957804739747`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "2.52797729205298`"}], ",", "0.002898972571646889`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941959375947747`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2.5323942767143146`"}], ",", "0.0003826960831065853`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.694196095482375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"-", "2.5329285976245073`"}], ",", "0.00007420428807423974`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.694196253572775*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"-", "2.533015157463443`"}], ",", "0.000014854084119025666`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941964136021185`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"-", "2.5330319531934364`"}], ",", "2.9944767104962697`*^-6"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941965747047806`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "2.533035865467909`"}], ",", "6.052866408355455`*^-7"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941967351237135`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{"-", "2.533036930717101`"}], ",", "1.224848438855477`*^-7"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.69419689573096*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", 
   RowBox[{"-", "2.5330372698751495`"}], ",", "2.479722677894898`*^-8"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.694197055452285*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   RowBox[{"-", "2.533037393587931`"}], ",", "5.021188348589085`*^-9"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6941972172707815`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"PaPiLDA", "-", "PbPiLDA"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "UPiLDA", " ", "spin", " ", "density", " ", "matrix", " ", "shows", " ", 
     "intermediate", " ", "negative"}], "-", 
    RowBox[{
    "spin", " ", "population", " ", "on", " ", "central", " ", "H", " ", 
     RowBox[{"atom", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.69419818661516*^9, 3.69419821410236*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6110812634943877`", 
      RowBox[{"-", "0.00012495671385223672`"}], 
      RowBox[{"-", "0.4379841802301101`"}]},
     {
      RowBox[{"-", "0.00012495671385223672`"}], 
      RowBox[{"-", "0.18096050050704496`"}], 
      RowBox[{"-", "0.0001249567138491281`"}]},
     {
      RowBox[{"-", "0.4379841802301101`"}], 
      RowBox[{"-", "0.0001249567138491281`"}], "0.611081263494388`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.69419818965716*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1904, 945},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.25 Inherited,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 1712, 28, 344, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2316, 54, 122, 1, 106, "Section"],
Cell[2441, 57, 1442, 43, 141, "Input"],
Cell[3886, 102, 455, 13, 56, "Input"],
Cell[4344, 117, 597, 18, 56, "Input"],
Cell[4944, 137, 5960, 157, 525, "Input"],
Cell[10907, 296, 1922, 47, 201, "Input"],
Cell[12832, 345, 2957, 70, 345, "Input"],
Cell[15792, 417, 3371, 81, 272, "Input"],
Cell[19166, 500, 3589, 90, 272, "Input"],
Cell[22758, 592, 5230, 125, 416, "Input"],
Cell[27991, 719, 8195, 185, 776, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[36223, 909, 111, 1, 68, "Section"],
Cell[36337, 912, 2296, 58, 381, "Input"],
Cell[38636, 972, 2672, 67, 452, "Input"],
Cell[41311, 1041, 5640, 133, 632, "Input"],
Cell[46954, 1176, 2221, 54, 416, "Input"],
Cell[CellGroupData[{
Cell[49200, 1234, 438, 13, 56, "Input"],
Cell[49641, 1249, 2209, 30, 70, "Output"]
}, Open  ]],
Cell[51865, 1282, 1860, 49, 308, "Input"],
Cell[53728, 1333, 2553, 63, 416, "Input"],
Cell[56284, 1398, 236, 5, 56, "Input"],
Cell[56523, 1405, 376, 10, 56, "Input"],
Cell[56902, 1417, 376, 10, 56, "Input"],
Cell[57281, 1429, 1205, 33, 201, "Input"],
Cell[58489, 1464, 1274, 36, 201, "Input"],
Cell[59766, 1502, 4098, 95, 525, "Input"],
Cell[63867, 1599, 709, 17, 165, "Input"],
Cell[64579, 1618, 7362, 177, 596, "Input"],
Cell[71944, 1797, 1261, 30, 237, "Input"],
Cell[73208, 1829, 1271, 31, 237, "Input"],
Cell[74482, 1862, 3634, 89, 488, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[78153, 1956, 102, 1, 68, "Section"],
Cell[78258, 1959, 3088, 74, 345, "Input"],
Cell[81349, 2035, 5158, 122, 596, "Input"],
Cell[86510, 2159, 822, 21, 88, "Input"],
Cell[87335, 2182, 805, 24, 93, "Input"],
Cell[88143, 2208, 975, 26, 93, "Input"],
Cell[89121, 2236, 1030, 26, 93, "Input"],
Cell[90154, 2264, 823, 23, 93, "Input"],
Cell[90980, 2289, 2746, 68, 416, "Input"],
Cell[93729, 2359, 5461, 133, 812, "Input"],
Cell[99193, 2494, 9077, 217, 1207, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[108307, 2716, 124, 1, 68, "Section"],
Cell[108434, 2719, 418, 12, 56, "Input"],
Cell[108855, 2733, 828, 22, 128, "Input"],
Cell[109686, 2757, 1559, 39, 165, "Input"],
Cell[111248, 2798, 2363, 58, 201, "Input"],
Cell[113614, 2858, 2211, 52, 272, "Input"],
Cell[115828, 2912, 1957, 48, 237, "Input"],
Cell[117788, 2962, 1921, 47, 237, "Input"],
Cell[119712, 3011, 1870, 46, 237, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[121619, 3062, 118, 1, 68, "Section"],
Cell[121740, 3065, 1528, 42, 272, "Input"],
Cell[123271, 3109, 989, 27, 201, "Input"],
Cell[124263, 3138, 2046, 53, 308, "Input"],
Cell[126312, 3193, 12419, 279, 1926, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[138768, 3477, 471, 7, 68, "Section"],
Cell[CellGroupData[{
Cell[139264, 3488, 1201, 31, 60, "Input"],
Cell[140468, 3521, 600, 18, 36, "Output"]
}, Open  ]],
Cell[141083, 3542, 305, 6, 36, "Input"],
Cell[141391, 3550, 5897, 157, 267, "Input"],
Cell[147291, 3709, 671, 16, 36, "Input"],
Cell[147965, 3727, 6027, 158, 267, "Input"],
Cell[153995, 3887, 775, 17, 38, "Input"],
Cell[154773, 3906, 380, 11, 38, "Input"],
Cell[155156, 3919, 620, 16, 38, "Input"],
Cell[155779, 3937, 620, 16, 38, "Input"],
Cell[156402, 3955, 618, 16, 38, "Input"],
Cell[157023, 3973, 620, 16, 38, "Input"],
Cell[157646, 3991, 615, 16, 38, "Input"],
Cell[158264, 4009, 615, 16, 38, "Input"],
Cell[158882, 4027, 612, 16, 38, "Input"],
Cell[159497, 4045, 618, 16, 38, "Input"],
Cell[160118, 4063, 618, 16, 38, "Input"],
Cell[160739, 4081, 620, 16, 38, "Input"],
Cell[161362, 4099, 614, 16, 38, "Input"],
Cell[161979, 4117, 1105, 29, 38, "Input"],
Cell[163087, 4148, 229, 5, 38, "Input"],
Cell[163319, 4155, 688, 17, 38, "Input"],
Cell[164010, 4174, 690, 17, 38, "Input"],
Cell[164703, 4193, 690, 17, 38, "Input"],
Cell[165396, 4212, 686, 17, 38, "Input"],
Cell[166085, 4231, 690, 17, 38, "Input"],
Cell[166778, 4250, 584, 15, 38, "Input"],
Cell[167365, 4267, 637, 16, 38, "Input"],
Cell[168005, 4285, 635, 16, 38, "Input"],
Cell[168643, 4303, 635, 16, 38, "Input"],
Cell[169281, 4321, 637, 16, 38, "Input"],
Cell[169921, 4339, 686, 17, 38, "Input"],
Cell[170610, 4358, 963, 27, 38, "Input"],
Cell[171576, 4387, 483, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[172084, 4400, 786, 22, 38, "Input"],
Cell[172873, 4424, 548, 17, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173458, 4446, 354, 8, 38, "Input"],
Cell[173815, 4456, 264, 7, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174116, 4468, 678, 20, 38, "Input"],
Cell[174797, 4490, 635, 19, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175469, 4514, 305, 8, 38, "Input"],
Cell[175777, 4524, 340, 9, 41, "Output"]
}, Open  ]],
Cell[176132, 4536, 184, 4, 38, "Input"],
Cell[176319, 4542, 804, 23, 38, "Input"],
Cell[177126, 4567, 1517, 45, 65, "Input"],
Cell[178646, 4614, 2469, 74, 140, "Input"],
Cell[CellGroupData[{
Cell[181140, 4692, 3780, 99, 115, "Input"],
Cell[184923, 4793, 27525, 727, 312, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[212497, 5526, 213, 4, 68, "Section"],
Cell[212713, 5532, 1344, 37, 36, "Input"],
Cell[214060, 5571, 229, 5, 36, "Input"],
Cell[214292, 5578, 1182, 26, 60, "Input"],
Cell[CellGroupData[{
Cell[215499, 5608, 337, 8, 36, "Input"],
Cell[215839, 5618, 782, 11, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216658, 5634, 513, 13, 36, "Input"],
Cell[217174, 5649, 1060, 27, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218271, 5681, 1006, 22, 60, "Input"],
Cell[219280, 5705, 1042, 28, 60, "Print"],
Cell[220325, 5735, 744, 13, 29, "Message"],
Cell[221072, 5750, 744, 13, 29, "Message"],
Cell[221819, 5765, 743, 13, 29, "Message"],
Cell[222565, 5780, 632, 12, 29, "Message"],
Cell[CellGroupData[{
Cell[223222, 5796, 205, 5, 27, "Print"],
Cell[223430, 5803, 209, 5, 27, "Print"],
Cell[223642, 5810, 209, 5, 27, "Print"],
Cell[223854, 5817, 210, 5, 27, "Print"],
Cell[224067, 5824, 212, 5, 30, "Print"],
Cell[224282, 5831, 211, 5, 30, "Print"],
Cell[224496, 5838, 208, 5, 30, "Print"],
Cell[224707, 5845, 208, 5, 30, "Print"],
Cell[224918, 5852, 209, 5, 30, "Print"],
Cell[225130, 5859, 210, 5, 30, "Print"],
Cell[225343, 5866, 213, 5, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[225605, 5877, 528, 13, 36, "Input"],
Cell[226136, 5892, 1034, 27, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[227207, 5924, 587, 14, 36, "Input"],
Cell[227797, 5940, 188, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228022, 5949, 1118, 26, 83, "Input"],
Cell[229143, 5977, 1016, 28, 60, "Print"],
Cell[230162, 6007, 644, 12, 29, "Message"],
Cell[230809, 6021, 642, 12, 29, "Message"],
Cell[231454, 6035, 645, 12, 29, "Message"],
Cell[232102, 6049, 533, 11, 29, "Message"],
Cell[CellGroupData[{
Cell[232660, 6064, 184, 5, 27, "Print"],
Cell[232847, 6071, 184, 5, 27, "Print"],
Cell[233034, 6078, 185, 5, 27, "Print"],
Cell[233222, 6085, 186, 5, 27, "Print"],
Cell[233411, 6092, 188, 5, 27, "Print"],
Cell[233602, 6099, 188, 5, 30, "Print"],
Cell[233793, 6106, 186, 5, 30, "Print"],
Cell[233982, 6113, 183, 5, 30, "Print"],
Cell[234168, 6120, 185, 5, 30, "Print"],
Cell[234356, 6127, 187, 5, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[234592, 6138, 485, 12, 36, "Input"],
Cell[235080, 6152, 988, 26, 90, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
