# README for YaSoFo - Yet Another SOlar Fuels Optimizer #

* YaSoFo implements some basic Python routines to calculate maximum theoretical efficiencies of single- and monolithic multi-junction
solar cells for solar fuel generation. The starting point is a solar spectrum (typically AM1.5G), which can be manipulated by the
application of a filter or an absorbing layer. The simple model employed here is described in the publication mentioned below.
* Version: Yasofo 1.0 (19. Jan. 2017)
* Project hosted at [https://bitbucket.org/YaSoFo/yasofo](https://bitbucket.org/YaSoFo/yasofo)
* Please cite May et al., Sustainable Energy & Fuels (2017). DOI:10.1039/C6SE00083E .

## Dependencies ##

* Python 3 with SciPy, for installation instructions see [SciPy](http://scipy.org/install.html)
* Solar Spectra (see below)

## How to run tests? ##


We assume that yasofo.py and am15g.dat are in the same directory and you have installed SciPy 3.x. Open a Python terminal, e.g. Ipython, in the directory where yasofo.py is located. Now type the following in your terminal:

    import yasofo as yo
    yo.demo_single_junction()

for a demo for a single junction with coarse parameters.Type

    yo.demo_double_junction()

for a demo for a double junction with coarse parameters. The line

    yo.demo_triple_junction()

will give you a demo for a triple junction with coarse parameters, and finally

    yo.demo_quadruple_junction()

will calculate a quadruple junction with coarse parameters. The latter can take a long time. After some time - depending on the order of the multi-junction - a graph with the max. STF efficiency over \Delta G should appear.

### Where to obtain solar spectra? ###

The standard file format used here is equivalent to the format distributed with etaOpt by Fraunhofer ISE.
It can be downloaded from [their website](https://www.ise.fraunhofer.de/en/business-areas/photovoltaics/research-topics/iii-v-and-concentrator-photovoltaics/fields-of-work/iii-v-epitaxy-and-solar-cells/rd-services/theoretical-modelling-1/etaopt). See also Letay and Bett, Eur. Photovoltaic Sol. Energy Conf., Proc. Int. Conf., 17th, 2001, 178–181.

In the etaOpt archive file, you will find a folder 'spectra', containing AM0, AM1.5D, and AM1.5G spectra.

Another source for spectra is e.g. [NREL](http://rredc.nrel.gov/solar/spectra/am1.5).

The AM1.5G spectrum supplied with YaSoFo originates from etaOpt and is redistributed with friendly permission from the authors.

### Water absorption ###

A nice overview of the optical properties of water with data and references can be found at the [Oregon
Medical Laser Center](http://omlc.org/spectra/water).

### Some quick examples ###

a) Let us assume you want to find the best double junction bandgap parameters for water splitting (E0=1.23eV).
Your absorbers are not the very best, so your open-circuit photovoltage is 500 mV lower than the bandgap/e,
but you have very good catalysts, i.e. IrO2. Your solar spectrum is the unmodified AM 1.5G spectrum.

What would be the very best bandgap combination and what efficiency could you get out of it?

Start a python console, e.g. Ipython in the directory where you have yasofo.py and you solar spectrum.

    import yasofo as yo
    yo.find_max_double(E0=1.23, voltage_loss=0.5, only_print_results=True)

You should see a text stating max. efficiency and bandgap combination.

b) If you want to see the various bandgap combinations with their resulting performance:

    yo.best_gaps_double(E0=1.23, voltage_loss=0.5)

You should now see a 2d plot with the STF efficienciy as a function of the bandgaps.

c) You want to modify you AM1.5G spectrum by the absorbance of a catalyst or electrolyte. Let us assume
you have a file 'absorbance.dat' with your wavelength (nm) in the first column and you absorbance (1/cm)
in the second column, has 5 lines of header and your absorbing layer is 5 mm thick.

    am15g_mod=yo.mod_spectrum_by_abs('absorbance.dat', thickness=0.5, header=5)

You can plot the spectrum to see if things are fine

    yo.plot_spectrum(am15g_mod)

Let us now see how a tandem performs with the modified spectrum:

    yo.best_gaps_double(data=am15g_mod, E0=1.23, voltage_loss=0.5)

## Contact ##

* Matthias May, University of Cambridge, Dept. of Chemistry. Email: mm2159 ]at[ cam.ac.uk

## License ##

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License
[CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0)
