(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    572141,      12448]
NotebookOptionsPosition[    542385,      11777]
NotebookOutlinePosition[    542819,      11794]
CellTagsIndexPosition[    542776,      11791]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{
  "Higher", " ", "order", " ", "perturbation", " ", "theory", " ", "for", " ",
    "the", " ", "buckling", " ", "of", " ", "a", " ", "growing", "  ", 
   "neoHookean", " ", "layer", " ", "sandwiched", " ", "between", " ", 
   "neoHookean", " ", "substrate", " ", "and", " ", "superstrate"}], 
  "Title"]], "Input",
 CellChangeTimes->{{3.748157106127223*^9, 3.7481572393084497`*^9}, {
  3.748157280213007*^9, 3.748157298711442*^9}, {3.748157349817041*^9, 
  3.7481573833723717`*^9}, {3.7481574974242907`*^9, 3.748157498273388*^9}, {
  3.748364692459585*^9, 3.748364699433175*^9}, {3.749020385740182*^9, 
  3.7490204064593487`*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["\[LineSeparator]Notebook by Nontawit Cheewaruangroj \
and John S Biggins", "Author"]], "Text",
 CellChangeTimes->{3.748364707364526*^9},
 TextAlignment->Center],

Cell[TextData[StyleBox["How to use this notebook ", "Section"]], "Text",
 CellChangeTimes->{{3.7481578035150757`*^9, 3.748157808410305*^9}}],

Cell["\<\
This notebook is intended to be read/used in conjunction with the paper \
\[OpenCurlyDoubleQuote]Pattern selection when a layer buckles on a soft \
substrate.\[CloseCurlyDoubleQuote] This notebook also uses helper functions \
written by the authors, which are contained in the accompanying Mathematica \
notebook Pert_helper _functions.nb, which must be in the same folder as this \
notebook. \
\>", "Text",
 CellChangeTimes->{{3.748157822772893*^9, 3.7481579853128366`*^9}, {
  3.748158317923436*^9, 3.748158318538887*^9}}],

Cell["\<\
If you run the \"input\" cells of this notebook in order (from top to bottom) \
the notebook will verify the first, second and third order perturbation \
fields for stripe, square and hexagonal patterns, and compute the \
accompanying energy coefficients. You can either do this whilst reading \
through, running each input cell manually, or run the entire notebook in one \
command by selecting Evaluation/Evaluate-notebook. Fair warning: running the \
entire notebook may take around an hour.\
\>", "Text",
 CellChangeTimes->{{3.748157822772893*^9, 3.748157944657064*^9}, {
  3.7481579932965107`*^9, 3.748158065558572*^9}, {3.748196265301153*^9, 
  3.7481962945792093`*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.7481583089030447`*^9, 3.748158308907529*^9}}],

Cell["", "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Helper functions", "Section"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748157764841991*^9, 3.7481577803021307`*^9}, 
   3.7487821236144075`*^9}],

Cell["\<\
This notebook uses the standard \[OpenCurlyDoubleQuote]Variational methods\
\[CloseCurlyDoubleQuote] package, to calculate the equilibrium equations \
directly from the energy via calculus of variations.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158093464594*^9, 3.7481581320612297`*^9}, 
   3.748782123615381*^9}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748157589976445*^9, 3.748157632245802*^9}, {
   3.748158159112691*^9, 3.748158159791313*^9}, 3.748782123615381*^9}],

Cell["\<\
This notebook also uses helper functions written by the authors, which are \
contained in the accompanying Mathematica notebook pert_helper_functions.nb, \
which must be in the same folder as this notebook. \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158147401422*^9, 3.748158155335235*^9}, {
   3.748158225718522*^9, 3.748158274427133*^9}, {3.748158353542948*^9, 
   3.748158353703319*^9}, 3.748195912982089*^9, {3.7481959460371103`*^9, 
   3.748195946317108*^9}, 3.748782123615381*^9}],

Cell[BoxData[
 RowBox[{"NotebookEvaluate", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], ",", 
     "\"\<pert_helper_functions.nb\>\""}], "}"}], "]"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158213150754*^9, 3.748158219797617*^9}, {
   3.7481941325489397`*^9, 3.748194136035887*^9}, 3.748195107133922*^9, {
   3.748195421557001*^9, 3.7481954825069237`*^9}, 3.748195517246182*^9, {
   3.74819562767171*^9, 3.748195632607148*^9}, {3.7481957842483664`*^9, 
   3.74819582426667*^9}, 3.748782123615381*^9}],

Cell["\<\
These helper functions include two new simplify commands, TrigSimplify and \
ExpSimplify, which are quicker than the regular Mathematica Simplify command \
at dealing with expressions that are sums of fourier components, or sums of \
exponential terms. They work by splitting the expression into \
fourier/exponential components, simplifying each component separately, then \
adding the, back together again.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158294534396*^9, 3.748158329875403*^9}, {
   3.748158385934456*^9, 3.748158530969438*^9}, 3.748263803954225*^9, 
   3.748782123616377*^9}],

Cell["\<\
Finally, we load a second Mathematica notebook, which contains the full \
algebraic forms of the higher order fields, which we validate in this \
notebook.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.74819596044608*^9, 3.748196016626272*^9}, 
   3.748782123616377*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NotebookEvaluate", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", 
       "\"\<sandwich_pert_solutions.nb\>\""}], "}"}], "]"}], "]"}], ";"}], 
  " "}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158213150754*^9, 3.748158219797617*^9}, {
   3.7481941325489397`*^9, 3.748194136035887*^9}, 3.748195107133922*^9, {
   3.748195421557001*^9, 3.7481954825069237`*^9}, 3.748195517246182*^9, {
   3.74819562767171*^9, 3.748195632607148*^9}, {3.7481957842483664`*^9, 
   3.74819582426667*^9}, {3.748195982630145*^9, 3.748195984068635*^9}, {
   3.7481968983523693`*^9, 3.748196910168001*^9}, 3.748782123616377*^9, {
   3.7490631959059935`*^9, 3.749063208250902*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Defining the elastic energy ", "Section"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481585477387753`*^9, 3.7481585735823603`*^9}, {
   3.748158867345829*^9, 3.7481588758818827`*^9}, {3.748263214336389*^9, 
   3.748263215129652*^9}, {3.7482636671820307`*^9, 3.748263668106621*^9}, 
   3.7487821424858932`*^9}],

Cell["\<\
We start by defining the displacement in the layer  u[x,y,z] as a vector \
displacement field in the layer, with x-y-z components ux, uy and,uz.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748263262110486*^9, 3.748263275531332*^9}, 
   3.7487821424858932`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7481585932803793`*^9, 3.748158691560307*^9, {3.7481955716264753`*^9, 
   3.748195575602419*^9}, 3.7487821424858932`*^9, {3.7490632585101223`*^9, 
   3.749063259423026*^9}}],

Cell["\<\
Unlike in the paper, in Mathematica it is not convenient to define piecewise \
functions to describe the different behavior of the layer and substrate, so \
we instead use different variables in the layer and substrate, using the \
convention that substrate variables are distinguished by an S appended to the \
variable name. For example, we first define uS[x,y,z] is the a vector \
displacement field in the substrate, with x-y-z components uxS, uyS and,uzS. \
To avoid too much repetition we define a substitution rule that replaces the \
common layer fields in an expression with their substrate counterparts. \
Similarly for the superstrate, we use uS2[x,y,z].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748263292506982*^9, 3.748263338374407*^9}, {
   3.7482633913666887`*^9, 3.748263395085491*^9}, {3.7482634613960323`*^9, 
   3.748263486651383*^9}, 3.7487821424858932`*^9, {3.749799130512555*^9, 
   3.74979915897124*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubstrateFields", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"uz", "\[Rule]", "uzS"}], ",", 
     RowBox[{"uy", "\[Rule]", "uyS"}], ",", 
     RowBox[{"ux", "\[Rule]", "uxS"}], ",", 
     RowBox[{"P", "\[Rule]", "PS"}], ",", 
     RowBox[{"\[Mu]1", "\[Rule]", "\[Mu]2"}], ",", 
     RowBox[{"g", "\[Rule]", "1"}], ",", 
     RowBox[{"fx", "\[Rule]", "fxS"}], ",", 
     RowBox[{"fz", "\[Rule]", "fzS"}], ",", 
     RowBox[{"fp", "\[Rule]", "fpS"}]}], "}"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482633825687637`*^9, 3.748263385225129*^9}, {
   3.748263452555109*^9, 3.7482634528935003`*^9}, 3.748263812463072*^9, 
   3.7487821424858932`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperstrateFields", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"uz", "\[Rule]", "uzS2"}], ",", 
     RowBox[{"uy", "\[Rule]", "uyS2"}], ",", 
     RowBox[{"ux", "\[Rule]", "uxS2"}], ",", 
     RowBox[{"P", "\[Rule]", "PS2"}], ",", 
     RowBox[{"\[Mu]1", "\[Rule]", "\[Mu]2"}], ",", 
     RowBox[{"g", "\[Rule]", "1"}], ",", 
     RowBox[{"fx", "\[Rule]", "fxS2"}], ",", 
     RowBox[{"fz", "\[Rule]", "fzS2"}], ",", 
     RowBox[{"fp", "\[Rule]", "fpS2"}]}], "}"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482633825687637`*^9, 3.748263385225129*^9}, {
   3.748263452555109*^9, 3.7482634528935003`*^9}, 3.748263812463072*^9, 
   3.7487821424858932`*^9, {3.749020416827567*^9, 3.7490204325730047`*^9}}],

Cell["\<\
The displacement in the substrate and superstrate are thus defined as \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748159360806814*^9, 3.7481593690050898`*^9}, 
   3.7487821424858932`*^9, {3.749020643605217*^9, 3.7490206499366455`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"uS", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
   "SubstrateFields"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7481585932803793`*^9, 3.748158691560307*^9, {3.748159375366708*^9, 
   3.748159381068968*^9}, {3.7481943922204533`*^9, 3.748194396540489*^9}, {
   3.74826349633512*^9, 3.748263501972477*^9}, 3.7487821424858932`*^9}],

Cell[BoxData[
 RowBox[{"uS", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7481585932803793`*^9, 3.748158691560307*^9, {3.748159375366708*^9, 
   3.748159381068968*^9}, {3.7481943922204533`*^9, 3.748194396540489*^9}, {
   3.74826349633512*^9, 3.748263545272531*^9}, 3.7487821424858932`*^9, {
   3.7490632653076553`*^9, 3.7490632662305703`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"uxS", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"uyS", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"uzS", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748263545688115*^9, 3.748263815713512*^9, 3.748264215273073*^9, 
   3.74826464617157*^9, 3.748264996489705*^9, 3.7482651158157597`*^9, 
   3.748265231615069*^9, 3.748265441693152*^9, 3.7482656176804037`*^9, 
   3.748266727219419*^9, 3.748267446003017*^9, 3.748358477639948*^9, 
   3.748362089463801*^9, 3.748363714317644*^9, 3.748364432624249*^9, 
   3.748364730217554*^9, 3.7483648325553493`*^9, 3.7483649683656607`*^9, 
   3.7483654390385427`*^9, 3.7483656457419662`*^9, 3.7483658652691298`*^9, 
   3.7483678957754803`*^9, 3.748368477006544*^9, 3.748368837736546*^9, 
   3.7483693813441973`*^9, 3.748370070179399*^9, 3.748371270376502*^9, 
   3.74837140350008*^9, 3.7487617748069644`*^9, {3.748782142486891*^9, 
   3.7487821443170533`*^9}, 3.748784703203154*^9, 3.748788156063622*^9, 
   3.7487887340276933`*^9, 3.748790781897951*^9, 3.748876096673195*^9, 
   3.74887640958061*^9, 3.7488791280751395`*^9, 3.7488939511566176`*^9, 
   3.748895871540728*^9, 3.748944405507182*^9, 3.748945639036533*^9, 
   3.7489475137871847`*^9, 3.748957548281746*^9, 3.7489642557115855`*^9, 
   3.7490632670792317`*^9, 3.7490645716527553`*^9, 3.7491109847462645`*^9, 
   3.749112847486537*^9, 3.7491259751256847`*^9, 3.749128466360114*^9, 
   3.7491374779031467`*^9, 3.749151176557308*^9, 3.7491984191949244`*^9, 
   3.749225138631689*^9, 3.7492444270646825`*^9, 3.7492793795149345`*^9, 
   3.7493085562825794`*^9, 3.749802139852172*^9, 3.749802262241006*^9, 
   3.749806753962777*^9, 3.749998617116907*^9, 3.7500000305634966`*^9, 
   3.7500616852420855`*^9, 3.7537340528469934`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"uS2", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
   "SuperstrateFields"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7481585932803793`*^9, 3.748158691560307*^9, {3.748159375366708*^9, 
   3.748159381068968*^9}, {3.7481943922204533`*^9, 3.748194396540489*^9}, {
   3.74826349633512*^9, 3.748263501972477*^9}, 3.7487821424858932`*^9, {
   3.749020665036127*^9, 3.749020669656587*^9}}],

Cell[BoxData[
 RowBox[{"uS2", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7481585932803793`*^9, 3.748158691560307*^9, {3.748159375366708*^9, 
   3.748159381068968*^9}, {3.7481943922204533`*^9, 3.748194396540489*^9}, {
   3.74826349633512*^9, 3.748263545272531*^9}, 3.7487821424858932`*^9, 
   3.7490206731863246`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"uxS2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"uyS2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"uzS2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748263545688115*^9, 3.748263815713512*^9, 3.748264215273073*^9, 
   3.74826464617157*^9, 3.748264996489705*^9, 3.7482651158157597`*^9, 
   3.748265231615069*^9, 3.748265441693152*^9, 3.7482656176804037`*^9, 
   3.748266727219419*^9, 3.748267446003017*^9, 3.748358477639948*^9, 
   3.748362089463801*^9, 3.748363714317644*^9, 3.748364432624249*^9, 
   3.748364730217554*^9, 3.7483648325553493`*^9, 3.7483649683656607`*^9, 
   3.7483654390385427`*^9, 3.7483656457419662`*^9, 3.7483658652691298`*^9, 
   3.7483678957754803`*^9, 3.748368477006544*^9, 3.748368837736546*^9, 
   3.7483693813441973`*^9, 3.748370070179399*^9, 3.748371270376502*^9, 
   3.74837140350008*^9, 3.7487617748069644`*^9, {3.748782142486891*^9, 
   3.7487821443170533`*^9}, 3.748784703203154*^9, 3.748788156063622*^9, 
   3.7487887340276933`*^9, 3.748790781897951*^9, 3.748876096673195*^9, 
   3.74887640958061*^9, 3.7488791280751395`*^9, 3.7488939511566176`*^9, 
   3.748895871540728*^9, 3.748944405507182*^9, 3.748945639036533*^9, 
   3.7489475137871847`*^9, 3.748957548281746*^9, 3.7489642557115855`*^9, 
   3.74906326842489*^9, 3.7490645717096596`*^9, 3.7491109847722282`*^9, 
   3.74911284753637*^9, 3.749125975156927*^9, 3.7491284663929677`*^9, 
   3.74913747801962*^9, 3.7491511765911913`*^9, 3.749198419224017*^9, 
   3.7492251386606436`*^9, 3.749244427095924*^9, 3.749279379564769*^9, 
   3.7493085563180766`*^9, 3.749802139883442*^9, 3.7498022622566595`*^9, 
   3.749806753978406*^9, 3.749998617148132*^9, 3.750000030597348*^9, 
   3.7500616852733283`*^9, 3.7537340528728876`*^9}],

Cell["As in the paper,  the deformation gradient is defined as:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481587064971523`*^9, 3.748158716990864*^9}, 
   3.748782142486891*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", " ", "=", " ", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "+", " ", 
    RowBox[{"Grad", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]}], ";"}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158727332*^9, 3.748158743908091*^9}, 
   3.748782142486891*^9}],

Cell["\<\
If we display F in matrix form, it has the expected components:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158795434462*^9, 3.748158807880468*^9}, 
   3.748782142486891*^9}],

Cell[BoxData[
 RowBox[{"F", "//", "MatrixForm"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158758467133*^9, 3.7481587610096483`*^9}, 
   3.748782142486891*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["ux", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox["ux", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
      RowBox[{
       SuperscriptBox["ux", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}]},
     {
      RowBox[{
       SuperscriptBox["uy", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["uy", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox["uy", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}]},
     {
      RowBox[{
       SuperscriptBox["uz", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
      RowBox[{
       SuperscriptBox["uz", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["uz", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748158761558833*^9, 3.748159434430613*^9, 3.7482642154665117`*^9, 
   3.748264646350333*^9, 3.74826499735951*^9, 3.7482651160286913`*^9, 
   3.748265231811203*^9, 3.7482654419099483`*^9, 3.748265617905122*^9, 
   3.7482667274369717`*^9, 3.748267446239506*^9, 3.748358477788678*^9, 
   3.748362089545095*^9, 3.748363714396614*^9, 3.748364432709051*^9, 
   3.748364730299684*^9, 3.748364832663312*^9, 3.748364968440797*^9, 
   3.7483654391315203`*^9, 3.748365645809317*^9, 3.748365865369316*^9, 
   3.748367895873979*^9, 3.748368477089388*^9, 3.748368837838067*^9, 
   3.748369381432191*^9, 3.7483700702626743`*^9, 3.7483712704753857`*^9, 
   3.748371403717348*^9, 3.7487617790117145`*^9, {3.748782142486891*^9, 
   3.7487821443688555`*^9}, 3.748784703234404*^9, 3.748788156105542*^9, 
   3.7487887340725718`*^9, 3.7487907819597845`*^9, 3.748876096707106*^9, 
   3.748876409627485*^9, 3.7488791281439524`*^9, 3.748893951221187*^9, 
   3.7488958715719724`*^9, 3.7489444055540447`*^9, 3.748945639067809*^9, 
   3.748947513820125*^9, 3.7489575483216333`*^9, 3.7489642557425356`*^9, 
   3.7490633049447527`*^9, 3.7490645717694983`*^9, 3.749110984835028*^9, 
   3.7491128475822797`*^9, 3.7491259751881695`*^9, 3.749128466426876*^9, 
   3.7491374781800766`*^9, 3.749151176637654*^9, 3.749198419271288*^9, 
   3.749225138697542*^9, 3.749244427142764*^9, 3.74927937962062*^9, 
   3.749308556349867*^9, 3.749802139914689*^9, 3.749802262287876*^9, 
   3.7498067540252647`*^9, 3.7499986171895247`*^9, 3.750000030629285*^9, 
   3.7500616853202257`*^9, 3.7537340529247494`*^9}],

Cell["Similarly, we define the growth tensor as ", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481587064971523`*^9, 3.748158716990864*^9}, {
   3.748158827729438*^9, 3.748158836423505*^9}, 3.748782142486891*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"g", ",", "g", ",", 
      FractionBox["1", 
       SuperscriptBox["g", "2"]]}], "}"}], "]"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158727332*^9, 3.748158743908091*^9}, 
   3.748158841571538*^9, 3.748782142486891*^9}],

Cell["\<\
If we display G in matrix form, it has the expected components:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158795434462*^9, 3.748158807880468*^9}, {
   3.7481588442311907`*^9, 3.7481588477269373`*^9}, 3.748782142486891*^9}],

Cell[BoxData[
 RowBox[{"G", "//", "MatrixForm"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158758467133*^9, 3.7481587610096483`*^9}, {
   3.748158849110083*^9, 3.748158849543005*^9}, 3.748782142486891*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"g", "0", "0"},
     {"0", "g", "0"},
     {"0", "0", 
      FractionBox["1", 
       SuperscriptBox["g", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748158761558833*^9, 3.748158852755788*^9, 3.748159437433158*^9, 
   3.748263824018909*^9, 3.748264215805725*^9, 3.748264646513412*^9, 
   3.748264997562785*^9, 3.7482651162466516`*^9, 3.748265231995348*^9, 
   3.748265442124243*^9, 3.7482656181215343`*^9, 3.74826672765707*^9, 
   3.7482674464391623`*^9, 3.7483584779402227`*^9, 3.748362089629294*^9, 
   3.748363714473106*^9, 3.7483644327922163`*^9, 3.748364730382368*^9, 
   3.748364832764303*^9, 3.748364968531913*^9, 3.748365439214426*^9, 
   3.7483656464239273`*^9, 3.748365865540492*^9, 3.748367895974348*^9, 
   3.748368477172717*^9, 3.7483688379394493`*^9, 3.7483693815321903`*^9, 
   3.7483700703531322`*^9, 3.7483712705783167`*^9, 3.748371403834971*^9, 
   3.7487617842706437`*^9, {3.748782142486891*^9, 3.7487821443997726`*^9}, 
   3.748784703265626*^9, 3.7487881561583967`*^9, 3.748788734113464*^9, 
   3.7487907819956865`*^9, 3.7488760967369967`*^9, 3.7488764096603956`*^9, 
   3.7488791281928225`*^9, 3.748893951254071*^9, 3.7488958716032357`*^9, 
   3.748944405569671*^9, 3.7489456390990505`*^9, 3.7489475138560257`*^9, 
   3.74895754835751*^9, 3.748964255780403*^9, 3.7490633081763344`*^9, 
   3.7490645718173723`*^9, 3.7491109848648787`*^9, 3.7491128476231403`*^9, 
   3.7491259752037916`*^9, 3.7491284664578047`*^9, 3.749137478413022*^9, 
   3.7491511766705875`*^9, 3.7491984193032007`*^9, 3.7492251387304573`*^9, 
   3.7492444271740417`*^9, 3.7492793796704855`*^9, 3.749308556365489*^9, 
   3.7498021399459267`*^9, 3.749802262319146*^9, 3.7498067540408945`*^9, 
   3.7499986172207394`*^9, 3.750000030663171*^9, 3.750061685351468*^9, 
   3.7537340529636736`*^9}],

Cell["\<\
Finally,  we can calculate the energy density, including the Lagrange \
multiplier term for incompressibility P[x,y,z]. For the layer we have:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158795434462*^9, 3.748158807880468*^9}, {
   3.7481588442311907`*^9, 3.7481588477269373`*^9}, {3.748158892826709*^9, 
   3.748158940097808*^9}, {3.748159028555542*^9, 3.748159032993976*^9}, 
   3.748782142487891*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"W", "=", " ", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[Mu]1", " ", 
     RowBox[{"Tr", "[", 
      RowBox[{
       RowBox[{"F", ".", " ", 
        RowBox[{"Inverse", "[", "G", "]"}], ".", " ", 
        RowBox[{"Inverse", "[", 
         RowBox[{"Transpose", "[", "G", "]"}], "]"}], ".", " ", 
        RowBox[{"Transpose", "[", "F", "]"}]}], "-", "3"}], "]"}]}], "-", " ", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Det", "[", "F", "]"}], "-", "1"}], ")"}]}]}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481589205795193`*^9, 3.7481589283160753`*^9}, 
   3.7481590457953243`*^9, 3.748159420606257*^9, {3.7482635945743217`*^9, 
   3.748263595485778*^9}, 3.748782142487891*^9}],

Cell["and for the substrate and supetstrate we have ", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748159036794915*^9, 3.748159042857609*^9}, 
   3.748782142487891*^9, {3.7497992443993917`*^9, 3.7497992482891045`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WS", "=", " ", 
   RowBox[{"W", "/.", "SubstrateFields"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.74815906494503*^9, 3.748159079513112*^9}, {
   3.748159411277789*^9, 3.748159442849318*^9}, {3.748263605647221*^9, 
   3.7482636093279133`*^9}, 3.748263834339552*^9, 3.748782142487891*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WS2", "=", " ", 
   RowBox[{"W", "/.", "SuperstrateFields"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.74815906494503*^9, 3.748159079513112*^9}, {
   3.748159411277789*^9, 3.748159442849318*^9}, {3.748263605647221*^9, 
   3.7482636093279133`*^9}, 3.748263834339552*^9, 3.748782142487891*^9, {
   3.749020743906289*^9, 3.7490207463841753`*^9}}],

Cell[TextData[{
 "The total elastic energy, which we need to minimize is then ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"E", "=", 
    RowBox[{"<", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{
         RowBox[{"-", "a"}], "/", "2"}], 
        RowBox[{"a", "/", "2"}]], 
       RowBox[{"W", " ", 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], 
        RowBox[{
         RowBox[{"-", "a"}], "/", "2"}]], 
       RowBox[{"WS", 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"a", "/", "2"}], "\[Infinity]"], 
       RowBox[{"WS2", 
        RowBox[{"\[DifferentialD]", "z"}]}]}]}], ">"}]}]}]], "Input",
  CellChangeTimes->{{3.7481596044512787`*^9, 3.748159618171105*^9}}]
}], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481594993347054`*^9, 3.748159509811297*^9}, {
   3.748159542637512*^9, 3.748159543269404*^9}, {3.748159625204307*^9, 
   3.748159635693334*^9}, 3.748782142487891*^9, {3.7491219554625664`*^9, 
   3.7491219852379265`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.748158727332*^9, 3.748158743908091*^9}, 
   3.748158841571538*^9, {3.748159931466012*^9, 3.74816004871554*^9}, {
   3.748160228196992*^9, 3.7481602298423862`*^9}, {3.748263051930909*^9, 
   3.7482630826898746`*^9}, 3.748263252957427*^9}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Equations of equilibrium", "Section"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748159461353683*^9, 3.74815946512779*^9}, 
   3.748782150345865*^9}],

Cell["\<\
We use the built in Mathematica function \
\[OpenCurlyDoubleQuote]EulerEquations\[CloseCurlyDoubleQuote] to minimize E \
with respect to variations in displacement and pressure, resulting in a set \
of Euler-Lagrange equations. The command /.(a_==b_)\[Rule](a-b) turns the \
resulting equations from the form A==B to expressions A-B, which are solved \
when they simplify to zero.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7481594707573547`*^9, 3.748159492909875*^9}, {
   3.7481596477118273`*^9, 3.7481597019004793`*^9}, {3.7481597925987*^9, 
   3.7481598386164017`*^9}, 3.7487821503468614`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EL", " ", "=", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"EulerEquations", "[", 
      RowBox[{"W", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ux", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uy", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uz", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"P", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "==", "b_"}], ")"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ELS", "=", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"EulerEquations", "[", 
      RowBox[{"WS", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"uxS", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uyS", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uzS", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"PS", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "==", "b_"}], ")"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ELS2", "=", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"EulerEquations", "[", 
      RowBox[{"WS2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"uxS2", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uyS2", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"uzS2", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"PS2", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "==", "b_"}], ")"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}]}]}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748159737349607*^9, 3.748159777026465*^9}, {
   3.7481598632020063`*^9, 3.7481598810558777`*^9}, 3.7487821503468614`*^9, {
   3.7490209564892116`*^9, 3.7490209645336065`*^9}}],

Cell["\<\
We join these two list together into a single large list of all eight  bulk \
equations\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748267170216387*^9, 3.748267196294633*^9}, 
   3.7487821503468614`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquations", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"EL", ",", "ELS", ",", "ELS2"}], "]"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748159737349607*^9, 3.748159777026465*^9}, {
   3.7481598632020063`*^9, 3.7481598810558777`*^9}, {3.748267210423747*^9, 
   3.748267232269842*^9}, 3.7487821503468614`*^9, {3.7490210156115036`*^9, 
   3.7490210190101233`*^9}}],

Cell["From the main text, we introduce the PK1 stress:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748159912245761*^9, 3.748159921094906*^9}, 
   3.748782150345865*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", " ", 
   RowBox[{
    RowBox[{"\[Mu]1", " ", 
     RowBox[{"F", ".", 
      RowBox[{"Inverse", "[", "G", "]"}], ".", 
      RowBox[{"Inverse", "[", 
       RowBox[{"Transpose", "[", "G", "]"}], "]"}]}]}], "-", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
     RowBox[{"Det", "[", "F", "]"}], 
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "F", "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]S", " ", "=", " ", 
   RowBox[{"\[Sigma]", "/.", "SubstrateFields"}]}], ";", 
  RowBox[{"\[Sigma]S2", " ", "=", " ", 
   RowBox[{"\[Sigma]", "/.", "SuperstrateFields"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748158727332*^9, 3.748158743908091*^9}, 
   3.748158841571538*^9, {3.748159931466012*^9, 3.74816004871554*^9}, {
   3.748160228196992*^9, 3.7481602298423862`*^9}, {3.748263847307515*^9, 
   3.748263868825564*^9}, 3.7487821503468614`*^9, {3.7490209439297647`*^9, 
   3.7490209507602096`*^9}}],

Cell["The boundary conditions are defined as in the main text", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.749799411478346*^9, 3.749799445075716*^9}, 
   3.749799521555356*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BoundaryConditionDisplacementSubstrate", "=", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y", ",", "z0"}], "]"}], "-", 
    RowBox[{"uS", "[", 
     RowBox[{"x", ",", "y", ",", "z0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BoundaryConditionDisplacementSuperstrate", "=", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y", ",", "z1"}], "]"}], "-", 
    RowBox[{"uS2", "[", 
     RowBox[{"x", ",", "y", ",", "z1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BoundaryConditionsStressSubstate", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Sigma]", ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "-", 
     RowBox[{"\[Sigma]S", ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"z", "\[Rule]", " ", "z0"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BoundaryConditionsStressSuperstrate", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Sigma]", ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "+", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"2", " ", "L", 
        RowBox[{"(", 
         RowBox[{"uz", "[", 
          RowBox[{"x", ",", "y", ",", "z1"}], "]"}], ")"}]}]}], "}"}], "-", 
     RowBox[{"\[Sigma]S2", ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"z", "\[Rule]", " ", "z1"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BoundaryConditionsAmplitude", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "\[CurlyEpsilon]"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"uz", "[", 
            RowBox[{"x", ",", "y", ",", "z1"}], "]"}], ")"}], "2"], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"xmax", "*", "ymax"}], ")"}]}], "-", 
      RowBox[{"\[CurlyEpsilon]", "^", "2"}]}], ")"}]}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.716620573616859*^9, 3.7166206460982933`*^9}, {
   3.7166665325178995`*^9, 3.716666537893193*^9}, {3.7166666610035477`*^9, 
   3.716666664499898*^9}, {3.716667247192238*^9, 3.7166672962699986`*^9}, {
   3.7166698439897795`*^9, 3.716669852672717*^9}, {3.7166699436832447`*^9, 
   3.716669964491853*^9}, {3.7166705739286613`*^9, 3.7166705784487686`*^9}, {
   3.7166709965282393`*^9, 3.7166710122606955`*^9}, {3.716671165258074*^9, 
   3.7166711744841456`*^9}, 3.7170405284753494`*^9, {3.7198214941631956`*^9, 
   3.719821497491223*^9}, {3.719821833896503*^9, 3.71982187590659*^9}, {
   3.719825602201521*^9, 3.719825603929378*^9}, 3.734338433142171*^9, {
   3.7343416068751993`*^9, 3.7343416429229355`*^9}, {3.734524027035774*^9, 
   3.734524044987177*^9}, {3.7348032223222446`*^9, 3.7348032397050104`*^9}, {
   3.7483596691754847`*^9, 3.748359675223789*^9}, {3.7483621048490763`*^9, 
   3.7483621092926903`*^9}, {3.748362206482781*^9, 3.748362339641395*^9}, {
   3.7483624068271103`*^9, 3.748362426864996*^9}, {3.7483626830627604`*^9, 
   3.748362710905182*^9}, {3.7483627829528646`*^9, 3.7483628059333477`*^9}, {
   3.74836436962538*^9, 3.748364399607009*^9}, {3.7483649291164217`*^9, 
   3.748364943985876*^9}, 3.748585348073351*^9, 3.7487821503468614`*^9, {
   3.7490215677479725`*^9, 3.749021601466423*^9}, {3.7490220542463064`*^9, 
   3.7490220774418344`*^9}, {3.7490221653627944`*^9, 3.749022167529889*^9}, {
   3.7490223188669796`*^9, 3.7490223333917394`*^9}, {3.7490226912272625`*^9, 
   3.749022702089678*^9}, 3.749112861532675*^9, {3.749113251814229*^9, 
   3.7491132569105883`*^9}, 3.7493810723404922`*^9, 3.749799514692628*^9},
 ExpressionUUID -> "576cfcb5-ac56-451a-b7a7-277ed325b1cc"],

Cell["These are then joined together into s single list", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.749799472009684*^9, 3.749799485223778*^9}, 
   3.749799521555356*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BoundaryConditions", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
    "BoundaryConditionDisplacementSubstrate", ",", 
     "BoundaryConditionDisplacementSuperstrate", ",", 
     "BoundaryConditionsStressSubstate", ",", 
     "BoundaryConditionsStressSuperstrate", ",", 
     RowBox[{"{", "BoundaryConditionsAmplitude", "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.748159737349607*^9, 3.748159777026465*^9}, {
   3.7481598632020063`*^9, 3.7481598810558777`*^9}, {3.748267210423747*^9, 
   3.748267232269842*^9}, {3.748362353152483*^9, 3.748362372874612*^9}, {
   3.748362430936763*^9, 3.7483624385081987`*^9}, {3.748363159362442*^9, 
   3.748363162500799*^9}, 3.7487821503468614`*^9, {3.749022755942657*^9, 
   3.7490227661088066`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Stripe Pattern", "Section"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483712732950583`*^9, 3.7483712754201603`*^9}, 
   3.7487821767591968`*^9}],

Cell["Displacement fields", "Subsubsection",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.734858096251944*^9, 3.734858108803898*^9}, 
   3.7487821767591968`*^9},
 TextAlignment->Left,
 ExpressionUUID -> "1b3bfbbc-60b3-4b40-9a2f-a856d7813b9c"],

Cell["\<\
As discussed in the main paper, the form of u(x,y,z) for the stripe pattern \
in the thin slab is expected to be of the form:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7161206305567656`*^9, 3.716120654414336*^9}, {
   3.719825444630498*^9, 3.7198254490843143`*^9}, {3.7343365435634594`*^9, 
   3.7343365530569415`*^9}, {3.7481926611831303`*^9, 3.7481926774792223`*^9}, 
   3.7487821767591968`*^9},
 ExpressionUUID -> "f5a52526-2b6d-407b-9f04-21d090a88149"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uz", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "x"}], "]"}], " ", 
    RowBox[{
     RowBox[{"fz", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"fz", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ux", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"k", " ", "x"}], "]"}], " ", 
    RowBox[{
     RowBox[{"fx", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "k", " ", "x"}], "]"}], " ", 
    RowBox[{
     RowBox[{"fx", "[", 
      RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.665774263326209*^9, 3.66577427385541*^9}, {
   3.6657743236327744`*^9, 3.665774371967226*^9}, {3.665774467469146*^9, 
   3.6657745171664667`*^9}, {3.6657746780929537`*^9, 
   3.6657747272032385`*^9}, {3.6657757781517873`*^9, 3.665775808017256*^9}, 
   3.6657759580813837`*^9, 3.6657760065598683`*^9, 3.6658296584374185`*^9, 
   3.6660107266892014`*^9, 3.666012204886698*^9, {3.666012513519569*^9, 
   3.6660125247351093`*^9}, {3.66601278685109*^9, 3.666012806026108*^9}, {
   3.666012972519032*^9, 3.666012979006877*^9}, {3.666013887366681*^9, 
   3.666013928053396*^9}, 3.666013989868081*^9, {3.6660147320221443`*^9, 
   3.666014756277513*^9}, {3.666014819652697*^9, 3.6660148425158243`*^9}, {
   3.666015002745376*^9, 3.666015011136634*^9}, 3.666015703700157*^9, 
   3.666015744531355*^9, 3.667246053897068*^9, {3.6672461691966453`*^9, 
   3.6672461754305334`*^9}, {3.705818060293044*^9, 3.7058180743009596`*^9}, {
   3.705818289204507*^9, 3.705818297352764*^9}, {3.705818346823226*^9, 
   3.705818381764964*^9}, 3.7058184518271837`*^9, {3.705819379045109*^9, 
   3.7058193899392233`*^9}, {3.716120693874295*^9, 3.716120694038066*^9}, 
   3.71612103748448*^9, {3.71666379795361*^9, 3.7166638046447215`*^9}, 
   3.7345160870401254`*^9, {3.7347802139114037`*^9, 3.734780215949613*^9}, 
   3.7482440160956907`*^9, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "40dad8a7-b736-4d12-af4b-30060025e83a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uy", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", "0"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657759391218367`*^9, 3.665776057713159*^9}, 
   3.6658296584379063`*^9, 3.6660107291851473`*^9, 3.666012209694578*^9, {
   3.666012528999206*^9, 3.666012537142894*^9}, {3.666012999870729*^9, 
   3.666013019358135*^9}, {3.666013072317521*^9, 3.666013074029131*^9}, {
   3.6660131551716967`*^9, 3.6660131691793137`*^9}, {3.6660139204933443`*^9, 
   3.666013926621202*^9}, 3.666013992463925*^9, {3.6660147384939632`*^9, 
   3.666014757597476*^9}, {3.666014822508614*^9, 3.6660148479637136`*^9}, {
   3.6660150080811462`*^9, 3.666015018784547*^9}, {3.666015633085493*^9, 
   3.666015653788924*^9}, 3.666015704827859*^9, 3.666015746131331*^9, 
   3.6672460553753724`*^9, 3.66724612564708*^9, {3.7161206968910065`*^9, 
   3.7161206970825825`*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 
 ExpressionUUID -> "37011bf4-9d75-4895-8b92-c683ff6c780b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["g", "4"], " ", "\[Mu]1"}], "+", 
   RowBox[{"\[CurlyEpsilon]", " ", "\[Mu]1", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "x"}], "]"}], " ", 
    RowBox[{
     RowBox[{"fp", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], " ", "\[Mu]1", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"fp", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fp", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], " ", "\[Mu]1", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fp", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fp", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657760820092983`*^9, 3.6657761051983843`*^9}, {
   3.665829557920424*^9, 3.665829559173556*^9}, 3.6658296584379063`*^9, 
   3.667246058975377*^9, {3.6672461347851114`*^9, 3.667246155584901*^9}, 
   3.669693515772377*^9, {3.705227845845664*^9, 3.7052278461045*^9}, {
   3.705227934870659*^9, 3.7052279383910027`*^9}, {3.7052299167648897`*^9, 
   3.705229970446568*^9}, {3.7052300261184797`*^9, 3.705230027175839*^9}, {
   3.705230071958618*^9, 3.705230077742556*^9}, {3.7058180782087336`*^9, 
   3.7058180848812704`*^9}, {3.7058183287173777`*^9, 3.705818340355358*^9}, 
   3.705818454586179*^9, {3.7059142877117147`*^9, 3.705914289123722*^9}, {
   3.716120699703617*^9, 3.71612069985559*^9}, {3.716120863888893*^9, 
   3.7161208688602057`*^9}, 3.7161210488972373`*^9, 3.7343363526051474`*^9, 
   3.734516089009384*^9, 3.748244029781723*^9, {3.7487818960376935`*^9, 
   3.7487818996975975`*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 
 ExpressionUUID -> "cd99ff87-ca37-49e1-8b73-9d2f02158237"],

Cell["and in the substrate and superstrate", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7343365589552717`*^9, 3.7343365626007757`*^9}, 
   3.7487821767601943`*^9, {3.7490228226148396`*^9, 3.749022825130707*^9}},
 ExpressionUUID -> "ceb842ef-d180-4cf0-a344-86b9f7dc9cc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.749022827086334*^9, 3.7490228408936667`*^9}},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}, {3.7490228286611767`*^9, 3.749022839461113*^9}},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.7490228292222233`*^9, 3.749022837940277*^9}},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}, {3.7490228299433208`*^9, 
   3.749022832576417*^9}},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[TextData[{
 "As in the main paper, ",
 StyleBox["fx[m,n][z] ", "Output"],
 "refers to the nth fourier term in the nth order in \[CurlyEpsilon] for ux, \
etc, which is a function of z."
}], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166711408488564`*^9, 3.7166711591302385`*^9}, {
   3.717343550334776*^9, 3.7173435553189697`*^9}, 3.717405806531722*^9, {
   3.7201699417103024`*^9, 3.7201699536755857`*^9}, {3.748192683134962*^9, 
   3.748192723039256*^9}, {3.74826292775035*^9, 3.748262987975998*^9}, 
   3.7487821767601943`*^9},
 ExpressionUUID -> "4ca55bf9-035a-4d4d-9323-a1eeaafb8812"],

Cell[TextData[StyleBox["Surface stress", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748192884714484*^9, 3.748192886896722*^9}, 
   3.7487821767601943`*^9}],

Cell["\<\
We also write the Lagrange multiplier for the surface amplitude as a series \
in \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748192725130557*^9, 3.7481927471727858`*^9}, 
   3.7487821767601943`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"L0", "+", 
    RowBox[{"\[CurlyEpsilon]", " ", "L1"}], " ", "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", "L2"}]}]}], " ", 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6651762408646874`*^9, 3.665176284308905*^9}, {
   3.6652272035076323`*^9, 3.6652272055495043`*^9}, 3.6653092065011587`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.669689820988999*^9, 
   3.669689828501999*^9}, {3.669691223963415*^9, 3.6696912248537703`*^9}, 
   3.7058486877397184`*^9, 3.7164901243745613`*^9, {3.734516110546652*^9, 
   3.7345161144425993`*^9}, {3.748782161964778*^9, 3.7487821767611914`*^9}},
 ExpressionUUID -> "157f94d4-a345-4842-ba8b-e758cc27a061"],

Cell[TextData[StyleBox["Calculation of the energy coefficients", \
"Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748193033814044*^9, 3.7481930409641542`*^9}, 
   3.7487821767611914`*^9}],

Cell["\<\
To calculate the energy coefficients, we first expand the energy density as a \
series in \[CurlyEpsilon].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748261801266735*^9, 3.7482618033912163`*^9}, 
   3.7487821767611914`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W2", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W3", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S", ",", "W2S", ",", "W3S", ",", "W4S"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2", ",", "W2S2", ",", "W3S2", ",", "W4S2"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748262405354032*^9, 
   3.748262405520245*^9}, {3.7483637331750517`*^9, 3.748363879931884*^9}, {
   3.748782161964778*^9, 3.7487821767611914`*^9}, {3.7490228751723347`*^9, 
   3.7490228933278155`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[TextData[StyleBox["In-plane averaging", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, 
   3.7487821767611914`*^9}],

Cell["\<\
For the stripe pattern, to take in-plane averages we integrate over an \
in-plane square with vertices (0,0) and (xmax, ymax) where:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, 3.7487821767611914`*^9, {3.74979987917766*^9, 
   3.749799884457762*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xmax", "=", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "k"}]}]}], ";", 
  RowBox[{"ymax", "=", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "k"}]}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.719933909813597*^9, {3.734776818484407*^9, 3.73477681962022*^9}, 
   3.7487821767611914`*^9},
 ExpressionUUID -> "5855c714-aa51-498c-95ad-fb5bc38951a6"],

Cell["\<\
We first average the W coefficients over this in-plane unit cell:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748261748545721*^9, 3.748261754737146*^9}, {
   3.748261885770821*^9, 3.748261903569084*^9}, 3.7487821767611914`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{"W1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W2av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{"W2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W3av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{"W3", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{"W4", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1Sav", ",", "W2Sav", ",", "W3Sav", ",", "W4Sav"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2av", ",", "W2S2av", ",", "W3S2av", ",", "W4S2av"}], "}"}], 
   "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748363304860167*^9, 3.748363305950943*^9}, {3.748363884084024*^9, 
   3.7483639296474533`*^9}, 3.74836397218202*^9, {3.748782161964778*^9, 
   3.7487821767611914`*^9}, {3.749022905875888*^9, 3.749022918858284*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[TextData[StyleBox["Validation the solution satisfies the bulk \
equations", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, {
   3.7481929666078777`*^9, 3.748192979141858*^9}, 3.7487821767611914`*^9}],

Cell["\<\
We use the inbuilt Mathematica \[OpenCurlyDoubleQuote]Series\
\[CloseCurlyDoubleQuote]  to expand the bulk equations to third order as a \
series in  \[CurlyEpsilon]\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, 3.7487821767611914`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquations", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748359076251601*^9, 3.748359096792377*^9}, 
   3.7487821767611914`*^9}],

Cell["\<\
We simplify these equations using the bespoke helper function TrigSimplify, \
which expresses the equations as a sum of Trig components and applies \
Simplify to the coefficient of each component.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
   3.748358288765593*^9}, 3.7487821767611914`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"TrigSimplify", "[", "BulkEquationSeries", "]"}]}], ";"}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748358299490245*^9, 3.748358312796399*^9}, 
   3.748358704686191*^9, {3.748359100059197*^9, 3.748359101588066*^9}, 
   3.7487821767611914`*^9, 3.7497999137613*^9}],

Cell["\<\
We can verify that this simplification has not altered the bulk equations by \
checking they are still equal to the original ones:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
   3.748358288765593*^9}, {3.748358322614171*^9, 3.748358357672377*^9}, 
   3.7487821767611914`*^9}],

Cell[BoxData[
 RowBox[{"BulkEquationSeries", "-", 
  RowBox[{"Series", "[", 
   RowBox[{"BulkEquations", ",", 
    RowBox[{"{", 
     RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], 
   "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, {3.748358368733041*^9, 3.7483583845075893`*^9}, {
   3.748358678288769*^9, 3.7483586799880857`*^9}, {3.748358732311248*^9, 
   3.748358750771925*^9}, {3.7483591033228397`*^9, 3.748359135765121*^9}, 
   3.748782176762218*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.7498023037753973`*^9, 3.7500617181279893`*^9, 
  3.7537340708800793`*^9}],

Cell[CellGroupData[{

Cell["\<\
The actual fields are stored in the variable \
\[OpenCurlyDoubleQuote]fsolutionstripe\[CloseCurlyDoubleQuote] which was \
imported from \[OpenCurlyDoubleQuote]sandwich_pert_soltuions.nb\
\[CloseCurlyDoubleQuote].  This variable is a list of substitutions \
containing the full algebraic form of all 29 unknown functions, for example:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, 
   3.748782176762218*^9, {3.7498007630893106`*^9, 3.749800764401509*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fz", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], "/.", 
  "fsolutionstripe"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, 3.748782176762218*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"k", " ", "z"}], 
      SuperscriptBox["g", "3"]]}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"k", " ", "z"}], 
     SuperscriptBox["g", "3"]]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "k"}], " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "3"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"k", " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "4"}], "]"}]}]}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748244176965735*^9, 3.7482639273061953`*^9, 3.748264223572152*^9, 
   3.748264653298921*^9, 3.748265004576914*^9, 3.748265122915847*^9, {
   3.748265238444811*^9, 3.748265250327454*^9}, 3.748265448476235*^9, 
   3.748265624397996*^9, 3.748266735181037*^9, 3.7482674535155573`*^9, {
   3.748362839670229*^9, 3.748362842689076*^9}, 3.7483644465534697`*^9, 
   3.748364982272184*^9, 3.748367910277012*^9, 3.748368491240568*^9, 
   3.748368851953443*^9, 3.74836939562584*^9, 3.748370084581484*^9, 
   3.748762171746231*^9, 3.748782176762218*^9, 3.748788216007246*^9, 
   3.7490633990286627`*^9, 3.749063553585493*^9, 3.749064673831664*^9, 
   3.7498021651743965`*^9, 3.749802303837859*^9, 3.7537340708970313`*^9}],

Cell["\<\
To verify these fields solve the bulk equations, we substitute them in, and \
then simplify the result using the second bespoke simplification function, \
ExpSimplify, which expresses the equations as a sum of Exponential components \
and then applies Simplify to the coefficient of each component.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
   3.74835877376761*^9, 3.748358840101597*^9}, 3.748782176762218*^9},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{"ExpSimplify", "[", 
  RowBox[{"BulkEquationSeries", "/.", "fsolutionstripe"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, 3.7483591121969*^9, 3.748782176762218*^9, 
   3.749799921955818*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748266449237129*^9, {3.748266746084798*^9, 3.748266753327408*^9}, 
   3.7482668404761057`*^9, 3.748266886592949*^9, 3.748266931748948*^9, 
   3.748269370234029*^9, 3.7482694147133293`*^9, 3.748269473584978*^9, 
   3.748357981253419*^9, 3.748358876699185*^9, 3.748359172776833*^9, 
   3.748362882992113*^9, 3.748364478461955*^9, 3.748365013812048*^9, 
   3.7483679425706673`*^9, 3.748368523080491*^9, 3.748368883587565*^9, 
   3.748369427481436*^9, 3.7483701167121353`*^9, 3.7487622112097683`*^9, 
   3.748782176762218*^9, 3.748788251731667*^9, 3.749064759880543*^9, 
   3.749802342306419*^9, 3.753734108487119*^9}],

Cell["\<\
One can achieve the same result up to second order using the built in \
function Simplify, but this takes unreasonably long for the layer equations \
at third order. \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
   3.74835877376761*^9, 3.748358840101597*^9}, {3.7483589228041067`*^9, 
   3.748358941540511*^9}, {3.748358982662092*^9, 3.748359022408444*^9}, 
   3.748782176762218*^9},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquationSeries", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
   "fsolutionstripe"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, {3.748358950227021*^9, 3.748358988873667*^9}, 
   3.748359114064515*^9, 3.748782176762218*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748266449237129*^9, {3.748266746084798*^9, 3.748266753327408*^9}, 
   3.7482668404761057`*^9, 3.748266886592949*^9, 3.748266931748948*^9, 
   3.748269370234029*^9, 3.7482694147133293`*^9, 3.748269473584978*^9, 
   3.748357981253419*^9, 3.748358876699185*^9, {3.748358966478747*^9, 
   3.748358990964706*^9}, 3.748359174735601*^9, 3.7483628926351757`*^9, 
   3.74836448043106*^9, 3.748365015780291*^9, 3.748367944583262*^9, 
   3.748368525087225*^9, 3.748368885573244*^9, 3.748369429491639*^9, 
   3.7483701187715797`*^9, 3.7487622133057127`*^9, 3.748782176762218*^9, 
   3.7487882540045877`*^9, 3.749063598231614*^9, 3.749064689828535*^9, 
   3.7491110437359233`*^9, 3.749802344321546*^9, 3.753734110883521*^9}],

Cell[TextData[StyleBox["Validation the solution satisfies the boundary \
conditions", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748192982991539*^9, 3.748192988325735*^9}, 
   3.748782176762218*^9}],

Cell["\<\
The full solutions for the constants of integration (and L0, L1, L2) are \
computed in the separate notebook \
\[OpenCurlyDoubleQuote]sandwich_pert_stripe_constants\[CloseCurlyDoubleQuote] \
which we run here. This document actually computes the constants, so running \
it may take a few (~5) minutes.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482607612792273`*^9, 3.748260875123485*^9}, {
   3.7482657965084953`*^9, 3.7482657975804243`*^9}, 3.748782176762218*^9, {
   3.7497999300008383`*^9, 3.7497999313909955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookEvaluate", "[", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<sandwich_pert_stripe_constants.nb\>\""}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748158213150754*^9, 3.748158219797617*^9}, {
   3.7481941325489397`*^9, 3.748194136035887*^9}, 3.748195107133922*^9, {
   3.748195421557001*^9, 3.7481954825069237`*^9}, 3.748195517246182*^9, {
   3.74819562767171*^9, 3.748195632607148*^9}, {3.7481957842483664`*^9, 
   3.74819582426667*^9}, {3.748260846949068*^9, 3.748260849580188*^9}, 
   3.748364094167431*^9, 3.748782176763212*^9, {3.7491110527630577`*^9, 
   3.7491110581896415`*^9}}],

Cell["\<\
After running  \[OpenCurlyDoubleQuote]pert_stripe_constants\
\[CloseCurlyDoubleQuote], the algebraic forms for the constants are stored in \
the three variables, FirstOrderConstantsStripe, SecondOrderConstantsStripe \
and ThirdOrderConstantsStripe. For example:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482608804202003`*^9, 3.748260931153734*^9}, {
   3.748260970268648*^9, 3.748260985377118*^9}, 3.748782176763212*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{"1", ",", "1"}], "]"}], "/.", 
  "FirstOrderConstantsStripe"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, {3.748782161964778*^9, 
   3.748782176763212*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"k", "+", 
      FractionBox["k", 
       RowBox[{"2", " ", 
        SuperscriptBox["g", "3"]}]]}]], " ", 
    SuperscriptBox["g", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "11"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "14"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "17"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "g", " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "4"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "7"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "10"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "13"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "9"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["\[Mu]2", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["g", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"k", "+", 
               FractionBox["k", 
                SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
          SuperscriptBox["\[Mu]1", "3"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
          SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"32", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", 
         FractionBox["1", 
          SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]], " ", 
     SuperscriptBox["g", "5"], " ", "\[Mu]2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["\[Mu]1", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["g", "8"], " ", 
        SuperscriptBox["\[Mu]1", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Mu]2", "2"]}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "k"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["g", "3"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["g", "5"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["g", "8"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["g", "11"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["g", "14"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"4", " ", "g", " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "4"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"4", " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Mu]1", "3"], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"k", "+", 
       FractionBox[
        RowBox[{"2", " ", "k"}], 
        SuperscriptBox["g", "3"]]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["g", "3"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["g", "5"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["g", "8"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["g", "11"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["g", "14"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", "g", " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "4"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"4", " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Mu]1", "3"], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", 
         FractionBox["2", 
          SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["g", "3"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["g", "5"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["g", "8"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["g", "11"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["g", "14"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", "g", " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "4"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"4", " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Mu]1", "3"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", " ", "k"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["g", "3"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["g", "5"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["g", "8"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["g", "11"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["g", "14"], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"4", " ", "g", " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "4"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
       RowBox[{"4", " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
        SuperscriptBox["\[Mu]2", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Mu]1", "3"], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{3.748260951225204*^9, 3.748363017860961*^9, 
  3.74836452913402*^9, 3.748365064394639*^9, 3.7483663728484793`*^9, 
  3.748367993301462*^9, 3.748368573734091*^9, 3.748368934061269*^9, 
  3.748369478943746*^9, 3.748370167978312*^9, 3.7487623028065624`*^9, 
  3.748782176763212*^9, 3.749111195512032*^9, 3.7498025884559827`*^9, 
  3.753734230216589*^9}],

Cell["\<\
The second order constants are in terms of the first order ones, and the \
third order constants are in terms of the first and second order ones:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482610014395227`*^9, 3.748261036909691*^9}, 
   3.748782176763212*^9}],

Cell["\<\
Mathematica is not able to validate that these solutions solve the boundary \
conditions in a reasonable amount of time, so we instead conduct this \
validation numerically at a high-precision numerical test point: \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482610837996073`*^9, 3.7482611632713633`*^9}, 
   3.748782176763212*^9}],

Cell[BoxData[
 RowBox[{"TestPoint", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]1", "\[Rule]", " ", "3"}], ",", 
      RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", "  ", 
      RowBox[{"g", "\[Rule]", " ", "1.4"}], ",", " ", 
      RowBox[{"k", "\[Rule]", " ", "5"}], ",", " ", 
      RowBox[{"z0", "\[Rule]", 
       RowBox[{"-", "0.5"}]}], ",", 
      RowBox[{"z1", "\[Rule]", "0.5"}]}], "}"}], ",", "50"}], 
   "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.748367111887246*^9, 3.7483671121796923`*^9}, {3.748782161964778*^9, 
   3.748782176763212*^9}, {3.749022978961009*^9, 3.74902298433265*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]1", "\[Rule]", "3.`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1.`50."}], ",", 
   RowBox[{
   "g", "\[Rule]", 
    "1.399999999999999911182158029987476766109466552734375`50."}], ",", 
   RowBox[{"k", "\[Rule]", "5.`50."}], ",", 
   RowBox[{"z0", "\[Rule]", 
    RowBox[{"-", "0.5`50."}]}], ",", 
   RowBox[{"z1", "\[Rule]", "0.5`50."}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{3.74835928266391*^9, 3.7483630202645607`*^9, 
  3.7483640992877703`*^9, 3.748364529203432*^9, 3.7483650644576797`*^9, 
  3.748366375786837*^9, 3.7483670795186777`*^9, 3.748367112856585*^9, 
  3.748367993387788*^9, 3.748368573802745*^9, 3.748368934137578*^9, 
  3.7483694790276117`*^9, 3.748370168053019*^9, 3.7487623072167625`*^9, 
  3.748782176763212*^9, 3.749111195586832*^9, 3.7491130325072145`*^9, 
  3.749802594654812*^9, 3.7537342302864027`*^9}],

Cell["\<\
At this TestPoint, we can numerically evaluate the constants at high \
precision, and we store these numerical constants in the variable \
\[OpenCurlyDoubleQuote]NumericalConstants\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748261177554925*^9, 3.748261244832778*^9}, 
   3.748782176763212*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericalConstants", "[", 
   RowBox[{
    RowBox[{"\[Mu]1value_", "?", "NumericQ"}], ",", 
    RowBox[{"\[Mu]2value_", "?", "NumericQ"}], ",", 
    RowBox[{"gvalue_", "?", "NumericQ"}], ",", 
    RowBox[{"kvalue_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TestPoint", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Mu]1value"}], ",", 
          RowBox[{"\[Mu]2", "\[Rule]", " ", "\[Mu]2value"}], ",", " ", 
          RowBox[{"g", "\[Rule]", " ", "gvalue"}], ",", " ", 
          RowBox[{"k", "\[Rule]", " ", "kvalue"}], ",", " ", 
          RowBox[{"z0", "\[Rule]", " ", 
           RowBox[{"-", "0.5"}]}], ",", " ", 
          RowBox[{"z1", "\[Rule]", " ", "0.5"}]}], "}"}], ",", "50"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"NFirstOrderConstantsStripe", "=", 
      RowBox[{"FirstOrderConstantsStripe", "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"NSecondOrderConstantsStripe", "=", 
      RowBox[{
       RowBox[{
       "SecondOrderConstantsStripe", "/.", "NFirstOrderConstantsStripe"}], "/.",
        "TestPoint"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NThirdOrderConstantsStripe", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
        "ThirdOrderConstantsStripe", "/.", "NSecondOrderConstantsStripe"}], "/.",
         "NFirstOrderConstantsStripe"}], "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "NFirstOrderConstantsStripe", ",", "NSecondOrderConstantsStripe", ",", 
        "NThirdOrderConstantsStripe"}], "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.748367299348639*^9, 
   3.748367402015232*^9}, {3.7483674432132998`*^9, 3.748367507170247*^9}, {
   3.74836755223973*^9, 3.7483675528233423`*^9}, {3.748367651745777*^9, 
   3.7483676532854013`*^9}, {3.748367722421383*^9, 3.748367724938448*^9}, {
   3.7483678628756857`*^9, 3.748367874455339*^9}, {3.7483679329955873`*^9, 
   3.748367942772023*^9}, {3.748782161964778*^9, 3.748782176763212*^9}, {
   3.749111139276334*^9, 3.7491111432517304`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["For example:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482612779840107`*^9, 3.748261279483727*^9}, 
   3.748782176763212*^9}],

Cell[BoxData[
 RowBox[{"L2", "/.", 
  RowBox[{"NumericalConstants", "[", 
   RowBox[{"3", ",", "1", ",", "1.4", ",", "5"}], "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.748782161964778*^9, 3.748782176763212*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["466.2088285243435472612186580495567885464514676955881838531594`\
38.27969291464363"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748261268192404*^9, {3.74826130444674*^9, 3.7482613107879143`*^9}, {
   3.748359350121023*^9, 3.7483593582974463`*^9}, {3.748363025924615*^9, 
   3.748363029546698*^9}, 3.748364531154643*^9, 3.7483650662788057`*^9, 
   3.748366380080958*^9, 3.748367709560692*^9, 3.748368005189967*^9, 
   3.748368575584404*^9, 3.7483689360378933`*^9, 3.748369481065188*^9, 
   3.7483701698933897`*^9, 3.748762323442356*^9, 3.748782176763212*^9, 
   3.7491112182282734`*^9, 3.7491131216054816`*^9, 3.749802602170991*^9, 
   3.753734236934292*^9}],

Cell["\<\
Finally, we expand the boundary conditions to third order in epsilon, \
substitute in the fields and the constants and evaluate at the test point, to \
show that they are satisfied up to machine precision. The Chop command rounds \
numbers smaller than 10^-30 to zero.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
   3.748261408839826*^9, 3.748261423343892*^9}, {3.748367234219556*^9, 
   3.748367248653973*^9}, 3.7487821767642107`*^9}],

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Series", "[", 
        RowBox[{"BoundaryConditions", ",", 
         RowBox[{"{", 
          RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.",
        "fsolutionstripe"}], "/.", 
      RowBox[{"NumericalConstants", "[", 
       RowBox[{"3", ",", "1", ",", "1.4", ",", "5"}], "]"}]}], "/.", 
     "TestPoint"}], "]"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "30"}]}]}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.7483671689589977`*^9, 3.7483671715347033`*^9}, {
   3.748367220011492*^9, 3.7483672221377087`*^9}, {3.7483675709932613`*^9, 
   3.7483675787994757`*^9}, {3.748782161964778*^9, 3.7487821767642107`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", "0", ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7483630651882343`*^9, 3.7483631806408167`*^9, 3.748363276704946*^9, 
   3.748364111234914*^9, 3.7483645363752213`*^9, 3.748365071665619*^9, 
   3.7483663906728697`*^9, 3.748367125524706*^9, 3.748367178003598*^9, {
   3.748367229036347*^9, 3.748367257146784*^9}, 3.748367587353529*^9, 
   3.748367673543158*^9, 3.748368015570116*^9, 3.748368582708802*^9, 
   3.748368943984146*^9, 3.748369488756003*^9, 3.748370177207624*^9, 
   3.7487623367849684`*^9, 3.7487821767642107`*^9, 3.7491131469926033`*^9, 
   3.7491132777056026`*^9, 3.749802613527737*^9, 3.7537342491478934`*^9}],

Cell["\<\
The user is invited to validate the boundary conditions at alternative \
test-points by modifying \[OpenCurlyDoubleQuote]TestPoint\
\[CloseCurlyDoubleQuote] above.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
   3.748261408839826*^9, 3.7482614927761793`*^9}, 3.7487821767642107`*^9}],

Cell[TextData[StyleBox["Thickness integration", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748262074419416*^9, 3.74826208137881*^9}, 
   3.7487821767642107`*^9}],

Cell["\<\
We next integrate the averaged energies over thickness to find the energy \
coefficients as defined in the paper: We must assume the real part of k>0, \
otherwise the elastic solutions diverge in the substrate and superstrate. \
This calculation may take several minutes.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7482620881141*^9, 3.748262101954483*^9}, {
   3.748363346970169*^9, 3.748363359624626*^9}, {3.748365214909356*^9, 
   3.748365240840098*^9}, {3.74836617852466*^9, 3.748366185813534*^9}, 
   3.7487821767642107`*^9, {3.749800702147659*^9, 3.7498007059904127`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"E1", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1Sav", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1S2av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E2", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2Sav", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2S2av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E3", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3Sav", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3S2av", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E4", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W4Sav", "/.", "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ExpSimplify", "[", 
        RowBox[{"W4av", "/.", "fsolutionstripe"}], "]"}], "/.", 
       "fsolutionstripe"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"+", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"W4S2av", "/.", "fsolutionstripe"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748262113533332*^9, 3.748262252817123*^9}, {3.748262305237101*^9, 
   3.748262310340988*^9}, {3.748262365269137*^9, 3.7482623722651787`*^9}, {
   3.7483633671292267`*^9, 3.748363383150691*^9}, {3.7483635959244337`*^9, 
   3.7483636870930433`*^9}, {3.748364333478301*^9, 3.748364334039871*^9}, {
   3.748365181454217*^9, 3.748365190982555*^9}, {3.748366111342016*^9, 
   3.7483661577719717`*^9}, {3.748782161964778*^9, 3.7487821767642107`*^9}, {
   3.749023083142062*^9, 3.7490231412630105`*^9}, {3.749113950980748*^9, 
   3.749113975181006*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[TextData[StyleBox["Threshold for instability", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.74836666158285*^9, 3.748366669568527*^9}, 
   3.7487821767642107`*^9}],

Cell["\<\
Instability occurs spontaneously at the point where L0=0, which corresponds \
to the following conditions:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366714346525*^9}, 
   3.7487821767642107`*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"ExpToTrig", "[", 
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"L0", "/.", "FirstOrderConstantsStripe"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", " ", 
        RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Eta]"}]}], "}"}]}], "]"}], "]"}],
    "\[Equal]", "0"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748782161964778*^9, 3.7487821767642107`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"k", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["g", "6"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}]}], ")"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["g", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["g", "4"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "12"]}]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"g", "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["g", "7"]}]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "3"], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"g", "-", 
              SuperscriptBox["g", "7"]}], ")"}], "2"], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["g", "6"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["g", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["g", "6"]}], ")"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"13", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                SuperscriptBox["g", "18"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                RowBox[{"20", " ", 
                 SuperscriptBox["g", "18"]}], "+", 
                SuperscriptBox["g", "24"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "g", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               SuperscriptBox["g", "4"]}], "+", 
              SuperscriptBox["\[Eta]", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["g", "12"], " ", 
               SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["g", "6"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             SuperscriptBox["g", "6"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.748366436722287*^9, {3.74836648564769*^9, 3.7483665065569477`*^9}, {
   3.748366542145163*^9, 3.748366610605278*^9}, 3.74836672545654*^9, 
   3.748368724221715*^9, 3.7483690947625504`*^9, 3.748369632442429*^9, 
   3.7483703251075907`*^9, 3.74876253043325*^9, 3.7487821767642107`*^9, 
   3.749113395652156*^9, 3.7498028727537837`*^9, 3.7537345101636086`*^9}],

Cell["\<\
This equation does not have an analytic solution, but can be solved \
numerically for g* at any value of k and \[Eta]. We have written a helper \
function CharacterizeInstabilitySandwich[\[Eta]] which finds numerically (but \
at high precision) the k* and g* for the first point of instability at a \
given value of \[Eta].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366914683483*^9}, 3.7487821767642107`*^9, {
   3.7498007218600817`*^9, 3.749800722859866*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366863463852*^9, 3.7483668668954573`*^9}, {3.748782161964778*^9, 
   3.7487821767642107`*^9}, {3.7491135695320525`*^9, 3.7491135720682683`*^9}},
 
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "g", "\[Rule]", 
    "1.24800619978443093404446326403077289245806686892119996464142355403003738\
290813`50."}], ",", 
   RowBox[{
   "k", "\[Rule]", 
    "1.40271633944241459594362210259135548632004523108779084003855628224143148\
358653`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1"}], ",", 
   RowBox[{"\[Mu]1", "\[Rule]", "3"}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{3.748366867457121*^9, 3.748368041616961*^9, 
  3.748368103648972*^9, 3.748368724340021*^9, 3.748369094895968*^9, 
  3.748369632567338*^9, 3.7483703252332773`*^9, 3.7487625305355177`*^9, 
  3.748782176766178*^9, 3.7491133957568755`*^9, 3.74911380419457*^9, 
  3.749802872863126*^9, 3.7537345102653666`*^9}],

Cell["\<\
We can validate that this point does indeed correspond to L0=0.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, 3.748782176766178*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"L0", "/.", "FirstOrderConstantsStripe"}], "/.", 
   RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366880429227*^9, 3.748366892535075*^9}, {3.748782161964778*^9, 
   3.748782176766178*^9}, 3.7491138105365105`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``47.00730560341811"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7483668935893517`*^9, 3.748367745014412*^9, 3.74836810758436*^9, 
   3.748368724399867*^9, 3.7483690949662523`*^9, 3.748369632630701*^9, 
   3.748370325296257*^9, 3.7487625343553905`*^9, 3.748782176766178*^9, 
   3.7491133958456507`*^9, {3.7491138065053916`*^9, 3.749113814257842*^9}, 
   3.749802872956856*^9, 3.7537345103346267`*^9}],

Cell["\<\
As does the energy coefficient E2, which we expect to have the form E2= \
C2(g-g*)\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
   3.748368290906556*^9}, 3.7487821767671757`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"E2", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, 3.7487625531420918`*^9, 3.7487626080329123`*^9, {
   3.748782161964778*^9, 3.7487821767671757`*^9}, 3.749113811359969*^9, {
   3.749113901788679*^9, 3.74911390268927*^9}, 3.7491181204297543`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"]
}, Open  ]],

Cell[BoxData["0``45.207999647948434"], "Output",
 CellChangeTimes->{3.749113821726821*^9, 3.7491139093514547`*^9, 
  3.749118088479211*^9, 3.749118130062021*^9, 3.7498028848433633`*^9, 
  3.7537345162362747`*^9}],

Cell[CellGroupData[{

Cell["\<\
We can evaluate C2 as the derivative of E2 with respect to g:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
   3.748368313602594*^9}, 3.7487821767671757`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"E2", "/.", "FirstOrderConstantsStripe"}], ",", "g"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748782161964778*^9, 3.7487821767671757`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["\<\
And then we plot C2 as a function of \[Eta], reproducing fig 12E in the main \
paper.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.74836847884299*^9, {3.748368538294593*^9, 3.748368559647304*^9}, 
   3.7487821767671757`*^9, {3.7498000391041155`*^9, 3.7498000408069887`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2", "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellChangeTimes->{{3.749118648460787*^9, 3.7491186574956493`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  "22.8645488469529552555180203367793415785594306922570651289417`44.\
72932769306238"}]], "Output",
 CellChangeTimes->{{3.7491186505960755`*^9, 3.749118662385542*^9}, 
   3.7498028859837465`*^9, 3.7537345164790516`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"C2", "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0"}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370373648697*^9, 3.74837039644267*^9}, {3.7487821619677696`*^9, 
   3.7487821767671757`*^9}, 3.7491186297568417`*^9, 3.7491186887723303`*^9, {
   3.7491187839406557`*^9, 3.749118812622938*^9}, 3.749283814029645*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEP7E1eRqq8lDc7AOF/sG+7ULk+9q0plP/D/pfz
CQF7Lpg8g8O/abqrprrC+CwOp5MZ7yX3wfgcDjKl+4WC78L4PA4s4mo3z+iZ
Q/kCDpGuL6LeNsD4Qg6HpI6HrLoE44s4FO/qyMhTtoDyxRzWRxX7PiuC8SUc
vNLVa58egPGlHNLmvDwcxmsJ5cs4pH7+pG8cAePLOUycLDylZiGMr+DA9uyC
vNVLGF/Rgc8kyqJM3wrKV3LY79MnblsC4ys7KGz9+Xz2dhhfxeHdLTnDBT+t
DgAAr9ZZIw==
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEH9iYvI1VeypsdgPA/2LddqFwf+9YUyv9h
/8v5hIA9F0yeweHfNN1VU11hfBaH08mM95L7YHwOB5nS/ULBd2F8HgcWcbWb
Z/TMoXwBh0jXF1FvG2B8IYdDUsdDVl2C8UUcind1ZOQpW0D5Yg7ro4p9nxXB
+BIOXunqtU8PwPhSDmlzXh4O47WE8mUcUj9/0jeOgPHlHCZOFp5SsxDGV3Bg
e3ZB3uoljK/owGcSZVGmbwXlKzns9+kTty2B8ZUdFLb+fD57O4yv4vDulpzh
gp9WBwC5blkl
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {-30, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7483703782010193`*^9, 3.748370399121915*^9}, 
   3.7487821767671757`*^9, 3.749113409264752*^9, 3.7491186717325726`*^9, 
   3.749118716755483*^9, {3.7491188043231373`*^9, 3.749118823105899*^9}, 
   3.749802895778433*^9, 3.75373452037783*^9}]
}, Open  ]],

Cell["Similarly, C4 is obtained from E4", "Text",
 CellChangeTimes->{{3.7497999806814003`*^9, 3.74980000494288*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E4", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.74836912905235*^9, 
   3.748369233216261*^9}, {3.748369783872941*^9, 3.7483697918810062`*^9}, 
   3.7487626437594852`*^9, {3.748782161966782*^9, 3.7487821767671757`*^9}, 
   3.749113812582118*^9, {3.7491181283605404`*^9, 3.749118134321596*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["6.0281055235626409139149486623758965030492278378202161268627`39.\
02571526184832"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{3.74836979419419*^9, 3.748370329112509*^9, 
  3.748762672338292*^9, 3.7487821767671757`*^9, 3.7491134068731513`*^9, 
  3.7491181414675016`*^9, 3.749802902058106*^9, 3.7500621545494585`*^9, 
  3.7500734386691847`*^9, 3.7537345268280907`*^9}]
}, Open  ]],

Cell["which is plotted against \[Eta] as in Fig. 12F", "Text",
 CellChangeTimes->{{3.7498000090825334`*^9, 3.749800035011475*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{
         RowBox[{"E4", "/.", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"NumericalConstants", "[", 
             RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
            RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}],
            ")"}]}], "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], "//", "Quiet"}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370140467683*^9, 3.7483701573194733`*^9}, {3.748370381950783*^9, 
   3.748370387159823*^9}, 3.748370435122093*^9, {3.748370487533835*^9, 
   3.748370487814623*^9}, {3.748370591923375*^9, 3.7483705922499657`*^9}, {
   3.74837067792865*^9, 3.7483706781197844`*^9}, {3.7487821619677696`*^9, 
   3.7487821767681727`*^9}, 3.749113379963093*^9, 3.749118631354541*^9, 
   3.7491186920057096`*^9, {3.7491188389405465`*^9, 3.749118840576181*^9}, {
   3.7491188898424683`*^9, 3.7491188941978455`*^9}, 3.7492838162324033`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEP7JfevOLUf8/AAcL/YM/DJ3DI4ZUalP/DPtbg
SL+JlBKUz+BwXir7/6EJclA+i8Mq7fllS85LQfkcDrnqhzYel5GA8nkcPl4I
O7hSUAzKF3BoFWKzdigTgfKFHNZMEgrQ0RSG8kUcfsWXqjuLCkH5Yg6Xjf4w
ZesIQvkSDjtlSmTupwhA+VIOW19vanPJ54fyZRxYF104o2TPB+XLOfxj2cA6
35AXyldw8P344tlpBx4oX9HhCse8CM4MbihfyUG2/b3+2sVcUL6yQ4aBN/+x
D5xQvorDiuZLm9/7cDoAAHMJSyA=
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEH9ktvXnHqv2fgAOF/sOfhEzjk8EoNyv9h
H2twpN9ESgnKZ3A4L5X9/9AEOSifxWGV9vyyJeeloHwOh1z1QxuPy0hA+TwO
Hy+EHVwpKAblCzi0CrFZO5SJQPlCDmsmCQXoaApD+SIOv+JL1Z1FhaB8MYfL
Rn+YsnUEoXwJh50yJTL3UwSgfCmHra83tbnk80P5Mg6siy6cUbLng/LlHP6x
bGCdb8gL5Ss4+H588ey0Aw+Ur+hwhWNeBGcGN5Sv5CDb/l5/7WIuKF/ZIcPA
m//YB04oX8VhRfOlze99OB0AfKFLIg==
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {0, 16.869373490300536`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{3.748370389382762*^9, 3.748370474513866*^9, 
  3.748370566448998*^9, 3.7483707482518463`*^9, 3.7487821767681727`*^9, 
  3.7491136205047407`*^9, 3.749119189651656*^9, 3.7498030004289336`*^9, 
  3.7537346459536357`*^9}],

Cell[TextData[StyleBox["", "Input"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7483686588823566`*^9, {3.748368690681077*^9, 3.7483686934219017`*^9}, {
   3.748370078389737*^9, 3.748370128283454*^9}, 3.7487821767681727`*^9}]
}, Open  ]],

Cell[TextData[StyleBox["", "Input"]], "Text",
 CellChangeTimes->{
  3.7483686588823566`*^9, {3.748368690681077*^9, 3.7483686934219017`*^9}, {
   3.748370078389737*^9, 3.748370128283454*^9}, 3.7487821972992725`*^9}],

Cell[TextData[StyleBox["Square pattern", "Section"]], "Text",
 CellChangeTimes->{{3.748245012145316*^9, 3.748245014961288*^9}, 
   3.74878219730027*^9, {3.7487889199459248`*^9, 3.7487889213970423`*^9}}],

Cell[CellGroupData[{

Cell["Displacement fields", "Subsubsection",
 CellChangeTimes->{{3.734858096251944*^9, 3.734858108803898*^9}},
 TextAlignment->Left,
 ExpressionUUID -> "1b3bfbbc-60b3-4b40-9a2f-a856d7813b9c"],

Cell["\<\
As discussed in the main paper, the form of u(x,y,z) for the hexagonal \
pattern in the thin slab is expected to be of the form:\
\>", "Text",
 CellChangeTimes->{{3.7161206305567656`*^9, 3.716120654414336*^9}, {
  3.719825444630498*^9, 3.7198254490843143`*^9}, {3.7343365435634594`*^9, 
  3.7343365530569415`*^9}, {3.7481926611831303`*^9, 3.7481926774792223`*^9}, {
  3.7482452333005257`*^9, 3.748245235635438*^9}},
 ExpressionUUID -> "f5a52526-2b6d-407b-9f04-21d090a88149"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"uz", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", " ", 
    RowBox[{
     RowBox[{"fz", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"k", " ", "x"}], "]"}], "+", 
       RowBox[{"Cos", "[", 
        RowBox[{"k", " ", "y"}], "]"}]}], ")"}], "/", 
     SqrtBox["2"]}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"fz", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "k", " ", "x"}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "k", " ", "y"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "-", 
           RowBox[{"k", " ", "y"}]}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "x"}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "y"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "k", " ", "x"}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "k", " ", "y"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "-", 
           RowBox[{"2", " ", "k", " ", "y"}]}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", " ", "k", " ", "x"}], "-", 
           RowBox[{"k", " ", "y"}]}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", " ", "k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"2", " ", "k", " ", "y"}]}], "]"}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7162111009000196`*^9, 
   3.716732410989917*^9, 3.748859279457818*^9, {3.7488758206650095`*^9, 
   3.748875830601449*^9}, 3.7488760331211987`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ux", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"k", " ", "x"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"fx", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], "/", 
     SqrtBox["2"]}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "k", " ", "x"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"k", " ", "y"}]}], "]"}]}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "k", " ", "x"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "-", 
            RowBox[{"k", " ", "y"}]}], "]"}]}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", " ", "k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}], 
       RowBox[{"(", " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"2", " ", "k", " ", "y"}]}], "]"}]}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"2", " ", "k", " ", "y"}]}], "]"}]}], ")"}], 
       RowBox[{"(", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"fx", "[", 
           RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}], "-", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"fx", "[", 
            RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.665774263326209*^9, 3.66577427385541*^9}, {
   3.6657743236327744`*^9, 3.665774371967226*^9}, {3.665774467469146*^9, 
   3.6657745171664667`*^9}, {3.6657746780929537`*^9, 
   3.6657747272032385`*^9}, {3.6657757781517873`*^9, 3.665775808017256*^9}, 
   3.6657759580813837`*^9, 3.6657760065598683`*^9, 3.6658296584374185`*^9, 
   3.6660107266892014`*^9, 3.666012204886698*^9, {3.666012513519569*^9, 
   3.6660125247351093`*^9}, {3.66601278685109*^9, 3.666012806026108*^9}, {
   3.666012972519032*^9, 3.666012979006877*^9}, {3.666013887366681*^9, 
   3.666013928053396*^9}, 3.666013989868081*^9, {3.6660147320221443`*^9, 
   3.666014756277513*^9}, {3.666014819652697*^9, 3.6660148425158243`*^9}, {
   3.666015002745376*^9, 3.666015011136634*^9}, 3.666015703700157*^9, 
   3.666015744531355*^9, 3.667246053897068*^9, {3.6672461691966453`*^9, 
   3.6672461754305334`*^9}, {3.705818060293044*^9, 3.7058180743009596`*^9}, {
   3.705818289204507*^9, 3.705818297352764*^9}, {3.705818346823226*^9, 
   3.705818381764964*^9}, 3.7058184518271837`*^9, {3.705819379045109*^9, 
   3.7058193899392233`*^9}, {3.716120693874295*^9, 3.716120694038066*^9}, 
   3.71612103748448*^9, 3.716211105347664*^9, {3.7167340326113214`*^9, 
   3.716734034912445*^9}, {3.748859271067266*^9, 3.7488593132055273`*^9}, {
   3.7488758339225397`*^9, 3.7488758485863075`*^9}, {3.7488758925606575`*^9, 
   3.7488758940626383`*^9}, 3.748876031066695*^9},
 ExpressionUUID -> "40dad8a7-b736-4d12-af4b-30060025e83a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uy", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"k", " ", "y"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"fx", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], "/", 
     SqrtBox["2"]}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "k", " ", "y"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "-", 
           RowBox[{"k", " ", "y"}]}], "]"}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "y"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "k", " ", "y"}], "]"}], " ", 
       RowBox[{
        RowBox[{"fx", "[", 
         RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", " ", "k", " ", "x"}], "-", 
           RowBox[{"k", " ", "y"}]}], "]"}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", " ", "k", " ", "x"}], "+", 
           RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}], 
       RowBox[{"(", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"fx", "[", 
           RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}], "-", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"fx", "[", 
            RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "-", 
           RowBox[{"2", " ", "k", " ", "y"}]}], "]"}], "-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"k", " ", "x"}], "+", 
           RowBox[{"2", " ", "k", " ", "y"}]}], "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}], ")"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657759391218367`*^9, 3.665776057713159*^9}, 
   3.6658296584379063`*^9, 3.6660107291851473`*^9, 3.666012209694578*^9, {
   3.666012528999206*^9, 3.666012537142894*^9}, {3.666012999870729*^9, 
   3.666013019358135*^9}, {3.666013072317521*^9, 3.666013074029131*^9}, {
   3.6660131551716967`*^9, 3.6660131691793137`*^9}, {3.6660139204933443`*^9, 
   3.666013926621202*^9}, 3.666013992463925*^9, {3.6660147384939632`*^9, 
   3.666014757597476*^9}, {3.666014822508614*^9, 3.6660148479637136`*^9}, {
   3.6660150080811462`*^9, 3.666015018784547*^9}, {3.666015633085493*^9, 
   3.666015653788924*^9}, 3.666015704827859*^9, 3.666015746131331*^9, 
   3.6672460553753724`*^9, 3.66724612564708*^9, {3.7161206968910065`*^9, 
   3.7161206970825825`*^9}, 3.716211109987939*^9, {3.7167340335885124`*^9, 
   3.7167340359541807`*^9}, 3.748859273521719*^9, {3.7488758516919994`*^9, 
   3.7488758704648013`*^9}, 3.748876029087989*^9},
 ExpressionUUID -> "37011bf4-9d75-4895-8b92-c683ff6c780b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"\[Mu]1", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["g", "4"], "+", 
     RowBox[{"\[CurlyEpsilon]", " ", 
      RowBox[{
       RowBox[{"fp", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "x"}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "y"}], "]"}]}], ")"}], "/", 
       SqrtBox["2"]}]}], "+", 
     RowBox[{
      SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "k", " ", "x"}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "k", " ", "y"}], "]"}]}], ")"}], " ", 
         RowBox[{
          RowBox[{"fp", "[", 
           RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "-", 
             RowBox[{"k", " ", "y"}]}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "+", 
             RowBox[{"k", " ", "y"}]}], "]"}]}], ")"}], " ", 
         RowBox[{
          RowBox[{"fp", "[", 
           RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
     
     RowBox[{
      SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fp", "[", 
           RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "y"}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"fp", "[", 
           RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"3", " ", "k", " ", "x"}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{"3", " ", "k", " ", "y"}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"fp", "[", 
           RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "-", 
             RowBox[{"2", " ", "k", " ", "y"}]}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"2", " ", "k", " ", "x"}], "-", 
             RowBox[{"k", " ", "y"}]}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"2", " ", "k", " ", "x"}], "+", 
             RowBox[{"k", " ", "y"}]}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "+", 
             RowBox[{"2", " ", "k", " ", "y"}]}], "]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657760820092983`*^9, 3.6657761051983843`*^9}, {
   3.665829557920424*^9, 3.665829559173556*^9}, 3.6658296584379063`*^9, 
   3.667246058975377*^9, {3.6672461347851114`*^9, 3.667246155584901*^9}, 
   3.669693515772377*^9, {3.705227845845664*^9, 3.7052278461045*^9}, {
   3.705227934870659*^9, 3.7052279383910027`*^9}, {3.7052299167648897`*^9, 
   3.705229970446568*^9}, {3.7052300261184797`*^9, 3.705230027175839*^9}, {
   3.705230071958618*^9, 3.705230077742556*^9}, {3.7058180782087336`*^9, 
   3.7058180848812704`*^9}, {3.7058183287173777`*^9, 3.705818340355358*^9}, 
   3.705818454586179*^9, {3.7059142877117147`*^9, 3.705914289123722*^9}, {
   3.716120699703617*^9, 3.71612069985559*^9}, {3.716120863888893*^9, 
   3.7161208688602057`*^9}, 3.7161210488972373`*^9, 3.7162111139193554`*^9, 
   3.7343363460587454`*^9, {3.748859259470293*^9, 3.748859265746536*^9}, {
   3.748875874234687*^9, 3.7488758877744617`*^9}, {3.7488760238769493`*^9, 
   3.7488760343988066`*^9}},
 ExpressionUUID -> "cd99ff87-ca37-49e1-8b73-9d2f02158237"]
}, Open  ]],

Cell[CellGroupData[{

Cell["and in the substrate and superstrate", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7343365589552717`*^9, 3.7343365626007757`*^9}, 
   3.7487821767601943`*^9, {3.7490228226148396`*^9, 3.749022825130707*^9}},
 ExpressionUUID -> "ceb842ef-d180-4cf0-a344-86b9f7dc9cc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.749022827086334*^9, 3.7490228408936667`*^9}},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}, {3.7490228286611767`*^9, 3.749022839461113*^9}},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.7490228292222233`*^9, 3.749022837940277*^9}},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}, {3.7490228299433208`*^9, 
   3.749022832576417*^9}},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[TextData[{
 "As in the main paper, ",
 StyleBox["fx[m,n][z] ", "Output"],
 "refers to the nth fourier term in the nth order in \[CurlyEpsilon] for ux, \
etc, which is a function of z."
}], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166711408488564`*^9, 3.7166711591302385`*^9}, {
   3.717343550334776*^9, 3.7173435553189697`*^9}, 3.717405806531722*^9, {
   3.7201699417103024`*^9, 3.7201699536755857`*^9}, {3.748192683134962*^9, 
   3.748192723039256*^9}, {3.74826292775035*^9, 3.748262987975998*^9}, 
   3.7487821767601943`*^9},
 ExpressionUUID -> "4ca55bf9-035a-4d4d-9323-a1eeaafb8812"],

Cell[TextData[StyleBox["Surface stress", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748192884714484*^9, 3.748192886896722*^9}, 
   3.7487821767601943`*^9}],

Cell["\<\
We also write the Lagrange multiplier for the surface amplitude as a series \
in \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748192725130557*^9, 3.7481927471727858`*^9}, 
   3.7487821767601943`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"L0", "+", 
    RowBox[{"\[CurlyEpsilon]", " ", "L1"}], " ", "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", "L2"}]}]}], " ", 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6651762408646874`*^9, 3.665176284308905*^9}, {
   3.6652272035076323`*^9, 3.6652272055495043`*^9}, 3.6653092065011587`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.669689820988999*^9, 
   3.669689828501999*^9}, {3.669691223963415*^9, 3.6696912248537703`*^9}, 
   3.7058486877397184`*^9, 3.7164901243745613`*^9, {3.734516110546652*^9, 
   3.7345161144425993`*^9}, {3.748782161964778*^9, 3.7487821767611914`*^9}},
 ExpressionUUID -> "157f94d4-a345-4842-ba8b-e758cc27a061"],

Cell[TextData[StyleBox["Calculation of the energy coefficients", \
"Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748193033814044*^9, 3.7481930409641542`*^9}, 
   3.7487821767611914`*^9}],

Cell["\<\
To calculate the energy coefficients, we first expand the energy density as a \
series in \[CurlyEpsilon].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748261801266735*^9, 3.7482618033912163`*^9}, 
   3.7487821767611914`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W2", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W3", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S", ",", "W2S", ",", "W3S", ",", "W4S"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2", ",", "W2S2", ",", "W3S2", ",", "W4S2"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748262405354032*^9, 
   3.748262405520245*^9}, {3.7483637331750517`*^9, 3.748363879931884*^9}, {
   3.748782161964778*^9, 3.7487821767611914`*^9}, {3.7490228751723347`*^9, 
   3.7490228933278155`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[TextData[StyleBox["In-plane averaging", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, 
   3.7487821767611914`*^9}],

Cell["\<\
For the stripe pattern, to take in-plane averages we integrate over an \
in-plane square with vertices (0,0) and (xmax, ymax) where:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, 3.7487821767611914`*^9, {3.7498007397887793`*^9, 
   3.749800745678179*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xmax", "=", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "k"}]}]}], ";", 
  RowBox[{"ymax", "=", 
   RowBox[{"2", 
    RowBox[{"\[Pi]", "/", "k"}]}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.719933909813597*^9, {3.734776818484407*^9, 3.73477681962022*^9}, 
   3.7487821767611914`*^9},
 ExpressionUUID -> "5855c714-aa51-498c-95ad-fb5bc38951a6"],

Cell["\<\
We first average the W coefficients over this in-plane unit cell:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.748261748545721*^9, 3.748261754737146*^9}, {
   3.748261885770821*^9, 3.748261903569084*^9}, 3.7487821767611914`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W2av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W2", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W3av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W3", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W4", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1Sav", ",", "W2Sav", ",", "W3Sav", ",", "W4Sav"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2av", ",", "W2S2av", ",", "W3S2av", ",", "W4S2av"}], "}"}], 
   "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748363304860167*^9, 3.748363305950943*^9}, {3.748363884084024*^9, 
   3.7483639296474533`*^9}, 3.74836397218202*^9, {3.748782161964778*^9, 
   3.7487821767611914`*^9}, {3.749022905875888*^9, 3.749022918858284*^9}, {
   3.7491284289132147`*^9, 3.7491284402528844`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"]
}, Open  ]],

Cell[TextData[StyleBox["Validation the solution satisfies the bulk \
equations", "Subsection"]], "Text",
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, {
  3.7481929666078777`*^9, 3.748192979141858*^9}}],

Cell["\<\
We use the inbuilt Mathematica \[OpenCurlyDoubleQuote]Series\
\[CloseCurlyDoubleQuote]  to expand the bulk equations to third order as a \
series in  \[CurlyEpsilon]\
\>", "Text",
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
  3.748358066566401*^9, 3.74835810807306*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquations", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748359076251601*^9, 3.748359096792377*^9}}],

Cell["\<\
We simplify these equations using the bespoke helper function TrigSimplify, \
which expresses the equations as a sum of Trig components and applies \
Simplify to the coefficient of each component.\
\>", "Text",
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
  3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
  3.748358288765593*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"TrigSimplify", "[", "BulkEquationSeries", "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748358299490245*^9, 3.748358312796399*^9}, 
   3.748358704686191*^9, {3.748359100059197*^9, 3.748359101588066*^9}, 
   3.749800750552062*^9}],

Cell["\<\
We can verify that this simplification has not altered the bulk equations by \
checking they are still equal to the original ones:\
\>", "Text",
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
  3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
  3.748358288765593*^9}, {3.748358322614171*^9, 3.748358357672377*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BulkEquationSeries", "-", 
  RowBox[{"Series", "[", 
   RowBox[{"BulkEquations", ",", 
    RowBox[{"{", 
     RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, {3.748358368733041*^9, 3.7483583845075893`*^9}, {
   3.748358678288769*^9, 3.7483586799880857`*^9}, {3.748358732311248*^9, 
   3.748358750771925*^9}, {3.7483591033228397`*^9, 3.748359135765121*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.748358751444758*^9, {3.748359126168439*^9, 3.748359137066627*^9}, 
   3.74836444648414*^9, 3.748364982217807*^9, 3.748367910206443*^9, 
   3.748368491159952*^9, 3.748368851870126*^9, 3.748369395549582*^9, 
   3.748370084500741*^9, 3.7488799529631968`*^9, 3.749075051085127*^9, 
   3.749803265744687*^9, 3.753734822004017*^9}]
}, Open  ]],

Cell["\<\
The actual fields are stored in the variable \
\[OpenCurlyDoubleQuote]fsolutionsquare\[CloseCurlyDoubleQuote] which was \
imported from \[OpenCurlyDoubleQuote]sandwich_pert_soltuions.nb\
\[CloseCurlyDoubleQuote].  This variable is a list of substitutions \
containing the full algebraic form of all unknown functions, for example:\
\>", "Text",
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, 
   3.7488756773065567`*^9, {3.7498007551603394`*^9, 3.74980075664425*^9}, {
   3.7498030613705325`*^9, 3.7498030617298546`*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fz", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], "/.", 
  "fsolutionsquare"}]], "Input",
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, {3.748371437005432*^9, 3.74837143926686*^9}, {
   3.7488756737460823`*^9, 3.7488756748850346`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"k", " ", "z"}], 
      SuperscriptBox["g", "3"]]}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"k", " ", "z"}], 
     SuperscriptBox["g", "3"]]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "k"}], " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "3"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"k", " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "4"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.748244176965735*^9, 3.7482639273061953`*^9, 3.748264223572152*^9, 
   3.748264653298921*^9, 3.748265004576914*^9, 3.748265122915847*^9, {
   3.748265238444811*^9, 3.748265250327454*^9}, 3.748265448476235*^9, 
   3.748265624397996*^9, 3.748266735181037*^9, 3.7482674535155573`*^9, {
   3.748362839670229*^9, 3.748362842689076*^9}, 3.7483644465534697`*^9, 
   3.748364982272184*^9, 3.748367910277012*^9, 3.748368491240568*^9, 
   3.748368851953443*^9, 3.74836939562584*^9, 3.748370084581484*^9, 
   3.74837144551795*^9, 3.748875686335444*^9, 3.7488757772382245`*^9, 
   3.748875914415186*^9, 3.7488761268335075`*^9, 3.748878401328388*^9, 
   3.749075051194597*^9, 3.7498032657915525`*^9, 3.753734822072354*^9}]
}, Open  ]],

Cell["\<\
To verify these fields solve the bulk equations, we substitute them in, and \
then simplify the result using the second bespoke simplification function, \
ExpSimplify, which expresses the equations as a sum of Exponential components \
and then applies Simplify to the coefficient of each component.\
\>", "Text",
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
  3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
  3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
  3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
  3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
  3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
  3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
  3.74835877376761*^9, 3.748358840101597*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpSimplify", "[", 
  RowBox[{"BulkEquationSeries", "/.", "fsolutionsquare"}], "]"}]], "Input",
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, 3.7483591121969*^9, {3.748370966122116*^9, 
   3.748370969754299*^9}, 3.7488757830496707`*^9, 3.7498008776776786`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.748266449237129*^9, {3.748266746084798*^9, 3.748266753327408*^9}, 
   3.7482668404761057`*^9, 3.748266886592949*^9, 3.748266931748948*^9, 
   3.748269370234029*^9, 3.7482694147133293`*^9, 3.748269473584978*^9, 
   3.748357981253419*^9, 3.748358876699185*^9, 3.748359172776833*^9, 
   3.748362882992113*^9, 3.748364478461955*^9, 3.748365013812048*^9, 
   3.7483679425706673`*^9, 3.748368523080491*^9, 3.748368883587565*^9, 
   3.748369427481436*^9, 3.7483701167121353`*^9, 3.748879952007753*^9, 
   3.7490766399012156`*^9, 3.7498040512739897`*^9, 3.753736074685521*^9}]
}, Open  ]],

Cell["\<\
One can achieve the same result up to second order using the built in \
function Simplify, but this takes unreasonably long for the layer equations \
at third order. \
\>", "Text",
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
  3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
  3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
  3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
  3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
  3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
  3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
  3.74835877376761*^9, 3.748358840101597*^9}, {3.7483589228041067`*^9, 
  3.748358941540511*^9}, {3.748358982662092*^9, 3.748359022408444*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquationSeries", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
   "fsolutionsquare"}], "]"}]], "Input",
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, {3.748358950227021*^9, 3.748358988873667*^9}, 
   3.748359114064515*^9, 3.748875783939277*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.748266449237129*^9, {3.748266746084798*^9, 3.748266753327408*^9}, 
   3.7482668404761057`*^9, 3.748266886592949*^9, 3.748266931748948*^9, 
   3.748269370234029*^9, 3.7482694147133293`*^9, 3.748269473584978*^9, 
   3.748357981253419*^9, 3.748358876699185*^9, {3.748358966478747*^9, 
   3.748358990964706*^9}, 3.748359174735601*^9, 3.7483628926351757`*^9, 
   3.74836448043106*^9, 3.748365015780291*^9, 3.748367944583262*^9, 
   3.748368525087225*^9, 3.748368885573244*^9, 3.748369429491639*^9, 
   3.7483701187715797`*^9, 3.748875789748725*^9, 3.7488791713363953`*^9, 
   3.7490750779289474`*^9, 3.7498032779037647`*^9, 3.753736095083516*^9}]
}, Open  ]],

Cell[TextData[StyleBox["Validation the solution satisfies the boundary \
conditions", "Subsection"]], "Text",
 CellChangeTimes->{{3.748192982991539*^9, 3.748192988325735*^9}}],

Cell["\<\
The full solutions for the constants of integration (and L0, L1, L2) are \
computed in the separate notebook \
\[OpenCurlyDoubleQuote]sandwich_pert_square_constants\[CloseCurlyDoubleQuote] \
which we run here. This document actually computes the constants, so running \
it may take a few (~5) minutes.\
\>", "Text",
 CellChangeTimes->{{3.7482607612792273`*^9, 3.748260875123485*^9}, {
   3.7482657965084953`*^9, 3.7482657975804243`*^9}, 3.7489267313887115`*^9, {
   3.7498007773684397`*^9, 3.7498007787588825`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookEvaluate", "[", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<sandwich_pert_square_constants.nb\>\""}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.748158213150754*^9, 3.748158219797617*^9}, {
   3.7481941325489397`*^9, 3.748194136035887*^9}, 3.748195107133922*^9, {
   3.748195421557001*^9, 3.7481954825069237`*^9}, 3.748195517246182*^9, {
   3.74819562767171*^9, 3.748195632607148*^9}, {3.7481957842483664`*^9, 
   3.74819582426667*^9}, {3.748260846949068*^9, 3.748260849580188*^9}, 
   3.748364094167431*^9, {3.7488800350337224`*^9, 3.748880037010333*^9}, {
   3.749133315427784*^9, 3.7491333171900663`*^9}}],

Cell["\<\
After running  \[OpenCurlyDoubleQuote]pert_square_constants\
\[CloseCurlyDoubleQuote], the algebraic forms for the constants are stored in \
the three variables, FirstOrderConstantsStripe, SecondOrderConstantsStripe \
and ThirdOrderConstantsStripe. For example:\
\>", "Text",
 CellChangeTimes->{{3.7482608804202003`*^9, 3.748260931153734*^9}, {
   3.748260970268648*^9, 3.748260985377118*^9}, 3.7489267374810243`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{"1", ",", "1"}], "]"}], "/.", 
  "FirstOrderConstantsSquare"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, {3.748880039961472*^9, 
   3.7488800413676753`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     FractionBox["k", 
      RowBox[{"2", " ", 
       SuperscriptBox["g", "3"]}]]], " ", 
    SuperscriptBox["g", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "11"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "14"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "17"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "g", " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "4"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "7"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "10"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "13"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "9"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["\[Mu]2", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["g", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"k", "+", 
               FractionBox["k", 
                SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
          SuperscriptBox["\[Mu]1", "3"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
          SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "11"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "14"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "17"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "20"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", "g", " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"k", "+", 
       FractionBox["k", 
        SuperscriptBox["g", "3"]]}]], " ", 
     SuperscriptBox["g", "7"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "10"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "k"}]]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            FractionBox["1", 
             SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", "k"}], 
          SuperscriptBox["g", "3"]]]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"k", "+", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
     SuperscriptBox["g", "13"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"12", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "9"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "12"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"k", "+", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
     SuperscriptBox["g", "5"], " ", 
     SuperscriptBox["\[Mu]2", "3"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "8"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.748260951225204*^9, 3.748363017860961*^9, 
  3.74836452913402*^9, 3.748365064394639*^9, 3.7483663728484793`*^9, 
  3.748367993301462*^9, 3.748368573734091*^9, 3.748368934061269*^9, 
  3.748369478943746*^9, 3.748370167978312*^9, 3.748880175250072*^9, 
  3.7488957472057123`*^9, 3.748926738871154*^9, 3.7489482323073754`*^9, 
  3.749129014269312*^9, 3.7491332789882994`*^9, 3.7491393886782494`*^9, 
  3.7498059162865677`*^9, 3.75373646673251*^9}],

Cell["", "Text",
 CellChangeTimes->{{3.749805910225495*^9, 3.749805910225495*^9}}],

Cell["\<\
The second order constants are in terms of the first order ones, and the \
third order constants are in terms of the first and second order ones:\
\>", "Text",
 CellChangeTimes->{{3.7482610014395227`*^9, 3.748261036909691*^9}}],

Cell["\<\
Mathematica is not able to validate that these solutions solve the boundary \
conditions in a reasonable amount of time, so we instead conduct this \
validation numerically at a high-precision numerical test point: \
\>", "Text",
 CellChangeTimes->{{3.7482610837996073`*^9, 3.7482611632713633`*^9}}],

Cell[BoxData[
 RowBox[{"TestPoint", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]1", "\[Rule]", " ", "3"}], ",", 
      RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", "  ", 
      RowBox[{"g", "\[Rule]", " ", "1.4"}], ",", " ", 
      RowBox[{"k", "\[Rule]", " ", "5"}], ",", " ", 
      RowBox[{"z0", "\[Rule]", 
       RowBox[{"-", "0.5"}]}], ",", 
      RowBox[{"z1", "\[Rule]", "0.5"}]}], "}"}], ",", "50"}], 
   "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.748367111887246*^9, 3.7483671121796923`*^9}, {3.7491431641222205`*^9, 
   3.749143169959608*^9}, 3.749147475754054*^9, 3.7491523638240366`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]1", "\[Rule]", "3.`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1.`50."}], ",", 
   RowBox[{
   "g", "\[Rule]", 
    "1.399999999999999911182158029987476766109466552734375`50."}], ",", 
   RowBox[{"k", "\[Rule]", "5.`50."}], ",", 
   RowBox[{"z0", "\[Rule]", 
    RowBox[{"-", "0.5`50."}]}], ",", 
   RowBox[{"z1", "\[Rule]", "0.5`50."}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.74835928266391*^9, 3.7483630202645607`*^9, 3.7483640992877703`*^9, 
   3.748364529203432*^9, 3.7483650644576797`*^9, 3.748366375786837*^9, 
   3.7483670795186777`*^9, 3.748367112856585*^9, 3.748367993387788*^9, 
   3.748368573802745*^9, 3.748368934137578*^9, 3.7483694790276117`*^9, 
   3.748370168053019*^9, 3.7488957473255997`*^9, 3.7489262017479563`*^9, 
   3.7491290143421125`*^9, 3.7491427336571693`*^9, 3.749143415294032*^9, {
   3.749147472828844*^9, 3.74914747595652*^9}, 3.749151767894739*^9, 
   3.749152571119811*^9, 3.7492761309312096`*^9, 3.7492795529351807`*^9, 
   3.7498059304434295`*^9, 3.7498072723241916`*^9, 3.7537364668312497`*^9}],

Cell["\<\
At this TestPoint, we can numerically evaluate the constants at high \
precision, and we store these numerical constants in the variable \
\[OpenCurlyDoubleQuote]NumericalConstants\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellChangeTimes->{{3.748261177554925*^9, 3.748261244832778*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericalConstants", "[", 
   RowBox[{
    RowBox[{"\[Mu]1value_", "?", "NumericQ"}], ",", 
    RowBox[{"\[Mu]2value_", "?", "NumericQ"}], ",", 
    RowBox[{"gvalue_", "?", "NumericQ"}], ",", 
    RowBox[{"kvalue_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TestPoint", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Mu]1value"}], ",", 
          RowBox[{"\[Mu]2", "\[Rule]", " ", "\[Mu]2value"}], ",", " ", 
          RowBox[{"g", "\[Rule]", " ", "gvalue"}], ",", " ", 
          RowBox[{"k", "\[Rule]", " ", "kvalue"}], ",", " ", 
          RowBox[{"z0", "\[Rule]", " ", 
           RowBox[{"-", "0.5"}]}], ",", " ", 
          RowBox[{"z1", "\[Rule]", "0.5"}]}], "}"}], ",", "50"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"NFirstOrderConstantsSquare", "=", 
      RowBox[{"FirstOrderConstantsSquare", "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"NSecondOrderConstantsSquare", "=", 
      RowBox[{
       RowBox[{
       "SecondOrderConstantsSquare", "/.", "NFirstOrderConstantsSquare"}], "/.",
        "TestPoint"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NThirdOrderConstantsSquare", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
        "ThirdOrderConstantsSquare", "/.", "NSecondOrderConstantsSquare"}], "/.",
         "NFirstOrderConstantsSquare"}], "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "NFirstOrderConstantsSquare", ",", "NSecondOrderConstantsSquare", ",", 
        "NThirdOrderConstantsSquare"}], "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.748367299348639*^9, 
   3.748367402015232*^9}, {3.7483674432132998`*^9, 3.748367507170247*^9}, {
   3.74836755223973*^9, 3.7483675528233423`*^9}, {3.748367651745777*^9, 
   3.7483676532854013`*^9}, {3.748367722421383*^9, 3.748367724938448*^9}, {
   3.7483678628756857`*^9, 3.748367874455339*^9}, {3.7483679329955873`*^9, 
   3.748367942772023*^9}, {3.7488946343134184`*^9, 3.74889466555879*^9}, {
   3.749145124656499*^9, 3.7491451297606974`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["For example:", "Text",
 CellChangeTimes->{{3.7482612779840107`*^9, 3.748261279483727*^9}}],

Cell[BoxData[
 RowBox[{"L2", "/.", 
  RowBox[{"NumericalConstants", "[", 
   RowBox[{"3", ",", "1", ",", "1.4", ",", "5"}], "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["576.7641616910895990910907758804902213016066945931228007953142`\
38.29990424587918"], "Output",
 CellChangeTimes->{
  3.748261268192404*^9, {3.74826130444674*^9, 3.7482613107879143`*^9}, {
   3.748359350121023*^9, 3.7483593582974463`*^9}, {3.748363025924615*^9, 
   3.748363029546698*^9}, 3.748364531154643*^9, 3.7483650662788057`*^9, 
   3.748366380080958*^9, 3.748367709560692*^9, 3.748368005189967*^9, 
   3.748368575584404*^9, 3.7483689360378933`*^9, 3.748369481065188*^9, 
   3.7483701698933897`*^9, 3.7488957476257963`*^9, 3.748926259474595*^9, 
   3.7491290750735893`*^9, 3.749142797472472*^9, 3.749143473603422*^9, 
   3.7491436514976053`*^9, 3.7491453004346104`*^9, 3.7491456260524707`*^9, 
   3.74915186312341*^9, 3.749276666423085*^9, 3.7498059992218533`*^9, 
   3.75373651020183*^9}],

Cell["\<\
Finally, we expand the boundary conditions to third order in epsilon, \
substitute in the fields and the constants and evaluate at the test point, to \
show that they are satisfied up to machine precision, with the help of \
TrigSimplify to speed up the calculation. The Chop command rounds numbers \
smaller than 10^-30 to zero.\
\>", "Text",
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
  3.748261408839826*^9, 3.748261423343892*^9}, {3.748367234219556*^9, 
  3.748367248653973*^9}, {3.7498218866113963`*^9, 3.7498219017641096`*^9}}],

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"TrigSimplify", "[", 
        RowBox[{"Series", "[", 
         RowBox[{"BoundaryConditions", ",", 
          RowBox[{"{", 
           RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}], 
        "]"}], "/.", "fsolutionsquare"}], "/.", 
      RowBox[{"NumericalConstants", "[", 
       RowBox[{"3", ",", "1", ",", "1.4", ",", "5"}], "]"}]}], "/.", 
     "TestPoint"}], "]"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "30"}]}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.7483671689589977`*^9, 3.7483671715347033`*^9}, {
   3.748367220011492*^9, 3.7483672221377087`*^9}, {3.7483675709932613`*^9, 
   3.7483675787994757`*^9}, {3.748894675042685*^9, 3.748894678378644*^9}, {
   3.748926879104168*^9, 3.74892688306077*^9}, {3.7489270397551355`*^9, 
   3.748927052007228*^9}, {3.7489272447088623`*^9, 3.7489272486268377`*^9}, {
   3.749385357678149*^9, 3.749385362900453*^9}, {3.749385398808679*^9, 
   3.7493854012622805`*^9}, 3.7498008033232307`*^9, {3.7498066193692627`*^9, 
   3.749806622399841*^9}, {3.7498218815657196`*^9, 3.749821884377558*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.7483630651882343`*^9, 3.7483631806408167`*^9, 3.748363276704946*^9, 
   3.748364111234914*^9, 3.7483645363752213`*^9, 3.748365071665619*^9, 
   3.7483663906728697`*^9, 3.748367125524706*^9, 3.748367178003598*^9, {
   3.748367229036347*^9, 3.748367257146784*^9}, 3.748367587353529*^9, 
   3.748367673543158*^9, 3.748368015570116*^9, 3.748368582708802*^9, 
   3.748368943984146*^9, 3.748369488756003*^9, 3.748370177207624*^9, 
   3.7487623367849684`*^9, 3.7487821767642107`*^9, 3.7491131469926033`*^9, 
   3.7491132777056026`*^9, 3.749807396971636*^9, 3.753736631780857*^9}],

Cell["\<\
The user is invited to validate the boundary conditions at alternative \
test-points by modifying \[OpenCurlyDoubleQuote]TestPoint\
\[CloseCurlyDoubleQuote] above.\
\>", "Text",
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
  3.748261408839826*^9, 3.7482614927761793`*^9}}],

Cell[TextData[StyleBox["Thickness integration", "Subsection"]], "Text",
 CellChangeTimes->{{3.748262074419416*^9, 3.74826208137881*^9}}],

Cell["\<\
We next integrate the averaged energies over thickness to find the energy \
coefficients as defined in the paper: We must assume the real part of k>0, \
otherwise the elastic solutions diverge in the substrate and superstrate. \
This calculation may take several minutes.\
\>", "Text",
 CellChangeTimes->{{3.7482620881141*^9, 3.748262101954483*^9}, {
  3.748363346970169*^9, 3.748363359624626*^9}, {3.748365214909356*^9, 
  3.748365240840098*^9}, {3.74836617852466*^9, 3.748366185813534*^9}, {
  3.7498007882253*^9, 3.749800795279854*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"E1", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1Sav", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}], ",", " ", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1S2av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E2", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2Sav", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}], ",", " ", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2S2av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E3", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3Sav", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}], ",", " ", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3S2av", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E4", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W4Sav", "/.", "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ExpSimplify", "[", 
        RowBox[{"W4av", "/.", "fsolutionsquare"}], "]"}], "/.", 
       "fsolutionsquare"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", " ", "1"}], "/", "2"}], ",", " ", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"+", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"W4S2av", "/.", "fsolutionsquare"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", " ", 
       RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748262113533332*^9, 3.748262252817123*^9}, {3.748262305237101*^9, 
   3.748262310340988*^9}, {3.748262365269137*^9, 3.7482623722651787`*^9}, {
   3.7483633671292267`*^9, 3.748363383150691*^9}, {3.7483635959244337`*^9, 
   3.7483636870930433`*^9}, {3.748364333478301*^9, 3.748364334039871*^9}, {
   3.748365181454217*^9, 3.748365190982555*^9}, {3.748366111342016*^9, 
   3.7483661577719717`*^9}, {3.748782161964778*^9, 3.7487821767642107`*^9}, {
   3.749023083142062*^9, 3.7490231412630105`*^9}, {3.7490240220227356`*^9, 
   3.749024025859057*^9}, {3.749024350552248*^9, 3.7490243642531223`*^9}, {
   3.7490245082154903`*^9, 3.749024522484132*^9}, {3.74913200799305*^9, 
   3.7491320154391665`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 TemplateBox[{
  "Simplify","time",
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"",2,120,1,31106511516940694969,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.753737137514592*^9}],

Cell[BoxData[
 TemplateBox[{
  "Simplify","time",
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"",2,120,2,31106511516940694969,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.753737453826532*^9}],

Cell[TextData[StyleBox["Threshold for instability", "Subsection"]], "Text",
 CellChangeTimes->{{3.74836666158285*^9, 3.748366669568527*^9}}],

Cell["\<\
Instability occurs spontaneously at the point where L0=0, which corresponds \
to the following conditions:\
\>", "Text",
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366714346525*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"ExpToTrig", "[", 
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"L0", "/.", "FirstOrderConstantsSquare"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", " ", 
        RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Eta]"}]}], "}"}]}], "]"}], "]"}],
    "\[Equal]", "0"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, 
   3.748894684236082*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"k", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["g", "6"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}]}], ")"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["g", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["g", "4"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "12"]}]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"g", "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["g", "7"]}]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "3"], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"g", "-", 
              SuperscriptBox["g", "7"]}], ")"}], "2"], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["g", "6"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["g", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["g", "6"]}], ")"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"13", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                SuperscriptBox["g", "18"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                RowBox[{"20", " ", 
                 SuperscriptBox["g", "18"]}], "+", 
                SuperscriptBox["g", "24"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "g", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               SuperscriptBox["g", "4"]}], "+", 
              SuperscriptBox["\[Eta]", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["g", "12"], " ", 
               SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["g", "6"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             SuperscriptBox["g", "6"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{
  3.748366436722287*^9, {3.74836648564769*^9, 3.7483665065569477`*^9}, {
   3.748366542145163*^9, 3.748366610605278*^9}, 3.74836672545654*^9, 
   3.748368724221715*^9, 3.7483690947625504`*^9, 3.748369632442429*^9, 
   3.7483703251075907`*^9, 3.7489488873093524`*^9, 3.749132749419948*^9, 
   3.7491331263308525`*^9, 3.749143415247157*^9, 3.7491438049232106`*^9, 
   3.7491525185987577`*^9, 3.749807436931003*^9, 3.753737829753862*^9}],

Cell["\<\
This equation does not have an analytic solution, but can be solved \
numerically for g* at any value of k and \[Eta]. We have written a helper \
function CharacterizeInstabilitySandwich[\[Eta]] which finds numerically (but \
at high precision) the k* and g* for the first point of instability at a \
given value of \[Eta].\
\>", "Text",
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
  3.748366907912177*^9, 3.748366914683483*^9}, {3.7498008387440863`*^9, 
  3.7498008395878105`*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366863463852*^9, 3.7483668668954573`*^9}, {3.7491330461762104`*^9, 
   3.7491330485359*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "g", "\[Rule]", 
    "1.24800619978443093404446326403077289245806686892119996464142355403003738\
290813`50."}], ",", 
   RowBox[{
   "k", "\[Rule]", 
    "1.40271633944241459594362210259135548632004523108779084003855628224143148\
358653`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1"}], ",", 
   RowBox[{"\[Mu]1", "\[Rule]", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{3.748366867457121*^9, 3.748368041616961*^9, 
  3.748368103648972*^9, 3.748368724340021*^9, 3.748369094895968*^9, 
  3.748369632567338*^9, 3.7483703252332773`*^9, 3.7489488874779015`*^9, 
  3.749132749537633*^9, 3.749133104497218*^9, 3.7491525187171984`*^9, 
  3.753737829983247*^9}],

Cell["\<\
We can validate that this point does indeed correspond to L0=0.\
\>", "Text",
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
  3.748366907912177*^9, 3.748366939643381*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"L0", "/.", "FirstOrderConstantsSquare"}], "/.", 
   RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366880429227*^9, 3.748366892535075*^9}, 3.748894688085436*^9, {
   3.7491330530079384`*^9, 3.749133055133254*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``46.75828514393407"], "Output",
 CellChangeTimes->{3.7483668935893517`*^9, 3.748367745014412*^9, 
  3.74836810758436*^9, 3.748368724399867*^9, 3.7483690949662523`*^9, 
  3.748369632630701*^9, 3.748370325296257*^9, 3.7489488876205215`*^9, 
  3.7491327496513295`*^9, 3.7491331264395313`*^9, 3.7491332413110824`*^9, 
  3.7491525188464828`*^9, 3.7537378300670204`*^9}],

Cell["\<\
As does the energy coefficient E2, which we expect to have the form E2= \
C2(g-g*)\
\>", "Text",
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
  3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
  3.748368290906556*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"E2", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, 3.748948903459873*^9, {3.7491330225663605`*^9, 
   3.749133024324664*^9}, 3.7491330566003304`*^9, 3.7491330989480896`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``45.07226733734072"], "Output",
 CellChangeTimes->{3.748367792808538*^9, 3.7483681144553337`*^9, 
  3.748368250036015*^9, 3.74836872621726*^9, 3.748369097275526*^9, 
  3.748369634536525*^9, 3.748370327151268*^9, 3.748948978243323*^9, 
  3.7491328106491776`*^9, 3.749133087920557*^9, 3.749152560002432*^9, 
  3.7537378712857676`*^9}],

Cell["\<\
We can evaluate C2 as the derivative of E2 with respect to g:\
\>", "Text",
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
  3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
  3.748368313602594*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"E2", "/.", "FirstOrderConstantsSquare"}], ",", "g"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, 
   3.748894692333063*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["\<\
And then we plot C2 as a function of \[Eta], reproducing fig 12E in the main \
paper.\
\>", "Text",
 CellChangeTimes->{
  3.74836847884299*^9, {3.748368538294593*^9, 3.748368559647304*^9}, {
   3.7498008469766836`*^9, 3.749800848351364*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"C2", "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0"}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370373648697*^9, 3.74837039644267*^9}, {3.749133038554614*^9, 
   3.7491330642159595`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEP7E1eRqq8lDc7AOF/sG+7ULk+9q0plP/D/pfz
CQF7Lpg8g8O/abqrprrC+CwOp5MZ7yX3wfgcDjKl+4WC78L4PA4s4mo3z+iZ
Q/kCDpGuL6LeNsD4Qg6HpI6HrLoE44s4FO/qyMhTtoDyxRzWRxX7PiuC8SUc
vNLVa58egPGlHNLmvDwcxmsJ5cs4pH7+pG8cAePLOUycLDylZiGMr+DA9uyC
vNVLGF/Rgc8kyqJM3wrKV3LY79MnblsC4ys7KGz9+Xz2dhhfxeHdLTnDBT+t
DgAAr9ZZIw==
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEH9iYvI1VeypsdgPA/2LddqFwf+9YUyv9h
/8v5hIA9F0yeweHfNN1VU11hfBaH08mM95L7YHwOB5nS/ULBd2F8HgcWcbWb
Z/TMoXwBh0jXF1FvG2B8IYdDUsdDVl2C8UUcind1ZOQpW0D5Yg7ro4p9nxXB
+BIOXunqtU8PwPhSDmlzXh4O47WE8mUcUj9/0jeOgPHlHCZOFp5SsxDGV3Bg
e3ZB3uoljK/owGcSZVGmbwXlKzns9+kTty2B8ZUdFLb+fD57O4yv4vDulpzh
gp9WBwC5blkl
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {-30, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.7483703782010193`*^9, 3.748370399121915*^9}, 
   3.74895199561522*^9, 3.7491527748276863`*^9, 3.75373787506423*^9}],

Cell["Similarly, C4 is obtained from E4", "Text",
 CellChangeTimes->{{3.7497999806814003`*^9, 3.74980000494288*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"E4", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.74836912905235*^9, 
   3.748369233216261*^9}, {3.748369783872941*^9, 3.7483697918810062`*^9}, 
   3.7489489047118587`*^9, 3.749133059666129*^9, 3.749276662062222*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["5.9344375445619633147608057894143611809252447185290246952515`37.\
012708006656695"], "Output",
 CellChangeTimes->{3.74836979419419*^9, 3.748370329112509*^9, 
  3.7489490581680627`*^9, 3.749132871038653*^9, 3.7491527275836167`*^9, 
  3.7492771650535345`*^9, 3.7498074675175886`*^9, 3.749808550408179*^9, 
  3.7537379159676304`*^9}],

Cell["which is plotted against \[Eta] as in Fig. 12F", "Text",
 CellChangeTimes->{{3.7498000090825334`*^9, 3.749800035011475*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{
         RowBox[{"E4", "/.", 
          RowBox[{"NumericalConstants", "[", 
           RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}]}], "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], "//", "Quiet"}]], "Input",\

 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370140467683*^9, 3.7483701573194733`*^9}, {3.748370381950783*^9, 
   3.748370387159823*^9}, 3.748370435122093*^9, {3.748370487533835*^9, 
   3.748370487814623*^9}, {3.748370591923375*^9, 3.7483705922499657`*^9}, {
   3.74837067792865*^9, 3.7483706781197844`*^9}, 3.7491330673475833`*^9, {
   3.749152773972011*^9, 3.7491527869173703`*^9}, {3.7492756207121077`*^9, 
   3.7492756223681374`*^9}, 3.7492793244239545`*^9, 3.7492837977836423`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQfSVE8bqU/lv7LkUPKZtsXQcGMPhgb3N9b64SnxaU
/8NeUD0qO8lcGcpncFjrPMmvzVkeymdxaFkdOKn2rBSUz+EQaihhdHePOJTP
4xAjavB+Wa0olC/gcOrpJBHZI8JQvpBDinR8ZkiqEJQv4lAn22Ml7S4I5Ys5
JH2wl2yLEIDyJRxk5s/Z5ivDD+VLOWwuDd3+bT8vlC/jEKZ2N6JsAg+UL+dg
y7s93rqVG8pXcOhsOZ50cjoXlK/ooNJRkyV/mBPKV3IoYF5zOoAZxld2+P3O
mtkulAPKV3HgN/vVmbSN3QEA0HJHWg==
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEP9jbX9+Yq8Wk5QPg/7AXVo7KTzJWhfAaH
tc6T/Nqc5aF8FoeW1YGTas9KQfkcDqGGEkZ394hD+TwOMaIG75fVikL5Ag6n
nk4SkT0iDOULOaRIx2eGpApB+SIOdbI9VtLuglC+mEPSB3vJtggBKF/CQWb+
nG2+MvxQvpTD5tLQ7d/280L5Mg5hancjyibwQPlyDra82+OtW7mhfAWHzpbj
SSenc0H5ig4qHTVZ8oc5oXwlhwLmNacDmGF8ZYff76yZ7UI5oHwVB36zX51J
29gdroQoXpfSf2vfpeghZZOt6wAAD+xHXA==
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {0, 14.709442921929412`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.748370389382762*^9, 3.748370474513866*^9, 
  3.748370566448998*^9, 3.7483707482518463`*^9, 3.748951991480588*^9, 
  3.749153632445697*^9, 3.749283768015274*^9, 3.7498092050666122`*^9, 
  3.7537386533760834`*^9}],

Cell[TextData[StyleBox["", "Input"]], "Text",
 CellChangeTimes->{
  3.7483686588823566`*^9, {3.748368690681077*^9, 3.7483686934219017`*^9}, {
   3.748370078389737*^9, 3.748370128283454*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Hexagonal pattern", "Section"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.748782196939209*^9}],

Cell["Displacement fields", "Subsubsection",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.734858096251944*^9, 3.734858108803898*^9}, 
   3.748782196940205*^9},
 TextAlignment->Left,
 ExpressionUUID -> "1b3bfbbc-60b3-4b40-9a2f-a856d7813b9c"],

Cell["\<\
As discussed in the main paper, the form of u(x,y,z) for the hexagonal \
pattern in the thin slab is expected to be of the form:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7161206305567656`*^9, 3.716120654414336*^9}, {
   3.719825444630498*^9, 3.7198254490843143`*^9}, {3.7343365435634594`*^9, 
   3.7343365530569415`*^9}, {3.7481926611831303`*^9, 
   3.7481926774792223`*^9}, {3.7482452333005257`*^9, 3.748245235635438*^9}, 
   3.748782196940205*^9},
 ExpressionUUID -> "f5a52526-2b6d-407b-9f04-21d090a88149"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uz", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CurlyEpsilon]", " ", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"k", " ", "x"}], "]"}], "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"k", " ", "x1"}], "]"}], "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], 
      SqrtBox["3"]], " ", 
     RowBox[{
      RowBox[{"fz", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x1"}], "+", 
            RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"2", ",", "4"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"fz", "[", 
         RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"3", " ", "k", " ", "x"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"3", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"3", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x1"}], "+", 
            RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "5"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "+", 
            RowBox[{"2", " ", "k", " ", "x1"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "6"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "7"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x1"}], "+", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"k", " ", "x1"}], "+", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fz", "[", 
          RowBox[{"3", ",", "8"}], "]"}], "[", "z", "]"}]}]}], ")"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", " ", 
      RowBox[{
       FractionBox["x", "2"], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["x", "2"]}], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}]}], "}"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748780010470646*^9, 3.7487800120527086`*^9}, {3.748781914084138*^9, 
   3.748781914297538*^9}, {3.7487819459333086`*^9, 3.7487819481186695`*^9}, 
   3.748782196940205*^9, {3.748788268565628*^9, 3.748788279497382*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ux", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CurlyEpsilon]", " ", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"k", " ", "x"}], "]"}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"k", " ", "x1"}], "]"}], "-", 
           RowBox[{"Sin", "[", 
            RowBox[{"k", " ", "x2"}], "]"}]}], ")"}]}]}], ")"}], 
      SqrtBox["3"]], " ", 
     RowBox[{
      RowBox[{"fx", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", " ", "k", " ", "x"}], "]"}]}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"k", " ", "x"}], "]"}]}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x1"}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "+", 
             RowBox[{"k", " ", "x1"}]}], "]"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "-", 
             RowBox[{"k", " ", "x2"}]}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"3", " ", "k", " ", "x"}], "]"}], "+", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"3", " ", "k", " ", "x1"}], "]"}], "-", 
             RowBox[{"Sin", "[", 
              RowBox[{"3", " ", "k", " ", "x2"}], "]"}]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", " ", "k", " ", "x"}], "]"}]}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x"}], "]"}], "+", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"k", " ", "x1"}], "]"}], "-", 
             RowBox[{"Sin", "[", 
              RowBox[{"k", " ", "x2"}], "]"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "+", 
             RowBox[{"k", " ", "x1"}]}], "]"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "-", 
             RowBox[{"k", " ", "x2"}]}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x"}], "+", 
             RowBox[{"2", " ", "k", " ", "x1"}]}], "]"}]}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "4"]}], " ", 
           RowBox[{
            RowBox[{"fx", "[", 
             RowBox[{"3", ",", "5"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           SqrtBox["3"], " ", 
           RowBox[{
            RowBox[{"fx", "[", 
             RowBox[{"3", ",", "8"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], 
       "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{
            RowBox[{"fx", "[", 
             RowBox[{"3", ",", "6"}], "]"}], "[", "z", "]"}]}], "-", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           SqrtBox["3"], " ", 
           RowBox[{
            RowBox[{"fx", "[", 
             RowBox[{"3", ",", "9"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], 
       "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x1"}], "+", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x1"}], "+", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"fx", "[", 
            RowBox[{"3", ",", "7"}], "]"}], "[", "z", "]"}], "-", 
          RowBox[{"3", " ", 
           SqrtBox["3"], " ", 
           RowBox[{
            RowBox[{"fx", "[", 
             RowBox[{"3", ",", "10"}], "]"}], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", " ", 
      RowBox[{
       FractionBox["x", "2"], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["x", "2"]}], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}]}], "}"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.665774263326209*^9, 3.66577427385541*^9}, {
   3.6657743236327744`*^9, 3.665774371967226*^9}, {3.665774467469146*^9, 
   3.6657745171664667`*^9}, {3.6657746780929537`*^9, 
   3.6657747272032385`*^9}, {3.6657757781517873`*^9, 3.665775808017256*^9}, 
   3.6657759580813837`*^9, 3.6657760065598683`*^9, 3.6658296584374185`*^9, 
   3.6660107266892014`*^9, 3.666012204886698*^9, {3.666012513519569*^9, 
   3.6660125247351093`*^9}, {3.66601278685109*^9, 3.666012806026108*^9}, {
   3.666012972519032*^9, 3.666012979006877*^9}, {3.666013887366681*^9, 
   3.666013928053396*^9}, 3.666013989868081*^9, {3.6660147320221443`*^9, 
   3.666014756277513*^9}, {3.666014819652697*^9, 3.6660148425158243`*^9}, {
   3.666015002745376*^9, 3.666015011136634*^9}, 3.666015703700157*^9, 
   3.666015744531355*^9, 3.667246053897068*^9, {3.6672461691966453`*^9, 
   3.6672461754305334`*^9}, {3.705818060293044*^9, 3.7058180743009596`*^9}, {
   3.705818289204507*^9, 3.705818297352764*^9}, {3.705818346823226*^9, 
   3.705818381764964*^9}, 3.7058184518271837`*^9, {3.705819379045109*^9, 
   3.7058193899392233`*^9}, {3.716120693874295*^9, 3.716120694038066*^9}, 
   3.71612103748448*^9, {3.71666379795361*^9, 3.7166638046447215`*^9}, 
   3.7345160870401254`*^9, {3.7347802139114037`*^9, 3.734780215949613*^9}, 
   3.7482440160956907`*^9, 3.748245155719054*^9, 3.748245198121097*^9, {
   3.748780017585449*^9, 3.748780022184403*^9}, {3.7487819283017635`*^9, 
   3.748781939897328*^9}, 3.748782196940205*^9, {3.748788283472746*^9, 
   3.748788288882307*^9}},
 ExpressionUUID -> "40dad8a7-b736-4d12-af4b-30060025e83a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uy", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "  ", "\[CurlyEpsilon]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x1"}], "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
     RowBox[{
      RowBox[{"fx", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", 
            RowBox[{"(", 
             RowBox[{"x", "+", "x1"}], ")"}]}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", 
            RowBox[{"(", 
             RowBox[{"x", "-", "x2"}], ")"}]}], "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"k", " ", 
             RowBox[{"(", 
              RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"3", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"3", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x1"}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"k", " ", "x1"}], "+", 
             RowBox[{"k", " ", "x2"}]}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "+", 
            RowBox[{"2", " ", "k", " ", "x1"}]}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x"}], "-", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "8"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "+", 
            RowBox[{"k", " ", "x1"}]}], "]"}], "-", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x"}], "-", 
            RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "9"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"2", " ", "k", " ", "x1"}], "+", 
            RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"k", " ", "x1"}], "+", 
            RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
        RowBox[{
         RowBox[{"fx", "[", 
          RowBox[{"3", ",", "10"}], "]"}], "[", "z", "]"}]}]}], ")"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", " ", 
      RowBox[{
       FractionBox["x", "2"], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["x", "2"]}], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}]}], "}"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657759391218367`*^9, 3.665776057713159*^9}, 
   3.6658296584379063`*^9, 3.6660107291851473`*^9, 3.666012209694578*^9, {
   3.666012528999206*^9, 3.666012537142894*^9}, {3.666012999870729*^9, 
   3.666013019358135*^9}, {3.666013072317521*^9, 3.666013074029131*^9}, {
   3.6660131551716967`*^9, 3.6660131691793137`*^9}, {3.6660139204933443`*^9, 
   3.666013926621202*^9}, 3.666013992463925*^9, {3.6660147384939632`*^9, 
   3.666014757597476*^9}, {3.666014822508614*^9, 3.6660148479637136`*^9}, {
   3.6660150080811462`*^9, 3.666015018784547*^9}, {3.666015633085493*^9, 
   3.666015653788924*^9}, 3.666015704827859*^9, 3.666015746131331*^9, 
   3.6672460553753724`*^9, 3.66724612564708*^9, {3.7161206968910065`*^9, 
   3.7161206970825825`*^9}, {3.7482451738278837`*^9, 3.748245196360682*^9}, 
   3.7487800522733364`*^9, {3.7487819218896985`*^9, 3.74878195810406*^9}, 
   3.748782196940205*^9, {3.74878829251655*^9, 3.7487882992335787`*^9}},
 ExpressionUUID -> "37011bf4-9d75-4895-8b92-c683ff6c780b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["g", "4"], " ", "\[Mu]1"}], "+", 
    RowBox[{"\[Mu]1", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CurlyEpsilon]", " ", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x1"}], "]"}], "+", 
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], 
         SqrtBox["3"]], " ", 
        RowBox[{
         RowBox[{"fp", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[CurlyEpsilon]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"fp", "[", 
            RowBox[{"2", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"2", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x1"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"2", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "+", 
               RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "-", 
               RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x1"}], "+", 
               RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"2", ",", "4"}], "]"}], "[", "z", "]"}]}]}], ")"}]}], 
       "+", 
       RowBox[{
        SuperscriptBox["\[CurlyEpsilon]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"fp", "[", 
            RowBox[{"3", ",", "1"}], "]"}], "[", "z", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"3", " ", "k", " ", "x"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"3", " ", "k", " ", "x1"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"3", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "2"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x1"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "k", " ", "x2"}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "3"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x1"}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "x2"}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "4"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "+", 
               RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "-", 
               RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x1"}], "+", 
               RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "5"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "+", 
               RowBox[{"2", " ", "k", " ", "x1"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x"}], "-", 
               RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "6"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"2", " ", "k", " ", "x"}], "+", 
               RowBox[{"k", " ", "x1"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"2", " ", "k", " ", "x"}], "-", 
               RowBox[{"k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "7"}], "]"}], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"2", " ", "k", " ", "x1"}], "+", 
               RowBox[{"k", " ", "x2"}]}], "]"}], "+", 
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"k", " ", "x1"}], "+", 
               RowBox[{"2", " ", "k", " ", "x2"}]}], "]"}]}], ")"}], " ", 
           RowBox[{
            RowBox[{"fp", "[", 
             RowBox[{"3", ",", "8"}], "]"}], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", " ", 
      RowBox[{
       FractionBox["x", "2"], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["x", "2"]}], "+", 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], "y"}]}]}]}], "}"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657760820092983`*^9, 3.6657761051983843`*^9}, {
   3.665829557920424*^9, 3.665829559173556*^9}, 3.6658296584379063`*^9, 
   3.667246058975377*^9, {3.6672461347851114`*^9, 3.667246155584901*^9}, 
   3.669693515772377*^9, {3.705227845845664*^9, 3.7052278461045*^9}, {
   3.705227934870659*^9, 3.7052279383910027`*^9}, {3.7052299167648897`*^9, 
   3.705229970446568*^9}, {3.7052300261184797`*^9, 3.705230027175839*^9}, {
   3.705230071958618*^9, 3.705230077742556*^9}, {3.7058180782087336`*^9, 
   3.7058180848812704`*^9}, {3.7058183287173777`*^9, 3.705818340355358*^9}, 
   3.705818454586179*^9, {3.7059142877117147`*^9, 3.705914289123722*^9}, {
   3.716120699703617*^9, 3.71612069985559*^9}, {3.716120863888893*^9, 
   3.7161208688602057`*^9}, 3.7161210488972373`*^9, 3.7343363526051474`*^9, 
   3.734516089009384*^9, 3.748244029781723*^9, {3.748245189881262*^9, 
   3.7482451950327*^9}, {3.7487800573993645`*^9, 3.7487800586059318`*^9}, {
   3.748781925458317*^9, 3.748781926098612*^9}, {3.748781962793226*^9, 
   3.7487819658968544`*^9}, 3.748782196940205*^9, {3.748784720802705*^9, 
   3.7487847368591604`*^9}, {3.7487883096726694`*^9, 3.748788313863471*^9}},
 ExpressionUUID -> "cd99ff87-ca37-49e1-8b73-9d2f02158237"]
}, Open  ]],

Cell[CellGroupData[{

Cell["and in the substrate and superstrate", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.7343365589552717`*^9, 3.7343365626007757`*^9}, 
   3.7487821767601943`*^9, {3.7490228226148396`*^9, 3.749022825130707*^9}, 
   3.749225250915362*^9},
 ExpressionUUID -> "ceb842ef-d180-4cf0-a344-86b9f7dc9cc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, 
   3.749225250915362*^9},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}, 3.749225250915362*^9},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, 
   3.749225250915362*^9},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SubstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}, 3.749225250915362*^9},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uxS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"ux", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653378489608873*^9, 3.6533785312774076`*^9}, {
   3.653378984925927*^9, 3.65337900502431*^9}, {3.65338276511313*^9, 
   3.6533828063939*^9}, 3.653382854167697*^9, {3.653383745662682*^9, 
   3.653383782981093*^9}, {3.653383840692298*^9, 3.6533838456198883`*^9}, {
   3.653384249995995*^9, 3.6533843123629847`*^9}, {3.653386202863043*^9, 
   3.6533862584998693`*^9}, {3.653390737705628*^9, 3.653390739937315*^9}, {
   3.653390902013857*^9, 3.65339090337775*^9}, {3.653390940309018*^9, 
   3.653390940712945*^9}, 3.653391190623646*^9, {3.6533912495193567`*^9, 
   3.653391282789853*^9}, 3.653634747776924*^9, 3.653637435127521*^9, 
   3.6536375108258133`*^9, {3.6536379695531263`*^9, 3.653637970546637*^9}, {
   3.653638004896541*^9, 3.653638005288282*^9}, {3.6536381345973387`*^9, 
   3.653638138828762*^9}, {3.6536424525112953`*^9, 3.653642456086172*^9}, {
   3.6536466374026337`*^9, 3.653646655164146*^9}, {3.653651776708181*^9, 
   3.653651784372064*^9}, {3.653651967105109*^9, 3.653651968536775*^9}, {
   3.65365202098381*^9, 3.6536520477108297`*^9}, {3.6544258621826887`*^9, 
   3.65442587450977*^9}, {3.654431134252376*^9, 3.654431145011314*^9}, 
   3.6544318188854713`*^9, {3.6544319448675013`*^9, 3.654431962603526*^9}, {
   3.654432465720717*^9, 3.654432471511896*^9}, {3.654432647083828*^9, 
   3.654432652452134*^9}, {3.654432766721627*^9, 3.654432776369487*^9}, {
   3.654432814024529*^9, 3.6544328205363894`*^9}, {3.654432959118018*^9, 
   3.654432964701429*^9}, {3.654433096708247*^9, 3.654433104705942*^9}, {
   3.654433218424775*^9, 3.654433220887821*^9}, {3.6544332764712877`*^9, 
   3.6544332772706413`*^9}, {3.654433470843918*^9, 3.654433480682355*^9}, {
   3.654433735581304*^9, 3.6544337625649023`*^9}, {3.654433903273954*^9, 
   3.654433910361353*^9}, {3.654433999919984*^9, 3.6544340151513968`*^9}, {
   3.654434209837215*^9, 3.6544342138123627`*^9}, {3.654434319016773*^9, 
   3.6544343431604*^9}, {3.654434533861601*^9, 3.654434538244244*^9}, {
   3.654434589083997*^9, 3.6544345900926113`*^9}, 3.6544348550385513`*^9, {
   3.6544350995764933`*^9, 3.6544351006003923`*^9}, {3.654435170048601*^9, 
   3.6544351740790243`*^9}, {3.654435232855584*^9, 3.654435236309228*^9}, {
   3.65443548767491*^9, 3.654435489263926*^9}, 3.654435612109846*^9, 
   3.6544356557016687`*^9, 3.654435765363168*^9, {3.6544358781764812`*^9, 
   3.654435881271947*^9}, {3.654435925103607*^9, 3.654435927151387*^9}, 
   3.654436023741592*^9, {3.654436101331933*^9, 3.654436139826598*^9}, {
   3.654436195178339*^9, 3.6544362263610697`*^9}, {3.654600142957807*^9, 
   3.654600143893454*^9}, 3.654600174442533*^9, {3.654601230294147*^9, 
   3.654601246720536*^9}, 3.6546031280197973`*^9, 3.654603331190138*^9, {
   3.654603409846778*^9, 3.654603410797145*^9}, {3.654607368657799*^9, 
   3.6546073984854603`*^9}, 3.654944865923127*^9, 3.654944959384799*^9, {
   3.6549456872439747`*^9, 3.6549457067261343`*^9}, {3.654948243623043*^9, 
   3.654948272841017*^9}, 3.654948381915938*^9, {3.6549484811720543`*^9, 
   3.654948481446971*^9}, {3.654949843398978*^9, 3.6549498892377996`*^9}, {
   3.65495003633182*^9, 3.654950041850161*^9}, {3.655119452157836*^9, 
   3.655119458179923*^9}, 3.6551195417469053`*^9, {3.6551199819944477`*^9, 
   3.65512002344252*^9}, {3.6551226931248283`*^9, 3.655122697436098*^9}, {
   3.655449270237895*^9, 3.6554493688669243`*^9}, {3.6554523971960616`*^9, 
   3.6554524221045923`*^9}, {3.655539312869871*^9, 3.655539327941757*^9}, 
   3.655540209700885*^9, {3.656235442696848*^9, 3.656235448360507*^9}, {
   3.656242241814143*^9, 3.656242299502399*^9}, {3.6562423503894672`*^9, 
   3.656242354437297*^9}, {3.656242431156152*^9, 3.656242436570652*^9}, {
   3.6562442575626163`*^9, 3.656244283730896*^9}, 3.656322116209444*^9, {
   3.656324411648356*^9, 3.656324412527975*^9}, {3.65632860940414*^9, 
   3.65632862648352*^9}, {3.656331744076589*^9, 3.65633176621229*^9}, {
   3.656331803163847*^9, 3.656331855067171*^9}, {3.6563323005370827`*^9, 
   3.656332337090822*^9}, {3.6563325306464443`*^9, 3.656332588333802*^9}, {
   3.656336033484117*^9, 3.656336096057795*^9}, {3.6564018134846015`*^9, 
   3.65640181834159*^9}, {3.6564020186226864`*^9, 3.6564020385035753`*^9}, {
   3.6564020807025366`*^9, 3.656402113699897*^9}, {3.656402189561782*^9, 
   3.6564022851846113`*^9}, {3.6564023423213015`*^9, 
   3.6564023829871492`*^9}, {3.6564024147071257`*^9, 3.656402430196471*^9}, {
   3.656402512787984*^9, 3.65640251391029*^9}, 3.6564025646841536`*^9, {
   3.6564026110136905`*^9, 3.6564026319503975`*^9}, {3.6564044250173144`*^9, 
   3.6564044300125113`*^9}, {3.65640446768567*^9, 3.656404490823603*^9}, {
   3.6564060240181212`*^9, 3.656406036030825*^9}, {3.65640611179447*^9, 
   3.6564061130183363`*^9}, {3.656406145692709*^9, 3.656406190104973*^9}, 
   3.6564091094866962`*^9, {3.6564097325831666`*^9, 3.6564098157265*^9}, {
   3.6570301059500732`*^9, 3.657030110037575*^9}, {3.657354761327952*^9, 
   3.65735476350546*^9}, 3.6649119715204744`*^9, {3.66514571166147*^9, 
   3.6651457456776066`*^9}, 3.6651461491061306`*^9, {3.665146376692958*^9, 
   3.665146384909066*^9}, {3.665165810870386*^9, 3.6651658112532315`*^9}, {
   3.665176365125589*^9, 3.665176398747633*^9}, {3.6652262011487246`*^9, 
   3.6652262027787337`*^9}, {3.665300636031836*^9, 3.6653006541165915`*^9}, {
   3.6653010448729863`*^9, 3.66530104813066*^9}, {3.6653012653576336`*^9, 
   3.6653012660088434`*^9}, 3.6653092065011587`*^9, {3.6653247721505795`*^9, 
   3.665324772613239*^9}, {3.6653914647859087`*^9, 3.665391525419199*^9}, {
   3.665392575525505*^9, 3.6653925763305845`*^9}, 3.6653934786372986`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.6658296132314606`*^9, 
   3.6658296398754435`*^9}, {3.6670365339806337`*^9, 
   3.6670365344652624`*^9}, {3.667549811196762*^9, 3.667549823541642*^9}, 
   3.6708461501379952`*^9, {3.671515747845851*^9, 3.67151574800206*^9}, 
   3.7339012212388983`*^9, 3.748263123339094*^9, {3.74826427511895*^9, 
   3.748264275689365*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.749022827086334*^9, 3.7490228408936667`*^9}, 3.749225250915362*^9},
 ExpressionUUID -> "961a37e2-31ff-4366-af70-d4df4d9c7878"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uyS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"uy", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653646656864345*^9, 3.653646666201375*^9}, {
   3.6544258790946913`*^9, 3.6544258819273167`*^9}, {3.654431134883913*^9, 
   3.654431148657559*^9}, 3.654431819769801*^9, {3.654431967483809*^9, 
   3.6544319777410393`*^9}, {3.654432474728406*^9, 3.654432501759036*^9}, {
   3.654432656380678*^9, 3.654432660348859*^9}, {3.654432966669482*^9, 
   3.6544329700770397`*^9}, {3.654433101419043*^9, 3.654433110930039*^9}, {
   3.6544332812877903`*^9, 3.65443328461489*^9}, {3.654433474835051*^9, 
   3.654433477234099*^9}, {3.654433754766362*^9, 3.654433759645101*^9}, {
   3.654433896290979*^9, 3.654433910753422*^9}, {3.654434220261179*^9, 
   3.654434224250766*^9}, {3.654434319752801*^9, 3.654434351944413*^9}, 
   3.654434399543202*^9, {3.654434535749795*^9, 3.654434546805729*^9}, 
   3.654434596040084*^9, 3.654434856477832*^9, {3.654435103905141*^9, 
   3.654435104577302*^9}, {3.654435176407405*^9, 3.65443518226292*^9}, {
   3.654435237250764*^9, 3.6544352385893707`*^9}, {3.654435492097211*^9, 
   3.654435492888328*^9}, 3.654435613318428*^9, 3.654435724500189*^9, {
   3.654435766779348*^9, 3.654435768314274*^9}, {3.6544359675596333`*^9, 
   3.654435968414906*^9}, 3.654436016173621*^9, {3.654436140634481*^9, 
   3.654436143467098*^9}, {3.6544362039776278`*^9, 3.654436228369001*^9}, 
   3.6546001761650763`*^9, {3.654601231667083*^9, 3.654601258872344*^9}, {
   3.654603142435042*^9, 3.6546031450094852`*^9}, {3.654603418312087*^9, 
   3.654603418948114*^9}, {3.654607370182158*^9, 3.654607416756566*^9}, {
   3.654852246040944*^9, 3.6548522598968573`*^9}, {3.654852314008891*^9, 
   3.654852314144066*^9}, {3.654852732552444*^9, 3.654852736568254*^9}, 
   3.654944860955061*^9, 3.654944962121249*^9, {3.6549456905310926`*^9, 
   3.654945715457518*^9}, {3.6549482817625732`*^9, 3.654948284038377*^9}, 
   3.654948385700252*^9, {3.654948483465907*^9, 3.654948485490468*^9}, {
   3.6549498488876667`*^9, 3.654949890598049*^9}, {3.654950043228282*^9, 
   3.6549500515465508`*^9}, {3.655116306100341*^9, 3.6551163106042843`*^9}, {
   3.655116445886464*^9, 3.655116470392399*^9}, {3.655117198129714*^9, 
   3.655117215969509*^9}, {3.6551174415973787`*^9, 3.65511746020441*^9}, 
   3.6551183824662323`*^9, {3.655119453797896*^9, 3.655119459572075*^9}, 
   3.655119543328308*^9, {3.655120028300734*^9, 3.655120038329707*^9}, {
   3.655122702278792*^9, 3.655122703700597*^9}, {3.655449373300736*^9, 
   3.655449397635953*^9}, {3.6554521762627583`*^9, 3.6554521913682113`*^9}, {
   3.655452394013936*^9, 3.655452429502508*^9}, {3.655539331485566*^9, 
   3.655539364165963*^9}, {3.6555398130531387`*^9, 3.655539829747613*^9}, 
   3.655540212661139*^9, 3.6562354564256163`*^9, {3.656242312482699*^9, 
   3.656242316230077*^9}, {3.656244288251334*^9, 3.6562443066184893`*^9}, {
   3.656322120841134*^9, 3.656322121611712*^9}, {3.656322351157514*^9, 
   3.656322356989119*^9}, {3.656324416608314*^9, 3.65632442102378*^9}, {
   3.656328610387838*^9, 3.656328627427506*^9}, {3.6563317457803183`*^9, 
   3.656331859586472*^9}, {3.656332607007971*^9, 3.6563326192843523`*^9}, {
   3.6563361151247063`*^9, 3.656336124937318*^9}, {3.6564018246350327`*^9, 
   3.6564018318525796`*^9}, 3.6564020469767513`*^9, {3.656402083369752*^9, 
   3.6564020849698887`*^9}, {3.656402308529245*^9, 3.656402394087489*^9}, {
   3.656402642862974*^9, 3.656402714402313*^9}, 3.656402756846137*^9, {
   3.656404427394226*^9, 3.6564044893855834`*^9}, {3.6564059844045863`*^9, 
   3.6564060168452473`*^9}, {3.6564061141501384`*^9, 
   3.6564061156622105`*^9}, {3.656406159067218*^9, 3.6564062011502333`*^9}, 
   3.656409113788725*^9, {3.656409823793915*^9, 3.656409838026557*^9}, {
   3.657030116383741*^9, 3.6570301244534273`*^9}, {3.657354765729664*^9, 
   3.6573547678040657`*^9}, 3.664911968549234*^9, {3.6651463730200953`*^9, 
   3.665146387680727*^9}, {3.6651658157814565`*^9, 3.665165816470908*^9}, {
   3.665176366732342*^9, 3.6651764046392145`*^9}, {3.665226205860623*^9, 
   3.6652262085959606`*^9}, {3.665226276977391*^9, 3.6652262773792405`*^9}, 
   3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665829616987405*^9, 3.6658296431942353`*^9}, 3.667036538137045*^9, {
   3.667549813188735*^9, 3.667549824333385*^9}, 3.6708461506140385`*^9, {
   3.6715157490333633`*^9, 3.6715157490958643`*^9}, 3.7339012212388983`*^9, {
   3.734780218998967*^9, 3.734780220293178*^9}, 3.748263124091325*^9, {
   3.748264278266306*^9, 3.748264278635758*^9}, {3.7487821619637814`*^9, 
   3.7487821767601943`*^9}, {3.7490228286611767`*^9, 3.749022839461113*^9}, 
   3.749225250915362*^9},
 ExpressionUUID -> "8c7abfee-ce24-49c0-ab8a-7e8fc1b916d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"uzS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"uz", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.653646668681004*^9, 3.653646699145215*^9}, {
   3.653651962025899*^9, 3.653651976480847*^9}, {3.6536520249427347`*^9, 
   3.6536520498153677`*^9}, {3.654425813951067*^9, 3.65442581783171*^9}, {
   3.6544304676650343`*^9, 3.654430509489046*^9}, {3.6544310802697268`*^9, 
   3.6544310827164516`*^9}, 3.65443182115392*^9, 3.6544319867863283`*^9, {
   3.65443254753474*^9, 3.654432582821368*^9}, {3.654432866977209*^9, 
   3.654432881535369*^9}, 3.654433017380834*^9, {3.654433190081985*^9, 
   3.654433195392448*^9}, {3.654433487330469*^9, 3.654433494186371*^9}, {
   3.6544341672446613`*^9, 3.654434200156747*^9}, 3.654434321264763*^9, {
   3.654434360176662*^9, 3.654434365016451*^9}, 3.6544344341359653`*^9, {
   3.65443453959233*^9, 3.6544345431130257`*^9}, {3.654434600411928*^9, 
   3.654434604923008*^9}, {3.654434857493829*^9, 3.654434858742721*^9}, {
   3.654435035130908*^9, 3.654435038849515*^9}, {3.654599015572548*^9, 
   3.6545990907637367`*^9}, {3.6545991246198483`*^9, 3.654599127658218*^9}, {
   3.65459917444527*^9, 3.654599203160955*^9}, {3.654599245304274*^9, 
   3.6545992522253647`*^9}, {3.654599699287374*^9, 3.654599716207759*^9}, {
   3.654600711180138*^9, 3.654600743266433*^9}, {3.65460082516348*^9, 
   3.654600868136133*^9}, 3.654853362060231*^9, {3.654941705651705*^9, 
   3.6549417213311157`*^9}, 3.654944852283134*^9, 3.654944965477054*^9, {
   3.654945718026718*^9, 3.654945727097561*^9}, {3.6551194182370853`*^9, 
   3.655119440972431*^9}, {3.655120052006782*^9, 3.655120068768977*^9}, {
   3.655122705902609*^9, 3.655122708773796*^9}, {3.655539392228231*^9, 
   3.655539402211912*^9}, 3.656235457329543*^9, {3.656236096013527*^9, 
   3.656236100300889*^9}, {3.6562367023385983`*^9, 3.65623674575331*^9}, {
   3.656237279744659*^9, 3.6562372927583103`*^9}, {3.656237328119171*^9, 
   3.6562373542553053`*^9}, {3.656237386622595*^9, 3.65623739033451*^9}, 
   3.656238918650964*^9, {3.656239409234419*^9, 3.656239471432931*^9}, {
   3.656239528657618*^9, 3.656239542936122*^9}, {3.6562400713854923`*^9, 
   3.656240149613399*^9}, 3.656242215808754*^9, 3.656244243667077*^9, 
   3.6563220677301397`*^9, {3.6563286122161283`*^9, 3.656328635755446*^9}, {
   3.6564027290294943`*^9, 3.656402738891775*^9}, {3.656404280569064*^9, 
   3.65640434942456*^9}, {3.6564059781954913`*^9, 3.6564059785893593`*^9}, {
   3.656413116052379*^9, 3.656413121967552*^9}, {3.6564157307394524`*^9, 
   3.656415738118362*^9}, {3.6649119643670444`*^9, 3.664911965078226*^9}, {
   3.665146363592942*^9, 3.665146389961588*^9}, 3.6651464604984417`*^9, {
   3.6651658195361357`*^9, 3.6651658213485804`*^9}, {3.665166008082565*^9, 
   3.6651660085779257`*^9}, {3.6651763692147284`*^9, 
   3.6651764086038017`*^9}, {3.6652262116202974`*^9, 3.6652262128931503`*^9}, 
   3.665226281228283*^9, {3.6653006401102057`*^9, 3.6653006575867515`*^9}, {
   3.665301050955241*^9, 3.6653010542312765`*^9}, {3.6653012680230923`*^9, 
   3.665301268390334*^9}, {3.6653022793879952`*^9, 3.6653022810010614`*^9}, 
   3.6653092065011587`*^9, 3.6653247739741764`*^9, {3.6653914664078445`*^9, 
   3.665391526571164*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.6658296215607457`*^9, 3.6658296439636726`*^9}, 3.6670365395473323`*^9, {
   3.667549815692732*^9, 3.6675498251974363`*^9}, 3.670846151338025*^9, 
   3.7339012212388983`*^9, 3.74826312492128*^9, {3.748264280802253*^9, 
   3.748264281146008*^9}, {3.7487821619637814`*^9, 3.7487821767601943`*^9}, {
   3.7490228292222233`*^9, 3.749022837940277*^9}, 3.749225250916359*^9},
 ExpressionUUID -> "811cca09-e39f-418f-9481-2f476967a27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PS2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", "SuperstrateFields"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.65338653407016*^9, 3.653386585725087*^9}, {
   3.653389535754504*^9, 3.653389536274371*^9}, {3.653389952737358*^9, 
   3.6533899530566463`*^9}, {3.6533904659345417`*^9, 3.653390476557845*^9}, {
   3.653390557884985*^9, 3.65339055975795*^9}, {3.653635723628846*^9, 
   3.653635725510133*^9}, {3.653635844619495*^9, 3.6536358450670137`*^9}, {
   3.6536377396938057`*^9, 3.65363774092563*^9}, {3.653637940648716*^9, 
   3.6536379411043453`*^9}, {3.653638045239662*^9, 3.653638046325344*^9}, {
   3.653638144244721*^9, 3.6536381455748587`*^9}, {3.653642261179134*^9, 
   3.653642261497168*^9}, {3.65364246303111*^9, 3.65364246429431*^9}, {
   3.653642596075506*^9, 3.653642596484844*^9}, 3.653646703809408*^9, {
   3.653648883918741*^9, 3.653648884232443*^9}, {3.653651991368587*^9, 
   3.653651997928196*^9}, {3.65365202905476*^9, 3.653652051085609*^9}, {
   3.6544258460396013`*^9, 3.6544258501751003`*^9}, {3.654431511957305*^9, 
   3.654431515235667*^9}, 3.654431822492021*^9, 3.654431988434101*^9, 
   3.654432586691399*^9, {3.6544328898606787`*^9, 3.6544329079034758`*^9}, 
   3.654433018148431*^9, {3.654433497203177*^9, 3.654433504355483*^9}, 
   3.654434206493174*^9, 3.654434321705036*^9, {3.654434371847488*^9, 
   3.6544343818322277`*^9}, 3.6544344347285547`*^9, {3.654434540670917*^9, 
   3.654434549452229*^9}, {3.654434608683476*^9, 3.6544346130991507`*^9}, {
   3.6544348597829103`*^9, 3.6544348613549*^9}, {3.654435055225634*^9, 
   3.6544350595712442`*^9}, {3.654599305636416*^9, 3.6545993139209538`*^9}, {
   3.654599718784523*^9, 3.654599746534658*^9}, {3.6546007476825857`*^9, 
   3.654600756253359*^9}, {3.65460084320191*^9, 3.654600904254669*^9}, 
   3.654603122426505*^9, 3.654603337118032*^9, {3.654603399372939*^9, 
   3.654603400078434*^9}, {3.6546038146781693`*^9, 3.6546038314998703`*^9}, {
   3.654941714483863*^9, 3.6549417223402033`*^9}, {3.654941935542698*^9, 
   3.654941938342661*^9}, 3.654944846308878*^9, {3.654945719634079*^9, 
   3.654945728522559*^9}, {3.655119439046522*^9, 3.6551194452444887`*^9}, {
   3.6551200737224283`*^9, 3.655120093665298*^9}, {3.655122712813733*^9, 
   3.655122716667802*^9}, {3.655539408236487*^9, 3.6555394151482162`*^9}, 
   3.6562354613375273`*^9, {3.65623729745604*^9, 3.6562373565354023`*^9}, {
   3.6562394789153423`*^9, 3.656239484592922*^9}, {3.6562395481053143`*^9, 
   3.656239560287814*^9}, {3.656240155076743*^9, 3.656240230820005*^9}, 
   3.6562422227365637`*^9, 3.6562442484109497`*^9, {3.656322072473866*^9, 
   3.6563220750576897`*^9}, {3.656328617395788*^9, 3.656328637139414*^9}, {
   3.656404362972185*^9, 3.656404369720972*^9}, {3.6564059736548347`*^9, 
   3.656405974358848*^9}, {3.656413143580474*^9, 3.6564131463063865`*^9}, {
   3.6564157567882524`*^9, 3.656415760674179*^9}, 3.6649119608057256`*^9, {
   3.665146140587656*^9, 3.6651461449015455`*^9}, {3.6651463450954227`*^9, 
   3.665146355013607*^9}, {3.6651658250476866`*^9, 3.6651658261974487`*^9}, {
   3.665176372345414*^9, 3.665176417099262*^9}, {3.6652262232995806`*^9, 
   3.665226223777876*^9}, 3.6652262877848063`*^9, {3.6652339313576336`*^9, 
   3.665233932487856*^9}, {3.6653006438556767`*^9, 3.665300661496628*^9}, {
   3.6653010771324954`*^9, 3.665301079899484*^9}, {3.665301270764222*^9, 
   3.665301271106109*^9}, {3.6653022842658424`*^9, 3.665302284659343*^9}, 
   3.6653092065011587`*^9, 3.665324777378188*^9, {3.6653914679474707`*^9, 
   3.665391475288598*^9}, {3.665391506161293*^9, 3.665391527809343*^9}, {
   3.6653968832143087`*^9, 3.6653968878692284`*^9}, {3.665402903744837*^9, 
   3.6654029046309404`*^9}, {3.665433338210455*^9, 3.6654333410946145`*^9}, {
   3.665826658194866*^9, 3.665826659085082*^9}, {3.6658296265084667`*^9, 
   3.665829644510583*^9}, 3.6658296883817434`*^9, 3.667036541102344*^9, 
   3.667549819581059*^9, 3.6708461519189835`*^9, 3.7339012212388983`*^9, 
   3.748263125623885*^9, {3.748264283069373*^9, 3.748264283489883*^9}, {
   3.7487821619637814`*^9, 3.7487821767601943`*^9}, {3.7490228299433208`*^9, 
   3.749022832576417*^9}, 3.749225250916359*^9},
 ExpressionUUID -> "e02b24ca-d7ae-4247-a6d2-d763483e980a"],

Cell[TextData[{
 "As in the main paper, ",
 StyleBox["fx[m,n][z] ", "Output"],
 "refers to the nth fourier term in the nth order in \[CurlyEpsilon] for ux, \
etc, which is a function of z."
}], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.7166711408488564`*^9, 3.7166711591302385`*^9}, {
   3.717343550334776*^9, 3.7173435553189697`*^9}, 3.717405806531722*^9, {
   3.7201699417103024`*^9, 3.7201699536755857`*^9}, {3.748192683134962*^9, 
   3.748192723039256*^9}, {3.74826292775035*^9, 3.748262987975998*^9}, 
   3.7487821767601943`*^9, 3.749225250916359*^9},
 ExpressionUUID -> "4ca55bf9-035a-4d4d-9323-a1eeaafb8812"],

Cell[TextData[StyleBox["Surface stress", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.748192884714484*^9, 3.748192886896722*^9}, 
   3.7487821767601943`*^9, 3.749225250916359*^9}],

Cell["\<\
We also write the Lagrange multiplier for the surface amplitude as a series \
in \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.748192725130557*^9, 3.7481927471727858`*^9}, 
   3.7487821767601943`*^9, 3.749225250916359*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"L0", "+", 
    RowBox[{"\[CurlyEpsilon]", " ", "L1"}], " ", "+", 
    RowBox[{
     SuperscriptBox["\[CurlyEpsilon]", "2"], " ", "L2"}]}]}], " ", 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.6651762408646874`*^9, 3.665176284308905*^9}, {
   3.6652272035076323`*^9, 3.6652272055495043`*^9}, 3.6653092065011587`*^9, {
   3.665433338210455*^9, 3.6654333410946145`*^9}, {3.669689820988999*^9, 
   3.669689828501999*^9}, {3.669691223963415*^9, 3.6696912248537703`*^9}, 
   3.7058486877397184`*^9, 3.7164901243745613`*^9, {3.734516110546652*^9, 
   3.7345161144425993`*^9}, {3.748782161964778*^9, 3.7487821767611914`*^9}, 
   3.749225250917356*^9},
 ExpressionUUID -> "157f94d4-a345-4842-ba8b-e758cc27a061"],

Cell[TextData[StyleBox["Calculation of the energy coefficients", \
"Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.748193033814044*^9, 3.7481930409641542`*^9}, 
   3.7487821767611914`*^9, 3.749225250917356*^9}],

Cell["\<\
To calculate the energy coefficients, we first expand the energy density as a \
series in \[CurlyEpsilon].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.748261801266735*^9, 3.7482618033912163`*^9}, 
   3.7487821767611914`*^9, 3.749225250917356*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W2", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";", 
  
  RowBox[{"W3", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4", "=", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"W", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S", ",", "W2S", ",", "W3S", ",", "W4S"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2", ",", "W2S2", ",", "W3S2", ",", "W4S2"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1", ",", "W2", ",", "W3", ",", "W4"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748262405354032*^9, 
   3.748262405520245*^9}, {3.7483637331750517`*^9, 3.748363879931884*^9}, {
   3.748782161964778*^9, 3.7487821767611914`*^9}, {3.7490228751723347`*^9, 
   3.7490228933278155`*^9}, 3.749225250917356*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[TextData[StyleBox["In-plane averaging", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, 
   3.7487821767611914`*^9, 3.749225250917356*^9}],

Cell["\<\
For the stripe pattern, to take in-plane averages we integrate over an \
in-plane square with vertices (0,0) and (xmax, ymax) where:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, 3.7487821767611914`*^9, 3.749225250917356*^9, {
   3.7493087882851577`*^9, 3.7493087890813665`*^9}, 3.749800861681419*^9},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xmax", "=", 
   RowBox[{"4", 
    RowBox[{"\[Pi]", "/", "k"}]}]}], ";", 
  RowBox[{"ymax", "=", 
   RowBox[{"4", 
    RowBox[{"\[Pi]", "/", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox["3"], "k"}], ")"}]}]}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{
  3.719933909813597*^9, {3.734776818484407*^9, 3.73477681962022*^9}, 
   3.748370890827632*^9, 3.7487821969581842`*^9, 3.748788952348234*^9, 
   3.749225250917356*^9},
 ExpressionUUID -> "5855c714-aa51-498c-95ad-fb5bc38951a6"],

Cell["\<\
We first average the W coefficients over this in-plane unit cell:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.748261748545721*^9, 3.748261754737146*^9}, {
   3.748261885770821*^9, 3.748261903569084*^9}, 3.7487821767611914`*^9, 
   3.749225250917356*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"W1av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W2av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W2", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W3av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W3", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W4av", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"xmax", " ", "ymax"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Expand", "[", "W4", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "ymax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1Sav", ",", "W2Sav", ",", "W3Sav", ",", "W4Sav"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SubstrateFields"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"W1S2av", ",", "W2S2av", ",", "W3S2av", ",", "W4S2av"}], "}"}], 
   "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"W1av", ",", "W2av", ",", "W3av", ",", "W4av"}], "}"}], "/.", 
    "SuperstrateFields"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748363304860167*^9, 3.748363305950943*^9}, {3.748363884084024*^9, 
   3.7483639296474533`*^9}, 3.74836397218202*^9, {3.748782161964778*^9, 
   3.7487821767611914`*^9}, {3.749022905875888*^9, 3.749022918858284*^9}, {
   3.7492251937811794`*^9, 3.7492252086374445`*^9}, 3.749225250917356*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Validation the solution satisfies the bulk \
equations", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.7481928957942*^9, 3.7481929037282*^9}, {
   3.7481929666078777`*^9, 3.748192979141858*^9}, 3.748782196963142*^9, 
   3.7487889523492317`*^9, 3.749225450290379*^9}],

Cell["\<\
.We use the inbuilt Mathematica \[OpenCurlyDoubleQuote]Series\
\[CloseCurlyDoubleQuote]  to expand the bulk equations to third order as a \
series in  \[CurlyEpsilon]\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, 3.74878219696414*^9, 
   3.7487885413311186`*^9, 3.7487889523492317`*^9, 3.749225450290379*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquations", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748359076251601*^9, 3.748359096792377*^9}, {
   3.748763367207853*^9, 3.7487633681848793`*^9}, 3.7487821969651365`*^9, 
   3.7487889523492317`*^9, 3.749225450290379*^9}],

Cell["\<\
We simplify these equations using the bespoke helper function TrigSimplify, \
which expresses the equations as a sum of Trig components and applies \
Simplify to the coefficient of each component.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
   3.748358288765593*^9}, 3.7487821969651365`*^9, 3.7487889523492317`*^9, 
   3.749225450290379*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BulkEquationSeries", "=", 
   RowBox[{"TrigSimplify", "[", "BulkEquationSeries", "]"}]}], ";"}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.748264022185272*^9}, 3.7482645170562563`*^9, {
   3.748265025803114*^9, 3.748265063629121*^9}, {3.7482663672032747`*^9, 
   3.7482664252577047`*^9}, {3.748266531005845*^9, 3.748266532199972*^9}, {
   3.748266616190357*^9, 3.74826663949277*^9}, 3.748266896189138*^9, {
   3.7482673152855577`*^9, 3.7482673161669197`*^9}, {3.7482678090557737`*^9, 
   3.748267809614543*^9}, {3.74826789081393*^9, 3.748267895061193*^9}, {
   3.748267927612143*^9, 3.74826794725991*^9}, {3.748268583368083*^9, 
   3.7482685998720217`*^9}, {3.748268645047811*^9, 3.7482686485923843`*^9}, {
   3.7482688459580517`*^9, 3.7482688772805*^9}, {3.7483581446122227`*^9, 
   3.748358196022498*^9}, {3.748358299490245*^9, 3.748358312796399*^9}, 
   3.748358704686191*^9, {3.748359100059197*^9, 3.748359101588066*^9}, 
   3.7487821969661636`*^9, 3.7487889523492317`*^9, 3.749225450290379*^9, 
   3.749800869085807*^9}],

Cell["\<\
We can verify that this simplification has not altered the bulk equations by \
checking they are still equal to the original ones:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748267286562029*^9, 3.74826730455931*^9}, {
   3.748358066566401*^9, 3.74835810807306*^9}, {3.74835821087175*^9, 
   3.748358288765593*^9}, {3.748358322614171*^9, 3.748358357672377*^9}, 
   3.7487821969661636`*^9, 3.7487889523492317`*^9, 3.749225450290379*^9}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"BulkEquationSeries", "-", 
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquations", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, {3.748358368733041*^9, 3.7483583845075893`*^9}, {
   3.748358678288769*^9, 3.7483586799880857`*^9}, {3.748358732311248*^9, 
   3.748358750771925*^9}, {3.7483591033228397`*^9, 3.748359135765121*^9}, 
   3.7487821969671583`*^9, 3.7487889523492317`*^9, {3.7489524290844717`*^9, 
   3.748952434051524*^9}, 3.749225450291376*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{
  3.748358751444758*^9, {3.748359126168439*^9, 3.748359137066627*^9}, 
   3.74836444648414*^9, 3.748364982217807*^9, 3.748367910206443*^9, 
   3.748368491159952*^9, 3.748368851870126*^9, 3.748369395549582*^9, 
   3.748370084500741*^9, 3.7487642521113033`*^9, 3.7487821972304535`*^9, 
   3.748783790227696*^9, 3.7487889523492317`*^9, 3.7489540558782473`*^9, 
   3.749066131560734*^9, 3.749225450291376*^9, 3.749226991631178*^9, 
   3.7537408842027016`*^9}],

Cell["\<\
The actual fields are stored in the variable \
\[OpenCurlyDoubleQuote]fsolutionhex\[CloseCurlyDoubleQuote] which was \
imported from \
\[OpenCurlyDoubleQuote]pert_solutions.nb\[CloseCurlyDoubleQuote].  This \
variable is a list of substitutions containing the full algebraic form of all \
unknown functions, for example:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, 
   3.748774746791428*^9, 3.748782197231453*^9, {3.7487888048911004`*^9, 
   3.7487888059802055`*^9}, 3.7487889523492317`*^9, 3.749225450291376*^9, {
   3.7498030712276306`*^9, 3.749803072945983*^9}},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fz", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "[", "z", "]"}], "/.", 
  "fsolutionhex"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, 
   3.748265242373149*^9, {3.748371437005432*^9, 3.74837143926686*^9}, 
   3.748782197235414*^9, 3.7487889523492317`*^9, {3.7487912558986964`*^9, 
   3.748791272273771*^9}, {3.748793049074587*^9, 3.748793050045586*^9}, 
   3.749225450291376*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"k", " ", "z"}], 
      SuperscriptBox["g", "3"]]}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"k", " ", "z"}], 
     SuperscriptBox["g", "3"]]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "k"}], " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "3"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"k", " ", "z"}]], " ", 
   RowBox[{"A", "[", 
    RowBox[{"1", ",", "4"}], "]"}]}]}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748791269162113*^9, 3.7487912731479483`*^9}, {
   3.7487930506368847`*^9, 3.7487930668035126`*^9}, 3.7490661316099873`*^9, 
   3.749225450291376*^9, 3.7492269917119617`*^9, 3.75374088428078*^9}],

Cell["\<\
To verify these fields solve the bulk equations, we substitute them in, and \
then simplify the result using the second bespoke simplification function, \
ExpSimplify, which expresses the equations as a sum of Exponential components \
and then applies Simplify to the coefficient of each component.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
   3.74835877376761*^9, 3.748358840101597*^9}, 3.748782197237439*^9, 
   3.748788952350238*^9, 3.749225450291376*^9},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{"ExpSimplify", "[", 
  RowBox[{"BulkEquationSeries", "/.", "fsolutionhex"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, 3.7483591121969*^9, {3.748370966122116*^9, 
   3.748370969754299*^9}, 3.748782197238408*^9, 3.748788952350238*^9, 
   3.749225450291376*^9, 3.749800930047773*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{3.748798226278036*^9, 3.7490750288062286`*^9, 
  3.749225450291376*^9, 3.7492332650410824`*^9, 3.753745034826532*^9}],

Cell["\<\
One can achieve the same result up to second order using the built in \
function Simplify, but this takes unreasonably long for the layer equations \
at third order. \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.7166710645876665`*^9, 3.7166710770508313`*^9}, {
   3.716671134840579*^9, 3.716671135971878*^9}, {3.7198254746813087`*^9, 
   3.719825475217451*^9}, {3.7348015038859835`*^9, 3.7348015088925223`*^9}, {
   3.734801559159957*^9, 3.7348015650851173`*^9}, {3.748192754780232*^9, 
   3.748192838370331*^9}, {3.748197133874509*^9, 3.748197229470049*^9}, {
   3.748197378441827*^9, 3.748197390169345*^9}, {3.748265901484597*^9, 
   3.748265904740265*^9}, {3.748265956999032*^9, 3.7482659702719507`*^9}, {
   3.74835877376761*^9, 3.748358840101597*^9}, {3.7483589228041067`*^9, 
   3.748358941540511*^9}, {3.748358982662092*^9, 3.748359022408444*^9}, 
   3.7487821972413983`*^9, 3.7487889523512273`*^9, 3.749225450291376*^9},
 ExpressionUUID -> "09bd2c59-97fe-406b-8035-c128314c4e86"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"BulkEquationSeries", ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
   "fsolutionhex"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{{3.748244164508481*^9, 3.748244176032332*^9}, {
   3.748263945014106*^9, 3.7482640191705227`*^9}, 3.748264301233959*^9, {
   3.7482643864267807`*^9, 3.748264391759066*^9}, 3.7482645199757013`*^9, {
   3.748265363710875*^9, 3.7482653763977423`*^9}, {3.748265466637621*^9, 
   3.748265524832838*^9}, {3.748265575685979*^9, 3.7482655901717777`*^9}, {
   3.748265740085949*^9, 3.748265746523098*^9}, {3.748266429595146*^9, 
   3.748266435498844*^9}, 3.748266478024062*^9, 3.7482666560037127`*^9, {
   3.748266694191393*^9, 3.7482667030410757`*^9}, {3.748266749727241*^9, 
   3.748266751236869*^9}, {3.748266800969043*^9, 3.7482668073009157`*^9}, {
   3.748266852072117*^9, 3.748266854221912*^9}, {3.748269366107563*^9, 
   3.748269379739429*^9}, {3.748358950227021*^9, 3.748358988873667*^9}, 
   3.748359114064515*^9, 3.7487747491656713`*^9, 3.748782197242425*^9, 
   3.7487889523512273`*^9, 3.749225450291376*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "3"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 3, 3, 1],
    Editable->False]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.},
 CellChangeTimes->{3.7487931198515053`*^9, 3.749066171806265*^9, 
  3.749225450291376*^9, 3.749233324443488*^9, 3.753745070843063*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Validation the solution satisfies the boundary \
conditions", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.748192982991539*^9, 3.748192988325735*^9}, 
   3.74878219724442*^9, 3.7487889523512273`*^9}],

Cell["\<\
The full solutions for the constants of integration (and L0, L1, L2) are \
computed in the separate notebook \
\[OpenCurlyDoubleQuote]sandwich_pert_hex_constants\[CloseCurlyDoubleQuote] \
which we run here. This document actually computes the constants, so running \
it may take a few minutes.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482607612792273`*^9, 3.748260875123485*^9}, {
   3.7482657965084953`*^9, 3.7482657975804243`*^9}, 3.748782197245417*^9, {
   3.7487832168770757`*^9, 3.7487832177088327`*^9}, 3.7487889523512273`*^9, {
   3.749235700895623*^9, 3.749235723599885*^9}, {3.7498010045680294`*^9, 
   3.7498010083484*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookEvaluate", "[", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<sandwich_pert_hex_constants.nb\>\""}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.748158213150754*^9, 3.748158219797617*^9}, {
   3.7481941325489397`*^9, 3.748194136035887*^9}, 3.748195107133922*^9, {
   3.748195421557001*^9, 3.7481954825069237`*^9}, 3.748195517246182*^9, {
   3.74819562767171*^9, 3.748195632607148*^9}, {3.7481957842483664`*^9, 
   3.74819582426667*^9}, {3.748260846949068*^9, 3.748260849580188*^9}, 
   3.748364094167431*^9, 3.748782197245417*^9, {3.748783221086709*^9, 
   3.7487832218599434`*^9}, 3.748788952352228*^9, {3.7492253948440723`*^9, 
   3.7492253963237257`*^9}}],

Cell["\<\
After running  \[OpenCurlyDoubleQuote]pert_stripe_constants\
\[CloseCurlyDoubleQuote], the algebraic forms for the constants are stored in \
the three variables, FirstOrderConstantsStripe, SecondOrderConstantsStripe \
and ThirdOrderConstantsStripe. For example:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482608804202003`*^9, 3.748260931153734*^9}, {
   3.748260970268648*^9, 3.748260985377118*^9}, 3.748782197246414*^9, 
   3.7487889523532233`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{"1", ",", "1"}], "]"}], "/.", "FirstOrderConstantsHex"}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7487821972473836`*^9, 
   3.748788952354219*^9, {3.748798416883297*^9, 3.7487984172782364`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     FractionBox["k", 
      RowBox[{"2", " ", 
       SuperscriptBox["g", "3"]}]]], " ", 
    SuperscriptBox["g", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "11"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "14"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "17"], " ", 
       SuperscriptBox["\[Mu]1", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "g", " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "4"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "7"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "10"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "13"], " ", 
       SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
       SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "9"], " ", "\[Mu]1", " ", 
       SuperscriptBox["\[Mu]2", "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "k"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"k", "+", 
            FractionBox["k", 
             SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["\[Mu]2", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["g", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"k", "+", 
               FractionBox["k", 
                SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
          SuperscriptBox["\[Mu]1", "3"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
          SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "11"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "14"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "17"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "20"], " ", 
     SuperscriptBox["\[Mu]1", "3"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", "g", " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"k", "+", 
       FractionBox["k", 
        SuperscriptBox["g", "3"]]}]], " ", 
     SuperscriptBox["g", "7"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "+", 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "10"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "k"}]]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            FractionBox["1", 
             SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", "k"}], 
          SuperscriptBox["g", "3"]]]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"k", "+", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
     SuperscriptBox["g", "13"], " ", 
     SuperscriptBox["\[Mu]1", "2"], " ", "\[Mu]2"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "3"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"12", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "6"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "9"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "12"], " ", "\[Mu]1", " ", 
     SuperscriptBox["\[Mu]2", "2"]}], "+", 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "k"}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            SuperscriptBox["g", "3"]]}], ")"}], " ", "k"}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"k", "+", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]]}]]}]}], ")"}], " ", 
     SuperscriptBox["g", "5"], " ", 
     SuperscriptBox["\[Mu]2", "3"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "k"}], 
         SuperscriptBox["g", "3"]]]}], ")"}], " ", 
     SuperscriptBox["g", "8"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]1", "3"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
        SuperscriptBox["\[Mu]2", "3"]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.748260951225204*^9, 3.748363017860961*^9, 
  3.74836452913402*^9, 3.748365064394639*^9, 3.7483663728484793`*^9, 
  3.748367993301462*^9, 3.748368573734091*^9, 3.748368934061269*^9, 
  3.748369478943746*^9, 3.748370167978312*^9, 3.7487821972543635`*^9, 
  3.748788952354219*^9, 3.748954835710265*^9, 3.748965398270523*^9, 
  3.749238244933198*^9, 3.7492444784119606`*^9, 3.749809642276722*^9, 
  3.7537454645056868`*^9}],

Cell["\<\
The second order constants are in terms of the first order ones, and the \
third order constants are in terms of the first and second order ones:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482610014395227`*^9, 3.748261036909691*^9}, 
   3.7487821972553897`*^9, 3.748788952354219*^9}],

Cell["\<\
Mathematica is not able to validate that these solutions solve the boundary \
conditions in a reasonable amount of time, so we instead conduct this \
validation numerically at a high-precision numerical test point: \
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482610837996073`*^9, 3.7482611632713633`*^9}, 
   3.748782197256359*^9, 3.748788952354219*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"TestPoint", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]1", "\[Rule]", " ", "3"}], ",", 
      RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", "  ", 
      RowBox[{"g", "\[Rule]", " ", "1.4"}], ",", " ", 
      RowBox[{"k", "\[Rule]", " ", "5"}], ",", " ", 
      RowBox[{"z0", "\[Rule]", 
       RowBox[{"-", "0.5"}]}], ",", 
      RowBox[{"z1", "\[Rule]", "0.5"}]}], "}"}], ",", "50"}], 
   "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.748367111887246*^9, 3.7483671121796923`*^9}, {3.7491431641222205`*^9, 
   3.749143169959608*^9}, 3.749145155169154*^9, {3.749225400366912*^9, 
   3.7492254045058413`*^9}, {3.7493121047378716`*^9, 3.7493121081794815`*^9}},
 
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]1", "\[Rule]", "3.`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1.`50."}], ",", 
   RowBox[{
   "g", "\[Rule]", 
    "1.399999999999999911182158029987476766109466552734375`50."}], ",", 
   RowBox[{"k", "\[Rule]", "5.`50."}], ",", 
   RowBox[{"z0", "\[Rule]", 
    RowBox[{"-", "0.5`50."}]}], ",", 
   RowBox[{"z1", "\[Rule]", "0.5`50."}]}], "}"}]], "Output",
 CellChangeTimes->{3.748958681366388*^9, 3.748965398331329*^9, 
  3.7492382506717243`*^9, 3.749244480770762*^9, 3.7493121089770975`*^9, 
  3.7498096448230095`*^9, 3.750000831582789*^9, 3.75374546458379*^9}],

Cell["\<\
At this TestPoint, we can numerically evaluate the constants at high \
precision, and we store these numerical constants in the variable \
\[OpenCurlyDoubleQuote]NumericalConstants\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellChangeTimes->{{3.7489548958285327`*^9, 3.7489548966702967`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericalConstants", "[", 
   RowBox[{
    RowBox[{"\[Mu]1value_", "?", "NumericQ"}], ",", 
    RowBox[{"\[Mu]2value_", "?", "NumericQ"}], ",", 
    RowBox[{"gvalue_", "?", "NumericQ"}], ",", 
    RowBox[{"kvalue_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TestPoint", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Mu]1value"}], ",", 
          RowBox[{"\[Mu]2", "\[Rule]", " ", "\[Mu]2value"}], ",", " ", 
          RowBox[{"g", "\[Rule]", " ", "gvalue"}], ",", " ", 
          RowBox[{"k", "\[Rule]", " ", "kvalue"}], ",", " ", 
          RowBox[{"z0", "\[Rule]", " ", 
           RowBox[{"-", "0.5"}]}], ",", " ", 
          RowBox[{"z1", "\[Rule]", "0.5"}]}], "}"}], ",", "50"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"NFirstOrderConstantsHex", "=", 
      RowBox[{"FirstOrderConstantsHex", "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"NSecondOrderConstantsHex", "=", 
      RowBox[{
       RowBox[{"SecondOrderConstantsHex", "/.", "NFirstOrderConstantsHex"}], "/.",
        "TestPoint"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NThirdOrderConstantsHex", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"ThirdOrderConstantsHex", "/.", "NSecondOrderConstantsHex"}], 
        "/.", "NFirstOrderConstantsHex"}], "/.", "TestPoint"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "NFirstOrderConstantsHex", ",", "NSecondOrderConstantsHex", ",", 
        "NThirdOrderConstantsHex"}], "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.748367299348639*^9, 
   3.748367402015232*^9}, {3.7483674432132998`*^9, 3.748367507170247*^9}, {
   3.74836755223973*^9, 3.7483675528233423`*^9}, {3.748367651745777*^9, 
   3.7483676532854013`*^9}, {3.748367722421383*^9, 3.748367724938448*^9}, {
   3.7483678628756857`*^9, 3.748367874455339*^9}, {3.7483679329955873`*^9, 
   3.748367942772023*^9}, 3.748782197260349*^9, 3.7487889523552155`*^9, {
   3.7489548492919645`*^9, 3.748954881179713*^9}, {3.7489704547105227`*^9, 
   3.748970461267991*^9}, {3.7489706405927477`*^9, 3.748970640715931*^9}, 
   3.749145154117326*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["For example:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482612779840107`*^9, 3.748261279483727*^9}, 
   3.748782197261346*^9, 3.7487889523552155`*^9}],

Cell[BoxData[
 RowBox[{"L2", "/.", 
  RowBox[{"NumericalConstants", "[", 
   RowBox[{"3", ",", "1", ",", "1.4", ",", "5"}], "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, 
   3.7487821972623434`*^9, 3.7487889523552155`*^9, {3.749225414893059*^9, 
   3.7492254189282656`*^9}, {3.7493121145470777`*^9, 3.749312117798173*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"]
}, Open  ]],

Cell[BoxData["684.3723678968510892270678113348922954810385141047853624862709`\
36.051052446429985"], "Output",
 CellChangeTimes->{3.7537455425002236`*^9}],

Cell[CellGroupData[{

Cell["\<\
Finally, we expand the boundary conditions to third order in epsilon, \
substitute in the fields and the constants and evaluate at the test point, to \
show that they are satisfied up to machine precision, with the help og \
TrigSimplify to speed up the calculation. The Chop command rounds numbers \
smaller than 10^-30 to zero.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
   3.748261408839826*^9, 3.748261423343892*^9}, {3.748367234219556*^9, 
   3.748367248653973*^9}, 3.7487821972643356`*^9, 3.7487889523552155`*^9, {
   3.7498219235401063`*^9, 3.7498219356468086`*^9}}],

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"TrigSimplify", "[", 
        RowBox[{"Series", "[", 
         RowBox[{"BoundaryConditions", ",", 
          RowBox[{"{", 
           RowBox[{"\[CurlyEpsilon]", ",", "0", ",", "3"}], "}"}]}], "]"}], 
        "]"}], "/.", "fsolutionhex"}], "/.", 
      RowBox[{"NumericalConstants", "[", 
       RowBox[{"3.0", ",", "1.0", ",", "1.4", ",", "5.0"}], "]"}]}], "/.", 
     "TestPoint"}], "]"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "20"}]}]}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.7483671689589977`*^9, 3.7483671715347033`*^9}, {
   3.748367220011492*^9, 3.7483672221377087`*^9}, {3.7483675709932613`*^9, 
   3.7483675787994757`*^9}, 3.748782197265361*^9, 3.7487889523552155`*^9, {
   3.748957483238025*^9, 3.748957485439419*^9}, 3.7492383211113167`*^9, 
   3.7492742771121893`*^9, {3.7493853772130136`*^9, 3.74938539107938*^9}, 
   3.749801018439763*^9, {3.749821917213462*^9, 3.749821920181674*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[CurlyEpsilon]", "]"}], "4"],
    SeriesData[$CellContext`\[CurlyEpsilon], 0, {}, 4, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.7498099634662313`*^9, 3.7500016442888494`*^9, 
  3.75374579901516*^9}],

Cell[CellGroupData[{

Cell["\<\
The user is invited to validate the boundary conditions at alternative \
test-points by modifying \[OpenCurlyDoubleQuote]TestPoint\
\[CloseCurlyDoubleQuote] above.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482613237444077`*^9, 3.748261354007496*^9}, {
   3.748261408839826*^9, 3.7482614927761793`*^9}, 3.7487821972673573`*^9, 
   3.7487889523552155`*^9}],

Cell[TextData[StyleBox["Thickness integration", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.748262074419416*^9, 3.74826208137881*^9}, 
   3.7487821972683554`*^9, 3.7487889523552155`*^9}],

Cell["\<\
We next integrate the averaged energies over thickness to find the energy \
coefficients as defined in the paper: We must assume the real part of k>0, \
otherwise the elastic solutions diverge in the substrate and superstrate. \
This calculation may take several minutes.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7482620881141*^9, 3.748262101954483*^9}, {
   3.748363346970169*^9, 3.748363359624626*^9}, {3.748365214909356*^9, 
   3.748365240840098*^9}, {3.74836617852466*^9, 3.748366185813534*^9}, 
   3.7487821972683554`*^9, 3.7487889523552155`*^9, {3.749801042900673*^9, 
   3.749801045681303*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"E1", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1Sav", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W1S2av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E2", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2Sav", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W2S2av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E3", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3Sav", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W3S2av", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"E4", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"W4Sav", "/.", "fsolutionhex"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}], "+", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ExpSimplify", "[", 
        RowBox[{"W4av", "/.", "fsolutionhex"}], "]"}], "/.", "fsolutionhex"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"+", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"W4S2av", "/.", "fsolutionhex"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"1", "/", "2"}], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "k", "]"}], ">", "0"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, {
   3.748261810434952*^9, 3.748261852402668*^9}, {3.748261923192767*^9, 
   3.748261997419652*^9}, {3.748262036893588*^9, 3.7482620405479507`*^9}, {
   3.748262113533332*^9, 3.748262252817123*^9}, {3.748262305237101*^9, 
   3.748262310340988*^9}, {3.748262365269137*^9, 3.7482623722651787`*^9}, {
   3.7483633671292267`*^9, 3.748363383150691*^9}, {3.7483635959244337`*^9, 
   3.7483636870930433`*^9}, {3.748364333478301*^9, 3.748364334039871*^9}, {
   3.748365181454217*^9, 3.748365190982555*^9}, {3.748366111342016*^9, 
   3.7483661577719717`*^9}, {3.748782161964778*^9, 3.7487821767642107`*^9}, {
   3.749023083142062*^9, 3.7490231412630105`*^9}, {3.7490240220227356`*^9, 
   3.749024025859057*^9}, {3.749024350552248*^9, 3.7490243642531223`*^9}, {
   3.749244531006997*^9, 3.7492445771679955`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 TemplateBox[{
  "Simplify","time",
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"",2,168,3,31106511516940694969,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7537469776530523`*^9}],

Cell[BoxData[
 TemplateBox[{
  "Simplify","time",
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"",2,168,4,31106511516940694969,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7537472894852037`*^9}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Threshold for instability", "Subsection"]], "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.74836666158285*^9, 3.748366669568527*^9}, 
   3.7487821972723427`*^9, 3.7487889523562126`*^9}],

Cell["\<\
Instability occurs spontaneously at the point where L0=0, which corresponds \
to the following conditions:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366714346525*^9}, 
   3.7487821972723427`*^9, 3.7487889523562126`*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"ExpToTrig", "[", 
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"L0", "/.", "FirstOrderConstantsHex"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Mu]2", "\[Rule]", " ", "1"}], ",", " ", 
        RowBox[{"\[Mu]1", "\[Rule]", " ", "\[Eta]"}]}], "}"}]}], "]"}], "]"}],
    "\[Equal]", "0"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, 
   3.7487821972743425`*^9, 3.7487889523562126`*^9, {3.748955154507112*^9, 
   3.7489551550895557`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"k", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "7"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["g", "6"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}]}], ")"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["g", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["g", "4"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "12"]}]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"g", "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["g", "7"]}]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "3"], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"g", "-", 
              SuperscriptBox["g", "7"]}], ")"}], "2"], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["g", "6"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["g", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["g", "6"]}], ")"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"13", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                SuperscriptBox["g", "18"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["g", "6"]}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["g", "12"]}], "+", 
                RowBox[{"20", " ", 
                 SuperscriptBox["g", "18"]}], "+", 
                SuperscriptBox["g", "24"]}], ")"}], " ", 
              SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", 
        SuperscriptBox["g", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", 
           SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "g", " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               SuperscriptBox["g", "4"]}], "+", 
              SuperscriptBox["\[Eta]", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["g", "12"], " ", 
               SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["g", "6"]}], "+", 
             RowBox[{
              SuperscriptBox["g", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             SuperscriptBox["g", "6"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["g", "8"], " ", 
              SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["k", 
          SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{
  3.748366436722287*^9, {3.74836648564769*^9, 3.7483665065569477`*^9}, {
   3.748366542145163*^9, 3.748366610605278*^9}, 3.74836672545654*^9, 
   3.748368724221715*^9, 3.7483690947625504`*^9, 3.748369632442429*^9, 
   3.7483703251075907`*^9, 3.748782197279296*^9, 3.7487889523562126`*^9, 
   3.748973700907337*^9, 3.74924753645168*^9, 3.7537476523276806`*^9}],

Cell["\<\
This equation does not have an analytic solution, but can be solved \
numerically for g* at any value of k and \[Eta]. We have written a helper \
function CharacterizeInstabilitySandwich[\[Eta]] which finds numerically (but \
at high precision) the k* and g* for the first point of instability at a \
given value of \[Eta].\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366914683483*^9}, 3.7487821972803235`*^9, 
   3.7487889523562126`*^9, {3.7498010517579904`*^9, 3.749801052523404*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366863463852*^9, 3.7483668668954573`*^9}, 3.7487821972813215`*^9, 
   3.7487889523562126`*^9, 3.7492389432596626`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "g", "\[Rule]", 
    "1.24800619978443093404446326403077289245806686892119996464142355403003738\
290813`50."}], ",", 
   RowBox[{
   "k", "\[Rule]", 
    "1.40271633944241459594362210259135548632004523108779084003855628224143148\
358653`50."}], ",", 
   RowBox[{"\[Mu]2", "\[Rule]", "1"}], ",", 
   RowBox[{"\[Mu]1", "\[Rule]", "3"}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.748366867457121*^9, 3.748368041616961*^9, 
  3.748368103648972*^9, 3.748368724340021*^9, 3.748369094895968*^9, 
  3.748369632567338*^9, 3.7483703252332773`*^9, 3.7487821972813215`*^9, 
  3.748788952357211*^9, 3.7492475365296936`*^9, 3.75374765248385*^9}],

Cell["\<\
We can validate that this point does indeed correspond to L0=0.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, 3.748782197282322*^9, 
   3.748788952357211*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"L0", "/.", "FirstOrderConstantsHex"}], "/.", 
   RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, {3.7482613798230553`*^9, 
   3.7482613948351583`*^9}, {3.7482615037390327`*^9, 3.7482615540063*^9}, 
   3.748363049102429*^9, {3.748366427727549*^9, 3.748366436312138*^9}, {
   3.748366475923089*^9, 3.7483664991077414`*^9}, {3.748366540926355*^9, 
   3.748366591864334*^9}, {3.748366706525754*^9, 3.748366706896644*^9}, {
   3.748366880429227*^9, 3.748366892535075*^9}, 3.7487821972833138`*^9, 
   3.748788952357211*^9, 3.748955160250757*^9, 3.7492389401306515`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``46.75828514393407"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.7483668935893517`*^9, 3.748367745014412*^9, 
  3.74836810758436*^9, 3.748368724399867*^9, 3.7483690949662523`*^9, 
  3.748369632630701*^9, 3.748370325296257*^9, 3.7487821972833138`*^9, 
  3.748788952357211*^9, 3.7489737010060706`*^9, 3.74924753659218*^9, 
  3.753747652561955*^9}],

Cell["\<\
As does the energy coefficient E2, which we expect to have the form E2= \
C2(g-g*)\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
   3.748368290906556*^9}, 3.748782197284314*^9, 3.748788952357211*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"E2", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, 3.7487821972853093`*^9, 3.748788952357211*^9, 
   3.748955342368843*^9, {3.749238929390696*^9, 3.74923893126441*^9}, {
   3.7492446007874317`*^9, 3.7492446058331184`*^9}},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``45.07226733734072"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.748367792808538*^9, 3.7483681144553337`*^9, 
  3.748368250036015*^9, 3.74836872621726*^9, 3.748369097275526*^9, 
  3.748369634536525*^9, 3.748370327151268*^9, 3.7487821972853093`*^9, 
  3.748788952357211*^9, 3.748973746460539*^9, 3.7500039113088465`*^9, 
  3.7537477320475307`*^9}],

Cell["\<\
We can evaluate C2 as the derivative of E2 with respect to g:\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.7483666730568247`*^9, 3.748366848273715*^9}, {
   3.748366907912177*^9, 3.748366939643381*^9}, {3.7483682698590727`*^9, 
   3.748368313602594*^9}, 3.7487821972863092`*^9, 3.748788952357211*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"E2", "/.", "FirstOrderConstantsHex"}], ",", "g"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, 
   3.748782197287276*^9, 3.748788952357211*^9, 3.7489551635090723`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell["\<\
And then we plot C2 as a function of \[Eta], reproducing fig 12E in the main \
paper.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{
  3.74836847884299*^9, {3.748368538294593*^9, 3.748368559647304*^9}, 
   3.748782197287276*^9, 3.748788952357211*^9, {3.7498003642201715`*^9, 
   3.7498003658761053`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"C2", "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0"}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370373648697*^9, 3.74837039644267*^9}, {3.749133038554614*^9, 
   3.7491330642159595`*^9}, {3.749244664129978*^9, 3.7492446660045385`*^9}, 
   3.749283806703413*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEP7E1eRqq8lDc7AOF/sG+7ULk+9q0plP/D/pfz
CQF7Lpg8g8O/abqrprrC+CwOp5MZ7yX3wfgcDjKl+4WC78L4PA4s4mo3z+iZ
Q/kCDpGuL6LeNsD4Qg6HpI6HrLoE44s4FO/qyMhTtoDyxRzWRxX7PiuC8SUc
vNLVa58egPGlHNLmvDwcxmsJ5cs4pH7+pG8cAePLOUycLDylZiGMr+DA9uyC
vNVLGF/Rgc8kyqJM3wrKV3LY79MnblsC4ys7KGz9+Xz2dhhfxeHdLTnDBT+t
DgAAr9ZZIw==
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEH9iYvI1VeypsdgPA/2LddqFwf+9YUyv9h
/8v5hIA9F0yeweHfNN1VU11hfBaH08mM95L7YHwOB5nS/ULBd2F8HgcWcbWb
Z/TMoXwBh0jXF1FvG2B8IYdDUsdDVl2C8UUcind1ZOQpW0D5Yg7ro4p9nxXB
+BIOXunqtU8PwPhSDmlzXh4O47WE8mUcUj9/0jeOgPHlHCZOFp5SsxDGV3Bg
e3ZB3uoljK/owGcSZVGmbwXlKzns9+kTty2B8ZUdFLb+fD57O4yv4vDulpzh
gp9WBwC5blkl
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {-30, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.749247704005886*^9, 3.7500039148152957`*^9, 
  3.7537477351245704`*^9}],

Cell["Similarly, C3 and C4 are obtained from E4", "Text",
 CellChangeTimes->{{3.7497999806814003`*^9, 3.74980000494288*^9}, {
  3.7498004086449156`*^9, 3.749800414377929*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"E3", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.74836912905235*^9, 
   3.748369233216261*^9}, {3.748369783872941*^9, 3.7483697918810062`*^9}, 
   3.748782197289297*^9, 3.748788952357211*^9, 3.7489553436863213`*^9, {
   3.749238912477173*^9, 3.7492389159885993`*^9}, 3.7492446211869726`*^9, 
   3.749322698421376*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["0``40.60703802372176"], "Output",
 CellChangeTimes->{3.750004008155589*^9, 3.753747815220333*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E4", "/.", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NumericalConstants", "[", 
      RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}], "/.", 
     RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"CharacterizeInstabilitySandwich", "[", "3", "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.74836912905235*^9, 
   3.748369233216261*^9}, {3.748369783872941*^9, 3.7483697918810062`*^9}, 
   3.748782197289297*^9, 3.748788952357211*^9, 3.7489553436863213`*^9, {
   3.749238912477173*^9, 3.7492389159885993`*^9}, 3.7492446211869726`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData["6.2783455692248102557769542359465475749357408768905268233959`32.\
6233694002771"], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.},
 CellChangeTimes->{3.74836979419419*^9, 3.748370329112509*^9, 
  3.748782197290267*^9, 3.748788952357211*^9, 3.748973791502116*^9, 
  3.7492476891968493`*^9, 3.750004092855729*^9, 3.7537478941863437`*^9}]
}, Open  ]],

Cell["C3 is zero as we expect from the inversion symmetry", "Text",
 CellChangeTimes->{{3.749800435518839*^9, 3.7498004455793047`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{
         RowBox[{"E3", "/.", 
          RowBox[{"NumericalConstants", "[", 
           RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}]}], "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], "//", "Quiet"}]], "Input",\

 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370140467683*^9, 3.7483701573194733`*^9}, {3.748370381950783*^9, 
   3.748370387159823*^9}, 3.748370435122093*^9, {3.748370487533835*^9, 
   3.748370487814623*^9}, {3.748370591923375*^9, 3.7483705922499657`*^9}, {
   3.74837067792865*^9, 3.7483706781197844`*^9}, 3.7491330673475833`*^9, {
   3.749152773972011*^9, 3.7491527869173703`*^9}, {3.7492446534449964`*^9, 
   3.7492446567410946`*^9}, 3.749283804485047*^9, 3.7493227041894803`*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEP7BlQwAc0/g80PoMDKpcFjc+BxudB4wug8YXQ
+CJofDE0vgQaX8rhvGEaH6evkAWEL4MmL4fGV0DjK6LxldD4ymh8FTgfADIv
DRU=
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEH9gwo4AMa/wcan8EBlcuCxudA4/Og8QXQ
+EJofBE0vhgaXwKNL+Vw3jCNj9NXyALCl0GTl0PjK6DxFdH4Smh8ZTS+CpwP
ADvHDRc=
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {0, 1.34453921334195*^-38}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.749341469955917*^9, 3.749366288410677*^9, 
  3.7500059239975166`*^9, 3.753749489194757*^9}],

Cell["C4 is plotted against \[Eta] as in Fig. 12F", "Text",
 CellChangeTimes->{{3.7498000090825334`*^9, 3.749800035011475*^9}, {
  3.7498004311293907`*^9, 3.749800431316717*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{
         RowBox[{"E4", "/.", 
          RowBox[{"NumericalConstants", "[", 
           RowBox[{"\[Mu]1", ",", "\[Mu]2", ",", "g", ",", "k"}], "]"}]}], "/.", 
         RowBox[{"CharacterizeInstabilitySandwich", "[", "\[Eta]", "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"5", "/", "10"}], ",", "10", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], "//", "Quiet"}]], "Input",\

 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6657713232344956`*^9, 3.665771343381418*^9}, {
   3.665771418266056*^9, 3.665771443269935*^9}, {3.6657714854748755`*^9, 
   3.6657715331802435`*^9}, {3.665771716847458*^9, 3.665771720446126*^9}, {
   3.6657718139064054`*^9, 3.6657718741793876`*^9}, {3.665772091294901*^9, 
   3.665772215307926*^9}, {3.665772247964039*^9, 3.665772263610958*^9}, {
   3.665772485446594*^9, 3.6657725184863443`*^9}, 3.6657729166750526`*^9, {
   3.66577426017365*^9, 3.6657742603906803`*^9}, 3.6658296584374185`*^9, {
   3.6672460521798906`*^9, 3.667246110757153*^9}, 3.667301860838393*^9, {
   3.7058179970092716`*^9, 3.705818048247526*^9}, {3.705818285589779*^9, 
   3.7058183237035446`*^9}, 3.705818449364562*^9, {3.71612068835028*^9, 
   3.7161206885199823`*^9}, 3.7161210204739447`*^9, 3.7345160841540394`*^9, 
   3.748244002237558*^9, 3.74824513592642*^9, 3.748245199162204*^9, {
   3.748260944110375*^9, 3.7482609500335903`*^9}, 3.7482611528669987`*^9, {
   3.7482612607979317`*^9, 3.748261267619701*^9}, 3.748367706806314*^9, {
   3.7483677889971046`*^9, 3.748367807583473*^9}, {3.748368152641985*^9, 
   3.74836815494832*^9}, {3.7483683375737123`*^9, 3.748368358092115*^9}, {
   3.748368488079357*^9, 3.748368510822382*^9}, {3.748369891334807*^9, 
   3.748369892279502*^9}, {3.74837003561719*^9, 3.748370037090804*^9}, {
   3.748370140467683*^9, 3.7483701573194733`*^9}, {3.748370381950783*^9, 
   3.748370387159823*^9}, 3.748370435122093*^9, {3.748370487533835*^9, 
   3.748370487814623*^9}, {3.748370591923375*^9, 3.7483705922499657`*^9}, {
   3.74837067792865*^9, 3.7483706781197844`*^9}, 3.7491330673475833`*^9, {
   3.749152773972011*^9, 3.7491527869173703`*^9}, {3.7492446534449964`*^9, 
   3.7492446567410946`*^9}, 3.749283804485047*^9},
 ExpressionUUID -> "56930096-319d-4d45-b5d5-c082ff58afa2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQrXgp8OPGslf2Oh+eq+4L0HVgAIMP9plz+q2+TteA
8n/YSxar5s2QVIbyGRzOOBXEbGBUgPJZHKSP7phU+EsayudwyLf6PI9NVhLK
53Eo+JPTJPVNDMoXcAg2lFxk7C4K5Qs5mK3KuLvjtTCUL+JwV9TeeecZIShf
zMHlzb9Q/tuCUL6Ew5ZDUkH+PDC+lMMKuf1/+SIFoHwZh4937BYcKueH8uUc
Jj1Xfp6VyAflKzicCb98914GL5Sv6ND6vDHCvZMHyldy0LS5tPbCPm4oX9nh
uVDSikw2GF/F4UmGht7UWC4HAP/qUTc=
        "]],
       FontFamily->"Times"]}}, {
     {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[1.6], 
      Dashing[{}], CapForm["Butt"], 
      StyleBox[GeometricTransformationBox[InsetBox[
         GraphicsBox[
          {GrayLevel[0], PointSize[0.019444444444444445`], AbsoluteThickness[
           1.6], Dashing[{}], CapForm["Butt"], 
           StyleBox[DiskBox[{0, 0}, Offset[{2.75, 2.75}, {0., 0.}]],
            FontFamily->"Times"]}], {0., 0.}], CompressedData["
1:eJxTTMoPSmVmYGAQAWJGIGZigIEP9plz+q2+TtdwgPB/2EsWq+bNkFSG8hkc
zjgVxGxgVIDyWRykj+6YVPhLGsrncMi3+jyPTVYSyudxKPiT0yT1TQzKF3AI
NpRcZOwuCuULOZityri747UwlC/icFfU3nnnGSEoX8zB5c2/UP7bglC+hMOW
Q1JB/jwwvpTDCrn9f/kiBaB8GYePd+wWHCrnh/LlHCY9V36elcgH5Ss4nAm/
fPdeBi+Ur+jQ+rwxwr2TB8pXctC0ubT2wj5uKF/Z4blQ0opMNhhfxeFJhobe
1FguB8VLgR83lr2y1/nwXHVfgK4DAM6HUTk=
        "]],
       FontFamily->"Times"]}, {}}}, {}, {}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {0, 14.657700714648023`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.749255361582118*^9, 3.7500078012165403`*^9, 
  3.7537510722339582`*^9}]
}, Open  ]]
},
Evaluator->"Local",
WindowSize->{1520, 781},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 690, 13, 90, "Input"],
Cell[1251, 35, 184, 3, 43, "Text"],
Cell[1438, 40, 140, 1, 31, "Text"],
Cell[1581, 43, 534, 9, 41, "Text"],
Cell[2118, 54, 686, 11, 41, "Text"],
Cell[2807, 67, 84, 1, 23, "Text"],
Cell[2894, 70, 16, 0, 23, "Text"],
Cell[CellGroupData[{
Cell[2935, 74, 214, 3, 31, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[3152, 79, 376, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[3531, 88, 277, 4, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[3811, 94, 548, 9, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[4362, 105, 627, 12, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[4992, 119, 651, 11, 41, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[5646, 132, 325, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[5974, 141, 829, 17, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[6840, 163, 378, 5, 31, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[7221, 170, 317, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[7541, 178, 635, 16, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[8179, 196, 987, 15, 59, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[9169, 213, 742, 17, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[9914, 232, 799, 17, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[10716, 251, 293, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[11012, 258, 527, 12, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[11542, 272, 437, 8, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[11982, 282, 1928, 32, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[13913, 316, 580, 13, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[14496, 331, 412, 8, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[14911, 341, 1922, 32, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[16836, 375, 222, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[17061, 380, 494, 14, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[17558, 396, 234, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[17795, 403, 208, 4, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[18006, 409, 4542, 117, 83, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[22551, 528, 253, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[22807, 533, 400, 10, 56, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[23210, 545, 284, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[23497, 552, 254, 4, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[23754, 558, 2381, 45, 87, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[26138, 605, 463, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[26604, 615, 885, 23, 54, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[27492, 640, 259, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[27754, 645, 378, 7, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[28135, 654, 433, 8, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[28571, 664, 1203, 32, 30, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[29789, 699, 286, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[30100, 707, 217, 3, 31, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[30320, 712, 655, 11, 41, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[30978, 725, 2698, 73, 66, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[33679, 800, 260, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[33942, 808, 455, 9, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[34400, 819, 211, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[34614, 824, 1105, 26, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[35722, 852, 218, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[35943, 857, 4085, 93, 106, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[40031, 952, 212, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[40246, 957, 839, 17, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[41122, 979, 214, 3, 31, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[41339, 984, 274, 5, 26, "Subsubsection",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[41616, 991, 515, 9, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[42134, 1002, 2270, 54, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[44407, 1058, 2584, 55, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[46994, 1115, 1047, 17, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[48044, 1134, 2444, 58, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[50491, 1194, 312, 4, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[50806, 1200, 6415, 92, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[57224, 1294, 4891, 72, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[62118, 1368, 3840, 57, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[65961, 1427, 4358, 64, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[70322, 1493, 6470, 93, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[76795, 1588, 4942, 72, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[81740, 1662, 3895, 58, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[85638, 1722, 4413, 65, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[90054, 1789, 636, 12, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[90693, 1803, 213, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[90909, 1808, 256, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[91168, 1816, 784, 15, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[91955, 1833, 241, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[92199, 1839, 281, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[92483, 1847, 2824, 63, 84, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[95310, 1912, 213, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[95526, 1917, 667, 11, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[96196, 1930, 434, 12, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[96633, 1944, 284, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[96920, 1951, 3856, 95, 138, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[100779, 2048, 297, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[101079, 2054, 382, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[101464, 2063, 1127, 20, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[102594, 2085, 462, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[103059, 2095, 1127, 18, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[104189, 2115, 446, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[104638, 2125, 585, 12, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[105238, 2140, 1861, 49, 35, "Output"],
Cell[CellGroupData[{
Cell[107124, 2193, 1063, 16, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[108190, 2211, 319, 8, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[108512, 2221, 1569, 39, 48, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[110084, 2262, 1025, 15, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[111112, 2279, 1004, 15, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[112119, 2296, 2460, 58, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[114582, 2356, 995, 16, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[115580, 2374, 1167, 20, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[116750, 2396, 2557, 59, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[119310, 2457, 256, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[119569, 2463, 578, 10, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[120150, 2475, 788, 16, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[120941, 2493, 480, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[121424, 2503, 1232, 20, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[122659, 2525, 13849, 381, 347, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[136511, 2908, 318, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[136832, 2916, 390, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[137225, 2925, 1715, 30, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[138943, 2957, 943, 19, 48, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[139889, 2978, 375, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[140267, 2987, 3381, 66, 102, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[143651, 3055, 177, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[143831, 3060, 1343, 20, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[145177, 3082, 718, 11, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[145898, 3095, 539, 9, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[146440, 3106, 2010, 36, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[148453, 3144, 2430, 57, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[150886, 3203, 386, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[151275, 3212, 219, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[151497, 3217, 635, 10, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[152135, 3229, 6326, 159, 156, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[158464, 3390, 223, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[158690, 3395, 281, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[158974, 3403, 1930, 33, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[160907, 3438, 7338, 199, 152, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[168248, 3639, 596, 10, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[168847, 3651, 1707, 25, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[170557, 3678, 789, 18, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[171349, 3698, 282, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[171634, 3705, 1750, 26, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[173387, 3733, 462, 7, 31, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[173852, 3742, 355, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[174210, 3751, 1796, 28, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[176021, 3782, 212, 3, 31, "Output"],
Cell[CellGroupData[{
Cell[176258, 3789, 334, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[176595, 3797, 1529, 25, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[178127, 3824, 332, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[178496, 3836, 177, 3, 29, "Input"],
Cell[178676, 3841, 248, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178961, 3851, 2320, 43, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[181284, 3896, 3063, 69, 242, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[184362, 3968, 116, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[184503, 3973, 1946, 30, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[186452, 4005, 422, 6, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[186889, 4014, 130, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[187044, 4019, 2792, 50, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[189839, 4071, 3123, 71, 245, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[192965, 4144, 269, 4, 22, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[193249, 4151, 214, 3, 22, "Text"],
Cell[193466, 4156, 202, 2, 31, "Text"],
Cell[CellGroupData[{
Cell[193693, 4162, 191, 3, 26, "Subsubsection"],
Cell[193887, 4167, 484, 8, 23, "Text"],
Cell[CellGroupData[{
Cell[194396, 4179, 4077, 109, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[198476, 4290, 4470, 113, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[202949, 4405, 3890, 103, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[206842, 4510, 4451, 114, 91, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[211330, 4629, 312, 4, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[211645, 4635, 6415, 92, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[218063, 4729, 4891, 72, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[222957, 4803, 3840, 57, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[226800, 4862, 4358, 64, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[231161, 4928, 6470, 93, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[237634, 5023, 4942, 72, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[242579, 5097, 3895, 58, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[246477, 5157, 4413, 65, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[250893, 5224, 636, 12, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[251532, 5238, 213, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[251748, 5243, 256, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[252007, 5251, 784, 15, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[252794, 5268, 241, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[253038, 5274, 281, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[253322, 5282, 2824, 63, 84, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[256149, 5347, 213, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[256365, 5352, 670, 11, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[257038, 5365, 434, 12, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[257475, 5379, 284, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[257762, 5386, 4058, 100, 138, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[261835, 5489, 217, 3, 27, "Text"],
Cell[262055, 5494, 302, 6, 23, "Text"],
Cell[262360, 5502, 1044, 18, 29, "Input"],
Cell[263407, 5522, 381, 7, 23, "Text"],
Cell[263791, 5531, 1050, 17, 29, "Input"],
Cell[264844, 5550, 361, 6, 23, "Text"],
Cell[CellGroupData[{
Cell[265230, 5560, 504, 10, 29, "Input"],
Cell[265737, 5572, 2647, 68, 35, "Output"]
}, Open  ]],
Cell[268399, 5643, 1060, 16, 23, "Text"],
Cell[CellGroupData[{
Cell[269484, 5663, 341, 8, 29, "Input"],
Cell[269828, 5673, 1513, 38, 48, "Output"]
}, Open  ]],
Cell[271356, 5714, 941, 14, 23, "Text"],
Cell[CellGroupData[{
Cell[272322, 5732, 999, 14, 29, "Input"],
Cell[273324, 5748, 2890, 71, 35, "Output"]
}, Open  ]],
Cell[276229, 5822, 906, 14, 23, "Text"],
Cell[CellGroupData[{
Cell[277160, 5840, 1112, 19, 29, "Input"],
Cell[278275, 5861, 2963, 72, 35, "Output"]
}, Open  ]],
Cell[281253, 5936, 175, 2, 27, "Text"],
Cell[281431, 5940, 525, 9, 23, "Text"],
Cell[281959, 5951, 757, 15, 29, "Input"],
Cell[282719, 5968, 427, 7, 23, "Text"],
Cell[283149, 5977, 1232, 20, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[284384, 5999, 14941, 429, 324, "Output"],
Cell[299328, 6430, 82, 1, 23, "Text"],
Cell[299413, 6433, 237, 4, 23, "Text"],
Cell[299653, 6439, 309, 5, 23, "Text"],
Cell[299965, 6446, 1716, 30, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[301684, 6478, 1094, 21, 48, "Output"],
Cell[302781, 6501, 294, 5, 23, "Text"],
Cell[303078, 6508, 3373, 66, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[306454, 6576, 96, 1, 23, "Text"],
Cell[306553, 6579, 1291, 19, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[307847, 6600, 809, 12, 29, "Output"],
Cell[308659, 6614, 569, 9, 41, "Text"],
Cell[309231, 6625, 2432, 42, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[311666, 6669, 3136, 77, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[314805, 6748, 306, 6, 23, "Text"],
Cell[315114, 6756, 136, 1, 27, "Text"],
Cell[315253, 6759, 549, 9, 23, "Text"],
Cell[315805, 6770, 6559, 161, 156, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[322367, 6933, 395, 8, 21, "Message"],
Cell[322765, 6943, 395, 8, 21, "Message"],
Cell[323163, 6953, 140, 1, 27, "Text"],
Cell[323306, 6956, 198, 4, 23, "Text"],
Cell[323507, 6962, 1902, 33, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[325412, 6997, 7356, 199, 152, "Output"],
Cell[332771, 7198, 517, 9, 23, "Text"],
Cell[333291, 7209, 1651, 24, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[334945, 7235, 711, 17, 29, "Output"],
Cell[335659, 7254, 204, 4, 23, "Text"],
Cell[335866, 7260, 1748, 26, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[337617, 7288, 380, 5, 31, "Output"],
Cell[338000, 7295, 274, 6, 23, "Text"],
Cell[338277, 7303, 1721, 27, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[340001, 7332, 348, 5, 31, "Output"],
Cell[340352, 7339, 253, 5, 23, "Text"],
Cell[340608, 7346, 1501, 25, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[342112, 7373, 251, 6, 23, "Text"],
Cell[342366, 7381, 2194, 42, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[344563, 7425, 2883, 66, 242, "Output"],
Cell[347449, 7493, 116, 1, 23, "Text"],
Cell[347568, 7496, 1866, 29, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[349437, 7527, 344, 5, 29, "Output"],
Cell[349784, 7534, 130, 1, 23, "Text"],
Cell[349917, 7537, 2563, 45, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[352483, 7584, 3072, 70, 245, "Output"],
Cell[355558, 7656, 190, 3, 22, "Text"],
Cell[CellGroupData[{
Cell[355773, 7663, 161, 2, 31, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[355937, 7667, 272, 5, 26, "Subsubsection",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[356212, 7674, 568, 10, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[356783, 7686, 7560, 203, 194, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[364346, 7891, 9096, 248, 244, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[373445, 8141, 7021, 193, 173, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[380469, 8336, 8281, 211, 241, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[388787, 8552, 338, 5, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[389128, 8559, 6441, 93, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[395572, 8654, 4913, 72, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[400488, 8728, 3866, 58, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[404357, 8788, 4380, 64, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[408740, 8854, 6492, 93, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[415235, 8949, 4968, 73, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[420206, 9024, 3917, 58, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[424126, 9084, 4435, 65, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[428564, 9151, 658, 12, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[429225, 9165, 235, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[429463, 9170, 278, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[429744, 9178, 810, 16, 31, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[430557, 9196, 263, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[430823, 9202, 303, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[431129, 9210, 2846, 63, 84, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[433978, 9275, 235, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[434216, 9280, 716, 11, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[434935, 9293, 569, 16, 43, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[435507, 9311, 310, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}],
Cell[435820, 9319, 4080, 100, 138, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[439937, 9424, 345, 5, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[440285, 9431, 454, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[440742, 9441, 1225, 21, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[441970, 9464, 512, 9, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[442485, 9475, 1179, 19, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[443667, 9496, 492, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[444162, 9506, 723, 14, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[444888, 9522, 2828, 71, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[447719, 9595, 1176, 19, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[448898, 9616, 513, 11, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[449414, 9629, 1052, 31, 48, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[450469, 9662, 1073, 16, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[451545, 9680, 1095, 16, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[452643, 9698, 2489, 65, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[455135, 9765, 1043, 16, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[456181, 9783, 1238, 21, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}],
Cell[457422, 9806, 2487, 65, 35, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10004.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[459946, 9876, 279, 4, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[460228, 9882, 694, 12, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[460925, 9896, 859, 17, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[461787, 9915, 508, 9, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[462298, 9926, 1276, 20, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[463577, 9948, 14971, 430, 324, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[478551, 10380, 342, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[478896, 10388, 412, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[479323, 10398, 1796, 32, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[481122, 10432, 624, 14, 48, "Output"],
Cell[481749, 10448, 298, 5, 23, "Text"],
Cell[CellGroupData[{
Cell[482072, 10457, 3447, 66, 102, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[485522, 10525, 201, 3, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[485726, 10530, 1445, 21, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[487186, 10554, 154, 2, 29, "Output"],
Cell[CellGroupData[{
Cell[487365, 10560, 678, 11, 41, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[488046, 10573, 2281, 40, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[490342, 10616, 2576, 69, 35, "Output"],
Cell[CellGroupData[{
Cell[492943, 10689, 414, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[493360, 10699, 243, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[493606, 10704, 661, 11, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[494282, 10718, 6388, 160, 102, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[500673, 10880, 397, 8, 21, "Message"],
Cell[501073, 10890, 397, 8, 21, "Message"],
Cell[CellGroupData[{
Cell[501495, 10902, 247, 3, 27, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[501745, 10907, 305, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[502053, 10915, 1979, 34, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[504035, 10951, 7336, 199, 152, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[511374, 11152, 620, 10, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[511997, 11164, 1679, 24, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[513679, 11190, 740, 17, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[514422, 11209, 308, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[514733, 11217, 1769, 26, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[516505, 11245, 404, 6, 31, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[516912, 11253, 375, 7, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[517290, 11262, 1772, 28, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[519065, 11292, 405, 6, 31, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[519473, 11300, 356, 6, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[519832, 11308, 1546, 25, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[521381, 11335, 356, 8, 23, "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[521752, 11346, 2268, 43, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[524023, 11391, 2838, 66, 242, "Output"],
Cell[526864, 11459, 175, 2, 23, "Text"],
Cell[527042, 11463, 1970, 31, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[529015, 11496, 111, 1, 31, "Output"],
Cell[CellGroupData[{
Cell[529151, 11501, 1944, 30, 29, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}],
Cell[531098, 11533, 366, 5, 29, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10002.}]
}, Open  ]],
Cell[531479, 11541, 135, 1, 23, "Text"],
Cell[531617, 11544, 2561, 45, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[534181, 11591, 2532, 62, 220, "Output"],
Cell[536716, 11655, 178, 2, 23, "Text"],
Cell[536897, 11659, 2537, 45, 29, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[539437, 11706, 2932, 68, 245, "Output"]
}, Open  ]]
}
]
*)

