(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     74094,       1954]
NotebookOptionsPosition[     71449,       1872]
NotebookOutlinePosition[     71793,       1887]
CellTagsIndexPosition[     71750,       1884]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractTrigs", "[", "expression_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr", "=", "expression"}], ",", 
      RowBox[{"components", "=", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"expr", "[", 
          RowBox[{"[", "0", "]"}], "]"}], "]"}], "\[NotEqual]", " ", 
        RowBox[{"ToString", "[", "Times", "]"}]}], " ", ",", 
       RowBox[{"expr", "=", 
        RowBox[{"{", "expr", "}"}]}]}], "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"expr", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "\[Equal]", "Times"}], ",", 
       RowBox[{
        RowBox[{"expr", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "=", "List"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"components", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"Apply", "[", 
       RowBox[{"Times", ",", 
        RowBox[{"Cases", "[", 
         RowBox[{"expr", ",", 
          RowBox[{
           RowBox[{"Sin", "[", "_", "]"}], "|", 
           RowBox[{"Cos", "[", "_", "]"}]}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"(*", 
      RowBox[{
      "This", " ", "obtains", " ", "the", " ", "trigonometric", " ", 
       "functions"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"components", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"Apply", "[", 
       RowBox[{"Times", ",", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"expr", ",", 
          RowBox[{
           RowBox[{"Sin", "[", "_", "]"}], "|", 
           RowBox[{"Cos", "[", "_", "]"}]}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"(*", 
      RowBox[{
      "This", " ", "gives", " ", "the", " ", "remaining", " ", "factor"}], 
      "*)"}], "\[IndentingNewLine]", "components"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6653092065001583`*^9, {3.665433338210455*^9, 3.6654333410941133`*^9}, 
   3.716181760556937*^9, {3.716622131769775*^9, 3.716622138417308*^9}, {
   3.7199167863377266`*^9, 3.719916840922812*^9}, {3.7199314415108724`*^9, 
   3.719931500172189*^9}, 3.720087026875539*^9, {3.7201773120782566`*^9, 
   3.7201773363615446`*^9}, {3.720177445491597*^9, 3.7201774670385838`*^9}, 
   3.720808932865016*^9},
 ExpressionUUID -> "35dd9c69-e52a-4db1-af18-9091e85700a6"],

Cell[TextData[{
 StyleBox["ExtractTrigs", "Output"],
 " extracts the trigonometric factors from a single term:"
}], "Text",
 CellChangeTimes->{{3.716620906509306*^9, 3.716620946046174*^9}, {
   3.7166212780270443`*^9, 3.716621280075304*^9}, 3.7166216730825872`*^9, {
   3.7166221317695827`*^9, 3.716622138417109*^9}, 3.7198242970964985`*^9, {
   3.7198246720837226`*^9, 3.7198246754923334`*^9}, 3.720093844225182*^9, 
   3.720808932865016*^9},
 ExpressionUUID -> "918af59b-8b00-4064-864f-026fa73194c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtractTrigs", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "x"}], "]"}], 
   SuperscriptBox["z", "2"]}], "]"}]], "Input",
 CellChangeTimes->{{3.7198242469764967`*^9, 3.7198242775951633`*^9}},
 ExpressionUUID -> "263f7865-b561-4c7f-9715-b3421129da3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "x"}], "]"}], ",", 
   SuperscriptBox["z", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.7198242790912795`*^9, 3.7198278082641597`*^9, 
  3.7198726829244585`*^9, 3.719903151195593*^9, 3.7200953684197474`*^9, 
  3.7201694770767946`*^9, 3.720543788861768*^9, 3.7206410537296734`*^9, 
  3.7348566766356897`*^9, 3.7348772690111513`*^9, 3.7349001615527487`*^9, 
  3.734931712003724*^9, 3.7350190563851104`*^9, 3.735127359835239*^9, 
  3.7351479283246007`*^9, 3.735362245376346*^9, 3.7353819871979127`*^9, 
  3.7354055630650663`*^9, 3.735416188307541*^9, 3.735454107816558*^9, 
  3.7354543797665167`*^9, 3.735454522597786*^9, 3.735481795207961*^9, 
  3.7360049922569942`*^9, 3.7365329764126306`*^9, 3.736868606410504*^9, 
  3.7501939346283846`*^9},
 ExpressionUUID -> "9807ce3b-d49c-43d7-9515-2c0b24c1b6b0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumToList", "[", "sum_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"list", "=", "sum"}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"list", "[", 
          RowBox[{"[", "0", "]"}], "]"}], "]"}], "\[NotEqual]", " ", 
        RowBox[{"ToString", "[", "Plus", "]"}]}], ",", 
       RowBox[{"list", "=", 
        RowBox[{"{", "list", "}"}]}], ",", 
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "=", "List"}]}], "]"}], ";", 
     "list"}]}], "]"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{
  3.718369585419119*^9, 3.719822413141817*^9, {3.7199168897850485`*^9, 
   3.7199169033168564`*^9}},
 ExpressionUUID -> "10594e0d-2831-4fba-94b7-1e1d7ce3ba71"],

Cell[TextData[{
 StyleBox["SumToList", "Output"],
 " converts a summation in to a list consists of each term in the summation:"
}], "Text",
 CellChangeTimes->{{3.7198226091978526`*^9, 3.7198226142621903`*^9}, {
   3.719822726965743*^9, 3.7198227616871867`*^9}, {3.7198228130614023`*^9, 
   3.7198228659600077`*^9}, {3.719822896186121*^9, 3.719822912557891*^9}, {
   3.719823453649412*^9, 3.719823464516035*^9}, 3.7198243057993646`*^9},
 ExpressionUUID -> "b0fd7a86-af8c-46a9-bb8a-bf82d075cf8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumToList", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input",
 CellChangeTimes->{{3.71982432767206*^9, 3.7198243343876734`*^9}},
 ExpressionUUID -> "44ed1395-8015-4e69-87c4-fe5b60a3d695"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 CellChangeTimes->{3.719824334763322*^9, 3.7198278082851734`*^9, 
  3.719872682957982*^9, 3.7199031512174883`*^9, 3.7200953685358295`*^9, 
  3.7201694770908127`*^9, 3.7205437888792934`*^9, 3.7206410537536807`*^9, 
  3.7348566767066193`*^9, 3.734877269103758*^9, 3.7349001616152487`*^9, 
  3.734931712112809*^9, 3.735019056512209*^9, 3.735127360067905*^9, 
  3.735147928397627*^9, 3.7353622454857206`*^9, 3.73538198729148*^9, 
  3.735405563207167*^9, 3.735416188409486*^9, 3.735454108172729*^9, 
  3.735454379979034*^9, 3.735454523153944*^9, 3.7354817952880225`*^9, 
  3.7360049923567095`*^9, 3.736532976532534*^9, 3.7368686065042486`*^9, 
  3.7501939346862307`*^9},
 ExpressionUUID -> "f5753ea0-e48f-4fc9-9bca-3ff0705a8095"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalToTrig", "[", "expression_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"ExtractTrigs", ",", 
    RowBox[{"SumToList", "[", 
     RowBox[{"Expand", "[", 
      RowBox[{"TrigReduce", "[", 
       RowBox[{"TrigExpand", "[", 
        RowBox[{"Expand", "[", "expression", "]"}], "]"}], "]"}], "]"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.7183695854193287`*^9, 3.719822414432208*^9, {3.719822505349998*^9, 
   3.719822506744626*^9}, {3.719822546798766*^9, 3.7198225489748297`*^9}, {
   3.719824043160082*^9, 3.7198240484595203`*^9}, {3.720177340073611*^9, 
   3.7201773419219646`*^9}, 3.72080894839365*^9},
 ExpressionUUID -> "0957f68f-4c8a-4c76-9079-5a92b400cc88"],

Cell[TextData[{
 StyleBox["NormalToTrig", "Output"],
 " converts an expression into a list. The first element is the trigonometry \
component. The second is the non-trigonometric expression:"
}], "Text",
 CellChangeTimes->{{3.716620966173333*^9, 3.716621069902986*^9}, {
   3.71662112596102*^9, 3.71662124217913*^9}, 3.716621673082807*^9, {
   3.716622131770009*^9, 3.7166221384175043`*^9}, {3.717405501071909*^9, 
   3.7174055161332946`*^9}, {3.717405820769741*^9, 3.7174058255305834`*^9}, {
   3.719824651225193*^9, 3.7198246586999063`*^9}, 3.72080894839365*^9},
 ExpressionUUID -> "d4bc05d4-ad36-48bc-b239-97c40907baa9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalToTrig", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "z"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "x"}], "]"}], "z"}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "x"}], "]"}], "y"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7198245803500757`*^9, 3.7198246179917793`*^9}},
 ExpressionUUID -> "2e787abd-dd97-4bc8-adb3-7d8667d547b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     SuperscriptBox["y", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "z"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7198246189889493`*^9, 3.719824631795294*^9}, 
   3.719827808305688*^9, 3.719872682991005*^9, 3.719903151238513*^9, 
   3.720095368658922*^9, 3.72016947711346*^9, 3.7205437889111567`*^9, 
   3.720641053769692*^9, 3.734856676804788*^9, 3.734877269211259*^9, 
   3.7349001616777487`*^9, 3.7349317122288923`*^9, 3.735019056645301*^9, 
   3.735127360214007*^9, 3.735147928471706*^9, 3.7353622456031523`*^9, 
   3.7353819873910494`*^9, 3.735405563309246*^9, 3.7354161885032377`*^9, 
   3.735454108540772*^9, 3.735454380145486*^9, 3.735454523497487*^9, 
   3.7354817953690815`*^9, 3.7360049924599032`*^9, 3.7365329766544933`*^9, 
   3.73686860662924*^9, 3.7501939347351*^9},
 ExpressionUUID -> "16d8b2e2-66a6-4516-a661-dfc0bfaf960a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"MergeTrigs", "[", "expression_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr", "=", "expression"}], ",", "trig", ",", "mergedelement", 
      ",", 
      RowBox[{"mergedlist", "=", 
       RowBox[{"{", "}"}]}]}], "}"}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "expr", "]"}], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"trig", "=", 
         RowBox[{
          RowBox[{"expr", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
         "We", " ", "get", " ", "the", " ", "first", " ", "trigonometric", 
          " ", "component", " ", "of", " ", "the", " ", "first", " ", "list", 
          " ", "element", " ", "stored", " ", "in", " ", "trig"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"mergedelement", "=", 
         RowBox[{
          RowBox[{"Total", "[", 
           RowBox[{"Cases", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"{", 
              RowBox[{"trig", ",", "_"}], "}"}]}], "]"}], "]"}], "-", 
          RowBox[{"Total", "[", 
           RowBox[{"Cases", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "trig"}], ",", "_"}], "}"}]}], "]"}], "]"}]}]}], 
        ";", 
        RowBox[{
         RowBox[{"mergedelement", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", "trig"}], ";", 
        RowBox[{"expr", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"expr", ",", 
           RowBox[{"{", 
            RowBox[{"trig", ",", "_"}], "}"}]}], "]"}]}], ";", 
        RowBox[{"expr", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"expr", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "trig"}], ",", "_"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "We", " ", "sum", " ", "all", " ", "the", " ", "element", " ", 
          "which", " ", "has", " ", "the", " ", "same", " ", "trigonometric", 
          " ", "factor", " ", "as", " ", "trig", " ", 
          RowBox[{"(", 
           RowBox[{"or", " ", "its", " ", "negative", " ", "value"}], ")"}], 
          " ", "and", " ", "put", " ", "the", " ", "sum", " ", "and", " ", 
          "its", " ", "trigonemetric", " ", "factor", " ", "in", " ", "one", 
          " ", "element", " ", "discarding", " ", "the", " ", "others"}], " ",
          "*)"}], "\[IndentingNewLine]", 
        RowBox[{"mergedlist", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"mergedlist", ",", 
           RowBox[{"{", "mergedelement", "}"}]}], "]"}]}]}]}], "]"}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "do", " ", "this", " ", "until", " ", "finish", " ", "all", " ", "the", 
       " ", "elements"}], " ", "*)"}], "\[IndentingNewLine]", 
     "mergedlist"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410941133`*^9}, 
   3.665657565000435*^9, {3.667028834364854*^9, 3.667028886023714*^9}, {
   3.667035825825741*^9, 3.6670358689629655`*^9}, {3.667035995495316*^9, 
   3.6670359969941325`*^9}, {3.66703605572631*^9, 3.667036132968751*^9}, {
   3.6670382500368996`*^9, 3.667038272156851*^9}, {3.667047334866377*^9, 
   3.6670473434716535`*^9}, {3.6670474746109743`*^9, 3.667047500890053*^9}, {
   3.66705041851608*^9, 3.667050447449589*^9}, {3.667053187282304*^9, 
   3.667053187749379*^9}, {3.6670532192448573`*^9, 3.6670532490853233`*^9}, {
   3.667053324170595*^9, 3.667053338947866*^9}, {3.6670536581272182`*^9, 
   3.6670536880459366`*^9}, {3.667053875290778*^9, 3.667053883115814*^9}, 
   3.716181760557937*^9, {3.716622131770492*^9, 3.716622138418043*^9}, {
   3.7199323246562805`*^9, 3.7199323289803424`*^9}, {3.7199325269848504`*^9, 
   3.7199327768786173`*^9}, {3.7199328483761315`*^9, 
   3.7199328558976016`*^9}, {3.7200018954734297`*^9, 3.720001930273882*^9}, {
   3.720177344488123*^9, 3.7201773456351194`*^9}, 3.720808944829778*^9, {
   3.748248426411724*^9, 3.748248491990014*^9}, {3.7482485333885403`*^9, 
   3.7482485359596043`*^9}},
 ExpressionUUID -> "d4333b1b-829e-4973-91b7-fb2105eea847"],

Cell[TextData[{
 StyleBox["MergeTrigs", "Output"],
 " merges the ",
 StyleBox["NormalToTrig", "Output"],
 " solutions that have the same trigonometry components together"
}], "Text",
 CellChangeTimes->{{3.716621075010137*^9, 3.716621123184722*^9}, {
   3.716621252387211*^9, 3.716621263803505*^9}, 3.7166213105876904`*^9, 
   3.716621673082963*^9, {3.716622131770307*^9, 3.716622138417815*^9}, {
   3.717405481723254*^9, 3.7174054874369745`*^9}, {3.719824897684675*^9, 
   3.7198248997413645`*^9}, 3.720808944829778*^9},
 ExpressionUUID -> "2cb1e875-b3ec-4b24-bf97-52eaad604023"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MergeTrigs", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      SuperscriptBox["y", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", "z"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.719824907813957*^9, 3.719824915028964*^9}},
 ExpressionUUID -> "f3c193b2-0061-41f3-b51b-6aae2a846038"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], ",", 
     RowBox[{"y", "+", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "z"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.719824915557235*^9, 3.7198278083277035`*^9, 
  3.7198726830230265`*^9, 3.719903151257517*^9, 3.7200953687399797`*^9, 
  3.720169477130472*^9, 3.720543788926193*^9, 3.720641053786206*^9, 
  3.7348566769028788`*^9, 3.734877269316824*^9, 3.734900161755873*^9, 
  3.734931712352951*^9, 3.735019056774886*^9, 3.7351273606013074`*^9, 
  3.7351479285467577`*^9, 3.7353622457119837`*^9, 3.7353819875091634`*^9, 
  3.735405563417346*^9, 3.7354161885969887`*^9, 3.7354541087170887`*^9, 
  3.735454380361107*^9, 3.7354545242418947`*^9, 3.7354817954576387`*^9, 
  3.7360049925702972`*^9, 3.7365329767754107`*^9, 3.7368686067230043`*^9, 
  3.7501939347839694`*^9},
 ExpressionUUID -> "d03144bb-7ddd-4257-8ef9-f0a752544fca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigToNormal", "[", "expression_", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", "expression", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6653092065011587`*^9, {3.665433338210455*^9, 3.6654333410941133`*^9}, 
   3.716181760557937*^9, {3.71662213177075*^9, 3.7166221384183187`*^9}, {
   3.7198225527644887`*^9, 3.719822555007477*^9}, {3.7201773607415037`*^9, 
   3.7201773629577923`*^9}, 3.7208089579337854`*^9},
 ExpressionUUID -> "cd36393f-e2d6-409a-b6bd-08f0db2ac29c"],

Cell[TextData[{
 "TrigToNormal changes (merged) ",
 StyleBox["NormalToTrigs", "Output"],
 " solution to normal form"
}], "Text",
 CellChangeTimes->{{3.716621313556415*^9, 3.716621375661191*^9}, 
   3.716621673083112*^9, {3.716622131770647*^9, 3.716622138418209*^9}, {
   3.7166230668378363`*^9, 3.716623103190399*^9}, {3.717405535072611*^9, 
   3.7174055360860147`*^9}, 3.7198249538722115`*^9, {3.7200939187965546`*^9, 
   3.720093920781209*^9}, 3.7208089579337854`*^9},
 ExpressionUUID -> "f842b919-4066-476f-879e-63975675fe7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToNormal", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], ",", 
      RowBox[{"y", "+", "z"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{
       SuperscriptBox["y", "2"], "+", "z"}]}], "}"}]}], "}"}], "]"}]], "Input",\

 CellChangeTimes->{{3.7198249587190504`*^9, 3.719824966044256*^9}},
 ExpressionUUID -> "224fe34b-415d-4c6f-8097-21607b819980"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["y", "2"], "+", "z"}], ")"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 CellChangeTimes->{3.719824966425416*^9, 3.7198278083472166`*^9, 
  3.7198726830570507`*^9, 3.7199031512765303`*^9, 3.7200953688145313`*^9, 
  3.7201694771464834`*^9, 3.7205437889416914`*^9, 3.720641053801409*^9, 
  3.734856676974863*^9, 3.7348772693978806`*^9, 3.734900161834*^9, 
  3.7349317124730415`*^9, 3.7350190569209948`*^9, 3.7351273607218924`*^9, 
  3.7351479286148076`*^9, 3.7353622458057127`*^9, 3.7353819876016994`*^9, 
  3.735405563509411*^9, 3.7354161886907396`*^9, 3.735454108866091*^9, 
  3.735454380479368*^9, 3.735454524507712*^9, 3.7354817955366955`*^9, 
  3.736004992690327*^9, 3.7365329769033213`*^9, 3.736868606832348*^9, 
  3.7501939348338356`*^9},
 ExpressionUUID -> "5bc08ad7-3a25-43c2-9e56-4210ad2185e5"]
}, Open  ]],

Cell["\<\
We use these function to separate equation with different trigonometry \
components.
For instance, we might encounter \
\>", "Text",
 CellChangeTimes->{{3.716621392684523*^9, 3.7166216102400007`*^9}, 
   3.7166216730831957`*^9, {3.7166221317708387`*^9, 3.716622138418416*^9}, 
   3.7208089628538556`*^9},
 ExpressionUUID -> "9c2e778a-620e-4650-81a9-fda247e29983"],

Cell[BoxData[
 RowBox[{
  RowBox[{"testequation", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"k", " ", "x"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "z", "]"}], "+", 
        RowBox[{"g", "[", "z", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "k", " ", "x"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"g", "'"}], "[", "z", "]"}], "-", "1"}], ")"}]}]}], 
    "\[Equal]", "0"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.716621590849989*^9, 3.7166216005601892`*^9}, 
   3.7166216730834627`*^9, {3.71662213177094*^9, 3.716622138418523*^9}, {
   3.716622996325542*^9, 3.716623001668976*^9}, 3.7208089628538556`*^9},
 ExpressionUUID -> "9adac8cf-b280-41fc-a646-abec5d7161fe"],

Cell["We can use ", "Text",
 CellChangeTimes->{{3.716621614991836*^9, 3.71662161717589*^9}, 
   3.716621673083568*^9, {3.716622131771027*^9, 3.716622138418618*^9}, 
   3.7208089628538556`*^9},
 ExpressionUUID -> "a51f5ec6-f400-4137-9a1f-380cd264c343"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"testsolution", "=", 
  RowBox[{"MergeTrigs", "[", 
   RowBox[{"NormalToTrig", "[", 
    RowBox[{"testequation", "/.", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "==", "b_"}], ")"}], "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.716621626301255*^9, 3.716621673083684*^9}, {
   3.7166221317711267`*^9, 3.716622138418724*^9}, {3.716623004973325*^9, 
   3.7166230418136873`*^9}, {3.716623112566934*^9, 3.716623115758732*^9}, 
   3.7208089628538556`*^9},
 ExpressionUUID -> "0631e6dd-3b54-4a18-b282-1e0c5e696cbb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"k", " ", "x"}], "]"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "z", "]"}], "+", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "k", " ", "x"}], "]"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7166230422407227`*^9, 3.7166231162339897`*^9, 3.716623170120408*^9, {
   3.7166301122028637`*^9, 3.7166301228348417`*^9}, 3.716630222123621*^9, 
   3.7166634350684967`*^9, 3.7167044009821453`*^9, 3.716709952419958*^9, 
   3.7167106989010105`*^9, 3.716759839162341*^9, 3.7167892040908165`*^9, 
   3.7168051454311285`*^9, 3.7168349584613204`*^9, 3.717009330971882*^9, 
   3.7173433296794806`*^9, 3.717429341431024*^9, 3.717496179379771*^9, 
   3.7176015023056374`*^9, 3.7177569002383585`*^9, 3.7178596887351875`*^9, 
   3.7181033207984543`*^9, 3.7181327595480146`*^9, 3.7181829522376833`*^9, 
   3.7182629834781923`*^9, 3.7183647904556437`*^9, 3.7183695680343227`*^9, 
   3.718372890778311*^9, 3.718445642363675*^9, 3.7184542504317627`*^9, 
   3.718531273253422*^9, 3.7187052416920023`*^9, 3.7191498309141006`*^9, 
   3.719580777644556*^9, 3.7195961213396425`*^9, 3.719665530330488*^9, 
   3.719827808366747*^9, 3.7198726831215973`*^9, 3.7199031513181696`*^9, 
   3.7200953689336147`*^9, 3.7201694771836967`*^9, 3.720543788976281*^9, 
   3.720641053843438*^9, 3.7208089628543563`*^9, 3.734856677059319*^9, 
   3.7348772696916614`*^9, 3.734900161959004*^9, 3.7349317125951214`*^9, 
   3.7350190570635967`*^9, 3.735127360943022*^9, 3.735147928785904*^9, 
   3.7353622459932375`*^9, 3.735381987690262*^9, 3.7354055636755004`*^9, 
   3.7354161888313675`*^9, 3.735454109076611*^9, 3.735454380597291*^9, 
   3.735454524782992*^9, 3.7354817956833096`*^9, 3.7360049928263645`*^9, 
   3.736532977024251*^9, 3.736868606988589*^9, 3.750193934879713*^9},
 ExpressionUUID -> "5cd28669-6228-49e0-bcd6-9d6c5ba126c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{"testsolution", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[Rule]", "b"}], ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.716623117182106*^9, 3.716623170120675*^9}, 
   3.7208089628543563`*^9},
 ExpressionUUID -> "77b88196-6484-41b3-967f-ddae23b84b5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", "z", "]"}], "+", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{
     SuperscriptBox["g", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.716623134515176*^9, 3.716623170120936*^9}, 
   3.716630112218484*^9, 3.7166302234401956`*^9, 3.716663435077504*^9, 
   3.7167044009911385`*^9, 3.716709952436984*^9, 3.7167106989335346`*^9, 
   3.716759839162341*^9, 3.716789204107975*^9, 3.716805145447641*^9, 
   3.716834958479334*^9, 3.717009330990896*^9, 3.71734332968847*^9, 
   3.7174293414440145`*^9, 3.717496179389345*^9, 3.717601502316655*^9, 
   3.717756900261875*^9, 3.717859688746196*^9, 3.718103320897874*^9, 
   3.7181327595660152`*^9, 3.718182952372158*^9, 3.7182629834938345`*^9, 
   3.7183647904853287`*^9, 3.718369568045005*^9, 3.718372890837365*^9, 
   3.7184456424755898`*^9, 3.718454250524632*^9, 3.718531273418256*^9, 
   3.7187052417516317`*^9, 3.719149830964342*^9, 3.719580777802882*^9, 
   3.71959612135271*^9, 3.719665530387162*^9, 3.719827808381241*^9, 
   3.7198726831361065`*^9, 3.7199031513281765`*^9, 3.7200953689821496`*^9, 
   3.720169477191204*^9, 3.720543788989288*^9, 3.7206410538514433`*^9, 
   3.7208089628543563`*^9, 3.7348566771156397`*^9, 3.7348772697387247`*^9, 
   3.7349001619902515`*^9, 3.734931712656169*^9, 3.735019057137173*^9, 
   3.735127361015072*^9, 3.735147928821929*^9, 3.735362246055738*^9, 
   3.735381987750806*^9, 3.735405563729538*^9, 3.7354161888782425`*^9, 
   3.735454109168437*^9, 3.735454380752729*^9, 3.7354545249746103`*^9, 
   3.7354817957253585`*^9, 3.736004992905175*^9, 3.736532977092213*^9, 
   3.736868607051076*^9, 3.7501939349016542`*^9},
 ExpressionUUID -> "c4a47c61-6823-48dc-af7c-50603b4bda34"]
}, Open  ]],

Cell["to obtain the equations to solve.", "Text",
 CellChangeTimes->{{3.7166216574165688`*^9, 3.71662167308379*^9}, {
   3.7166221317712173`*^9, 3.716622138418824*^9}, 3.7208089628543563`*^9},
 ExpressionUUID -> "591c032b-1f21-4dc8-b6a1-c0774238b1e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", "z", "]"}], "+", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        SuperscriptBox["g", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], "}"}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], ",", 
     RowBox[{"g", "[", "z", "]"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.719825176953965*^9, 3.719825217009173*^9}},
 ExpressionUUID -> "fda858e7-892f-423f-8f4d-a599dd53b35e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["z", "2"], "2"]}], "+", 
      RowBox[{"C", "[", "1", "]"}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"g", "[", "z", "]"}], "\[Rule]", 
     RowBox[{"z", "+", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.7198251969598446`*^9, 3.719825217441181*^9}, 
   3.719827808398766*^9, 3.7198726832937183`*^9, 3.719903151435478*^9, 
   3.7200953692103095`*^9, 3.7201694772988243`*^9, 3.720543789083686*^9, 
   3.720641053931817*^9, 3.734856677201079*^9, 3.734877270048524*^9, 
   3.7349001622246284`*^9, 3.734931712725241*^9, 3.7350190573933225`*^9, 
   3.735127361141161*^9, 3.735147929069131*^9, 3.735362246540124*^9, 
   3.7353819878218575`*^9, 3.735405564028781*^9, 3.7354161892219973`*^9, 
   3.735454109390073*^9, 3.735454380884728*^9, 3.735454525617794*^9, 
   3.735481796171645*^9, 3.7360049931784363`*^9, 3.7365329772771106`*^9, 
   3.7368686073323135`*^9, 3.750193947355647*^9},
 ExpressionUUID -> "d361aed7-aaba-498c-a129-c109c696e46d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateTrig", "[", "expression_", "]"}], ":=", 
  RowBox[{"MergeTrigs", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"NormalToTrig", "[", 
      RowBox[{"Expand", "[", "expression", "]"}], "]"}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.735102827237501*^9, 3.735102829495019*^9}, {
   3.7351028809304066`*^9, 3.7351029023988113`*^9}, {3.7351056237223253`*^9, 
   3.7351056446329193`*^9}, {3.735105816314085*^9, 3.735105821005765*^9}, 
   3.735106500823453*^9, {3.735106629788351*^9, 3.735106630122664*^9}, {
   3.735107454010366*^9, 3.7351074577490664`*^9}, {3.7351074924699526`*^9, 
   3.7351074942157044`*^9}},
 ExpressionUUID -> "596daa60-02c5-43fd-b2eb-7710f70efcfb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigSimplify1", "[", 
   RowBox[{"expression_", ",", "function_"}], "]"}], ":=", 
  RowBox[{"TrigToNormal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReleaseHold", "[", 
     RowBox[{"Replace", "[", 
      RowBox[{
       RowBox[{"ReleaseHold", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SeparateTrig", "[", "expression", "]"}], "/.", 
          "derivativehelp"}], "/.", "function"}], "]"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a_", ",", "b_"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"Hold", "[", 
           RowBox[{"ExpSimplify", "[", "b", "]"}], "]"}]}], "}"}]}], ",", 
       "1"}], "]"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7353662497460394`*^9, 3.7353662605784597`*^9}, 
   3.7497985367014775`*^9},
 ExpressionUUID -> "2f4a5144-a1d3-4dab-b078-17f95f61eef8"],

Cell[TextData[{
 StyleBox["TrigSimplify", "Output"],
 " separate terms with different trigonometry components, substitute \
function, then simplify each separated terms using ",
 StyleBox["ExpSimplify", "Output"],
 "."
}], "Text",
 CellChangeTimes->{{3.7215536991486998`*^9, 3.7215537175885057`*^9}, 
   3.7215555365146255`*^9, {3.7355402772876315`*^9, 3.7355402852850237`*^9}},
 ExpressionUUID -> "cfe9668a-ea0e-4e08-ab50-cc799fc77dfd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigSimplify2", "[", "expression_", "]"}], ":=", 
  RowBox[{"TrigToNormal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeparateTrig", "[", "expression", "]"}], "]"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.74826626743495*^9, 3.7482662857860327`*^9}, {
   3.748266326502492*^9, 3.74826632821286*^9}, {3.7482663847077293`*^9, 
   3.748266405680664*^9}, 3.7497985397008095`*^9, 3.749802225073243*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigSimplify3", "[", "expression_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"expression", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "===", "SeriesData"}], ",", 
    RowBox[{"expression", "/.", 
     RowBox[{
      RowBox[{"expression", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "  ", 
      RowBox[{"Map", "[", 
       RowBox[{"TrigSimplify2", ",", 
        RowBox[{"expression", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]}], ",", 
    RowBox[{"TrigSimplify2", "[", "expression", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748268741225869*^9, 3.748268832992455*^9}, 
   3.748269288709629*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigSimplify", "[", "expression_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"expression", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "===", "List"}], ",", " ", 
    RowBox[{"Map", "[", 
     RowBox[{"TrigSimplify3", ",", "expression"}], "]"}], ",", 
    RowBox[{"TrigSimplify3", "[", "expression", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748268496857723*^9, 3.748268506521491*^9}, {
   3.748268542217801*^9, 3.7482685745675087`*^9}, {3.748268691180874*^9, 
   3.748268735415121*^9}, {3.748269283173394*^9, 3.7482692856372957`*^9}, 
   3.7497985455745516`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7355402555632734`*^9, 3.7355402564833117`*^9}}],

Cell["\tSimilarly, for exponential, we have", "Text",
 CellChangeTimes->{{3.716664966258334*^9, 3.71666497598167*^9}, 
   3.7167106940724306`*^9, 3.720808969004922*^9, 3.735540231767598*^9},
 ExpressionUUID -> "c0f87e54-e404-44b9-9db0-d6aa292ed0d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractExponential", "[", "expression_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr", "=", "expression"}], ",", 
      RowBox[{"components", "=", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"expr", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "\[Equal]", " ", "Power"}], ",", 
       RowBox[{"expr", "=", 
        RowBox[{"{", "expr", "}"}]}]}], "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"expr", "[", 
          RowBox[{"[", "0", "]"}], "]"}], "]"}], "\[NotEqual]", " ", 
        RowBox[{"ToString", "[", "Times", "]"}]}], " ", ",", 
       RowBox[{"expr", "=", 
        RowBox[{"{", "expr", "}"}]}]}], "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"expr", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "\[Equal]", "Times"}], ",", 
       RowBox[{
        RowBox[{"expr", "[", 
         RowBox[{"[", "0", "]"}], "]"}], "=", "List"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"components", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"Apply", "[", 
       RowBox[{"Times", ",", 
        RowBox[{"Cases", "[", 
         RowBox[{"expr", ",", 
          SuperscriptBox["\[ExponentialE]", "_"]}], "]"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"components", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"Apply", "[", 
       RowBox[{"Times", ",", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"expr", ",", 
          SuperscriptBox["\[ExponentialE]", "_"]}], "]"}]}], "]"}]}], ";", 
     "components"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6653092065001583`*^9, {3.665433338210455*^9, 3.6654333410941133`*^9}, 
   3.6654903732777033`*^9, 3.6654981428882313`*^9, 3.7167106940724306`*^9, {
   3.720177370039504*^9, 3.720177388118021*^9}, {3.720177429282838*^9, 
   3.7201774375646706`*^9}, 3.720808969004922*^9, {3.7353659925977497`*^9, 
   3.7353659961764297`*^9}, {3.7353661012605715`*^9, 3.7353661025730596`*^9}},
 
 ExpressionUUID -> "e1f16f74-1eff-44f8-a4ce-a80224ecc066"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpToNormal", "[", "expression_", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", "expression", ",", "1"}], "]"}], "]"}]}]], "Input",
 ExpressionUUID -> "a7ec3617-e118-4dea-bc94-1e9bca225b2c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalToExp", "[", "expression_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"ExtractExponential", ",", 
    RowBox[{"SumToList", "[", "expression", "]"}]}], "]"}]}]], "Input",
 ExpressionUUID -> "5bcfc3d7-8616-42ff-abaa-ff76fa138c73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MergeExps", "[", "expression_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"expr", "=", "expression"}], ",", "testexp", ",", 
      "mergedelement", ",", 
      RowBox[{"mergedlist", "=", 
       RowBox[{"{", "}"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "expr", "]"}], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"testexp", "=", 
         RowBox[{
          RowBox[{"expr", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", 
        RowBox[{"mergedelement", "=", 
         RowBox[{"Total", "[", 
          RowBox[{"Cases", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"{", 
             RowBox[{"testexp", ",", "_"}], "}"}]}], "]"}], "]"}]}], ";", 
        RowBox[{
         RowBox[{"mergedelement", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", "testexp"}], ";", 
        RowBox[{"expr", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"expr", ",", 
           RowBox[{"{", 
            RowBox[{"testexp", ",", "_"}], "}"}]}], "]"}]}], ";", 
        RowBox[{"mergedlist", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"mergedlist", ",", 
           RowBox[{"{", "mergedelement", "}"}]}], "]"}]}]}]}], "]"}], ";", 
     "mergedlist"}]}], "]"}]}]], "Input",
 ExpressionUUID -> "ff3aed35-459c-42b8-97be-8db4f8dd00f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpSimplify1", "[", "expression_", "]"}], ":=", 
  RowBox[{"ExpToNormal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"MergeExps", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"NormalToExp", "[", 
       RowBox[{"Expand", "[", "expression", "]"}], "]"}], "]"}], "]"}], "]"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.735362767592938*^9, 3.7353627875019836`*^9}, 
   3.7497985571552587`*^9},
 ExpressionUUID -> "66b79cc7-557b-4b25-bff9-e1fca627b5fe"],

Cell[TextData[{
 StyleBox["ExpSimplify", "Output"],
 " separate terms with different exponential components, then simplify each \
separated terms."
}], "Text",
 CellChangeTimes->{{3.7215534655928855`*^9, 3.721553467967828*^9}, {
   3.7215535332580595`*^9, 3.7215536167479005`*^9}, 3.7215555327421293`*^9, 
   3.7353792001328*^9},
 ExpressionUUID -> "4072e186-54cb-4d46-805b-b068857a3fe8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpSimplify2", "[", "expression_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"expression", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "===", "SeriesData"}], ",", 
    RowBox[{"expression", "/.", 
     RowBox[{
      RowBox[{"expression", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "  ", 
      RowBox[{"Map", "[", 
       RowBox[{"ExpSimplify1", ",", 
        RowBox[{"expression", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]}], ",", 
    RowBox[{"ExpSimplify1", "[", "expression", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748268741225869*^9, 3.748268832992455*^9}, 
   3.748269288709629*^9, {3.748269328514935*^9, 3.748269338564814*^9}, {
   3.7497985594202185`*^9, 3.7497985609198675`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpSimplify", "[", "expression_", "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"expression", "[", 
       RowBox[{"[", "0", "]"}], "]"}], "===", "List"}], ",", " ", 
     RowBox[{"Map", "[", 
      RowBox[{"ExpSimplify2", ",", "expression"}], "]"}], ",", 
     RowBox[{"ExpSimplify2", "[", "expression", "]"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.748268496857723*^9, 3.748268506521491*^9}, {
   3.748268542217801*^9, 3.7482685745675087`*^9}, {3.748268691180874*^9, 
   3.748268735415121*^9}, {3.748269283173394*^9, 3.7482692856372957`*^9}, {
   3.748269341197208*^9, 3.748269345332704*^9}, {3.748269432409688*^9, 
   3.748269436548538*^9}, 3.749798563310048*^9}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.7355402591960974`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"AdvancedDeleteDuplicates", "[", "sol_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"DupPosition", ",", "Coor", ",", "Pos", ",", "i"}], "}"}], ",", 
    RowBox[{
     RowBox[{"DupPosition", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", "i", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"Length", "[", "sol", "]"}], ")"}], "2"]}], "}"}]}],
              "]"}], ",", 
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"Flatten", "[", 
                 RowBox[{
                  RowBox[{"Simplify", "[", 
                   RowBox[{"Outer", "[", 
                    RowBox[{"Divide", ",", 
                    RowBox[{"sol", "/.", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"b_", "\[Equal]", "a_"}], ")"}], "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"b", "-", "a"}], ")"}]}]}], ",", 
                    RowBox[{"sol", "/.", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"b_", "\[Equal]", "a_"}], ")"}], "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"b", "-", "a"}], ")"}]}]}]}], "]"}], "]"}], "-", 
                  RowBox[{"IdentityMatrix", "[", 
                   RowBox[{"Length", "[", "sol", "]"}], "]"}]}], "]"}], ",", 
                "1"}], "]"}], ",", "_Mod"}], "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "#", "]"}], "==", "1"}], "&"}]}], "]"}], 
        ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "sol", "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"i", "-", "1"}], ")"}]}], "+", "i"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "sol", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
     ";", 
     RowBox[{"Coor", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Quotient", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Flatten", "[", "DupPosition", "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ",", 
             RowBox[{"Length", "[", "sol", "]"}]}], "]"}], "+", "1"}], ",", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Flatten", "[", "DupPosition", "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"Length", "[", "sol", "]"}]}], "]"}], "/.", 
            RowBox[{"(", 
             RowBox[{"0", "\[Rule]", 
              RowBox[{"Length", "[", "sol", "]"}]}], ")"}]}], ")"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", 
           RowBox[{"Flatten", "[", "DupPosition", "]"}], "]"}]}], "}"}]}], 
       "]"}]}], ";", 
     RowBox[{"i", "=", "1"}], ";", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "Coor", "]"}], ">", "i"}], ",", 
       RowBox[{
        RowBox[{"Coor", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"Coor", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Coor", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "_"}], "}"}]}], "]"}]}], 
        ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Pos", "=", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Coor", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "Coor", "]"}]}], "}"}]}], "]"}], "]"}]}], 
     ";", 
     RowBox[{"Pos", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"Pos", ",", 
        RowBox[{"Replace", "[", 
         RowBox[{
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{"j", ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"Length", "[", "sol", "]"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Flatten", "[", "Coor", "]"}]}], "]"}], ",", 
          RowBox[{"a_", "->", 
           RowBox[{"{", "a", "}"}]}], ",", "1"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Extract", "[", 
      RowBox[{"sol", ",", "Pos"}], "]"}]}]}], "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.667128546403157*^9, 3.667128562699009*^9}, 
   3.667128629227168*^9, {3.667128863109606*^9, 3.667128863325626*^9}, 
   3.667129057746604*^9, 3.667137515142722*^9},
 ExpressionUUID -> "5c288af6-1f3a-4187-9bf1-f81dae484719"],

Cell[TextData[{
 StyleBox["AdvancedDeleteDuplicates", "Output"],
 " are used to remove duplicate entries in a list"
}], "Text",
 CellChangeTimes->{{3.7354818558060527`*^9, 3.735481878062333*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ThresholdCondition", "[", 
   RowBox[{"g_", ",", "k_", ",", "\[Eta]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["g", "8"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["g", "6"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["g", "6"]}], ")"}], " ", 
          SuperscriptBox["\[Eta]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cosh", "[", 
        FractionBox["k", 
         SuperscriptBox["g", "3"]], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["g", "6"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["g", "12"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["g", "8"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
             SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
          RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["g", "6"]}]}], ")"}], " ", "\[Eta]", " ", 
          RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["g", "6"]}], ")"}], "3"], " ", "\[Eta]", " ", 
          RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["g", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["g", "6"]}], "+", 
               SuperscriptBox["g", "12"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["g", "6"]}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["g", "12"]}], "+", 
               RowBox[{"20", " ", 
                SuperscriptBox["g", "18"]}], "+", 
               SuperscriptBox["g", "24"]}], ")"}], " ", 
             SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
          RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
       RowBox[{"Sinh", "[", 
        FractionBox["k", 
         SuperscriptBox["g", "3"]], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      SuperscriptBox["g", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["g", "6"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"Cosh", "[", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["g", "6"]}], ")"}]}], " ", "\[Eta]", " ", 
            RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               SuperscriptBox["g", "8"], " ", 
               SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
            RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"g", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["g", "2"]}], "+", "\[Eta]", "+", 
              RowBox[{
               SuperscriptBox["g", "6"], " ", "\[Eta]"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["g", "2"]}], "+", "\[Eta]", "+", 
              RowBox[{
               SuperscriptBox["g", "6"], " ", "\[Eta]"}]}], ")"}], " ", 
            RowBox[{"Cosh", "[", "k", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["g", "6"]}], ")"}], " ", "\[Eta]", " ", 
            RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
         RowBox[{"Sinh", "[", 
          FractionBox["k", 
           SuperscriptBox["g", "3"]], "]"}]}]}], ")"}]}], ")"}]}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"g", "-", "1"}], ")"}], "2"]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BracketGrowth", "[", 
    RowBox[{
     RowBox[{"k_", "?", "NumericQ"}], ",", 
     RowBox[{"\[Eta]_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "=", 
        RowBox[{"101", "/", "100"}]}], ",", 
       RowBox[{"sgn0", "=", 
        RowBox[{"Sign", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"119", "-", 
            RowBox[{"258", " ", 
             SuperscriptBox["\[Eta]", "2"]}], "-", 
            RowBox[{"128", " ", 
             SuperscriptBox[
              RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["k", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
            RowBox[{"258", " ", 
             SuperscriptBox["\[Eta]", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["k", "2"], " ", 
             SuperscriptBox["\[Eta]", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "-", 
            RowBox[{"18", " ", "\[Eta]", " ", 
             RowBox[{"Cosh", "[", "k", "]"}], " ", 
             RowBox[{"Sinh", "[", "k", "]"}]}], "+", 
            RowBox[{"119", " ", 
             SuperscriptBox[
              RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["k", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "-", 
            RowBox[{"267", " ", 
             SuperscriptBox["\[Eta]", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["k", "2"], " ", 
             SuperscriptBox["\[Eta]", "2"], " ", 
             SuperscriptBox[
              RowBox[{"Sinh", "[", "k", "]"}], "2"]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"9", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "k"}], " ", 
               SuperscriptBox[
                RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
              RowBox[{"\[Eta]", " ", 
               SuperscriptBox[
                RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox["\[Eta]", "2"], " ", 
               SuperscriptBox[
                RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
              RowBox[{
               RowBox[{"Cosh", "[", "k", "]"}], " ", 
               RowBox[{"Sinh", "[", "k", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["\[Eta]", "2"], " ", 
               RowBox[{"Cosh", "[", "k", "]"}], " ", 
               RowBox[{"Sinh", "[", "k", "]"}]}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox[
                RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "+", 
              RowBox[{"\[Eta]", " ", 
               SuperscriptBox[
                RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "-", 
              RowBox[{"k", " ", 
               SuperscriptBox["\[Eta]", "2"], " ", 
               SuperscriptBox[
                RowBox[{"Sinh", "[", "k", "]"}], "2"]}]}], ")"}]}], ")"}]}], 
         "]"}]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ThresholdCondition", "[", 
           RowBox[{"g", ",", "k", ",", "\[Eta]"}], "]"}], "/", "sgn0"}], ">", 
         "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"g", "+", 
          RowBox[{"1", "/", "20"}]}]}]}], "]"}], ";", "g"}]}], "]"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindGrowth", "[", 
    RowBox[{
     RowBox[{"k_", "?", "NumericQ"}], ",", 
     RowBox[{"\[Eta]_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"g", "/.", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"growthlimit", "=", 
          RowBox[{"BracketGrowth", "[", 
           RowBox[{"k", ",", "\[Eta]"}], "]"}]}], "}"}], ",", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ThresholdCondition", "[", 
            RowBox[{"g", ",", "k", ",", "\[Eta]"}], "]"}], "\[Equal]", "0"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"g", ",", 
            RowBox[{"growthlimit", "-", 
             RowBox[{"1", "/", "20"}]}], ",", "growthlimit"}], "}"}], ",", 
          RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "//", "Quiet"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"CharacterizeInstability", "[", 
    RowBox[{"\[Eta]_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gt", ",", "kt", ",", "solution"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"\[Eta]", "\[LessEqual]", 
        FractionBox[
         RowBox[{
          RowBox[{
           FractionBox["1", "6"], 
           RowBox[{"(", 
            RowBox[{"5", "-", 
             FractionBox["4", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"19", "-", 
                 RowBox[{"3", 
                  SqrtBox["33"]}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]], "-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"19", "-", 
                RowBox[{"3", 
                 SqrtBox["33"]}]}], ")"}], 
              RowBox[{"1", "/", "3"}]]}], ")"}]}], "+", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"2", 
             SqrtBox["3"]}]], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             FractionBox[
              RowBox[{"(", 
               RowBox[{"2", "*", 
                SuperscriptBox["22", 
                 RowBox[{"2", "/", "3"}]]}], ")"}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"11", "+", 
                 RowBox[{"3", 
                  SqrtBox["33"]}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"22", 
                RowBox[{"(", 
                 RowBox[{"11", "+", 
                  RowBox[{"3", 
                   SqrtBox["33"]}]}], ")"}]}], ")"}], 
              RowBox[{"1", "/", "3"}]]}]]}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "3"], 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"19", "-", 
                 RowBox[{"3", 
                  SqrtBox["33"]}]}], ")"}], 
               RowBox[{"1", "/", "3"}]], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"19", "+", 
                 RowBox[{"3", 
                  SqrtBox["33"]}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}], ")"}]}], ")"}], 
          RowBox[{"2", "/", "3"}]]]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"g", "\[Rule]", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "3"], 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"19", "-", 
                  RowBox[{"3", 
                   SqrtBox["33"]}]}], ")"}], 
                RowBox[{"1", "/", "3"}]], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"19", "+", 
                  RowBox[{"3", 
                   SqrtBox["33"]}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}], ")"}]}], ")"}], 
           RowBox[{"2", "/", "3"}]]}], ",", 
         RowBox[{"k", "\[Rule]", "\[Infinity]"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"solution", "=", 
         RowBox[{
          RowBox[{"FindMinimum", "[", 
           RowBox[{
            RowBox[{"FindGrowth", "[", 
             RowBox[{"k", ",", "\[Eta]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"\[Eta]", "<", "20"}], ",", "1", ",", 
                RowBox[{
                 RowBox[{"3", "^", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "3"}], ")"}]}], "/", 
                 RowBox[{"\[Eta]", "^", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "3"}], ")"}]}]}]}], "]"}]}], "}"}], ",", 
            
            RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
          "Quiet"}]}], ";", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"g", "\[Rule]", 
           RowBox[{"solution", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"solution", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"\[Mu]2", "\[Rule]", "1"}], ",", 
          RowBox[{"\[Mu]1", "\[Rule]", "\[Eta]"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7483664251212482`*^9, 3.748366425238668*^9}, 
   3.748368091436594*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.748368093998341*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ThresholdConditionSandwich", "[", 
   RowBox[{"g_", ",", "k_", ",", "\[Eta]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["g", "7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["g", "6"]}], ")"}], " ", 
          SuperscriptBox["\[Eta]", "2"]}]}], ")"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"Cosh", "[", 
       FractionBox["k", 
        SuperscriptBox["g", "3"]], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["g", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["g", "4"]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["g", "12"]}]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["g", "8"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
            SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
         RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["g", "6"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"g", "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["g", "7"]}]}], ")"}], 
         SuperscriptBox["\[Eta]", "3"], " ", 
         RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"g", "-", 
            SuperscriptBox["g", "7"]}], ")"}], "2"], " ", "\[Eta]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["g", "6"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}]}], ")"}], " ", 
         RowBox[{"Cosh", "[", "k", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["g", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["g", "6"]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["g", "6"]}], "+", 
              RowBox[{"13", " ", 
               SuperscriptBox["g", "12"]}], "+", 
              SuperscriptBox["g", "18"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["g", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["g", "6"]}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["g", "12"]}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["g", "18"]}], "+", 
              SuperscriptBox["g", "24"]}], ")"}], " ", 
            SuperscriptBox["\[Eta]", "4"]}]}], ")"}], " ", 
         RowBox[{"Sinh", "[", "k", "]"}]}]}], ")"}], " ", 
      RowBox[{"Sinh", "[", 
       FractionBox["k", 
        SuperscriptBox["g", "3"]], "]"}]}]}], ")"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"g", "-", "1"}], ")"}], "2"]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BracketGrowthSandwich", "[", 
    RowBox[{
     RowBox[{"k_", "?", "NumericQ"}], ",", 
     RowBox[{"\[Eta]_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "=", 
        RowBox[{"101", "/", "100"}]}], ",", 
       RowBox[{"sgn0", "=", 
        RowBox[{"Sign", "[", 
         RowBox[{"(", 
          RowBox[{"672", "-", 
           RowBox[{"4512", " ", 
            SuperscriptBox["\[Eta]", "2"]}], "+", 
           RowBox[{"4640", " ", 
            SuperscriptBox["\[Eta]", "4"]}], "-", 
           RowBox[{"672", " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "-", 
           RowBox[{"144", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"5088", " ", 
            SuperscriptBox["\[Eta]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"288", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox["\[Eta]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "-", 
           RowBox[{"4640", " ", 
            SuperscriptBox["\[Eta]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "-", 
           RowBox[{"144", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox["\[Eta]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"Cosh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"576", " ", "\[Eta]", " ", 
            RowBox[{"Cosh", "[", "k", "]"}], " ", 
            RowBox[{"Sinh", "[", "k", "]"}]}], "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["\[Eta]", "3"], " ", 
            RowBox[{"Cosh", "[", "k", "]"}], " ", 
            RowBox[{"Sinh", "[", "k", "]"}]}], "+", 
           RowBox[{"816", " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "-", 
           RowBox[{"4224", " ", 
            SuperscriptBox["\[Eta]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "-", 
           RowBox[{"288", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox["\[Eta]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"4784", " ", 
            SuperscriptBox["\[Eta]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox["\[Eta]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"Sinh", "[", "k", "]"}], "2"]}]}], ")"}], "]"}]}]}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ThresholdConditionSandwich", "[", 
           RowBox[{"g", ",", "k", ",", "\[Eta]"}], "]"}], "/", "sgn0"}], ">", 
         "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"g", "+", 
          RowBox[{"1", "/", "20"}]}]}]}], "]"}], ";", "g"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FindGrowthSandwich", "[", 
    RowBox[{
     RowBox[{"k_", "?", "NumericQ"}], ",", 
     RowBox[{"\[Eta]_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"g", "/.", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"growthlimit", "=", 
          RowBox[{"BracketGrowthSandwich", "[", 
           RowBox[{"k", ",", "\[Eta]"}], "]"}]}], "}"}], ",", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ThresholdConditionSandwich", "[", 
            RowBox[{"g", ",", "k", ",", "\[Eta]"}], "]"}], "\[Equal]", "0"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"g", ",", 
            RowBox[{"growthlimit", "-", 
             RowBox[{"1", "/", "20"}]}], ",", "growthlimit"}], "}"}], ",", 
          RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "//", "Quiet"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CharacterizeInstabilitySandwich", "[", 
   RowBox[{"\[Eta]_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gt", ",", "kt", ",", "solution"}], "}"}], ",", 
    RowBox[{
     RowBox[{"solution", "=", 
      RowBox[{
       RowBox[{"FindMinimum", "[", 
        RowBox[{
         RowBox[{"FindGrowthSandwich", "[", 
          RowBox[{"k", ",", "\[Eta]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"1", "/", 
            SuperscriptBox["\[Eta]", 
             RowBox[{"1", "/", "3"}]]}]}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}], "//", 
       "Quiet"}]}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[Rule]", 
        RowBox[{"solution", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"solution", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"\[Mu]2", "\[Rule]", "1"}], ",", 
       RowBox[{"\[Mu]1", "\[Rule]", "\[Eta]"}]}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.735458104559493*^9, 3.7354581974122543`*^9}, {
   3.735458362837817*^9, 3.735458384209004*^9}, {3.735458500624453*^9, 
   3.73545850993432*^9}, {3.7475663424514217`*^9, 3.7475663424574037`*^9}, {
   3.7475675302357273`*^9, 3.747567634472962*^9}, {3.7475676893581924`*^9, 
   3.7475676954150195`*^9}, {3.747568041788686*^9, 3.747568043948341*^9}, 
   3.7475702234907336`*^9, {3.7475720473507123`*^9, 3.747572051984346*^9}, {
   3.747578026137376*^9, 3.7475780271506658`*^9}, {3.747578847942542*^9, 
   3.7475788492470536`*^9}, {3.747584564777028*^9, 3.747584579247263*^9}, {
   3.7475847372241807`*^9, 3.7475847621105723`*^9}, {3.7475848740424376`*^9, 
   3.7475848812795477`*^9}, {3.747584912639723*^9, 3.747584951549899*^9}, {
   3.7475850545264916`*^9, 3.7475851448633194`*^9}, {3.7475852124786577`*^9, 
   3.7475852205745206`*^9}, {3.7475853683663654`*^9, 3.747585369163148*^9}, {
   3.747585540069771*^9, 3.7475855412463675`*^9}, {3.747585579879183*^9, 
   3.7475855822299647`*^9}, {3.747585705054598*^9, 3.7475857785192566`*^9}, {
   3.7475859314065046`*^9, 3.747585932935117*^9}, {3.747587896204405*^9, 
   3.7475878980125685`*^9}, {3.7491137642212663`*^9, 3.749113786031895*^9}},
 ExpressionUUID -> "858c1a37-0c3e-4903-8c84-5ff7afb6bde6"]
},
WindowSize->{808, 911},
WindowMargins->{{186, Automatic}, {-83, Automatic}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 2494, 64, 166, "Input"],
Cell[3055, 86, 502, 9, 30, "Text"],
Cell[CellGroupData[{
Cell[3582, 99, 293, 7, 34, "Input"],
Cell[3878, 108, 888, 16, 34, "Output"]
}, Open  ]],
Cell[4781, 127, 898, 25, 69, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[5682, 154, 494, 8, 30, "Text"],
Cell[CellGroupData[{
Cell[6201, 166, 221, 4, 30, "Input"],
Cell[6425, 172, 808, 13, 30, "Output"]
}, Open  ]],
Cell[7248, 188, 726, 16, 50, "Input"],
Cell[7977, 206, 623, 10, 49, "Text"],
Cell[CellGroupData[{
Cell[8625, 220, 501, 15, 34, "Input"],
Cell[9129, 237, 1251, 28, 34, "Output"]
}, Open  ]],
Cell[10395, 268, 4362, 95, 259, "Input"],
Cell[14760, 365, 579, 11, 30, "Text"],
Cell[CellGroupData[{
Cell[15364, 380, 682, 21, 34, "Input"],
Cell[16049, 403, 1076, 23, 34, "Output"]
}, Open  ]],
Cell[17140, 429, 569, 11, 30, "Input"],
Cell[17712, 442, 529, 10, 30, "Text"],
Cell[CellGroupData[{
Cell[18266, 456, 522, 16, 34, "Input"],
Cell[18791, 474, 1039, 22, 34, "Output"]
}, Open  ]],
Cell[19845, 499, 373, 8, 49, "Text"],
Cell[20221, 509, 851, 24, 30, "Input"],
Cell[21075, 535, 251, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[21351, 543, 622, 14, 30, "Input"],
Cell[21976, 559, 2236, 44, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24249, 608, 343, 9, 30, "Input"],
Cell[24595, 619, 1904, 34, 30, "Output"]
}, Open  ]],
Cell[26514, 656, 251, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[26790, 663, 779, 23, 30, "Input"],
Cell[27572, 688, 1240, 27, 56, "Output"]
}, Open  ]],
Cell[28827, 718, 759, 15, 30, "Input"],
Cell[29589, 735, 917, 24, 88, "Input"],
Cell[30509, 761, 437, 9, 49, "Text"],
Cell[30949, 772, 441, 9, 30, "Input"],
Cell[31393, 783, 698, 18, 69, "Input"],
Cell[32094, 803, 638, 14, 50, "Input"],
Cell[32735, 819, 96, 1, 30, "Input"],
Cell[32834, 822, 249, 3, 30, "Text"],
Cell[33086, 827, 2272, 60, 145, "Input"],
Cell[35361, 889, 270, 6, 30, "Input"],
Cell[35634, 897, 275, 6, 30, "Input"],
Cell[35912, 905, 1491, 41, 145, "Input"],
Cell[37406, 948, 497, 12, 50, "Input"],
Cell[37906, 962, 388, 8, 30, "Text"],
Cell[38297, 972, 795, 19, 69, "Input"],
Cell[39095, 993, 776, 17, 50, "Input"],
Cell[39874, 1012, 89, 1, 50, "Input"],
Cell[39966, 1015, 5427, 144, 358, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45396, 1161, 195, 4, 30, "Text"],
Cell[45594, 1167, 14916, 415, 899, "Input"],
Cell[60513, 1584, 68, 1, 30, "Input"],
Cell[60584, 1587, 10861, 283, 623, "Input"]
}
]
*)

