      subroutine cntl

c   this subroutine reads in run control parameters from file on unit 5

      include 'traj.inc'


      call lisym(11,'-')
      write(11,*) ' *** subroutine cntl:',
     .  ' read in run control parameters ***'

      nunits=5

      amsc=1.0d0
      esc=1.0d0
      rsc=1.0d0
        scalef=9.682886569d14
        msunit=' g/mol'
        enunit=' hartree'
        lnunit=' bohr'
        eukjpm=2625.499964d0
      tsc=dsqrt(amsc/esc)*rsc/scalef
      tups=tsc*1.0d12

c   Avagadro's number

      avanum=6.0221367d23

c   speed of light in cm s-1 and cm tu-1

      ccmps=2.99792458d10
      ccmptu=ccmps*tsc

c   Planck's constant in J s, kJ/mol s and eu tu

      hjs=6.6260755d-34
      hkjpms=hjs*avanum*1.0d-03
      heutu=(hkjpms/tsc)/eukjpm

c---------------------------------------------------------------------
c   echo some parameters

c echo info from readccm

      write(11,*) 'The number of atoms = ',natom
      write(11,*)
      write(11,*) 'The atomic labels and masses are:'
      do i=1,natom
      write(11,*) lab(i), amas(i)
      enddo
      write(11,*)
      write(11,*) 'The bonded atoms'
      do i=1,nbond
      write(11,*) mb(i), nb(i)
      enddo
      write(11,*)
      write(11,*) 'The number of group elements = ',ngroup
      write(11,*)

      write(11,*) 'The permutations of bonds in the group are:'
      write(11,*)
      do i=1,ngroup
       write(11,*)
       write(11,8769)' Reordered atoms ',(nperm(i,k),k=1,natom)
       do k=1,nbond
       write(11,*)k, ip(k,i)
       enddo
       write(11,*)
      enddo
8769  format(a18,20i3)

      write(11,*) 'The units are defined as atomic units in cntl.f'
      write(11,*)

      write(11,40)esc,enunit,rsc,lnunit,amsc,msunit,
     .  tsc,tups,scalef
   40 format(
     ./,'  unit scaling parameters',
     ./,'  esc=',g12.5,a10,'  rsc=',g12.5,a10,'  amsc=',g12.5,a10,
     ./,'  tsc=',g17.10,' s =',g17.10,' ps  scalef=',g17.10,' s-1')

      write(11,45)avanum,ccmps,ccmptu,hjs,hkjpms,heutu,eukjpm
   45 format(
     ./,'  Avagadro''s number   =',g17.10,
     ./,'  Speed of light       =',g17.10,' cm s-1  =',
     .g17.10,' cm tu-1',
     ./,'  Planck''s constant   =',g17.10,' J s     =',
     .g17.10,' kJ/mol s',
     ./,'                                           =',g17.10,' eu tu',
     ./,'  1 eu = 1 energy unit = ',g17.10,' kJ/mol')

      call lisym(11,'-')

      if ((natom/=6).and.(natom/=9)) 
     +  stop 'natom wrong.  This version only for SiH5 and Si2H7'

c     call lisym(11,'-')
      if (natom==6) then
        write(11,81)'SiH5'
      else
        write(11,81)'Si2H7'
      endif
   81 format(1x,a79)
c     call lisym(11,'-')

c   read in time step,no. of traj. step, nprint,no. of molecule etc.

       ipart=2
91     format(2x,'we will use the ',i1,' part weight function')

c  read in the parameters defining the weight function, the neighbour
c  list and the number of timesteps between calls to neighbour

       lowp=2
       wtol=1.0d-5
       outer=1.0d-4
      if (natom==6) then
        ipow=8
        nneigh=48
        vmin=-291
        potmax=-290
      else
        ipow=13
        nneigh=48
        vmin=-579.1
        potmax=-578
      endif

       neighco=10
       neighci=5

c  to allow one part neighbour to work

      neighc=neighci


c  read in the sampling fraction used in outp to determine number
c  of trajectory points output in file TOUT, and number of
c  data points chosen

       sample=1

c read in the multipicitive factor used in radius.f, confidrad.f

c  Enter the energy error tolerance for confidrad.f

       sigma=2.0d-4

c calculate pi, conversion factors

      pi=2.d0*dacos(0.d0)
      todeg=45.d0/atan(1.d0)
      toang=0.52917706d0
      sq2=dsqrt(2.d0)

      write(11,*) ' conversion factors: '
      write(11,*) ' todeg=',todeg,' toang=',toang
      write(11,*) ' pi   =',pi,' sq2  =',sq2


c  scale atomic masses

      do 150 i=1,natom
        amas(i)=amas(i)/amsc
  150 continue


      close(unit=7)

      return
      end

c  --------------------------------------------------------------

      subroutine readz

c  modified jan 7 1996 by kt 

      include 'traj.inc'
 
      call lisym(11,'-')
      write(11,*)'*** subroutine readz: read in fragment data'
      write(11,*) ' '

c  given that we need all the atom-atom bonds, we just assign the indirect
c  addresses of the bonds, rather than the traditional read from ZMA

        k=1
        do i=1,natom-1
        do j=i+1,natom

           mb(k)=i
           nb(k)=j
           k=k+1

        enddo
        enddo

c   read fragment atom numbers

      open (unit=7,file='IN_ZMA',status='old')

80    format(a80)
81    format(1x,a79)

      read(7,80)comlin
      write(11,81)comlin

      read(7,*)nfraga,nfragb
      write(11,*)nfraga,nfragb

      if(nfraga+nfragb.ne.natom)then
        write(11,*) 'ABORT: nfraga+nfragb.ne.natom'
        write(11,*) nfraga,'+',nfragb,'.ne.',natom
        stop
      endif

      read(7,80)comlin
      write(11,81)comlin

      if(nfraga.gt.0)then
      read(7,*)(ifraga(i),i=1,nfraga)
      write(11,*)(ifraga(i),i=1,nfraga)
      endif

      read(7,80)comlin
      write(11,81)comlin

      if(nfragb.gt.0)then
      read(7,*)(ifragb(i),i=1,nfragb)
      write(11,*)(ifragb(i),i=1,nfragb)
      endif
      if (nfraga .le. 1) go to 3100

      nbfraga=0
      do 3000 i=1,nbond
	do 2900 j=1,nfraga
	  do 2800 k=1,nfraga
            if ((mb(i).eq.ifraga(j)).and.(nb(i).eq.ifraga(k))) then
              nbfraga=nbfraga+1
              ibfraga(nbfraga)=i
            endif
 2800     continue 
 2900   continue
 3000 continue
	
      write (11,*) 'no. of bonds in fragment a is', nbfraga
      write (11,*) 'bonds in fragment a are'
      write (11,*) (ibfraga(i),i=1,nbfraga)

 3100 continue

      if (nfragb .le. 1) go to 4100

      nbfragb=0
      do 4000 i=1,nbond
	do 3900 j=1,nfragb
	  do 3800 k=1,nfragb
            if ((mb(i).eq.ifragb(j)).and.(nb(i).eq.ifragb(k))) then
              nbfragb=nbfragb+1
              ibfragb(nbfragb)=i
              endif
 3800     continue 
 3900   continue
 4000 continue

      write (11,*) 'no. of bonds in fragment b is', nbfragb
      write (11,*) 'bonds in fragment b are'
      write (11,*) (ibfragb(i),i=1,nbfragb)
      
 4100 continue

      close(unit=7)

      return
      end

