      program Energy

c  This is an example to setup the PES, then evaluate the energy and forces
c  It reads Cartesian coordinates (bohr) for the atoms from stdin
c  Order is: Si H H H H H for SiH5
c            Si H H H Si H H H H for Si2H7
c  We do differences to confirm calculated force

!  Be warned:  There is considerable scope for optimising the included code!

      include 'traj.inc'

      real(kind=8),dimension(3,9)::x,f,f1
      real(kind=8)::e,e1,e2
      integer::i,j

      real(kind=8),parameter::h=1.0e-5

!  Setup the potential:
      call readccm
      call readz
      call makebp
      call cntl
      call readt
      call readcon

!  Read in a geometry:
      do i=1,natom
        read(*,*)x(:,i)
      enddo

! transfer to internal data structures
      c(1,1:natom,:)=transpose(x)
!  Evaluate interpolated PES
      call intern(1)
      call enerder_system(r(1,:))
      call dvdx(1)
!  Extract from internal
      e=en(1)
      f=transpose(dv(1,1:natom,:))

      write(*,*)'Energy:'
      write(*,*)e
      write(*,*)'Interpolated force:'
      do i=1,natom
        write(*,*)real(f(:,i))
      enddo

! difference it to check
      do i=1,natom
        do j=1,3
          c(1,1:natom,:)=transpose(x)
          c(1,i,j)=x(j,i)+h
          call intern(1)
          call enerder_system(r(1,:))
          e2=en(1)
          c(1,i,j)=x(j,i)-h
          call intern(1)
          call enerder_system(r(1,:))
          e1=en(1)
          f1(j,i)=(e2-e1)/(2*h)
        enddo
      enddo
      write(*,*)'Stepped force:'
      do i=1,natom
        write(*,*)real(f1(:,i))
      enddo

      end
