module deandnac
  use dimmatrix
  implicit none

  public :: deandnacr1, deandnacr2,deandnacr3

contains
  
subroutine deandnacr1(r1,r2,r3,denac)
  !! On-diagonal values = derivatives of adiabatic energies
  !! Off-diagonal values = non-adiabatic coupling matrix elements
  !! Needs the lapack diagonalization subroutine dsyev
  !! Calls the subroutine hmatsnglt and dhmatsnglt
  implicit none
  real(kind=8), intent(in) :: r1,r2,r3
  real(kind=8), dimension(ndim,ndim), intent(out) :: denac
  !! Internal variables 
  real(kind=8), dimension(ndim,ndim) :: dhmatsnglt,auxdenac 
  integer :: i,j
  real(kind=8) :: etria
  real(kind=8) :: dtria(ndim)
  !!Defining variables and arrays for lapack diagonalization
  real(kind=8) :: eabbd1,eabbd2,eabbnd1,eabbnd2
  real(kind=8), dimension(ndim,ndim) :: eigvec
  real(kind=8), dimension(ndim) :: eigval
  real(kind=8),dimension(ndim) :: d1231,d2231,d1132,d2132,d1123,d2123
  real(kind=8),dimension(ndim) :: nd1231,nd2231,nd1132,nd2132,nd1123,nd2123
  integer :: lwork,info
  real(kind=8), allocatable, dimension(:) :: work

   call hmatsnglt(r1,r2,r3,eigvec(:,:))
!! H11
   call triabb01(r2,r3,r1,eabbd1,d1231)
   call triabb02(r2,r3,r1,eabbd2,d2231)
   eigvec(1,1)=eigvec(1,1)+eabbd1+eabbd2
!! H22
   call triabb01(r1,r3,r2,eabbd1,d1132)
   call triabb02(r1,r3,r2,eabbd2,d2132)
   eigvec(2,2)=eigvec(2,2)+eabbd1+eabbd2
!! H33
   call triabb01(r1,r2,r3,eabbd1,d1123)
   call triabb02(r1,r2,r3,eabbd2,d2123)
   eigvec(3,3)=eigvec(3,3)+eabbd1+eabbd2
!! H12
   call tabbnd01(r1,r2,r3,eabbd1,nd1123)
   call tabbnd02(r1,r2,r3,eabbd2,nd2123)
   eigvec(1,2)=eigvec(1,2)+eabbd1+eabbd2
   eigvec(2,1)=eigvec(1,2)
!! H13
   call tabbnd01(r1,r3,r2,eabbd1,nd1132)
   call tabbnd02(r1,r3,r2,eabbd2,nd2132)
   eigvec(1,3)=eigvec(1,3)+eabbd1+eabbd2
   eigvec(3,1)=eigvec(1,3)
!! H23
   call tabbnd01(r2,r3,r1,eabbd1,nd1231)
   call tabbnd02(r2,r3,r1,eabbd2,nd2231)
   eigvec(2,3)=eigvec(2,3)+eabbd1+eabbd2
   eigvec(3,2)=eigvec(2,3)   
 
  !diagonalisation
  lwork=3*ndim-1
  allocate(work(lwork))
  call dsyev('V','U',ndim,eigvec,ndim,eigval,work,lwork,info)

  !derivatives of hmat
  call dhmatsngltr1(r1,r2,r3,dhmatsnglt(:,:))
!! H11
   dhmatsnglt(1,1)=dhmatsnglt(1,1)+d1231(3)+d2231(3)
!! H22
   dhmatsnglt(2,2)=dhmatsnglt(2,2)+d1132(1)+d2132(1)
!! H33
   dhmatsnglt(3,3)=dhmatsnglt(3,3)+d1123(1)+d2123(1)
!! H12
   dhmatsnglt(1,2)=dhmatsnglt(1,2)+nd1123(1)+nd2123(1)
   dhmatsnglt(2,1)=dhmatsnglt(1,2)
!! H13
   dhmatsnglt(1,3)=dhmatsnglt(1,3)+nd1132(1)+nd2132(1)
   dhmatsnglt(3,1)=dhmatsnglt(1,3)
!! H23
   dhmatsnglt(2,3)=dhmatsnglt(2,3)+nd1231(3)+nd2231(3)
   dhmatsnglt(3,2)=dhmatsnglt(2,3)

  !transformation
  auxdenac(:,:)=matmul(dhmatsnglt(:,:),eigvec(:,:))
  denac(:,:)=matmul(transpose(eigvec(:,:)),auxdenac(:,:))

!  do i=1,n
!     denac(i,i)=denac(i,i)+dtria(1)
!  enddo
 
  !dividing by (W_n-W_n')
  auxdenac(:,:)=0.d0 
  do i=1,ndim
     do j=i+1,ndim
        auxdenac(i,j)=denac(i,j)/(eigval(j)-eigval(i))
        denac(i,j)=auxdenac(i,j)
        denac(j,i)=denac(i,j)
     enddo
  enddo

  return
end subroutine deandnacr1

subroutine deandnacr2(r1,r2,r3,denac)
  !! On-diagonal values = derivatives of adiabatic energies
  !! Off-diagonal values = non-adiabatic coupling matrix elements
  !! Needs the lapack diagonalization subroutine dsyev
  !! Calls the subroutine hmatsnglt and dhmatsnglt
  implicit none
  real(kind=8), intent(in) :: r1,r2,r3
  real(kind=8), dimension(ndim,ndim), intent(out) :: denac
  !! Internal variables
  integer :: i,j
  real(kind=8) :: etria
  real(kind=8) :: dtria(ndim)
  real(kind=8), dimension(ndim,ndim) :: dhmatsnglt,auxdenac
  !!Defining variables and arrays for lapack diagonalization
  real(kind=8) :: eabbd1,eabbd2,eabbnd1,eabbnd2
  real(kind=8), dimension(ndim,ndim) :: eigvec
  real(kind=8), dimension(ndim) :: eigval
  real(kind=8),dimension(ndim) :: d1231,d2231,d1132,d2132,d1123,d2123
  real(kind=8),dimension(ndim) :: nd1231,nd2231,nd1132,nd2132,nd1123,nd2123
  integer :: lwork
  real(kind=8), allocatable, dimension(:) :: work
  integer :: info
  
   call hmatsnglt(r1,r2,r3,eigvec(:,:))
!! H11
   call triabb01(r2,r3,r1,eabbd1,d1231)
   call triabb02(r2,r3,r1,eabbd2,d2231)
   eigvec(1,1)=eigvec(1,1)+eabbd1+eabbd2
!! H22
   call triabb01(r1,r3,r2,eabbd1,d1132)
   call triabb02(r1,r3,r2,eabbd2,d2132)
   eigvec(2,2)=eigvec(2,2)+eabbd1+eabbd2
!! H33
   call triabb01(r1,r2,r3,eabbd1,d1123)
   call triabb02(r1,r2,r3,eabbd2,d2123)
   eigvec(3,3)=eigvec(3,3)+eabbd1+eabbd2
!! H12
   call tabbnd01(r1,r2,r3,eabbd1,nd1123)
   call tabbnd02(r1,r2,r3,eabbd2,nd2123)
   eigvec(1,2)=eigvec(1,2)+eabbd1+eabbd2
   eigvec(2,1)=eigvec(1,2)
!! H13
   call tabbnd01(r1,r3,r2,eabbd1,nd1132)
   call tabbnd02(r1,r3,r2,eabbd2,nd2132)
   eigvec(1,3)=eigvec(1,3)+eabbd1+eabbd2
   eigvec(3,1)=eigvec(1,3)
!! H23
   call tabbnd01(r2,r3,r1,eabbd1,nd1231)
   call tabbnd02(r2,r3,r1,eabbd2,nd2231)
   eigvec(2,3)=eigvec(2,3)+eabbd1+eabbd2
   eigvec(3,2)=eigvec(2,3)
   
  !diagonalisation
  lwork=3*ndim-1
  allocate(work(lwork))
  call dsyev('V','U',ndim,eigvec,ndim,eigval,work,lwork,info)

  !derivatives of hmat 
  call dhmatsngltr2(r1,r2,r3,dhmatsnglt(:,:))
!! H11
   dhmatsnglt(1,1)=dhmatsnglt(1,1)+d1231(1)+d2231(1)
!! H22
   dhmatsnglt(2,2)=dhmatsnglt(2,2)+d1132(3)+d2132(3)
!! H33
   dhmatsnglt(3,3)=dhmatsnglt(3,3)+d1123(2)+d2123(2)
!! H12
   dhmatsnglt(1,2)=dhmatsnglt(1,2)+nd1123(2)+nd2123(2)
   dhmatsnglt(2,1)=dhmatsnglt(1,2)
!! H13
   dhmatsnglt(1,3)=dhmatsnglt(1,3)+nd1132(3)+nd2132(3)
   dhmatsnglt(3,1)=dhmatsnglt(1,3)
!! H23
   dhmatsnglt(2,3)=dhmatsnglt(2,3)+nd1231(1)+nd2231(1)
   dhmatsnglt(3,2)=dhmatsnglt(2,3)

  !transformation
  auxdenac(:,:)=matmul(dhmatsnglt(:,:),eigvec(:,:))
  denac(:,:)=matmul(transpose(eigvec(:,:)),auxdenac(:,:))

!  do i=1,n
!     denac(i,i)=denac(i,i)+dtria(2)
!  enddo
  !dividing by (W_n-W_n')
  auxdenac(:,:)=0.d0
  do i=1,ndim
     do j=i+1,ndim
        auxdenac(i,j)=denac(i,j)/(eigval(j)-eigval(i))
        denac(i,j)=auxdenac(i,j)
        denac(j,i)=denac(i,j)
     enddo
  enddo

  return
end subroutine deandnacr2

subroutine deandnacr3(r1,r2,r3,denac)
  !! On-diagonal values = derivatives of adiabatic energies
  !! Off-diagonal values = non-adiabatic coupling matrix elements
  !! Needs the lapack diagonalization subroutine dsyev
  !! Calls the subroutine hmatsnglt and dhmatsnglt
  implicit none
  real(kind=8), intent(in) :: r1,r2,r3
  real(kind=8), dimension(n,n), intent(out) :: denac
  !! Internal variables
  integer :: i,j
  real(kind=8) :: etria
  real(kind=8) :: dtria(ndim)
  real(kind=8), dimension(ndim,ndim) :: dhmatsnglt,auxdenac
  !!Defining variables and arrays for lapack diagonalization
  real(kind=8) :: eabbd1,eabbd2,eabbnd1,eabbnd2
  real(kind=8), dimension(ndim,ndim) :: eigvec
  real(kind=8), dimension(ndim) :: eigval
  real(kind=8),dimension(ndim) :: d1231,d2231,d1132,d2132,d1123,d2123
  real(kind=8),dimension(ndim) :: nd1231,nd2231,nd1132,nd2132,nd1123,nd2123
  integer :: lwork
  real(kind=8), allocatable, dimension(:) :: work
  integer :: info
  
   call hmatsnglt(r1,r2,r3,eigvec(:,:))
!! H11
   call triabb01(r2,r3,r1,eabbd1,d1231)
   call triabb02(r2,r3,r1,eabbd2,d2231)
   eigvec(1,1)=eigvec(1,1)+eabbd1+eabbd2
!! H22
   call triabb01(r1,r3,r2,eabbd1,d1132)
   call triabb02(r1,r3,r2,eabbd2,d2132)
   eigvec(2,2)=eigvec(2,2)+eabbd1+eabbd2
!! H33
   call triabb01(r1,r2,r3,eabbd1,d1123)
   call triabb02(r1,r2,r3,eabbd2,d2123)
   eigvec(3,3)=eigvec(3,3)+eabbd1+eabbd2
!! H12
   call tabbnd01(r1,r2,r3,eabbd1,nd1123)
   call tabbnd02(r1,r2,r3,eabbd2,nd2123)
   eigvec(1,2)=eigvec(1,2)+eabbd1+eabbd2
   eigvec(2,1)=eigvec(1,2)
!! H13
   call tabbnd01(r1,r3,r2,eabbd1,nd1132)
   call tabbnd02(r1,r3,r2,eabbd2,nd2132)
   eigvec(1,3)=eigvec(1,3)+eabbd1+eabbd2
   eigvec(3,1)=eigvec(1,3)
!! H23
   call tabbnd01(r2,r3,r1,eabbd1,nd1231)
   call tabbnd02(r2,r3,r1,eabbd2,nd2231)
   eigvec(2,3)=eigvec(2,3)+eabbd1+eabbd2
   eigvec(3,2)=eigvec(2,3)
   
  !diagonalisation
  lwork=3*ndim-1
  allocate(work(lwork))
  call dsyev('V','U',ndim,eigvec,ndim,eigval,work,lwork,info)
  
  !derivatives of hmat
  call dhmatsngltr3(r1,r2,r3,dhmatsnglt(:,:))
!! H11
   dhmatsnglt(1,1)=dhmatsnglt(1,1)+d1231(2)+d2231(2)
!! H22
   dhmatsnglt(2,2)=dhmatsnglt(2,2)+d1132(2)+d2132(2)
!! H33
   dhmatsnglt(3,3)=dhmatsnglt(3,3)+d1123(3)+d2123(3)
!! H12
   dhmatsnglt(1,2)=dhmatsnglt(1,2)+nd1123(3)+nd2123(3)
   dhmatsnglt(2,1)=dhmatsnglt(1,2)
!! H13
   dhmatsnglt(1,3)=dhmatsnglt(1,3)+nd1132(2)+nd2132(2)
   dhmatsnglt(3,1)=dhmatsnglt(1,3)
!! H23
   dhmatsnglt(2,3)=dhmatsnglt(2,3)+nd1231(2)+nd2231(2)
   dhmatsnglt(3,2)=dhmatsnglt(2,3)
   
!transformation
  auxdenac(:,:)=matmul(dhmatsnglt(:,:),eigvec(:,:))
  denac(:,:)=matmul(transpose(eigvec(:,:)),auxdenac(:,:))

  !dividing by (W_n-W_n')
  auxdenac(:,:)=0.d0
  do i=1,ndim
     do j=i+1,ndim
        auxdenac(i,j)=denac(i,j)/(eigval(j)-eigval(i))
        denac(i,j)=auxdenac(i,j)
        denac(j,i)=denac(i,j)
     enddo
  enddo

  return
end subroutine deandnacr3

end module deandnac
