************************************************************************
      subroutine     h2(r,ener,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   162 points
*     rms =  0.39598612E-07 a.u. =     0.00002485 kcal/mol
*     emax =  0.22393268E-06 a.u. =     0.00014052 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 17)
      data cf(  1)/  0.10703415717469221199265048D+01/
      data cf(  2)/  0.43260282216858295658476284D-03/
      data cf(  3)/ -0.20410014967335843688930660D+01/
      data cf(  4)/ -0.10175847165502449258049299D+03/
      data cf(  5)/  0.19562429923763516912818479D+04/
      data cf(  6)/ -0.32306634978908493314295000D+05/
      data cf(  7)/  0.51640473568610878429349845D+06/
      data cf(  8)/ -0.63520969865106058182696720D+07/
      data cf(  9)/  0.56268960289226016720656633D+08/
      data cf( 10)/ -0.36169873423464798249974881D+09/
      data cf( 11)/  0.17091184797052570492413634D+10/
      data cf( 12)/ -0.59552843123124532102649734D+10/
      data cf( 13)/  0.15150137958804960262870571D+11/
      data cf( 14)/ -0.27395599962529915291349758D+11/
      data cf( 15)/  0.33378554946877359176382105D+11/
      data cf( 16)/ -0.24575308604561459751104872D+11/
      data cf( 17)/  0.82609693102084461884151650D+10/
      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.10887818315166017439388405D+01
      vex2=  0.23340086563635132420187340D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 17
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
         ener=ener+cf(i)*dux
    1 continue
      elong=elargo(r)
      ener=ener+elong
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux
      return
      end

************************************************************************
      subroutine dh2(r,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   162 points
*     rms =  0.39598612E-07 a.u. =     0.00002485 kcal/mol
*     emax =  0.22393268E-06 a.u. =     0.00014052 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 17)
      data cf(  1)/  0.10703415717469221199265048D+01/
      data cf(  2)/  0.43260282216858295658476284D-03/
      data cf(  3)/ -0.20410014967335843688930660D+01/
      data cf(  4)/ -0.10175847165502449258049299D+03/
      data cf(  5)/  0.19562429923763516912818479D+04/
      data cf(  6)/ -0.32306634978908493314295000D+05/
      data cf(  7)/  0.51640473568610878429349845D+06/
      data cf(  8)/ -0.63520969865106058182696720D+07/
      data cf(  9)/  0.56268960289226016720656633D+08/
      data cf( 10)/ -0.36169873423464798249974881D+09/
      data cf( 11)/  0.17091184797052570492413634D+10/
      data cf( 12)/ -0.59552843123124532102649734D+10/
      data cf( 13)/  0.15150137958804960262870571D+11/
      data cf( 14)/ -0.27395599962529915291349758D+11/
      data cf( 15)/  0.33378554946877359176382105D+11/
      data cf( 16)/ -0.24575308604561459751104872D+11/
      data cf( 17)/  0.82609693102084461884151650D+10/
!      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.10887818315166017439388405D+01
      vex2=  0.23340086563635132420187340D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
!      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 17
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
!         ener=ener+cf(i)*dux
    1 continue
!      elong=elargo(r)
!      ener=ener+elong
      dlargo=delargo(r)
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux+dlargo
      return
      end      
      
************************************************************************
      subroutine h2masg(r,ener,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   121 points
*     rms =  0.35673702E-07 a.u. =     0.00002239 kcal/mol
*     emax =  0.14654901E-06 a.u. =     0.00009196 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 19)
      data cf(  1)/  0.10281970547284470836543318D+01/
      data cf(  2)/ -0.62471265592231882107139440D-02/
      data cf(  3)/  0.39889267054812300854171981D-01/
      data cf(  4)/ -0.17142695798085883468652576D+02/
      data cf(  5)/  0.54551925174089160613124799D+02/
      data cf(  6)/ -0.11736444645440007494996582D+04/
      data cf(  7)/  0.36913178859190714263908422D+05/
      data cf(  8)/ -0.60599916837226493579129480D+06/
      data cf(  9)/  0.66155465587156182324293825D+07/
      data cf( 10)/ -0.51945634552082538754281788D+08/
      data cf( 11)/  0.30255745789441962642297607D+09/
      data cf( 12)/ -0.13263177697293768611090548D+10/
      data cf( 13)/  0.43948881782475190503584997D+10/
      data cf( 14)/ -0.10953379471753313432389028D+11/
      data cf( 15)/  0.20215009003285862799802987D+11/
      data cf( 16)/ -0.26797544320924579386334644D+11/
      data cf( 17)/  0.24130140346227925475191459D+11/
      data cf( 18)/ -0.13216990368805700443666605D+11/
      data cf( 19)/  0.33238723300216874611199049D+10/
      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.85238021399700000000000000D+00
      vex2=  0.17124189755673800000000000D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 19
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
         ener=ener+cf(i)*dux
    1 continue
      elong=elargomex(r)
      dlargo=delargomex(r)
      ener=ener+elong
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux+dlargo
      return
      end subroutine

************************************************************************
C Derivative H2+_g
      subroutine dh2masg(r,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   121 points
*     rms =  0.35673702E-07 a.u. =     0.00002239 kcal/mol
*     emax =  0.14654901E-06 a.u. =     0.00009196 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 19)
      data cf(  1)/  0.10281970547284470836543318D+01/
      data cf(  2)/ -0.62471265592231882107139440D-02/
      data cf(  3)/  0.39889267054812300854171981D-01/
      data cf(  4)/ -0.17142695798085883468652576D+02/
      data cf(  5)/  0.54551925174089160613124799D+02/
      data cf(  6)/ -0.11736444645440007494996582D+04/
      data cf(  7)/  0.36913178859190714263908422D+05/
      data cf(  8)/ -0.60599916837226493579129480D+06/
      data cf(  9)/  0.66155465587156182324293825D+07/
      data cf( 10)/ -0.51945634552082538754281788D+08/
      data cf( 11)/  0.30255745789441962642297607D+09/
      data cf( 12)/ -0.13263177697293768611090548D+10/
      data cf( 13)/  0.43948881782475190503584997D+10/
      data cf( 14)/ -0.10953379471753313432389028D+11/
      data cf( 15)/  0.20215009003285862799802987D+11/
      data cf( 16)/ -0.26797544320924579386334644D+11/
      data cf( 17)/  0.24130140346227925475191459D+11/
      data cf( 18)/ -0.13216990368805700443666605D+11/
      data cf( 19)/  0.33238723300216874611199049D+10/
C      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.85238021399700000000000000D+00
      vex2=  0.17124189755673800000000000D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
C      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 19
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
C         ener=ener+cf(i)*dux
    1 continue
C      elong=elargomex(r)
C     ener=ener+elong
      dlargo=delargomex(r)
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux+dlargo
      return
      end 
      
************************************************************************
      subroutine h2masu(r,ener,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   118 points
*     rms =  0.78203646E-07 a.u. =     0.00004907 kcal/mol
*     emax =  0.38484025E-06 a.u. =     0.00024149 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 19)
      data cf(  1)/  0.15160867210670587860277865D+01/
      data cf(  2)/ -0.17529667406199481201145945D-01/
      data cf(  3)/  0.25102894974057866986530530D+02/
      data cf(  4)/ -0.37805971479770946624460622D+03/
      data cf(  5)/  0.69022954522961692235756468D+04/
      data cf(  6)/ -0.14739812937212873831644509D+06/
      data cf(  7)/  0.28380805113597659895923514D+07/
      data cf(  8)/ -0.44109491072459989461846813D+08/
      data cf(  9)/  0.53516802773596441400773425D+09/
      data cf( 10)/ -0.50219095207171740257018843D+10/
      data cf( 11)/  0.36400655649015170116642451D+11/
      data cf( 12)/ -0.20365431313761015923626514D+12/
      data cf( 13)/  0.87587693752081711061511993D+12/
      data cf( 14)/ -0.28668262806230207268589605D+13/
      data cf( 15)/  0.70078535570743851000161712D+13/
      data cf( 16)/ -0.12382493591623064152889837D+14/
      data cf( 17)/  0.14933006638132530875557516D+14/
      data cf( 18)/ -0.10994794679907604666808684D+14/
      data cf( 19)/  0.37275001737650895916916198D+13/
      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.10977340790000000000000000D+01
      vex2=  0.11396102851300000000000000D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 19
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
         ener=ener+cf(i)*dux
    1 continue
      elong=elargomex2(r)
      ener=ener+elong
      dlargo=delargomex2(r)
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux+dlargo
      return
      end 
      
************************************************************************
C Derivative H2+_u
      subroutine dh2masu(r,ener,der)
************************************************************************
*     This subroutine computes the energies of a diatomic potential 
*     fitted to   118 points
*     rms =  0.78203646E-07 a.u. =     0.00004907 kcal/mol
*     emax =  0.38484025E-06 a.u. =     0.00024149 kcal/mol
************************************************************************
      implicit real*8 (a-h,o-z)
      dimension cf( 19)
      data cf(  1)/  0.15160867210670587860277865D+01/
      data cf(  2)/ -0.17529667406199481201145945D-01/
      data cf(  3)/  0.25102894974057866986530530D+02/
      data cf(  4)/ -0.37805971479770946624460622D+03/
      data cf(  5)/  0.69022954522961692235756468D+04/
      data cf(  6)/ -0.14739812937212873831644509D+06/
      data cf(  7)/  0.28380805113597659895923514D+07/
      data cf(  8)/ -0.44109491072459989461846813D+08/
      data cf(  9)/  0.53516802773596441400773425D+09/
      data cf( 10)/ -0.50219095207171740257018843D+10/
      data cf( 11)/  0.36400655649015170116642451D+11/
      data cf( 12)/ -0.20365431313761015923626514D+12/
      data cf( 13)/  0.87587693752081711061511993D+12/
      data cf( 14)/ -0.28668262806230207268589605D+13/
      data cf( 15)/  0.70078535570743851000161712D+13/
      data cf( 16)/ -0.12382493591623064152889837D+14/
      data cf( 17)/  0.14933006638132530875557516D+14/
      data cf( 18)/ -0.10994794679907604666808684D+14/
      data cf( 19)/  0.37275001737650895916916198D+13/
C      e0=  0.00000000000000000000000000D+00
      der=0.d0
      vex1=  0.10977340790000000000000000D+01
      vex2=  0.11396102851300000000000000D+01
      aux = 1.d0/r
      bux = dexp(-vex2*r)*aux
      cux = dexp(-vex1*r)
C      ener=e0+cf(1)*bux
      dux=1.d0
      eux=r*cux
      do 1 i=2, 19
         der=der+(i-1)*cf(i)*dux
         dux=dux*eux
C         ener=ener+cf(i)*dux
    1 continue
C      elong=elargomex2(r)
C     ener=ener+elong
      dlargo=delargomex2(r)
      der=der*(1.d0-vex1*r)*cux
      der=der-cf(1)*(vex2+aux)*bux+dlargo
      return
      end
*************************************************************
      subroutine triabb01(r12,r13,r23,ener,der)       
*************************************************************
*     This subroutine computes the energies of a 3D PES     
*     for the ABB system class fitted to **** points      
*     rms =      0.05563320 kcal/mol                              
*     emax =      0.00023876 kcal/mol                             
*************************************************************
      implicit real*8(a-h,o-z)                               
      dimension i1(  140),i2(  140),i3(  140),i4(  140),cf(  140)  
      dimension f12(0: 9),f13(0: 9),f23(0: 9)
      dimension der(3)
      parameter(RLIM=1000.d0)
      g(x)=x+RLIM*exp(-x)
      data cf(  1)/  0.2805947206339524D+00/
      data i1(  1)/ 1/,i2(  1)/ 1/,i3(  1)/ 0/,i4(  1)/ 2/
      data cf(  2)/ -0.3498306876493043D+01/
      data i1(  2)/ 1/,i2(  2)/ 0/,i3(  2)/ 1/,i4(  2)/ 1/
      data cf(  3)/  0.7775801449759275D+01/
      data i1(  3)/ 1/,i2(  3)/ 1/,i3(  3)/ 1/,i4(  3)/ 1/
      data cf(  4)/  0.1561519587674139D+01/
      data i1(  4)/ 2/,i2(  4)/ 1/,i3(  4)/ 0/,i4(  4)/ 2/
      data cf(  5)/  0.9706718552423204D+00/
      data i1(  5)/ 2/,i2(  5)/ 0/,i3(  5)/ 1/,i4(  5)/ 2/
      data cf(  6)/ -0.4514565414021415D-01/
      data i1(  6)/ 0/,i2(  6)/ 2/,i3(  6)/ 1/,i4(  6)/ 2/
      data cf(  7)/ -0.4626904302816675D+01/
      data i1(  7)/ 2/,i2(  7)/ 1/,i3(  7)/ 1/,i4(  7)/ 2/
      data cf(  8)/  0.7327418676131892D+01/
      data i1(  8)/ 1/,i2(  8)/ 2/,i3(  8)/ 1/,i4(  8)/ 1/
      data cf(  9)/  0.8264581877576615D+00/
      data i1(  9)/ 2/,i2(  9)/ 2/,i3(  9)/ 0/,i4(  9)/ 2/
      data cf( 10)/  0.3736573805168472D+02/
      data i1( 10)/ 2/,i2( 10)/ 0/,i3( 10)/ 2/,i4( 10)/ 1/
      data cf( 11)/ -0.6007007832962719D+01/
      data i1( 11)/ 3/,i2( 11)/ 1/,i3( 11)/ 0/,i4( 11)/ 2/
      data cf( 12)/  0.5241329798880382D+01/
      data i1( 12)/ 3/,i2( 12)/ 0/,i3( 12)/ 1/,i4( 12)/ 2/
      data cf( 13)/ -0.1187912722454251D+01/
      data i1( 13)/ 0/,i2( 13)/ 3/,i3( 13)/ 1/,i4( 13)/ 2/
      data cf( 14)/  0.2258420460813488D+02/
      data i1( 14)/ 2/,i2( 14)/ 2/,i3( 14)/ 1/,i4( 14)/ 2/
      data cf( 15)/ -0.1493626107333775D+02/
      data i1( 15)/ 2/,i2( 15)/ 1/,i3( 15)/ 2/,i4( 15)/ 1/
      data cf( 16)/ -0.6812836452861059D+02/
      data i1( 16)/ 3/,i2( 16)/ 1/,i3( 16)/ 1/,i4( 16)/ 2/
      data cf( 17)/ -0.2243145580707733D+02/
      data i1( 17)/ 1/,i2( 17)/ 3/,i3( 17)/ 1/,i4( 17)/ 1/
      data cf( 18)/  0.2658516994938437D+01/
      data i1( 18)/ 3/,i2( 18)/ 2/,i3( 18)/ 0/,i4( 18)/ 2/
      data cf( 19)/ -0.8236718313128675D+02/
      data i1( 19)/ 3/,i2( 19)/ 0/,i3( 19)/ 2/,i4( 19)/ 2/
      data cf( 20)/  0.3936321698645180D+01/
      data i1( 20)/ 0/,i2( 20)/ 3/,i3( 20)/ 2/,i4( 20)/ 2/
      data cf( 21)/ -0.2885595835993897D+02/
      data i1( 21)/ 4/,i2( 21)/ 1/,i3( 21)/ 0/,i4( 21)/ 2/
      data cf( 22)/  0.8593041430680982D+02/
      data i1( 22)/ 4/,i2( 22)/ 0/,i3( 22)/ 1/,i4( 22)/ 2/
      data cf( 23)/  0.3243813094190925D+00/
      data i1( 23)/ 0/,i2( 23)/ 4/,i3( 23)/ 1/,i4( 23)/ 2/
      data cf( 24)/ -0.1522239626505810D+02/
      data i1( 24)/ 2/,i2( 24)/ 2/,i3( 24)/ 2/,i4( 24)/ 1/
      data cf( 25)/  0.2419850155296026D+02/
      data i1( 25)/ 3/,i2( 25)/ 2/,i3( 25)/ 1/,i4( 25)/ 2/
      data cf( 26)/  0.7557967839372445D+01/
      data i1( 26)/ 3/,i2( 26)/ 1/,i3( 26)/ 2/,i4( 26)/ 2/
      data cf( 27)/ -0.4208328891474264D+01/
      data i1( 27)/ 1/,i2( 27)/ 3/,i3( 27)/ 2/,i4( 27)/ 2/
      data cf( 28)/  0.6346762139690777D+01/
      data i1( 28)/ 3/,i2( 28)/ 3/,i3( 28)/ 0/,i4( 28)/ 2/
      data cf( 29)/ -0.7529204614179546D+02/
      data i1( 29)/ 3/,i2( 29)/ 0/,i3( 29)/ 3/,i4( 29)/ 1/
      data cf( 30)/  0.5272786120877304D+02/
      data i1( 30)/ 4/,i2( 30)/ 1/,i3( 30)/ 1/,i4( 30)/ 2/
      data cf( 31)/ -0.8783377766330253D+01/
      data i1( 31)/ 1/,i2( 31)/ 4/,i3( 31)/ 1/,i4( 31)/ 1/
      data cf( 32)/ -0.3540838489651509D+02/
      data i1( 32)/ 4/,i2( 32)/ 2/,i3( 32)/ 0/,i4( 32)/ 2/
      data cf( 33)/  0.9388196900928369D+02/
      data i1( 33)/ 4/,i2( 33)/ 0/,i3( 33)/ 2/,i4( 33)/ 2/
      data cf( 34)/ -0.1124243652517645D+02/
      data i1( 34)/ 0/,i2( 34)/ 4/,i3( 34)/ 2/,i4( 34)/ 2/
      data cf( 35)/  0.7634216202457147D+02/
      data i1( 35)/ 5/,i2( 35)/ 1/,i3( 35)/ 0/,i4( 35)/ 2/
      data cf( 36)/ -0.7885874394761302D+02/
      data i1( 36)/ 5/,i2( 36)/ 0/,i3( 36)/ 1/,i4( 36)/ 2/
      data cf( 37)/ -0.3274692880538734D+00/
      data i1( 37)/ 0/,i2( 37)/ 5/,i3( 37)/ 1/,i4( 37)/ 2/
      data cf( 38)/  0.7408211158409573D+02/
      data i1( 38)/ 3/,i2( 38)/ 2/,i3( 38)/ 2/,i4( 38)/ 2/
      data cf( 39)/  0.6351204694915573D+02/
      data i1( 39)/ 2/,i2( 39)/ 3/,i3( 39)/ 2/,i4( 39)/ 1/
      data cf( 40)/ -0.1311567883963757D+02/
      data i1( 40)/ 3/,i2( 40)/ 3/,i3( 40)/ 1/,i4( 40)/ 2/
      data cf( 41)/ -0.2426039434256789D+03/
      data i1( 41)/ 3/,i2( 41)/ 1/,i3( 41)/ 3/,i4( 41)/ 1/
      data cf( 42)/ -0.5568527113037750D+02/
      data i1( 42)/ 4/,i2( 42)/ 2/,i3( 42)/ 1/,i4( 42)/ 2/
      data cf( 43)/  0.5597580034643215D+02/
      data i1( 43)/ 4/,i2( 43)/ 1/,i3( 43)/ 2/,i4( 43)/ 2/
      data cf( 44)/  0.2292826252635392D+02/
      data i1( 44)/ 1/,i2( 44)/ 4/,i3( 44)/ 2/,i4( 44)/ 2/
      data cf( 45)/ -0.2063277613377697D+02/
      data i1( 45)/ 4/,i2( 45)/ 3/,i3( 45)/ 0/,i4( 45)/ 2/
      data cf( 46)/  0.1804080111754617D+03/
      data i1( 46)/ 4/,i2( 46)/ 0/,i3( 46)/ 3/,i4( 46)/ 2/
      data cf( 47)/  0.6650572551543215D+02/
      data i1( 47)/ 0/,i2( 47)/ 4/,i3( 47)/ 3/,i4( 47)/ 2/
      data cf( 48)/ -0.1253622125113007D+03/
      data i1( 48)/ 5/,i2( 48)/ 1/,i3( 48)/ 1/,i4( 48)/ 2/
      data cf( 49)/ -0.2727200865664476D+01/
      data i1( 49)/ 1/,i2( 49)/ 5/,i3( 49)/ 1/,i4( 49)/ 1/
      data cf( 50)/  0.2970893211494113D+02/
      data i1( 50)/ 5/,i2( 50)/ 2/,i3( 50)/ 0/,i4( 50)/ 2/
      data cf( 51)/ -0.2784927021973857D+03/
      data i1( 51)/ 5/,i2( 51)/ 0/,i3( 51)/ 2/,i4( 51)/ 2/
      data cf( 52)/ -0.1736894025034768D+02/
      data i1( 52)/ 0/,i2( 52)/ 5/,i3( 52)/ 2/,i4( 52)/ 2/
      data cf( 53)/  0.1062242419016359D+03/
      data i1( 53)/ 6/,i2( 53)/ 1/,i3( 53)/ 0/,i4( 53)/ 2/
      data cf( 54)/ -0.1108080978091334D+03/
      data i1( 54)/ 6/,i2( 54)/ 0/,i3( 54)/ 1/,i4( 54)/ 2/
      data cf( 55)/ -0.8504339916463525D+01/
      data i1( 55)/ 0/,i2( 55)/ 6/,i3( 55)/ 1/,i4( 55)/ 2/
      data cf( 56)/  0.2262928975301577D+03/
      data i1( 56)/ 3/,i2( 56)/ 3/,i3( 56)/ 2/,i4( 56)/ 2/
      data cf( 57)/  0.2675489311783254D+03/
      data i1( 57)/ 3/,i2( 57)/ 2/,i3( 57)/ 3/,i4( 57)/ 1/
      data cf( 58)/ -0.1192551725304516D+03/
      data i1( 58)/ 4/,i2( 58)/ 2/,i3( 58)/ 2/,i4( 58)/ 2/
      data cf( 59)/ -0.3306641495756804D+03/
      data i1( 59)/ 2/,i2( 59)/ 4/,i3( 59)/ 2/,i4( 59)/ 1/
      data cf( 60)/  0.7149898919810732D+02/
      data i1( 60)/ 4/,i2( 60)/ 3/,i3( 60)/ 1/,i4( 60)/ 2/
      data cf( 61)/  0.5774163160216875D+03/
      data i1( 61)/ 4/,i2( 61)/ 1/,i3( 61)/ 3/,i4( 61)/ 2/
      data cf( 62)/ -0.1538765349090412D+03/
      data i1( 62)/ 1/,i2( 62)/ 4/,i3( 62)/ 3/,i4( 62)/ 2/
      data cf( 63)/ -0.2366519145722235D+02/
      data i1( 63)/ 4/,i2( 63)/ 4/,i3( 63)/ 0/,i4( 63)/ 2/
      data cf( 64)/  0.2342404092820819D+03/
      data i1( 64)/ 4/,i2( 64)/ 0/,i3( 64)/ 4/,i4( 64)/ 1/
      data cf( 65)/  0.2319695824905876D+01/
      data i1( 65)/ 5/,i2( 65)/ 2/,i3( 65)/ 1/,i4( 65)/ 2/
      data cf( 66)/  0.2759106947749279D+03/
      data i1( 66)/ 5/,i2( 66)/ 1/,i3( 66)/ 2/,i4( 66)/ 2/
      data cf( 67)/ -0.3001304266358301D+02/
      data i1( 67)/ 1/,i2( 67)/ 5/,i3( 67)/ 2/,i4( 67)/ 2/
      data cf( 68)/ -0.5048487524426685D+01/
      data i1( 68)/ 5/,i2( 68)/ 3/,i3( 68)/ 0/,i4( 68)/ 2/
      data cf( 69)/ -0.5636159143991656D+02/
      data i1( 69)/ 5/,i2( 69)/ 0/,i3( 69)/ 3/,i4( 69)/ 2/
      data cf( 70)/  0.2516121469870774D+02/
      data i1( 70)/ 0/,i2( 70)/ 5/,i3( 70)/ 3/,i4( 70)/ 2/
      data cf( 71)/  0.3896178598439000D+01/
      data i1( 71)/ 6/,i2( 71)/ 1/,i3( 71)/ 1/,i4( 71)/ 2/
      data cf( 72)/  0.1731715160466217D+02/
      data i1( 72)/ 1/,i2( 72)/ 6/,i3( 72)/ 1/,i4( 72)/ 1/
      data cf( 73)/ -0.1081544093009113D+03/
      data i1( 73)/ 6/,i2( 73)/ 2/,i3( 73)/ 0/,i4( 73)/ 2/
      data cf( 74)/ -0.2006569785585397D+03/
      data i1( 74)/ 6/,i2( 74)/ 0/,i3( 74)/ 2/,i4( 74)/ 2/
      data cf( 75)/  0.2015530152732097D+02/
      data i1( 75)/ 0/,i2( 75)/ 6/,i3( 75)/ 2/,i4( 75)/ 2/
      data cf( 76)/ -0.3887076923534646D+03/
      data i1( 76)/ 7/,i2( 76)/ 1/,i3( 76)/ 0/,i4( 76)/ 2/
      data cf( 77)/  0.4987008601932984D+03/
      data i1( 77)/ 7/,i2( 77)/ 0/,i3( 77)/ 1/,i4( 77)/ 2/
      data cf( 78)/  0.1670950379175182D+02/
      data i1( 78)/ 0/,i2( 78)/ 7/,i3( 78)/ 1/,i4( 78)/ 2/
      data cf( 79)/  0.6353339965985177D+03/
      data i1( 79)/ 3/,i2( 79)/ 3/,i3( 79)/ 3/,i4( 79)/ 1/
      data cf( 80)/ -0.1479903811933251D+02/
      data i1( 80)/ 4/,i2( 80)/ 3/,i3( 80)/ 2/,i4( 80)/ 2/
      data cf( 81)/  0.2376745228822637D+03/
      data i1( 81)/ 4/,i2( 81)/ 2/,i3( 81)/ 3/,i4( 81)/ 2/
      data cf( 82)/ -0.1480986306641688D+03/
      data i1( 82)/ 2/,i2( 82)/ 4/,i3( 82)/ 3/,i4( 82)/ 2/
      data cf( 83)/ -0.4057510103604826D+02/
      data i1( 83)/ 4/,i2( 83)/ 4/,i3( 83)/ 1/,i4( 83)/ 2/
      data cf( 84)/  0.1171804476450430D+04/
      data i1( 84)/ 4/,i2( 84)/ 1/,i3( 84)/ 4/,i4( 84)/ 1/
      data cf( 85)/ -0.1655913469438238D+03/
      data i1( 85)/ 5/,i2( 85)/ 2/,i3( 85)/ 2/,i4( 85)/ 2/
      data cf( 86)/ -0.2254315028742205D+03/
      data i1( 86)/ 2/,i2( 86)/ 5/,i3( 86)/ 2/,i4( 86)/ 1/
      data cf( 87)/  0.2045904233510814D+03/
      data i1( 87)/ 5/,i2( 87)/ 3/,i3( 87)/ 1/,i4( 87)/ 2/
      data cf( 88)/  0.4195743923689553D+03/
      data i1( 88)/ 5/,i2( 88)/ 1/,i3( 88)/ 3/,i4( 88)/ 2/
      data cf( 89)/ -0.6176890057796445D+02/
      data i1( 89)/ 1/,i2( 89)/ 5/,i3( 89)/ 3/,i4( 89)/ 2/
      data cf( 90)/  0.1658427840621088D+02/
      data i1( 90)/ 5/,i2( 90)/ 4/,i3( 90)/ 0/,i4( 90)/ 2/
      data cf( 91)/  0.1971507023886599D+03/
      data i1( 91)/ 5/,i2( 91)/ 0/,i3( 91)/ 4/,i4( 91)/ 2/
      data cf( 92)/  0.7845420692248556D+00/
      data i1( 92)/ 0/,i2( 92)/ 5/,i3( 92)/ 4/,i4( 92)/ 2/
      data cf( 93)/ -0.9643597995412899D+02/
      data i1( 93)/ 6/,i2( 93)/ 2/,i3( 93)/ 1/,i4( 93)/ 2/
      data cf( 94)/  0.1409888682065698D+03/
      data i1( 94)/ 6/,i2( 94)/ 1/,i3( 94)/ 2/,i4( 94)/ 2/
      data cf( 95)/  0.1383550418336167D+02/
      data i1( 95)/ 1/,i2( 95)/ 6/,i3( 95)/ 2/,i4( 95)/ 2/
      data cf( 96)/  0.2536530513572112D+02/
      data i1( 96)/ 6/,i2( 96)/ 3/,i3( 96)/ 0/,i4( 96)/ 2/
      data cf( 97)/  0.2793838943212204D+03/
      data i1( 97)/ 6/,i2( 97)/ 0/,i3( 97)/ 3/,i4( 97)/ 2/
      data cf( 98)/ -0.3322834472782176D+01/
      data i1( 98)/ 0/,i2( 98)/ 6/,i3( 98)/ 3/,i4( 98)/ 2/
      data cf( 99)/  0.2548948264657844D+03/
      data i1( 99)/ 7/,i2( 99)/ 1/,i3( 99)/ 1/,i4( 99)/ 2/
      data cf(100)/  0.3269660214265086D+02/
      data i1(100)/ 1/,i2(100)/ 7/,i3(100)/ 1/,i4(100)/ 1/
      data cf(101)/ -0.2325935302445301D+02/
      data i1(101)/ 7/,i2(101)/ 2/,i3(101)/ 0/,i4(101)/ 2/
      data cf(102)/ -0.7684881555268413D+03/
      data i1(102)/ 7/,i2(102)/ 0/,i3(102)/ 2/,i4(102)/ 2/
      data cf(103)/ -0.3755051060374750D+02/
      data i1(103)/ 0/,i2(103)/ 7/,i3(103)/ 2/,i4(103)/ 2/
      data cf(104)/  0.3163486068815891D+03/
      data i1(104)/ 8/,i2(104)/ 1/,i3(104)/ 0/,i4(104)/ 2/
      data cf(105)/  0.2064876006395800D+03/
      data i1(105)/ 8/,i2(105)/ 0/,i3(105)/ 1/,i4(105)/ 2/
      data cf(106)/  0.1315064932584855D+02/
      data i1(106)/ 0/,i2(106)/ 8/,i3(106)/ 1/,i4(106)/ 2/
      data cf(107)/ -0.1299435140568726D+03/
      data i1(107)/ 4/,i2(107)/ 3/,i3(107)/ 3/,i4(107)/ 2/
      data cf(108)/  0.7201273646771861D+03/
      data i1(108)/ 3/,i2(108)/ 4/,i3(108)/ 3/,i4(108)/ 1/
      data cf(109)/ -0.2692931389672003D+03/
      data i1(109)/ 4/,i2(109)/ 4/,i3(109)/ 2/,i4(109)/ 2/
      data cf(110)/ -0.1176322100614892D+04/
      data i1(110)/ 4/,i2(110)/ 2/,i3(110)/ 4/,i4(110)/ 1/
      data cf(111)/  0.1946636364789691D+03/
      data i1(111)/ 5/,i2(111)/ 3/,i3(111)/ 2/,i4(111)/ 2/
      data cf(112)/ -0.6889821017324270D+02/
      data i1(112)/ 5/,i2(112)/ 2/,i3(112)/ 3/,i4(112)/ 2/
      data cf(113)/  0.8360652359027201D+02/
      data i1(113)/ 2/,i2(113)/ 5/,i3(113)/ 3/,i4(113)/ 2/
      data cf(114)/ -0.4727599390543260D+03/
      data i1(114)/ 5/,i2(114)/ 4/,i3(114)/ 1/,i4(114)/ 2/
      data cf(115)/ -0.2781736432217880D+03/
      data i1(115)/ 5/,i2(115)/ 1/,i3(115)/ 4/,i4(115)/ 2/
      data cf(116)/  0.5530941282673659D+02/
      data i1(116)/ 1/,i2(116)/ 5/,i3(116)/ 4/,i4(116)/ 2/
      data cf(117)/  0.5366968849986887D+02/
      data i1(117)/ 5/,i2(117)/ 5/,i3(117)/ 0/,i4(117)/ 2/
      data cf(118)/ -0.2487551950296257D+04/
      data i1(118)/ 5/,i2(118)/ 0/,i3(118)/ 5/,i4(118)/ 1/
      data cf(119)/  0.1350401645680985D+03/
      data i1(119)/ 6/,i2(119)/ 2/,i3(119)/ 2/,i4(119)/ 2/
      data cf(120)/ -0.3223401056407143D+03/
      data i1(120)/ 2/,i2(120)/ 6/,i3(120)/ 2/,i4(120)/ 1/
      data cf(121)/  0.3921975167527883D+03/
      data i1(121)/ 6/,i2(121)/ 3/,i3(121)/ 1/,i4(121)/ 2/
      data cf(122)/  0.4372931888728234D+03/
      data i1(122)/ 6/,i2(122)/ 1/,i3(122)/ 3/,i4(122)/ 2/
      data cf(123)/ -0.3116106133829778D+02/
      data i1(123)/ 1/,i2(123)/ 6/,i3(123)/ 3/,i4(123)/ 2/
      data cf(124)/  0.2955748418589575D+03/
      data i1(124)/ 6/,i2(124)/ 4/,i3(124)/ 0/,i4(124)/ 2/
      data cf(125)/ -0.3209081635812802D+03/
      data i1(125)/ 6/,i2(125)/ 0/,i3(125)/ 4/,i4(125)/ 2/
      data cf(126)/ -0.8864378894884181D+02/
      data i1(126)/ 0/,i2(126)/ 6/,i3(126)/ 4/,i4(126)/ 2/
      data cf(127)/ -0.2276851294343045D+03/
      data i1(127)/ 7/,i2(127)/ 2/,i3(127)/ 1/,i4(127)/ 2/
      data cf(128)/  0.9269854355112246D+03/
      data i1(128)/ 7/,i2(128)/ 1/,i3(128)/ 2/,i4(128)/ 2/
      data cf(129)/  0.1091495289066335D+02/
      data i1(129)/ 1/,i2(129)/ 7/,i3(129)/ 2/,i4(129)/ 2/
      data cf(130)/  0.1357787760676430D+03/
      data i1(130)/ 7/,i2(130)/ 3/,i3(130)/ 0/,i4(130)/ 2/
      data cf(131)/  0.5914023859679505D+03/
      data i1(131)/ 7/,i2(131)/ 0/,i3(131)/ 3/,i4(131)/ 2/
      data cf(132)/ -0.2199897611559857D+02/
      data i1(132)/ 0/,i2(132)/ 7/,i3(132)/ 3/,i4(132)/ 2/
      data cf(133)/  0.1678491138931716D+03/
      data i1(133)/ 8/,i2(133)/ 1/,i3(133)/ 1/,i4(133)/ 2/
      data cf(134)/  0.4213201143832496D+02/
      data i1(134)/ 1/,i2(134)/ 8/,i3(134)/ 1/,i4(134)/ 1/
      data cf(135)/  0.9533295637934369D+03/
      data i1(135)/ 8/,i2(135)/ 2/,i3(135)/ 0/,i4(135)/ 2/
      data cf(136)/ -0.3649938567036642D+04/
      data i1(136)/ 8/,i2(136)/ 0/,i3(136)/ 2/,i4(136)/ 2/
      data cf(137)/ -0.2709575899620910D+02/
      data i1(137)/ 0/,i2(137)/ 8/,i3(137)/ 2/,i4(137)/ 2/
      data cf(138)/  0.2166636920940467D+03/
      data i1(138)/ 9/,i2(138)/ 1/,i3(138)/ 0/,i4(138)/ 2/
      data cf(139)/  0.2963079163122134D+03/
      data i1(139)/ 9/,i2(139)/ 0/,i3(139)/ 1/,i4(139)/ 2/
      data cf(140)/ -0.1354170318073010D+02/
      data i1(140)/ 0/,i2(140)/ 9/,i3(140)/ 1/,i4(140)/ 2/
      vex1=  0.1052683302805491D+01
      vex2=  0.6993498793793306D+00
      f12(0)=1.d0
      f13(0)=1.d0
      f23(0)=1.d0
      bux12=r12*dexp(-vex1*r12)
      bux13=r13*dexp(-vex1*r13)
      bux23=r23*dexp(-vex2*r23)
      bux12=bux12 - g(r12)*dexp(-vex1*g(r12))
      bux13=bux13 - g(r13)*dexp(-vex1*g(r13))
      bux23=bux23 - g(r23)*dexp(-vex2*g(r23))
      do 1 i=1, 9
         f12(i)=f12(i-1)*bux12
         f13(i)=f13(i-1)*bux13
         f23(i)=f23(i-1)*bux23
1     continue
      ener = 0.d0
      der12 = 0.d0
      der13 = 0.d0
      der23 = 0.d0
      do 2 l=1,140
         if (i4(l).eq.1) then                             
            aux=f12(i1(l))*f13(i3(l))*f23(i2(l))          
            dux12=i1(l)*f12(i1(l)-1)*f13(i3(l))*f23(i2(l))
            dux13=i3(l)*f12(i1(l))*f13(i3(l)-1)*f23(i2(l))
            dux23=i2(l)*f12(i1(l))*f13(i3(l))*f23(i2(l)-1)
         else                                             
            aux1=f12(i1(l))*f13(i3(l))                    
            aux2=f12(i3(l))*f13(i1(l))                    
            aux=(aux1+aux2)*f23(i2(l))                    
            dux23=(aux1+aux2)*i2(l)*f23(i2(l)-1)          
            dux1=i1(l)*f12(i1(l)-1)*f13(i3(l))            
            dux2=i3(l)*f12(i3(l)-1)*f13(i1(l))            
            dux12=(dux1+dux2)*f23(i2(l))                  
            dux1=i3(l)*f12(i1(l))*f13(i3(l)-1)            
            dux2=i1(l)*f12(i3(l))*f13(i1(l)-1)            
            dux13=(dux1+dux2)*f23(i2(l))                  
         endif                                            
         ener=ener+cf(l)*aux                              
         der12=der12+cf(l)*dux12                          
         der13=der13+cf(l)*dux13                          
         der23=der23+cf(l)*dux23                          
    2 continue                                          
      der(1)=der12*(1.d0-vex1*r12)*dexp(-vex1*r12)        
      der(2)=der13*(1.d0-vex1*r13)*dexp(-vex1*r13)        
      der(3)=der23*(1.d0-vex2*r23)*dexp(-vex2*r23)        
      return
      end
*************************************************************
      subroutine tabbnd01(r12,r13,r23,ener,der)       
*************************************************************
*     This subroutine computes the energies of a 3D PES     
*     for the ABB system class fitted to **** points      
*     rms =      0.05563320 kcal/mol                              
*     emax =      0.00023876 kcal/mol                             
*************************************************************
      implicit real*8(a-h,o-z)                               
      dimension i1(  140),i2(  140),i3(  140),i4(  140),cf(  140)  
      dimension f12(0: 9),f13(0: 9),f23(0: 9)
      dimension der(3)
      parameter(RLIM=1000.d0)
      g(x)=x+RLIM*exp(-x)
      data cf(  1)/ -0.1234592894436901D+01/
      data i1(  1)/ 1/,i2(  1)/ 1/,i3(  1)/ 0/,i4(  1)/ 2/
      data cf(  2)/ -0.4764606486379054D+00/
      data i1(  2)/ 1/,i2(  2)/ 0/,i3(  2)/ 1/,i4(  2)/ 1/
      data cf(  3)/ -0.2563355192989367D+01/
      data i1(  3)/ 1/,i2(  3)/ 1/,i3(  3)/ 1/,i4(  3)/ 1/
      data cf(  4)/ -0.4769592574835856D+00/
      data i1(  4)/ 2/,i2(  4)/ 1/,i3(  4)/ 0/,i4(  4)/ 2/
      data cf(  5)/ -0.4828534756987745D-01/
      data i1(  5)/ 2/,i2(  5)/ 0/,i3(  5)/ 1/,i4(  5)/ 2/
      data cf(  6)/  0.1181571041247655D+02/
      data i1(  6)/ 0/,i2(  6)/ 2/,i3(  6)/ 1/,i4(  6)/ 2/
      data cf(  7)/ -0.8476809063492934D+01/
      data i1(  7)/ 2/,i2(  7)/ 1/,i3(  7)/ 1/,i4(  7)/ 2/
      data cf(  8)/ -0.1562965389947724D+02/
      data i1(  8)/ 1/,i2(  8)/ 2/,i3(  8)/ 1/,i4(  8)/ 1/
      data cf(  9)/  0.9607633722868502D+01/
      data i1(  9)/ 2/,i2(  9)/ 2/,i3(  9)/ 0/,i4(  9)/ 2/
      data cf( 10)/ -0.1053659903698300D+01/
      data i1( 10)/ 2/,i2( 10)/ 0/,i3( 10)/ 2/,i4( 10)/ 1/
      data cf( 11)/ -0.3089482177030140D+01/
      data i1( 11)/ 3/,i2( 11)/ 1/,i3( 11)/ 0/,i4( 11)/ 2/
      data cf( 12)/  0.1921512389195535D+01/
      data i1( 12)/ 3/,i2( 12)/ 0/,i3( 12)/ 1/,i4( 12)/ 2/
      data cf( 13)/ -0.1996526831962033D+02/
      data i1( 13)/ 0/,i2( 13)/ 3/,i3( 13)/ 1/,i4( 13)/ 2/
      data cf( 14)/ -0.4002239966201548D+02/
      data i1( 14)/ 2/,i2( 14)/ 2/,i3( 14)/ 1/,i4( 14)/ 2/
      data cf( 15)/  0.4542970268634277D+02/
      data i1( 15)/ 2/,i2( 15)/ 1/,i3( 15)/ 2/,i4( 15)/ 1/
      data cf( 16)/ -0.1681249025049905D+01/
      data i1( 16)/ 3/,i2( 16)/ 1/,i3( 16)/ 1/,i4( 16)/ 2/
      data cf( 17)/  0.2325696516840286D+03/
      data i1( 17)/ 1/,i2( 17)/ 3/,i3( 17)/ 1/,i4( 17)/ 1/
      data cf( 18)/  0.5067382253577587D+02/
      data i1( 18)/ 3/,i2( 18)/ 2/,i3( 18)/ 0/,i4( 18)/ 2/
      data cf( 19)/ -0.2118417332785628D+01/
      data i1( 19)/ 3/,i2( 19)/ 0/,i3( 19)/ 2/,i4( 19)/ 2/
      data cf( 20)/ -0.1750849777269700D+03/
      data i1( 20)/ 0/,i2( 20)/ 3/,i3( 20)/ 2/,i4( 20)/ 2/
      data cf( 21)/  0.2158725298695713D+02/
      data i1( 21)/ 4/,i2( 21)/ 1/,i3( 21)/ 0/,i4( 21)/ 2/
      data cf( 22)/  0.2611095564266847D+01/
      data i1( 22)/ 4/,i2( 22)/ 0/,i3( 22)/ 1/,i4( 22)/ 2/
      data cf( 23)/ -0.2561568931591649D+03/
      data i1( 23)/ 0/,i2( 23)/ 4/,i3( 23)/ 1/,i4( 23)/ 2/
      data cf( 24)/ -0.4386250549705185D+01/
      data i1( 24)/ 2/,i2( 24)/ 2/,i3( 24)/ 2/,i4( 24)/ 1/
      data cf( 25)/ -0.3397781544777143D+02/
      data i1( 25)/ 3/,i2( 25)/ 2/,i3( 25)/ 1/,i4( 25)/ 2/
      data cf( 26)/ -0.3408346712337496D+02/
      data i1( 26)/ 3/,i2( 26)/ 1/,i3( 26)/ 2/,i4( 26)/ 2/
      data cf( 27)/ -0.1065684638781996D+03/
      data i1( 27)/ 1/,i2( 27)/ 3/,i3( 27)/ 2/,i4( 27)/ 2/
      data cf( 28)/  0.9983117046822235D+02/
      data i1( 28)/ 3/,i2( 28)/ 3/,i3( 28)/ 0/,i4( 28)/ 2/
      data cf( 29)/  0.1111993457555131D+02/
      data i1( 29)/ 3/,i2( 29)/ 0/,i3( 29)/ 3/,i4( 29)/ 1/
      data cf( 30)/  0.4694952761127709D+02/
      data i1( 30)/ 4/,i2( 30)/ 1/,i3( 30)/ 1/,i4( 30)/ 2/
      data cf( 31)/  0.5175078603016785D+03/
      data i1( 31)/ 1/,i2( 31)/ 4/,i3( 31)/ 1/,i4( 31)/ 1/
      data cf( 32)/  0.2843047578856050D+02/
      data i1( 32)/ 4/,i2( 32)/ 2/,i3( 32)/ 0/,i4( 32)/ 2/
      data cf( 33)/ -0.2819147125422518D+01/
      data i1( 33)/ 4/,i2( 33)/ 0/,i3( 33)/ 2/,i4( 33)/ 2/
      data cf( 34)/  0.3628421930800464D+03/
      data i1( 34)/ 0/,i2( 34)/ 4/,i3( 34)/ 2/,i4( 34)/ 2/
      data cf( 35)/ -0.1885550330473789D+02/
      data i1( 35)/ 5/,i2( 35)/ 1/,i3( 35)/ 0/,i4( 35)/ 2/
      data cf( 36)/  0.1089325540759684D+01/
      data i1( 36)/ 5/,i2( 36)/ 0/,i3( 36)/ 1/,i4( 36)/ 2/
      data cf( 37)/  0.5997257257210131D+03/
      data i1( 37)/ 0/,i2( 37)/ 5/,i3( 37)/ 1/,i4( 37)/ 2/
      data cf( 38)/  0.1092983621220956D+03/
      data i1( 38)/ 3/,i2( 38)/ 2/,i3( 38)/ 2/,i4( 38)/ 2/
      data cf( 39)/ -0.3866307466573507D+03/
      data i1( 39)/ 2/,i2( 39)/ 3/,i3( 39)/ 2/,i4( 39)/ 1/
      data cf( 40)/ -0.6841216912851234D+02/
      data i1( 40)/ 3/,i2( 40)/ 3/,i3( 40)/ 1/,i4( 40)/ 2/
      data cf( 41)/  0.1219988193056908D+02/
      data i1( 41)/ 3/,i2( 41)/ 1/,i3( 41)/ 3/,i4( 41)/ 1/
      data cf( 42)/ -0.1438164418001778D+03/
      data i1( 42)/ 4/,i2( 42)/ 2/,i3( 42)/ 1/,i4( 42)/ 2/
      data cf( 43)/ -0.2105035245869289D+02/
      data i1( 43)/ 4/,i2( 43)/ 1/,i3( 43)/ 2/,i4( 43)/ 2/
      data cf( 44)/ -0.8243379188518733D+02/
      data i1( 44)/ 1/,i2( 44)/ 4/,i3( 44)/ 2/,i4( 44)/ 2/
      data cf( 45)/ -0.8222164780948635D+02/
      data i1( 45)/ 4/,i2( 45)/ 3/,i3( 45)/ 0/,i4( 45)/ 2/
      data cf( 46)/  0.4037887258068896D+01/
      data i1( 46)/ 4/,i2( 46)/ 0/,i3( 46)/ 3/,i4( 46)/ 2/
      data cf( 47)/  0.1512994257300291D+03/
      data i1( 47)/ 0/,i2( 47)/ 4/,i3( 47)/ 3/,i4( 47)/ 2/
      data cf( 48)/  0.1038534295299858D+02/
      data i1( 48)/ 5/,i2( 48)/ 1/,i3( 48)/ 1/,i4( 48)/ 2/
      data cf( 49)/ -0.2686510861474785D+04/
      data i1( 49)/ 1/,i2( 49)/ 5/,i3( 49)/ 1/,i4( 49)/ 1/
      data cf( 50)/ -0.4683570289322045D+02/
      data i1( 50)/ 5/,i2( 50)/ 2/,i3( 50)/ 0/,i4( 50)/ 2/
      data cf( 51)/  0.2006661695479201D+02/
      data i1( 51)/ 5/,i2( 51)/ 0/,i3( 51)/ 2/,i4( 51)/ 2/
      data cf( 52)/  0.1644962327470806D+04/
      data i1( 52)/ 0/,i2( 52)/ 5/,i3( 52)/ 2/,i4( 52)/ 2/
      data cf( 53)/ -0.1119816038698669D+03/
      data i1( 53)/ 6/,i2( 53)/ 1/,i3( 53)/ 0/,i4( 53)/ 2/
      data cf( 54)/  0.1435923778581458D+02/
      data i1( 54)/ 6/,i2( 54)/ 0/,i3( 54)/ 1/,i4( 54)/ 2/
      data cf( 55)/ -0.6182997982205324D+03/
      data i1( 55)/ 0/,i2( 55)/ 6/,i3( 55)/ 1/,i4( 55)/ 2/
      data cf( 56)/  0.7254910971570033D+03/
      data i1( 56)/ 3/,i2( 56)/ 3/,i3( 56)/ 2/,i4( 56)/ 2/
      data cf( 57)/  0.6080155237373226D+02/
      data i1( 57)/ 3/,i2( 57)/ 2/,i3( 57)/ 3/,i4( 57)/ 1/
      data cf( 58)/ -0.2442549396863335D+03/
      data i1( 58)/ 4/,i2( 58)/ 2/,i3( 58)/ 2/,i4( 58)/ 2/
      data cf( 59)/ -0.2515165838471856D+04/
      data i1( 59)/ 2/,i2( 59)/ 4/,i3( 59)/ 2/,i4( 59)/ 1/
      data cf( 60)/  0.2560351913467586D+03/
      data i1( 60)/ 4/,i2( 60)/ 3/,i3( 60)/ 1/,i4( 60)/ 2/
      data cf( 61)/ -0.4023539282276295D+02/
      data i1( 61)/ 4/,i2( 61)/ 1/,i3( 61)/ 3/,i4( 61)/ 2/
      data cf( 62)/ -0.4942090263314970D+03/
      data i1( 62)/ 1/,i2( 62)/ 4/,i3( 62)/ 3/,i4( 62)/ 2/
      data cf( 63)/  0.5157273251987373D+02/
      data i1( 63)/ 4/,i2( 63)/ 4/,i3( 63)/ 0/,i4( 63)/ 2/
      data cf( 64)/  0.1221459494850513D+03/
      data i1( 64)/ 4/,i2( 64)/ 0/,i3( 64)/ 4/,i4( 64)/ 1/
      data cf( 65)/ -0.4562341558636475D+03/
      data i1( 65)/ 5/,i2( 65)/ 2/,i3( 65)/ 1/,i4( 65)/ 2/
      data cf( 66)/ -0.4375743935225700D+01/
      data i1( 66)/ 5/,i2( 66)/ 1/,i3( 66)/ 2/,i4( 66)/ 2/
      data cf( 67)/ -0.7768556064674326D+01/
      data i1( 67)/ 1/,i2( 67)/ 5/,i3( 67)/ 2/,i4( 67)/ 2/
      data cf( 68)/  0.5272495106589491D+03/
      data i1( 68)/ 5/,i2( 68)/ 3/,i3( 68)/ 0/,i4( 68)/ 2/
      data cf( 69)/ -0.5611456004216243D+02/
      data i1( 69)/ 5/,i2( 69)/ 0/,i3( 69)/ 3/,i4( 69)/ 2/
      data cf( 70)/  0.3654970330996985D+03/
      data i1( 70)/ 0/,i2( 70)/ 5/,i3( 70)/ 3/,i4( 70)/ 2/
      data cf( 71)/  0.2465889509216301D+03/
      data i1( 71)/ 6/,i2( 71)/ 1/,i3( 71)/ 1/,i4( 71)/ 2/
      data cf( 72)/ -0.4395195734880529D+04/
      data i1( 72)/ 1/,i2( 72)/ 6/,i3( 72)/ 1/,i4( 72)/ 1/
      data cf( 73)/ -0.1957796635897439D+03/
      data i1( 73)/ 6/,i2( 73)/ 2/,i3( 73)/ 0/,i4( 73)/ 2/
      data cf( 74)/ -0.3318965785298324D+02/
      data i1( 74)/ 6/,i2( 74)/ 0/,i3( 74)/ 2/,i4( 74)/ 2/
      data cf( 75)/  0.2489926608463350D+04/
      data i1( 75)/ 0/,i2( 75)/ 6/,i3( 75)/ 2/,i4( 75)/ 2/
      data cf( 76)/  0.1293340967488238D+03/
      data i1( 76)/ 7/,i2( 76)/ 1/,i3( 76)/ 0/,i4( 76)/ 2/
      data cf( 77)/ -0.9581270856944158D+02/
      data i1( 77)/ 7/,i2( 77)/ 0/,i3( 77)/ 1/,i4( 77)/ 2/
      data cf( 78)/  0.4490997676201340D+04/
      data i1( 78)/ 0/,i2( 78)/ 7/,i3( 78)/ 1/,i4( 78)/ 2/
      data cf( 79)/  0.3265888474998194D+03/
      data i1( 79)/ 3/,i2( 79)/ 3/,i3( 79)/ 3/,i4( 79)/ 1/
      data cf( 80)/ -0.1882443921770999D+02/
      data i1( 80)/ 4/,i2( 80)/ 3/,i3( 80)/ 2/,i4( 80)/ 2/
      data cf( 81)/ -0.6035988315967571D+02/
      data i1( 81)/ 4/,i2( 81)/ 2/,i3( 81)/ 3/,i4( 81)/ 2/
      data cf( 82)/ -0.1822503302713010D+03/
      data i1( 82)/ 2/,i2( 82)/ 4/,i3( 82)/ 3/,i4( 82)/ 2/
      data cf( 83)/ -0.7522769884819200D+03/
      data i1( 83)/ 4/,i2( 83)/ 4/,i3( 83)/ 1/,i4( 83)/ 2/
      data cf( 84)/ -0.5496224149855852D+02/
      data i1( 84)/ 4/,i2( 84)/ 1/,i3( 84)/ 4/,i4( 84)/ 1/
      data cf( 85)/  0.6556505365044338D+02/
      data i1( 85)/ 5/,i2( 85)/ 2/,i3( 85)/ 2/,i4( 85)/ 2/
      data cf( 86)/ -0.1302822243178012D+03/
      data i1( 86)/ 2/,i2( 86)/ 5/,i3( 86)/ 2/,i4( 86)/ 1/
      data cf( 87)/ -0.5765098717592973D+01/
      data i1( 87)/ 5/,i2( 87)/ 3/,i3( 87)/ 1/,i4( 87)/ 2/
      data cf( 88)/ -0.3547673081132025D+02/
      data i1( 88)/ 5/,i2( 88)/ 1/,i3( 88)/ 3/,i4( 88)/ 2/
      data cf( 89)/  0.5168537011425699D+03/
      data i1( 89)/ 1/,i2( 89)/ 5/,i3( 89)/ 3/,i4( 89)/ 2/
      data cf( 90)/  0.1126254943364509D+03/
      data i1( 90)/ 5/,i2( 90)/ 4/,i3( 90)/ 0/,i4( 90)/ 2/
      data cf( 91)/  0.9329637172789013D+02/
      data i1( 91)/ 5/,i2( 91)/ 0/,i3( 91)/ 4/,i4( 91)/ 2/
      data cf( 92)/ -0.2915974001053876D+04/
      data i1( 92)/ 0/,i2( 92)/ 5/,i3( 92)/ 4/,i4( 92)/ 2/
      data cf( 93)/ -0.1705340491398736D+03/
      data i1( 93)/ 6/,i2( 93)/ 2/,i3( 93)/ 1/,i4( 93)/ 2/
      data cf( 94)/ -0.4593198042814689D+02/
      data i1( 94)/ 6/,i2( 94)/ 1/,i3( 94)/ 2/,i4( 94)/ 2/
      data cf( 95)/  0.2676667694039463D+04/
      data i1( 95)/ 1/,i2( 95)/ 6/,i3( 95)/ 2/,i4( 95)/ 2/
      data cf( 96)/  0.4817439082240325D+03/
      data i1( 96)/ 6/,i2( 96)/ 3/,i3( 96)/ 0/,i4( 96)/ 2/
      data cf( 97)/  0.5009719488174567D+02/
      data i1( 97)/ 6/,i2( 97)/ 0/,i3( 97)/ 3/,i4( 97)/ 2/
      data cf( 98)/ -0.1533632896520267D+04/
      data i1( 98)/ 0/,i2( 98)/ 6/,i3( 98)/ 3/,i4( 98)/ 2/
      data cf( 99)/ -0.1066411209844007D+03/
      data i1( 99)/ 7/,i2( 99)/ 1/,i3( 99)/ 1/,i4( 99)/ 2/
      data cf(100)/  0.1117361633243177D+05/
      data i1(100)/ 1/,i2(100)/ 7/,i3(100)/ 1/,i4(100)/ 1/
      data cf(101)/ -0.3307484234917447D+02/
      data i1(101)/ 7/,i2(101)/ 2/,i3(101)/ 0/,i4(101)/ 2/
      data cf(102)/  0.1029867748381908D+03/
      data i1(102)/ 7/,i2(102)/ 0/,i3(102)/ 2/,i4(102)/ 2/
      data cf(103)/ -0.2130611733571985D+04/
      data i1(103)/ 0/,i2(103)/ 7/,i3(103)/ 2/,i4(103)/ 2/
      data cf(104)/ -0.1580616452393172D+03/
      data i1(104)/ 8/,i2(104)/ 1/,i3(104)/ 0/,i4(104)/ 2/
      data cf(105)/  0.6666744043036390D+02/
      data i1(105)/ 8/,i2(105)/ 0/,i3(105)/ 1/,i4(105)/ 2/
      data cf(106)/ -0.2364033596238808D+04/
      data i1(106)/ 0/,i2(106)/ 8/,i3(106)/ 1/,i4(106)/ 2/
      data cf(107)/  0.5594160349177736D+03/
      data i1(107)/ 4/,i2(107)/ 3/,i3(107)/ 3/,i4(107)/ 2/
      data cf(108)/  0.4531869969817846D+04/
      data i1(108)/ 3/,i2(108)/ 4/,i3(108)/ 3/,i4(108)/ 1/
      data cf(109)/ -0.1344641865450541D+04/
      data i1(109)/ 4/,i2(109)/ 4/,i3(109)/ 2/,i4(109)/ 2/
      data cf(110)/ -0.8029287710207345D+03/
      data i1(110)/ 4/,i2(110)/ 2/,i3(110)/ 4/,i4(110)/ 1/
      data cf(111)/ -0.2655671735455331D+03/
      data i1(111)/ 5/,i2(111)/ 3/,i3(111)/ 2/,i4(111)/ 2/
      data cf(112)/  0.7252946459788082D+02/
      data i1(112)/ 5/,i2(112)/ 2/,i3(112)/ 3/,i4(112)/ 2/
      data cf(113)/  0.3575108456368330D+04/
      data i1(113)/ 2/,i2(113)/ 5/,i3(113)/ 3/,i4(113)/ 2/
      data cf(114)/ -0.3582284795264992D+04/
      data i1(114)/ 5/,i2(114)/ 4/,i3(114)/ 1/,i4(114)/ 2/
      data cf(115)/ -0.2658492290545146D+03/
      data i1(115)/ 5/,i2(115)/ 1/,i3(115)/ 4/,i4(115)/ 2/
      data cf(116)/  0.6094219403343308D+04/
      data i1(116)/ 1/,i2(116)/ 5/,i3(116)/ 4/,i4(116)/ 2/
      data cf(117)/ -0.4796743646910030D+04/
      data i1(117)/ 5/,i2(117)/ 5/,i3(117)/ 0/,i4(117)/ 2/
      data cf(118)/ -0.4034645157683636D+03/
      data i1(118)/ 5/,i2(118)/ 0/,i3(118)/ 5/,i4(118)/ 1/
      data cf(119)/  0.9025775298214590D+03/
      data i1(119)/ 6/,i2(119)/ 2/,i3(119)/ 2/,i4(119)/ 2/
      data cf(120)/  0.1641685496871642D+05/
      data i1(120)/ 2/,i2(120)/ 6/,i3(120)/ 2/,i4(120)/ 1/
      data cf(121)/ -0.1020875264605494D+04/
      data i1(121)/ 6/,i2(121)/ 3/,i3(121)/ 1/,i4(121)/ 2/
      data cf(122)/ -0.1470881499150936D+03/
      data i1(122)/ 6/,i2(122)/ 1/,i3(122)/ 3/,i4(122)/ 2/
      data cf(123)/  0.5805600707111526D+04/
      data i1(123)/ 1/,i2(123)/ 6/,i3(123)/ 3/,i4(123)/ 2/
      data cf(124)/  0.1656703746118042D+03/
      data i1(124)/ 6/,i2(124)/ 4/,i3(124)/ 0/,i4(124)/ 2/
      data cf(125)/ -0.7425193298299414D+02/
      data i1(125)/ 6/,i2(125)/ 0/,i3(125)/ 4/,i4(125)/ 2/
      data cf(126)/ -0.3715039770638760D+03/
      data i1(126)/ 0/,i2(126)/ 6/,i3(126)/ 4/,i4(126)/ 2/
      data cf(127)/ -0.4573897631335376D+03/
      data i1(127)/ 7/,i2(127)/ 2/,i3(127)/ 1/,i4(127)/ 2/
      data cf(128)/ -0.1808889336710569D+03/
      data i1(128)/ 7/,i2(128)/ 1/,i3(128)/ 2/,i4(128)/ 2/
      data cf(129)/  0.8555065426068813D+04/
      data i1(129)/ 1/,i2(129)/ 7/,i3(129)/ 2/,i4(129)/ 2/
      data cf(130)/  0.1689144479950091D+04/
      data i1(130)/ 7/,i2(130)/ 3/,i3(130)/ 0/,i4(130)/ 2/
      data cf(131)/ -0.3442016985790168D+02/
      data i1(131)/ 7/,i2(131)/ 0/,i3(131)/ 3/,i4(131)/ 2/
      data cf(132)/ -0.2879298218953127D+04/
      data i1(132)/ 0/,i2(132)/ 7/,i3(132)/ 3/,i4(132)/ 2/
      data cf(133)/ -0.5566383892905589D+03/
      data i1(133)/ 8/,i2(133)/ 1/,i3(133)/ 1/,i4(133)/ 2/
      data cf(134)/  0.2977993095999765D+05/
      data i1(134)/ 1/,i2(134)/ 8/,i3(134)/ 1/,i4(134)/ 1/
      data cf(135)/  0.5862672456123189D+03/
      data i1(135)/ 8/,i2(135)/ 2/,i3(135)/ 0/,i4(135)/ 2/
      data cf(136)/  0.3087786938048933D+03/
      data i1(136)/ 8/,i2(136)/ 0/,i3(136)/ 2/,i4(136)/ 2/
      data cf(137)/ -0.5349444510588719D+05/
      data i1(137)/ 0/,i2(137)/ 8/,i3(137)/ 2/,i4(137)/ 2/
      data cf(138)/  0.9884170758833557D+01/
      data i1(138)/ 9/,i2(138)/ 1/,i3(138)/ 0/,i4(138)/ 2/
      data cf(139)/ -0.1378903876765284D+03/
      data i1(139)/ 9/,i2(139)/ 0/,i3(139)/ 1/,i4(139)/ 2/
      data cf(140)/  0.3733225647169655D+05/
      data i1(140)/ 0/,i2(140)/ 9/,i3(140)/ 1/,i4(140)/ 2/
      vex1=  0.9024706720664377D+00
      vex2=  0.1542099534511999D+01
      f12(0)=1.d0
      f13(0)=1.d0
      f23(0)=1.d0
      bux12=r12*dexp(-vex1*r12)
      bux13=r13*dexp(-vex1*r13)
      bux23=r23*dexp(-vex2*r23)
      bux12=bux12 - g(r12)*dexp(-vex1*g(r12))
      bux13=bux13 - g(r13)*dexp(-vex1*g(r13))
      bux23=bux23 - g(r23)*dexp(-vex2*g(r23))
      do 1 i=1, 9
         f12(i)=f12(i-1)*bux12
         f13(i)=f13(i-1)*bux13
         f23(i)=f23(i-1)*bux23
1     continue
      ener = 0.d0
      der12 = 0.d0
      der13 = 0.d0
      der23 = 0.d0
      do 2 l=1,140
         if (i4(l).eq.1) then                             
            aux=f12(i1(l))*f13(i3(l))*f23(i2(l))          
            dux12=i1(l)*f12(i1(l)-1)*f13(i3(l))*f23(i2(l))
            dux13=i3(l)*f12(i1(l))*f13(i3(l)-1)*f23(i2(l))
            dux23=i2(l)*f12(i1(l))*f13(i3(l))*f23(i2(l)-1)
         else                                             
            aux1=f12(i1(l))*f13(i3(l))                    
            aux2=f12(i3(l))*f13(i1(l))                    
            aux=(aux1+aux2)*f23(i2(l))                    
            dux23=(aux1+aux2)*i2(l)*f23(i2(l)-1)          
            dux1=i1(l)*f12(i1(l)-1)*f13(i3(l))            
            dux2=i3(l)*f12(i3(l)-1)*f13(i1(l))            
            dux12=(dux1+dux2)*f23(i2(l))                  
            dux1=i3(l)*f12(i1(l))*f13(i3(l)-1)            
            dux2=i1(l)*f12(i3(l))*f13(i1(l)-1)            
            dux13=(dux1+dux2)*f23(i2(l))                  
         endif                                            
         ener=ener+cf(l)*aux                              
         der12=der12+cf(l)*dux12                          
         der13=der13+cf(l)*dux13                          
         der23=der23+cf(l)*dux23                          
    2 continue                                          
      der(1)=der12*(1.d0-vex1*r12)*dexp(-vex1*r12)        
      der(2)=der13*(1.d0-vex1*r13)*dexp(-vex1*r13)        
      der(3)=der23*(1.d0-vex2*r23)*dexp(-vex2*r23)        
      return
      end
*************************************************************
      subroutine triabb02(r12,r13,r23,ener,der)       
*************************************************************
*     This subroutine computes the energies of a 3D PES     
*     for the ABB system class fitted to **** points      
*     rms =      0.05563320 kcal/mol                              
*     emax =      0.00023876 kcal/mol                             
*************************************************************
      implicit real*8(a-h,o-z)                               
      dimension i1(  140),i2(  140),i3(  140),i4(  140),cf(  140)  
      dimension f12(0: 9),f13(0: 9),f23(0: 9)
      dimension der(3)
      parameter(RLIM=1000.d0)
      g(x)=x+RLIM*exp(-x)
      data cf(  1)/ -0.7837547344897150D+01/
      data i1(  1)/ 1/,i2(  1)/ 1/,i3(  1)/ 0/,i4(  1)/ 2/
      data cf(  2)/ -0.8328422889107758D+00/
      data i1(  2)/ 1/,i2(  2)/ 0/,i3(  2)/ 1/,i4(  2)/ 1/
      data cf(  3)/  0.1893132950943776D+03/
      data i1(  3)/ 1/,i2(  3)/ 1/,i3(  3)/ 1/,i4(  3)/ 1/
      data cf(  4)/  0.5558035137995622D+02/
      data i1(  4)/ 2/,i2(  4)/ 1/,i3(  4)/ 0/,i4(  4)/ 2/
      data cf(  5)/ -0.4704876121148610D+02/
      data i1(  5)/ 2/,i2(  5)/ 0/,i3(  5)/ 1/,i4(  5)/ 2/
      data cf(  6)/  0.7565824103613439D+02/
      data i1(  6)/ 0/,i2(  6)/ 2/,i3(  6)/ 1/,i4(  6)/ 2/
      data cf(  7)/ -0.4559391109761962D+03/
      data i1(  7)/ 2/,i2(  7)/ 1/,i3(  7)/ 1/,i4(  7)/ 2/
      data cf(  8)/ -0.2847454672195699D+03/
      data i1(  8)/ 1/,i2(  8)/ 2/,i3(  8)/ 1/,i4(  8)/ 1/
      data cf(  9)/  0.7955298084239415D+02/
      data i1(  9)/ 2/,i2(  9)/ 2/,i3(  9)/ 0/,i4(  9)/ 2/
      data cf( 10)/  0.2476648996065476D+03/
      data i1( 10)/ 2/,i2( 10)/ 0/,i3( 10)/ 2/,i4( 10)/ 1/
      data cf( 11)/ -0.2381921343333218D+03/
      data i1( 11)/ 3/,i2( 11)/ 1/,i3( 11)/ 0/,i4( 11)/ 2/
      data cf( 12)/ -0.4152907682166412D+02/
      data i1( 12)/ 3/,i2( 12)/ 0/,i3( 12)/ 1/,i4( 12)/ 2/
      data cf( 13)/ -0.1004915859073004D+02/
      data i1( 13)/ 0/,i2( 13)/ 3/,i3( 13)/ 1/,i4( 13)/ 2/
      data cf( 14)/  0.1758381437991144D+04/
      data i1( 14)/ 2/,i2( 14)/ 2/,i3( 14)/ 1/,i4( 14)/ 2/
      data cf( 15)/ -0.1926422574463778D+04/
      data i1( 15)/ 2/,i2( 15)/ 1/,i3( 15)/ 2/,i4( 15)/ 1/
      data cf( 16)/  0.7872084801600150D+03/
      data i1( 16)/ 3/,i2( 16)/ 1/,i3( 16)/ 1/,i4( 16)/ 2/
      data cf( 17)/ -0.5970420210102190D+03/
      data i1( 17)/ 1/,i2( 17)/ 3/,i3( 17)/ 1/,i4( 17)/ 1/
      data cf( 18)/ -0.1227407573057689D+04/
      data i1( 18)/ 3/,i2( 18)/ 2/,i3( 18)/ 0/,i4( 18)/ 2/
      data cf( 19)/  0.1738196215636560D+03/
      data i1( 19)/ 3/,i2( 19)/ 0/,i3( 19)/ 2/,i4( 19)/ 2/
      data cf( 20)/ -0.8357819700501162D+03/
      data i1( 20)/ 0/,i2( 20)/ 3/,i3( 20)/ 2/,i4( 20)/ 2/
      data cf( 21)/  0.6417087497434820D+03/
      data i1( 21)/ 4/,i2( 21)/ 1/,i3( 21)/ 0/,i4( 21)/ 2/
      data cf( 22)/  0.3278388685740398D+03/
      data i1( 22)/ 4/,i2( 22)/ 0/,i3( 22)/ 1/,i4( 22)/ 2/
      data cf( 23)/ -0.2070186614598905D+04/
      data i1( 23)/ 0/,i2( 23)/ 4/,i3( 23)/ 1/,i4( 23)/ 2/
      data cf( 24)/  0.8331370236493639D+04/
      data i1( 24)/ 2/,i2( 24)/ 2/,i3( 24)/ 2/,i4( 24)/ 1/
      data cf( 25)/ -0.5799569246966053D+04/
      data i1( 25)/ 3/,i2( 25)/ 2/,i3( 25)/ 1/,i4( 25)/ 2/
      data cf( 26)/ -0.1163091951609647D+04/
      data i1( 26)/ 3/,i2( 26)/ 1/,i3( 26)/ 2/,i4( 26)/ 2/
      data cf( 27)/  0.3975356620434274D+04/
      data i1( 27)/ 1/,i2( 27)/ 3/,i3( 27)/ 2/,i4( 27)/ 2/
      data cf( 28)/  0.1315828596762939D+04/
      data i1( 28)/ 3/,i2( 28)/ 3/,i3( 28)/ 0/,i4( 28)/ 2/
      data cf( 29)/  0.4289559678873611D+03/
      data i1( 29)/ 3/,i2( 29)/ 0/,i3( 29)/ 3/,i4( 29)/ 1/
      data cf( 30)/ -0.9700429408986388D+03/
      data i1( 30)/ 4/,i2( 30)/ 1/,i3( 30)/ 1/,i4( 30)/ 2/
      data cf( 31)/ -0.1084033255962516D+05/
      data i1( 31)/ 1/,i2( 31)/ 4/,i3( 31)/ 1/,i4( 31)/ 1/
      data cf( 32)/  0.8578289661172716D+04/
      data i1( 32)/ 4/,i2( 32)/ 2/,i3( 32)/ 0/,i4( 32)/ 2/
      data cf( 33)/  0.8433180803046354D+03/
      data i1( 33)/ 4/,i2( 33)/ 0/,i3( 33)/ 2/,i4( 33)/ 2/
      data cf( 34)/ -0.6523679829732024D+04/
      data i1( 34)/ 0/,i2( 34)/ 4/,i3( 34)/ 2/,i4( 34)/ 2/
      data cf( 35)/  0.1355585917451022D+04/
      data i1( 35)/ 5/,i2( 35)/ 1/,i3( 35)/ 0/,i4( 35)/ 2/
      data cf( 36)/ -0.1155028472534049D+03/
      data i1( 36)/ 5/,i2( 36)/ 0/,i3( 36)/ 1/,i4( 36)/ 2/
      data cf( 37)/  0.2774438569763776D+04/
      data i1( 37)/ 0/,i2( 37)/ 5/,i3( 37)/ 1/,i4( 37)/ 2/
      data cf( 38)/ -0.4586471412021963D+04/
      data i1( 38)/ 3/,i2( 38)/ 2/,i3( 38)/ 2/,i4( 38)/ 2/
      data cf( 39)/  0.8664451523016074D+04/
      data i1( 39)/ 2/,i2( 39)/ 3/,i3( 39)/ 2/,i4( 39)/ 1/
      data cf( 40)/ -0.4814402897873182D+04/
      data i1( 40)/ 3/,i2( 40)/ 3/,i3( 40)/ 1/,i4( 40)/ 2/
      data cf( 41)/  0.2856370046487752D+04/
      data i1( 41)/ 3/,i2( 41)/ 1/,i3( 41)/ 3/,i4( 41)/ 1/
      data cf( 42)/ -0.3326481417265979D+04/
      data i1( 42)/ 4/,i2( 42)/ 2/,i3( 42)/ 1/,i4( 42)/ 2/
      data cf( 43)/  0.1723304057804626D+05/
      data i1( 43)/ 4/,i2( 43)/ 1/,i3( 43)/ 2/,i4( 43)/ 2/
      data cf( 44)/ -0.9910235915720798D+04/
      data i1( 44)/ 1/,i2( 44)/ 4/,i3( 44)/ 2/,i4( 44)/ 2/
      data cf( 45)/ -0.1725978291141156D+04/
      data i1( 45)/ 4/,i2( 45)/ 3/,i3( 45)/ 0/,i4( 45)/ 2/
      data cf( 46)/ -0.5461720282981267D+04/
      data i1( 46)/ 4/,i2( 46)/ 0/,i3( 46)/ 3/,i4( 46)/ 2/
      data cf( 47)/  0.5911119224180754D+04/
      data i1( 47)/ 0/,i2( 47)/ 4/,i3( 47)/ 3/,i4( 47)/ 2/
      data cf( 48)/ -0.1272841030464072D+04/
      data i1( 48)/ 5/,i2( 48)/ 1/,i3( 48)/ 1/,i4( 48)/ 2/
      data cf( 49)/  0.3919840499644242D+04/
      data i1( 49)/ 1/,i2( 49)/ 5/,i3( 49)/ 1/,i4( 49)/ 1/
      data cf( 50)/ -0.2989377514786091D+04/
      data i1( 50)/ 5/,i2( 50)/ 2/,i3( 50)/ 0/,i4( 50)/ 2/
      data cf( 51)/ -0.6709130579508804D+04/
      data i1( 51)/ 5/,i2( 51)/ 0/,i3( 51)/ 2/,i4( 51)/ 2/
      data cf( 52)/  0.3895654127677988D+05/
      data i1( 52)/ 0/,i2( 52)/ 5/,i3( 52)/ 2/,i4( 52)/ 2/
      data cf( 53)/ -0.1415824525241648D+05/
      data i1( 53)/ 6/,i2( 53)/ 1/,i3( 53)/ 0/,i4( 53)/ 2/
      data cf( 54)/  0.1881719690651238D+04/
      data i1( 54)/ 6/,i2( 54)/ 0/,i3( 54)/ 1/,i4( 54)/ 2/
      data cf( 55)/  0.2192078178153296D+05/
      data i1( 55)/ 0/,i2( 55)/ 6/,i3( 55)/ 1/,i4( 55)/ 2/
      data cf( 56)/ -0.1368511502149710D+05/
      data i1( 56)/ 3/,i2( 56)/ 3/,i3( 56)/ 2/,i4( 56)/ 2/
      data cf( 57)/ -0.3712041282491243D+04/
      data i1( 57)/ 3/,i2( 57)/ 2/,i3( 57)/ 3/,i4( 57)/ 1/
      data cf( 58)/  0.7951167959105582D+03/
      data i1( 58)/ 4/,i2( 58)/ 2/,i3( 58)/ 2/,i4( 58)/ 2/
      data cf( 59)/  0.7965258956609831D+04/
      data i1( 59)/ 2/,i2( 59)/ 4/,i3( 59)/ 2/,i4( 59)/ 1/
      data cf( 60)/  0.2257557488265686D+05/
      data i1( 60)/ 4/,i2( 60)/ 3/,i3( 60)/ 1/,i4( 60)/ 2/
      data cf( 61)/  0.1456549879511555D+05/
      data i1( 61)/ 4/,i2( 61)/ 1/,i3( 61)/ 3/,i4( 61)/ 2/
      data cf( 62)/ -0.2014426855072430D+05/
      data i1( 62)/ 1/,i2( 62)/ 4/,i3( 62)/ 3/,i4( 62)/ 2/
      data cf( 63)/ -0.2994799128686912D+05/
      data i1( 63)/ 4/,i2( 63)/ 4/,i3( 63)/ 0/,i4( 63)/ 2/
      data cf( 64)/  0.6030256602714968D+04/
      data i1( 64)/ 4/,i2( 64)/ 0/,i3( 64)/ 4/,i4( 64)/ 1/
      data cf( 65)/  0.1583713784670139D+03/
      data i1( 65)/ 5/,i2( 65)/ 2/,i3( 65)/ 1/,i4( 65)/ 2/
      data cf( 66)/  0.1187904989435147D+05/
      data i1( 66)/ 5/,i2( 66)/ 1/,i3( 66)/ 2/,i4( 66)/ 2/
      data cf( 67)/ -0.4357894725879515D+05/
      data i1( 67)/ 1/,i2( 67)/ 5/,i3( 67)/ 2/,i4( 67)/ 2/
      data cf( 68)/ -0.7462765208358827D+04/
      data i1( 68)/ 5/,i2( 68)/ 3/,i3( 68)/ 0/,i4( 68)/ 2/
      data cf( 69)/  0.1034127020912722D+05/
      data i1( 69)/ 5/,i2( 69)/ 0/,i3( 69)/ 3/,i4( 69)/ 2/
      data cf( 70)/  0.8139175340685540D+04/
      data i1( 70)/ 0/,i2( 70)/ 5/,i3( 70)/ 3/,i4( 70)/ 2/
      data cf( 71)/ -0.4324654873738463D+03/
      data i1( 71)/ 6/,i2( 71)/ 1/,i3( 71)/ 1/,i4( 71)/ 2/
      data cf( 72)/  0.8496653339151406D+04/
      data i1( 72)/ 1/,i2( 72)/ 6/,i3( 72)/ 1/,i4( 72)/ 1/
      data cf( 73)/ -0.1832460505725276D+04/
      data i1( 73)/ 6/,i2( 73)/ 2/,i3( 73)/ 0/,i4( 73)/ 2/
      data cf( 74)/ -0.6815475851029718D+03/
      data i1( 74)/ 6/,i2( 74)/ 0/,i3( 74)/ 2/,i4( 74)/ 2/
      data cf( 75)/  0.5120907346045616D+05/
      data i1( 75)/ 0/,i2( 75)/ 6/,i3( 75)/ 2/,i4( 75)/ 2/
      data cf( 76)/ -0.2674966284374449D+05/
      data i1( 76)/ 7/,i2( 76)/ 1/,i3( 76)/ 0/,i4( 76)/ 2/
      data cf( 77)/ -0.2614635110962668D+03/
      data i1( 77)/ 7/,i2( 77)/ 0/,i3( 77)/ 1/,i4( 77)/ 2/
      data cf( 78)/ -0.3458144126006364D+05/
      data i1( 78)/ 0/,i2( 78)/ 7/,i3( 78)/ 1/,i4( 78)/ 2/
      data cf( 79)/ -0.9541720606373286D+05/
      data i1( 79)/ 3/,i2( 79)/ 3/,i3( 79)/ 3/,i4( 79)/ 1/
      data cf( 80)/ -0.3384925991645640D+05/
      data i1( 80)/ 4/,i2( 80)/ 3/,i3( 80)/ 2/,i4( 80)/ 2/
      data cf( 81)/ -0.1618913844319111D+04/
      data i1( 81)/ 4/,i2( 81)/ 2/,i3( 81)/ 3/,i4( 81)/ 2/
      data cf( 82)/ -0.1937761720134679D+05/
      data i1( 82)/ 2/,i2( 82)/ 4/,i3( 82)/ 3/,i4( 82)/ 2/
      data cf( 83)/  0.4174883486414793D+05/
      data i1( 83)/ 4/,i2( 83)/ 4/,i3( 83)/ 1/,i4( 83)/ 2/
      data cf( 84)/  0.3764771136538473D+05/
      data i1( 84)/ 4/,i2( 84)/ 1/,i3( 84)/ 4/,i4( 84)/ 1/
      data cf( 85)/ -0.6355086580528263D+05/
      data i1( 85)/ 5/,i2( 85)/ 2/,i3( 85)/ 2/,i4( 85)/ 2/
      data cf( 86)/ -0.1714878822751730D+06/
      data i1( 86)/ 2/,i2( 86)/ 5/,i3( 86)/ 2/,i4( 86)/ 1/
      data cf( 87)/  0.9375752352918965D+05/
      data i1( 87)/ 5/,i2( 87)/ 3/,i3( 87)/ 1/,i4( 87)/ 2/
      data cf( 88)/  0.2029220311970410D+05/
      data i1( 88)/ 5/,i2( 88)/ 1/,i3( 88)/ 3/,i4( 88)/ 2/
      data cf( 89)/ -0.8454979484297661D+05/
      data i1( 89)/ 1/,i2( 89)/ 5/,i3( 89)/ 3/,i4( 89)/ 2/
      data cf( 90)/  0.8035428470041952D+03/
      data i1( 90)/ 5/,i2( 90)/ 4/,i3( 90)/ 0/,i4( 90)/ 2/
      data cf( 91)/  0.1562048295387231D+04/
      data i1( 91)/ 5/,i2( 91)/ 0/,i3( 91)/ 4/,i4( 91)/ 2/
      data cf( 92)/  0.2002624161192495D+05/
      data i1( 92)/ 0/,i2( 92)/ 5/,i3( 92)/ 4/,i4( 92)/ 2/
      data cf( 93)/  0.7375034428170918D+04/
      data i1( 93)/ 6/,i2( 93)/ 2/,i3( 93)/ 1/,i4( 93)/ 2/
      data cf( 94)/  0.2123812190351326D+05/
      data i1( 94)/ 6/,i2( 94)/ 1/,i3( 94)/ 2/,i4( 94)/ 2/
      data cf( 95)/ -0.2027271209247617D+06/
      data i1( 95)/ 1/,i2( 95)/ 6/,i3( 95)/ 2/,i4( 95)/ 2/
      data cf( 96)/  0.7442285618016746D+05/
      data i1( 96)/ 6/,i2( 96)/ 3/,i3( 96)/ 0/,i4( 96)/ 2/
      data cf( 97)/  0.8911579079079204D+04/
      data i1( 97)/ 6/,i2( 97)/ 0/,i3( 97)/ 3/,i4( 97)/ 2/
      data cf( 98)/ -0.1378774394318679D+05/
      data i1( 98)/ 0/,i2( 98)/ 6/,i3( 98)/ 3/,i4( 98)/ 2/
      data cf( 99)/  0.2063577587649332D+05/
      data i1( 99)/ 7/,i2( 99)/ 1/,i3( 99)/ 1/,i4( 99)/ 2/
      data cf(100)/  0.1782887108494913D+06/
      data i1(100)/ 1/,i2(100)/ 7/,i3(100)/ 1/,i4(100)/ 1/
      data cf(101)/ -0.3949359683699076D+05/
      data i1(101)/ 7/,i2(101)/ 2/,i3(101)/ 0/,i4(101)/ 2/
      data cf(102)/  0.1433389608085249D+05/
      data i1(102)/ 7/,i2(102)/ 0/,i3(102)/ 2/,i4(102)/ 2/
      data cf(103)/ -0.3773829079453925D+05/
      data i1(103)/ 0/,i2(103)/ 7/,i3(103)/ 2/,i4(103)/ 2/
      data cf(104)/  0.9025388857753488D+04/
      data i1(104)/ 8/,i2(104)/ 1/,i3(104)/ 0/,i4(104)/ 2/
      data cf(105)/ -0.2083484021076972D+05/
      data i1(105)/ 8/,i2(105)/ 0/,i3(105)/ 1/,i4(105)/ 2/
      data cf(106)/ -0.4856333092902333D+05/
      data i1(106)/ 0/,i2(106)/ 8/,i3(106)/ 1/,i4(106)/ 2/
      data cf(107)/  0.4976722538056133D+06/
      data i1(107)/ 4/,i2(107)/ 3/,i3(107)/ 3/,i4(107)/ 2/
      data cf(108)/  0.3929237058950502D+06/
      data i1(108)/ 3/,i2(108)/ 4/,i3(108)/ 3/,i4(108)/ 1/
      data cf(109)/ -0.1585736475647462D+06/
      data i1(109)/ 4/,i2(109)/ 4/,i3(109)/ 2/,i4(109)/ 2/
      data cf(110)/ -0.5262368375574458D+06/
      data i1(110)/ 4/,i2(110)/ 2/,i3(110)/ 4/,i4(110)/ 1/
      data cf(111)/ -0.9098992860753418D+05/
      data i1(111)/ 5/,i2(111)/ 3/,i3(111)/ 2/,i4(111)/ 2/
      data cf(112)/ -0.1201521827677071D+06/
      data i1(112)/ 5/,i2(112)/ 2/,i3(112)/ 3/,i4(112)/ 2/
      data cf(113)/  0.5050058538548991D+06/
      data i1(113)/ 2/,i2(113)/ 5/,i3(113)/ 3/,i4(113)/ 2/
      data cf(114)/  0.9979263663044500D+05/
      data i1(114)/ 5/,i2(114)/ 4/,i3(114)/ 1/,i4(114)/ 2/
      data cf(115)/ -0.9435892393961928D+05/
      data i1(115)/ 5/,i2(115)/ 1/,i3(115)/ 4/,i4(115)/ 2/
      data cf(116)/  0.3582195221490562D+06/
      data i1(116)/ 1/,i2(116)/ 5/,i3(116)/ 4/,i4(116)/ 2/
      data cf(117)/ -0.4387477361599418D+06/
      data i1(117)/ 5/,i2(117)/ 5/,i3(117)/ 0/,i4(117)/ 2/
      data cf(118)/ -0.1520279696472221D+06/
      data i1(118)/ 5/,i2(118)/ 0/,i3(118)/ 5/,i4(118)/ 1/
      data cf(119)/ -0.3344685988459269D+06/
      data i1(119)/ 6/,i2(119)/ 2/,i3(119)/ 2/,i4(119)/ 2/
      data cf(120)/  0.5944682443955185D+06/
      data i1(120)/ 2/,i2(120)/ 6/,i3(120)/ 2/,i4(120)/ 1/
      data cf(121)/  0.2011627866264273D+06/
      data i1(121)/ 6/,i2(121)/ 3/,i3(121)/ 1/,i4(121)/ 2/
      data cf(122)/  0.3569700717810818D+05/
      data i1(122)/ 6/,i2(122)/ 1/,i3(122)/ 3/,i4(122)/ 2/
      data cf(123)/  0.1661114050788475D+06/
      data i1(123)/ 1/,i2(123)/ 6/,i3(123)/ 3/,i4(123)/ 2/
      data cf(124)/ -0.5075559150282596D+05/
      data i1(124)/ 6/,i2(124)/ 4/,i3(124)/ 0/,i4(124)/ 2/
      data cf(125)/ -0.5531868734569294D+05/
      data i1(125)/ 6/,i2(125)/ 0/,i3(125)/ 4/,i4(125)/ 2/
      data cf(126)/  0.2224330680197138D+06/
      data i1(126)/ 0/,i2(126)/ 6/,i3(126)/ 4/,i4(126)/ 2/
      data cf(127)/ -0.2947570344751998D+06/
      data i1(127)/ 7/,i2(127)/ 2/,i3(127)/ 1/,i4(127)/ 2/
      data cf(128)/  0.7654299075877818D+05/
      data i1(128)/ 7/,i2(128)/ 1/,i3(128)/ 2/,i4(128)/ 2/
      data cf(129)/ -0.6476376774662797D+06/
      data i1(129)/ 1/,i2(129)/ 7/,i3(129)/ 2/,i4(129)/ 2/
      data cf(130)/  0.3527528409298632D+06/
      data i1(130)/ 7/,i2(130)/ 3/,i3(130)/ 0/,i4(130)/ 2/
      data cf(131)/  0.3557907312381371D+05/
      data i1(131)/ 7/,i2(131)/ 0/,i3(131)/ 3/,i4(131)/ 2/
      data cf(132)/ -0.2387686323122970D+06/
      data i1(132)/ 0/,i2(132)/ 7/,i3(132)/ 3/,i4(132)/ 2/
      data cf(133)/ -0.2859856309062379D+05/
      data i1(133)/ 8/,i2(133)/ 1/,i3(133)/ 1/,i4(133)/ 2/
      data cf(134)/  0.1676332188691858D+07/
      data i1(134)/ 1/,i2(134)/ 8/,i3(134)/ 1/,i4(134)/ 1/
      data cf(135)/ -0.2140107258662561D+06/
      data i1(135)/ 8/,i2(135)/ 2/,i3(135)/ 0/,i4(135)/ 2/
      data cf(136)/  0.3313195714831068D+05/
      data i1(136)/ 8/,i2(136)/ 0/,i3(136)/ 2/,i4(136)/ 2/
      data cf(137)/ -0.5802786536373766D+06/
      data i1(137)/ 0/,i2(137)/ 8/,i3(137)/ 2/,i4(137)/ 2/
      data cf(138)/  0.1963555121168694D+06/
      data i1(138)/ 9/,i2(138)/ 1/,i3(138)/ 0/,i4(138)/ 2/
      data cf(139)/ -0.1669658572256369D+06/
      data i1(139)/ 9/,i2(139)/ 0/,i3(139)/ 1/,i4(139)/ 2/
      data cf(140)/ -0.2335662130573570D+06/
      data i1(140)/ 0/,i2(140)/ 9/,i3(140)/ 1/,i4(140)/ 2/
      vex1=  0.1472584918521823D+01
      vex2=  0.1675388430956133D+01
      f12(0)=1.d0
      f13(0)=1.d0
      f23(0)=1.d0
      bux12=r12*dexp(-vex1*r12)
      bux13=r13*dexp(-vex1*r13)
      bux23=r23*dexp(-vex2*r23)
      bux12=bux12 - g(r12)*dexp(-vex1*g(r12))
      bux13=bux13 - g(r13)*dexp(-vex1*g(r13))
      bux23=bux23 - g(r23)*dexp(-vex2*g(r23))
      do 1 i=1, 9
         f12(i)=f12(i-1)*bux12
         f13(i)=f13(i-1)*bux13
         f23(i)=f23(i-1)*bux23
1     continue
      ener = 0.d0
      der12 = 0.d0
      der13 = 0.d0
      der23 = 0.d0
      do 2 l=1,140
         if (i4(l).eq.1) then                             
            aux=f12(i1(l))*f13(i3(l))*f23(i2(l))          
            dux12=i1(l)*f12(i1(l)-1)*f13(i3(l))*f23(i2(l))
            dux13=i3(l)*f12(i1(l))*f13(i3(l)-1)*f23(i2(l))
            dux23=i2(l)*f12(i1(l))*f13(i3(l))*f23(i2(l)-1)
         else                                             
            aux1=f12(i1(l))*f13(i3(l))                    
            aux2=f12(i3(l))*f13(i1(l))                    
            aux=(aux1+aux2)*f23(i2(l))                    
            dux23=(aux1+aux2)*i2(l)*f23(i2(l)-1)          
            dux1=i1(l)*f12(i1(l)-1)*f13(i3(l))            
            dux2=i3(l)*f12(i3(l)-1)*f13(i1(l))            
            dux12=(dux1+dux2)*f23(i2(l))                  
            dux1=i3(l)*f12(i1(l))*f13(i3(l)-1)            
            dux2=i1(l)*f12(i3(l))*f13(i1(l)-1)            
            dux13=(dux1+dux2)*f23(i2(l))                  
         endif                                            
         ener=ener+cf(l)*aux                              
         der12=der12+cf(l)*dux12                          
         der13=der13+cf(l)*dux13                          
         der23=der23+cf(l)*dux23                          
    2 continue                                          
      der(1)=der12*(1.d0-vex1*r12)*dexp(-vex1*r12)        
      der(2)=der13*(1.d0-vex1*r13)*dexp(-vex1*r13)        
      der(3)=der23*(1.d0-vex2*r23)*dexp(-vex2*r23)        
      return
      end
*************************************************************
      subroutine tabbnd02(r12,r13,r23,ener,der)       
*************************************************************
*     This subroutine computes the energies of a 3D PES     
*     for the ABB system class fitted to **** points      
*     rms =      0.05563320 kcal/mol                              
*     emax =      0.00023876 kcal/mol                             
*************************************************************
      implicit real*8(a-h,o-z)                               
      dimension i1(  140),i2(  140),i3(  140),i4(  140),cf(  140)  
      dimension f12(0: 9),f13(0: 9),f23(0: 9)
      dimension der(3)
      parameter(RLIM=1000.d0)
      g(x)=x+RLIM*exp(-x)
      data cf(  1)/  0.5222032679119670D+01/
      data i1(  1)/ 1/,i2(  1)/ 1/,i3(  1)/ 0/,i4(  1)/ 2/
      data cf(  2)/ -0.5582478948448899D+01/
      data i1(  2)/ 1/,i2(  2)/ 0/,i3(  2)/ 1/,i4(  2)/ 1/
      data cf(  3)/ -0.3316211549975470D+02/
      data i1(  3)/ 1/,i2(  3)/ 1/,i3(  3)/ 1/,i4(  3)/ 1/
      data cf(  4)/  0.1219498237743248D+01/
      data i1(  4)/ 2/,i2(  4)/ 1/,i3(  4)/ 0/,i4(  4)/ 2/
      data cf(  5)/  0.1208015546015239D+02/
      data i1(  5)/ 2/,i2(  5)/ 0/,i3(  5)/ 1/,i4(  5)/ 2/
      data cf(  6)/ -0.4233763281629705D+01/
      data i1(  6)/ 0/,i2(  6)/ 2/,i3(  6)/ 1/,i4(  6)/ 2/
      data cf(  7)/  0.8000353168902209D+02/
      data i1(  7)/ 2/,i2(  7)/ 1/,i3(  7)/ 1/,i4(  7)/ 2/
      data cf(  8)/  0.3429783963912695D+02/
      data i1(  8)/ 1/,i2(  8)/ 2/,i3(  8)/ 1/,i4(  8)/ 1/
      data cf(  9)/ -0.6879566940581300D+01/
      data i1(  9)/ 2/,i2(  9)/ 2/,i3(  9)/ 0/,i4(  9)/ 2/
      data cf( 10)/ -0.6550982210472176D+02/
      data i1( 10)/ 2/,i2( 10)/ 0/,i3( 10)/ 2/,i4( 10)/ 1/
      data cf( 11)/ -0.2622433397980719D+02/
      data i1( 11)/ 3/,i2( 11)/ 1/,i3( 11)/ 0/,i4( 11)/ 2/
      data cf( 12)/ -0.5080384966346802D+02/
      data i1( 12)/ 3/,i2( 12)/ 0/,i3( 12)/ 1/,i4( 12)/ 2/
      data cf( 13)/ -0.1810044627414249D+01/
      data i1( 13)/ 0/,i2( 13)/ 3/,i3( 13)/ 1/,i4( 13)/ 2/
      data cf( 14)/ -0.8396215424958998D+02/
      data i1( 14)/ 2/,i2( 14)/ 2/,i3( 14)/ 1/,i4( 14)/ 2/
      data cf( 15)/  0.1075955485647290D+03/
      data i1( 15)/ 2/,i2( 15)/ 1/,i3( 15)/ 2/,i4( 15)/ 1/
      data cf( 16)/ -0.7975133955950498D+02/
      data i1( 16)/ 3/,i2( 16)/ 1/,i3( 16)/ 1/,i4( 16)/ 2/
      data cf( 17)/  0.2184205146253717D+03/
      data i1( 17)/ 1/,i2( 17)/ 3/,i3( 17)/ 1/,i4( 17)/ 1/
      data cf( 18)/  0.9889032597213171D+00/
      data i1( 18)/ 3/,i2( 18)/ 2/,i3( 18)/ 0/,i4( 18)/ 2/
      data cf( 19)/  0.2744008856763070D+02/
      data i1( 19)/ 3/,i2( 19)/ 0/,i3( 19)/ 2/,i4( 19)/ 2/
      data cf( 20)/ -0.5611825262920126D+02/
      data i1( 20)/ 0/,i2( 20)/ 3/,i3( 20)/ 2/,i4( 20)/ 2/
      data cf( 21)/ -0.1249911969671910D+03/
      data i1( 21)/ 4/,i2( 21)/ 1/,i3( 21)/ 0/,i4( 21)/ 2/
      data cf( 22)/  0.1463014342537238D+03/
      data i1( 22)/ 4/,i2( 22)/ 0/,i3( 22)/ 1/,i4( 22)/ 2/
      data cf( 23)/  0.6315417139324614D+02/
      data i1( 23)/ 0/,i2( 23)/ 4/,i3( 23)/ 1/,i4( 23)/ 2/
      data cf( 24)/ -0.4781123890137205D+03/
      data i1( 24)/ 2/,i2( 24)/ 2/,i3( 24)/ 2/,i4( 24)/ 1/
      data cf( 25)/  0.1764810836685831D+03/
      data i1( 25)/ 3/,i2( 25)/ 2/,i3( 25)/ 1/,i4( 25)/ 2/
      data cf( 26)/ -0.7092840333336424D+03/
      data i1( 26)/ 3/,i2( 26)/ 1/,i3( 26)/ 2/,i4( 26)/ 2/
      data cf( 27)/  0.5477165187324090D+03/
      data i1( 27)/ 1/,i2( 27)/ 3/,i3( 27)/ 2/,i4( 27)/ 2/
      data cf( 28)/ -0.3740843050535221D+02/
      data i1( 28)/ 3/,i2( 28)/ 3/,i3( 28)/ 0/,i4( 28)/ 2/
      data cf( 29)/  0.5054233161138697D+03/
      data i1( 29)/ 3/,i2( 29)/ 0/,i3( 29)/ 3/,i4( 29)/ 1/
      data cf( 30)/  0.4232864817975622D+02/
      data i1( 30)/ 4/,i2( 30)/ 1/,i3( 30)/ 1/,i4( 30)/ 2/
      data cf( 31)/  0.1692227026110118D+03/
      data i1( 31)/ 1/,i2( 31)/ 4/,i3( 31)/ 1/,i4( 31)/ 1/
      data cf( 32)/  0.3898102259779054D+03/
      data i1( 32)/ 4/,i2( 32)/ 2/,i3( 32)/ 0/,i4( 32)/ 2/
      data cf( 33)/ -0.1841761507793333D+03/
      data i1( 33)/ 4/,i2( 33)/ 0/,i3( 33)/ 2/,i4( 33)/ 2/
      data cf( 34)/ -0.2125974484074657D+03/
      data i1( 34)/ 0/,i2( 34)/ 4/,i3( 34)/ 2/,i4( 34)/ 2/
      data cf( 35)/  0.4492842288772552D+03/
      data i1( 35)/ 5/,i2( 35)/ 1/,i3( 35)/ 0/,i4( 35)/ 2/
      data cf( 36)/  0.4083648133145709D+03/
      data i1( 36)/ 5/,i2( 36)/ 0/,i3( 36)/ 1/,i4( 36)/ 2/
      data cf( 37)/ -0.5886604017796640D+03/
      data i1( 37)/ 0/,i2( 37)/ 5/,i3( 37)/ 1/,i4( 37)/ 2/
      data cf( 38)/  0.1096428015952321D+04/
      data i1( 38)/ 3/,i2( 38)/ 2/,i3( 38)/ 2/,i4( 38)/ 2/
      data cf( 39)/ -0.1088203946045091D+04/
      data i1( 39)/ 2/,i2( 39)/ 3/,i3( 39)/ 2/,i4( 39)/ 1/
      data cf( 40)/ -0.2320068997831111D+03/
      data i1( 40)/ 3/,i2( 40)/ 3/,i3( 40)/ 1/,i4( 40)/ 2/
      data cf( 41)/  0.8236946546624374D+03/
      data i1( 41)/ 3/,i2( 41)/ 1/,i3( 41)/ 3/,i4( 41)/ 1/
      data cf( 42)/  0.1011045086509669D+03/
      data i1( 42)/ 4/,i2( 42)/ 2/,i3( 42)/ 1/,i4( 42)/ 2/
      data cf( 43)/  0.1677623078290733D+03/
      data i1( 43)/ 4/,i2( 43)/ 1/,i3( 43)/ 2/,i4( 43)/ 2/
      data cf( 44)/ -0.6746209222313653D+03/
      data i1( 44)/ 1/,i2( 44)/ 4/,i3( 44)/ 2/,i4( 44)/ 2/
      data cf( 45)/  0.6385167880217886D+03/
      data i1( 45)/ 4/,i2( 45)/ 3/,i3( 45)/ 0/,i4( 45)/ 2/
      data cf( 46)/  0.8982143852013266D+03/
      data i1( 46)/ 4/,i2( 46)/ 0/,i3( 46)/ 3/,i4( 46)/ 2/
      data cf( 47)/ -0.6643701383195343D+03/
      data i1( 47)/ 0/,i2( 47)/ 4/,i3( 47)/ 3/,i4( 47)/ 2/
      data cf( 48)/ -0.1069985205835169D+04/
      data i1( 48)/ 5/,i2( 48)/ 1/,i3( 48)/ 1/,i4( 48)/ 2/
      data cf( 49)/  0.8388262124180435D+03/
      data i1( 49)/ 1/,i2( 49)/ 5/,i3( 49)/ 1/,i4( 49)/ 1/
      data cf( 50)/ -0.5897375735132603D+03/
      data i1( 50)/ 5/,i2( 50)/ 2/,i3( 50)/ 0/,i4( 50)/ 2/
      data cf( 51)/  0.1856075974214246D+02/
      data i1( 51)/ 5/,i2( 51)/ 0/,i3( 51)/ 2/,i4( 51)/ 2/
      data cf( 52)/  0.2650863317621220D+03/
      data i1( 52)/ 0/,i2( 52)/ 5/,i3( 52)/ 2/,i4( 52)/ 2/
      data cf( 53)/  0.2199984524507599D+03/
      data i1( 53)/ 6/,i2( 53)/ 1/,i3( 53)/ 0/,i4( 53)/ 2/
      data cf( 54)/ -0.8617739273129733D+03/
      data i1( 54)/ 6/,i2( 54)/ 0/,i3( 54)/ 1/,i4( 54)/ 2/
      data cf( 55)/  0.5715267732116865D+03/
      data i1( 55)/ 0/,i2( 55)/ 6/,i3( 55)/ 1/,i4( 55)/ 2/
      data cf( 56)/  0.1090936661666613D+04/
      data i1( 56)/ 3/,i2( 56)/ 3/,i3( 56)/ 2/,i4( 56)/ 2/
      data cf( 57)/ -0.1619296753950112D+04/
      data i1( 57)/ 3/,i2( 57)/ 2/,i3( 57)/ 3/,i4( 57)/ 1/
      data cf( 58)/  0.1493991532982617D+04/
      data i1( 58)/ 4/,i2( 58)/ 2/,i3( 58)/ 2/,i4( 58)/ 2/
      data cf( 59)/ -0.9698051917627388D+03/
      data i1( 59)/ 2/,i2( 59)/ 4/,i3( 59)/ 2/,i4( 59)/ 1/
      data cf( 60)/  0.4985013468120443D+03/
      data i1( 60)/ 4/,i2( 60)/ 3/,i3( 60)/ 1/,i4( 60)/ 2/
      data cf( 61)/ -0.1485565398737336D+04/
      data i1( 61)/ 4/,i2( 61)/ 1/,i3( 61)/ 3/,i4( 61)/ 2/
      data cf( 62)/  0.2117405043665539D+03/
      data i1( 62)/ 1/,i2( 62)/ 4/,i3( 62)/ 3/,i4( 62)/ 2/
      data cf( 63)/  0.5885467850894133D+03/
      data i1( 63)/ 4/,i2( 63)/ 4/,i3( 63)/ 0/,i4( 63)/ 2/
      data cf( 64)/ -0.1698933120124713D+04/
      data i1( 64)/ 4/,i2( 64)/ 0/,i3( 64)/ 4/,i4( 64)/ 1/
      data cf( 65)/  0.1947286700313170D+04/
      data i1( 65)/ 5/,i2( 65)/ 2/,i3( 65)/ 1/,i4( 65)/ 2/
      data cf( 66)/ -0.5632108750439523D+03/
      data i1( 66)/ 5/,i2( 66)/ 1/,i3( 66)/ 2/,i4( 66)/ 2/
      data cf( 67)/ -0.1448251743279529D+04/
      data i1( 67)/ 1/,i2( 67)/ 5/,i3( 67)/ 2/,i4( 67)/ 2/
      data cf( 68)/  0.4935172916203839D+03/
      data i1( 68)/ 5/,i2( 68)/ 3/,i3( 68)/ 0/,i4( 68)/ 2/
      data cf( 69)/ -0.9429446799791722D+03/
      data i1( 69)/ 5/,i2( 69)/ 0/,i3( 69)/ 3/,i4( 69)/ 2/
      data cf( 70)/ -0.6793508654460368D+03/
      data i1( 70)/ 0/,i2( 70)/ 5/,i3( 70)/ 3/,i4( 70)/ 2/
      data cf( 71)/ -0.1329804226556532D+04/
      data i1( 71)/ 6/,i2( 71)/ 1/,i3( 71)/ 1/,i4( 71)/ 2/
      data cf( 72)/ -0.3069050355063872D+03/
      data i1( 72)/ 1/,i2( 72)/ 6/,i3( 72)/ 1/,i4( 72)/ 1/
      data cf( 73)/ -0.2086648814172576D+04/
      data i1( 73)/ 6/,i2( 73)/ 2/,i3( 73)/ 0/,i4( 73)/ 2/
      data cf( 74)/  0.1901755179618334D+03/
      data i1( 74)/ 6/,i2( 74)/ 0/,i3( 74)/ 2/,i4( 74)/ 2/
      data cf( 75)/  0.7125153739932183D+03/
      data i1( 75)/ 0/,i2( 75)/ 6/,i3( 75)/ 2/,i4( 75)/ 2/
      data cf( 76)/ -0.2870714648355877D+04/
      data i1( 76)/ 7/,i2( 76)/ 1/,i3( 76)/ 0/,i4( 76)/ 2/
      data cf( 77)/  0.7617284746140893D+03/
      data i1( 77)/ 7/,i2( 77)/ 0/,i3( 77)/ 1/,i4( 77)/ 2/
      data cf( 78)/  0.1778600595961722D+04/
      data i1( 78)/ 0/,i2( 78)/ 7/,i3( 78)/ 1/,i4( 78)/ 2/
      data cf( 79)/ -0.3168908158849778D+04/
      data i1( 79)/ 3/,i2( 79)/ 3/,i3( 79)/ 3/,i4( 79)/ 1/
      data cf( 80)/ -0.1648694170498399D+03/
      data i1( 80)/ 4/,i2( 80)/ 3/,i3( 80)/ 2/,i4( 80)/ 2/
      data cf( 81)/ -0.4010345008829348D+03/
      data i1( 81)/ 4/,i2( 81)/ 2/,i3( 81)/ 3/,i4( 81)/ 2/
      data cf( 82)/  0.1166349198306795D+04/
      data i1( 82)/ 2/,i2( 82)/ 4/,i3( 82)/ 3/,i4( 82)/ 2/
      data cf( 83)/ -0.2452304509699140D+04/
      data i1( 83)/ 4/,i2( 83)/ 4/,i3( 83)/ 1/,i4( 83)/ 2/
      data cf( 84)/  0.1691732906358984D+04/
      data i1( 84)/ 4/,i2( 84)/ 1/,i3( 84)/ 4/,i4( 84)/ 1/
      data cf( 85)/  0.2792366515320404D+04/
      data i1( 85)/ 5/,i2( 85)/ 2/,i3( 85)/ 2/,i4( 85)/ 2/
      data cf( 86)/  0.8523438609357061D+03/
      data i1( 86)/ 2/,i2( 86)/ 5/,i3( 86)/ 2/,i4( 86)/ 1/
      data cf( 87)/ -0.2181625338538407D+04/
      data i1( 87)/ 5/,i2( 87)/ 3/,i3( 87)/ 1/,i4( 87)/ 2/
      data cf( 88)/  0.7370168346124931D+03/
      data i1( 88)/ 5/,i2( 88)/ 1/,i3( 88)/ 3/,i4( 88)/ 2/
      data cf( 89)/ -0.5503572349847575D+03/
      data i1( 89)/ 1/,i2( 89)/ 5/,i3( 89)/ 3/,i4( 89)/ 2/
      data cf( 90)/  0.1232993526296050D+04/
      data i1( 90)/ 5/,i2( 90)/ 4/,i3( 90)/ 0/,i4( 90)/ 2/
      data cf( 91)/ -0.8852417501556669D+03/
      data i1( 91)/ 5/,i2( 91)/ 0/,i3( 91)/ 4/,i4( 91)/ 2/
      data cf( 92)/ -0.7821113513828482D+02/
      data i1( 92)/ 0/,i2( 92)/ 5/,i3( 92)/ 4/,i4( 92)/ 2/
      data cf( 93)/  0.2802085843505927D+04/
      data i1( 93)/ 6/,i2( 93)/ 2/,i3( 93)/ 1/,i4( 93)/ 2/
      data cf( 94)/  0.1009321637391508D+04/
      data i1( 94)/ 6/,i2( 94)/ 1/,i3( 94)/ 2/,i4( 94)/ 2/
      data cf( 95)/ -0.1668536327024182D+04/
      data i1( 95)/ 1/,i2( 95)/ 6/,i3( 95)/ 2/,i4( 95)/ 2/
      data cf( 96)/  0.3119322874691945D+03/
      data i1( 96)/ 6/,i2( 96)/ 3/,i3( 96)/ 0/,i4( 96)/ 2/
      data cf( 97)/ -0.6543036694506627D+03/
      data i1( 97)/ 6/,i2( 97)/ 0/,i3( 97)/ 3/,i4( 97)/ 2/
      data cf( 98)/ -0.1012087836170270D+04/
      data i1( 98)/ 0/,i2( 98)/ 6/,i3( 98)/ 3/,i4( 98)/ 2/
      data cf( 99)/ -0.6320774945435330D+03/
      data i1( 99)/ 7/,i2( 99)/ 1/,i3( 99)/ 1/,i4( 99)/ 2/
      data cf(100)/  0.1047537659542319D+04/
      data i1(100)/ 1/,i2(100)/ 7/,i3(100)/ 1/,i4(100)/ 1/
      data cf(101)/ -0.9140699064820048D+03/
      data i1(101)/ 7/,i2(101)/ 2/,i3(101)/ 0/,i4(101)/ 2/
      data cf(102)/  0.1557059000400515D+04/
      data i1(102)/ 7/,i2(102)/ 0/,i3(102)/ 2/,i4(102)/ 2/
      data cf(103)/ -0.1728821144058512D+03/
      data i1(103)/ 0/,i2(103)/ 7/,i3(103)/ 2/,i4(103)/ 2/
      data cf(104)/ -0.8424192281132375D+03/
      data i1(104)/ 8/,i2(104)/ 1/,i3(104)/ 0/,i4(104)/ 2/
      data cf(105)/  0.1840547331372023D+03/
      data i1(105)/ 8/,i2(105)/ 0/,i3(105)/ 1/,i4(105)/ 2/
      data cf(106)/  0.1125309813054644D+03/
      data i1(106)/ 0/,i2(106)/ 8/,i3(106)/ 1/,i4(106)/ 2/
      data cf(107)/ -0.9259365907978048D+04/
      data i1(107)/ 4/,i2(107)/ 3/,i3(107)/ 3/,i4(107)/ 2/
      data cf(108)/  0.1312544012350511D+05/
      data i1(108)/ 3/,i2(108)/ 4/,i3(108)/ 3/,i4(108)/ 1/
      data cf(109)/ -0.3199106166257688D+04/
      data i1(109)/ 4/,i2(109)/ 4/,i3(109)/ 2/,i4(109)/ 2/
      data cf(110)/ -0.1328468494061226D+05/
      data i1(110)/ 4/,i2(110)/ 2/,i3(110)/ 4/,i4(110)/ 1/
      data cf(111)/  0.4869363012899832D+04/
      data i1(111)/ 5/,i2(111)/ 3/,i3(111)/ 2/,i4(111)/ 2/
      data cf(112)/ -0.2991991128622602D+04/
      data i1(112)/ 5/,i2(112)/ 2/,i3(112)/ 3/,i4(112)/ 2/
      data cf(113)/  0.7175228019321758D+04/
      data i1(113)/ 2/,i2(113)/ 5/,i3(113)/ 3/,i4(113)/ 2/
      data cf(114)/ -0.8523315592684230D+04/
      data i1(114)/ 5/,i2(114)/ 4/,i3(114)/ 1/,i4(114)/ 2/
      data cf(115)/  0.1070659660360346D+04/
      data i1(115)/ 5/,i2(115)/ 1/,i3(115)/ 4/,i4(115)/ 2/
      data cf(116)/  0.5358315638049150D+03/
      data i1(116)/ 1/,i2(116)/ 5/,i3(116)/ 4/,i4(116)/ 2/
      data cf(117)/  0.5026631714688955D+04/
      data i1(117)/ 5/,i2(117)/ 5/,i3(117)/ 0/,i4(117)/ 2/
      data cf(118)/ -0.5102619850086367D+03/
      data i1(118)/ 5/,i2(118)/ 0/,i3(118)/ 5/,i4(118)/ 1/
      data cf(119)/  0.1999205103758513D+04/
      data i1(119)/ 6/,i2(119)/ 2/,i3(119)/ 2/,i4(119)/ 2/
      data cf(120)/  0.6680119095483052D+04/
      data i1(120)/ 2/,i2(120)/ 6/,i3(120)/ 2/,i4(120)/ 1/
      data cf(121)/ -0.6079425150026132D+04/
      data i1(121)/ 6/,i2(121)/ 3/,i3(121)/ 1/,i4(121)/ 2/
      data cf(122)/ -0.2165648785327001D+03/
      data i1(122)/ 6/,i2(122)/ 1/,i3(122)/ 3/,i4(122)/ 2/
      data cf(123)/ -0.1080529555689350D+04/
      data i1(123)/ 1/,i2(123)/ 6/,i3(123)/ 3/,i4(123)/ 2/
      data cf(124)/  0.2697586255013533D+04/
      data i1(124)/ 6/,i2(124)/ 4/,i3(124)/ 0/,i4(124)/ 2/
      data cf(125)/ -0.3036005605503763D+03/
      data i1(125)/ 6/,i2(125)/ 0/,i3(125)/ 4/,i4(125)/ 2/
      data cf(126)/ -0.2023113063973575D+04/
      data i1(126)/ 0/,i2(126)/ 6/,i3(126)/ 4/,i4(126)/ 2/
      data cf(127)/  0.2047548950417219D+05/
      data i1(127)/ 7/,i2(127)/ 2/,i3(127)/ 1/,i4(127)/ 2/
      data cf(128)/  0.5677498225963471D+03/
      data i1(128)/ 7/,i2(128)/ 1/,i3(128)/ 2/,i4(128)/ 2/
      data cf(129)/ -0.7948022437669285D+04/
      data i1(129)/ 1/,i2(129)/ 7/,i3(129)/ 2/,i4(129)/ 2/
      data cf(130)/  0.2619669727666864D+04/
      data i1(130)/ 7/,i2(130)/ 3/,i3(130)/ 0/,i4(130)/ 2/
      data cf(131)/  0.8495328774479731D+03/
      data i1(131)/ 7/,i2(131)/ 0/,i3(131)/ 3/,i4(131)/ 2/
      data cf(132)/ -0.5615593573318582D+04/
      data i1(132)/ 0/,i2(132)/ 7/,i3(132)/ 3/,i4(132)/ 2/
      data cf(133)/  0.1418108924541734D+05/
      data i1(133)/ 8/,i2(133)/ 1/,i3(133)/ 1/,i4(133)/ 2/
      data cf(134)/ -0.8870560025078181D+04/
      data i1(134)/ 1/,i2(134)/ 8/,i3(134)/ 1/,i4(134)/ 1/
      data cf(135)/  0.4095921065931130D+04/
      data i1(135)/ 8/,i2(135)/ 2/,i3(135)/ 0/,i4(135)/ 2/
      data cf(136)/  0.5117647656520908D+04/
      data i1(136)/ 8/,i2(136)/ 0/,i3(136)/ 2/,i4(136)/ 2/
      data cf(137)/ -0.3682787013351079D+04/
      data i1(137)/ 0/,i2(137)/ 8/,i3(137)/ 2/,i4(137)/ 2/
      data cf(138)/  0.5776580142517152D+04/
      data i1(138)/ 9/,i2(138)/ 1/,i3(138)/ 0/,i4(138)/ 2/
      data cf(139)/ -0.1827217839581786D+04/
      data i1(139)/ 9/,i2(139)/ 0/,i3(139)/ 1/,i4(139)/ 2/
      data cf(140)/ -0.4490409489952874D+04/
      data i1(140)/ 0/,i2(140)/ 9/,i3(140)/ 1/,i4(140)/ 2/
      vex1=  0.1275720227332551D+01
      vex2=  0.1154031324873908D+01
      f12(0)=1.d0
      f13(0)=1.d0
      f23(0)=1.d0
      bux12=r12*dexp(-vex1*r12)
      bux13=r13*dexp(-vex1*r13)
      bux23=r23*dexp(-vex2*r23)
      bux12=bux12 - g(r12)*dexp(-vex1*g(r12))
      bux13=bux13 - g(r13)*dexp(-vex1*g(r13))
      bux23=bux23 - g(r23)*dexp(-vex2*g(r23))
      do 1 i=1, 9
         f12(i)=f12(i-1)*bux12
         f13(i)=f13(i-1)*bux13
         f23(i)=f23(i-1)*bux23
1     continue
      ener = 0.d0
      der12 = 0.d0
      der13 = 0.d0
      der23 = 0.d0
      do 2 l=1,140
         if (i4(l).eq.1) then                             
            aux=f12(i1(l))*f13(i3(l))*f23(i2(l))          
            dux12=i1(l)*f12(i1(l)-1)*f13(i3(l))*f23(i2(l))
            dux13=i3(l)*f12(i1(l))*f13(i3(l)-1)*f23(i2(l))
            dux23=i2(l)*f12(i1(l))*f13(i3(l))*f23(i2(l)-1)
         else                                             
            aux1=f12(i1(l))*f13(i3(l))                    
            aux2=f12(i3(l))*f13(i1(l))                    
            aux=(aux1+aux2)*f23(i2(l))                    
            dux23=(aux1+aux2)*i2(l)*f23(i2(l)-1)          
            dux1=i1(l)*f12(i1(l)-1)*f13(i3(l))            
            dux2=i3(l)*f12(i3(l)-1)*f13(i1(l))            
            dux12=(dux1+dux2)*f23(i2(l))                  
            dux1=i3(l)*f12(i1(l))*f13(i3(l)-1)            
            dux2=i1(l)*f12(i3(l))*f13(i1(l)-1)            
            dux13=(dux1+dux2)*f23(i2(l))                  
         endif                                            
         ener=ener+cf(l)*aux                              
         der12=der12+cf(l)*dux12                          
         der13=der13+cf(l)*dux13                          
         der23=der23+cf(l)*dux23                          
    2 continue                                          
      der(1)=der12*(1.d0-vex1*r12)*dexp(-vex1*r12)        
      der(2)=der13*(1.d0-vex1*r13)*dexp(-vex1*r13)        
      der(3)=der23*(1.d0-vex2*r23)*dexp(-vex2*r23)        
      return
      end
