module dimmatrix
  implicit none
  public :: poth3ps,HmatSNGLT, dHmatSNGLTr1, dHmatSNGLTr2, dHmatSNGLTr3
  private :: Hmatlong, dhmatlongr1, dhmatlongr2, dhmatlongr3
 !Global variables for Hmatlong and its derivatives
  real(kind=8),parameter, private :: ve1= -7.01621562459723937362055959631495703d0
  real(kind=8),parameter, private :: ve2=  22.0370588396508481196639211454012227d0
  real(kind=8),parameter, private :: ve3=  24.0261669248609443512144493446810140d0
  real(kind=8),parameter, private :: ve4= -58.2812394589862088190764429762273926d0
  real(kind=8),parameter, private :: ve5=  11.0797514171293179020725540208936220d0
  real(kind=8),parameter, private :: ve6= -33.6696064315535173898685881693160887d0
  real(kind=8),parameter, private :: vf1= 0.591081055952138559741889527377755190d0
  real(kind=8),parameter, private :: vf2= -4.52420419051493610099164761029869668d0
  real(kind=8),parameter, private :: vf3=-0.229307036828269126432392424139460469d0
  real(kind=8),parameter, private :: vf4= 0.513469242308439028997502940712689384d0
  real(kind=8),parameter, private :: vf5= -4.83320212389903627847005818308801113d0
  real(kind=8),parameter, private :: vf6=  10.3849728424843113188885559738687392d0
  real(kind=8), parameter :: RLIM=20.d0 
  real(kind=8), parameter :: delta=1.d-05,delta2=1.0d-05,vex=2.0d0
  integer, parameter :: ndim=3
  integer, parameter :: nex=2
  real(kind=8), parameter :: a1=4.5d0,a2=15.d0

contains
   subroutine poth3ps(r1,r2,r3,dia)
   implicit none
   real(kind=8), intent(in) :: r1,r2,r3
   real(kind=8), intent(out), dimension(ndim,ndim) :: dia
   real(kind=8), dimension(ndim,ndim) :: eigvec
   real(kind=8) :: eabbd1,eabbd2,eabbnd1,eabbnd2
   real(kind=8),dimension(ndim) :: dabbd1,dabbd2,dabbnd1,dabbnd2

        call hmatsnglt(r1,r2,r3,dia(:,:))
     !! H11
        call triabb01(r2,r3,r1,eabbd1,dabbd1)
        call triabb02(r2,r3,r1,eabbd2,dabbd2)
        dia(1,1)=dia(1,1)+eabbd1+eabbd2
     !! H22
        call triabb01(r1,r3,r2,eabbd1,dabbd1)
        call triabb02(r1,r3,r2,eabbd2,dabbd2)
        dia(2,2)=dia(2,2)+eabbd1+eabbd2
     !! H33
        call triabb01(r1,r2,r3,eabbd1,dabbd1)
        call triabb02(r1,r2,r3,eabbd2,dabbd2)
        dia(3,3)=dia(3,3)+eabbd1+eabbd2
     !! H12
        call tabbnd01(r1,r2,r3,eabbd1,dabbd1)
        call tabbnd02(r1,r2,r3,eabbd2,dabbd2)
        dia(1,2)=dia(1,2)+eabbd1+eabbd2
        dia(2,1)=dia(1,2)
     !! H13
        call tabbnd01(r1,r3,r2,eabbd1,dabbd1)
        call tabbnd02(r1,r3,r2,eabbd2,dabbd2)
        dia(1,3)=dia(1,3)+eabbd1+eabbd2
        dia(3,1)=dia(1,3)
     !! H23
        call tabbnd01(r2,r3,r1,eabbd1,dabbd1)
        call tabbnd02(r2,r3,r1,eabbd2,dabbd2)
        dia(2,3)=dia(2,3)+eabbd1+eabbd2
        dia(3,2)=dia(2,3)
        
   return
 end subroutine poth3ps
 
!!! Hmatsnglt 
  
    subroutine  HmatSNGLT(r1,r2,r3,Hdim)
      implicit none
      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim,ndim), intent(out) :: Hdim
      real(kind=8) :: xmasgr1,xmasgr2,xmasgr3,eh2,d
      real(kind=8) :: xmasur1,xmasur2,xmasur3
      real(kind=8), dimension(3) :: vlong,vllong
      integer :: i,j

      call h2masg(r1,xmasgr1,d)
      call h2masg(r2,xmasgr2,d)
      call h2masg(r3,xmasgr3,d)
      call h2masu(r1,xmasur1,d)
      call h2masu(r2,xmasur2,d)
      call h2masu(r3,xmasur3,d)
      call h2(r1,eh2,d)
      Hdim(1,1)=eh2&
     &       +0.5d0*(xmasgr2+xmasur2+xmasgr3+xmasur3)
      call h2(r2,eh2,d)
      Hdim(2,2)=eh2&
     &       +0.5d0*(xmasgr1+xmasur1+xmasgr3+xmasur3)
      call h2(r3,eh2,d)
      Hdim(3,3)=eh2&
     &       +0.5d0*(xmasgr1+xmasur1+xmasgr2+xmasur2)

      Hdim(1,2)=0.5d0*(xmasgr3-xmasur3)
      Hdim(2,1)=Hdim(1,2)
      Hdim(1,3)=0.5d0*(xmasgr2-xmasur2)
      Hdim(3,1)=Hdim(1,3)
      Hdim(2,3)=0.5d0*(xmasgr1-xmasur1)
      Hdim(3,2)=Hdim(2,3)

!     Anado terminos de largo rango al TRIM (terminos diagonales solo)      
      call Hmatlong(r1,r2,r3,vlong)
!      vlong(:)=0.d0 !testing hdim derivative
      do i=1,ndim
        Hdim(i,i)=Hdim(i,i) + vlong(i)
     enddo
!     write(98,'(3(f9.6,1x),1x,40(f20.15,1x))')r1,r2,r3,hdim(1,1),hdim(2,2),&
!    &          hdim(3,3),hdim(1,2),hdim(1,3),hdim(2,3),vlong(1),vlong(2),vlong(3)    
     
      return
    end subroutine HmatSNGLT

! 
!Derivatives of the dim matrix
!
!dHmatsnglr1    
    subroutine dHmatSNGLTr1(r1,r2,r3,Hdim)
      implicit none
      real(kind=8), dimension(ndim,ndim),intent(out) :: Hdim
      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim) :: vlong
      real(kind=8) :: dh2masgr1,dh2masgr2,dh2masgr3
      real(kind=8) :: dh2masur1,dh2masur2,dh2masur3
      real(kind=8) :: dh2snglt
      integer :: i

      if(ndim.ne.3)print*,"Warning: ndim different to 3"
 
      call dh2masg(r1,dh2masgr1)
      dh2masgr2= 0.d0
      dh2masgr3= 0.d0
      call dh2masu(r1,dh2masur1)
      dh2masur2= 0.d0
      dh2masur3= 0.d0
      call dh2(r1,dh2snglt)
      Hdim(1,1)= dh2snglt&
     &       +0.5d0*(dh2masgr2+dh2masur2+dh2masgr3+dh2masur3)
      Hdim(2,2)= 0.d0&
     &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr3+dh2masur3)
      Hdim(3,3)=0.d0&
           &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr2+dh2masur2)
!      print*,"Cris",r1,r2,r3,Hdim(1,1),Hdim(2,2),Hdim(3,3)
!     Adding the long term derivatives to the diagonal terms
      call dHmatlongr1(r1,r2,r3,vlong) !should be like this
!      print*,"Cris",r1,r2,r3,vlong(1),vlong(2),vlong(3)
!      vlong(:)=0.d0 !testing hdim derivative
      do i=1,ndim
        Hdim(i,i)=Hdim(i,i) + vlong(i)
      enddo
      Hdim(1,2)=0.5d0*(dh2masgr3-dh2masur3)
      Hdim(2,1)=Hdim(1,2)
      Hdim(1,3)=0.5d0*(dh2masgr2-dh2masur2)
      Hdim(3,1)=Hdim(1,3)
      Hdim(2,3)=0.5d0*(dh2masgr1-dh2masur1)
      Hdim(3,2)=Hdim(2,3)

!      write(99,'(1(f9.6,1x),1x,40(f20.15,1x))')r1,r2,r3,hdim(1,1),&
!     &          dh2snglt,dh2masgr1,dh2masur1

      return
    end subroutine dHmatSNGLTr1
 
!dHmatsnglr2    
    subroutine dHmatSNGLTr2(r1,r2,r3,Hdim)
      implicit none
      real(kind=8), dimension(ndim,ndim),intent(out) :: Hdim
      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim) :: vlong
      real(kind=8) :: dh2masgr1,dh2masgr2,dh2masgr3
      real(kind=8) :: dh2masur1,dh2masur2,dh2masur3
      real(kind=8) :: dh2snglt
      integer :: i

      if(ndim.ne.3)print*,"Warning: ndim different to 3"
    
      call dh2masg(r2,dh2masgr2)
      dh2masgr1=0.d0
      dh2masgr3=0.d0
      call dh2masu(r2,dh2masur2)
      dh2masur1=0.d0
      dh2masur3=0.d0
      Hdim(1,1)= 0.d0&
           &    +0.5d0*(dh2masgr2+dh2masur2+dh2masgr3+dh2masur3)
      call dh2(r2,dh2snglt)
      Hdim(2,2)= dh2snglt&
     &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr3+dh2masur3)
      Hdim(3,3)=0.d0&
     &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr2+dh2masur2)

!     Adding the long term derivatives to the diagonal terms
      call dHmatlongr2(r1,r2,r3,vlong)
!      vlong(:)=0.d0
      do i=1,ndim
        Hdim(i,i)=Hdim(i,i) + vlong(i)
      enddo
      Hdim(1,2)=0.5d0*(dh2masgr3-dh2masur3)
      Hdim(2,1)=Hdim(1,2)
      Hdim(1,3)=0.5d0*(dh2masgr2-dh2masur2)
      Hdim(3,1)=Hdim(1,3)
      Hdim(2,3)=0.5d0*(dh2masgr1-dh2masur1)
      Hdim(3,2)=Hdim(2,3)

      return
    end subroutine dHmatSNGLTr2

!dHmatsnglr3 
    subroutine dHmatSNGLTr3(r1,r2,r3,Hdim)
      implicit none
      real(kind=8), dimension(ndim,ndim),intent(out) :: Hdim
      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim) :: vlong
      real(kind=8) :: dh2masgr1,dh2masgr2,dh2masgr3
      real(kind=8) :: dh2masur1,dh2masur2,dh2masur3
      real(kind=8) :: dh2snglt
      integer :: i

      if(ndim.ne.3)print*,"Warning: ndim different to 3"

      dh2masgr1=0.d0
      dh2masgr2=0.d0
!      xmasg23=h2masgmat1(ir2,ir3)
      call dh2masg(r3,dh2masgr3)
      dh2masur1=0.d0
      dh2masur2=0.d0
      call dh2masu(r3,dh2masur3)
      !      xmasu23=h2masumat1(ir2,ir3)
      Hdim(1,1)=0.d0&
     &       +0.5d0*(dh2masgr2+dh2masur2+dh2masgr3+dh2masur3)
      Hdim(2,2)=0.d0&
     &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr3+dh2masur3)    
      call dh2(r3,dh2snglt)
      Hdim(3,3)=dh2snglt&
     &       +0.5d0*(dh2masgr1+dh2masur1+dh2masgr2+dh2masur2)

!     Adding the long term derivatives to the diagonal terms
      call dHmatlongr3(r1,r2,r3,vlong)
!      vlong(:)=0.d0
      do i=1,ndim
        Hdim(i,i)=Hdim(i,i) + vlong(i)
      enddo
      Hdim(1,2)=0.5d0*(dh2masgr3-dh2masur3)
      Hdim(2,1)=Hdim(1,2)
      Hdim(1,3)=0.5d0*(dh2masgr2-dh2masur2)
      Hdim(3,1)=Hdim(1,3)
      Hdim(2,3)=0.5d0*(dh2masgr1-dh2masur1)
      Hdim(3,2)=Hdim(2,3)

      return
    end subroutine dHmatSNGLTr3          
    
!*************************************************

    subroutine Hmatlong(r1,r2,r3,vlong)
      implicit none
      interface
        real(kind=8) function h2hmlong(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function h2hmlong
     end interface
      
      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim), intent(out) :: vlong
!      real(kind=8), parameter :: RLIM=20.d0 
!      real(kind=8), parameter :: delta=1.d-05,vex=2.0d0
!      integer, parameter :: nex=2
!      real(kind=8), parameter :: ve1=-6.877632866816436331701127313d0
!      real(kind=8), parameter :: ve2= 1.063377811610615495595154391d0
!      real(kind=8), parameter :: ve3= 0.851470426733243541438835536d0
!      real(kind=8), parameter :: ve4= 0.102742528139116503000832375d0
!      real(kind=8), parameter :: ve5=32.643085505784540262772041147d0
!      real(kind=8), parameter :: ve6=-3.972836288158882839263374076d0
!      real(kind=8), parameter :: ve7=-4.352872865059483693513648852d0
!      real(kind=8), parameter :: ve8=-0.702079250269487087681174516d0
!      real(kind=8), parameter :: a1=4.5d0,a2=15.d0
      real(kind=8) :: r1sq,r2sq,r3sq,Rgsq,Rg,den,Rg1,Rg2,Rg3
      real(kind=8) :: xcos1,xcos2,xcos3,Rgg,Rgg2
      real(kind=8) :: vlong1,vlong2,vlong3
      real(kind=8) :: xch1,xch2,xch3
      real(kind=8) :: vcut,vcut1,vcut2,vcut3
      real(kind=8) :: vcut12,vcut21,vcut13
      real(kind=8) :: vcut31,vcut23,vcut32
      real(kind=8) :: vc1,vc2,vc3,vee    
      real(kind=8) :: vlim1,vlim2,vlim3,vlrnew
      real(kind=8) :: p2,p4,p6,x
      real(kind=8) :: gr1,gr2,gr3
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3.d0)/8.d0 ! Legendre polynomial P4
!      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legendre polynomial P6              
      r1sq=r1*r1
      r2sq=r2*r2
      r3sq=r3*r3
!     Long range three body terms:
!     Jacobi coordinates in the three DIM wavefunctions
!     h11 term 
      Rgsq=abs(0.50d0*r2sq+0.50d0*r3sq-0.25d0*r1sq)
      Rg=sqrt(Rgsq)
      den=2.d0*r1*Rg
      Rg1=Rg
      if(den.lt.delta) then
         xcos1=0.0d0
      else
         xcos1=r2sq-r3sq
         xcos1=xcos1/den 
      endif 
!     h22 term 
      Rgsq=abs(0.50d0*r1sq+0.50d0*r3sq-0.25d0*r2sq)
      Rg=sqrt(Rgsq)
      den=2.d0*r2*Rg
      Rg2=Rg
      if(den.lt.delta) then
         xcos2=0.0d0
      else
         xcos2=r1sq-r3sq
         xcos2=xcos2/den
      endif
!     h33 term 
      Rgsq=abs(0.50d0*r1sq+0.50d0*r2sq-0.25d0*r3sq)
      Rg=sqrt(Rgsq)
      den=2.d0*r3*Rg 
      Rg3=Rg
      if(den.lt.delta) then
         xcos3=0.0d0
      else
         xcos3=r1sq-r2sq 
         xcos3=xcos3/den
      endif
     
!!!!!!!!!!!!!!!!
!!! Long range with constant coefficients
!!!!!!!!!!!!!!!!
!   Long range H2 -- H+ terms
! Rg1
      Rgg=Rg1+RLIM*exp(-1.d0*(Rg1-1.4d0))
      vee=1.d0
      gr1=r1*exp(-vee*r1)
!      Rgg2=Rg1+RLIM*exp(-0.40*(Rg1-1.4d0))
      vlrnew=(ve1*gr1+ve2*gr1**2)/(Rgg**5)+&
     &       (ve3*gr1+ve4*gr1**2)*p2(xcos1)/(Rgg**5)+&
     &       (ve5*gr1+ve6*gr1**2)*p4(xcos1)/(Rgg**5) 
     vlong1=h2hmlong(r1,Rgg,xcos1)+vlrnew
!      vlong1=h2hmlong(r1,Rgg,xcos1)
!      write(80,*)r1,r2,r3,vlrnew,vlong1
! Rg2      
      Rgg=Rg2+RLIM*exp(-1.d0*(Rg2-1.4d0))
      gr2=r2*exp(-vee*r2)
      vlrnew=(ve1*gr2+ve2*gr2**2)/(Rgg**5) +&
     &       (ve3*gr2+ve4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (ve5*gr2+ve6*gr2**2)*p4 (xcos2)/(Rgg**5)
     vlong2=h2hmlong(r2,Rgg,xcos2)+vlrnew 
!      vlong2=h2hmlong(r2,Rgg,xcos2)
!      write(81,*)r1,r2,r3,vlrnew,vlong2
! Rg3      
      Rgg=Rg3+RLIM*exp(-1.d0*(Rg3-1.4d0))
      gr3=r3*exp(-vee*r3)
      vlrnew=(ve1*gr3+ve2*gr3**2)/(Rgg**5) +&
     &       (ve3*gr3+ve4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (ve5*gr3+ve6*gr3**2)*p4 (xcos3)/(Rgg**5)
      vlong3=h2hmlong(r3,Rgg,xcos3)+vlrnew
!      vlong3=h2hmlong(r3,Rgg,xcos3)
!      write(82,*)r1,r2,r3,vlrnew,vlong3
     
      vcut1=exp(-(vex*r1)**nex/vex)
      vcut2=exp(-(vex*r2)**nex/vex)
      vcut3=exp(-(vex*r3)**nex/vex)
      vcut=vcut1+vcut2+vcut3
      vcut12=exp((-(vex*r1)**nex+(vex*r2)**nex)/vex)
      vcut21=exp((+(vex*r1)**nex-(vex*r2)**nex)/vex)
      vcut13=exp((-(vex*r1)**nex+(vex*r3)**nex)/vex)
      vcut31=exp((+(vex*r1)**nex-(vex*r3)**nex)/vex)
      vcut23=exp((-(vex*r2)**nex+(vex*r3)**nex)/vex)
      vcut32=exp((+(vex*r2)**nex-(vex*r3)**nex)/vex)
      vc1=1.d0/(1.d0+vcut21+vcut31)
      vc2=1.d0/(vcut12+1.d0+vcut32)
      vc3=1.d0/(vcut13+vcut23+1.d0)
      vlong1=vlong1*vc1
      vlong2=vlong2*vc2
      vlong3=vlong3*vc3
!      write(13,*)r1,r2,r3,vlong1
!      write(14,*)r1,r2,r3,vlong2
!      write(15,*)r1,r2,r3,vlong3
      
!C    Long range H2+ -- H terms
!     a1=4.5d0
!     a2=15.d0

      vlim1=0.d0
      vlim2=0.d0
      vlim3=0.d0

      Rgg=Rg1+RLIM*dexp(-(Rg1-1.4d0))
      vlim1=-a1/Rgg**4-a2/Rgg**6
      gr1=r1*exp(-vee*r1)
      vlrnew=(vf1*gr1+vf2*gr1**2)/(Rgg**5) +&
     &       (vf3*gr1+vf4*gr1**2)*p2(xcos1)/(Rgg**5) +&
     &       (vf5*gr1+vf6*gr1**2)*p4 (xcos1)/(Rgg**5)
      vlim1=vlim1+vlrnew

      Rgg=Rg2+RLIM*dexp(-(Rg2-1.4d0))
      vlim2=-a1/Rgg**4-a2/Rgg**6
      gr2=r2*exp(-vee*r2)
      vlrnew=(vf1*gr2+vf2*gr2**2)/(Rgg**5) +&
     &       (vf3*gr2+vf4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (vf5*gr2+vf6*gr2**2)*p4 (xcos2)/(Rgg**5)
      vlim2=vlim2+vlrnew

      Rgg=Rg3+RLIM*dexp(-(Rg3-1.4d0))
      vlim3=-a1/Rgg**4-a2/Rgg**6
      gr3=r3*exp(-vee*r3)
      vlrnew=(vf1*gr3+vf2*gr3**2)/(Rgg**5) +&
     &       (vf3*gr3+vf4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (vf5*gr3+vf6*gr3**2)*p4 (xcos3)/(Rgg**5)
      vlim3=vlim3+vlrnew

      vlim1=vlim1*vc1
      vlim2=vlim2*vc2
      vlim3=vlim3*vc3
     
      if(ndim.gt.3)print*,"Warning with size of vlong? and vlim?"
      vlong(1) = vlong1 - vlim1
      vlong(2) = vlong2 - vlim2
      vlong(3) = vlong3 - vlim3

!      write(16,*)r1,r2,r3,vlong(1)
!      write(17,*)r1,r2,r3,vlong(2)
!      write(18,*)r1,r2,r3,vlong(3)
      return
    end subroutine Hmatlong

!**************************
! Derivatives
!**************************
!!*********************************
!! dHmatlongr1
!!****************************

    subroutine  dHmatlongr1(r1,r2,r3,vlong)
      implicit none
      interface
        real(kind=8) function h2hmlong(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function h2hmlong

        real(kind=8) function dh2hmlongRgg(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongRgg
        
        real(kind=8) function dh2hmlongr(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function dh2hmlongr

        real(kind=8) function dh2hmlongxcos(rpeq,Rgran,xcos)
         implicit none
         real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongxcos
        
      end interface

      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim), intent(out) :: vlong
!      real(kind=8), parameter :: RLIM=20.d0
!      real(kind=8), parameter :: delta=1.d-05,delta2=1.0d-05,vex=2.0d0
!      real(kind=8), parameter :: a1=4.5d0,a2=15.d0
!      integer, parameter :: nex=2
!      real(kind=8), parameter :: ve1=-6.877632866816436331701127313d0
!      real(kind=8), parameter :: ve2= 1.063377811610615495595154391d0
!      real(kind=8), parameter :: ve3= 0.851470426733243541438835536d0
!      real(kind=8), parameter :: ve4= 0.102742528139116503000832375d0
!      real(kind=8), parameter :: ve5=32.643085505784540262772041147d0
!      real(kind=8), parameter :: ve6=-3.972836288158882839263374076d0
!      real(kind=8), parameter :: ve7=-4.352872865059483693513648852d0
!      real(kind=8), parameter :: ve8=-0.702079250269487087681174516d0
      real(kind=8) :: r1p,r2p,r3p
      real(kind=8) :: r1sq,r2sq,r3sq,Rgsq,Rg,den,Rg1,Rg2,Rg3
      real(kind=8) :: gr1,gr2,gr3,gr11,gr21,gr31,vee
      real(kind=8) :: xcos1,xcos2,xcos3,Rgg,Rgg1,Rgg2
      real(kind=8) :: Rg11,Rg21,Rg31,RgRg,xcos11,xcos21,xcos31
      real(kind=8) :: vlong1,vlong2,vlong3
      real(kind=8) :: vlong11,vlong21,vlong31
      real(kind=8) :: dvlrnewrg,dvlrnewcos
      real(kind=8) :: xch1,xch2,xch3
      real(kind=8) :: vcut,vcut1,vcut2,vcut3
      real(kind=8) :: vcut12,vcut21,vcut13
      real(kind=8) :: vcut31,vcut23,vcut32
      real(kind=8) :: dcut12,dcut21,dcut13
      real(kind=8) :: dcut31,dcut23,dcut32
      real(kind=8) :: vc1,vc2,vc3
      real(kind=8) :: dc1,dc2,dc3
      real(kind=8) :: vlim1,vlim2,vlim3
      real(kind=8) :: vlrnew
      real(kind=8) :: dvlrnewgr1,dvlrnewgr2,dvlrnewgr3
      real(kind=8) :: dvlrnewp2,dvlrnewp4
      real(kind=8) :: vlim11,vlim21,vlim31
      real(kind=8) :: p2,p4,x
      real(kind=8) :: dp2,dp4
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3.d0)/8.d0 ! Legendre polynomial P4
!      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legendre polynomial P6       
      dp2(x)=3.0d0*x ! Legendre polynomial P2
      dp4(x)=(140.d0*x*x*x-60.d0*x)/8.d0 ! Legendre polynomial P4
!      dp6(x)=(1386.d0*x*x*x*x*x-1260.d0*x*x*x+210.d0*x)/16.d0 ! Legendre polynomial P6   

      r1sq=r1*r1
      r2sq=r2*r2
      r3sq=r3*r3
!     Long range three body terms:
!     Jacobi coordinates in the three DIM wavefunctions
!     h11 term 
      RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*r1sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*(r1-delta2)**2
      endif
      Rgsq=abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r1*Rg
      Rg1=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg11 = (0.5d0/Rg)*(-0.5d0*r1)
      if(RgRg.lt.0.d0) Rg11 = -Rg11
      if(den.lt.delta) then
         xcos1=0.0d0
         xcos11=0.d0
      else
         xcos1=r2sq-r3sq
         xcos1=xcos1/den
         xcos11 = -xcos1*2.d0*(Rg1 + r1*Rg11)/den
      endif
!!!!!!!!
      ! H22 term 
!!!!!!!!
      RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*r2sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*(r2-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r2*Rg
      Rg2=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg21 = (0.5d0/Rg)*r1
        if(RgRg.lt.0.d0) Rg21 = -Rg21

      if(den.lt.delta) then
         xcos2=0.0d0
         xcos21=0.d0
      else
         xcos2=r1sq-r3sq
         xcos2=xcos2/den
         xcos21 = (2.d0*r1 -xcos2*2.d0*r2*Rg21)/den
      endif
!!!!!!!!
      ! H33 term 
!!!!!!!!
      RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*r3sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*(r3-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r3*Rg
      Rg3=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg31 = (0.5d0/Rg)*r1
      if(RgRg.lt.0.d0) Rg31 = -Rg31

      if(den.lt.delta) then
        xcos3=0.0d0
        xcos31=0.d0
      else
         xcos3=r1sq-r2sq
         xcos3=xcos3/den
         xcos31 = (2.d0*r1 -xcos3*2.d0*r3*Rg31)/den
      endif
!C    Long range H2 -- H+ terms
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vee=1.d0
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(ve1*gr1+ve2*gr1**2)/(Rgg**5)+&
     &       (ve3*gr1+ve4*gr1**2)*p2(xcos1)/(Rgg**5)+&
     &       (ve5*gr1+ve6*gr1**2)*p4(xcos1)/(Rgg**5)
      vlong1=h2hmlong(r1,Rgg,xcos1)+vlrnew
!      vlong1=h2hmlong(r1,Rgg,xcos1)
      !Der new term

      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1=vlrnew*gr11/gr1
       dvlrnewp2=(ve3*gr1+ve4*gr1**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr1+ve6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11
    
      !Der vlong1 
     vlong11= dh2hmlongr(r1,Rgg,xcos1)&
    &    + dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1&
    &    + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11&
    &    + dvlrnewrg + dvlrnewgr1 + dvlrnewcos
!      vlong11= dh2hmlongr(r1,Rgg,xcos1)&
!     &    + dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1&
!     &    + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11
     
      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21
      vee=1.d0
      gr2=r2*exp(-vee*r2)
      gr21=gr2*(-vee+(1/r2))
      vlrnew=(ve1*gr2+ve2*gr2**2)/(Rgg**5) +&
     &       (ve3*gr2+ve4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (ve5*gr2+ve6*gr2**2)*p4(xcos2)/(Rgg**5)
     vlong2=h2hmlong(r2,Rgg,xcos2)+vlrnew
     
  !Der new term
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=0.0 !dgr2/dr1=0
       dvlrnewp2=(ve3*gr2+ve4*gr2**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr2+ve6*gr2**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21
    
     !Der vlong2
      vlong21= dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1&
          &    + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21&
          &    + dvlrnewrg + dvlrnewgr2 + dvlrnewcos
!        vlong21= dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1&
!            &    + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21

      Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vee=1.d0
      gr3=r3*exp(-vee*r3)
      gr31=gr3*(-vee+(1/r3))
      vlrnew=(ve1*gr3+ve2*gr3**2)/(Rgg**5) +&
     &       (ve3*gr3+ve4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (ve5*gr3+ve6*gr3**2)*p4(xcos3)/(Rgg**5)

      vlong3=h2hmlong(r3,Rgg,xcos3)+vlrnew     
      !      vlong3=h2hmlong(r3,Rgg,xcos3)
      
      ! Der new term
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3= 0.0 !dgr3/dr1=0
       dvlrnewp2=(ve3*gr3+ve4*gr3**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr3+ve6*gr3**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31
      
     ! Der vlong3    
     vlong31= dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1&
          &   + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31&
          &   + dvlrnewrg + dvlrnewgr3 + dvlrnewcos
!       vlong31= dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1&
!            &   + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31
      
      r1p=r1
      r2p=r2
      r3p=r3
      if(r1p.ge.18.d0) r1p=18.d0
      if(r2p.ge.18.d0) r2p=18.d0
      if(r3p.ge.18.d0) r3p=18.d0

      vcut12=exp((-(vex*r1p)**nex+(vex*r2p)**nex)/vex)
      dcut12=-nex*(vex*r1p)**(nex-1)*vcut12
      vcut21=exp((+(vex*r1p)**nex-(vex*r2p)**nex)/vex)
      dcut21=nex*(vex*r1p)**(nex-1)*vcut21
      vcut13=exp((-(vex*r1p)**nex+(vex*r3p)**nex)/vex)
      dcut13=-nex*(vex*r1p)**(nex-1)*vcut13
      vcut31=exp((+(vex*r1p)**nex-(vex*r3p)**nex)/vex)
      dcut31=nex*(vex*r1p)**(nex-1)*vcut31
      vcut23=exp((-(vex*r2p)**nex+(vex*r3p)**nex)/vex)
      vcut32=exp((+(vex*r2p)**nex-(vex*r3p)**nex)/vex)

      vc1=1.d0/(1.d0+vcut21+vcut31)
      vc2=1.d0/(vcut12+1.d0+vcut32)
      vc3=1.d0/(vcut13+vcut23+1.d0)
      dc1=(-vc1**2)*(dcut21+dcut31)
      dc2=(-vc2**2)*(dcut12)
      dc3=(-vc3**2)*(dcut13)
      vlong11=vlong11*vc1+vlong1*dc1
      vlong21=vlong21*vc2+vlong2*dc2
      vlong31=vlong31*vc3+vlong3*dc3

!C    Long range H2+ -- H terms
!     a1=4.5d0
!     a2=15.d0
!     if(Rg1.ge.Rg2.and.Rg1.ge.Rg3) then
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vlim1=-a1/Rgg**4-a2/Rgg**6
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(vf1*gr1+vf2*gr1**2)/(Rgg**5)&
     &     +  (vf3*gr1+vf4*gr1**2)*p2(xcos1)/(Rgg**5)&
     &     +  (vf5*gr1+vf6*gr1**2)*p4 (xcos1)/(Rgg**5)  
      vlim1=vlim1+vlrnew
     !!Der vlim1
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1=vlrnew*gr11/gr1
       dvlrnewp2=(vf3*gr1+vf4*gr1**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr1+vf6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11 
      vlim11 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr1 + dvlrnewcos
      
!     elseif(Rg2.ge.Rg1.and.Rg2.ge.Rg3) then
      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21
      vlim2=-a1/Rgg**4-a2/Rgg**6
      gr2=r2*exp(-vee*r2)
      vlrnew=(vf1*gr2+vf2*gr2**2)/(Rgg**5)&
     &    +   (vf3*gr2+vf4*gr2**2)*p2(xcos2)/(Rgg**5)&
     &    +   (vf5*gr2+vf6*gr2**2)*p4 (xcos2)/(Rgg**5)  
      vlim2=vlim2+vlrnew

     !!Der vlim2
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=0.0 !dgr2/dr1=0
       dvlrnewp2=(vf3*gr2+vf4*gr2**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr2+vf6*gr2**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21 
      vlim21 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr2 + dvlrnewcos      
!     elseif(Rg3.ge.Rg1.and.Rg3.ge.Rg2) then
      Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vlim3=-a1/Rgg**4-a2/Rgg**6
      gr3=r3*exp(-vee*r3)
      vlrnew=(vf1*gr3+vf2*gr3**2)/(Rgg**5) +&
     &       (vf3*gr3+vf4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (vf5*gr3+vf6*gr3**2)*p4 (xcos3)/(Rgg**5)  
      vlim3=vlim3+vlrnew
     !!Der vlim3
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3=0.0 !dgr3/dr1=0
       dvlrnewp2=(vf3*gr3+vf4*gr3**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr3+vf6*gr3**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31 
      vlim31 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr3 + dvlrnewcos      
!     endif

      vlim11=vlim11*vc1+vlim1*dc1
      vlim21=vlim21*vc2+vlim2*dc2
      vlim31=vlim31*vc3+vlim3*dc3
!      print*,"Cris2",r1,r2,r3,vlim31,vlim21,vc2,vc3,vlim2,vlim3,dc2,dc3
      
      vlong(1)= vlong11 - vlim11
      vlong(2)= vlong21 - vlim21
      vlong(3)= vlong31 - vlim31   

      return
    end subroutine dHmatlongr1


!!*********************************
!! dHmatlong2
!!****************************      
      
    subroutine  dHmatlongr2(r1,r2,r3,vlong)
      implicit none
      interface
        real(kind=8) function h2hmlong(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function h2hmlong

        real(kind=8) function dh2hmlongRgg(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongRgg
        
        real(kind=8) function dh2hmlongr(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function dh2hmlongr

        real(kind=8) function dh2hmlongxcos(rpeq,Rgran,xcos)
         implicit none
         real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongxcos
        
      end interface

      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim), intent(out) :: vlong
!      real(kind=8), parameter :: RLIM=20.d0
!      real(kind=8), parameter :: delta=1.d-05,delta2=1.0d-05,vex=2.0d0
!      real(kind=8), parameter :: a1=4.5d0,a2=15.d0
!      integer, parameter :: nex=2
!      real(kind=8), parameter :: ve1=-6.877632866816436331701127313d0
!      real(kind=8), parameter :: ve2= 1.063377811610615495595154391d0
!      real(kind=8), parameter :: ve3= 0.851470426733243541438835536d0
!      real(kind=8), parameter :: ve4= 0.102742528139116503000832375d0
!      real(kind=8), parameter :: ve5=32.643085505784540262772041147d0
!      real(kind=8), parameter :: ve6=-3.972836288158882839263374076d0
!      real(kind=8), parameter :: ve7=-4.352872865059483693513648852d0
!      real(kind=8), parameter :: ve8=-0.702079250269487087681174516d0
      real(kind=8) :: r1p,r2p,r3p
      real(kind=8) :: r1sq,r2sq,r3sq,Rgsq,Rg,den,Rg1,Rg2,Rg3
      real(kind=8) :: gr1,gr2,gr3,gr11,gr21,gr31,vee
      real(kind=8) :: xcos1,xcos2,xcos3,Rgg,Rgg1,Rgg2
      real(kind=8) :: Rg11,Rg21,Rg31,RgRg,xcos11,xcos21,xcos31
      real(kind=8) :: vlong1,vlong2,vlong3
      real(kind=8) :: vlong11,vlong21,vlong31
      real(kind=8) :: dvlrnewrg,dvlrnewcos
      real(kind=8) :: xch1,xch2,xch3
      real(kind=8) :: vcut,vcut1,vcut2,vcut3
      real(kind=8) :: vcut12,vcut21,vcut13
      real(kind=8) :: dcut12,dcut21,dcut13
      real(kind=8) :: vcut31,vcut23,vcut32
      real(kind=8) :: dcut31,dcut23,dcut32
      real(kind=8) :: vc1,vc2,vc3
      real(kind=8) :: dc1,dc2,dc3
      real(kind=8) :: vlim1,vlim2,vlim3
      real(kind=8) :: vlrnew
      real(kind=8) :: dvlrnewgr1,dvlrnewgr2,dvlrnewgr3
      real(kind=8) :: dvlrnewp2,dvlrnewp4
      real(kind=8) :: vlim11,vlim21,vlim31     
      real(kind=8) :: p2,p4,x
      real(kind=8) :: dp2,dp4
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3)/8.d0 ! Legendre polynomial P4
!      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legen polyn P6       
      dp2(x)=3.0d0*x ! Legendre polynomial P2
      dp4(x)=(140.d0*x*x*x-60.d0*x)/8.d0 ! Legendre polynomial P4
!      dp6(x)=(1386.d0*x*x*x*x*x-1260.d0*x*x*x+210.d0*x)/16.d0 ! Legen polyn P6       

      r1sq=r1*r1
      r2sq=r2*r2
      r3sq=r3*r3
!     Long range three body terms:
!     Jacobi coordinates in the three DIM wavefunctions
!     h11 term 
      RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*r1sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*(r1-delta2)**2
      endif
      Rgsq=abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r1*Rg
      Rg1=Rg
!    if(Rg.lt.delta) write(6,*) Rg
      Rg11 = (0.5d0/Rg)*r2
      if(RgRg.lt.0.d0) Rg11 = -Rg11
      if(den.lt.delta) then
        xcos1=0.0d0
        xcos11=0.d0
      else
        xcos1=r2sq-r3sq
        xcos1=xcos1/den
        xcos11 = (2.d0*r2 - xcos1*2.d0*r1*Rg11)/den
      endif
!     h22 term 
      RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*r2sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*(r2-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r2*Rg
      Rg2=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg21 = (0.5d0/Rg)*(-0.5d0*r2)
      if(RgRg.lt.0.d0) Rg21 = -Rg21

      if(den.lt.delta) then
        xcos2=0.0d0
        xcos21=0.d0
      else
        xcos2=r1sq-r3sq
        xcos2=xcos2/den
        xcos21 = -xcos2*2.d0*(Rg2 + r2*Rg21)/den
      endif
!     h33 term 
      RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*r3sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*(r3-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r3*Rg
      Rg3=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg31 = (0.5d0/Rg)*r2
      if(RgRg.lt.0.d0) Rg31 = -Rg31

      if(den.lt.delta) then
        xcos3=0.0d0
        xcos31=0.d0
      else
        xcos3=r1sq-r2sq
        xcos3=xcos3/den
        xcos31 = (-2.d0*r2 -xcos3*2.d0*r3*Rg31)/den
      endif
!!    Long range H2 -- H+ terms
!     if(Rg1.ge.Rg2.and.Rg1.ge.Rg3) then
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vee=1.d0
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(ve1*gr1+ve2*gr1**2)/(Rgg**5) +&
     &       (ve3*gr1+ve4*gr1**2)*p2(xcos1)/(Rgg**5) +&
     &       (ve5*gr1+ve6*gr1**2)*p4(xcos1)/(Rgg**5)
     vlong1=h2hmlong(r1,Rgg,xcos1)+vlrnew
     
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1= 0.0 !dgr1/dr2=0
       dvlrnewp2=(ve3*gr1+ve4*gr1**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr1+ve6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11
    
      !Der vlong1
     vlong11=dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1 &
          &  + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11&
          &  + dvlrnewrg + dvlrnewgr1 + dvlrnewcos
!      vlong11=dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1 &
!           &  + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11

      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21
      vee=1.d0
      gr2=r2*exp(-vee*r2)
      gr21=gr2*(-vee+(1/r2))
      vlrnew=(ve1*gr2+ve2*gr2**2)/(Rgg**5) +&
     &       (ve3*gr2+ve4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (ve5*gr2+ve6*gr2**2)*p4(xcos2)/(Rgg**5)
      vlong2=h2hmlong(r2,Rgg,xcos2)+vlrnew
!      vlong2=h2hmlong(r2,Rgg,xcos2)
      ! Der new term
     
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=vlrnew*gr21/gr2
       dvlrnewp2=(ve3*gr2+ve4*gr2**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr2+ve6*gr2**2)/(Rgg**5)
       dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21
       
     !Der vlong2
     vlong21=dh2hmlongr(r2,Rgg,xcos2)&
    &   + dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1 &
    &   + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21&
    &   + dvlrnewrg+dvlrnewgr2+dvlrnewcos
!      vlong21=dh2hmlongr(r2,Rgg,xcos2)&
!     &   + dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1 &
!     &   + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21 

      Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vee=1.d0
      gr3=r3*exp(-vee*r3)
      gr31=gr3*(-vee+(1/r3))
      vlrnew=(ve1*gr3+ve2*gr3**2)/(Rgg**5)+&
     &       (ve3*gr3+ve4*gr3**2)*p2(xcos3)/(Rgg**5)+&
     &       (ve5*gr3+ve6*gr3**2)*p4(xcos3)/(Rgg**5)
     vlong3=h2hmlong(r3,Rgg,xcos3)+vlrnew
!      vlong3=h2hmlong(r3,Rgg,xcos3)
      ! Der new term
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3=0.0 !dgr3/dr2=0
       dvlrnewp2=(ve3*gr3+ve4*gr3**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr3+ve6*gr3**2)/(Rgg**5)
       dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31
     
     !Der vlong3
     vlong31= dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1&
          &    + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31&
          &    + dvlrnewrg+dvlrnewgr3+dvlrnewcos
!      vlong31= dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1 &
!           &    + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31

      r1p=r1
      r2p=r2
      r3p=r3
      if(r1p.ge.18.d0) r1p=18.d0
      if(r2p.ge.18.d0) r2p=18.d0
      if(r3p.ge.18.d0) r3p=18.d0

      vcut12=exp((-(vex*r1p)**nex+(vex*r2p)**nex)/vex)
      vcut21=exp((+(vex*r1p)**nex-(vex*r2p)**nex)/vex)
      vcut13=exp((-(vex*r1p)**nex+(vex*r3p)**nex)/vex)
      vcut31=exp((+(vex*r1p)**nex-(vex*r3p)**nex)/vex)
      dcut12=nex*(vex*r2p)**(nex-1)*vcut12
      dcut21=-nex*(vex*r2p)**(nex-1)*vcut21
      vcut23=exp((-(vex*r2p)**nex+(vex*r3p)**nex)/vex)
      dcut23=-nex*(vex*r2p)**(nex-1)*vcut23
      vcut32=exp((+(vex*r2p)**nex-(vex*r3p)**nex)/vex)
      dcut32=nex*(vex*r2p)**(nex-1)*vcut32
      vc1=1.d0/(1.d0+vcut21+vcut31)
      vc2=1.d0/(vcut12+1.d0+vcut32)
      vc3=1.d0/(vcut13+vcut23+1.d0)
      dc1=(-vc1**2)*(dcut21)
      dc2=(-vc2**2)*(dcut12+dcut32)
      dc3=(-vc3**2)*(dcut23)
     
      vlong11=vlong11*vc1+vlong1*dc1
      vlong21=vlong21*vc2+vlong2*dc2
      vlong31=vlong31*vc3+vlong3*dc3

!        write(8,*) vlong11,vlong21,vlong31
!C    Long range H2+ -- H terms
!     a1=4.5d0
!     a2=15.d0
!      if(Rg1.ge.Rg2.and.Rg1.ge.Rg3) then
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vlim1=-a1/Rgg**4-a2/Rgg**6
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(vf1*gr1+vf2*gr1**2)/(Rgg**5) +&
     &       (vf3*gr1+vf4*gr1**2)*p2(xcos1)/(Rgg**5) +&
     &       (vf5*gr1+vf6*gr1**2)*p4 (xcos1)/(Rgg**5)  
      vlim1=vlim1+vlrnew
     !!Der vlim1
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1=0.0 !dgr1/dr2=0
       dvlrnewp2=(vf3*gr1+vf4*gr1**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr1+vf6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11          
      vlim11 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
      & dvlrnewrg +dvlrnewgr1 + dvlrnewcos
      
!      elseif(Rg2.ge.Rg1.and.Rg2.ge.Rg3) then
      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21
      vlim2=-a1/Rgg**4-a2/Rgg**6
      gr2=r2*exp(-vee*r2)
      gr21=gr2*(-vee+(1/r2))
      vlrnew=(vf1*gr2+vf2*gr2**2)/(Rgg**5) +&
     &       (vf3*gr2+vf4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (vf5*gr2+vf6*gr2**2)*p4(xcos2)/(Rgg**5)  
     vlim2=vlim2+vlrnew
     
     !!Der vlim2
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=vlrnew*gr21/gr2
       dvlrnewp2=(vf3*gr2+vf4*gr2**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr2+vf6*gr2**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21      
      vlim21 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
      & dvlrnewrg +dvlrnewgr2 + dvlrnewcos
      
!      elseif(Rg3.ge.Rg1.and.Rg3.ge.Rg2) then
       Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vlim3=-a1/Rgg**4-a2/Rgg**6
      gr3=r3*exp(-vee*r3)
      gr31=gr3*(-vee+(1/r3))
      vlrnew=(vf1*gr3+vf2*gr3**2)/(Rgg**5) +&
     &       (vf3*gr3+vf4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (vf5*gr3+vf6*gr3**2)*p4(xcos3)/(Rgg**5)  
      vlim3=vlim3+vlrnew
     !!Der vlim3
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3=0.0 !dgr3/dr2=0
       dvlrnewp2=(vf3*gr3+vf4*gr3**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr3+vf6*gr3**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31         
      vlim31 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
      & dvlrnewrg +dvlrnewgr3 + dvlrnewcos

      vlim11=vlim11*vc1+vlim1*dc1
      vlim21=vlim21*vc2+vlim2*dc2
      vlim31=vlim31*vc3+vlim3*dc3
      
      if(ndim.gt.3)print*,"Warning with size of vlong? and vlim?"
      vlong(1)=vlong11 - vlim11
      vlong(2)=vlong21 - vlim21
      vlong(3)=vlong31 - vlim31

      return
      end subroutine dHmatlongr2

!!*********************************
!! dHmatlongr3
!!****************************

    subroutine dHmatlongr3(r1,r2,r3,vlong)
      implicit none
      interface
        real(kind=8) function h2hmlong(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function h2hmlong

        real(kind=8) function dh2hmlongRgg(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongRgg
        
        real(kind=8) function dh2hmlongr(rpeq,Rgran,xcos)
          implicit none
          real(kind=8), intent(in) :: rpeq,rgran,xcos
        end function dh2hmlongr

        real(kind=8) function dh2hmlongxcos(rpeq,Rgran,xcos)
         implicit none
         real(kind=8), intent(in) :: rpeq,Rgran,xcos
        end function dh2hmlongxcos
        
      end interface

      real(kind=8), intent(in) :: r1,r2,r3
      real(kind=8), dimension(ndim), intent(out) :: vlong
!      real(kind=8), parameter :: RLIM=20.d0
!      real(kind=8), parameter :: delta=1.d-05,delta2=1.0d-05,vex=2.0d0
!      real(kind=8), parameter :: a1=4.5d0,a2=15.d0
!      integer, parameter :: nex=2
!      real(kind=8), parameter :: ve1=-6.877632866816436331701127313d0
!      real(kind=8), parameter :: ve2= 1.063377811610615495595154391d0
!      real(kind=8), parameter :: ve3= 0.851470426733243541438835536d0
!      real(kind=8), parameter :: ve4= 0.102742528139116503000832375d0
!      real(kind=8), parameter :: ve5=32.643085505784540262772041147d0
!      real(kind=8), parameter :: ve6=-3.972836288158882839263374076d0
!      real(kind=8), parameter :: ve7=-4.352872865059483693513648852d0
!      real(kind=8), parameter :: ve8=-0.702079250269487087681174516d0
      real(kind=8) :: r1p,r2p,r3p
      real(kind=8) :: r1sq,r2sq,r3sq,Rgsq,Rg,den,Rg1,Rg2,Rg3
      real(kind=8) :: gr1,gr2,gr3,gr11,gr21,gr31,vee
      real(kind=8) :: xcos1,xcos2,xcos3,Rgg,Rgg1,Rgg2
      real(kind=8) :: Rg11,Rg21,Rg31,RgRg,xcos11,xcos21,xcos31
      real(kind=8) :: vlong1,vlong2,vlong3
      real(kind=8) :: vlong11,vlong21,vlong31
      real(kind=8) :: xch1,xch2,xch3
      real(kind=8) :: vcut,vcut1,vcut2,vcut3
      real(kind=8) :: vcut12,vcut21,vcut13
      real(kind=8) :: dcut12,dcut21,dcut13
      real(kind=8) :: vcut31,vcut23,vcut32
      real(kind=8) :: dcut31,dcut23,dcut32
      real(kind=8) :: vc1,vc2,vc3
      real(kind=8) :: dc1,dc2,dc3
      real(kind=8) :: vlim1,vlim2,vlim3,vlrnew 
      real(kind=8) :: dvlrnewrg,dvlrnewcos   
      real(kind=8) :: vlim11,vlim21,vlim31
      real(kind=8) :: dvlrnewgr1,dvlrnewgr2,dvlrnewgr3
      real(kind=8) :: dvlrnewp2,dvlrnewp4
      real(kind=8) :: p2,p4,x
      real(kind=8) :: dp2,dp4
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3)/8.d0 ! Legendre polynomial P4
!      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legendre polynomial P6       
      dp2(x)=3.0d0*x ! Legendre polynomial P2
      dp4(x)=(140.d0*x*x*x-60.d0*x)/8.d0 ! Legendre polynomial P4
!      dp6(x)=(1386.d0*x*x*x*x*x-1260.d0*x*x*x+210.d0*x)/16.d0 ! Legendre polynomial P6       

      r1sq=r1*r1
      r2sq=r2*r2
      r3sq=r3*r3
!     Long range three body terms:
!     Jacobi coordinates in the three DIM wavefunctions
!     h11 term 
      RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*r1sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r2sq+0.50d0*r3sq-0.25d0*(r1-delta2)**2
      endif
      Rgsq=abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r1*Rg
      Rg1=Rg
!    if(Rg.lt.delta) write(6,*) Rg
      Rg11 = (0.5d0/Rg)*r3
      if(RgRg.lt.0.d0) Rg11 = -Rg11
      if(den.lt.delta) then
        xcos1=0.0d0
        xcos11=0.d0
      else
        xcos1=r2sq-r3sq
        xcos1=xcos1/den
        xcos11 = (-2.d0*r3 - xcos1*2.d0*r1*Rg11)/den
     endif
  
     
!     h22 term 
      RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*r2sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r3sq-0.25d0*(r2-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r2*Rg
      Rg2=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg21 = (0.5d0/Rg)*r3
      if(RgRg.lt.0.d0) Rg21 = -Rg21

      if(den.lt.delta) then
        xcos2=0.0d0
        xcos21=0.d0
      else
        xcos2=r1sq-r3sq
        xcos2=xcos2/den
        xcos21 = (-2.d0*r3 - xcos2*2.d0*r2*Rg21)/den
      endif
!     h33 term 
      RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*r3sq
      if(RgRg.le.delta2) then
         RgRg = 0.50d0*r1sq+0.50d0*r2sq-0.25d0*(r3-delta2)**2
      endif
      Rgsq = abs(RgRg)
      Rg=sqrt(Rgsq)
      den=2.d0*r3*Rg
      Rg3=Rg
!      if(Rg.lt.delta) write(6,*) Rg
      Rg31 = (0.5d0/Rg)*(-0.5d0*r3)
      if(RgRg.lt.0.d0) Rg31 = -Rg31

      if(den.lt.delta) then
        xcos3=0.0d0
        xcos31=0.d0
      else
        xcos3=r1sq-r2sq
        xcos3=xcos3/den
        xcos31 = -xcos3/den*2.d0*(Rg3 + r3*Rg31)
      endif
!!    Long range H2 -- H+ terms
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vee=1.d0
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(ve1*gr1+ve2*gr1**2)/(Rgg**5) +&
     &       (ve3*gr1+ve4*gr1**2)*p2(xcos1)/(Rgg**5) +&
     &       (ve5*gr1+ve6*gr1**2)*p4(xcos1)/(Rgg**5)
      vlong1=h2hmlong(r1,Rgg,xcos1)+vlrnew
     
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1= 0.0 !dgr1/dr3=0
       dvlrnewp2=(ve3*gr1+ve4*gr1**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr1+ve6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11

     !Der of vlong1  
     vlong11=dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1 &
          &  + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11&
          &  + dvlrnewrg + dvlrnewgr1 + dvlrnewcos
!      vlong11=dh2hmlongRgg(r1,Rgg,xcos1)*Rgg1 &
!           &  + dh2hmlongxcos(r1,Rgg,xcos1)*xcos11

      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21

      vee=1.d0
      gr2=r2*exp(-vee*r2)
      gr21=gr2*(-vee+(1/r2))
      vlrnew=(ve1*gr2+ve2*gr2**2)/(Rgg**5) +&
     &       (ve3*gr2+ve4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (ve5*gr2+ve6*gr2**2)*p4(xcos2)/(Rgg**5)
      vlong2=h2hmlong(r2,Rgg,xcos2)+vlrnew
!      vlong2=h2hmlong(r2,Rgg,xcos2)
      ! Der new term
     
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=0 !dgr2/dr3=0
       dvlrnewp2=(ve3*gr2+ve4*gr2**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr2+ve6*gr2**2)/(Rgg**5)
       dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21
       
     !Der vlong2
     vlong21=dh2hmlongr(r2,Rgg,xcos2)&
    &   + dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1 &
    &   + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21 &
    &   + dvlrnewrg+dvlrnewgr2+dvlrnewcos

!      vlong21=dh2hmlongRgg(r2,Rgg,xcos2)*Rgg1 &
!           &   + dh2hmlongxcos(r2,Rgg,xcos2)*xcos21

      Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vee=1.d0
      gr3=r3*exp(-vee*r3)
      gr31=gr3*(-vee+(1/r3))
      vlrnew=(ve1*gr3+ve2*gr3**2)/(Rgg**5) +&
     &       (ve3*gr3+ve4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (ve5*gr3+ve6*gr3**2)*p4(xcos3)/(Rgg**5)
     vlong3=h2hmlong(r3,Rgg,xcos3)+vlrnew
!      vlong3=h2hmlong(r3,Rgg,xcos3)
      ! Der new term
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3=vlrnew*gr31/gr3
       dvlrnewp2=(ve3*gr2+ve4*gr2**2)/(Rgg**5)
       dvlrnewp4=(ve5*gr2+ve6*gr2**2)/(Rgg**5)
       dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31
     
     !Der vlong3
     vlong31= dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1 &
          &    + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31&
          &    + dvlrnewrg+dvlrnewgr3+dvlrnewcos

!      vlong31=dh2hmlongr(r3,Rgg,xcos3) &
!     &   + dh2hmlongRgg(r3,Rgg,xcos3)*Rgg1 &
!     &   + dh2hmlongxcos(r3,Rgg,xcos3)*xcos31

      r1p=r1
      r2p=r2
      r3p=r3
      if(r1p.ge.18.d0) r1p=18.d0
      if(r2p.ge.18.d0) r2p=18.d0
      if(r3p.ge.18.d0) r3p=18.d0

      vcut12=exp((-(vex*r1p)**nex+(vex*r2p)**nex)/vex)
      vcut21=exp((+(vex*r1p)**nex-(vex*r2p)**nex)/vex)
      vcut13=exp((-(vex*r1p)**nex+(vex*r3p)**nex)/vex)
      dcut13=nex*(vex*r3p)**(nex-1)*vcut13
      vcut31=exp((+(vex*r1p)**nex-(vex*r3p)**nex)/vex)
      dcut31=-nex*(vex*r3p)**(nex-1)*vcut31
      vcut23=exp((-(vex*r2p)**nex+(vex*r3p)**nex)/vex)
      dcut23=nex*(vex*r3p)**(nex-1)*vcut23
      vcut32=exp((+(vex*r2p)**nex-(vex*r3p)**nex)/vex)
      dcut32=-nex*(vex*r3p)**(nex-1)*vcut32
      vc1=1.d0/(1.d0+vcut21+vcut31)
      vc2=1.d0/(vcut12+1.d0+vcut32)
      vc3=1.d0/(vcut13+vcut23+1.d0)
      dc1=(-vc1**2)*(dcut31)
      dc2=(-vc2**2)*(dcut32)
      dc3=(-vc3**2)*(dcut13+dcut23)
      vlong11=vlong11*vc1+vlong1*dc1
      vlong21=vlong21*vc2+vlong2*dc2
      vlong31=vlong31*vc3+vlong3*dc3

!        write(8,*) vlong11,vlong21,vlong31
!C    Long range H2+ -- H terms
!     a1=4.5d0
!     a2=15.d0
!      if(Rg1.ge.Rg2.and.Rg1.ge.Rg3) then
      Rgg=Rg1+RLIM*exp(-(Rg1-1.4d0))
      Rgg1 = Rg11 - (Rgg-Rg1)*Rg11
      vlim1=-a1/Rgg**4-a2/Rgg**6
      gr1=r1*exp(-vee*r1)
      gr11=gr1*(-vee+(1/r1))
      vlrnew=(vf1*gr1+vf2*gr1**2)/(Rgg**5) +&
     &       (vf3*gr1+vf4*gr1**2)*p2(xcos1)/(Rgg**5) +&
     &       (vf5*gr1+vf6*gr1**2)*p4 (xcos1)/(Rgg**5)  
      vlim1=vlim1+vlrnew
     
       !!Der vlim1
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr1=0.0 !dgr1/dr3=0
       dvlrnewp2=(vf3*gr1+vf4*gr1**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr1+vf6*gr1**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos1)*xcos11+dvlrnewp4*dp4(xcos1)*xcos11  
      vlim11 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr1 + dvlrnewcos
      
!      elseif(Rg2.ge.Rg1.and.Rg2.ge.Rg3) then
      Rgg=Rg2+RLIM*exp(-(Rg2-1.4d0))
      Rgg1 = Rg21 - (Rgg-Rg2)*Rg21
      vlim2=-a1/Rgg**4-a2/Rgg**6
      gr2=r2*exp(-vee*r2)
      gr21=gr2*(-vee+(1/r2))
      vlrnew=(vf1*gr2+vf2*gr2**2)/(Rgg**5) +&
     &       (vf3*gr2+vf4*gr2**2)*p2(xcos2)/(Rgg**5) +&
     &       (vf5*gr2+vf6*gr2**2)*p4 (xcos2)/(Rgg**5)  
     vlim2=vlim2+vlrnew
     
     !!Der vlim2
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr2=0.0 !dgr2/dr3=0
       dvlrnewp2=(vf3*gr2+vf4*gr2**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr2+vf6*gr2**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos2)*xcos21+dvlrnewp4*dp4(xcos2)*xcos21       
      vlim21 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr2 + dvlrnewcos
      
!      elseif(Rg3.ge.Rg1.and.Rg3.ge.Rg2) then
      Rgg=Rg3+RLIM*exp(-(Rg3-1.4d0))
      Rgg1 = Rg31 - (Rgg-Rg3)*Rg31
      vlim3=-a1/Rgg**4-a2/Rgg**6
      gr3=r3*exp(-vee*r3)
      gr31=gr3*(-vee+(1/r3))
      vlrnew=(vf1*gr3+vf2*gr3**2)/(Rgg**5) +&
     &       (vf3*gr3+vf4*gr3**2)*p2(xcos3)/(Rgg**5) +&
     &       (vf5*gr3+vf6*gr3**2)*p4(xcos3)/(Rgg**5)  
      vlim3=vlim3+vlrnew
 !!Der vlim3
      dvlrnewrg=-5*vlrnew*Rgg1/Rgg
      dvlrnewgr3=vlrnew*gr31/gr3
       dvlrnewp2=(vf3*gr3+vf4*gr3**2)/(Rgg**5)
       dvlrnewp4=(vf5*gr3+vf6*gr3**2)/(Rgg**5)
      dvlrnewcos=dvlrnewp2*dp2(xcos3)*xcos31+dvlrnewp4*dp4(xcos3)*xcos31         
      vlim31 = (4.d0*a1/Rgg**5 +6.d0*a2/Rgg**7)*Rgg1+&
     & dvlrnewrg +dvlrnewgr3 + dvlrnewcos

      vlim11=vlim11*vc1+vlim1*dc1
      vlim21=vlim21*vc2+vlim2*dc2
      vlim31=vlim31*vc3+vlim3*dc3
      
      if(ndim.gt.3)print*,"Warning with size of vlong? and vlim?"
      vlong(1)=vlong11 - vlim11
      vlong(2)=vlong21 - vlim21
      vlong(3)=vlong31 - vlim31

      return
    end subroutine dHmatlongr3
  
end module dimmatrix
