!********************************************
!     **************  elargom  **************
!********************************************
!  Comportamiento a largas distancias del H2
      real(kind=8) function elargo(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x3,x6,x8,x10,x11
      real(kind=8) :: ef,eg,eh,ei,ej,ej1

      shift = 10.d0*exp(-(y-1.4d0))
      x=y+shift
      x2=x*x
      x3=x2*x
      x6=x3*x3
      x8=x6*x2
      x10=x8*x2
      x11=x10*x
      ef=-6.499027d0*(1.d0+0.002723d0)/x6
      eg=-124.4d0*(1.d0+0.0038d0)/x8
      eh=-(1135.d0+2150.d0)*(1.d0+0.0049d0)/x10
      ei=-3986.d0*(1.d0+0.0054d0)/x11
      ej=-0.818d0*x**2.5d0*exp(-2.d0*x)
      ej1= (2.5d0/x - 2.d0)*ej
      elargo=ef+eg+eh+ei+ej
      return
      end function elargo

!********************************************
!     *******derivative delargom  ***********
!********************************************
      real(kind=8) function delargo(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x3,x6,x8,x10,x11
      real(kind=8) :: ef,eg,eh,ei,ej,ej1

      shift = 10.d0*exp(-(y-1.4d0))
      x=y+shift
      x2=x*x
      x3=x2*x
      x6=x3*x3
      x8=x6*x2
      x10=x8*x2
      x11=x10*x
      ef=-6.499027d0*(1.d0+0.002723d0)/x6
      eg=-124.4d0*(1.d0+0.0038d0)/x8
      eh=-(1135.d0+2150.d0)*(1.d0+0.0049d0)/x10
      ei=-3986.d0*(1.d0+0.0054d0)/x11
      ej=-0.818d0*x**2.5d0*exp(-2.d0*x)
      ej1= (2.5d0/x - 2.d0)*ej
!     elargo=ef+eg+eh+ei+ej
      delargo = ((-6.d0*ef -8.d0*eg -10.d0*eh -11.d0*ei)/x +ej1)*(1.d0-shift)
      return
      end function delargo

!********************************************
!     ************** elargomex **************
!********************************************
!     Long range H2+ terms
      real(kind=8) function elargomex(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x4,x6
!     New smoothing function
      shift= 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2
      elargomex = -(2.25d0/x4 + 7.5d0/x6 + 0.735758882342885d0*x*exp(-x))
      return
      end function elargomex

!********************************************
!     ********* derivative elargomex *********
!********************************************
      real(kind=8) function delargomex(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x4,x6
!     New smoothing function
      shift= 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2
!      elargomex=-(2.25d0/x4 + 7.5d0/x6 +
!     ,    0.735758882342885d0*x*exp(-x))
      delargomex=( (9.d0 + 45d0/x2)/(x4*x) + 0.735758882342885d0*exp(-x)*(x-1.d0) ) * (1.d0-shift)
      return
      end function delargomex     

!********************************************
!     **************  elargom  **************
!********************************************
!     Long range H2+ terms
      real(kind=8) function elargom(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x4,x6

      shift = 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2   
!     New smoothing function
      elargom=-(2.25d0/x4 + 7.5d0/x6)
      return
      end function elargom

!********************************************
!     ********  derivative elargom  *********
!********************************************
      
      real(kind=8) function delargom(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift, x,x2,x4,x6
  
      shift = 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2   
!     New smoothing function
!      elargom=-(2.25d0/x4 + 7.5d0/x6)
      delargom = (9.d0 + 45d0/x2)/(x4*x) * (1.d0-shift)
      return
      end function delargom
      
!********************************************
!     ************  elargomex2  *************
!********************************************
!     Long range H2+ terms      
      real(kind=8) function elargomex2(y)
      implicit none
      real(kind=8), intent(in) ::y
      real(kind=8) :: shift,x,x2,x4,x6

      shift = 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2
      elargomex2=-(2.25d0/x4 + 7.5d0/x6 - 0.734341d0*x*exp(-x))

      return
      end function elargomex2


!********************************************
!     ********derivative elargomex2  ********
!********************************************
      
      real(kind=8) function delargomex2(y)
      implicit none
      real(kind=8), intent(in) :: y
      real(kind=8) :: shift,x,x2,x4,x6
!     New smoothing function
      shift = 10.d0*exp(-(y-2.0d0))
      x=y+shift
      x2=x*x
      x4=x2*x2
      x6=x4*x2
!      elargomex2=-(2.25d0/x4 + 7.5d0/x6 -
!     ,    0.734341d0*x*exp(-x))
      delargomex2 = ( (9.d0 + 45d0/x2)/(x4*x) + 0.734341d0*exp(-x)*(1.d0-x) )*(1.d0-shift)

      return
      end function delargomex2
      
      
!***********************************************************************
!                                                                      *
!     H2 -- H Long range terms                                         *
!                                                                      *
!     aV6Z basis set                                                   *
!                                                                      *
!************************************************************************
      real(kind=8) function h2hmlong(rpeq,Rgran,xcos)
      implicit none
      real(kind=8), parameter :: ve1= -6.147112098805865934989295792d0
      real(kind=8), parameter :: ve2=  3.442679407611818105773697193d0
      real(kind=8), parameter :: ve3=  0.177491647435106509947195401d0
      real(kind=8), parameter :: ve4=  0.201649387273910056803411474d0
      real(kind=8), parameter :: ve5= 46.642636021164385763992587776d0
      real(kind=8), parameter :: ve6=-18.914420188856872968482579063d0
      real(kind=8), parameter :: ve7=  0.370333872009991195305781521d0
      real(kind=8), parameter :: ve8= -1.023918775649497442214591755d0
      real(kind=8), intent(in) :: rpeq,Rgran,xcos
      real(kind=8) :: Rgran3,Rgran4,Rgran5,Rgran6
      real(kind=8) :: h2quad,pol2,vqz,axx,azz
      real(kind=8) :: a0aV6Z,a2aV6Z,vpol
      real(kind=8) :: vlrnew
      real(kind=8) :: p2,p4,p6,x
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3.d0)/8.d0 ! Legendre polynomial P4
      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legendre polynomial P6       

      call quadz(rpeq,h2quad)
      pol2=1.5d0*xcos*xcos-0.5d0
!     aV6Z quadrupole moment
      vqz=h2quad*pol2/rgran**3

!     aV6Z polarizabilities
      call polx(rpeq,axx) !! aV6Z
      call polz(rpeq,azz) !! aV6Z
      a0aV6Z=(azz+2.d0*axx)/3.d0
      a0aV6Z=a0aV6Z/2.d0
      a2aV6Z=(azz-axx)*2.d0/3.d0
      a2aV6Z=a2aV6Z/2.d0
      rgran3=rgran*rgran*rgran
      rgran4=rgran3*rgran
      Rgran5=Rgran4*Rgran
      Rgran6=Rgran5*Rgran
      vpol=-(a0aV6Z+a2aV6Z*pol2)/Rgran4
      vlrnew=(ve1 + ve2*p2(xcos) &
     &     +  ve3*p4(xcos) + ve4*p6(xcos))/(Rgran5)
      vlrnew=vlrnew + (ve5 + ve6*p2(xcos) &
     &     +  ve7*p4(xcos) + ve8*p6(xcos))/(Rgran6)
      h2hmlong=vqz+vpol+vlrnew
      return
      end function h2hmlong
!**********************************
! ****** Derivatives h2hmlong *****       
!**********************************
!**********************************
! Derivative dh2hmlongRgg
!**********************************
      real(kind=8) function dh2hmlongRgg(rpeq,Rgran,xcos)
      implicit none
      real(kind=8), parameter :: ve1= -6.147112098805865934989295792d0
      real(kind=8), parameter :: ve2=  3.442679407611818105773697193d0
      real(kind=8), parameter :: ve3=  0.177491647435106509947195401d0
      real(kind=8), parameter :: ve4=  0.201649387273910056803411474d0
      real(kind=8), parameter :: ve5= 46.642636021164385763992587776d0
      real(kind=8), parameter :: ve6=-18.914420188856872968482579063d0
      real(kind=8), parameter :: ve7=  0.370333872009991195305781521d0
      real(kind=8), parameter :: ve8= -1.023918775649497442214591755d0
      real(kind=8), intent(in) :: rpeq,Rgran,xcos
      real(kind=8) :: Rgran5,Rgran6,Rgran7
      real(kind=8) :: h2quad,pol2,rgran3,rgran4,axx,azz
      real(kind=8) :: a0aV6Z,a2aV6Z,vpol1,vqz1
      real(kind=8) :: vlrnew,dvlrnew
      real(kind=8) :: p2,p4,p6,x
      p2(x)=1.5d0*x*x-0.5d0 ! Legendre polynomial P2
      p4(x)=(35.d0*x*x*x*x-30.d0*x*x+3.d0)/8.d0 ! Legendre polynomial P4
      p6(x)=(231.d0*x*x*x*x*x*x-315.d0*x*x*x*x+105.d0*x*x-5.d0)/16.d0 ! Legendre polynomial P6       

      call quadz(rpeq,h2quad)
      pol2=1.5d0*xcos*xcos-0.5d0
!     aV6Z quadrupole moment
      rgran3=rgran*rgran*rgran
      rgran4=rgran3*rgran
      Rgran5=Rgran4*Rgran
      Rgran6=Rgran5*Rgran
      Rgran7=Rgran6*Rgran
      vqz1=-3.d0*h2quad*pol2/rgran4

!     aV6Z polarizabilities
      call polx(rpeq,axx) !! aV6Z
      call polz(rpeq,azz) !! aV6Z
      a0aV6Z=(azz*0.5d0+axx)
      a2aV6Z=(azz-axx)
      vpol1=4.d0*(a0aV6Z+a2aV6Z*pol2)/(3.d0*Rgran5)
      dvlrnew=-5.d0*(ve1 + ve2*p2(xcos) &
     &     +  ve3*p4(xcos) + ve4*p6(xcos))/(Rgran6)
      dvlrnew=dvlrnew-6.d0*(ve5 + ve6*p2(xcos) &
     &     +  ve7*p4(xcos) + ve8*p6(xcos))/(Rgran7)
      dh2hmlongRgg = vqz1+vpol1+dvlrnew   
      return
      end function dh2hmlongRgg
!**********************************
! Derivative dh2hmlongxcos
!**********************************
      real(kind=8) function dh2hmlongxcos(rpeq,Rgran,xcos)
      implicit none
      real(kind=8), parameter :: ve1= -6.147112098805865934989295792d0
      real(kind=8), parameter :: ve2=  3.442679407611818105773697193d0
      real(kind=8), parameter :: ve3=  0.177491647435106509947195401d0
      real(kind=8), parameter :: ve4=  0.201649387273910056803411474d0
      real(kind=8), parameter :: ve5= 46.642636021164385763992587776d0
      real(kind=8), parameter :: ve6=-18.914420188856872968482579063d0
      real(kind=8), parameter :: ve7=  0.370333872009991195305781521d0
      real(kind=8), parameter :: ve8= -1.023918775649497442214591755d0
      real(kind=8), intent(in) :: rpeq,Rgran,xcos
      real(kind=8) :: h2quad, rgran3,rgran4,vqz1,axx,azz
      real(kind=8) :: Rgran5,Rgran6
      real(kind=8) :: a2aV6Z,vpol1
      real(kind=8) :: dvlrnew
      real(kind=8) :: dp2,dp4,dp6,x
      dp2(x)=3.0d0*x ! Legendre polynomial P2 derivative
      dp4(x)=(140.d0*x*x*x-60.d0*x)/8.d0 ! Legendre polynomial P4 derivative
      dp6(x)=(1386.d0*x*x*x*x*x-1260.d0*x*x*x+210.d0*x)/16.d0 ! Legendre polynomial P6 derivative

      call quadz(rpeq,h2quad)
!c      pol2=1.5d0*xcos*xcos-0.5d0
!     aV6Z quadrupole moment
      rgran3=rgran*rgran*rgran
      rgran4=rgran3*rgran
      Rgran5=Rgran4*Rgran
      Rgran6=Rgran5*Rgran
      vqz1=h2quad*3.d0*xcos/rgran3

!     aV6Z polarizabilities
      call polx(rpeq,axx) !! aV6Z
      call polz(rpeq,azz) !! aV6Z
!c      a0aV6Z=(azz*0.5d0+axx)
      a2aV6Z=(azz-axx)
      vpol1=-(a2aV6Z*3.d0*xcos)/(3.d0*Rgran4)
      dvlrnew=(ve2*dp2(xcos) &
     &     +  ve3*dp4(xcos) + ve4*dp6(xcos))/(Rgran5)
      dvlrnew=dvlrnew + (ve6*dp2(xcos) &
     &     +  ve7*dp4(xcos) + ve8*dp6(xcos))/(Rgran6)
      dh2hmlongxcos = vqz1+vpol1+dvlrnew
      return
      end function dh2hmlongxcos
      
!**********************************
! Derivative dh2hmlongr
!**********************************      
      real(kind=8) function dh2hmlongr(rpeq,Rgran,xcos)
      implicit none
      real(kind=8), intent(in) :: rpeq,rgran,xcos
      real(kind=8) :: h2quad1,rgran3,rgran4,vqz1,pol2
      real(kind=8) :: axx1,azz1,a0aV6Z1,a2aV6Z1,vpol1

      call dquadz(rpeq,h2quad1)
      pol2=1.5d0*xcos*xcos-0.5d0
!     aV6Z quadrupole moment
      rgran3=rgran*rgran*rgran
      rgran4=rgran3*rgran
      vqz1=h2quad1*pol2/rgran3

!     aV6Z polarizabilities
      call dpolx(rpeq,axx1) !! aV6Z
      call dpolz(rpeq,azz1) !! aV6Z
      a0aV6Z1=(azz1*0.5d0+axx1)
      a2aV6Z1=(azz1-axx1)
      vpol1=-(a0aV6Z1+a2aV6Z1*pol2)/(3.d0*Rgran4)
      dh2hmlongr=vqz1+vpol1
      return
      end

!***********************************
!      aV6Z quadrupole fits
!***********************************
!*********************************
!     quadz
!*********************************
!    
      subroutine quadz(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari
      integer :: i

      cf( 1)=0.8166648734890371D-04
      cf( 2)=-.1881855960082434D+01
      cf( 3)=0.2421277875344904D+00
      cf( 4)=0.6085863990932506D+02
      cf( 5)=-.2757874922103535D+03
      cf( 6)=0.1512576449669221D+04
      cf( 7)=-.1090442521871086D+05
      cf( 8)=0.1905266714338982D+05
      cf( 9)=0.1730115053828064D+06
      cf(10)=-.1000012086016814D+07
      cf(11)=0.1762147199545549D+07
      cf(12)=0.9342476802465859D+06
      cf(13)=-.8105382035645692D+07
      cf(14)=0.1151121162307790D+08
      cf(15)=-.5602134540904779D+07
      vex(1)=0.1340130881463356D+01
      vex(2)=0.8322962713014708D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=cf(1)+exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
      do i=3,15
         expo=expo*vari
         y=y+cf(i)*expo
      enddo
      return
      end subroutine quadz
      
!*********************************
!*******   Derivative  quadz *****
!*********************************
      subroutine dquadz(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari,vari1
      integer :: i
      
      cf( 1)=0.8166648734890371D-04
      cf( 2)=-.1881855960082434D+01
      cf( 3)=0.2421277875344904D+00
      cf( 4)=0.6085863990932506D+02
      cf( 5)=-.2757874922103535D+03
      cf( 6)=0.1512576449669221D+04
      cf( 7)=-.1090442521871086D+05
      cf( 8)=0.1905266714338982D+05
      cf( 9)=0.1730115053828064D+06
      cf(10)=-.1000012086016814D+07
      cf(11)=0.1762147199545549D+07
      cf(12)=0.9342476802465859D+06
      cf(13)=-.8105382035645692D+07
      cf(14)=0.1151121162307790D+08
      cf(15)=-.5602134540904779D+07
      vex(1)=0.1340130881463356D+01
      vex(2)=0.8322962713014708D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=-vex(1)*exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
      vari1 = (1-vex(2)*x)*exp(-vex(2)*x)
      do i=3,15
         y=y+cf(i)*(i-2)*expo*vari1
        expo=expo*vari
      enddo
      return
      end subroutine dquadz
      
!***********************************
!      aV6Z Polarizabilities  fits
!***********************************
!*********************************
!     Polx
!*********************************
      subroutine polx(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari
      integer :: i

      cf( 1)=0.8974583249592978D+01
      cf( 2)=-.1290835863481878D+02
      cf( 3)=-.5379421065843753D+01
      cf( 4)=0.1765706276501767D+03
      cf( 5)=-.3385803556921954D+04
      cf( 6)=0.4493699029122313D+05
      cf( 7)=-.3652369817756390D+06
      cf( 8)=0.1852753697133512D+07
      cf( 9)=-.5809312606038393D+07
      cf(10)=0.9721353024158247D+07
      cf(11)=-.7092806937216849D+06
      cf(12)=-.3327729880967365D+08
      cf(13)=0.6983684025829618D+08
      cf(14)=-.6381343977493817D+08
      cf(15)=0.2300922761580030D+08
      vex(1)=0.1187879729111910D+01
      vex(2)=0.7554684825669591D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=cf(1)+exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
      do i=3,15
         expo=expo*vari
         y=y+cf(i)*expo
      enddo      
      return
      end subroutine polx
      
!*********************************
! Derivative Polx
!*********************************
      subroutine dpolx(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari,vari1
      integer :: i

      cf( 1)=0.8974583249592978D+01
      cf( 2)=-.1290835863481878D+02
      cf( 3)=-.5379421065843753D+01
      cf( 4)=0.1765706276501767D+03
      cf( 5)=-.3385803556921954D+04
      cf( 6)=0.4493699029122313D+05
      cf( 7)=-.3652369817756390D+06
      cf( 8)=0.1852753697133512D+07
      cf( 9)=-.5809312606038393D+07
      cf(10)=0.9721353024158247D+07
      cf(11)=-.7092806937216849D+06
      cf(12)=-.3327729880967365D+08
      cf(13)=0.6983684025829618D+08
      cf(14)=-.6381343977493817D+08
      cf(15)=0.2300922761580030D+08
      vex(1)=0.1187879729111910D+01
      vex(2)=0.7554684825669591D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=-vex(1)*exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
      vari1 = (1-vex(2)*x)*exp(-vex(2)*x)
      do i=3,15
         y=y+cf(i)*(i-2)*expo*vari1
        expo=expo*vari
      enddo
      return
      end subroutine dpolx


!*********************************
!     Polz
!*********************************

      subroutine polz(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari
      integer :: i
 
      cf( 1)=0.9005313464224852D+01
      cf( 2)=-.4087039493711530D+02
      cf( 3)=0.1169970996784607D+02
      cf( 4)=-.2570966837001311D+03
      cf( 5)=0.1115822309638538D+05
      cf( 6)=-.1611895201468293D+06
      cf( 7)=0.1476263886597057D+07
      cf( 8)=-.8725387879754866D+07
      cf( 9)=0.3255107028148777D+08
      cf(10)=-.7292647566134660D+08
      cf(11)=0.7756856658321184D+08
      cf(12)=0.3625591185348335D+08
      cf(13)=-.2179510419880131D+09
      cf(14)=0.2531262189573988D+09
      cf(15)=-.1047041830161959D+09
      vex(1)=0.1826054733720348D+01
      vex(2)=0.7429159069146456D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=cf(1)+exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
      do i=3,15
         expo=expo*vari
         y=y+cf(i)*expo
      enddo
      return
      end  subroutine polz
      
!*********************************
! Derivative Polz
!*********************************
      subroutine dpolz(x,y)
      implicit none
      real(kind=8), intent(in) :: x
      real(kind=8), intent(out) :: y
      real(kind=8), dimension(:) :: cf(15),vex(2)
      real(kind=8) :: expo,vari,vari1
      integer :: i

      cf( 1)=0.9005313464224852D+01
      cf( 2)=-.4087039493711530D+02
      cf( 3)=0.1169970996784607D+02
      cf( 4)=-.2570966837001311D+03
      cf( 5)=0.1115822309638538D+05
      cf( 6)=-.1611895201468293D+06
      cf( 7)=0.1476263886597057D+07
      cf( 8)=-.8725387879754866D+07
      cf( 9)=0.3255107028148777D+08
      cf(10)=-.7292647566134660D+08
      cf(11)=0.7756856658321184D+08
      cf(12)=0.3625591185348335D+08
      cf(13)=-.2179510419880131D+09
      cf(14)=0.2531262189573988D+09
      cf(15)=-.1047041830161959D+09
      vex(1)=0.1826054733720348D+01
      vex(2)=0.7429159069146456D+00
      y=0.d0
!      do 1 i=  1, 15
!         y = y + cf(i)*funcion(vex,i,x)
!    1 continue
      y=-vex(1)*exp(-vex(1)*x)*cf(2)
      expo=1.d0
      vari=(x*exp(-vex(2)*x))
        vari1 = (1-vex(2)*x)*exp(-vex(2)*x)
      do i=3,15
         y=y+cf(i)*(i-2)*expo*vari1
        expo=expo*vari
      enddo
      return
      end subroutine dpolz
